"use client"
import React from 'react';
import './addFile.css'
import Modal from 'react-modal';
import Compressor from 'compressorjs'
const customStyles = {
    content: {
        border: '0',
        borderRadius: '4px',
        bottom: 'auto',
        minHeight: '25rem',
        maxHeight: '60em',
        left: '50%',
        padding: '2rem',
        position: 'fixed',
        right: 'auto',
        top: '50%',
        transform: 'translate(-50%,-50%)',
        minWidth: '20rem',
        width: window.innerWidth < 800
            ? '60%'
            : '60%',
        maxWidth: '30rem',
        borderRadius: '20px'
    },
    overlay: {
        position: 'fixed',
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        backgroundColor: 'rgba(0, 0, 0, 0.5)'
    }
};
const fileToDataUri = (file) => new Promise((resolve, reject) => {
    const reader = new FileReader();
    reader.onload = (event) => {
        resolve(event.target.result)
    };
    reader.readAsDataURL(file);
})
export default function Addfile(fileprop) {

    const [dataUri,
        setDataUri] = React.useState('')
    const [filename,
        setfilename] = React.useState('')
    const [fileType,
        setfileType] = React.useState('')
        const [fileSize,
            setfileSize] = React.useState('')
    const [shawImage,
        setshowImage] = React.useState(false)
    const onChange = (file) => {
        
        setshowImage(true)
        setfilename('')
        setfileType('')
        setDataUri('');
        setfilename(file.name)
        setfileType(file.type)
        setfileSize(file.size)
        if (!file) {

            return;
        }

        if (file.type == 'image/jpeg' || file.type == 'image/png') {
            var qt = 0.8;
            if (file.size / 1024 > 800) {
                qt = 0.6
            }
            new Compressor(file, {
                quality: qt, // 0.6 can also be used, but its not recommended to go below.
                success: (compressedResult) => {
                    fileToDataUri(compressedResult).then(dataUri => {
                       
                        setDataUri(dataUri)
                    })

                }
            });
           
            document
                .getElementById('picture')
                .value = ""
        } else {

            const reader = new FileReader();
            reader.onload = (event) => {
                // console.log(event.target.result)
                setDataUri(event.target.result)
            };
            reader.readAsDataURL(file);
            
            document
                .getElementById('picture')
                .value = ""
        }

        // } } else {  alert("Currently only image is supported") }
    }
    const cancel = e=>{
       // document.getElementById('picture').value = ""
        setshowImage(false)
        setfilename('')
        setfileType('')
        setDataUri('');
    }
    const submit = e =>{
        setshowImage(false)
       fileprop.submit(dataUri,filename,fileType,fileSize)
       setfilename('')
        setfileType('')
        setDataUri('');
    }
    return (
        <Modal
            ariaHideApp={false}
            isOpen={fileprop.addfilemodalopen}
            style={customStyles}
            contentLabel="Example Modal">
            <div className='modal-body '>

                <span className="material-icons closeModal" onClick={e => fileprop.addfilemodalclose(false)}>
                    cancel
                </span>
                <div>Upload File</div>
                {/* <span className="material-icons folder">
                    folder
                </span> */}

                <div className='form-group '>
                    {shawImage
                        ? <div className="showFilemodal text-center ">
                                {dataUri.length == 0
                                    ? <div className='imageBox flex justify-center items-center'><img src="/image/loading.gif" alt="avatar" className='w-11/12'/> </div>
                                    : fileType.startsWith("image")
                                        ?
                                        <div className='imageBox flex justify-center items-center'>
                                        <img src={dataUri} alt="file loading.." className='mt-20 w-6/12'/>
                                        </div>
                                        : fileType.startsWith("video")
                                            ?  <div className='imageBox mt-12 flex justify-center items-center'><span
                                                    className="material-icons"
                                                    style={{
                                                    "fontSize": "100px"
                                                }}>videocam</span> </div>
                                            : fileType.startsWith("application") 
                                                ? <div className='imageBox flex mt-12 justify-center items-center'>
                                                    {
                                                                        fileType
                                                                        .split('/')[1]
                                                                        .includes('.document')
                                                                        ? <img src='/image/icons8-microsoft-word.svg' className='w-5/12 mx-auto'/>
                                                                        : fileType
                                                                            .split('/')[1]
                                                                            .includes('.presentation')
                                                                            ? <img src='/image/icons8-microsoft-powerpoint.svg' className='w-5/12 mx-auto'/>
                                                                            : <div className='flex justify-center items-center'>
                                                                            <span className="material-icons description"  style={{
                                                    "fontSize": "100px"
                                                }}>picture_as_pdf</span>
                                                                        </div>}
</div>
                                                : fileType.startsWith("application") ? <div className='imageBox mt-12 flex justify-center items-center'><span
                                                className="material-icons"
                                                style={{
                                                "fontSize": "100px"
                                            }}>description</span> </div>: <div className='imageBox flex mt-12 justify-center items-center'><img src='/image/icons8-file-100.png' className='w-5/12 mx-auto'/></div>}

                                {dataUri.length !== 0
                                    ? <div>
                                            <p className='filenamep'>{filename}</p>
                                            <br></br>

                                            <div className="buttonModal">
                                                <button className="btn btn-default mr-20">
                                                    <span
                                                        className="material-icons"
                                                        onClick={cancel}
                                                        >
                                                        close
                                                    </span>

                                                </button>
                                                <button className="btn btn-default">
                                                    <span className="material-icons" onClick={submit}> 
                                                        upload
                                                    </span>

                                                </button>
                                            </div>
                                        </div>
                                    : <div></div>}
                            </div>
                        : <div>
                            <span className="material-icons mt-24 cloud_upload">
                                cloud_upload
                            </span>
                            <label className="uploadfiletocloud ">

                                <p>
                                    Choose file from your device
                                </p>

                                <input
                                    type="file"
                                    id="picture"
                                    multiple="multiple"
                                    onChange={(event) => onChange(event.target.files[0] || null)}
                                    encType="multipart/form-data"/>
                            </label>
                        </div>
}

                </div>
                {/* <div className='grid grid-cols-2 mt-10'>
                    <div>
                        <button className="font-extrabold  text-red-600" type='reset'>Cancel
                        </button>
                    </div>
                    <div>
                        <button className="font-extrabold text-blue-600" type='button'>Create
                        </button>
                    </div>
                </div> */}

            </div>

        </Modal>
    )
}
