"use client"
import Image from 'next/image'
import React from 'react'
import './style.css'
import {getUserInfo, createUser} from '@/app/util/db'
import Signout from '@/app/Provider/signout'
var userId = null
export default function Nav() {

    const [showNav,
        setshowNav] = React.useState(false)
    const [name,
        setName] = React.useState('')
    const [email,
        setemail] = React.useState('')
    const getuser = async e => {
        if (e) 
            await getUserInfo(e).then(data => {
              
                setName(data[0].USERNAME)
                setemail(data[0].EMAIL)
            })
    }
    React.useEffect(() => {
        userId = localStorage.getItem('my-drive-user')

        getuser(localStorage.getItem('my-drive-user'))
    }, [])
    const logout = async e =>{
        await Signout().then(() => {
           window.location.href="/"
       }).catch(err => console.log(err))
   }
    return (
        <div>
            <nav
                className="fixed top-0 z-50 w-full bg-white border-b border-gray-200 dark:bg-gray-800 dark:border-gray-700 animate__animated animate__fadeInDown">
                <div className="px-3 py-3 lg:px-5 lg:pl-3">
                    <div className="flex items-center justify-between">
                        <div className="flex items-center justify-start rtl:justify-end">

                            <a href="/" className="flex ms-2 md:me-24 ">
                                <img src="/image/driveIcon.png" className="h-8 me-3" alt="my drive Logo"/>
                                <span
                                    className="self-center text-xl font-semibold sm:text-2xl whitespace-nowrap dark:text-white">MY-DRIVE</span>
                            </a>
                        </div>
                        <div className="flex items-center ">
                            <div className="flex items-center ms-3">
                                {/* <button
                                    data-collapse-toggle="navbar-default"
                                    type="button"
                                    class="inline-flex items-center p-2 w-10 h-10 justify-center text-sm text-gray-500 rounded-lg md:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600"
                                    aria-controls="navbar-default"
                                    aria-expanded="false">
                                    <span class="sr-only">Open main menu</span>
                                    <svg
                                        class="w-5 h-5"
                                        aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg"
                                        fill="none"
                                        viewBox="0 0 17 14">
                                        <path
                                            stroke="currentColor"
                                            stroke-linecap="round"
                                            stroke-linejoin="round"
                                            stroke-width="2"
                                            d="M1 1h15M1 7h15M1 13h15"/>
                                    </svg>
                                </button> */}
                                <div class="hidden w-full md:block md:w-auto mr-12" id="navbar-default">
                                    <ul
                                        class="font-medium flex flex-col p-4 md:p-0 mt-4  md:flex-row md:space-x-8 rtl:space-x-reverse md:mt-0   ">
                                        {/*
                                        <li>
                                            <a
                                                href="#"
                                                class="block py-2 px-3 text-gray-900 rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:hover:text-blue-700 md:p-0 dark:text-white md:dark:hover:text-blue-500 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent">About</a>
                                        </li>
                                        <li>
                                            <a
                                                href="#"
                                                class="block py-2 px-3 text-gray-900 rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:hover:text-blue-700 md:p-0 dark:text-white md:dark:hover:text-blue-500 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent">Services</a>
                                        </li>
                                        <li>
                                            <a
                                                href="#"
                                                class="block py-2 px-3 text-gray-900 rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:hover:text-blue-700 md:p-0 dark:text-white md:dark:hover:text-blue-500 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent">Pricing</a>
                                        </li>
                                        <li>
                                            <a
                                                href="#"
                                                class="block py-2 px-3 text-gray-900 rounded hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:hover:text-blue-700 md:p-0 dark:text-white md:dark:hover:text-blue-500 dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent">Contact</a>
                                        </li> */}
                                    </ul>
                                </div>
                                <div onClick={e => setshowNav(!showNav)}>
                                    {userId
                                        ? <button
                                                type="button"
                                                className="flex mr-7 text-sm bg-gray-800 rounded-full focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600"
                                                aria-expanded="false"
                                                data-dropdown-toggle="dropdown-user">
                                                <span className="sr-only">Open user menu</span>
                                                {!showNav
                                                    ? <img
                                                            className="w-8 h-8 rounded-full"
                                                            src="/image/unnamed.png"
                                                            alt="user photo"/>
                                                    : <span class="material-icons text-white p-1">
                                                        cancel
                                                    </span>}

                                            </button>
                                        : <div></div>}

                                    <div
                                        style={{
                                        'display': showNav
                                            ? "block"
                                            : "none"
                                    }}
                                        className="z-50 sm:top-9 sm:right-10 lg:top-9 lg:right-10  top-12 right-4 absolute my-4 text-base list-none bg-white divide-y divide-gray-100 rounded shadow dark:bg-gray-700 dark:divide-gray-600"
                                        id="dropdown-user">
                                        <div className="px-4 py-3" role="none">

                                            <div>
                                                <p className="text-sm text-gray-900 dark:text-white" role="none">
                                                    {name}
                                                </p>
                                                <p
                                                    className="text-sm font-medium text-gray-900 truncate dark:text-gray-300"
                                                    role="none">
                                                    {email}
                                                </p>
                                            </div>

                                        </div>
                                        <ul className="py-1" role="none">
                                            <li>
                                                <a
                                                    href="/MyFiles"
                                                    className="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-gray-600 dark:hover:text-white"
                                                    role="menuitem">My Files</a>
                                            </li>

                                            <li>
                                                <a
                                                    onClick={e => logout()}
                                                    className="block px-4 py-2 text-sm cursor-pointer text-gray-700 hover:bg-gray-100 dark:text-gray-300 dark:hover:bg-gray-600 dark:hover:text-white"
                                                    role="menuitem">Logout</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </nav>
        </div>

    )
}