import {getAuth, signInWithEmailAndPassword, createUserWithEmailAndPassword} from "firebase/auth";

const auth = getAuth();

const userNamepassword = (e, email, password) => {
    return new Promise(async(resolve, reject) => {
        if (e == 1) {
            signInWithEmailAndPassword(auth, email, password).then((userCredential) => {
                // Signed in
                const user = userCredential.user;
                resolve(user)
            }).catch((error) => {
                const errorCode = error.code;
                const errorMessage = error.message;
                reject(errorCode)
            });
        } else {
            createUserWithEmailAndPassword(auth, email, password).then((userCredential) => {
                // Signed up
                const user = userCredential.user;
                resolve(user)
            }).catch((error) => {
                const errorCode = error.code;
                const errorMessage = error.message;
                reject(errorCode)
            });
        }

    })
}

export default userNamepassword