"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/@firebase";
exports.ids = ["vendor-chunks/@firebase"];
exports.modules = {

/***/ "(ssr)/./node_modules/@firebase/app/dist/esm/index.esm2017.js":
/*!**************************************************************!*\
  !*** ./node_modules/@firebase/app/dist/esm/index.esm2017.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FirebaseError: () => (/* reexport safe */ _firebase_util__WEBPACK_IMPORTED_MODULE_2__.FirebaseError),\n/* harmony export */   SDK_VERSION: () => (/* binding */ SDK_VERSION),\n/* harmony export */   _DEFAULT_ENTRY_NAME: () => (/* binding */ DEFAULT_ENTRY_NAME),\n/* harmony export */   _addComponent: () => (/* binding */ _addComponent),\n/* harmony export */   _addOrOverwriteComponent: () => (/* binding */ _addOrOverwriteComponent),\n/* harmony export */   _apps: () => (/* binding */ _apps),\n/* harmony export */   _clearComponents: () => (/* binding */ _clearComponents),\n/* harmony export */   _components: () => (/* binding */ _components),\n/* harmony export */   _getProvider: () => (/* binding */ _getProvider),\n/* harmony export */   _registerComponent: () => (/* binding */ _registerComponent),\n/* harmony export */   _removeServiceInstance: () => (/* binding */ _removeServiceInstance),\n/* harmony export */   deleteApp: () => (/* binding */ deleteApp),\n/* harmony export */   getApp: () => (/* binding */ getApp),\n/* harmony export */   getApps: () => (/* binding */ getApps),\n/* harmony export */   initializeApp: () => (/* binding */ initializeApp),\n/* harmony export */   onLog: () => (/* binding */ onLog),\n/* harmony export */   registerVersion: () => (/* binding */ registerVersion),\n/* harmony export */   setLogLevel: () => (/* binding */ setLogLevel)\n/* harmony export */ });\n/* harmony import */ var _firebase_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @firebase/component */ \"(ssr)/./node_modules/@firebase/component/dist/esm/index.esm2017.js\");\n/* harmony import */ var _firebase_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @firebase/logger */ \"(ssr)/./node_modules/@firebase/logger/dist/esm/index.esm2017.js\");\n/* harmony import */ var _firebase_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @firebase/util */ \"(ssr)/./node_modules/@firebase/util/dist/node-esm/index.node.esm.js\");\n/* harmony import */ var idb__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! idb */ \"(ssr)/./node_modules/idb/build/index.js\");\n\n\n\n\n\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass PlatformLoggerServiceImpl {\r\n    constructor(container) {\r\n        this.container = container;\r\n    }\r\n    // In initial implementation, this will be called by installations on\r\n    // auth token refresh, and installations will send this string.\r\n    getPlatformInfoString() {\r\n        const providers = this.container.getProviders();\r\n        // Loop through providers and get library/version pairs from any that are\r\n        // version components.\r\n        return providers\r\n            .map(provider => {\r\n            if (isVersionServiceProvider(provider)) {\r\n                const service = provider.getImmediate();\r\n                return `${service.library}/${service.version}`;\r\n            }\r\n            else {\r\n                return null;\r\n            }\r\n        })\r\n            .filter(logString => logString)\r\n            .join(' ');\r\n    }\r\n}\r\n/**\r\n *\r\n * @param provider check if this provider provides a VersionService\r\n *\r\n * NOTE: Using Provider<'app-version'> is a hack to indicate that the provider\r\n * provides VersionService. The provider is not necessarily a 'app-version'\r\n * provider.\r\n */\r\nfunction isVersionServiceProvider(provider) {\r\n    const component = provider.getComponent();\r\n    return (component === null || component === void 0 ? void 0 : component.type) === \"VERSION\" /* ComponentType.VERSION */;\r\n}\n\nconst name$o = \"@firebase/app\";\nconst version$1 = \"0.9.25\";\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst logger = new _firebase_logger__WEBPACK_IMPORTED_MODULE_1__.Logger('@firebase/app');\n\nconst name$n = \"@firebase/app-compat\";\n\nconst name$m = \"@firebase/analytics-compat\";\n\nconst name$l = \"@firebase/analytics\";\n\nconst name$k = \"@firebase/app-check-compat\";\n\nconst name$j = \"@firebase/app-check\";\n\nconst name$i = \"@firebase/auth\";\n\nconst name$h = \"@firebase/auth-compat\";\n\nconst name$g = \"@firebase/database\";\n\nconst name$f = \"@firebase/database-compat\";\n\nconst name$e = \"@firebase/functions\";\n\nconst name$d = \"@firebase/functions-compat\";\n\nconst name$c = \"@firebase/installations\";\n\nconst name$b = \"@firebase/installations-compat\";\n\nconst name$a = \"@firebase/messaging\";\n\nconst name$9 = \"@firebase/messaging-compat\";\n\nconst name$8 = \"@firebase/performance\";\n\nconst name$7 = \"@firebase/performance-compat\";\n\nconst name$6 = \"@firebase/remote-config\";\n\nconst name$5 = \"@firebase/remote-config-compat\";\n\nconst name$4 = \"@firebase/storage\";\n\nconst name$3 = \"@firebase/storage-compat\";\n\nconst name$2 = \"@firebase/firestore\";\n\nconst name$1 = \"@firebase/firestore-compat\";\n\nconst name = \"firebase\";\nconst version = \"10.7.1\";\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * The default app name\r\n *\r\n * @internal\r\n */\r\nconst DEFAULT_ENTRY_NAME = '[DEFAULT]';\r\nconst PLATFORM_LOG_STRING = {\r\n    [name$o]: 'fire-core',\r\n    [name$n]: 'fire-core-compat',\r\n    [name$l]: 'fire-analytics',\r\n    [name$m]: 'fire-analytics-compat',\r\n    [name$j]: 'fire-app-check',\r\n    [name$k]: 'fire-app-check-compat',\r\n    [name$i]: 'fire-auth',\r\n    [name$h]: 'fire-auth-compat',\r\n    [name$g]: 'fire-rtdb',\r\n    [name$f]: 'fire-rtdb-compat',\r\n    [name$e]: 'fire-fn',\r\n    [name$d]: 'fire-fn-compat',\r\n    [name$c]: 'fire-iid',\r\n    [name$b]: 'fire-iid-compat',\r\n    [name$a]: 'fire-fcm',\r\n    [name$9]: 'fire-fcm-compat',\r\n    [name$8]: 'fire-perf',\r\n    [name$7]: 'fire-perf-compat',\r\n    [name$6]: 'fire-rc',\r\n    [name$5]: 'fire-rc-compat',\r\n    [name$4]: 'fire-gcs',\r\n    [name$3]: 'fire-gcs-compat',\r\n    [name$2]: 'fire-fst',\r\n    [name$1]: 'fire-fst-compat',\r\n    'fire-js': 'fire-js',\r\n    [name]: 'fire-js-all'\r\n};\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * @internal\r\n */\r\nconst _apps = new Map();\r\n/**\r\n * Registered components.\r\n *\r\n * @internal\r\n */\r\n// eslint-disable-next-line @typescript-eslint/no-explicit-any\r\nconst _components = new Map();\r\n/**\r\n * @param component - the component being added to this app's container\r\n *\r\n * @internal\r\n */\r\nfunction _addComponent(app, component) {\r\n    try {\r\n        app.container.addComponent(component);\r\n    }\r\n    catch (e) {\r\n        logger.debug(`Component ${component.name} failed to register with FirebaseApp ${app.name}`, e);\r\n    }\r\n}\r\n/**\r\n *\r\n * @internal\r\n */\r\nfunction _addOrOverwriteComponent(app, component) {\r\n    app.container.addOrOverwriteComponent(component);\r\n}\r\n/**\r\n *\r\n * @param component - the component to register\r\n * @returns whether or not the component is registered successfully\r\n *\r\n * @internal\r\n */\r\nfunction _registerComponent(component) {\r\n    const componentName = component.name;\r\n    if (_components.has(componentName)) {\r\n        logger.debug(`There were multiple attempts to register component ${componentName}.`);\r\n        return false;\r\n    }\r\n    _components.set(componentName, component);\r\n    // add the component to existing app instances\r\n    for (const app of _apps.values()) {\r\n        _addComponent(app, component);\r\n    }\r\n    return true;\r\n}\r\n/**\r\n *\r\n * @param app - FirebaseApp instance\r\n * @param name - service name\r\n *\r\n * @returns the provider for the service with the matching name\r\n *\r\n * @internal\r\n */\r\nfunction _getProvider(app, name) {\r\n    const heartbeatController = app.container\r\n        .getProvider('heartbeat')\r\n        .getImmediate({ optional: true });\r\n    if (heartbeatController) {\r\n        void heartbeatController.triggerHeartbeat();\r\n    }\r\n    return app.container.getProvider(name);\r\n}\r\n/**\r\n *\r\n * @param app - FirebaseApp instance\r\n * @param name - service name\r\n * @param instanceIdentifier - service instance identifier in case the service supports multiple instances\r\n *\r\n * @internal\r\n */\r\nfunction _removeServiceInstance(app, name, instanceIdentifier = DEFAULT_ENTRY_NAME) {\r\n    _getProvider(app, name).clearInstance(instanceIdentifier);\r\n}\r\n/**\r\n * Test only\r\n *\r\n * @internal\r\n */\r\nfunction _clearComponents() {\r\n    _components.clear();\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst ERRORS = {\r\n    [\"no-app\" /* AppError.NO_APP */]: \"No Firebase App '{$appName}' has been created - \" +\r\n        'call initializeApp() first',\r\n    [\"bad-app-name\" /* AppError.BAD_APP_NAME */]: \"Illegal App name: '{$appName}\",\r\n    [\"duplicate-app\" /* AppError.DUPLICATE_APP */]: \"Firebase App named '{$appName}' already exists with different options or config\",\r\n    [\"app-deleted\" /* AppError.APP_DELETED */]: \"Firebase App named '{$appName}' already deleted\",\r\n    [\"no-options\" /* AppError.NO_OPTIONS */]: 'Need to provide options, when not being deployed to hosting via source.',\r\n    [\"invalid-app-argument\" /* AppError.INVALID_APP_ARGUMENT */]: 'firebase.{$appName}() takes either no argument or a ' +\r\n        'Firebase App instance.',\r\n    [\"invalid-log-argument\" /* AppError.INVALID_LOG_ARGUMENT */]: 'First argument to `onLog` must be null or a function.',\r\n    [\"idb-open\" /* AppError.IDB_OPEN */]: 'Error thrown when opening IndexedDB. Original error: {$originalErrorMessage}.',\r\n    [\"idb-get\" /* AppError.IDB_GET */]: 'Error thrown when reading from IndexedDB. Original error: {$originalErrorMessage}.',\r\n    [\"idb-set\" /* AppError.IDB_WRITE */]: 'Error thrown when writing to IndexedDB. Original error: {$originalErrorMessage}.',\r\n    [\"idb-delete\" /* AppError.IDB_DELETE */]: 'Error thrown when deleting from IndexedDB. Original error: {$originalErrorMessage}.'\r\n};\r\nconst ERROR_FACTORY = new _firebase_util__WEBPACK_IMPORTED_MODULE_2__.ErrorFactory('app', 'Firebase', ERRORS);\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass FirebaseAppImpl {\r\n    constructor(options, config, container) {\r\n        this._isDeleted = false;\r\n        this._options = Object.assign({}, options);\r\n        this._config = Object.assign({}, config);\r\n        this._name = config.name;\r\n        this._automaticDataCollectionEnabled =\r\n            config.automaticDataCollectionEnabled;\r\n        this._container = container;\r\n        this.container.addComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_0__.Component('app', () => this, \"PUBLIC\" /* ComponentType.PUBLIC */));\r\n    }\r\n    get automaticDataCollectionEnabled() {\r\n        this.checkDestroyed();\r\n        return this._automaticDataCollectionEnabled;\r\n    }\r\n    set automaticDataCollectionEnabled(val) {\r\n        this.checkDestroyed();\r\n        this._automaticDataCollectionEnabled = val;\r\n    }\r\n    get name() {\r\n        this.checkDestroyed();\r\n        return this._name;\r\n    }\r\n    get options() {\r\n        this.checkDestroyed();\r\n        return this._options;\r\n    }\r\n    get config() {\r\n        this.checkDestroyed();\r\n        return this._config;\r\n    }\r\n    get container() {\r\n        return this._container;\r\n    }\r\n    get isDeleted() {\r\n        return this._isDeleted;\r\n    }\r\n    set isDeleted(val) {\r\n        this._isDeleted = val;\r\n    }\r\n    /**\r\n     * This function will throw an Error if the App has already been deleted -\r\n     * use before performing API actions on the App.\r\n     */\r\n    checkDestroyed() {\r\n        if (this.isDeleted) {\r\n            throw ERROR_FACTORY.create(\"app-deleted\" /* AppError.APP_DELETED */, { appName: this._name });\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * The current SDK version.\r\n *\r\n * @public\r\n */\r\nconst SDK_VERSION = version;\r\nfunction initializeApp(_options, rawConfig = {}) {\r\n    let options = _options;\r\n    if (typeof rawConfig !== 'object') {\r\n        const name = rawConfig;\r\n        rawConfig = { name };\r\n    }\r\n    const config = Object.assign({ name: DEFAULT_ENTRY_NAME, automaticDataCollectionEnabled: false }, rawConfig);\r\n    const name = config.name;\r\n    if (typeof name !== 'string' || !name) {\r\n        throw ERROR_FACTORY.create(\"bad-app-name\" /* AppError.BAD_APP_NAME */, {\r\n            appName: String(name)\r\n        });\r\n    }\r\n    options || (options = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.getDefaultAppConfig)());\r\n    if (!options) {\r\n        throw ERROR_FACTORY.create(\"no-options\" /* AppError.NO_OPTIONS */);\r\n    }\r\n    const existingApp = _apps.get(name);\r\n    if (existingApp) {\r\n        // return the existing app if options and config deep equal the ones in the existing app.\r\n        if ((0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.deepEqual)(options, existingApp.options) &&\r\n            (0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.deepEqual)(config, existingApp.config)) {\r\n            return existingApp;\r\n        }\r\n        else {\r\n            throw ERROR_FACTORY.create(\"duplicate-app\" /* AppError.DUPLICATE_APP */, { appName: name });\r\n        }\r\n    }\r\n    const container = new _firebase_component__WEBPACK_IMPORTED_MODULE_0__.ComponentContainer(name);\r\n    for (const component of _components.values()) {\r\n        container.addComponent(component);\r\n    }\r\n    const newApp = new FirebaseAppImpl(options, config, container);\r\n    _apps.set(name, newApp);\r\n    return newApp;\r\n}\r\n/**\r\n * Retrieves a {@link @firebase/app#FirebaseApp} instance.\r\n *\r\n * When called with no arguments, the default app is returned. When an app name\r\n * is provided, the app corresponding to that name is returned.\r\n *\r\n * An exception is thrown if the app being retrieved has not yet been\r\n * initialized.\r\n *\r\n * @example\r\n * ```javascript\r\n * // Return the default app\r\n * const app = getApp();\r\n * ```\r\n *\r\n * @example\r\n * ```javascript\r\n * // Return a named app\r\n * const otherApp = getApp(\"otherApp\");\r\n * ```\r\n *\r\n * @param name - Optional name of the app to return. If no name is\r\n *   provided, the default is `\"[DEFAULT]\"`.\r\n *\r\n * @returns The app corresponding to the provided app name.\r\n *   If no app name is provided, the default app is returned.\r\n *\r\n * @public\r\n */\r\nfunction getApp(name = DEFAULT_ENTRY_NAME) {\r\n    const app = _apps.get(name);\r\n    if (!app && name === DEFAULT_ENTRY_NAME && (0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.getDefaultAppConfig)()) {\r\n        return initializeApp();\r\n    }\r\n    if (!app) {\r\n        throw ERROR_FACTORY.create(\"no-app\" /* AppError.NO_APP */, { appName: name });\r\n    }\r\n    return app;\r\n}\r\n/**\r\n * A (read-only) array of all initialized apps.\r\n * @public\r\n */\r\nfunction getApps() {\r\n    return Array.from(_apps.values());\r\n}\r\n/**\r\n * Renders this app unusable and frees the resources of all associated\r\n * services.\r\n *\r\n * @example\r\n * ```javascript\r\n * deleteApp(app)\r\n *   .then(function() {\r\n *     console.log(\"App deleted successfully\");\r\n *   })\r\n *   .catch(function(error) {\r\n *     console.log(\"Error deleting app:\", error);\r\n *   });\r\n * ```\r\n *\r\n * @public\r\n */\r\nasync function deleteApp(app) {\r\n    const name = app.name;\r\n    if (_apps.has(name)) {\r\n        _apps.delete(name);\r\n        await Promise.all(app.container\r\n            .getProviders()\r\n            .map(provider => provider.delete()));\r\n        app.isDeleted = true;\r\n    }\r\n}\r\n/**\r\n * Registers a library's name and version for platform logging purposes.\r\n * @param library - Name of 1p or 3p library (e.g. firestore, angularfire)\r\n * @param version - Current version of that library.\r\n * @param variant - Bundle variant, e.g., node, rn, etc.\r\n *\r\n * @public\r\n */\r\nfunction registerVersion(libraryKeyOrName, version, variant) {\r\n    var _a;\r\n    // TODO: We can use this check to whitelist strings when/if we set up\r\n    // a good whitelist system.\r\n    let library = (_a = PLATFORM_LOG_STRING[libraryKeyOrName]) !== null && _a !== void 0 ? _a : libraryKeyOrName;\r\n    if (variant) {\r\n        library += `-${variant}`;\r\n    }\r\n    const libraryMismatch = library.match(/\\s|\\//);\r\n    const versionMismatch = version.match(/\\s|\\//);\r\n    if (libraryMismatch || versionMismatch) {\r\n        const warning = [\r\n            `Unable to register library \"${library}\" with version \"${version}\":`\r\n        ];\r\n        if (libraryMismatch) {\r\n            warning.push(`library name \"${library}\" contains illegal characters (whitespace or \"/\")`);\r\n        }\r\n        if (libraryMismatch && versionMismatch) {\r\n            warning.push('and');\r\n        }\r\n        if (versionMismatch) {\r\n            warning.push(`version name \"${version}\" contains illegal characters (whitespace or \"/\")`);\r\n        }\r\n        logger.warn(warning.join(' '));\r\n        return;\r\n    }\r\n    _registerComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_0__.Component(`${library}-version`, () => ({ library, version }), \"VERSION\" /* ComponentType.VERSION */));\r\n}\r\n/**\r\n * Sets log handler for all Firebase SDKs.\r\n * @param logCallback - An optional custom log handler that executes user code whenever\r\n * the Firebase SDK makes a logging call.\r\n *\r\n * @public\r\n */\r\nfunction onLog(logCallback, options) {\r\n    if (logCallback !== null && typeof logCallback !== 'function') {\r\n        throw ERROR_FACTORY.create(\"invalid-log-argument\" /* AppError.INVALID_LOG_ARGUMENT */);\r\n    }\r\n    (0,_firebase_logger__WEBPACK_IMPORTED_MODULE_1__.setUserLogHandler)(logCallback, options);\r\n}\r\n/**\r\n * Sets log level for all Firebase SDKs.\r\n *\r\n * All of the log types above the current log level are captured (i.e. if\r\n * you set the log level to `info`, errors are logged, but `debug` and\r\n * `verbose` logs are not).\r\n *\r\n * @public\r\n */\r\nfunction setLogLevel(logLevel) {\r\n    (0,_firebase_logger__WEBPACK_IMPORTED_MODULE_1__.setLogLevel)(logLevel);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2021 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst DB_NAME = 'firebase-heartbeat-database';\r\nconst DB_VERSION = 1;\r\nconst STORE_NAME = 'firebase-heartbeat-store';\r\nlet dbPromise = null;\r\nfunction getDbPromise() {\r\n    if (!dbPromise) {\r\n        dbPromise = (0,idb__WEBPACK_IMPORTED_MODULE_3__.openDB)(DB_NAME, DB_VERSION, {\r\n            upgrade: (db, oldVersion) => {\r\n                // We don't use 'break' in this switch statement, the fall-through\r\n                // behavior is what we want, because if there are multiple versions between\r\n                // the old version and the current version, we want ALL the migrations\r\n                // that correspond to those versions to run, not only the last one.\r\n                // eslint-disable-next-line default-case\r\n                switch (oldVersion) {\r\n                    case 0:\r\n                        db.createObjectStore(STORE_NAME);\r\n                }\r\n            }\r\n        }).catch(e => {\r\n            throw ERROR_FACTORY.create(\"idb-open\" /* AppError.IDB_OPEN */, {\r\n                originalErrorMessage: e.message\r\n            });\r\n        });\r\n    }\r\n    return dbPromise;\r\n}\r\nasync function readHeartbeatsFromIndexedDB(app) {\r\n    try {\r\n        const db = await getDbPromise();\r\n        const result = await db\r\n            .transaction(STORE_NAME)\r\n            .objectStore(STORE_NAME)\r\n            .get(computeKey(app));\r\n        return result;\r\n    }\r\n    catch (e) {\r\n        if (e instanceof _firebase_util__WEBPACK_IMPORTED_MODULE_2__.FirebaseError) {\r\n            logger.warn(e.message);\r\n        }\r\n        else {\r\n            const idbGetError = ERROR_FACTORY.create(\"idb-get\" /* AppError.IDB_GET */, {\r\n                originalErrorMessage: e === null || e === void 0 ? void 0 : e.message\r\n            });\r\n            logger.warn(idbGetError.message);\r\n        }\r\n    }\r\n}\r\nasync function writeHeartbeatsToIndexedDB(app, heartbeatObject) {\r\n    try {\r\n        const db = await getDbPromise();\r\n        const tx = db.transaction(STORE_NAME, 'readwrite');\r\n        const objectStore = tx.objectStore(STORE_NAME);\r\n        await objectStore.put(heartbeatObject, computeKey(app));\r\n        await tx.done;\r\n    }\r\n    catch (e) {\r\n        if (e instanceof _firebase_util__WEBPACK_IMPORTED_MODULE_2__.FirebaseError) {\r\n            logger.warn(e.message);\r\n        }\r\n        else {\r\n            const idbGetError = ERROR_FACTORY.create(\"idb-set\" /* AppError.IDB_WRITE */, {\r\n                originalErrorMessage: e === null || e === void 0 ? void 0 : e.message\r\n            });\r\n            logger.warn(idbGetError.message);\r\n        }\r\n    }\r\n}\r\nfunction computeKey(app) {\r\n    return `${app.name}!${app.options.appId}`;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2021 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst MAX_HEADER_BYTES = 1024;\r\n// 30 days\r\nconst STORED_HEARTBEAT_RETENTION_MAX_MILLIS = 30 * 24 * 60 * 60 * 1000;\r\nclass HeartbeatServiceImpl {\r\n    constructor(container) {\r\n        this.container = container;\r\n        /**\r\n         * In-memory cache for heartbeats, used by getHeartbeatsHeader() to generate\r\n         * the header string.\r\n         * Stores one record per date. This will be consolidated into the standard\r\n         * format of one record per user agent string before being sent as a header.\r\n         * Populated from indexedDB when the controller is instantiated and should\r\n         * be kept in sync with indexedDB.\r\n         * Leave public for easier testing.\r\n         */\r\n        this._heartbeatsCache = null;\r\n        const app = this.container.getProvider('app').getImmediate();\r\n        this._storage = new HeartbeatStorageImpl(app);\r\n        this._heartbeatsCachePromise = this._storage.read().then(result => {\r\n            this._heartbeatsCache = result;\r\n            return result;\r\n        });\r\n    }\r\n    /**\r\n     * Called to report a heartbeat. The function will generate\r\n     * a HeartbeatsByUserAgent object, update heartbeatsCache, and persist it\r\n     * to IndexedDB.\r\n     * Note that we only store one heartbeat per day. So if a heartbeat for today is\r\n     * already logged, subsequent calls to this function in the same day will be ignored.\r\n     */\r\n    async triggerHeartbeat() {\r\n        var _a, _b;\r\n        const platformLogger = this.container\r\n            .getProvider('platform-logger')\r\n            .getImmediate();\r\n        // This is the \"Firebase user agent\" string from the platform logger\r\n        // service, not the browser user agent.\r\n        const agent = platformLogger.getPlatformInfoString();\r\n        const date = getUTCDateString();\r\n        if (((_a = this._heartbeatsCache) === null || _a === void 0 ? void 0 : _a.heartbeats) == null) {\r\n            this._heartbeatsCache = await this._heartbeatsCachePromise;\r\n            // If we failed to construct a heartbeats cache, then return immediately.\r\n            if (((_b = this._heartbeatsCache) === null || _b === void 0 ? void 0 : _b.heartbeats) == null) {\r\n                return;\r\n            }\r\n        }\r\n        // Do not store a heartbeat if one is already stored for this day\r\n        // or if a header has already been sent today.\r\n        if (this._heartbeatsCache.lastSentHeartbeatDate === date ||\r\n            this._heartbeatsCache.heartbeats.some(singleDateHeartbeat => singleDateHeartbeat.date === date)) {\r\n            return;\r\n        }\r\n        else {\r\n            // There is no entry for this date. Create one.\r\n            this._heartbeatsCache.heartbeats.push({ date, agent });\r\n        }\r\n        // Remove entries older than 30 days.\r\n        this._heartbeatsCache.heartbeats = this._heartbeatsCache.heartbeats.filter(singleDateHeartbeat => {\r\n            const hbTimestamp = new Date(singleDateHeartbeat.date).valueOf();\r\n            const now = Date.now();\r\n            return now - hbTimestamp <= STORED_HEARTBEAT_RETENTION_MAX_MILLIS;\r\n        });\r\n        return this._storage.overwrite(this._heartbeatsCache);\r\n    }\r\n    /**\r\n     * Returns a base64 encoded string which can be attached to the heartbeat-specific header directly.\r\n     * It also clears all heartbeats from memory as well as in IndexedDB.\r\n     *\r\n     * NOTE: Consuming product SDKs should not send the header if this method\r\n     * returns an empty string.\r\n     */\r\n    async getHeartbeatsHeader() {\r\n        var _a;\r\n        if (this._heartbeatsCache === null) {\r\n            await this._heartbeatsCachePromise;\r\n        }\r\n        // If it's still null or the array is empty, there is no data to send.\r\n        if (((_a = this._heartbeatsCache) === null || _a === void 0 ? void 0 : _a.heartbeats) == null ||\r\n            this._heartbeatsCache.heartbeats.length === 0) {\r\n            return '';\r\n        }\r\n        const date = getUTCDateString();\r\n        // Extract as many heartbeats from the cache as will fit under the size limit.\r\n        const { heartbeatsToSend, unsentEntries } = extractHeartbeatsForHeader(this._heartbeatsCache.heartbeats);\r\n        const headerString = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.base64urlEncodeWithoutPadding)(JSON.stringify({ version: 2, heartbeats: heartbeatsToSend }));\r\n        // Store last sent date to prevent another being logged/sent for the same day.\r\n        this._heartbeatsCache.lastSentHeartbeatDate = date;\r\n        if (unsentEntries.length > 0) {\r\n            // Store any unsent entries if they exist.\r\n            this._heartbeatsCache.heartbeats = unsentEntries;\r\n            // This seems more likely than emptying the array (below) to lead to some odd state\r\n            // since the cache isn't empty and this will be called again on the next request,\r\n            // and is probably safest if we await it.\r\n            await this._storage.overwrite(this._heartbeatsCache);\r\n        }\r\n        else {\r\n            this._heartbeatsCache.heartbeats = [];\r\n            // Do not wait for this, to reduce latency.\r\n            void this._storage.overwrite(this._heartbeatsCache);\r\n        }\r\n        return headerString;\r\n    }\r\n}\r\nfunction getUTCDateString() {\r\n    const today = new Date();\r\n    // Returns date format 'YYYY-MM-DD'\r\n    return today.toISOString().substring(0, 10);\r\n}\r\nfunction extractHeartbeatsForHeader(heartbeatsCache, maxSize = MAX_HEADER_BYTES) {\r\n    // Heartbeats grouped by user agent in the standard format to be sent in\r\n    // the header.\r\n    const heartbeatsToSend = [];\r\n    // Single date format heartbeats that are not sent.\r\n    let unsentEntries = heartbeatsCache.slice();\r\n    for (const singleDateHeartbeat of heartbeatsCache) {\r\n        // Look for an existing entry with the same user agent.\r\n        const heartbeatEntry = heartbeatsToSend.find(hb => hb.agent === singleDateHeartbeat.agent);\r\n        if (!heartbeatEntry) {\r\n            // If no entry for this user agent exists, create one.\r\n            heartbeatsToSend.push({\r\n                agent: singleDateHeartbeat.agent,\r\n                dates: [singleDateHeartbeat.date]\r\n            });\r\n            if (countBytes(heartbeatsToSend) > maxSize) {\r\n                // If the header would exceed max size, remove the added heartbeat\r\n                // entry and stop adding to the header.\r\n                heartbeatsToSend.pop();\r\n                break;\r\n            }\r\n        }\r\n        else {\r\n            heartbeatEntry.dates.push(singleDateHeartbeat.date);\r\n            // If the header would exceed max size, remove the added date\r\n            // and stop adding to the header.\r\n            if (countBytes(heartbeatsToSend) > maxSize) {\r\n                heartbeatEntry.dates.pop();\r\n                break;\r\n            }\r\n        }\r\n        // Pop unsent entry from queue. (Skipped if adding the entry exceeded\r\n        // quota and the loop breaks early.)\r\n        unsentEntries = unsentEntries.slice(1);\r\n    }\r\n    return {\r\n        heartbeatsToSend,\r\n        unsentEntries\r\n    };\r\n}\r\nclass HeartbeatStorageImpl {\r\n    constructor(app) {\r\n        this.app = app;\r\n        this._canUseIndexedDBPromise = this.runIndexedDBEnvironmentCheck();\r\n    }\r\n    async runIndexedDBEnvironmentCheck() {\r\n        if (!(0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.isIndexedDBAvailable)()) {\r\n            return false;\r\n        }\r\n        else {\r\n            return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.validateIndexedDBOpenable)()\r\n                .then(() => true)\r\n                .catch(() => false);\r\n        }\r\n    }\r\n    /**\r\n     * Read all heartbeats.\r\n     */\r\n    async read() {\r\n        const canUseIndexedDB = await this._canUseIndexedDBPromise;\r\n        if (!canUseIndexedDB) {\r\n            return { heartbeats: [] };\r\n        }\r\n        else {\r\n            const idbHeartbeatObject = await readHeartbeatsFromIndexedDB(this.app);\r\n            if (idbHeartbeatObject === null || idbHeartbeatObject === void 0 ? void 0 : idbHeartbeatObject.heartbeats) {\r\n                return idbHeartbeatObject;\r\n            }\r\n            else {\r\n                return { heartbeats: [] };\r\n            }\r\n        }\r\n    }\r\n    // overwrite the storage with the provided heartbeats\r\n    async overwrite(heartbeatsObject) {\r\n        var _a;\r\n        const canUseIndexedDB = await this._canUseIndexedDBPromise;\r\n        if (!canUseIndexedDB) {\r\n            return;\r\n        }\r\n        else {\r\n            const existingHeartbeatsObject = await this.read();\r\n            return writeHeartbeatsToIndexedDB(this.app, {\r\n                lastSentHeartbeatDate: (_a = heartbeatsObject.lastSentHeartbeatDate) !== null && _a !== void 0 ? _a : existingHeartbeatsObject.lastSentHeartbeatDate,\r\n                heartbeats: heartbeatsObject.heartbeats\r\n            });\r\n        }\r\n    }\r\n    // add heartbeats\r\n    async add(heartbeatsObject) {\r\n        var _a;\r\n        const canUseIndexedDB = await this._canUseIndexedDBPromise;\r\n        if (!canUseIndexedDB) {\r\n            return;\r\n        }\r\n        else {\r\n            const existingHeartbeatsObject = await this.read();\r\n            return writeHeartbeatsToIndexedDB(this.app, {\r\n                lastSentHeartbeatDate: (_a = heartbeatsObject.lastSentHeartbeatDate) !== null && _a !== void 0 ? _a : existingHeartbeatsObject.lastSentHeartbeatDate,\r\n                heartbeats: [\r\n                    ...existingHeartbeatsObject.heartbeats,\r\n                    ...heartbeatsObject.heartbeats\r\n                ]\r\n            });\r\n        }\r\n    }\r\n}\r\n/**\r\n * Calculate bytes of a HeartbeatsByUserAgent array after being wrapped\r\n * in a platform logging header JSON object, stringified, and converted\r\n * to base 64.\r\n */\r\nfunction countBytes(heartbeatsCache) {\r\n    // base64 has a restricted set of characters, all of which should be 1 byte.\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_2__.base64urlEncodeWithoutPadding)(\r\n    // heartbeatsCache wrapper properties\r\n    JSON.stringify({ version: 2, heartbeats: heartbeatsCache })).length;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction registerCoreComponents(variant) {\r\n    _registerComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_0__.Component('platform-logger', container => new PlatformLoggerServiceImpl(container), \"PRIVATE\" /* ComponentType.PRIVATE */));\r\n    _registerComponent(new _firebase_component__WEBPACK_IMPORTED_MODULE_0__.Component('heartbeat', container => new HeartbeatServiceImpl(container), \"PRIVATE\" /* ComponentType.PRIVATE */));\r\n    // Register `app` package.\r\n    registerVersion(name$o, version$1, variant);\r\n    // BUILD_TARGET will be replaced by values like esm5, esm2017, cjs5, etc during the compilation\r\n    registerVersion(name$o, version$1, 'esm2017');\r\n    // Register platform SDK identifier (no version).\r\n    registerVersion('fire-js', '');\r\n}\n\n/**\r\n * Firebase App\r\n *\r\n * @remarks This package coordinates the communication between the different Firebase components\r\n * @packageDocumentation\r\n */\r\nregisterCoreComponents('');\n\n\n//# sourceMappingURL=index.esm2017.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@firebase/app/dist/esm/index.esm2017.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/@firebase/auth/dist/node-esm/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@firebase/auth/dist/node-esm/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ActionCodeOperation: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.A),\n/* harmony export */   ActionCodeURL: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ai),\n/* harmony export */   AuthCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.L),\n/* harmony export */   AuthErrorCodes: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.I),\n/* harmony export */   EmailAuthCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.M),\n/* harmony export */   EmailAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.V),\n/* harmony export */   FacebookAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.W),\n/* harmony export */   FactorId: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.F),\n/* harmony export */   GithubAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.Y),\n/* harmony export */   GoogleAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.X),\n/* harmony export */   OAuthCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.N),\n/* harmony export */   OAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.Z),\n/* harmony export */   OperationType: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.O),\n/* harmony export */   PhoneAuthCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.Q),\n/* harmony export */   PhoneAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.P),\n/* harmony export */   PhoneMultiFactorGenerator: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.m),\n/* harmony export */   ProviderId: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.p),\n/* harmony export */   RecaptchaVerifier: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.R),\n/* harmony export */   SAMLAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__._),\n/* harmony export */   SignInMethod: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.S),\n/* harmony export */   TotpMultiFactorGenerator: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.T),\n/* harmony export */   TotpSecret: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.n),\n/* harmony export */   TwitterAuthProvider: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.$),\n/* harmony export */   applyActionCode: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a7),\n/* harmony export */   beforeAuthStateChanged: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.x),\n/* harmony export */   browserLocalPersistence: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.b),\n/* harmony export */   browserPopupRedirectResolver: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.k),\n/* harmony export */   browserSessionPersistence: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a),\n/* harmony export */   checkActionCode: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a8),\n/* harmony export */   confirmPasswordReset: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a6),\n/* harmony export */   connectAuthEmulator: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.K),\n/* harmony export */   createUserWithEmailAndPassword: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.aa),\n/* harmony export */   debugErrorMap: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.G),\n/* harmony export */   deleteUser: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.E),\n/* harmony export */   fetchSignInMethodsForEmail: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.af),\n/* harmony export */   getAdditionalUserInfo: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.aq),\n/* harmony export */   getAuth: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.o),\n/* harmony export */   getIdToken: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.an),\n/* harmony export */   getIdTokenResult: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ao),\n/* harmony export */   getMultiFactorResolver: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.as),\n/* harmony export */   getRedirectResult: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.j),\n/* harmony export */   inMemoryPersistence: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.U),\n/* harmony export */   indexedDBLocalPersistence: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.i),\n/* harmony export */   initializeAuth: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.J),\n/* harmony export */   initializeRecaptchaConfig: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.t),\n/* harmony export */   isSignInWithEmailLink: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ad),\n/* harmony export */   linkWithCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a2),\n/* harmony export */   linkWithPhoneNumber: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.l),\n/* harmony export */   linkWithPopup: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.d),\n/* harmony export */   linkWithRedirect: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.g),\n/* harmony export */   multiFactor: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.at),\n/* harmony export */   onAuthStateChanged: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.y),\n/* harmony export */   onIdTokenChanged: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.w),\n/* harmony export */   parseActionCodeURL: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.aj),\n/* harmony export */   prodErrorMap: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.H),\n/* harmony export */   reauthenticateWithCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a3),\n/* harmony export */   reauthenticateWithPhoneNumber: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.r),\n/* harmony export */   reauthenticateWithPopup: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.e),\n/* harmony export */   reauthenticateWithRedirect: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.h),\n/* harmony export */   reload: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ar),\n/* harmony export */   revokeAccessToken: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.D),\n/* harmony export */   sendEmailVerification: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ag),\n/* harmony export */   sendPasswordResetEmail: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a5),\n/* harmony export */   sendSignInLinkToEmail: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ac),\n/* harmony export */   setPersistence: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.q),\n/* harmony export */   signInAnonymously: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a0),\n/* harmony export */   signInWithCredential: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a1),\n/* harmony export */   signInWithCustomToken: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a4),\n/* harmony export */   signInWithEmailAndPassword: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ab),\n/* harmony export */   signInWithEmailLink: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ae),\n/* harmony export */   signInWithPhoneNumber: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.s),\n/* harmony export */   signInWithPopup: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.c),\n/* harmony export */   signInWithRedirect: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.f),\n/* harmony export */   signOut: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.C),\n/* harmony export */   unlink: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ap),\n/* harmony export */   updateCurrentUser: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.B),\n/* harmony export */   updateEmail: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.al),\n/* harmony export */   updatePassword: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.am),\n/* harmony export */   updatePhoneNumber: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.u),\n/* harmony export */   updateProfile: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ak),\n/* harmony export */   useDeviceLanguage: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.z),\n/* harmony export */   validatePassword: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.v),\n/* harmony export */   verifyBeforeUpdateEmail: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.ah),\n/* harmony export */   verifyPasswordResetCode: () => (/* reexport safe */ _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__.a9)\n/* harmony export */ });\n/* harmony import */ var _totp_4c2d4e67_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./totp-4c2d4e67.js */ \"(ssr)/./node_modules/@firebase/auth/dist/node-esm/totp-4c2d4e67.js\");\n/* harmony import */ var _firebase_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @firebase/util */ \"(ssr)/./node_modules/@firebase/util/dist/node-esm/index.node.esm.js\");\n/* harmony import */ var _firebase_app__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @firebase/app */ \"(ssr)/./node_modules/@firebase/app/dist/esm/index.esm2017.js\");\n/* harmony import */ var _firebase_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @firebase/component */ \"(ssr)/./node_modules/@firebase/component/dist/esm/index.esm2017.js\");\n/* harmony import */ var undici__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! undici */ \"(ssr)/./node_modules/undici/index.js\");\n/* harmony import */ var _firebase_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @firebase/logger */ \"(ssr)/./node_modules/@firebase/logger/dist/esm/index.esm2017.js\");\n\n\n\n\n\n\n\n//# sourceMappingURL=index.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@firebase/auth/dist/node-esm/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/@firebase/auth/dist/node-esm/totp-4c2d4e67.js":
/*!********************************************************************!*\
  !*** ./node_modules/@firebase/auth/dist/node-esm/totp-4c2d4e67.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   $: () => (/* binding */ TwitterAuthProvider),\n/* harmony export */   A: () => (/* binding */ ActionCodeOperation),\n/* harmony export */   B: () => (/* binding */ updateCurrentUser),\n/* harmony export */   C: () => (/* binding */ signOut),\n/* harmony export */   D: () => (/* binding */ revokeAccessToken),\n/* harmony export */   E: () => (/* binding */ deleteUser),\n/* harmony export */   F: () => (/* binding */ FactorId),\n/* harmony export */   G: () => (/* binding */ debugErrorMap),\n/* harmony export */   H: () => (/* binding */ prodErrorMap),\n/* harmony export */   I: () => (/* binding */ AUTH_ERROR_CODES_MAP_DO_NOT_USE_INTERNALLY),\n/* harmony export */   J: () => (/* binding */ initializeAuth),\n/* harmony export */   K: () => (/* binding */ connectAuthEmulator),\n/* harmony export */   L: () => (/* binding */ AuthCredential),\n/* harmony export */   M: () => (/* binding */ EmailAuthCredential),\n/* harmony export */   N: () => (/* binding */ OAuthCredential),\n/* harmony export */   O: () => (/* binding */ OperationType),\n/* harmony export */   P: () => (/* binding */ PhoneAuthProvider),\n/* harmony export */   Q: () => (/* binding */ PhoneAuthCredential),\n/* harmony export */   R: () => (/* binding */ RecaptchaVerifier),\n/* harmony export */   S: () => (/* binding */ SignInMethod),\n/* harmony export */   T: () => (/* binding */ TotpMultiFactorGenerator),\n/* harmony export */   U: () => (/* binding */ inMemoryPersistence),\n/* harmony export */   V: () => (/* binding */ EmailAuthProvider),\n/* harmony export */   W: () => (/* binding */ FacebookAuthProvider),\n/* harmony export */   X: () => (/* binding */ GoogleAuthProvider),\n/* harmony export */   Y: () => (/* binding */ GithubAuthProvider),\n/* harmony export */   Z: () => (/* binding */ OAuthProvider),\n/* harmony export */   _: () => (/* binding */ SAMLAuthProvider),\n/* harmony export */   a: () => (/* binding */ browserSessionPersistence),\n/* harmony export */   a0: () => (/* binding */ signInAnonymously),\n/* harmony export */   a1: () => (/* binding */ signInWithCredential),\n/* harmony export */   a2: () => (/* binding */ linkWithCredential),\n/* harmony export */   a3: () => (/* binding */ reauthenticateWithCredential),\n/* harmony export */   a4: () => (/* binding */ signInWithCustomToken),\n/* harmony export */   a5: () => (/* binding */ sendPasswordResetEmail),\n/* harmony export */   a6: () => (/* binding */ confirmPasswordReset),\n/* harmony export */   a7: () => (/* binding */ applyActionCode),\n/* harmony export */   a8: () => (/* binding */ checkActionCode),\n/* harmony export */   a9: () => (/* binding */ verifyPasswordResetCode),\n/* harmony export */   aA: () => (/* binding */ _fail),\n/* harmony export */   aB: () => (/* binding */ debugAssert),\n/* harmony export */   aC: () => (/* binding */ _persistenceKeyName),\n/* harmony export */   aD: () => (/* binding */ _castAuth),\n/* harmony export */   aE: () => (/* binding */ FederatedAuthProvider),\n/* harmony export */   aF: () => (/* binding */ BaseOAuthProvider),\n/* harmony export */   aG: () => (/* binding */ _emulatorUrl),\n/* harmony export */   aH: () => (/* binding */ _performApiRequest),\n/* harmony export */   aI: () => (/* binding */ _isIOS),\n/* harmony export */   aJ: () => (/* binding */ _isAndroid),\n/* harmony export */   aK: () => (/* binding */ _isIOS7Or8),\n/* harmony export */   aL: () => (/* binding */ _createError),\n/* harmony export */   aM: () => (/* binding */ _isIframe),\n/* harmony export */   aN: () => (/* binding */ _isMobileBrowser),\n/* harmony export */   aO: () => (/* binding */ _isIE10),\n/* harmony export */   aP: () => (/* binding */ _isSafari),\n/* harmony export */   aQ: () => (/* binding */ UserImpl),\n/* harmony export */   aR: () => (/* binding */ AuthImpl),\n/* harmony export */   aS: () => (/* binding */ _getClientVersion),\n/* harmony export */   aT: () => (/* binding */ FetchProvider),\n/* harmony export */   aU: () => (/* binding */ SAMLAuthCredential),\n/* harmony export */   aa: () => (/* binding */ createUserWithEmailAndPassword),\n/* harmony export */   ab: () => (/* binding */ signInWithEmailAndPassword),\n/* harmony export */   ac: () => (/* binding */ sendSignInLinkToEmail),\n/* harmony export */   ad: () => (/* binding */ isSignInWithEmailLink),\n/* harmony export */   ae: () => (/* binding */ signInWithEmailLink),\n/* harmony export */   af: () => (/* binding */ fetchSignInMethodsForEmail),\n/* harmony export */   ag: () => (/* binding */ sendEmailVerification),\n/* harmony export */   ah: () => (/* binding */ verifyBeforeUpdateEmail),\n/* harmony export */   ai: () => (/* binding */ ActionCodeURL),\n/* harmony export */   aj: () => (/* binding */ parseActionCodeURL),\n/* harmony export */   ak: () => (/* binding */ updateProfile),\n/* harmony export */   al: () => (/* binding */ updateEmail),\n/* harmony export */   am: () => (/* binding */ updatePassword),\n/* harmony export */   an: () => (/* binding */ getIdToken),\n/* harmony export */   ao: () => (/* binding */ getIdTokenResult),\n/* harmony export */   ap: () => (/* binding */ unlink),\n/* harmony export */   aq: () => (/* binding */ getAdditionalUserInfo),\n/* harmony export */   ar: () => (/* binding */ reload),\n/* harmony export */   as: () => (/* binding */ getMultiFactorResolver),\n/* harmony export */   at: () => (/* binding */ multiFactor),\n/* harmony export */   au: () => (/* binding */ _getInstance),\n/* harmony export */   av: () => (/* binding */ _assert),\n/* harmony export */   aw: () => (/* binding */ _signInWithCredential),\n/* harmony export */   ax: () => (/* binding */ _reauthenticate),\n/* harmony export */   ay: () => (/* binding */ _link),\n/* harmony export */   az: () => (/* binding */ signInWithIdp),\n/* harmony export */   b: () => (/* binding */ browserLocalPersistence),\n/* harmony export */   c: () => (/* binding */ signInWithPopup),\n/* harmony export */   d: () => (/* binding */ linkWithPopup),\n/* harmony export */   e: () => (/* binding */ reauthenticateWithPopup),\n/* harmony export */   f: () => (/* binding */ signInWithRedirect),\n/* harmony export */   g: () => (/* binding */ linkWithRedirect),\n/* harmony export */   h: () => (/* binding */ reauthenticateWithRedirect),\n/* harmony export */   i: () => (/* binding */ indexedDBLocalPersistence),\n/* harmony export */   j: () => (/* binding */ getRedirectResult),\n/* harmony export */   k: () => (/* binding */ browserPopupRedirectResolver),\n/* harmony export */   l: () => (/* binding */ linkWithPhoneNumber),\n/* harmony export */   m: () => (/* binding */ PhoneMultiFactorGenerator),\n/* harmony export */   n: () => (/* binding */ TotpSecret),\n/* harmony export */   o: () => (/* binding */ getAuth),\n/* harmony export */   p: () => (/* binding */ ProviderId),\n/* harmony export */   q: () => (/* binding */ setPersistence),\n/* harmony export */   r: () => (/* binding */ reauthenticateWithPhoneNumber),\n/* harmony export */   s: () => (/* binding */ signInWithPhoneNumber),\n/* harmony export */   t: () => (/* binding */ initializeRecaptchaConfig),\n/* harmony export */   u: () => (/* binding */ updatePhoneNumber),\n/* harmony export */   v: () => (/* binding */ validatePassword),\n/* harmony export */   w: () => (/* binding */ onIdTokenChanged),\n/* harmony export */   x: () => (/* binding */ beforeAuthStateChanged),\n/* harmony export */   y: () => (/* binding */ onAuthStateChanged),\n/* harmony export */   z: () => (/* binding */ useDeviceLanguage)\n/* harmony export */ });\n/* harmony import */ var _firebase_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @firebase/util */ \"(ssr)/./node_modules/@firebase/util/dist/node-esm/index.node.esm.js\");\n/* harmony import */ var _firebase_app__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @firebase/app */ \"(ssr)/./node_modules/@firebase/app/dist/esm/index.esm2017.js\");\n/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ \"(ssr)/./node_modules/tslib/tslib.es6.mjs\");\n/* harmony import */ var _firebase_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @firebase/component */ \"(ssr)/./node_modules/@firebase/component/dist/esm/index.esm2017.js\");\n/* harmony import */ var undici__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! undici */ \"(ssr)/./node_modules/undici/index.js\");\n/* harmony import */ var _firebase_logger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @firebase/logger */ \"(ssr)/./node_modules/@firebase/logger/dist/esm/index.esm2017.js\");\n\n\n\n\n\n\n\n/**\r\n * @license\r\n * Copyright 2021 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * An enum of factors that may be used for multifactor authentication.\r\n *\r\n * @public\r\n */\r\nconst FactorId = {\r\n    /** Phone as second factor */\r\n    PHONE: 'phone',\r\n    TOTP: 'totp'\r\n};\r\n/**\r\n * Enumeration of supported providers.\r\n *\r\n * @public\r\n */\r\nconst ProviderId = {\r\n    /** Facebook provider ID */\r\n    FACEBOOK: 'facebook.com',\r\n    /** GitHub provider ID */\r\n    GITHUB: 'github.com',\r\n    /** Google provider ID */\r\n    GOOGLE: 'google.com',\r\n    /** Password provider */\r\n    PASSWORD: 'password',\r\n    /** Phone provider */\r\n    PHONE: 'phone',\r\n    /** Twitter provider ID */\r\n    TWITTER: 'twitter.com'\r\n};\r\n/**\r\n * Enumeration of supported sign-in methods.\r\n *\r\n * @public\r\n */\r\nconst SignInMethod = {\r\n    /** Email link sign in method */\r\n    EMAIL_LINK: 'emailLink',\r\n    /** Email/password sign in method */\r\n    EMAIL_PASSWORD: 'password',\r\n    /** Facebook sign in method */\r\n    FACEBOOK: 'facebook.com',\r\n    /** GitHub sign in method */\r\n    GITHUB: 'github.com',\r\n    /** Google sign in method */\r\n    GOOGLE: 'google.com',\r\n    /** Phone sign in method */\r\n    PHONE: 'phone',\r\n    /** Twitter sign in method */\r\n    TWITTER: 'twitter.com'\r\n};\r\n/**\r\n * Enumeration of supported operation types.\r\n *\r\n * @public\r\n */\r\nconst OperationType = {\r\n    /** Operation involving linking an additional provider to an already signed-in user. */\r\n    LINK: 'link',\r\n    /** Operation involving using a provider to reauthenticate an already signed-in user. */\r\n    REAUTHENTICATE: 'reauthenticate',\r\n    /** Operation involving signing in a user. */\r\n    SIGN_IN: 'signIn'\r\n};\r\n/**\r\n * An enumeration of the possible email action types.\r\n *\r\n * @public\r\n */\r\nconst ActionCodeOperation = {\r\n    /** The email link sign-in action. */\r\n    EMAIL_SIGNIN: 'EMAIL_SIGNIN',\r\n    /** The password reset action. */\r\n    PASSWORD_RESET: 'PASSWORD_RESET',\r\n    /** The email revocation action. */\r\n    RECOVER_EMAIL: 'RECOVER_EMAIL',\r\n    /** The revert second factor addition email action. */\r\n    REVERT_SECOND_FACTOR_ADDITION: 'REVERT_SECOND_FACTOR_ADDITION',\r\n    /** The revert second factor addition email action. */\r\n    VERIFY_AND_CHANGE_EMAIL: 'VERIFY_AND_CHANGE_EMAIL',\r\n    /** The email verification action. */\r\n    VERIFY_EMAIL: 'VERIFY_EMAIL'\r\n};\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction _debugErrorMap() {\r\n    return {\r\n        [\"admin-restricted-operation\" /* AuthErrorCode.ADMIN_ONLY_OPERATION */]: 'This operation is restricted to administrators only.',\r\n        [\"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */]: '',\r\n        [\"app-not-authorized\" /* AuthErrorCode.APP_NOT_AUTHORIZED */]: \"This app, identified by the domain where it's hosted, is not \" +\r\n            'authorized to use Firebase Authentication with the provided API key. ' +\r\n            'Review your key configuration in the Google API console.',\r\n        [\"app-not-installed\" /* AuthErrorCode.APP_NOT_INSTALLED */]: 'The requested mobile application corresponding to the identifier (' +\r\n            'Android package name or iOS bundle ID) provided is not installed on ' +\r\n            'this device.',\r\n        [\"captcha-check-failed\" /* AuthErrorCode.CAPTCHA_CHECK_FAILED */]: 'The reCAPTCHA response token provided is either invalid, expired, ' +\r\n            'already used or the domain associated with it does not match the list ' +\r\n            'of whitelisted domains.',\r\n        [\"code-expired\" /* AuthErrorCode.CODE_EXPIRED */]: 'The SMS code has expired. Please re-send the verification code to try ' +\r\n            'again.',\r\n        [\"cordova-not-ready\" /* AuthErrorCode.CORDOVA_NOT_READY */]: 'Cordova framework is not ready.',\r\n        [\"cors-unsupported\" /* AuthErrorCode.CORS_UNSUPPORTED */]: 'This browser is not supported.',\r\n        [\"credential-already-in-use\" /* AuthErrorCode.CREDENTIAL_ALREADY_IN_USE */]: 'This credential is already associated with a different user account.',\r\n        [\"custom-token-mismatch\" /* AuthErrorCode.CREDENTIAL_MISMATCH */]: 'The custom token corresponds to a different audience.',\r\n        [\"requires-recent-login\" /* AuthErrorCode.CREDENTIAL_TOO_OLD_LOGIN_AGAIN */]: 'This operation is sensitive and requires recent authentication. Log in ' +\r\n            'again before retrying this request.',\r\n        [\"dependent-sdk-initialized-before-auth\" /* AuthErrorCode.DEPENDENT_SDK_INIT_BEFORE_AUTH */]: 'Another Firebase SDK was initialized and is trying to use Auth before Auth is ' +\r\n            'initialized. Please be sure to call `initializeAuth` or `getAuth` before ' +\r\n            'starting any other Firebase SDK.',\r\n        [\"dynamic-link-not-activated\" /* AuthErrorCode.DYNAMIC_LINK_NOT_ACTIVATED */]: 'Please activate Dynamic Links in the Firebase Console and agree to the terms and ' +\r\n            'conditions.',\r\n        [\"email-change-needs-verification\" /* AuthErrorCode.EMAIL_CHANGE_NEEDS_VERIFICATION */]: 'Multi-factor users must always have a verified email.',\r\n        [\"email-already-in-use\" /* AuthErrorCode.EMAIL_EXISTS */]: 'The email address is already in use by another account.',\r\n        [\"emulator-config-failed\" /* AuthErrorCode.EMULATOR_CONFIG_FAILED */]: 'Auth instance has already been used to make a network call. Auth can ' +\r\n            'no longer be configured to use the emulator. Try calling ' +\r\n            '\"connectAuthEmulator()\" sooner.',\r\n        [\"expired-action-code\" /* AuthErrorCode.EXPIRED_OOB_CODE */]: 'The action code has expired.',\r\n        [\"cancelled-popup-request\" /* AuthErrorCode.EXPIRED_POPUP_REQUEST */]: 'This operation has been cancelled due to another conflicting popup being opened.',\r\n        [\"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */]: 'An internal AuthError has occurred.',\r\n        [\"invalid-app-credential\" /* AuthErrorCode.INVALID_APP_CREDENTIAL */]: 'The phone verification request contains an invalid application verifier.' +\r\n            ' The reCAPTCHA token response is either invalid or expired.',\r\n        [\"invalid-app-id\" /* AuthErrorCode.INVALID_APP_ID */]: 'The mobile app identifier is not registed for the current project.',\r\n        [\"invalid-user-token\" /* AuthErrorCode.INVALID_AUTH */]: \"This user's credential isn't valid for this project. This can happen \" +\r\n            \"if the user's token has been tampered with, or if the user isn't for \" +\r\n            'the project associated with this API key.',\r\n        [\"invalid-auth-event\" /* AuthErrorCode.INVALID_AUTH_EVENT */]: 'An internal AuthError has occurred.',\r\n        [\"invalid-verification-code\" /* AuthErrorCode.INVALID_CODE */]: 'The SMS verification code used to create the phone auth credential is ' +\r\n            'invalid. Please resend the verification code sms and be sure to use the ' +\r\n            'verification code provided by the user.',\r\n        [\"invalid-continue-uri\" /* AuthErrorCode.INVALID_CONTINUE_URI */]: 'The continue URL provided in the request is invalid.',\r\n        [\"invalid-cordova-configuration\" /* AuthErrorCode.INVALID_CORDOVA_CONFIGURATION */]: 'The following Cordova plugins must be installed to enable OAuth sign-in: ' +\r\n            'cordova-plugin-buildinfo, cordova-universal-links-plugin, ' +\r\n            'cordova-plugin-browsertab, cordova-plugin-inappbrowser and ' +\r\n            'cordova-plugin-customurlscheme.',\r\n        [\"invalid-custom-token\" /* AuthErrorCode.INVALID_CUSTOM_TOKEN */]: 'The custom token format is incorrect. Please check the documentation.',\r\n        [\"invalid-dynamic-link-domain\" /* AuthErrorCode.INVALID_DYNAMIC_LINK_DOMAIN */]: 'The provided dynamic link domain is not configured or authorized for the current project.',\r\n        [\"invalid-email\" /* AuthErrorCode.INVALID_EMAIL */]: 'The email address is badly formatted.',\r\n        [\"invalid-emulator-scheme\" /* AuthErrorCode.INVALID_EMULATOR_SCHEME */]: 'Emulator URL must start with a valid scheme (http:// or https://).',\r\n        [\"invalid-api-key\" /* AuthErrorCode.INVALID_API_KEY */]: 'Your API key is invalid, please check you have copied it correctly.',\r\n        [\"invalid-cert-hash\" /* AuthErrorCode.INVALID_CERT_HASH */]: 'The SHA-1 certificate hash provided is invalid.',\r\n        [\"invalid-credential\" /* AuthErrorCode.INVALID_CREDENTIAL */]: 'The supplied auth credential is incorrect, malformed or has expired.',\r\n        [\"invalid-message-payload\" /* AuthErrorCode.INVALID_MESSAGE_PAYLOAD */]: 'The email template corresponding to this action contains invalid characters in its message. ' +\r\n            'Please fix by going to the Auth email templates section in the Firebase Console.',\r\n        [\"invalid-multi-factor-session\" /* AuthErrorCode.INVALID_MFA_SESSION */]: 'The request does not contain a valid proof of first factor successful sign-in.',\r\n        [\"invalid-oauth-provider\" /* AuthErrorCode.INVALID_OAUTH_PROVIDER */]: 'EmailAuthProvider is not supported for this operation. This operation ' +\r\n            'only supports OAuth providers.',\r\n        [\"invalid-oauth-client-id\" /* AuthErrorCode.INVALID_OAUTH_CLIENT_ID */]: 'The OAuth client ID provided is either invalid or does not match the ' +\r\n            'specified API key.',\r\n        [\"unauthorized-domain\" /* AuthErrorCode.INVALID_ORIGIN */]: 'This domain is not authorized for OAuth operations for your Firebase ' +\r\n            'project. Edit the list of authorized domains from the Firebase console.',\r\n        [\"invalid-action-code\" /* AuthErrorCode.INVALID_OOB_CODE */]: 'The action code is invalid. This can happen if the code is malformed, ' +\r\n            'expired, or has already been used.',\r\n        [\"wrong-password\" /* AuthErrorCode.INVALID_PASSWORD */]: 'The password is invalid or the user does not have a password.',\r\n        [\"invalid-persistence-type\" /* AuthErrorCode.INVALID_PERSISTENCE */]: 'The specified persistence type is invalid. It can only be local, session or none.',\r\n        [\"invalid-phone-number\" /* AuthErrorCode.INVALID_PHONE_NUMBER */]: 'The format of the phone number provided is incorrect. Please enter the ' +\r\n            'phone number in a format that can be parsed into E.164 format. E.164 ' +\r\n            'phone numbers are written in the format [+][country code][subscriber ' +\r\n            'number including area code].',\r\n        [\"invalid-provider-id\" /* AuthErrorCode.INVALID_PROVIDER_ID */]: 'The specified provider ID is invalid.',\r\n        [\"invalid-recipient-email\" /* AuthErrorCode.INVALID_RECIPIENT_EMAIL */]: 'The email corresponding to this action failed to send as the provided ' +\r\n            'recipient email address is invalid.',\r\n        [\"invalid-sender\" /* AuthErrorCode.INVALID_SENDER */]: 'The email template corresponding to this action contains an invalid sender email or name. ' +\r\n            'Please fix by going to the Auth email templates section in the Firebase Console.',\r\n        [\"invalid-verification-id\" /* AuthErrorCode.INVALID_SESSION_INFO */]: 'The verification ID used to create the phone auth credential is invalid.',\r\n        [\"invalid-tenant-id\" /* AuthErrorCode.INVALID_TENANT_ID */]: \"The Auth instance's tenant ID is invalid.\",\r\n        [\"login-blocked\" /* AuthErrorCode.LOGIN_BLOCKED */]: 'Login blocked by user-provided method: {$originalMessage}',\r\n        [\"missing-android-pkg-name\" /* AuthErrorCode.MISSING_ANDROID_PACKAGE_NAME */]: 'An Android Package Name must be provided if the Android App is required to be installed.',\r\n        [\"auth-domain-config-required\" /* AuthErrorCode.MISSING_AUTH_DOMAIN */]: 'Be sure to include authDomain when calling firebase.initializeApp(), ' +\r\n            'by following the instructions in the Firebase console.',\r\n        [\"missing-app-credential\" /* AuthErrorCode.MISSING_APP_CREDENTIAL */]: 'The phone verification request is missing an application verifier ' +\r\n            'assertion. A reCAPTCHA response token needs to be provided.',\r\n        [\"missing-verification-code\" /* AuthErrorCode.MISSING_CODE */]: 'The phone auth credential was created with an empty SMS verification code.',\r\n        [\"missing-continue-uri\" /* AuthErrorCode.MISSING_CONTINUE_URI */]: 'A continue URL must be provided in the request.',\r\n        [\"missing-iframe-start\" /* AuthErrorCode.MISSING_IFRAME_START */]: 'An internal AuthError has occurred.',\r\n        [\"missing-ios-bundle-id\" /* AuthErrorCode.MISSING_IOS_BUNDLE_ID */]: 'An iOS Bundle ID must be provided if an App Store ID is provided.',\r\n        [\"missing-or-invalid-nonce\" /* AuthErrorCode.MISSING_OR_INVALID_NONCE */]: 'The request does not contain a valid nonce. This can occur if the ' +\r\n            'SHA-256 hash of the provided raw nonce does not match the hashed nonce ' +\r\n            'in the ID token payload.',\r\n        [\"missing-password\" /* AuthErrorCode.MISSING_PASSWORD */]: 'A non-empty password must be provided',\r\n        [\"missing-multi-factor-info\" /* AuthErrorCode.MISSING_MFA_INFO */]: 'No second factor identifier is provided.',\r\n        [\"missing-multi-factor-session\" /* AuthErrorCode.MISSING_MFA_SESSION */]: 'The request is missing proof of first factor successful sign-in.',\r\n        [\"missing-phone-number\" /* AuthErrorCode.MISSING_PHONE_NUMBER */]: 'To send verification codes, provide a phone number for the recipient.',\r\n        [\"missing-verification-id\" /* AuthErrorCode.MISSING_SESSION_INFO */]: 'The phone auth credential was created with an empty verification ID.',\r\n        [\"app-deleted\" /* AuthErrorCode.MODULE_DESTROYED */]: 'This instance of FirebaseApp has been deleted.',\r\n        [\"multi-factor-info-not-found\" /* AuthErrorCode.MFA_INFO_NOT_FOUND */]: 'The user does not have a second factor matching the identifier provided.',\r\n        [\"multi-factor-auth-required\" /* AuthErrorCode.MFA_REQUIRED */]: 'Proof of ownership of a second factor is required to complete sign-in.',\r\n        [\"account-exists-with-different-credential\" /* AuthErrorCode.NEED_CONFIRMATION */]: 'An account already exists with the same email address but different ' +\r\n            'sign-in credentials. Sign in using a provider associated with this ' +\r\n            'email address.',\r\n        [\"network-request-failed\" /* AuthErrorCode.NETWORK_REQUEST_FAILED */]: 'A network AuthError (such as timeout, interrupted connection or unreachable host) has occurred.',\r\n        [\"no-auth-event\" /* AuthErrorCode.NO_AUTH_EVENT */]: 'An internal AuthError has occurred.',\r\n        [\"no-such-provider\" /* AuthErrorCode.NO_SUCH_PROVIDER */]: 'User was not linked to an account with the given provider.',\r\n        [\"null-user\" /* AuthErrorCode.NULL_USER */]: 'A null user object was provided as the argument for an operation which ' +\r\n            'requires a non-null user object.',\r\n        [\"operation-not-allowed\" /* AuthErrorCode.OPERATION_NOT_ALLOWED */]: 'The given sign-in provider is disabled for this Firebase project. ' +\r\n            'Enable it in the Firebase console, under the sign-in method tab of the ' +\r\n            'Auth section.',\r\n        [\"operation-not-supported-in-this-environment\" /* AuthErrorCode.OPERATION_NOT_SUPPORTED */]: 'This operation is not supported in the environment this application is ' +\r\n            'running on. \"location.protocol\" must be http, https or chrome-extension' +\r\n            ' and web storage must be enabled.',\r\n        [\"popup-blocked\" /* AuthErrorCode.POPUP_BLOCKED */]: 'Unable to establish a connection with the popup. It may have been blocked by the browser.',\r\n        [\"popup-closed-by-user\" /* AuthErrorCode.POPUP_CLOSED_BY_USER */]: 'The popup has been closed by the user before finalizing the operation.',\r\n        [\"provider-already-linked\" /* AuthErrorCode.PROVIDER_ALREADY_LINKED */]: 'User can only be linked to one identity for the given provider.',\r\n        [\"quota-exceeded\" /* AuthErrorCode.QUOTA_EXCEEDED */]: \"The project's quota for this operation has been exceeded.\",\r\n        [\"redirect-cancelled-by-user\" /* AuthErrorCode.REDIRECT_CANCELLED_BY_USER */]: 'The redirect operation has been cancelled by the user before finalizing.',\r\n        [\"redirect-operation-pending\" /* AuthErrorCode.REDIRECT_OPERATION_PENDING */]: 'A redirect sign-in operation is already pending.',\r\n        [\"rejected-credential\" /* AuthErrorCode.REJECTED_CREDENTIAL */]: 'The request contains malformed or mismatching credentials.',\r\n        [\"second-factor-already-in-use\" /* AuthErrorCode.SECOND_FACTOR_ALREADY_ENROLLED */]: 'The second factor is already enrolled on this account.',\r\n        [\"maximum-second-factor-count-exceeded\" /* AuthErrorCode.SECOND_FACTOR_LIMIT_EXCEEDED */]: 'The maximum allowed number of second factors on a user has been exceeded.',\r\n        [\"tenant-id-mismatch\" /* AuthErrorCode.TENANT_ID_MISMATCH */]: \"The provided tenant ID does not match the Auth instance's tenant ID\",\r\n        [\"timeout\" /* AuthErrorCode.TIMEOUT */]: 'The operation has timed out.',\r\n        [\"user-token-expired\" /* AuthErrorCode.TOKEN_EXPIRED */]: \"The user's credential is no longer valid. The user must sign in again.\",\r\n        [\"too-many-requests\" /* AuthErrorCode.TOO_MANY_ATTEMPTS_TRY_LATER */]: 'We have blocked all requests from this device due to unusual activity. ' +\r\n            'Try again later.',\r\n        [\"unauthorized-continue-uri\" /* AuthErrorCode.UNAUTHORIZED_DOMAIN */]: 'The domain of the continue URL is not whitelisted.  Please whitelist ' +\r\n            'the domain in the Firebase console.',\r\n        [\"unsupported-first-factor\" /* AuthErrorCode.UNSUPPORTED_FIRST_FACTOR */]: 'Enrolling a second factor or signing in with a multi-factor account requires sign-in with a supported first factor.',\r\n        [\"unsupported-persistence-type\" /* AuthErrorCode.UNSUPPORTED_PERSISTENCE */]: 'The current environment does not support the specified persistence type.',\r\n        [\"unsupported-tenant-operation\" /* AuthErrorCode.UNSUPPORTED_TENANT_OPERATION */]: 'This operation is not supported in a multi-tenant context.',\r\n        [\"unverified-email\" /* AuthErrorCode.UNVERIFIED_EMAIL */]: 'The operation requires a verified email.',\r\n        [\"user-cancelled\" /* AuthErrorCode.USER_CANCELLED */]: 'The user did not grant your application the permissions it requested.',\r\n        [\"user-not-found\" /* AuthErrorCode.USER_DELETED */]: 'There is no user record corresponding to this identifier. The user may ' +\r\n            'have been deleted.',\r\n        [\"user-disabled\" /* AuthErrorCode.USER_DISABLED */]: 'The user account has been disabled by an administrator.',\r\n        [\"user-mismatch\" /* AuthErrorCode.USER_MISMATCH */]: 'The supplied credentials do not correspond to the previously signed in user.',\r\n        [\"user-signed-out\" /* AuthErrorCode.USER_SIGNED_OUT */]: '',\r\n        [\"weak-password\" /* AuthErrorCode.WEAK_PASSWORD */]: 'The password must be 6 characters long or more.',\r\n        [\"web-storage-unsupported\" /* AuthErrorCode.WEB_STORAGE_UNSUPPORTED */]: 'This browser is not supported or 3rd party cookies and data may be disabled.',\r\n        [\"already-initialized\" /* AuthErrorCode.ALREADY_INITIALIZED */]: 'initializeAuth() has already been called with ' +\r\n            'different options. To avoid this error, call initializeAuth() with the ' +\r\n            'same options as when it was originally called, or call getAuth() to return the' +\r\n            ' already initialized instance.',\r\n        [\"missing-recaptcha-token\" /* AuthErrorCode.MISSING_RECAPTCHA_TOKEN */]: 'The reCAPTCHA token is missing when sending request to the backend.',\r\n        [\"invalid-recaptcha-token\" /* AuthErrorCode.INVALID_RECAPTCHA_TOKEN */]: 'The reCAPTCHA token is invalid when sending request to the backend.',\r\n        [\"invalid-recaptcha-action\" /* AuthErrorCode.INVALID_RECAPTCHA_ACTION */]: 'The reCAPTCHA action is invalid when sending request to the backend.',\r\n        [\"recaptcha-not-enabled\" /* AuthErrorCode.RECAPTCHA_NOT_ENABLED */]: 'reCAPTCHA Enterprise integration is not enabled for this project.',\r\n        [\"missing-client-type\" /* AuthErrorCode.MISSING_CLIENT_TYPE */]: 'The reCAPTCHA client type is missing when sending request to the backend.',\r\n        [\"missing-recaptcha-version\" /* AuthErrorCode.MISSING_RECAPTCHA_VERSION */]: 'The reCAPTCHA version is missing when sending request to the backend.',\r\n        [\"invalid-req-type\" /* AuthErrorCode.INVALID_REQ_TYPE */]: 'Invalid request parameters.',\r\n        [\"invalid-recaptcha-version\" /* AuthErrorCode.INVALID_RECAPTCHA_VERSION */]: 'The reCAPTCHA version is invalid when sending request to the backend.',\r\n        [\"unsupported-password-policy-schema-version\" /* AuthErrorCode.UNSUPPORTED_PASSWORD_POLICY_SCHEMA_VERSION */]: 'The password policy received from the backend uses a schema version that is not supported by this version of the Firebase SDK.',\r\n        [\"password-does-not-meet-requirements\" /* AuthErrorCode.PASSWORD_DOES_NOT_MEET_REQUIREMENTS */]: 'The password does not meet the requirements.'\r\n    };\r\n}\r\nfunction _prodErrorMap() {\r\n    // We will include this one message in the prod error map since by the very\r\n    // nature of this error, developers will never be able to see the message\r\n    // using the debugErrorMap (which is installed during auth initialization).\r\n    return {\r\n        [\"dependent-sdk-initialized-before-auth\" /* AuthErrorCode.DEPENDENT_SDK_INIT_BEFORE_AUTH */]: 'Another Firebase SDK was initialized and is trying to use Auth before Auth is ' +\r\n            'initialized. Please be sure to call `initializeAuth` or `getAuth` before ' +\r\n            'starting any other Firebase SDK.'\r\n    };\r\n}\r\n/**\r\n * A verbose error map with detailed descriptions for most error codes.\r\n *\r\n * See discussion at {@link AuthErrorMap}\r\n *\r\n * @public\r\n */\r\nconst debugErrorMap = _debugErrorMap;\r\n/**\r\n * A minimal error map with all verbose error messages stripped.\r\n *\r\n * See discussion at {@link AuthErrorMap}\r\n *\r\n * @public\r\n */\r\nconst prodErrorMap = _prodErrorMap;\r\nconst _DEFAULT_AUTH_ERROR_FACTORY = new _firebase_util__WEBPACK_IMPORTED_MODULE_0__.ErrorFactory('auth', 'Firebase', _prodErrorMap());\r\n/**\r\n * A map of potential `Auth` error codes, for easier comparison with errors\r\n * thrown by the SDK.\r\n *\r\n * @remarks\r\n * Note that you can't tree-shake individual keys\r\n * in the map, so by using the map you might substantially increase your\r\n * bundle size.\r\n *\r\n * @public\r\n */\r\nconst AUTH_ERROR_CODES_MAP_DO_NOT_USE_INTERNALLY = {\r\n    ADMIN_ONLY_OPERATION: 'auth/admin-restricted-operation',\r\n    ARGUMENT_ERROR: 'auth/argument-error',\r\n    APP_NOT_AUTHORIZED: 'auth/app-not-authorized',\r\n    APP_NOT_INSTALLED: 'auth/app-not-installed',\r\n    CAPTCHA_CHECK_FAILED: 'auth/captcha-check-failed',\r\n    CODE_EXPIRED: 'auth/code-expired',\r\n    CORDOVA_NOT_READY: 'auth/cordova-not-ready',\r\n    CORS_UNSUPPORTED: 'auth/cors-unsupported',\r\n    CREDENTIAL_ALREADY_IN_USE: 'auth/credential-already-in-use',\r\n    CREDENTIAL_MISMATCH: 'auth/custom-token-mismatch',\r\n    CREDENTIAL_TOO_OLD_LOGIN_AGAIN: 'auth/requires-recent-login',\r\n    DEPENDENT_SDK_INIT_BEFORE_AUTH: 'auth/dependent-sdk-initialized-before-auth',\r\n    DYNAMIC_LINK_NOT_ACTIVATED: 'auth/dynamic-link-not-activated',\r\n    EMAIL_CHANGE_NEEDS_VERIFICATION: 'auth/email-change-needs-verification',\r\n    EMAIL_EXISTS: 'auth/email-already-in-use',\r\n    EMULATOR_CONFIG_FAILED: 'auth/emulator-config-failed',\r\n    EXPIRED_OOB_CODE: 'auth/expired-action-code',\r\n    EXPIRED_POPUP_REQUEST: 'auth/cancelled-popup-request',\r\n    INTERNAL_ERROR: 'auth/internal-error',\r\n    INVALID_API_KEY: 'auth/invalid-api-key',\r\n    INVALID_APP_CREDENTIAL: 'auth/invalid-app-credential',\r\n    INVALID_APP_ID: 'auth/invalid-app-id',\r\n    INVALID_AUTH: 'auth/invalid-user-token',\r\n    INVALID_AUTH_EVENT: 'auth/invalid-auth-event',\r\n    INVALID_CERT_HASH: 'auth/invalid-cert-hash',\r\n    INVALID_CODE: 'auth/invalid-verification-code',\r\n    INVALID_CONTINUE_URI: 'auth/invalid-continue-uri',\r\n    INVALID_CORDOVA_CONFIGURATION: 'auth/invalid-cordova-configuration',\r\n    INVALID_CUSTOM_TOKEN: 'auth/invalid-custom-token',\r\n    INVALID_DYNAMIC_LINK_DOMAIN: 'auth/invalid-dynamic-link-domain',\r\n    INVALID_EMAIL: 'auth/invalid-email',\r\n    INVALID_EMULATOR_SCHEME: 'auth/invalid-emulator-scheme',\r\n    INVALID_IDP_RESPONSE: 'auth/invalid-credential',\r\n    INVALID_LOGIN_CREDENTIALS: 'auth/invalid-credential',\r\n    INVALID_MESSAGE_PAYLOAD: 'auth/invalid-message-payload',\r\n    INVALID_MFA_SESSION: 'auth/invalid-multi-factor-session',\r\n    INVALID_OAUTH_CLIENT_ID: 'auth/invalid-oauth-client-id',\r\n    INVALID_OAUTH_PROVIDER: 'auth/invalid-oauth-provider',\r\n    INVALID_OOB_CODE: 'auth/invalid-action-code',\r\n    INVALID_ORIGIN: 'auth/unauthorized-domain',\r\n    INVALID_PASSWORD: 'auth/wrong-password',\r\n    INVALID_PERSISTENCE: 'auth/invalid-persistence-type',\r\n    INVALID_PHONE_NUMBER: 'auth/invalid-phone-number',\r\n    INVALID_PROVIDER_ID: 'auth/invalid-provider-id',\r\n    INVALID_RECIPIENT_EMAIL: 'auth/invalid-recipient-email',\r\n    INVALID_SENDER: 'auth/invalid-sender',\r\n    INVALID_SESSION_INFO: 'auth/invalid-verification-id',\r\n    INVALID_TENANT_ID: 'auth/invalid-tenant-id',\r\n    MFA_INFO_NOT_FOUND: 'auth/multi-factor-info-not-found',\r\n    MFA_REQUIRED: 'auth/multi-factor-auth-required',\r\n    MISSING_ANDROID_PACKAGE_NAME: 'auth/missing-android-pkg-name',\r\n    MISSING_APP_CREDENTIAL: 'auth/missing-app-credential',\r\n    MISSING_AUTH_DOMAIN: 'auth/auth-domain-config-required',\r\n    MISSING_CODE: 'auth/missing-verification-code',\r\n    MISSING_CONTINUE_URI: 'auth/missing-continue-uri',\r\n    MISSING_IFRAME_START: 'auth/missing-iframe-start',\r\n    MISSING_IOS_BUNDLE_ID: 'auth/missing-ios-bundle-id',\r\n    MISSING_OR_INVALID_NONCE: 'auth/missing-or-invalid-nonce',\r\n    MISSING_MFA_INFO: 'auth/missing-multi-factor-info',\r\n    MISSING_MFA_SESSION: 'auth/missing-multi-factor-session',\r\n    MISSING_PHONE_NUMBER: 'auth/missing-phone-number',\r\n    MISSING_SESSION_INFO: 'auth/missing-verification-id',\r\n    MODULE_DESTROYED: 'auth/app-deleted',\r\n    NEED_CONFIRMATION: 'auth/account-exists-with-different-credential',\r\n    NETWORK_REQUEST_FAILED: 'auth/network-request-failed',\r\n    NULL_USER: 'auth/null-user',\r\n    NO_AUTH_EVENT: 'auth/no-auth-event',\r\n    NO_SUCH_PROVIDER: 'auth/no-such-provider',\r\n    OPERATION_NOT_ALLOWED: 'auth/operation-not-allowed',\r\n    OPERATION_NOT_SUPPORTED: 'auth/operation-not-supported-in-this-environment',\r\n    POPUP_BLOCKED: 'auth/popup-blocked',\r\n    POPUP_CLOSED_BY_USER: 'auth/popup-closed-by-user',\r\n    PROVIDER_ALREADY_LINKED: 'auth/provider-already-linked',\r\n    QUOTA_EXCEEDED: 'auth/quota-exceeded',\r\n    REDIRECT_CANCELLED_BY_USER: 'auth/redirect-cancelled-by-user',\r\n    REDIRECT_OPERATION_PENDING: 'auth/redirect-operation-pending',\r\n    REJECTED_CREDENTIAL: 'auth/rejected-credential',\r\n    SECOND_FACTOR_ALREADY_ENROLLED: 'auth/second-factor-already-in-use',\r\n    SECOND_FACTOR_LIMIT_EXCEEDED: 'auth/maximum-second-factor-count-exceeded',\r\n    TENANT_ID_MISMATCH: 'auth/tenant-id-mismatch',\r\n    TIMEOUT: 'auth/timeout',\r\n    TOKEN_EXPIRED: 'auth/user-token-expired',\r\n    TOO_MANY_ATTEMPTS_TRY_LATER: 'auth/too-many-requests',\r\n    UNAUTHORIZED_DOMAIN: 'auth/unauthorized-continue-uri',\r\n    UNSUPPORTED_FIRST_FACTOR: 'auth/unsupported-first-factor',\r\n    UNSUPPORTED_PERSISTENCE: 'auth/unsupported-persistence-type',\r\n    UNSUPPORTED_TENANT_OPERATION: 'auth/unsupported-tenant-operation',\r\n    UNVERIFIED_EMAIL: 'auth/unverified-email',\r\n    USER_CANCELLED: 'auth/user-cancelled',\r\n    USER_DELETED: 'auth/user-not-found',\r\n    USER_DISABLED: 'auth/user-disabled',\r\n    USER_MISMATCH: 'auth/user-mismatch',\r\n    USER_SIGNED_OUT: 'auth/user-signed-out',\r\n    WEAK_PASSWORD: 'auth/weak-password',\r\n    WEB_STORAGE_UNSUPPORTED: 'auth/web-storage-unsupported',\r\n    ALREADY_INITIALIZED: 'auth/already-initialized',\r\n    RECAPTCHA_NOT_ENABLED: 'auth/recaptcha-not-enabled',\r\n    MISSING_RECAPTCHA_TOKEN: 'auth/missing-recaptcha-token',\r\n    INVALID_RECAPTCHA_TOKEN: 'auth/invalid-recaptcha-token',\r\n    INVALID_RECAPTCHA_ACTION: 'auth/invalid-recaptcha-action',\r\n    MISSING_CLIENT_TYPE: 'auth/missing-client-type',\r\n    MISSING_RECAPTCHA_VERSION: 'auth/missing-recaptcha-version',\r\n    INVALID_RECAPTCHA_VERSION: 'auth/invalid-recaptcha-version',\r\n    INVALID_REQ_TYPE: 'auth/invalid-req-type'\r\n};\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst logClient = new _firebase_logger__WEBPACK_IMPORTED_MODULE_4__.Logger('@firebase/auth');\r\nfunction _logWarn(msg, ...args) {\r\n    if (logClient.logLevel <= _firebase_logger__WEBPACK_IMPORTED_MODULE_4__.LogLevel.WARN) {\r\n        logClient.warn(`Auth (${_firebase_app__WEBPACK_IMPORTED_MODULE_1__.SDK_VERSION}): ${msg}`, ...args);\r\n    }\r\n}\r\nfunction _logError(msg, ...args) {\r\n    if (logClient.logLevel <= _firebase_logger__WEBPACK_IMPORTED_MODULE_4__.LogLevel.ERROR) {\r\n        logClient.error(`Auth (${_firebase_app__WEBPACK_IMPORTED_MODULE_1__.SDK_VERSION}): ${msg}`, ...args);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction _fail(authOrCode, ...rest) {\r\n    throw createErrorInternal(authOrCode, ...rest);\r\n}\r\nfunction _createError(authOrCode, ...rest) {\r\n    return createErrorInternal(authOrCode, ...rest);\r\n}\r\nfunction _errorWithCustomMessage(auth, code, message) {\r\n    const errorMap = Object.assign(Object.assign({}, prodErrorMap()), { [code]: message });\r\n    const factory = new _firebase_util__WEBPACK_IMPORTED_MODULE_0__.ErrorFactory('auth', 'Firebase', errorMap);\r\n    return factory.create(code, {\r\n        appName: auth.name\r\n    });\r\n}\r\nfunction createErrorInternal(authOrCode, ...rest) {\r\n    if (typeof authOrCode !== 'string') {\r\n        const code = rest[0];\r\n        const fullParams = [...rest.slice(1)];\r\n        if (fullParams[0]) {\r\n            fullParams[0].appName = authOrCode.name;\r\n        }\r\n        return authOrCode._errorFactory.create(code, ...fullParams);\r\n    }\r\n    return _DEFAULT_AUTH_ERROR_FACTORY.create(authOrCode, ...rest);\r\n}\r\nfunction _assert(assertion, authOrCode, ...rest) {\r\n    if (!assertion) {\r\n        throw createErrorInternal(authOrCode, ...rest);\r\n    }\r\n}\r\n/**\r\n * Unconditionally fails, throwing an internal error with the given message.\r\n *\r\n * @param failure type of failure encountered\r\n * @throws Error\r\n */\r\nfunction debugFail(failure) {\r\n    // Log the failure in addition to throw an exception, just in case the\r\n    // exception is swallowed.\r\n    const message = `INTERNAL ASSERTION FAILED: ` + failure;\r\n    _logError(message);\r\n    // NOTE: We don't use FirebaseError here because these are internal failures\r\n    // that cannot be handled by the user. (Also it would create a circular\r\n    // dependency between the error and assert modules which doesn't work.)\r\n    throw new Error(message);\r\n}\r\n/**\r\n * Fails if the given assertion condition is false, throwing an Error with the\r\n * given message if it did.\r\n *\r\n * @param assertion\r\n * @param message\r\n */\r\nfunction debugAssert(assertion, message) {\r\n    if (!assertion) {\r\n        debugFail(message);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction _getCurrentUrl() {\r\n    var _a;\r\n    return (typeof self !== 'undefined' && ((_a = self.location) === null || _a === void 0 ? void 0 : _a.href)) || '';\r\n}\r\nfunction _isHttpOrHttps() {\r\n    return _getCurrentScheme() === 'http:' || _getCurrentScheme() === 'https:';\r\n}\r\nfunction _getCurrentScheme() {\r\n    var _a;\r\n    return (typeof self !== 'undefined' && ((_a = self.location) === null || _a === void 0 ? void 0 : _a.protocol)) || null;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Determine whether the browser is working online\r\n */\r\nfunction _isOnline() {\r\n    if (typeof navigator !== 'undefined' &&\r\n        navigator &&\r\n        'onLine' in navigator &&\r\n        typeof navigator.onLine === 'boolean' &&\r\n        // Apply only for traditional web apps and Chrome extensions.\r\n        // This is especially true for Cordova apps which have unreliable\r\n        // navigator.onLine behavior unless cordova-plugin-network-information is\r\n        // installed which overwrites the native navigator.onLine value and\r\n        // defines navigator.connection.\r\n        (_isHttpOrHttps() || (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.isBrowserExtension)() || 'connection' in navigator)) {\r\n        return navigator.onLine;\r\n    }\r\n    // If we can't determine the state, assume it is online.\r\n    return true;\r\n}\r\nfunction _getUserLanguage() {\r\n    if (typeof navigator === 'undefined') {\r\n        return null;\r\n    }\r\n    const navigatorLanguage = navigator;\r\n    return (\r\n    // Most reliable, but only supported in Chrome/Firefox.\r\n    (navigatorLanguage.languages && navigatorLanguage.languages[0]) ||\r\n        // Supported in most browsers, but returns the language of the browser\r\n        // UI, not the language set in browser settings.\r\n        navigatorLanguage.language ||\r\n        // Couldn't determine language.\r\n        null);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * A structure to help pick between a range of long and short delay durations\r\n * depending on the current environment. In general, the long delay is used for\r\n * mobile environments whereas short delays are used for desktop environments.\r\n */\r\nclass Delay {\r\n    constructor(shortDelay, longDelay) {\r\n        this.shortDelay = shortDelay;\r\n        this.longDelay = longDelay;\r\n        // Internal error when improperly initialized.\r\n        debugAssert(longDelay > shortDelay, 'Short delay should be less than long delay!');\r\n        this.isMobile = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.isMobileCordova)() || (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.isReactNative)();\r\n    }\r\n    get() {\r\n        if (!_isOnline()) {\r\n            // Pick the shorter timeout.\r\n            return Math.min(5000 /* DelayMin.OFFLINE */, this.shortDelay);\r\n        }\r\n        // If running in a mobile environment, return the long delay, otherwise\r\n        // return the short delay.\r\n        // This could be improved in the future to dynamically change based on other\r\n        // variables instead of just reading the current environment.\r\n        return this.isMobile ? this.longDelay : this.shortDelay;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction _emulatorUrl(config, path) {\r\n    debugAssert(config.emulator, 'Emulator should always be set here');\r\n    const { url } = config.emulator;\r\n    if (!path) {\r\n        return url;\r\n    }\r\n    return `${url}${path.startsWith('/') ? path.slice(1) : path}`;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass FetchProvider {\r\n    static initialize(fetchImpl, headersImpl, responseImpl) {\r\n        this.fetchImpl = fetchImpl;\r\n        if (headersImpl) {\r\n            this.headersImpl = headersImpl;\r\n        }\r\n        if (responseImpl) {\r\n            this.responseImpl = responseImpl;\r\n        }\r\n    }\r\n    static fetch() {\r\n        if (this.fetchImpl) {\r\n            return this.fetchImpl;\r\n        }\r\n        if (typeof self !== 'undefined' && 'fetch' in self) {\r\n            return self.fetch;\r\n        }\r\n        if (typeof globalThis !== 'undefined' && globalThis.fetch) {\r\n            return globalThis.fetch;\r\n        }\r\n        if (typeof fetch !== 'undefined') {\r\n            return fetch;\r\n        }\r\n        debugFail('Could not find fetch implementation, make sure you call FetchProvider.initialize() with an appropriate polyfill');\r\n    }\r\n    static headers() {\r\n        if (this.headersImpl) {\r\n            return this.headersImpl;\r\n        }\r\n        if (typeof self !== 'undefined' && 'Headers' in self) {\r\n            return self.Headers;\r\n        }\r\n        if (typeof globalThis !== 'undefined' && globalThis.Headers) {\r\n            return globalThis.Headers;\r\n        }\r\n        if (typeof Headers !== 'undefined') {\r\n            return Headers;\r\n        }\r\n        debugFail('Could not find Headers implementation, make sure you call FetchProvider.initialize() with an appropriate polyfill');\r\n    }\r\n    static response() {\r\n        if (this.responseImpl) {\r\n            return this.responseImpl;\r\n        }\r\n        if (typeof self !== 'undefined' && 'Response' in self) {\r\n            return self.Response;\r\n        }\r\n        if (typeof globalThis !== 'undefined' && globalThis.Response) {\r\n            return globalThis.Response;\r\n        }\r\n        if (typeof Response !== 'undefined') {\r\n            return Response;\r\n        }\r\n        debugFail('Could not find Response implementation, make sure you call FetchProvider.initialize() with an appropriate polyfill');\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Map from errors returned by the server to errors to developer visible errors\r\n */\r\nconst SERVER_ERROR_MAP = {\r\n    // Custom token errors.\r\n    [\"CREDENTIAL_MISMATCH\" /* ServerError.CREDENTIAL_MISMATCH */]: \"custom-token-mismatch\" /* AuthErrorCode.CREDENTIAL_MISMATCH */,\r\n    // This can only happen if the SDK sends a bad request.\r\n    [\"MISSING_CUSTOM_TOKEN\" /* ServerError.MISSING_CUSTOM_TOKEN */]: \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */,\r\n    // Create Auth URI errors.\r\n    [\"INVALID_IDENTIFIER\" /* ServerError.INVALID_IDENTIFIER */]: \"invalid-email\" /* AuthErrorCode.INVALID_EMAIL */,\r\n    // This can only happen if the SDK sends a bad request.\r\n    [\"MISSING_CONTINUE_URI\" /* ServerError.MISSING_CONTINUE_URI */]: \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */,\r\n    // Sign in with email and password errors (some apply to sign up too).\r\n    [\"INVALID_PASSWORD\" /* ServerError.INVALID_PASSWORD */]: \"wrong-password\" /* AuthErrorCode.INVALID_PASSWORD */,\r\n    // This can only happen if the SDK sends a bad request.\r\n    [\"MISSING_PASSWORD\" /* ServerError.MISSING_PASSWORD */]: \"missing-password\" /* AuthErrorCode.MISSING_PASSWORD */,\r\n    // Thrown if Email Enumeration Protection is enabled in the project and the email or password is\r\n    // invalid.\r\n    [\"INVALID_LOGIN_CREDENTIALS\" /* ServerError.INVALID_LOGIN_CREDENTIALS */]: \"invalid-credential\" /* AuthErrorCode.INVALID_CREDENTIAL */,\r\n    // Sign up with email and password errors.\r\n    [\"EMAIL_EXISTS\" /* ServerError.EMAIL_EXISTS */]: \"email-already-in-use\" /* AuthErrorCode.EMAIL_EXISTS */,\r\n    [\"PASSWORD_LOGIN_DISABLED\" /* ServerError.PASSWORD_LOGIN_DISABLED */]: \"operation-not-allowed\" /* AuthErrorCode.OPERATION_NOT_ALLOWED */,\r\n    // Verify assertion for sign in with credential errors:\r\n    [\"INVALID_IDP_RESPONSE\" /* ServerError.INVALID_IDP_RESPONSE */]: \"invalid-credential\" /* AuthErrorCode.INVALID_CREDENTIAL */,\r\n    [\"INVALID_PENDING_TOKEN\" /* ServerError.INVALID_PENDING_TOKEN */]: \"invalid-credential\" /* AuthErrorCode.INVALID_CREDENTIAL */,\r\n    [\"FEDERATED_USER_ID_ALREADY_LINKED\" /* ServerError.FEDERATED_USER_ID_ALREADY_LINKED */]: \"credential-already-in-use\" /* AuthErrorCode.CREDENTIAL_ALREADY_IN_USE */,\r\n    // This can only happen if the SDK sends a bad request.\r\n    [\"MISSING_REQ_TYPE\" /* ServerError.MISSING_REQ_TYPE */]: \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */,\r\n    // Send Password reset email errors:\r\n    [\"EMAIL_NOT_FOUND\" /* ServerError.EMAIL_NOT_FOUND */]: \"user-not-found\" /* AuthErrorCode.USER_DELETED */,\r\n    [\"RESET_PASSWORD_EXCEED_LIMIT\" /* ServerError.RESET_PASSWORD_EXCEED_LIMIT */]: \"too-many-requests\" /* AuthErrorCode.TOO_MANY_ATTEMPTS_TRY_LATER */,\r\n    [\"EXPIRED_OOB_CODE\" /* ServerError.EXPIRED_OOB_CODE */]: \"expired-action-code\" /* AuthErrorCode.EXPIRED_OOB_CODE */,\r\n    [\"INVALID_OOB_CODE\" /* ServerError.INVALID_OOB_CODE */]: \"invalid-action-code\" /* AuthErrorCode.INVALID_OOB_CODE */,\r\n    // This can only happen if the SDK sends a bad request.\r\n    [\"MISSING_OOB_CODE\" /* ServerError.MISSING_OOB_CODE */]: \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */,\r\n    // Operations that require ID token in request:\r\n    [\"CREDENTIAL_TOO_OLD_LOGIN_AGAIN\" /* ServerError.CREDENTIAL_TOO_OLD_LOGIN_AGAIN */]: \"requires-recent-login\" /* AuthErrorCode.CREDENTIAL_TOO_OLD_LOGIN_AGAIN */,\r\n    [\"INVALID_ID_TOKEN\" /* ServerError.INVALID_ID_TOKEN */]: \"invalid-user-token\" /* AuthErrorCode.INVALID_AUTH */,\r\n    [\"TOKEN_EXPIRED\" /* ServerError.TOKEN_EXPIRED */]: \"user-token-expired\" /* AuthErrorCode.TOKEN_EXPIRED */,\r\n    [\"USER_NOT_FOUND\" /* ServerError.USER_NOT_FOUND */]: \"user-token-expired\" /* AuthErrorCode.TOKEN_EXPIRED */,\r\n    // Other errors.\r\n    [\"TOO_MANY_ATTEMPTS_TRY_LATER\" /* ServerError.TOO_MANY_ATTEMPTS_TRY_LATER */]: \"too-many-requests\" /* AuthErrorCode.TOO_MANY_ATTEMPTS_TRY_LATER */,\r\n    [\"PASSWORD_DOES_NOT_MEET_REQUIREMENTS\" /* ServerError.PASSWORD_DOES_NOT_MEET_REQUIREMENTS */]: \"password-does-not-meet-requirements\" /* AuthErrorCode.PASSWORD_DOES_NOT_MEET_REQUIREMENTS */,\r\n    // Phone Auth related errors.\r\n    [\"INVALID_CODE\" /* ServerError.INVALID_CODE */]: \"invalid-verification-code\" /* AuthErrorCode.INVALID_CODE */,\r\n    [\"INVALID_SESSION_INFO\" /* ServerError.INVALID_SESSION_INFO */]: \"invalid-verification-id\" /* AuthErrorCode.INVALID_SESSION_INFO */,\r\n    [\"INVALID_TEMPORARY_PROOF\" /* ServerError.INVALID_TEMPORARY_PROOF */]: \"invalid-credential\" /* AuthErrorCode.INVALID_CREDENTIAL */,\r\n    [\"MISSING_SESSION_INFO\" /* ServerError.MISSING_SESSION_INFO */]: \"missing-verification-id\" /* AuthErrorCode.MISSING_SESSION_INFO */,\r\n    [\"SESSION_EXPIRED\" /* ServerError.SESSION_EXPIRED */]: \"code-expired\" /* AuthErrorCode.CODE_EXPIRED */,\r\n    // Other action code errors when additional settings passed.\r\n    // MISSING_CONTINUE_URI is getting mapped to INTERNAL_ERROR above.\r\n    // This is OK as this error will be caught by client side validation.\r\n    [\"MISSING_ANDROID_PACKAGE_NAME\" /* ServerError.MISSING_ANDROID_PACKAGE_NAME */]: \"missing-android-pkg-name\" /* AuthErrorCode.MISSING_ANDROID_PACKAGE_NAME */,\r\n    [\"UNAUTHORIZED_DOMAIN\" /* ServerError.UNAUTHORIZED_DOMAIN */]: \"unauthorized-continue-uri\" /* AuthErrorCode.UNAUTHORIZED_DOMAIN */,\r\n    // getProjectConfig errors when clientId is passed.\r\n    [\"INVALID_OAUTH_CLIENT_ID\" /* ServerError.INVALID_OAUTH_CLIENT_ID */]: \"invalid-oauth-client-id\" /* AuthErrorCode.INVALID_OAUTH_CLIENT_ID */,\r\n    // User actions (sign-up or deletion) disabled errors.\r\n    [\"ADMIN_ONLY_OPERATION\" /* ServerError.ADMIN_ONLY_OPERATION */]: \"admin-restricted-operation\" /* AuthErrorCode.ADMIN_ONLY_OPERATION */,\r\n    // Multi factor related errors.\r\n    [\"INVALID_MFA_PENDING_CREDENTIAL\" /* ServerError.INVALID_MFA_PENDING_CREDENTIAL */]: \"invalid-multi-factor-session\" /* AuthErrorCode.INVALID_MFA_SESSION */,\r\n    [\"MFA_ENROLLMENT_NOT_FOUND\" /* ServerError.MFA_ENROLLMENT_NOT_FOUND */]: \"multi-factor-info-not-found\" /* AuthErrorCode.MFA_INFO_NOT_FOUND */,\r\n    [\"MISSING_MFA_ENROLLMENT_ID\" /* ServerError.MISSING_MFA_ENROLLMENT_ID */]: \"missing-multi-factor-info\" /* AuthErrorCode.MISSING_MFA_INFO */,\r\n    [\"MISSING_MFA_PENDING_CREDENTIAL\" /* ServerError.MISSING_MFA_PENDING_CREDENTIAL */]: \"missing-multi-factor-session\" /* AuthErrorCode.MISSING_MFA_SESSION */,\r\n    [\"SECOND_FACTOR_EXISTS\" /* ServerError.SECOND_FACTOR_EXISTS */]: \"second-factor-already-in-use\" /* AuthErrorCode.SECOND_FACTOR_ALREADY_ENROLLED */,\r\n    [\"SECOND_FACTOR_LIMIT_EXCEEDED\" /* ServerError.SECOND_FACTOR_LIMIT_EXCEEDED */]: \"maximum-second-factor-count-exceeded\" /* AuthErrorCode.SECOND_FACTOR_LIMIT_EXCEEDED */,\r\n    // Blocking functions related errors.\r\n    [\"BLOCKING_FUNCTION_ERROR_RESPONSE\" /* ServerError.BLOCKING_FUNCTION_ERROR_RESPONSE */]: \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */,\r\n    // Recaptcha related errors.\r\n    [\"RECAPTCHA_NOT_ENABLED\" /* ServerError.RECAPTCHA_NOT_ENABLED */]: \"recaptcha-not-enabled\" /* AuthErrorCode.RECAPTCHA_NOT_ENABLED */,\r\n    [\"MISSING_RECAPTCHA_TOKEN\" /* ServerError.MISSING_RECAPTCHA_TOKEN */]: \"missing-recaptcha-token\" /* AuthErrorCode.MISSING_RECAPTCHA_TOKEN */,\r\n    [\"INVALID_RECAPTCHA_TOKEN\" /* ServerError.INVALID_RECAPTCHA_TOKEN */]: \"invalid-recaptcha-token\" /* AuthErrorCode.INVALID_RECAPTCHA_TOKEN */,\r\n    [\"INVALID_RECAPTCHA_ACTION\" /* ServerError.INVALID_RECAPTCHA_ACTION */]: \"invalid-recaptcha-action\" /* AuthErrorCode.INVALID_RECAPTCHA_ACTION */,\r\n    [\"MISSING_CLIENT_TYPE\" /* ServerError.MISSING_CLIENT_TYPE */]: \"missing-client-type\" /* AuthErrorCode.MISSING_CLIENT_TYPE */,\r\n    [\"MISSING_RECAPTCHA_VERSION\" /* ServerError.MISSING_RECAPTCHA_VERSION */]: \"missing-recaptcha-version\" /* AuthErrorCode.MISSING_RECAPTCHA_VERSION */,\r\n    [\"INVALID_RECAPTCHA_VERSION\" /* ServerError.INVALID_RECAPTCHA_VERSION */]: \"invalid-recaptcha-version\" /* AuthErrorCode.INVALID_RECAPTCHA_VERSION */,\r\n    [\"INVALID_REQ_TYPE\" /* ServerError.INVALID_REQ_TYPE */]: \"invalid-req-type\" /* AuthErrorCode.INVALID_REQ_TYPE */\r\n};\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst DEFAULT_API_TIMEOUT_MS = new Delay(30000, 60000);\r\nfunction _addTidIfNecessary(auth, request) {\r\n    if (auth.tenantId && !request.tenantId) {\r\n        return Object.assign(Object.assign({}, request), { tenantId: auth.tenantId });\r\n    }\r\n    return request;\r\n}\r\nasync function _performApiRequest(auth, method, path, request, customErrorMap = {}) {\r\n    return _performFetchWithErrorHandling(auth, customErrorMap, async () => {\r\n        let body = {};\r\n        let params = {};\r\n        if (request) {\r\n            if (method === \"GET\" /* HttpMethod.GET */) {\r\n                params = request;\r\n            }\r\n            else {\r\n                body = {\r\n                    body: JSON.stringify(request)\r\n                };\r\n            }\r\n        }\r\n        const query = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystring)(Object.assign({ key: auth.config.apiKey }, params)).slice(1);\r\n        const headers = await auth._getAdditionalHeaders();\r\n        headers[\"Content-Type\" /* HttpHeader.CONTENT_TYPE */] = 'application/json';\r\n        if (auth.languageCode) {\r\n            headers[\"X-Firebase-Locale\" /* HttpHeader.X_FIREBASE_LOCALE */] = auth.languageCode;\r\n        }\r\n        return FetchProvider.fetch()(_getFinalTarget(auth, auth.config.apiHost, path, query), Object.assign({ method,\r\n            headers, referrerPolicy: 'no-referrer' }, body));\r\n    });\r\n}\r\nasync function _performFetchWithErrorHandling(auth, customErrorMap, fetchFn) {\r\n    auth._canInitEmulator = false;\r\n    const errorMap = Object.assign(Object.assign({}, SERVER_ERROR_MAP), customErrorMap);\r\n    try {\r\n        const networkTimeout = new NetworkTimeout(auth);\r\n        const response = await Promise.race([\r\n            fetchFn(),\r\n            networkTimeout.promise\r\n        ]);\r\n        // If we've reached this point, the fetch succeeded and the networkTimeout\r\n        // didn't throw; clear the network timeout delay so that Node won't hang\r\n        networkTimeout.clearNetworkTimeout();\r\n        const json = await response.json();\r\n        if ('needConfirmation' in json) {\r\n            throw _makeTaggedError(auth, \"account-exists-with-different-credential\" /* AuthErrorCode.NEED_CONFIRMATION */, json);\r\n        }\r\n        if (response.ok && !('errorMessage' in json)) {\r\n            return json;\r\n        }\r\n        else {\r\n            const errorMessage = response.ok ? json.errorMessage : json.error.message;\r\n            const [serverErrorCode, serverErrorMessage] = errorMessage.split(' : ');\r\n            if (serverErrorCode === \"FEDERATED_USER_ID_ALREADY_LINKED\" /* ServerError.FEDERATED_USER_ID_ALREADY_LINKED */) {\r\n                throw _makeTaggedError(auth, \"credential-already-in-use\" /* AuthErrorCode.CREDENTIAL_ALREADY_IN_USE */, json);\r\n            }\r\n            else if (serverErrorCode === \"EMAIL_EXISTS\" /* ServerError.EMAIL_EXISTS */) {\r\n                throw _makeTaggedError(auth, \"email-already-in-use\" /* AuthErrorCode.EMAIL_EXISTS */, json);\r\n            }\r\n            else if (serverErrorCode === \"USER_DISABLED\" /* ServerError.USER_DISABLED */) {\r\n                throw _makeTaggedError(auth, \"user-disabled\" /* AuthErrorCode.USER_DISABLED */, json);\r\n            }\r\n            const authError = errorMap[serverErrorCode] ||\r\n                serverErrorCode\r\n                    .toLowerCase()\r\n                    .replace(/[_\\s]+/g, '-');\r\n            if (serverErrorMessage) {\r\n                throw _errorWithCustomMessage(auth, authError, serverErrorMessage);\r\n            }\r\n            else {\r\n                _fail(auth, authError);\r\n            }\r\n        }\r\n    }\r\n    catch (e) {\r\n        if (e instanceof _firebase_util__WEBPACK_IMPORTED_MODULE_0__.FirebaseError) {\r\n            throw e;\r\n        }\r\n        // Changing this to a different error code will log user out when there is a network error\r\n        // because we treat any error other than NETWORK_REQUEST_FAILED as token is invalid.\r\n        // https://github.com/firebase/firebase-js-sdk/blob/4fbc73610d70be4e0852e7de63a39cb7897e8546/packages/auth/src/core/auth/auth_impl.ts#L309-L316\r\n        _fail(auth, \"network-request-failed\" /* AuthErrorCode.NETWORK_REQUEST_FAILED */, { 'message': String(e) });\r\n    }\r\n}\r\nasync function _performSignInRequest(auth, method, path, request, customErrorMap = {}) {\r\n    const serverResponse = (await _performApiRequest(auth, method, path, request, customErrorMap));\r\n    if ('mfaPendingCredential' in serverResponse) {\r\n        _fail(auth, \"multi-factor-auth-required\" /* AuthErrorCode.MFA_REQUIRED */, {\r\n            _serverResponse: serverResponse\r\n        });\r\n    }\r\n    return serverResponse;\r\n}\r\nfunction _getFinalTarget(auth, host, path, query) {\r\n    const base = `${host}${path}?${query}`;\r\n    if (!auth.config.emulator) {\r\n        return `${auth.config.apiScheme}://${base}`;\r\n    }\r\n    return _emulatorUrl(auth.config, base);\r\n}\r\nfunction _parseEnforcementState(enforcementStateStr) {\r\n    switch (enforcementStateStr) {\r\n        case 'ENFORCE':\r\n            return \"ENFORCE\" /* EnforcementState.ENFORCE */;\r\n        case 'AUDIT':\r\n            return \"AUDIT\" /* EnforcementState.AUDIT */;\r\n        case 'OFF':\r\n            return \"OFF\" /* EnforcementState.OFF */;\r\n        default:\r\n            return \"ENFORCEMENT_STATE_UNSPECIFIED\" /* EnforcementState.ENFORCEMENT_STATE_UNSPECIFIED */;\r\n    }\r\n}\r\nclass NetworkTimeout {\r\n    constructor(auth) {\r\n        this.auth = auth;\r\n        // Node timers and browser timers are fundamentally incompatible, but we\r\n        // don't care about the value here\r\n        // eslint-disable-next-line @typescript-eslint/no-explicit-any\r\n        this.timer = null;\r\n        this.promise = new Promise((_, reject) => {\r\n            this.timer = setTimeout(() => {\r\n                return reject(_createError(this.auth, \"network-request-failed\" /* AuthErrorCode.NETWORK_REQUEST_FAILED */));\r\n            }, DEFAULT_API_TIMEOUT_MS.get());\r\n        });\r\n    }\r\n    clearNetworkTimeout() {\r\n        clearTimeout(this.timer);\r\n    }\r\n}\r\nfunction _makeTaggedError(auth, code, response) {\r\n    const errorParams = {\r\n        appName: auth.name\r\n    };\r\n    if (response.email) {\r\n        errorParams.email = response.email;\r\n    }\r\n    if (response.phoneNumber) {\r\n        errorParams.phoneNumber = response.phoneNumber;\r\n    }\r\n    const error = _createError(auth, code, errorParams);\r\n    // We know customData is defined on error because errorParams is defined\r\n    error.customData._tokenResponse = response;\r\n    return error;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction isEnterprise(grecaptcha) {\r\n    return (grecaptcha !== undefined &&\r\n        grecaptcha.enterprise !== undefined);\r\n}\r\nclass RecaptchaConfig {\r\n    constructor(response) {\r\n        /**\r\n         * The reCAPTCHA site key.\r\n         */\r\n        this.siteKey = '';\r\n        /**\r\n         * The list of providers and their enablement status for reCAPTCHA Enterprise.\r\n         */\r\n        this.recaptchaEnforcementState = [];\r\n        if (response.recaptchaKey === undefined) {\r\n            throw new Error('recaptchaKey undefined');\r\n        }\r\n        // Example response.recaptchaKey: \"projects/proj123/keys/sitekey123\"\r\n        this.siteKey = response.recaptchaKey.split('/')[3];\r\n        this.recaptchaEnforcementState = response.recaptchaEnforcementState;\r\n    }\r\n    /**\r\n     * Returns the reCAPTCHA Enterprise enforcement state for the given provider.\r\n     *\r\n     * @param providerStr - The provider whose enforcement state is to be returned.\r\n     * @returns The reCAPTCHA Enterprise enforcement state for the given provider.\r\n     */\r\n    getProviderEnforcementState(providerStr) {\r\n        if (!this.recaptchaEnforcementState ||\r\n            this.recaptchaEnforcementState.length === 0) {\r\n            return null;\r\n        }\r\n        for (const recaptchaEnforcementState of this.recaptchaEnforcementState) {\r\n            if (recaptchaEnforcementState.provider &&\r\n                recaptchaEnforcementState.provider === providerStr) {\r\n                return _parseEnforcementState(recaptchaEnforcementState.enforcementState);\r\n            }\r\n        }\r\n        return null;\r\n    }\r\n    /**\r\n     * Returns true if the reCAPTCHA Enterprise enforcement state for the provider is set to ENFORCE or AUDIT.\r\n     *\r\n     * @param providerStr - The provider whose enablement state is to be returned.\r\n     * @returns Whether or not reCAPTCHA Enterprise protection is enabled for the given provider.\r\n     */\r\n    isProviderEnabled(providerStr) {\r\n        return (this.getProviderEnforcementState(providerStr) ===\r\n            \"ENFORCE\" /* EnforcementState.ENFORCE */ ||\r\n            this.getProviderEnforcementState(providerStr) === \"AUDIT\" /* EnforcementState.AUDIT */);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function getRecaptchaConfig(auth, request) {\r\n    return _performApiRequest(auth, \"GET\" /* HttpMethod.GET */, \"/v2/recaptchaConfig\" /* Endpoint.GET_RECAPTCHA_CONFIG */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function deleteAccount(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:delete\" /* Endpoint.DELETE_ACCOUNT */, request);\r\n}\r\nasync function deleteLinkedAccounts(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:update\" /* Endpoint.SET_ACCOUNT_INFO */, request);\r\n}\r\nasync function getAccountInfo(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:lookup\" /* Endpoint.GET_ACCOUNT_INFO */, request);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction utcTimestampToDateString(utcTimestamp) {\r\n    if (!utcTimestamp) {\r\n        return undefined;\r\n    }\r\n    try {\r\n        // Convert to date object.\r\n        const date = new Date(Number(utcTimestamp));\r\n        // Test date is valid.\r\n        if (!isNaN(date.getTime())) {\r\n            // Convert to UTC date string.\r\n            return date.toUTCString();\r\n        }\r\n    }\r\n    catch (e) {\r\n        // Do nothing. undefined will be returned.\r\n    }\r\n    return undefined;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Returns a JSON Web Token (JWT) used to identify the user to a Firebase service.\r\n *\r\n * @remarks\r\n * Returns the current token if it has not expired or if it will not expire in the next five\r\n * minutes. Otherwise, this will refresh the token and return a new one.\r\n *\r\n * @param user - The user.\r\n * @param forceRefresh - Force refresh regardless of token expiration.\r\n *\r\n * @public\r\n */\r\nfunction getIdToken(user, forceRefresh = false) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user).getIdToken(forceRefresh);\r\n}\r\n/**\r\n * Returns a deserialized JSON Web Token (JWT) used to identify the user to a Firebase service.\r\n *\r\n * @remarks\r\n * Returns the current token if it has not expired or if it will not expire in the next five\r\n * minutes. Otherwise, this will refresh the token and return a new one.\r\n *\r\n * @param user - The user.\r\n * @param forceRefresh - Force refresh regardless of token expiration.\r\n *\r\n * @public\r\n */\r\nasync function getIdTokenResult(user, forceRefresh = false) {\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    const token = await userInternal.getIdToken(forceRefresh);\r\n    const claims = _parseToken(token);\r\n    _assert(claims && claims.exp && claims.auth_time && claims.iat, userInternal.auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    const firebase = typeof claims.firebase === 'object' ? claims.firebase : undefined;\r\n    const signInProvider = firebase === null || firebase === void 0 ? void 0 : firebase['sign_in_provider'];\r\n    return {\r\n        claims,\r\n        token,\r\n        authTime: utcTimestampToDateString(secondsStringToMilliseconds(claims.auth_time)),\r\n        issuedAtTime: utcTimestampToDateString(secondsStringToMilliseconds(claims.iat)),\r\n        expirationTime: utcTimestampToDateString(secondsStringToMilliseconds(claims.exp)),\r\n        signInProvider: signInProvider || null,\r\n        signInSecondFactor: (firebase === null || firebase === void 0 ? void 0 : firebase['sign_in_second_factor']) || null\r\n    };\r\n}\r\nfunction secondsStringToMilliseconds(seconds) {\r\n    return Number(seconds) * 1000;\r\n}\r\nfunction _parseToken(token) {\r\n    const [algorithm, payload, signature] = token.split('.');\r\n    if (algorithm === undefined ||\r\n        payload === undefined ||\r\n        signature === undefined) {\r\n        _logError('JWT malformed, contained fewer than 3 sections');\r\n        return null;\r\n    }\r\n    try {\r\n        const decoded = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.base64Decode)(payload);\r\n        if (!decoded) {\r\n            _logError('Failed to decode base64 JWT payload');\r\n            return null;\r\n        }\r\n        return JSON.parse(decoded);\r\n    }\r\n    catch (e) {\r\n        _logError('Caught error parsing JWT payload as JSON', e === null || e === void 0 ? void 0 : e.toString());\r\n        return null;\r\n    }\r\n}\r\n/**\r\n * Extract expiresIn TTL from a token by subtracting the expiration from the issuance.\r\n */\r\nfunction _tokenExpiresIn(token) {\r\n    const parsedToken = _parseToken(token);\r\n    _assert(parsedToken, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    _assert(typeof parsedToken.exp !== 'undefined', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    _assert(typeof parsedToken.iat !== 'undefined', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    return Number(parsedToken.exp) - Number(parsedToken.iat);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function _logoutIfInvalidated(user, promise, bypassAuthState = false) {\r\n    if (bypassAuthState) {\r\n        return promise;\r\n    }\r\n    try {\r\n        return await promise;\r\n    }\r\n    catch (e) {\r\n        if (e instanceof _firebase_util__WEBPACK_IMPORTED_MODULE_0__.FirebaseError && isUserInvalidated(e)) {\r\n            if (user.auth.currentUser === user) {\r\n                await user.auth.signOut();\r\n            }\r\n        }\r\n        throw e;\r\n    }\r\n}\r\nfunction isUserInvalidated({ code }) {\r\n    return (code === `auth/${\"user-disabled\" /* AuthErrorCode.USER_DISABLED */}` ||\r\n        code === `auth/${\"user-token-expired\" /* AuthErrorCode.TOKEN_EXPIRED */}`);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass ProactiveRefresh {\r\n    constructor(user) {\r\n        this.user = user;\r\n        this.isRunning = false;\r\n        // Node timers and browser timers return fundamentally different types.\r\n        // We don't actually care what the value is but TS won't accept unknown and\r\n        // we can't cast properly in both environments.\r\n        // eslint-disable-next-line @typescript-eslint/no-explicit-any\r\n        this.timerId = null;\r\n        this.errorBackoff = 30000 /* Duration.RETRY_BACKOFF_MIN */;\r\n    }\r\n    _start() {\r\n        if (this.isRunning) {\r\n            return;\r\n        }\r\n        this.isRunning = true;\r\n        this.schedule();\r\n    }\r\n    _stop() {\r\n        if (!this.isRunning) {\r\n            return;\r\n        }\r\n        this.isRunning = false;\r\n        if (this.timerId !== null) {\r\n            clearTimeout(this.timerId);\r\n        }\r\n    }\r\n    getInterval(wasError) {\r\n        var _a;\r\n        if (wasError) {\r\n            const interval = this.errorBackoff;\r\n            this.errorBackoff = Math.min(this.errorBackoff * 2, 960000 /* Duration.RETRY_BACKOFF_MAX */);\r\n            return interval;\r\n        }\r\n        else {\r\n            // Reset the error backoff\r\n            this.errorBackoff = 30000 /* Duration.RETRY_BACKOFF_MIN */;\r\n            const expTime = (_a = this.user.stsTokenManager.expirationTime) !== null && _a !== void 0 ? _a : 0;\r\n            const interval = expTime - Date.now() - 300000 /* Duration.OFFSET */;\r\n            return Math.max(0, interval);\r\n        }\r\n    }\r\n    schedule(wasError = false) {\r\n        if (!this.isRunning) {\r\n            // Just in case...\r\n            return;\r\n        }\r\n        const interval = this.getInterval(wasError);\r\n        this.timerId = setTimeout(async () => {\r\n            await this.iteration();\r\n        }, interval);\r\n    }\r\n    async iteration() {\r\n        try {\r\n            await this.user.getIdToken(true);\r\n        }\r\n        catch (e) {\r\n            // Only retry on network errors\r\n            if ((e === null || e === void 0 ? void 0 : e.code) ===\r\n                `auth/${\"network-request-failed\" /* AuthErrorCode.NETWORK_REQUEST_FAILED */}`) {\r\n                this.schedule(/* wasError */ true);\r\n            }\r\n            return;\r\n        }\r\n        this.schedule();\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass UserMetadata {\r\n    constructor(createdAt, lastLoginAt) {\r\n        this.createdAt = createdAt;\r\n        this.lastLoginAt = lastLoginAt;\r\n        this._initializeTime();\r\n    }\r\n    _initializeTime() {\r\n        this.lastSignInTime = utcTimestampToDateString(this.lastLoginAt);\r\n        this.creationTime = utcTimestampToDateString(this.createdAt);\r\n    }\r\n    _copy(metadata) {\r\n        this.createdAt = metadata.createdAt;\r\n        this.lastLoginAt = metadata.lastLoginAt;\r\n        this._initializeTime();\r\n    }\r\n    toJSON() {\r\n        return {\r\n            createdAt: this.createdAt,\r\n            lastLoginAt: this.lastLoginAt\r\n        };\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function _reloadWithoutSaving(user) {\r\n    var _a;\r\n    const auth = user.auth;\r\n    const idToken = await user.getIdToken();\r\n    const response = await _logoutIfInvalidated(user, getAccountInfo(auth, { idToken }));\r\n    _assert(response === null || response === void 0 ? void 0 : response.users.length, auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    const coreAccount = response.users[0];\r\n    user._notifyReloadListener(coreAccount);\r\n    const newProviderData = ((_a = coreAccount.providerUserInfo) === null || _a === void 0 ? void 0 : _a.length)\r\n        ? extractProviderData(coreAccount.providerUserInfo)\r\n        : [];\r\n    const providerData = mergeProviderData(user.providerData, newProviderData);\r\n    // Preserves the non-nonymous status of the stored user, even if no more\r\n    // credentials (federated or email/password) are linked to the user. If\r\n    // the user was previously anonymous, then use provider data to update.\r\n    // On the other hand, if it was not anonymous before, it should never be\r\n    // considered anonymous now.\r\n    const oldIsAnonymous = user.isAnonymous;\r\n    const newIsAnonymous = !(user.email && coreAccount.passwordHash) && !(providerData === null || providerData === void 0 ? void 0 : providerData.length);\r\n    const isAnonymous = !oldIsAnonymous ? false : newIsAnonymous;\r\n    const updates = {\r\n        uid: coreAccount.localId,\r\n        displayName: coreAccount.displayName || null,\r\n        photoURL: coreAccount.photoUrl || null,\r\n        email: coreAccount.email || null,\r\n        emailVerified: coreAccount.emailVerified || false,\r\n        phoneNumber: coreAccount.phoneNumber || null,\r\n        tenantId: coreAccount.tenantId || null,\r\n        providerData,\r\n        metadata: new UserMetadata(coreAccount.createdAt, coreAccount.lastLoginAt),\r\n        isAnonymous\r\n    };\r\n    Object.assign(user, updates);\r\n}\r\n/**\r\n * Reloads user account data, if signed in.\r\n *\r\n * @param user - The user.\r\n *\r\n * @public\r\n */\r\nasync function reload(user) {\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    await _reloadWithoutSaving(userInternal);\r\n    // Even though the current user hasn't changed, update\r\n    // current user will trigger a persistence update w/ the\r\n    // new info.\r\n    await userInternal.auth._persistUserIfCurrent(userInternal);\r\n    userInternal.auth._notifyListenersIfCurrent(userInternal);\r\n}\r\nfunction mergeProviderData(original, newData) {\r\n    const deduped = original.filter(o => !newData.some(n => n.providerId === o.providerId));\r\n    return [...deduped, ...newData];\r\n}\r\nfunction extractProviderData(providers) {\r\n    return providers.map((_a) => {\r\n        var { providerId } = _a, provider = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__rest)(_a, [\"providerId\"]);\r\n        return {\r\n            providerId,\r\n            uid: provider.rawId || '',\r\n            displayName: provider.displayName || null,\r\n            email: provider.email || null,\r\n            phoneNumber: provider.phoneNumber || null,\r\n            photoURL: provider.photoUrl || null\r\n        };\r\n    });\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function requestStsToken(auth, refreshToken) {\r\n    const response = await _performFetchWithErrorHandling(auth, {}, async () => {\r\n        const body = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystring)({\r\n            'grant_type': 'refresh_token',\r\n            'refresh_token': refreshToken\r\n        }).slice(1);\r\n        const { tokenApiHost, apiKey } = auth.config;\r\n        const url = _getFinalTarget(auth, tokenApiHost, \"/v1/token\" /* Endpoint.TOKEN */, `key=${apiKey}`);\r\n        const headers = await auth._getAdditionalHeaders();\r\n        headers[\"Content-Type\" /* HttpHeader.CONTENT_TYPE */] = 'application/x-www-form-urlencoded';\r\n        return FetchProvider.fetch()(url, {\r\n            method: \"POST\" /* HttpMethod.POST */,\r\n            headers,\r\n            body\r\n        });\r\n    });\r\n    // The response comes back in snake_case. Convert to camel:\r\n    return {\r\n        accessToken: response.access_token,\r\n        expiresIn: response.expires_in,\r\n        refreshToken: response.refresh_token\r\n    };\r\n}\r\nasync function revokeToken(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v2/accounts:revokeToken\" /* Endpoint.REVOKE_TOKEN */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * We need to mark this class as internal explicitly to exclude it in the public typings, because\r\n * it references AuthInternal which has a circular dependency with UserInternal.\r\n *\r\n * @internal\r\n */\r\nclass StsTokenManager {\r\n    constructor() {\r\n        this.refreshToken = null;\r\n        this.accessToken = null;\r\n        this.expirationTime = null;\r\n    }\r\n    get isExpired() {\r\n        return (!this.expirationTime ||\r\n            Date.now() > this.expirationTime - 30000 /* Buffer.TOKEN_REFRESH */);\r\n    }\r\n    updateFromServerResponse(response) {\r\n        _assert(response.idToken, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        _assert(typeof response.idToken !== 'undefined', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        _assert(typeof response.refreshToken !== 'undefined', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        const expiresIn = 'expiresIn' in response && typeof response.expiresIn !== 'undefined'\r\n            ? Number(response.expiresIn)\r\n            : _tokenExpiresIn(response.idToken);\r\n        this.updateTokensAndExpiration(response.idToken, response.refreshToken, expiresIn);\r\n    }\r\n    async getToken(auth, forceRefresh = false) {\r\n        _assert(!this.accessToken || this.refreshToken, auth, \"user-token-expired\" /* AuthErrorCode.TOKEN_EXPIRED */);\r\n        if (!forceRefresh && this.accessToken && !this.isExpired) {\r\n            return this.accessToken;\r\n        }\r\n        if (this.refreshToken) {\r\n            await this.refresh(auth, this.refreshToken);\r\n            return this.accessToken;\r\n        }\r\n        return null;\r\n    }\r\n    clearRefreshToken() {\r\n        this.refreshToken = null;\r\n    }\r\n    async refresh(auth, oldToken) {\r\n        const { accessToken, refreshToken, expiresIn } = await requestStsToken(auth, oldToken);\r\n        this.updateTokensAndExpiration(accessToken, refreshToken, Number(expiresIn));\r\n    }\r\n    updateTokensAndExpiration(accessToken, refreshToken, expiresInSec) {\r\n        this.refreshToken = refreshToken || null;\r\n        this.accessToken = accessToken || null;\r\n        this.expirationTime = Date.now() + expiresInSec * 1000;\r\n    }\r\n    static fromJSON(appName, object) {\r\n        const { refreshToken, accessToken, expirationTime } = object;\r\n        const manager = new StsTokenManager();\r\n        if (refreshToken) {\r\n            _assert(typeof refreshToken === 'string', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */, {\r\n                appName\r\n            });\r\n            manager.refreshToken = refreshToken;\r\n        }\r\n        if (accessToken) {\r\n            _assert(typeof accessToken === 'string', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */, {\r\n                appName\r\n            });\r\n            manager.accessToken = accessToken;\r\n        }\r\n        if (expirationTime) {\r\n            _assert(typeof expirationTime === 'number', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */, {\r\n                appName\r\n            });\r\n            manager.expirationTime = expirationTime;\r\n        }\r\n        return manager;\r\n    }\r\n    toJSON() {\r\n        return {\r\n            refreshToken: this.refreshToken,\r\n            accessToken: this.accessToken,\r\n            expirationTime: this.expirationTime\r\n        };\r\n    }\r\n    _assign(stsTokenManager) {\r\n        this.accessToken = stsTokenManager.accessToken;\r\n        this.refreshToken = stsTokenManager.refreshToken;\r\n        this.expirationTime = stsTokenManager.expirationTime;\r\n    }\r\n    _clone() {\r\n        return Object.assign(new StsTokenManager(), this.toJSON());\r\n    }\r\n    _performRefresh() {\r\n        return debugFail('not implemented');\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction assertStringOrUndefined(assertion, appName) {\r\n    _assert(typeof assertion === 'string' || typeof assertion === 'undefined', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */, { appName });\r\n}\r\nclass UserImpl {\r\n    constructor(_a) {\r\n        var { uid, auth, stsTokenManager } = _a, opt = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__rest)(_a, [\"uid\", \"auth\", \"stsTokenManager\"]);\r\n        // For the user object, provider is always Firebase.\r\n        this.providerId = \"firebase\" /* ProviderId.FIREBASE */;\r\n        this.proactiveRefresh = new ProactiveRefresh(this);\r\n        this.reloadUserInfo = null;\r\n        this.reloadListener = null;\r\n        this.uid = uid;\r\n        this.auth = auth;\r\n        this.stsTokenManager = stsTokenManager;\r\n        this.accessToken = stsTokenManager.accessToken;\r\n        this.displayName = opt.displayName || null;\r\n        this.email = opt.email || null;\r\n        this.emailVerified = opt.emailVerified || false;\r\n        this.phoneNumber = opt.phoneNumber || null;\r\n        this.photoURL = opt.photoURL || null;\r\n        this.isAnonymous = opt.isAnonymous || false;\r\n        this.tenantId = opt.tenantId || null;\r\n        this.providerData = opt.providerData ? [...opt.providerData] : [];\r\n        this.metadata = new UserMetadata(opt.createdAt || undefined, opt.lastLoginAt || undefined);\r\n    }\r\n    async getIdToken(forceRefresh) {\r\n        const accessToken = await _logoutIfInvalidated(this, this.stsTokenManager.getToken(this.auth, forceRefresh));\r\n        _assert(accessToken, this.auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        if (this.accessToken !== accessToken) {\r\n            this.accessToken = accessToken;\r\n            await this.auth._persistUserIfCurrent(this);\r\n            this.auth._notifyListenersIfCurrent(this);\r\n        }\r\n        return accessToken;\r\n    }\r\n    getIdTokenResult(forceRefresh) {\r\n        return getIdTokenResult(this, forceRefresh);\r\n    }\r\n    reload() {\r\n        return reload(this);\r\n    }\r\n    _assign(user) {\r\n        if (this === user) {\r\n            return;\r\n        }\r\n        _assert(this.uid === user.uid, this.auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        this.displayName = user.displayName;\r\n        this.photoURL = user.photoURL;\r\n        this.email = user.email;\r\n        this.emailVerified = user.emailVerified;\r\n        this.phoneNumber = user.phoneNumber;\r\n        this.isAnonymous = user.isAnonymous;\r\n        this.tenantId = user.tenantId;\r\n        this.providerData = user.providerData.map(userInfo => (Object.assign({}, userInfo)));\r\n        this.metadata._copy(user.metadata);\r\n        this.stsTokenManager._assign(user.stsTokenManager);\r\n    }\r\n    _clone(auth) {\r\n        const newUser = new UserImpl(Object.assign(Object.assign({}, this), { auth, stsTokenManager: this.stsTokenManager._clone() }));\r\n        newUser.metadata._copy(this.metadata);\r\n        return newUser;\r\n    }\r\n    _onReload(callback) {\r\n        // There should only ever be one listener, and that is a single instance of MultiFactorUser\r\n        _assert(!this.reloadListener, this.auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        this.reloadListener = callback;\r\n        if (this.reloadUserInfo) {\r\n            this._notifyReloadListener(this.reloadUserInfo);\r\n            this.reloadUserInfo = null;\r\n        }\r\n    }\r\n    _notifyReloadListener(userInfo) {\r\n        if (this.reloadListener) {\r\n            this.reloadListener(userInfo);\r\n        }\r\n        else {\r\n            // If no listener is subscribed yet, save the result so it's available when they do subscribe\r\n            this.reloadUserInfo = userInfo;\r\n        }\r\n    }\r\n    _startProactiveRefresh() {\r\n        this.proactiveRefresh._start();\r\n    }\r\n    _stopProactiveRefresh() {\r\n        this.proactiveRefresh._stop();\r\n    }\r\n    async _updateTokensIfNecessary(response, reload = false) {\r\n        let tokensRefreshed = false;\r\n        if (response.idToken &&\r\n            response.idToken !== this.stsTokenManager.accessToken) {\r\n            this.stsTokenManager.updateFromServerResponse(response);\r\n            tokensRefreshed = true;\r\n        }\r\n        if (reload) {\r\n            await _reloadWithoutSaving(this);\r\n        }\r\n        await this.auth._persistUserIfCurrent(this);\r\n        if (tokensRefreshed) {\r\n            this.auth._notifyListenersIfCurrent(this);\r\n        }\r\n    }\r\n    async delete() {\r\n        const idToken = await this.getIdToken();\r\n        await _logoutIfInvalidated(this, deleteAccount(this.auth, { idToken }));\r\n        this.stsTokenManager.clearRefreshToken();\r\n        // TODO: Determine if cancellable-promises are necessary to use in this class so that delete()\r\n        //       cancels pending actions...\r\n        return this.auth.signOut();\r\n    }\r\n    toJSON() {\r\n        return Object.assign(Object.assign({ uid: this.uid, email: this.email || undefined, emailVerified: this.emailVerified, displayName: this.displayName || undefined, isAnonymous: this.isAnonymous, photoURL: this.photoURL || undefined, phoneNumber: this.phoneNumber || undefined, tenantId: this.tenantId || undefined, providerData: this.providerData.map(userInfo => (Object.assign({}, userInfo))), stsTokenManager: this.stsTokenManager.toJSON(), \r\n            // Redirect event ID must be maintained in case there is a pending\r\n            // redirect event.\r\n            _redirectEventId: this._redirectEventId }, this.metadata.toJSON()), { \r\n            // Required for compatibility with the legacy SDK (go/firebase-auth-sdk-persistence-parsing):\r\n            apiKey: this.auth.config.apiKey, appName: this.auth.name });\r\n    }\r\n    get refreshToken() {\r\n        return this.stsTokenManager.refreshToken || '';\r\n    }\r\n    static _fromJSON(auth, object) {\r\n        var _a, _b, _c, _d, _e, _f, _g, _h;\r\n        const displayName = (_a = object.displayName) !== null && _a !== void 0 ? _a : undefined;\r\n        const email = (_b = object.email) !== null && _b !== void 0 ? _b : undefined;\r\n        const phoneNumber = (_c = object.phoneNumber) !== null && _c !== void 0 ? _c : undefined;\r\n        const photoURL = (_d = object.photoURL) !== null && _d !== void 0 ? _d : undefined;\r\n        const tenantId = (_e = object.tenantId) !== null && _e !== void 0 ? _e : undefined;\r\n        const _redirectEventId = (_f = object._redirectEventId) !== null && _f !== void 0 ? _f : undefined;\r\n        const createdAt = (_g = object.createdAt) !== null && _g !== void 0 ? _g : undefined;\r\n        const lastLoginAt = (_h = object.lastLoginAt) !== null && _h !== void 0 ? _h : undefined;\r\n        const { uid, emailVerified, isAnonymous, providerData, stsTokenManager: plainObjectTokenManager } = object;\r\n        _assert(uid && plainObjectTokenManager, auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        const stsTokenManager = StsTokenManager.fromJSON(this.name, plainObjectTokenManager);\r\n        _assert(typeof uid === 'string', auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        assertStringOrUndefined(displayName, auth.name);\r\n        assertStringOrUndefined(email, auth.name);\r\n        _assert(typeof emailVerified === 'boolean', auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        _assert(typeof isAnonymous === 'boolean', auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        assertStringOrUndefined(phoneNumber, auth.name);\r\n        assertStringOrUndefined(photoURL, auth.name);\r\n        assertStringOrUndefined(tenantId, auth.name);\r\n        assertStringOrUndefined(_redirectEventId, auth.name);\r\n        assertStringOrUndefined(createdAt, auth.name);\r\n        assertStringOrUndefined(lastLoginAt, auth.name);\r\n        const user = new UserImpl({\r\n            uid,\r\n            auth,\r\n            email,\r\n            emailVerified,\r\n            displayName,\r\n            isAnonymous,\r\n            photoURL,\r\n            phoneNumber,\r\n            tenantId,\r\n            stsTokenManager,\r\n            createdAt,\r\n            lastLoginAt\r\n        });\r\n        if (providerData && Array.isArray(providerData)) {\r\n            user.providerData = providerData.map(userInfo => (Object.assign({}, userInfo)));\r\n        }\r\n        if (_redirectEventId) {\r\n            user._redirectEventId = _redirectEventId;\r\n        }\r\n        return user;\r\n    }\r\n    /**\r\n     * Initialize a User from an idToken server response\r\n     * @param auth\r\n     * @param idTokenResponse\r\n     */\r\n    static async _fromIdTokenResponse(auth, idTokenResponse, isAnonymous = false) {\r\n        const stsTokenManager = new StsTokenManager();\r\n        stsTokenManager.updateFromServerResponse(idTokenResponse);\r\n        // Initialize the Firebase Auth user.\r\n        const user = new UserImpl({\r\n            uid: idTokenResponse.localId,\r\n            auth,\r\n            stsTokenManager,\r\n            isAnonymous\r\n        });\r\n        // Updates the user info and data and resolves with a user instance.\r\n        await _reloadWithoutSaving(user);\r\n        return user;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst instanceCache = new Map();\r\nfunction _getInstance(cls) {\r\n    debugAssert(cls instanceof Function, 'Expected a class definition');\r\n    let instance = instanceCache.get(cls);\r\n    if (instance) {\r\n        debugAssert(instance instanceof cls, 'Instance stored in cache mismatched with class');\r\n        return instance;\r\n    }\r\n    instance = new cls();\r\n    instanceCache.set(cls, instance);\r\n    return instance;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass InMemoryPersistence {\r\n    constructor() {\r\n        this.type = \"NONE\" /* PersistenceType.NONE */;\r\n        this.storage = {};\r\n    }\r\n    async _isAvailable() {\r\n        return true;\r\n    }\r\n    async _set(key, value) {\r\n        this.storage[key] = value;\r\n    }\r\n    async _get(key) {\r\n        const value = this.storage[key];\r\n        return value === undefined ? null : value;\r\n    }\r\n    async _remove(key) {\r\n        delete this.storage[key];\r\n    }\r\n    _addListener(_key, _listener) {\r\n        // Listeners are not supported for in-memory storage since it cannot be shared across windows/workers\r\n        return;\r\n    }\r\n    _removeListener(_key, _listener) {\r\n        // Listeners are not supported for in-memory storage since it cannot be shared across windows/workers\r\n        return;\r\n    }\r\n}\r\nInMemoryPersistence.type = 'NONE';\r\n/**\r\n * An implementation of {@link Persistence} of type 'NONE'.\r\n *\r\n * @public\r\n */\r\nconst inMemoryPersistence = InMemoryPersistence;\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction _persistenceKeyName(key, apiKey, appName) {\r\n    return `${\"firebase\" /* Namespace.PERSISTENCE */}:${key}:${apiKey}:${appName}`;\r\n}\r\nclass PersistenceUserManager {\r\n    constructor(persistence, auth, userKey) {\r\n        this.persistence = persistence;\r\n        this.auth = auth;\r\n        this.userKey = userKey;\r\n        const { config, name } = this.auth;\r\n        this.fullUserKey = _persistenceKeyName(this.userKey, config.apiKey, name);\r\n        this.fullPersistenceKey = _persistenceKeyName(\"persistence\" /* KeyName.PERSISTENCE_USER */, config.apiKey, name);\r\n        this.boundEventHandler = auth._onStorageEvent.bind(auth);\r\n        this.persistence._addListener(this.fullUserKey, this.boundEventHandler);\r\n    }\r\n    setCurrentUser(user) {\r\n        return this.persistence._set(this.fullUserKey, user.toJSON());\r\n    }\r\n    async getCurrentUser() {\r\n        const blob = await this.persistence._get(this.fullUserKey);\r\n        return blob ? UserImpl._fromJSON(this.auth, blob) : null;\r\n    }\r\n    removeCurrentUser() {\r\n        return this.persistence._remove(this.fullUserKey);\r\n    }\r\n    savePersistenceForRedirect() {\r\n        return this.persistence._set(this.fullPersistenceKey, this.persistence.type);\r\n    }\r\n    async setPersistence(newPersistence) {\r\n        if (this.persistence === newPersistence) {\r\n            return;\r\n        }\r\n        const currentUser = await this.getCurrentUser();\r\n        await this.removeCurrentUser();\r\n        this.persistence = newPersistence;\r\n        if (currentUser) {\r\n            return this.setCurrentUser(currentUser);\r\n        }\r\n    }\r\n    delete() {\r\n        this.persistence._removeListener(this.fullUserKey, this.boundEventHandler);\r\n    }\r\n    static async create(auth, persistenceHierarchy, userKey = \"authUser\" /* KeyName.AUTH_USER */) {\r\n        if (!persistenceHierarchy.length) {\r\n            return new PersistenceUserManager(_getInstance(inMemoryPersistence), auth, userKey);\r\n        }\r\n        // Eliminate any persistences that are not available\r\n        const availablePersistences = (await Promise.all(persistenceHierarchy.map(async (persistence) => {\r\n            if (await persistence._isAvailable()) {\r\n                return persistence;\r\n            }\r\n            return undefined;\r\n        }))).filter(persistence => persistence);\r\n        // Fall back to the first persistence listed, or in memory if none available\r\n        let selectedPersistence = availablePersistences[0] ||\r\n            _getInstance(inMemoryPersistence);\r\n        const key = _persistenceKeyName(userKey, auth.config.apiKey, auth.name);\r\n        // Pull out the existing user, setting the chosen persistence to that\r\n        // persistence if the user exists.\r\n        let userToMigrate = null;\r\n        // Note, here we check for a user in _all_ persistences, not just the\r\n        // ones deemed available. If we can migrate a user out of a broken\r\n        // persistence, we will (but only if that persistence supports migration).\r\n        for (const persistence of persistenceHierarchy) {\r\n            try {\r\n                const blob = await persistence._get(key);\r\n                if (blob) {\r\n                    const user = UserImpl._fromJSON(auth, blob); // throws for unparsable blob (wrong format)\r\n                    if (persistence !== selectedPersistence) {\r\n                        userToMigrate = user;\r\n                    }\r\n                    selectedPersistence = persistence;\r\n                    break;\r\n                }\r\n            }\r\n            catch (_a) { }\r\n        }\r\n        // If we find the user in a persistence that does support migration, use\r\n        // that migration path (of only persistences that support migration)\r\n        const migrationHierarchy = availablePersistences.filter(p => p._shouldAllowMigration);\r\n        // If the persistence does _not_ allow migration, just finish off here\r\n        if (!selectedPersistence._shouldAllowMigration ||\r\n            !migrationHierarchy.length) {\r\n            return new PersistenceUserManager(selectedPersistence, auth, userKey);\r\n        }\r\n        selectedPersistence = migrationHierarchy[0];\r\n        if (userToMigrate) {\r\n            // This normally shouldn't throw since chosenPersistence.isAvailable() is true, but if it does\r\n            // we'll just let it bubble to surface the error.\r\n            await selectedPersistence._set(key, userToMigrate.toJSON());\r\n        }\r\n        // Attempt to clear the key in other persistences but ignore errors. This helps prevent issues\r\n        // such as users getting stuck with a previous account after signing out and refreshing the tab.\r\n        await Promise.all(persistenceHierarchy.map(async (persistence) => {\r\n            if (persistence !== selectedPersistence) {\r\n                try {\r\n                    await persistence._remove(key);\r\n                }\r\n                catch (_a) { }\r\n            }\r\n        }));\r\n        return new PersistenceUserManager(selectedPersistence, auth, userKey);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Determine the browser for the purposes of reporting usage to the API\r\n */\r\nfunction _getBrowserName(userAgent) {\r\n    const ua = userAgent.toLowerCase();\r\n    if (ua.includes('opera/') || ua.includes('opr/') || ua.includes('opios/')) {\r\n        return \"Opera\" /* BrowserName.OPERA */;\r\n    }\r\n    else if (_isIEMobile(ua)) {\r\n        // Windows phone IEMobile browser.\r\n        return \"IEMobile\" /* BrowserName.IEMOBILE */;\r\n    }\r\n    else if (ua.includes('msie') || ua.includes('trident/')) {\r\n        return \"IE\" /* BrowserName.IE */;\r\n    }\r\n    else if (ua.includes('edge/')) {\r\n        return \"Edge\" /* BrowserName.EDGE */;\r\n    }\r\n    else if (_isFirefox(ua)) {\r\n        return \"Firefox\" /* BrowserName.FIREFOX */;\r\n    }\r\n    else if (ua.includes('silk/')) {\r\n        return \"Silk\" /* BrowserName.SILK */;\r\n    }\r\n    else if (_isBlackBerry(ua)) {\r\n        // Blackberry browser.\r\n        return \"Blackberry\" /* BrowserName.BLACKBERRY */;\r\n    }\r\n    else if (_isWebOS(ua)) {\r\n        // WebOS default browser.\r\n        return \"Webos\" /* BrowserName.WEBOS */;\r\n    }\r\n    else if (_isSafari(ua)) {\r\n        return \"Safari\" /* BrowserName.SAFARI */;\r\n    }\r\n    else if ((ua.includes('chrome/') || _isChromeIOS(ua)) &&\r\n        !ua.includes('edge/')) {\r\n        return \"Chrome\" /* BrowserName.CHROME */;\r\n    }\r\n    else if (_isAndroid(ua)) {\r\n        // Android stock browser.\r\n        return \"Android\" /* BrowserName.ANDROID */;\r\n    }\r\n    else {\r\n        // Most modern browsers have name/version at end of user agent string.\r\n        const re = /([a-zA-Z\\d\\.]+)\\/[a-zA-Z\\d\\.]*$/;\r\n        const matches = userAgent.match(re);\r\n        if ((matches === null || matches === void 0 ? void 0 : matches.length) === 2) {\r\n            return matches[1];\r\n        }\r\n    }\r\n    return \"Other\" /* BrowserName.OTHER */;\r\n}\r\nfunction _isFirefox(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return /firefox\\//i.test(ua);\r\n}\r\nfunction _isSafari(userAgent = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    const ua = userAgent.toLowerCase();\r\n    return (ua.includes('safari/') &&\r\n        !ua.includes('chrome/') &&\r\n        !ua.includes('crios/') &&\r\n        !ua.includes('android'));\r\n}\r\nfunction _isChromeIOS(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return /crios\\//i.test(ua);\r\n}\r\nfunction _isIEMobile(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return /iemobile/i.test(ua);\r\n}\r\nfunction _isAndroid(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return /android/i.test(ua);\r\n}\r\nfunction _isBlackBerry(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return /blackberry/i.test(ua);\r\n}\r\nfunction _isWebOS(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return /webos/i.test(ua);\r\n}\r\nfunction _isIOS(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return (/iphone|ipad|ipod/i.test(ua) ||\r\n        (/macintosh/i.test(ua) && /mobile/i.test(ua)));\r\n}\r\nfunction _isIOS7Or8(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    return (/(iPad|iPhone|iPod).*OS 7_\\d/i.test(ua) ||\r\n        /(iPad|iPhone|iPod).*OS 8_\\d/i.test(ua));\r\n}\r\nfunction _isIE10() {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.isIE)() && document.documentMode === 10;\r\n}\r\nfunction _isMobileBrowser(ua = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)()) {\r\n    // TODO: implement getBrowserName equivalent for OS.\r\n    return (_isIOS(ua) ||\r\n        _isAndroid(ua) ||\r\n        _isWebOS(ua) ||\r\n        _isBlackBerry(ua) ||\r\n        /windows phone/i.test(ua) ||\r\n        _isIEMobile(ua));\r\n}\r\nfunction _isIframe() {\r\n    try {\r\n        // Check that the current window is not the top window.\r\n        // If so, return true.\r\n        return !!(window && window !== window.top);\r\n    }\r\n    catch (e) {\r\n        return false;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/*\r\n * Determine the SDK version string\r\n */\r\nfunction _getClientVersion(clientPlatform, frameworks = []) {\r\n    let reportedPlatform;\r\n    switch (clientPlatform) {\r\n        case \"Browser\" /* ClientPlatform.BROWSER */:\r\n            // In a browser environment, report the browser name.\r\n            reportedPlatform = _getBrowserName((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)());\r\n            break;\r\n        case \"Worker\" /* ClientPlatform.WORKER */:\r\n            // Technically a worker runs from a browser but we need to differentiate a\r\n            // worker from a browser.\r\n            // For example: Chrome-Worker/JsCore/4.9.1/FirebaseCore-web.\r\n            reportedPlatform = `${_getBrowserName((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getUA)())}-${clientPlatform}`;\r\n            break;\r\n        default:\r\n            reportedPlatform = clientPlatform;\r\n    }\r\n    const reportedFrameworks = frameworks.length\r\n        ? frameworks.join(',')\r\n        : 'FirebaseCore-web'; /* default value if no other framework is used */\r\n    return `${reportedPlatform}/${\"JsCore\" /* ClientImplementation.CORE */}/${_firebase_app__WEBPACK_IMPORTED_MODULE_1__.SDK_VERSION}/${reportedFrameworks}`;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2022 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass AuthMiddlewareQueue {\r\n    constructor(auth) {\r\n        this.auth = auth;\r\n        this.queue = [];\r\n    }\r\n    pushCallback(callback, onAbort) {\r\n        // The callback could be sync or async. Wrap it into a\r\n        // function that is always async.\r\n        const wrappedCallback = (user) => new Promise((resolve, reject) => {\r\n            try {\r\n                const result = callback(user);\r\n                // Either resolve with existing promise or wrap a non-promise\r\n                // return value into a promise.\r\n                resolve(result);\r\n            }\r\n            catch (e) {\r\n                // Sync callback throws.\r\n                reject(e);\r\n            }\r\n        });\r\n        // Attach the onAbort if present\r\n        wrappedCallback.onAbort = onAbort;\r\n        this.queue.push(wrappedCallback);\r\n        const index = this.queue.length - 1;\r\n        return () => {\r\n            // Unsubscribe. Replace with no-op. Do not remove from array, or it will disturb\r\n            // indexing of other elements.\r\n            this.queue[index] = () => Promise.resolve();\r\n        };\r\n    }\r\n    async runMiddleware(nextUser) {\r\n        if (this.auth.currentUser === nextUser) {\r\n            return;\r\n        }\r\n        // While running the middleware, build a temporary stack of onAbort\r\n        // callbacks to call if one middleware callback rejects.\r\n        const onAbortStack = [];\r\n        try {\r\n            for (const beforeStateCallback of this.queue) {\r\n                await beforeStateCallback(nextUser);\r\n                // Only push the onAbort if the callback succeeds\r\n                if (beforeStateCallback.onAbort) {\r\n                    onAbortStack.push(beforeStateCallback.onAbort);\r\n                }\r\n            }\r\n        }\r\n        catch (e) {\r\n            // Run all onAbort, with separate try/catch to ignore any errors and\r\n            // continue\r\n            onAbortStack.reverse();\r\n            for (const onAbort of onAbortStack) {\r\n                try {\r\n                    onAbort();\r\n                }\r\n                catch (_) {\r\n                    /* swallow error */\r\n                }\r\n            }\r\n            throw this.auth._errorFactory.create(\"login-blocked\" /* AuthErrorCode.LOGIN_BLOCKED */, {\r\n                originalMessage: e === null || e === void 0 ? void 0 : e.message\r\n            });\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2023 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Fetches the password policy for the currently set tenant or the project if no tenant is set.\r\n *\r\n * @param auth Auth object.\r\n * @param request Password policy request.\r\n * @returns Password policy response.\r\n */\r\nasync function _getPasswordPolicy(auth, request = {}) {\r\n    return _performApiRequest(auth, \"GET\" /* HttpMethod.GET */, \"/v2/passwordPolicy\" /* Endpoint.GET_PASSWORD_POLICY */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2023 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n// Minimum min password length enforced by the backend, even if no minimum length is set.\r\nconst MINIMUM_MIN_PASSWORD_LENGTH = 6;\r\n/**\r\n * Stores password policy requirements and provides password validation against the policy.\r\n *\r\n * @internal\r\n */\r\nclass PasswordPolicyImpl {\r\n    constructor(response) {\r\n        var _a, _b, _c, _d;\r\n        // Only include custom strength options defined in the response.\r\n        const responseOptions = response.customStrengthOptions;\r\n        this.customStrengthOptions = {};\r\n        // TODO: Remove once the backend is updated to include the minimum min password length instead of undefined when there is no minimum length set.\r\n        this.customStrengthOptions.minPasswordLength =\r\n            (_a = responseOptions.minPasswordLength) !== null && _a !== void 0 ? _a : MINIMUM_MIN_PASSWORD_LENGTH;\r\n        if (responseOptions.maxPasswordLength) {\r\n            this.customStrengthOptions.maxPasswordLength =\r\n                responseOptions.maxPasswordLength;\r\n        }\r\n        if (responseOptions.containsLowercaseCharacter !== undefined) {\r\n            this.customStrengthOptions.containsLowercaseLetter =\r\n                responseOptions.containsLowercaseCharacter;\r\n        }\r\n        if (responseOptions.containsUppercaseCharacter !== undefined) {\r\n            this.customStrengthOptions.containsUppercaseLetter =\r\n                responseOptions.containsUppercaseCharacter;\r\n        }\r\n        if (responseOptions.containsNumericCharacter !== undefined) {\r\n            this.customStrengthOptions.containsNumericCharacter =\r\n                responseOptions.containsNumericCharacter;\r\n        }\r\n        if (responseOptions.containsNonAlphanumericCharacter !== undefined) {\r\n            this.customStrengthOptions.containsNonAlphanumericCharacter =\r\n                responseOptions.containsNonAlphanumericCharacter;\r\n        }\r\n        this.enforcementState = response.enforcementState;\r\n        if (this.enforcementState === 'ENFORCEMENT_STATE_UNSPECIFIED') {\r\n            this.enforcementState = 'OFF';\r\n        }\r\n        // Use an empty string if no non-alphanumeric characters are specified in the response.\r\n        this.allowedNonAlphanumericCharacters =\r\n            (_c = (_b = response.allowedNonAlphanumericCharacters) === null || _b === void 0 ? void 0 : _b.join('')) !== null && _c !== void 0 ? _c : '';\r\n        this.forceUpgradeOnSignin = (_d = response.forceUpgradeOnSignin) !== null && _d !== void 0 ? _d : false;\r\n        this.schemaVersion = response.schemaVersion;\r\n    }\r\n    validatePassword(password) {\r\n        var _a, _b, _c, _d, _e, _f;\r\n        const status = {\r\n            isValid: true,\r\n            passwordPolicy: this\r\n        };\r\n        // Check the password length and character options.\r\n        this.validatePasswordLengthOptions(password, status);\r\n        this.validatePasswordCharacterOptions(password, status);\r\n        // Combine the status into single isValid property.\r\n        status.isValid && (status.isValid = (_a = status.meetsMinPasswordLength) !== null && _a !== void 0 ? _a : true);\r\n        status.isValid && (status.isValid = (_b = status.meetsMaxPasswordLength) !== null && _b !== void 0 ? _b : true);\r\n        status.isValid && (status.isValid = (_c = status.containsLowercaseLetter) !== null && _c !== void 0 ? _c : true);\r\n        status.isValid && (status.isValid = (_d = status.containsUppercaseLetter) !== null && _d !== void 0 ? _d : true);\r\n        status.isValid && (status.isValid = (_e = status.containsNumericCharacter) !== null && _e !== void 0 ? _e : true);\r\n        status.isValid && (status.isValid = (_f = status.containsNonAlphanumericCharacter) !== null && _f !== void 0 ? _f : true);\r\n        return status;\r\n    }\r\n    /**\r\n     * Validates that the password meets the length options for the policy.\r\n     *\r\n     * @param password Password to validate.\r\n     * @param status Validation status.\r\n     */\r\n    validatePasswordLengthOptions(password, status) {\r\n        const minPasswordLength = this.customStrengthOptions.minPasswordLength;\r\n        const maxPasswordLength = this.customStrengthOptions.maxPasswordLength;\r\n        if (minPasswordLength) {\r\n            status.meetsMinPasswordLength = password.length >= minPasswordLength;\r\n        }\r\n        if (maxPasswordLength) {\r\n            status.meetsMaxPasswordLength = password.length <= maxPasswordLength;\r\n        }\r\n    }\r\n    /**\r\n     * Validates that the password meets the character options for the policy.\r\n     *\r\n     * @param password Password to validate.\r\n     * @param status Validation status.\r\n     */\r\n    validatePasswordCharacterOptions(password, status) {\r\n        // Assign statuses for requirements even if the password is an empty string.\r\n        this.updatePasswordCharacterOptionsStatuses(status, \r\n        /* containsLowercaseCharacter= */ false, \r\n        /* containsUppercaseCharacter= */ false, \r\n        /* containsNumericCharacter= */ false, \r\n        /* containsNonAlphanumericCharacter= */ false);\r\n        let passwordChar;\r\n        for (let i = 0; i < password.length; i++) {\r\n            passwordChar = password.charAt(i);\r\n            this.updatePasswordCharacterOptionsStatuses(status, \r\n            /* containsLowercaseCharacter= */ passwordChar >= 'a' &&\r\n                passwordChar <= 'z', \r\n            /* containsUppercaseCharacter= */ passwordChar >= 'A' &&\r\n                passwordChar <= 'Z', \r\n            /* containsNumericCharacter= */ passwordChar >= '0' &&\r\n                passwordChar <= '9', \r\n            /* containsNonAlphanumericCharacter= */ this.allowedNonAlphanumericCharacters.includes(passwordChar));\r\n        }\r\n    }\r\n    /**\r\n     * Updates the running validation status with the statuses for the character options.\r\n     * Expected to be called each time a character is processed to update each option status\r\n     * based on the current character.\r\n     *\r\n     * @param status Validation status.\r\n     * @param containsLowercaseCharacter Whether the character is a lowercase letter.\r\n     * @param containsUppercaseCharacter Whether the character is an uppercase letter.\r\n     * @param containsNumericCharacter Whether the character is a numeric character.\r\n     * @param containsNonAlphanumericCharacter Whether the character is a non-alphanumeric character.\r\n     */\r\n    updatePasswordCharacterOptionsStatuses(status, containsLowercaseCharacter, containsUppercaseCharacter, containsNumericCharacter, containsNonAlphanumericCharacter) {\r\n        if (this.customStrengthOptions.containsLowercaseLetter) {\r\n            status.containsLowercaseLetter || (status.containsLowercaseLetter = containsLowercaseCharacter);\r\n        }\r\n        if (this.customStrengthOptions.containsUppercaseLetter) {\r\n            status.containsUppercaseLetter || (status.containsUppercaseLetter = containsUppercaseCharacter);\r\n        }\r\n        if (this.customStrengthOptions.containsNumericCharacter) {\r\n            status.containsNumericCharacter || (status.containsNumericCharacter = containsNumericCharacter);\r\n        }\r\n        if (this.customStrengthOptions.containsNonAlphanumericCharacter) {\r\n            status.containsNonAlphanumericCharacter || (status.containsNonAlphanumericCharacter = containsNonAlphanumericCharacter);\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass AuthImpl {\r\n    constructor(app, heartbeatServiceProvider, appCheckServiceProvider, config) {\r\n        this.app = app;\r\n        this.heartbeatServiceProvider = heartbeatServiceProvider;\r\n        this.appCheckServiceProvider = appCheckServiceProvider;\r\n        this.config = config;\r\n        this.currentUser = null;\r\n        this.emulatorConfig = null;\r\n        this.operations = Promise.resolve();\r\n        this.authStateSubscription = new Subscription(this);\r\n        this.idTokenSubscription = new Subscription(this);\r\n        this.beforeStateQueue = new AuthMiddlewareQueue(this);\r\n        this.redirectUser = null;\r\n        this.isProactiveRefreshEnabled = false;\r\n        this.EXPECTED_PASSWORD_POLICY_SCHEMA_VERSION = 1;\r\n        // Any network calls will set this to true and prevent subsequent emulator\r\n        // initialization\r\n        this._canInitEmulator = true;\r\n        this._isInitialized = false;\r\n        this._deleted = false;\r\n        this._initializationPromise = null;\r\n        this._popupRedirectResolver = null;\r\n        this._errorFactory = _DEFAULT_AUTH_ERROR_FACTORY;\r\n        this._agentRecaptchaConfig = null;\r\n        this._tenantRecaptchaConfigs = {};\r\n        this._projectPasswordPolicy = null;\r\n        this._tenantPasswordPolicies = {};\r\n        // Tracks the last notified UID for state change listeners to prevent\r\n        // repeated calls to the callbacks. Undefined means it's never been\r\n        // called, whereas null means it's been called with a signed out user\r\n        this.lastNotifiedUid = undefined;\r\n        this.languageCode = null;\r\n        this.tenantId = null;\r\n        this.settings = { appVerificationDisabledForTesting: false };\r\n        this.frameworks = [];\r\n        this.name = app.name;\r\n        this.clientVersion = config.sdkClientVersion;\r\n    }\r\n    _initializeWithPersistence(persistenceHierarchy, popupRedirectResolver) {\r\n        if (popupRedirectResolver) {\r\n            this._popupRedirectResolver = _getInstance(popupRedirectResolver);\r\n        }\r\n        // Have to check for app deletion throughout initialization (after each\r\n        // promise resolution)\r\n        this._initializationPromise = this.queue(async () => {\r\n            var _a, _b;\r\n            if (this._deleted) {\r\n                return;\r\n            }\r\n            this.persistenceManager = await PersistenceUserManager.create(this, persistenceHierarchy);\r\n            if (this._deleted) {\r\n                return;\r\n            }\r\n            // Initialize the resolver early if necessary (only applicable to web:\r\n            // this will cause the iframe to load immediately in certain cases)\r\n            if ((_a = this._popupRedirectResolver) === null || _a === void 0 ? void 0 : _a._shouldInitProactively) {\r\n                // If this fails, don't halt auth loading\r\n                try {\r\n                    await this._popupRedirectResolver._initialize(this);\r\n                }\r\n                catch (e) {\r\n                    /* Ignore the error */\r\n                }\r\n            }\r\n            await this.initializeCurrentUser(popupRedirectResolver);\r\n            this.lastNotifiedUid = ((_b = this.currentUser) === null || _b === void 0 ? void 0 : _b.uid) || null;\r\n            if (this._deleted) {\r\n                return;\r\n            }\r\n            this._isInitialized = true;\r\n        });\r\n        return this._initializationPromise;\r\n    }\r\n    /**\r\n     * If the persistence is changed in another window, the user manager will let us know\r\n     */\r\n    async _onStorageEvent() {\r\n        if (this._deleted) {\r\n            return;\r\n        }\r\n        const user = await this.assertedPersistence.getCurrentUser();\r\n        if (!this.currentUser && !user) {\r\n            // No change, do nothing (was signed out and remained signed out).\r\n            return;\r\n        }\r\n        // If the same user is to be synchronized.\r\n        if (this.currentUser && user && this.currentUser.uid === user.uid) {\r\n            // Data update, simply copy data changes.\r\n            this._currentUser._assign(user);\r\n            // If tokens changed from previous user tokens, this will trigger\r\n            // notifyAuthListeners_.\r\n            await this.currentUser.getIdToken();\r\n            return;\r\n        }\r\n        // Update current Auth state. Either a new login or logout.\r\n        // Skip blocking callbacks, they should not apply to a change in another tab.\r\n        await this._updateCurrentUser(user, /* skipBeforeStateCallbacks */ true);\r\n    }\r\n    async initializeCurrentUser(popupRedirectResolver) {\r\n        var _a;\r\n        // First check to see if we have a pending redirect event.\r\n        const previouslyStoredUser = (await this.assertedPersistence.getCurrentUser());\r\n        let futureCurrentUser = previouslyStoredUser;\r\n        let needsTocheckMiddleware = false;\r\n        if (popupRedirectResolver && this.config.authDomain) {\r\n            await this.getOrInitRedirectPersistenceManager();\r\n            const redirectUserEventId = (_a = this.redirectUser) === null || _a === void 0 ? void 0 : _a._redirectEventId;\r\n            const storedUserEventId = futureCurrentUser === null || futureCurrentUser === void 0 ? void 0 : futureCurrentUser._redirectEventId;\r\n            const result = await this.tryRedirectSignIn(popupRedirectResolver);\r\n            // If the stored user (i.e. the old \"currentUser\") has a redirectId that\r\n            // matches the redirect user, then we want to initially sign in with the\r\n            // new user object from result.\r\n            // TODO(samgho): More thoroughly test all of this\r\n            if ((!redirectUserEventId || redirectUserEventId === storedUserEventId) &&\r\n                (result === null || result === void 0 ? void 0 : result.user)) {\r\n                futureCurrentUser = result.user;\r\n                needsTocheckMiddleware = true;\r\n            }\r\n        }\r\n        // If no user in persistence, there is no current user. Set to null.\r\n        if (!futureCurrentUser) {\r\n            return this.directlySetCurrentUser(null);\r\n        }\r\n        if (!futureCurrentUser._redirectEventId) {\r\n            // This isn't a redirect link operation, we can reload and bail.\r\n            // First though, ensure that we check the middleware is happy.\r\n            if (needsTocheckMiddleware) {\r\n                try {\r\n                    await this.beforeStateQueue.runMiddleware(futureCurrentUser);\r\n                }\r\n                catch (e) {\r\n                    futureCurrentUser = previouslyStoredUser;\r\n                    // We know this is available since the bit is only set when the\r\n                    // resolver is available\r\n                    this._popupRedirectResolver._overrideRedirectResult(this, () => Promise.reject(e));\r\n                }\r\n            }\r\n            if (futureCurrentUser) {\r\n                return this.reloadAndSetCurrentUserOrClear(futureCurrentUser);\r\n            }\r\n            else {\r\n                return this.directlySetCurrentUser(null);\r\n            }\r\n        }\r\n        _assert(this._popupRedirectResolver, this, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        await this.getOrInitRedirectPersistenceManager();\r\n        // If the redirect user's event ID matches the current user's event ID,\r\n        // DO NOT reload the current user, otherwise they'll be cleared from storage.\r\n        // This is important for the reauthenticateWithRedirect() flow.\r\n        if (this.redirectUser &&\r\n            this.redirectUser._redirectEventId === futureCurrentUser._redirectEventId) {\r\n            return this.directlySetCurrentUser(futureCurrentUser);\r\n        }\r\n        return this.reloadAndSetCurrentUserOrClear(futureCurrentUser);\r\n    }\r\n    async tryRedirectSignIn(redirectResolver) {\r\n        // The redirect user needs to be checked (and signed in if available)\r\n        // during auth initialization. All of the normal sign in and link/reauth\r\n        // flows call back into auth and push things onto the promise queue. We\r\n        // need to await the result of the redirect sign in *inside the promise\r\n        // queue*. This presents a problem: we run into deadlock. See:\r\n        //    ┌> [Initialization] ─────┐\r\n        //    ┌> [<other queue tasks>] │\r\n        //    └─ [getRedirectResult] <─┘\r\n        //    where [] are tasks on the queue and arrows denote awaits\r\n        // Initialization will never complete because it's waiting on something\r\n        // that's waiting for initialization to complete!\r\n        //\r\n        // Instead, this method calls getRedirectResult() (stored in\r\n        // _completeRedirectFn) with an optional parameter that instructs all of\r\n        // the underlying auth operations to skip anything that mutates auth state.\r\n        let result = null;\r\n        try {\r\n            // We know this._popupRedirectResolver is set since redirectResolver\r\n            // is passed in. The _completeRedirectFn expects the unwrapped extern.\r\n            result = await this._popupRedirectResolver._completeRedirectFn(this, redirectResolver, true);\r\n        }\r\n        catch (e) {\r\n            // Swallow any errors here; the code can retrieve them in\r\n            // getRedirectResult().\r\n            await this._setRedirectUser(null);\r\n        }\r\n        return result;\r\n    }\r\n    async reloadAndSetCurrentUserOrClear(user) {\r\n        try {\r\n            await _reloadWithoutSaving(user);\r\n        }\r\n        catch (e) {\r\n            if ((e === null || e === void 0 ? void 0 : e.code) !==\r\n                `auth/${\"network-request-failed\" /* AuthErrorCode.NETWORK_REQUEST_FAILED */}`) {\r\n                // Something's wrong with the user's token. Log them out and remove\r\n                // them from storage\r\n                return this.directlySetCurrentUser(null);\r\n            }\r\n        }\r\n        return this.directlySetCurrentUser(user);\r\n    }\r\n    useDeviceLanguage() {\r\n        this.languageCode = _getUserLanguage();\r\n    }\r\n    async _delete() {\r\n        this._deleted = true;\r\n    }\r\n    async updateCurrentUser(userExtern) {\r\n        // The public updateCurrentUser method needs to make a copy of the user,\r\n        // and also check that the project matches\r\n        const user = userExtern\r\n            ? (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(userExtern)\r\n            : null;\r\n        if (user) {\r\n            _assert(user.auth.config.apiKey === this.config.apiKey, this, \"invalid-user-token\" /* AuthErrorCode.INVALID_AUTH */);\r\n        }\r\n        return this._updateCurrentUser(user && user._clone(this));\r\n    }\r\n    async _updateCurrentUser(user, skipBeforeStateCallbacks = false) {\r\n        if (this._deleted) {\r\n            return;\r\n        }\r\n        if (user) {\r\n            _assert(this.tenantId === user.tenantId, this, \"tenant-id-mismatch\" /* AuthErrorCode.TENANT_ID_MISMATCH */);\r\n        }\r\n        if (!skipBeforeStateCallbacks) {\r\n            await this.beforeStateQueue.runMiddleware(user);\r\n        }\r\n        return this.queue(async () => {\r\n            await this.directlySetCurrentUser(user);\r\n            this.notifyAuthListeners();\r\n        });\r\n    }\r\n    async signOut() {\r\n        // Run first, to block _setRedirectUser() if any callbacks fail.\r\n        await this.beforeStateQueue.runMiddleware(null);\r\n        // Clear the redirect user when signOut is called\r\n        if (this.redirectPersistenceManager || this._popupRedirectResolver) {\r\n            await this._setRedirectUser(null);\r\n        }\r\n        // Prevent callbacks from being called again in _updateCurrentUser, as\r\n        // they were already called in the first line.\r\n        return this._updateCurrentUser(null, /* skipBeforeStateCallbacks */ true);\r\n    }\r\n    setPersistence(persistence) {\r\n        return this.queue(async () => {\r\n            await this.assertedPersistence.setPersistence(_getInstance(persistence));\r\n        });\r\n    }\r\n    _getRecaptchaConfig() {\r\n        if (this.tenantId == null) {\r\n            return this._agentRecaptchaConfig;\r\n        }\r\n        else {\r\n            return this._tenantRecaptchaConfigs[this.tenantId];\r\n        }\r\n    }\r\n    async validatePassword(password) {\r\n        if (!this._getPasswordPolicyInternal()) {\r\n            await this._updatePasswordPolicy();\r\n        }\r\n        // Password policy will be defined after fetching.\r\n        const passwordPolicy = this._getPasswordPolicyInternal();\r\n        // Check that the policy schema version is supported by the SDK.\r\n        // TODO: Update this logic to use a max supported policy schema version once we have multiple schema versions.\r\n        if (passwordPolicy.schemaVersion !==\r\n            this.EXPECTED_PASSWORD_POLICY_SCHEMA_VERSION) {\r\n            return Promise.reject(this._errorFactory.create(\"unsupported-password-policy-schema-version\" /* AuthErrorCode.UNSUPPORTED_PASSWORD_POLICY_SCHEMA_VERSION */, {}));\r\n        }\r\n        return passwordPolicy.validatePassword(password);\r\n    }\r\n    _getPasswordPolicyInternal() {\r\n        if (this.tenantId === null) {\r\n            return this._projectPasswordPolicy;\r\n        }\r\n        else {\r\n            return this._tenantPasswordPolicies[this.tenantId];\r\n        }\r\n    }\r\n    async _updatePasswordPolicy() {\r\n        const response = await _getPasswordPolicy(this);\r\n        const passwordPolicy = new PasswordPolicyImpl(response);\r\n        if (this.tenantId === null) {\r\n            this._projectPasswordPolicy = passwordPolicy;\r\n        }\r\n        else {\r\n            this._tenantPasswordPolicies[this.tenantId] = passwordPolicy;\r\n        }\r\n    }\r\n    _getPersistence() {\r\n        return this.assertedPersistence.persistence.type;\r\n    }\r\n    _updateErrorMap(errorMap) {\r\n        this._errorFactory = new _firebase_util__WEBPACK_IMPORTED_MODULE_0__.ErrorFactory('auth', 'Firebase', errorMap());\r\n    }\r\n    onAuthStateChanged(nextOrObserver, error, completed) {\r\n        return this.registerStateListener(this.authStateSubscription, nextOrObserver, error, completed);\r\n    }\r\n    beforeAuthStateChanged(callback, onAbort) {\r\n        return this.beforeStateQueue.pushCallback(callback, onAbort);\r\n    }\r\n    onIdTokenChanged(nextOrObserver, error, completed) {\r\n        return this.registerStateListener(this.idTokenSubscription, nextOrObserver, error, completed);\r\n    }\r\n    authStateReady() {\r\n        return new Promise((resolve, reject) => {\r\n            if (this.currentUser) {\r\n                resolve();\r\n            }\r\n            else {\r\n                const unsubscribe = this.onAuthStateChanged(() => {\r\n                    unsubscribe();\r\n                    resolve();\r\n                }, reject);\r\n            }\r\n        });\r\n    }\r\n    /**\r\n     * Revokes the given access token. Currently only supports Apple OAuth access tokens.\r\n     */\r\n    async revokeAccessToken(token) {\r\n        if (this.currentUser) {\r\n            const idToken = await this.currentUser.getIdToken();\r\n            // Generalize this to accept other providers once supported.\r\n            const request = {\r\n                providerId: 'apple.com',\r\n                tokenType: \"ACCESS_TOKEN\" /* TokenType.ACCESS_TOKEN */,\r\n                token,\r\n                idToken\r\n            };\r\n            if (this.tenantId != null) {\r\n                request.tenantId = this.tenantId;\r\n            }\r\n            await revokeToken(this, request);\r\n        }\r\n    }\r\n    toJSON() {\r\n        var _a;\r\n        return {\r\n            apiKey: this.config.apiKey,\r\n            authDomain: this.config.authDomain,\r\n            appName: this.name,\r\n            currentUser: (_a = this._currentUser) === null || _a === void 0 ? void 0 : _a.toJSON()\r\n        };\r\n    }\r\n    async _setRedirectUser(user, popupRedirectResolver) {\r\n        const redirectManager = await this.getOrInitRedirectPersistenceManager(popupRedirectResolver);\r\n        return user === null\r\n            ? redirectManager.removeCurrentUser()\r\n            : redirectManager.setCurrentUser(user);\r\n    }\r\n    async getOrInitRedirectPersistenceManager(popupRedirectResolver) {\r\n        if (!this.redirectPersistenceManager) {\r\n            const resolver = (popupRedirectResolver && _getInstance(popupRedirectResolver)) ||\r\n                this._popupRedirectResolver;\r\n            _assert(resolver, this, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n            this.redirectPersistenceManager = await PersistenceUserManager.create(this, [_getInstance(resolver._redirectPersistence)], \"redirectUser\" /* KeyName.REDIRECT_USER */);\r\n            this.redirectUser =\r\n                await this.redirectPersistenceManager.getCurrentUser();\r\n        }\r\n        return this.redirectPersistenceManager;\r\n    }\r\n    async _redirectUserForId(id) {\r\n        var _a, _b;\r\n        // Make sure we've cleared any pending persistence actions if we're not in\r\n        // the initializer\r\n        if (this._isInitialized) {\r\n            await this.queue(async () => { });\r\n        }\r\n        if (((_a = this._currentUser) === null || _a === void 0 ? void 0 : _a._redirectEventId) === id) {\r\n            return this._currentUser;\r\n        }\r\n        if (((_b = this.redirectUser) === null || _b === void 0 ? void 0 : _b._redirectEventId) === id) {\r\n            return this.redirectUser;\r\n        }\r\n        return null;\r\n    }\r\n    async _persistUserIfCurrent(user) {\r\n        if (user === this.currentUser) {\r\n            return this.queue(async () => this.directlySetCurrentUser(user));\r\n        }\r\n    }\r\n    /** Notifies listeners only if the user is current */\r\n    _notifyListenersIfCurrent(user) {\r\n        if (user === this.currentUser) {\r\n            this.notifyAuthListeners();\r\n        }\r\n    }\r\n    _key() {\r\n        return `${this.config.authDomain}:${this.config.apiKey}:${this.name}`;\r\n    }\r\n    _startProactiveRefresh() {\r\n        this.isProactiveRefreshEnabled = true;\r\n        if (this.currentUser) {\r\n            this._currentUser._startProactiveRefresh();\r\n        }\r\n    }\r\n    _stopProactiveRefresh() {\r\n        this.isProactiveRefreshEnabled = false;\r\n        if (this.currentUser) {\r\n            this._currentUser._stopProactiveRefresh();\r\n        }\r\n    }\r\n    /** Returns the current user cast as the internal type */\r\n    get _currentUser() {\r\n        return this.currentUser;\r\n    }\r\n    notifyAuthListeners() {\r\n        var _a, _b;\r\n        if (!this._isInitialized) {\r\n            return;\r\n        }\r\n        this.idTokenSubscription.next(this.currentUser);\r\n        const currentUid = (_b = (_a = this.currentUser) === null || _a === void 0 ? void 0 : _a.uid) !== null && _b !== void 0 ? _b : null;\r\n        if (this.lastNotifiedUid !== currentUid) {\r\n            this.lastNotifiedUid = currentUid;\r\n            this.authStateSubscription.next(this.currentUser);\r\n        }\r\n    }\r\n    registerStateListener(subscription, nextOrObserver, error, completed) {\r\n        if (this._deleted) {\r\n            return () => { };\r\n        }\r\n        const cb = typeof nextOrObserver === 'function'\r\n            ? nextOrObserver\r\n            : nextOrObserver.next.bind(nextOrObserver);\r\n        let isUnsubscribed = false;\r\n        const promise = this._isInitialized\r\n            ? Promise.resolve()\r\n            : this._initializationPromise;\r\n        _assert(promise, this, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        // The callback needs to be called asynchronously per the spec.\r\n        // eslint-disable-next-line @typescript-eslint/no-floating-promises\r\n        promise.then(() => {\r\n            if (isUnsubscribed) {\r\n                return;\r\n            }\r\n            cb(this.currentUser);\r\n        });\r\n        if (typeof nextOrObserver === 'function') {\r\n            const unsubscribe = subscription.addObserver(nextOrObserver, error, completed);\r\n            return () => {\r\n                isUnsubscribed = true;\r\n                unsubscribe();\r\n            };\r\n        }\r\n        else {\r\n            const unsubscribe = subscription.addObserver(nextOrObserver);\r\n            return () => {\r\n                isUnsubscribed = true;\r\n                unsubscribe();\r\n            };\r\n        }\r\n    }\r\n    /**\r\n     * Unprotected (from race conditions) method to set the current user. This\r\n     * should only be called from within a queued callback. This is necessary\r\n     * because the queue shouldn't rely on another queued callback.\r\n     */\r\n    async directlySetCurrentUser(user) {\r\n        if (this.currentUser && this.currentUser !== user) {\r\n            this._currentUser._stopProactiveRefresh();\r\n        }\r\n        if (user && this.isProactiveRefreshEnabled) {\r\n            user._startProactiveRefresh();\r\n        }\r\n        this.currentUser = user;\r\n        if (user) {\r\n            await this.assertedPersistence.setCurrentUser(user);\r\n        }\r\n        else {\r\n            await this.assertedPersistence.removeCurrentUser();\r\n        }\r\n    }\r\n    queue(action) {\r\n        // In case something errors, the callback still should be called in order\r\n        // to keep the promise chain alive\r\n        this.operations = this.operations.then(action, action);\r\n        return this.operations;\r\n    }\r\n    get assertedPersistence() {\r\n        _assert(this.persistenceManager, this, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        return this.persistenceManager;\r\n    }\r\n    _logFramework(framework) {\r\n        if (!framework || this.frameworks.includes(framework)) {\r\n            return;\r\n        }\r\n        this.frameworks.push(framework);\r\n        // Sort alphabetically so that \"FirebaseCore-web,FirebaseUI-web\" and\r\n        // \"FirebaseUI-web,FirebaseCore-web\" aren't viewed as different.\r\n        this.frameworks.sort();\r\n        this.clientVersion = _getClientVersion(this.config.clientPlatform, this._getFrameworks());\r\n    }\r\n    _getFrameworks() {\r\n        return this.frameworks;\r\n    }\r\n    async _getAdditionalHeaders() {\r\n        var _a;\r\n        // Additional headers on every request\r\n        const headers = {\r\n            [\"X-Client-Version\" /* HttpHeader.X_CLIENT_VERSION */]: this.clientVersion\r\n        };\r\n        if (this.app.options.appId) {\r\n            headers[\"X-Firebase-gmpid\" /* HttpHeader.X_FIREBASE_GMPID */] = this.app.options.appId;\r\n        }\r\n        // If the heartbeat service exists, add the heartbeat string\r\n        const heartbeatsHeader = await ((_a = this.heartbeatServiceProvider\r\n            .getImmediate({\r\n            optional: true\r\n        })) === null || _a === void 0 ? void 0 : _a.getHeartbeatsHeader());\r\n        if (heartbeatsHeader) {\r\n            headers[\"X-Firebase-Client\" /* HttpHeader.X_FIREBASE_CLIENT */] = heartbeatsHeader;\r\n        }\r\n        // If the App Check service exists, add the App Check token in the headers\r\n        const appCheckToken = await this._getAppCheckToken();\r\n        if (appCheckToken) {\r\n            headers[\"X-Firebase-AppCheck\" /* HttpHeader.X_FIREBASE_APP_CHECK */] = appCheckToken;\r\n        }\r\n        return headers;\r\n    }\r\n    async _getAppCheckToken() {\r\n        var _a;\r\n        const appCheckTokenResult = await ((_a = this.appCheckServiceProvider\r\n            .getImmediate({ optional: true })) === null || _a === void 0 ? void 0 : _a.getToken());\r\n        if (appCheckTokenResult === null || appCheckTokenResult === void 0 ? void 0 : appCheckTokenResult.error) {\r\n            // Context: appCheck.getToken() will never throw even if an error happened.\r\n            // In the error case, a dummy token will be returned along with an error field describing\r\n            // the error. In general, we shouldn't care about the error condition and just use\r\n            // the token (actual or dummy) to send requests.\r\n            _logWarn(`Error while retrieving App Check token: ${appCheckTokenResult.error}`);\r\n        }\r\n        return appCheckTokenResult === null || appCheckTokenResult === void 0 ? void 0 : appCheckTokenResult.token;\r\n    }\r\n}\r\n/**\r\n * Method to be used to cast down to our private implmentation of Auth.\r\n * It will also handle unwrapping from the compat type if necessary\r\n *\r\n * @param auth Auth object passed in from developer\r\n */\r\nfunction _castAuth(auth) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth);\r\n}\r\n/** Helper class to wrap subscriber logic */\r\nclass Subscription {\r\n    constructor(auth) {\r\n        this.auth = auth;\r\n        this.observer = null;\r\n        this.addObserver = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.createSubscribe)(observer => (this.observer = observer));\r\n    }\r\n    get next() {\r\n        _assert(this.observer, this.auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        return this.observer.next.bind(this.observer);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction getScriptParentElement() {\r\n    var _a, _b;\r\n    return (_b = (_a = document.getElementsByTagName('head')) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : document;\r\n}\r\nfunction _loadJS(url) {\r\n    // TODO: consider adding timeout support & cancellation\r\n    return new Promise((resolve, reject) => {\r\n        const el = document.createElement('script');\r\n        el.setAttribute('src', url);\r\n        el.onload = resolve;\r\n        el.onerror = e => {\r\n            const error = _createError(\"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n            error.customData = e;\r\n            reject(error);\r\n        };\r\n        el.type = 'text/javascript';\r\n        el.charset = 'UTF-8';\r\n        getScriptParentElement().appendChild(el);\r\n    });\r\n}\n\n/* eslint-disable @typescript-eslint/no-require-imports */\r\nconst RECAPTCHA_ENTERPRISE_URL = 'https://www.google.com/recaptcha/enterprise.js?render=';\r\nconst RECAPTCHA_ENTERPRISE_VERIFIER_TYPE = 'recaptcha-enterprise';\r\nconst FAKE_TOKEN = 'NO_RECAPTCHA';\r\nclass RecaptchaEnterpriseVerifier {\r\n    /**\r\n     *\r\n     * @param authExtern - The corresponding Firebase {@link Auth} instance.\r\n     *\r\n     */\r\n    constructor(authExtern) {\r\n        /**\r\n         * Identifies the type of application verifier (e.g. \"recaptcha-enterprise\").\r\n         */\r\n        this.type = RECAPTCHA_ENTERPRISE_VERIFIER_TYPE;\r\n        this.auth = _castAuth(authExtern);\r\n    }\r\n    /**\r\n     * Executes the verification process.\r\n     *\r\n     * @returns A Promise for a token that can be used to assert the validity of a request.\r\n     */\r\n    async verify(action = 'verify', forceRefresh = false) {\r\n        async function retrieveSiteKey(auth) {\r\n            if (!forceRefresh) {\r\n                if (auth.tenantId == null && auth._agentRecaptchaConfig != null) {\r\n                    return auth._agentRecaptchaConfig.siteKey;\r\n                }\r\n                if (auth.tenantId != null &&\r\n                    auth._tenantRecaptchaConfigs[auth.tenantId] !== undefined) {\r\n                    return auth._tenantRecaptchaConfigs[auth.tenantId].siteKey;\r\n                }\r\n            }\r\n            return new Promise(async (resolve, reject) => {\r\n                getRecaptchaConfig(auth, {\r\n                    clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */,\r\n                    version: \"RECAPTCHA_ENTERPRISE\" /* RecaptchaVersion.ENTERPRISE */\r\n                })\r\n                    .then(response => {\r\n                    if (response.recaptchaKey === undefined) {\r\n                        reject(new Error('recaptcha Enterprise site key undefined'));\r\n                    }\r\n                    else {\r\n                        const config = new RecaptchaConfig(response);\r\n                        if (auth.tenantId == null) {\r\n                            auth._agentRecaptchaConfig = config;\r\n                        }\r\n                        else {\r\n                            auth._tenantRecaptchaConfigs[auth.tenantId] = config;\r\n                        }\r\n                        return resolve(config.siteKey);\r\n                    }\r\n                })\r\n                    .catch(error => {\r\n                    reject(error);\r\n                });\r\n            });\r\n        }\r\n        function retrieveRecaptchaToken(siteKey, resolve, reject) {\r\n            const grecaptcha = window.grecaptcha;\r\n            if (isEnterprise(grecaptcha)) {\r\n                grecaptcha.enterprise.ready(() => {\r\n                    grecaptcha.enterprise\r\n                        .execute(siteKey, { action })\r\n                        .then(token => {\r\n                        resolve(token);\r\n                    })\r\n                        .catch(() => {\r\n                        resolve(FAKE_TOKEN);\r\n                    });\r\n                });\r\n            }\r\n            else {\r\n                reject(Error('No reCAPTCHA enterprise script loaded.'));\r\n            }\r\n        }\r\n        return new Promise((resolve, reject) => {\r\n            retrieveSiteKey(this.auth)\r\n                .then(siteKey => {\r\n                if (!forceRefresh && isEnterprise(window.grecaptcha)) {\r\n                    retrieveRecaptchaToken(siteKey, resolve, reject);\r\n                }\r\n                else {\r\n                    if (typeof window === 'undefined') {\r\n                        reject(new Error('RecaptchaVerifier is only supported in browser'));\r\n                        return;\r\n                    }\r\n                    _loadJS(RECAPTCHA_ENTERPRISE_URL + siteKey)\r\n                        .then(() => {\r\n                        retrieveRecaptchaToken(siteKey, resolve, reject);\r\n                    })\r\n                        .catch(error => {\r\n                        reject(error);\r\n                    });\r\n                }\r\n            })\r\n                .catch(error => {\r\n                reject(error);\r\n            });\r\n        });\r\n    }\r\n}\r\nasync function injectRecaptchaFields(auth, request, action, captchaResp = false) {\r\n    const verifier = new RecaptchaEnterpriseVerifier(auth);\r\n    let captchaResponse;\r\n    try {\r\n        captchaResponse = await verifier.verify(action);\r\n    }\r\n    catch (error) {\r\n        captchaResponse = await verifier.verify(action, true);\r\n    }\r\n    const newRequest = Object.assign({}, request);\r\n    if (!captchaResp) {\r\n        Object.assign(newRequest, { captchaResponse });\r\n    }\r\n    else {\r\n        Object.assign(newRequest, { 'captchaResp': captchaResponse });\r\n    }\r\n    Object.assign(newRequest, { 'clientType': \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */ });\r\n    Object.assign(newRequest, {\r\n        'recaptchaVersion': \"RECAPTCHA_ENTERPRISE\" /* RecaptchaVersion.ENTERPRISE */\r\n    });\r\n    return newRequest;\r\n}\r\nasync function handleRecaptchaFlow(authInstance, request, actionName, actionMethod) {\r\n    var _a;\r\n    if ((_a = authInstance\r\n        ._getRecaptchaConfig()) === null || _a === void 0 ? void 0 : _a.isProviderEnabled(\"EMAIL_PASSWORD_PROVIDER\" /* RecaptchaProvider.EMAIL_PASSWORD_PROVIDER */)) {\r\n        const requestWithRecaptcha = await injectRecaptchaFields(authInstance, request, actionName, actionName === \"getOobCode\" /* RecaptchaActionName.GET_OOB_CODE */);\r\n        return actionMethod(authInstance, requestWithRecaptcha);\r\n    }\r\n    else {\r\n        return actionMethod(authInstance, request).catch(async (error) => {\r\n            if (error.code === `auth/${\"missing-recaptcha-token\" /* AuthErrorCode.MISSING_RECAPTCHA_TOKEN */}`) {\r\n                console.log(`${actionName} is protected by reCAPTCHA Enterprise for this project. Automatically triggering the reCAPTCHA flow and restarting the flow.`);\r\n                const requestWithRecaptcha = await injectRecaptchaFields(authInstance, request, actionName, actionName === \"getOobCode\" /* RecaptchaActionName.GET_OOB_CODE */);\r\n                return actionMethod(authInstance, requestWithRecaptcha);\r\n            }\r\n            else {\r\n                return Promise.reject(error);\r\n            }\r\n        });\r\n    }\r\n}\r\nasync function _initializeRecaptchaConfig(auth) {\r\n    const authInternal = _castAuth(auth);\r\n    const response = await getRecaptchaConfig(authInternal, {\r\n        clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */,\r\n        version: \"RECAPTCHA_ENTERPRISE\" /* RecaptchaVersion.ENTERPRISE */\r\n    });\r\n    const config = new RecaptchaConfig(response);\r\n    if (authInternal.tenantId == null) {\r\n        authInternal._agentRecaptchaConfig = config;\r\n    }\r\n    else {\r\n        authInternal._tenantRecaptchaConfigs[authInternal.tenantId] = config;\r\n    }\r\n    if (config.isProviderEnabled(\"EMAIL_PASSWORD_PROVIDER\" /* RecaptchaProvider.EMAIL_PASSWORD_PROVIDER */)) {\r\n        const verifier = new RecaptchaEnterpriseVerifier(authInternal);\r\n        void verifier.verify();\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Initializes an {@link Auth} instance with fine-grained control over\r\n * {@link Dependencies}.\r\n *\r\n * @remarks\r\n *\r\n * This function allows more control over the {@link Auth} instance than\r\n * {@link getAuth}. `getAuth` uses platform-specific defaults to supply\r\n * the {@link Dependencies}. In general, `getAuth` is the easiest way to\r\n * initialize Auth and works for most use cases. Use `initializeAuth` if you\r\n * need control over which persistence layer is used, or to minimize bundle\r\n * size if you're not using either `signInWithPopup` or `signInWithRedirect`.\r\n *\r\n * For example, if your app only uses anonymous accounts and you only want\r\n * accounts saved for the current session, initialize `Auth` with:\r\n *\r\n * ```js\r\n * const auth = initializeAuth(app, {\r\n *   persistence: browserSessionPersistence,\r\n *   popupRedirectResolver: undefined,\r\n * });\r\n * ```\r\n *\r\n * @public\r\n */\r\nfunction initializeAuth(app, deps) {\r\n    const provider = (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__._getProvider)(app, 'auth');\r\n    if (provider.isInitialized()) {\r\n        const auth = provider.getImmediate();\r\n        const initialOptions = provider.getOptions();\r\n        if ((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.deepEqual)(initialOptions, deps !== null && deps !== void 0 ? deps : {})) {\r\n            return auth;\r\n        }\r\n        else {\r\n            _fail(auth, \"already-initialized\" /* AuthErrorCode.ALREADY_INITIALIZED */);\r\n        }\r\n    }\r\n    const auth = provider.initialize({ options: deps });\r\n    return auth;\r\n}\r\nfunction _initializeAuthInstance(auth, deps) {\r\n    const persistence = (deps === null || deps === void 0 ? void 0 : deps.persistence) || [];\r\n    const hierarchy = (Array.isArray(persistence) ? persistence : [persistence]).map(_getInstance);\r\n    if (deps === null || deps === void 0 ? void 0 : deps.errorMap) {\r\n        auth._updateErrorMap(deps.errorMap);\r\n    }\r\n    // This promise is intended to float; auth initialization happens in the\r\n    // background, meanwhile the auth object may be used by the app.\r\n    // eslint-disable-next-line @typescript-eslint/no-floating-promises\r\n    auth._initializeWithPersistence(hierarchy, deps === null || deps === void 0 ? void 0 : deps.popupRedirectResolver);\r\n}\n\n/**\r\n * Changes the {@link Auth} instance to communicate with the Firebase Auth Emulator, instead of production\r\n * Firebase Auth services.\r\n *\r\n * @remarks\r\n * This must be called synchronously immediately following the first call to\r\n * {@link initializeAuth}.  Do not use with production credentials as emulator\r\n * traffic is not encrypted.\r\n *\r\n *\r\n * @example\r\n * ```javascript\r\n * connectAuthEmulator(auth, 'http://127.0.0.1:9099', { disableWarnings: true });\r\n * ```\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param url - The URL at which the emulator is running (eg, 'http://localhost:9099').\r\n * @param options - Optional. `options.disableWarnings` defaults to `false`. Set it to\r\n * `true` to disable the warning banner attached to the DOM.\r\n *\r\n * @public\r\n */\r\nfunction connectAuthEmulator(auth, url, options) {\r\n    const authInternal = _castAuth(auth);\r\n    _assert(authInternal._canInitEmulator, authInternal, \"emulator-config-failed\" /* AuthErrorCode.EMULATOR_CONFIG_FAILED */);\r\n    _assert(/^https?:\\/\\//.test(url), authInternal, \"invalid-emulator-scheme\" /* AuthErrorCode.INVALID_EMULATOR_SCHEME */);\r\n    const disableWarnings = !!(options === null || options === void 0 ? void 0 : options.disableWarnings);\r\n    const protocol = extractProtocol(url);\r\n    const { host, port } = extractHostAndPort(url);\r\n    const portStr = port === null ? '' : `:${port}`;\r\n    // Always replace path with \"/\" (even if input url had no path at all, or had a different one).\r\n    authInternal.config.emulator = { url: `${protocol}//${host}${portStr}/` };\r\n    authInternal.settings.appVerificationDisabledForTesting = true;\r\n    authInternal.emulatorConfig = Object.freeze({\r\n        host,\r\n        port,\r\n        protocol: protocol.replace(':', ''),\r\n        options: Object.freeze({ disableWarnings })\r\n    });\r\n    if (!disableWarnings) {\r\n        emitEmulatorWarning();\r\n    }\r\n}\r\nfunction extractProtocol(url) {\r\n    const protocolEnd = url.indexOf(':');\r\n    return protocolEnd < 0 ? '' : url.substr(0, protocolEnd + 1);\r\n}\r\nfunction extractHostAndPort(url) {\r\n    const protocol = extractProtocol(url);\r\n    const authority = /(\\/\\/)?([^?#/]+)/.exec(url.substr(protocol.length)); // Between // and /, ? or #.\r\n    if (!authority) {\r\n        return { host: '', port: null };\r\n    }\r\n    const hostAndPort = authority[2].split('@').pop() || ''; // Strip out \"username:password@\".\r\n    const bracketedIPv6 = /^(\\[[^\\]]+\\])(:|$)/.exec(hostAndPort);\r\n    if (bracketedIPv6) {\r\n        const host = bracketedIPv6[1];\r\n        return { host, port: parsePort(hostAndPort.substr(host.length + 1)) };\r\n    }\r\n    else {\r\n        const [host, port] = hostAndPort.split(':');\r\n        return { host, port: parsePort(port) };\r\n    }\r\n}\r\nfunction parsePort(portStr) {\r\n    if (!portStr) {\r\n        return null;\r\n    }\r\n    const port = Number(portStr);\r\n    if (isNaN(port)) {\r\n        return null;\r\n    }\r\n    return port;\r\n}\r\nfunction emitEmulatorWarning() {\r\n    function attachBanner() {\r\n        const el = document.createElement('p');\r\n        const sty = el.style;\r\n        el.innerText =\r\n            'Running in emulator mode. Do not use with production credentials.';\r\n        sty.position = 'fixed';\r\n        sty.width = '100%';\r\n        sty.backgroundColor = '#ffffff';\r\n        sty.border = '.1em solid #000000';\r\n        sty.color = '#b50000';\r\n        sty.bottom = '0px';\r\n        sty.left = '0px';\r\n        sty.margin = '0px';\r\n        sty.zIndex = '10000';\r\n        sty.textAlign = 'center';\r\n        el.classList.add('firebase-emulator-warning');\r\n        document.body.appendChild(el);\r\n    }\r\n    if (typeof console !== 'undefined' && typeof console.info === 'function') {\r\n        console.info('WARNING: You are using the Auth Emulator,' +\r\n            ' which is intended for local testing only.  Do not use with' +\r\n            ' production credentials.');\r\n    }\r\n    if (typeof window !== 'undefined' && typeof document !== 'undefined') {\r\n        if (document.readyState === 'loading') {\r\n            window.addEventListener('DOMContentLoaded', attachBanner);\r\n        }\r\n        else {\r\n            attachBanner();\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Interface that represents the credentials returned by an {@link AuthProvider}.\r\n *\r\n * @remarks\r\n * Implementations specify the details about each auth provider's credential requirements.\r\n *\r\n * @public\r\n */\r\nclass AuthCredential {\r\n    /** @internal */\r\n    constructor(\r\n    /**\r\n     * The authentication provider ID for the credential.\r\n     *\r\n     * @remarks\r\n     * For example, 'facebook.com', or 'google.com'.\r\n     */\r\n    providerId, \r\n    /**\r\n     * The authentication sign in method for the credential.\r\n     *\r\n     * @remarks\r\n     * For example, {@link SignInMethod}.EMAIL_PASSWORD, or\r\n     * {@link SignInMethod}.EMAIL_LINK. This corresponds to the sign-in method\r\n     * identifier as returned in {@link fetchSignInMethodsForEmail}.\r\n     */\r\n    signInMethod) {\r\n        this.providerId = providerId;\r\n        this.signInMethod = signInMethod;\r\n    }\r\n    /**\r\n     * Returns a JSON-serializable representation of this object.\r\n     *\r\n     * @returns a JSON-serializable representation of this object.\r\n     */\r\n    toJSON() {\r\n        return debugFail('not implemented');\r\n    }\r\n    /** @internal */\r\n    _getIdTokenResponse(_auth) {\r\n        return debugFail('not implemented');\r\n    }\r\n    /** @internal */\r\n    _linkToIdToken(_auth, _idToken) {\r\n        return debugFail('not implemented');\r\n    }\r\n    /** @internal */\r\n    _getReauthenticationResolver(_auth) {\r\n        return debugFail('not implemented');\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function resetPassword(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:resetPassword\" /* Endpoint.RESET_PASSWORD */, _addTidIfNecessary(auth, request));\r\n}\r\nasync function updateEmailPassword(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:update\" /* Endpoint.SET_ACCOUNT_INFO */, request);\r\n}\r\n// Used for linking an email/password account to an existing idToken. Uses the same request/response\r\n// format as updateEmailPassword.\r\nasync function linkEmailPassword(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signUp\" /* Endpoint.SIGN_UP */, request);\r\n}\r\nasync function applyActionCode$1(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:update\" /* Endpoint.SET_ACCOUNT_INFO */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function signInWithPassword(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithPassword\" /* Endpoint.SIGN_IN_WITH_PASSWORD */, _addTidIfNecessary(auth, request));\r\n}\r\nasync function sendOobCode(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:sendOobCode\" /* Endpoint.SEND_OOB_CODE */, _addTidIfNecessary(auth, request));\r\n}\r\nasync function sendEmailVerification$1(auth, request) {\r\n    return sendOobCode(auth, request);\r\n}\r\nasync function sendPasswordResetEmail$1(auth, request) {\r\n    return sendOobCode(auth, request);\r\n}\r\nasync function sendSignInLinkToEmail$1(auth, request) {\r\n    return sendOobCode(auth, request);\r\n}\r\nasync function verifyAndChangeEmail(auth, request) {\r\n    return sendOobCode(auth, request);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function signInWithEmailLink$1(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithEmailLink\" /* Endpoint.SIGN_IN_WITH_EMAIL_LINK */, _addTidIfNecessary(auth, request));\r\n}\r\nasync function signInWithEmailLinkForLinking(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithEmailLink\" /* Endpoint.SIGN_IN_WITH_EMAIL_LINK */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Interface that represents the credentials returned by {@link EmailAuthProvider} for\r\n * {@link ProviderId}.PASSWORD\r\n *\r\n * @remarks\r\n * Covers both {@link SignInMethod}.EMAIL_PASSWORD and\r\n * {@link SignInMethod}.EMAIL_LINK.\r\n *\r\n * @public\r\n */\r\nclass EmailAuthCredential extends AuthCredential {\r\n    /** @internal */\r\n    constructor(\r\n    /** @internal */\r\n    _email, \r\n    /** @internal */\r\n    _password, signInMethod, \r\n    /** @internal */\r\n    _tenantId = null) {\r\n        super(\"password\" /* ProviderId.PASSWORD */, signInMethod);\r\n        this._email = _email;\r\n        this._password = _password;\r\n        this._tenantId = _tenantId;\r\n    }\r\n    /** @internal */\r\n    static _fromEmailAndPassword(email, password) {\r\n        return new EmailAuthCredential(email, password, \"password\" /* SignInMethod.EMAIL_PASSWORD */);\r\n    }\r\n    /** @internal */\r\n    static _fromEmailAndCode(email, oobCode, tenantId = null) {\r\n        return new EmailAuthCredential(email, oobCode, \"emailLink\" /* SignInMethod.EMAIL_LINK */, tenantId);\r\n    }\r\n    /** {@inheritdoc AuthCredential.toJSON} */\r\n    toJSON() {\r\n        return {\r\n            email: this._email,\r\n            password: this._password,\r\n            signInMethod: this.signInMethod,\r\n            tenantId: this._tenantId\r\n        };\r\n    }\r\n    /**\r\n     * Static method to deserialize a JSON representation of an object into an {@link  AuthCredential}.\r\n     *\r\n     * @param json - Either `object` or the stringified representation of the object. When string is\r\n     * provided, `JSON.parse` would be called first.\r\n     *\r\n     * @returns If the JSON input does not represent an {@link AuthCredential}, null is returned.\r\n     */\r\n    static fromJSON(json) {\r\n        const obj = typeof json === 'string' ? JSON.parse(json) : json;\r\n        if ((obj === null || obj === void 0 ? void 0 : obj.email) && (obj === null || obj === void 0 ? void 0 : obj.password)) {\r\n            if (obj.signInMethod === \"password\" /* SignInMethod.EMAIL_PASSWORD */) {\r\n                return this._fromEmailAndPassword(obj.email, obj.password);\r\n            }\r\n            else if (obj.signInMethod === \"emailLink\" /* SignInMethod.EMAIL_LINK */) {\r\n                return this._fromEmailAndCode(obj.email, obj.password, obj.tenantId);\r\n            }\r\n        }\r\n        return null;\r\n    }\r\n    /** @internal */\r\n    async _getIdTokenResponse(auth) {\r\n        switch (this.signInMethod) {\r\n            case \"password\" /* SignInMethod.EMAIL_PASSWORD */:\r\n                const request = {\r\n                    returnSecureToken: true,\r\n                    email: this._email,\r\n                    password: this._password,\r\n                    clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */\r\n                };\r\n                return handleRecaptchaFlow(auth, request, \"signInWithPassword\" /* RecaptchaActionName.SIGN_IN_WITH_PASSWORD */, signInWithPassword);\r\n            case \"emailLink\" /* SignInMethod.EMAIL_LINK */:\r\n                return signInWithEmailLink$1(auth, {\r\n                    email: this._email,\r\n                    oobCode: this._password\r\n                });\r\n            default:\r\n                _fail(auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        }\r\n    }\r\n    /** @internal */\r\n    async _linkToIdToken(auth, idToken) {\r\n        switch (this.signInMethod) {\r\n            case \"password\" /* SignInMethod.EMAIL_PASSWORD */:\r\n                const request = {\r\n                    idToken,\r\n                    returnSecureToken: true,\r\n                    email: this._email,\r\n                    password: this._password,\r\n                    clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */\r\n                };\r\n                return handleRecaptchaFlow(auth, request, \"signUpPassword\" /* RecaptchaActionName.SIGN_UP_PASSWORD */, linkEmailPassword);\r\n            case \"emailLink\" /* SignInMethod.EMAIL_LINK */:\r\n                return signInWithEmailLinkForLinking(auth, {\r\n                    idToken,\r\n                    email: this._email,\r\n                    oobCode: this._password\r\n                });\r\n            default:\r\n                _fail(auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        }\r\n    }\r\n    /** @internal */\r\n    _getReauthenticationResolver(auth) {\r\n        return this._getIdTokenResponse(auth);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function signInWithIdp(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithIdp\" /* Endpoint.SIGN_IN_WITH_IDP */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst IDP_REQUEST_URI$1 = 'http://localhost';\r\n/**\r\n * Represents the OAuth credentials returned by an {@link OAuthProvider}.\r\n *\r\n * @remarks\r\n * Implementations specify the details about each auth provider's credential requirements.\r\n *\r\n * @public\r\n */\r\nclass OAuthCredential extends AuthCredential {\r\n    constructor() {\r\n        super(...arguments);\r\n        this.pendingToken = null;\r\n    }\r\n    /** @internal */\r\n    static _fromParams(params) {\r\n        const cred = new OAuthCredential(params.providerId, params.signInMethod);\r\n        if (params.idToken || params.accessToken) {\r\n            // OAuth 2 and either ID token or access token.\r\n            if (params.idToken) {\r\n                cred.idToken = params.idToken;\r\n            }\r\n            if (params.accessToken) {\r\n                cred.accessToken = params.accessToken;\r\n            }\r\n            // Add nonce if available and no pendingToken is present.\r\n            if (params.nonce && !params.pendingToken) {\r\n                cred.nonce = params.nonce;\r\n            }\r\n            if (params.pendingToken) {\r\n                cred.pendingToken = params.pendingToken;\r\n            }\r\n        }\r\n        else if (params.oauthToken && params.oauthTokenSecret) {\r\n            // OAuth 1 and OAuth token with token secret\r\n            cred.accessToken = params.oauthToken;\r\n            cred.secret = params.oauthTokenSecret;\r\n        }\r\n        else {\r\n            _fail(\"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        }\r\n        return cred;\r\n    }\r\n    /** {@inheritdoc AuthCredential.toJSON}  */\r\n    toJSON() {\r\n        return {\r\n            idToken: this.idToken,\r\n            accessToken: this.accessToken,\r\n            secret: this.secret,\r\n            nonce: this.nonce,\r\n            pendingToken: this.pendingToken,\r\n            providerId: this.providerId,\r\n            signInMethod: this.signInMethod\r\n        };\r\n    }\r\n    /**\r\n     * Static method to deserialize a JSON representation of an object into an\r\n     * {@link  AuthCredential}.\r\n     *\r\n     * @param json - Input can be either Object or the stringified representation of the object.\r\n     * When string is provided, JSON.parse would be called first.\r\n     *\r\n     * @returns If the JSON input does not represent an {@link  AuthCredential}, null is returned.\r\n     */\r\n    static fromJSON(json) {\r\n        const obj = typeof json === 'string' ? JSON.parse(json) : json;\r\n        const { providerId, signInMethod } = obj, rest = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__rest)(obj, [\"providerId\", \"signInMethod\"]);\r\n        if (!providerId || !signInMethod) {\r\n            return null;\r\n        }\r\n        const cred = new OAuthCredential(providerId, signInMethod);\r\n        cred.idToken = rest.idToken || undefined;\r\n        cred.accessToken = rest.accessToken || undefined;\r\n        cred.secret = rest.secret;\r\n        cred.nonce = rest.nonce;\r\n        cred.pendingToken = rest.pendingToken || null;\r\n        return cred;\r\n    }\r\n    /** @internal */\r\n    _getIdTokenResponse(auth) {\r\n        const request = this.buildRequest();\r\n        return signInWithIdp(auth, request);\r\n    }\r\n    /** @internal */\r\n    _linkToIdToken(auth, idToken) {\r\n        const request = this.buildRequest();\r\n        request.idToken = idToken;\r\n        return signInWithIdp(auth, request);\r\n    }\r\n    /** @internal */\r\n    _getReauthenticationResolver(auth) {\r\n        const request = this.buildRequest();\r\n        request.autoCreate = false;\r\n        return signInWithIdp(auth, request);\r\n    }\r\n    buildRequest() {\r\n        const request = {\r\n            requestUri: IDP_REQUEST_URI$1,\r\n            returnSecureToken: true\r\n        };\r\n        if (this.pendingToken) {\r\n            request.pendingToken = this.pendingToken;\r\n        }\r\n        else {\r\n            const postBody = {};\r\n            if (this.idToken) {\r\n                postBody['id_token'] = this.idToken;\r\n            }\r\n            if (this.accessToken) {\r\n                postBody['access_token'] = this.accessToken;\r\n            }\r\n            if (this.secret) {\r\n                postBody['oauth_token_secret'] = this.secret;\r\n            }\r\n            postBody['providerId'] = this.providerId;\r\n            if (this.nonce && !this.pendingToken) {\r\n                postBody['nonce'] = this.nonce;\r\n            }\r\n            request.postBody = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystring)(postBody);\r\n        }\r\n        return request;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function signInWithPhoneNumber$1(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithPhoneNumber\" /* Endpoint.SIGN_IN_WITH_PHONE_NUMBER */, _addTidIfNecessary(auth, request));\r\n}\r\nasync function linkWithPhoneNumber$1(auth, request) {\r\n    const response = await _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithPhoneNumber\" /* Endpoint.SIGN_IN_WITH_PHONE_NUMBER */, _addTidIfNecessary(auth, request));\r\n    if (response.temporaryProof) {\r\n        throw _makeTaggedError(auth, \"account-exists-with-different-credential\" /* AuthErrorCode.NEED_CONFIRMATION */, response);\r\n    }\r\n    return response;\r\n}\r\nconst VERIFY_PHONE_NUMBER_FOR_EXISTING_ERROR_MAP_ = {\r\n    [\"USER_NOT_FOUND\" /* ServerError.USER_NOT_FOUND */]: \"user-not-found\" /* AuthErrorCode.USER_DELETED */\r\n};\r\nasync function verifyPhoneNumberForExisting(auth, request) {\r\n    const apiRequest = Object.assign(Object.assign({}, request), { operation: 'REAUTH' });\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithPhoneNumber\" /* Endpoint.SIGN_IN_WITH_PHONE_NUMBER */, _addTidIfNecessary(auth, apiRequest), VERIFY_PHONE_NUMBER_FOR_EXISTING_ERROR_MAP_);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Represents the credentials returned by {@link PhoneAuthProvider}.\r\n *\r\n * @public\r\n */\r\nclass PhoneAuthCredential extends AuthCredential {\r\n    constructor(params) {\r\n        super(\"phone\" /* ProviderId.PHONE */, \"phone\" /* SignInMethod.PHONE */);\r\n        this.params = params;\r\n    }\r\n    /** @internal */\r\n    static _fromVerification(verificationId, verificationCode) {\r\n        return new PhoneAuthCredential({ verificationId, verificationCode });\r\n    }\r\n    /** @internal */\r\n    static _fromTokenResponse(phoneNumber, temporaryProof) {\r\n        return new PhoneAuthCredential({ phoneNumber, temporaryProof });\r\n    }\r\n    /** @internal */\r\n    _getIdTokenResponse(auth) {\r\n        return signInWithPhoneNumber$1(auth, this._makeVerificationRequest());\r\n    }\r\n    /** @internal */\r\n    _linkToIdToken(auth, idToken) {\r\n        return linkWithPhoneNumber$1(auth, Object.assign({ idToken }, this._makeVerificationRequest()));\r\n    }\r\n    /** @internal */\r\n    _getReauthenticationResolver(auth) {\r\n        return verifyPhoneNumberForExisting(auth, this._makeVerificationRequest());\r\n    }\r\n    /** @internal */\r\n    _makeVerificationRequest() {\r\n        const { temporaryProof, phoneNumber, verificationId, verificationCode } = this.params;\r\n        if (temporaryProof && phoneNumber) {\r\n            return { temporaryProof, phoneNumber };\r\n        }\r\n        return {\r\n            sessionInfo: verificationId,\r\n            code: verificationCode\r\n        };\r\n    }\r\n    /** {@inheritdoc AuthCredential.toJSON} */\r\n    toJSON() {\r\n        const obj = {\r\n            providerId: this.providerId\r\n        };\r\n        if (this.params.phoneNumber) {\r\n            obj.phoneNumber = this.params.phoneNumber;\r\n        }\r\n        if (this.params.temporaryProof) {\r\n            obj.temporaryProof = this.params.temporaryProof;\r\n        }\r\n        if (this.params.verificationCode) {\r\n            obj.verificationCode = this.params.verificationCode;\r\n        }\r\n        if (this.params.verificationId) {\r\n            obj.verificationId = this.params.verificationId;\r\n        }\r\n        return obj;\r\n    }\r\n    /** Generates a phone credential based on a plain object or a JSON string. */\r\n    static fromJSON(json) {\r\n        if (typeof json === 'string') {\r\n            json = JSON.parse(json);\r\n        }\r\n        const { verificationId, verificationCode, phoneNumber, temporaryProof } = json;\r\n        if (!verificationCode &&\r\n            !verificationId &&\r\n            !phoneNumber &&\r\n            !temporaryProof) {\r\n            return null;\r\n        }\r\n        return new PhoneAuthCredential({\r\n            verificationId,\r\n            verificationCode,\r\n            phoneNumber,\r\n            temporaryProof\r\n        });\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Maps the mode string in action code URL to Action Code Info operation.\r\n *\r\n * @param mode\r\n */\r\nfunction parseMode(mode) {\r\n    switch (mode) {\r\n        case 'recoverEmail':\r\n            return \"RECOVER_EMAIL\" /* ActionCodeOperation.RECOVER_EMAIL */;\r\n        case 'resetPassword':\r\n            return \"PASSWORD_RESET\" /* ActionCodeOperation.PASSWORD_RESET */;\r\n        case 'signIn':\r\n            return \"EMAIL_SIGNIN\" /* ActionCodeOperation.EMAIL_SIGNIN */;\r\n        case 'verifyEmail':\r\n            return \"VERIFY_EMAIL\" /* ActionCodeOperation.VERIFY_EMAIL */;\r\n        case 'verifyAndChangeEmail':\r\n            return \"VERIFY_AND_CHANGE_EMAIL\" /* ActionCodeOperation.VERIFY_AND_CHANGE_EMAIL */;\r\n        case 'revertSecondFactorAddition':\r\n            return \"REVERT_SECOND_FACTOR_ADDITION\" /* ActionCodeOperation.REVERT_SECOND_FACTOR_ADDITION */;\r\n        default:\r\n            return null;\r\n    }\r\n}\r\n/**\r\n * Helper to parse FDL links\r\n *\r\n * @param url\r\n */\r\nfunction parseDeepLink(url) {\r\n    const link = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystringDecode)((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.extractQuerystring)(url))['link'];\r\n    // Double link case (automatic redirect).\r\n    const doubleDeepLink = link\r\n        ? (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystringDecode)((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.extractQuerystring)(link))['deep_link_id']\r\n        : null;\r\n    // iOS custom scheme links.\r\n    const iOSDeepLink = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystringDecode)((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.extractQuerystring)(url))['deep_link_id'];\r\n    const iOSDoubleDeepLink = iOSDeepLink\r\n        ? (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystringDecode)((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.extractQuerystring)(iOSDeepLink))['link']\r\n        : null;\r\n    return iOSDoubleDeepLink || iOSDeepLink || doubleDeepLink || link || url;\r\n}\r\n/**\r\n * A utility class to parse email action URLs such as password reset, email verification,\r\n * email link sign in, etc.\r\n *\r\n * @public\r\n */\r\nclass ActionCodeURL {\r\n    /**\r\n     * @param actionLink - The link from which to extract the URL.\r\n     * @returns The {@link ActionCodeURL} object, or null if the link is invalid.\r\n     *\r\n     * @internal\r\n     */\r\n    constructor(actionLink) {\r\n        var _a, _b, _c, _d, _e, _f;\r\n        const searchParams = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.querystringDecode)((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.extractQuerystring)(actionLink));\r\n        const apiKey = (_a = searchParams[\"apiKey\" /* QueryField.API_KEY */]) !== null && _a !== void 0 ? _a : null;\r\n        const code = (_b = searchParams[\"oobCode\" /* QueryField.CODE */]) !== null && _b !== void 0 ? _b : null;\r\n        const operation = parseMode((_c = searchParams[\"mode\" /* QueryField.MODE */]) !== null && _c !== void 0 ? _c : null);\r\n        // Validate API key, code and mode.\r\n        _assert(apiKey && code && operation, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        this.apiKey = apiKey;\r\n        this.operation = operation;\r\n        this.code = code;\r\n        this.continueUrl = (_d = searchParams[\"continueUrl\" /* QueryField.CONTINUE_URL */]) !== null && _d !== void 0 ? _d : null;\r\n        this.languageCode = (_e = searchParams[\"languageCode\" /* QueryField.LANGUAGE_CODE */]) !== null && _e !== void 0 ? _e : null;\r\n        this.tenantId = (_f = searchParams[\"tenantId\" /* QueryField.TENANT_ID */]) !== null && _f !== void 0 ? _f : null;\r\n    }\r\n    /**\r\n     * Parses the email action link string and returns an {@link ActionCodeURL} if the link is valid,\r\n     * otherwise returns null.\r\n     *\r\n     * @param link  - The email action link string.\r\n     * @returns The {@link ActionCodeURL} object, or null if the link is invalid.\r\n     *\r\n     * @public\r\n     */\r\n    static parseLink(link) {\r\n        const actionLink = parseDeepLink(link);\r\n        try {\r\n            return new ActionCodeURL(actionLink);\r\n        }\r\n        catch (_a) {\r\n            return null;\r\n        }\r\n    }\r\n}\r\n/**\r\n * Parses the email action link string and returns an {@link ActionCodeURL} if\r\n * the link is valid, otherwise returns null.\r\n *\r\n * @public\r\n */\r\nfunction parseActionCodeURL(link) {\r\n    return ActionCodeURL.parseLink(link);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Provider for generating {@link EmailAuthCredential}.\r\n *\r\n * @public\r\n */\r\nclass EmailAuthProvider {\r\n    constructor() {\r\n        /**\r\n         * Always set to {@link ProviderId}.PASSWORD, even for email link.\r\n         */\r\n        this.providerId = EmailAuthProvider.PROVIDER_ID;\r\n    }\r\n    /**\r\n     * Initialize an {@link AuthCredential} using an email and password.\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * const authCredential = EmailAuthProvider.credential(email, password);\r\n     * const userCredential = await signInWithCredential(auth, authCredential);\r\n     * ```\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * const userCredential = await signInWithEmailAndPassword(auth, email, password);\r\n     * ```\r\n     *\r\n     * @param email - Email address.\r\n     * @param password - User account password.\r\n     * @returns The auth provider credential.\r\n     */\r\n    static credential(email, password) {\r\n        return EmailAuthCredential._fromEmailAndPassword(email, password);\r\n    }\r\n    /**\r\n     * Initialize an {@link AuthCredential} using an email and an email link after a sign in with\r\n     * email link operation.\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * const authCredential = EmailAuthProvider.credentialWithLink(auth, email, emailLink);\r\n     * const userCredential = await signInWithCredential(auth, authCredential);\r\n     * ```\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * await sendSignInLinkToEmail(auth, email);\r\n     * // Obtain emailLink from user.\r\n     * const userCredential = await signInWithEmailLink(auth, email, emailLink);\r\n     * ```\r\n     *\r\n     * @param auth - The {@link Auth} instance used to verify the link.\r\n     * @param email - Email address.\r\n     * @param emailLink - Sign-in email link.\r\n     * @returns - The auth provider credential.\r\n     */\r\n    static credentialWithLink(email, emailLink) {\r\n        const actionCodeUrl = ActionCodeURL.parseLink(emailLink);\r\n        _assert(actionCodeUrl, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        return EmailAuthCredential._fromEmailAndCode(email, actionCodeUrl.code, actionCodeUrl.tenantId);\r\n    }\r\n}\r\n/**\r\n * Always set to {@link ProviderId}.PASSWORD, even for email link.\r\n */\r\nEmailAuthProvider.PROVIDER_ID = \"password\" /* ProviderId.PASSWORD */;\r\n/**\r\n * Always set to {@link SignInMethod}.EMAIL_PASSWORD.\r\n */\r\nEmailAuthProvider.EMAIL_PASSWORD_SIGN_IN_METHOD = \"password\" /* SignInMethod.EMAIL_PASSWORD */;\r\n/**\r\n * Always set to {@link SignInMethod}.EMAIL_LINK.\r\n */\r\nEmailAuthProvider.EMAIL_LINK_SIGN_IN_METHOD = \"emailLink\" /* SignInMethod.EMAIL_LINK */;\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * The base class for all Federated providers (OAuth (including OIDC), SAML).\r\n *\r\n * This class is not meant to be instantiated directly.\r\n *\r\n * @public\r\n */\r\nclass FederatedAuthProvider {\r\n    /**\r\n     * Constructor for generic OAuth providers.\r\n     *\r\n     * @param providerId - Provider for which credentials should be generated.\r\n     */\r\n    constructor(providerId) {\r\n        this.providerId = providerId;\r\n        /** @internal */\r\n        this.defaultLanguageCode = null;\r\n        /** @internal */\r\n        this.customParameters = {};\r\n    }\r\n    /**\r\n     * Set the language gode.\r\n     *\r\n     * @param languageCode - language code\r\n     */\r\n    setDefaultLanguage(languageCode) {\r\n        this.defaultLanguageCode = languageCode;\r\n    }\r\n    /**\r\n     * Sets the OAuth custom parameters to pass in an OAuth request for popup and redirect sign-in\r\n     * operations.\r\n     *\r\n     * @remarks\r\n     * For a detailed list, check the reserved required OAuth 2.0 parameters such as `client_id`,\r\n     * `redirect_uri`, `scope`, `response_type`, and `state` are not allowed and will be ignored.\r\n     *\r\n     * @param customOAuthParameters - The custom OAuth parameters to pass in the OAuth request.\r\n     */\r\n    setCustomParameters(customOAuthParameters) {\r\n        this.customParameters = customOAuthParameters;\r\n        return this;\r\n    }\r\n    /**\r\n     * Retrieve the current list of {@link CustomParameters}.\r\n     */\r\n    getCustomParameters() {\r\n        return this.customParameters;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Common code to all OAuth providers. This is separate from the\r\n * {@link OAuthProvider} so that child providers (like\r\n * {@link GoogleAuthProvider}) don't inherit the `credential` instance method.\r\n * Instead, they rely on a static `credential` method.\r\n */\r\nclass BaseOAuthProvider extends FederatedAuthProvider {\r\n    constructor() {\r\n        super(...arguments);\r\n        /** @internal */\r\n        this.scopes = [];\r\n    }\r\n    /**\r\n     * Add an OAuth scope to the credential.\r\n     *\r\n     * @param scope - Provider OAuth scope to add.\r\n     */\r\n    addScope(scope) {\r\n        // If not already added, add scope to list.\r\n        if (!this.scopes.includes(scope)) {\r\n            this.scopes.push(scope);\r\n        }\r\n        return this;\r\n    }\r\n    /**\r\n     * Retrieve the current list of OAuth scopes.\r\n     */\r\n    getScopes() {\r\n        return [...this.scopes];\r\n    }\r\n}\r\n/**\r\n * Provider for generating generic {@link OAuthCredential}.\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a redirect.\r\n * const provider = new OAuthProvider('google.com');\r\n * // Start a sign in process for an unauthenticated user.\r\n * provider.addScope('profile');\r\n * provider.addScope('email');\r\n * await signInWithRedirect(auth, provider);\r\n * // This will trigger a full page redirect away from your app\r\n *\r\n * // After returning from the redirect when your app initializes you can obtain the result\r\n * const result = await getRedirectResult(auth);\r\n * if (result) {\r\n *   // This is the signed-in user\r\n *   const user = result.user;\r\n *   // This gives you a OAuth Access Token for the provider.\r\n *   const credential = provider.credentialFromResult(auth, result);\r\n *   const token = credential.accessToken;\r\n * }\r\n * ```\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a popup.\r\n * const provider = new OAuthProvider('google.com');\r\n * provider.addScope('profile');\r\n * provider.addScope('email');\r\n * const result = await signInWithPopup(auth, provider);\r\n *\r\n * // The signed-in user info.\r\n * const user = result.user;\r\n * // This gives you a OAuth Access Token for the provider.\r\n * const credential = provider.credentialFromResult(auth, result);\r\n * const token = credential.accessToken;\r\n * ```\r\n * @public\r\n */\r\nclass OAuthProvider extends BaseOAuthProvider {\r\n    /**\r\n     * Creates an {@link OAuthCredential} from a JSON string or a plain object.\r\n     * @param json - A plain object or a JSON string\r\n     */\r\n    static credentialFromJSON(json) {\r\n        const obj = typeof json === 'string' ? JSON.parse(json) : json;\r\n        _assert('providerId' in obj && 'signInMethod' in obj, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        return OAuthCredential._fromParams(obj);\r\n    }\r\n    /**\r\n     * Creates a {@link OAuthCredential} from a generic OAuth provider's access token or ID token.\r\n     *\r\n     * @remarks\r\n     * The raw nonce is required when an ID token with a nonce field is provided. The SHA-256 hash of\r\n     * the raw nonce must match the nonce field in the ID token.\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * // `googleUser` from the onsuccess Google Sign In callback.\r\n     * // Initialize a generate OAuth provider with a `google.com` providerId.\r\n     * const provider = new OAuthProvider('google.com');\r\n     * const credential = provider.credential({\r\n     *   idToken: googleUser.getAuthResponse().id_token,\r\n     * });\r\n     * const result = await signInWithCredential(credential);\r\n     * ```\r\n     *\r\n     * @param params - Either the options object containing the ID token, access token and raw nonce\r\n     * or the ID token string.\r\n     */\r\n    credential(params) {\r\n        return this._credential(Object.assign(Object.assign({}, params), { nonce: params.rawNonce }));\r\n    }\r\n    /** An internal credential method that accepts more permissive options */\r\n    _credential(params) {\r\n        _assert(params.idToken || params.accessToken, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        // For OAuthCredential, sign in method is same as providerId.\r\n        return OAuthCredential._fromParams(Object.assign(Object.assign({}, params), { providerId: this.providerId, signInMethod: this.providerId }));\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link UserCredential}.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromResult(userCredential) {\r\n        return OAuthProvider.oauthCredentialFromTaggedObject(userCredential);\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link AuthError} which was\r\n     * thrown during a sign-in, link, or reauthenticate operation.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromError(error) {\r\n        return OAuthProvider.oauthCredentialFromTaggedObject((error.customData || {}));\r\n    }\r\n    static oauthCredentialFromTaggedObject({ _tokenResponse: tokenResponse }) {\r\n        if (!tokenResponse) {\r\n            return null;\r\n        }\r\n        const { oauthIdToken, oauthAccessToken, oauthTokenSecret, pendingToken, nonce, providerId } = tokenResponse;\r\n        if (!oauthAccessToken &&\r\n            !oauthTokenSecret &&\r\n            !oauthIdToken &&\r\n            !pendingToken) {\r\n            return null;\r\n        }\r\n        if (!providerId) {\r\n            return null;\r\n        }\r\n        try {\r\n            return new OAuthProvider(providerId)._credential({\r\n                idToken: oauthIdToken,\r\n                accessToken: oauthAccessToken,\r\n                nonce,\r\n                pendingToken\r\n            });\r\n        }\r\n        catch (e) {\r\n            return null;\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Provider for generating an {@link OAuthCredential} for {@link ProviderId}.FACEBOOK.\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a redirect.\r\n * const provider = new FacebookAuthProvider();\r\n * // Start a sign in process for an unauthenticated user.\r\n * provider.addScope('user_birthday');\r\n * await signInWithRedirect(auth, provider);\r\n * // This will trigger a full page redirect away from your app\r\n *\r\n * // After returning from the redirect when your app initializes you can obtain the result\r\n * const result = await getRedirectResult(auth);\r\n * if (result) {\r\n *   // This is the signed-in user\r\n *   const user = result.user;\r\n *   // This gives you a Facebook Access Token.\r\n *   const credential = FacebookAuthProvider.credentialFromResult(result);\r\n *   const token = credential.accessToken;\r\n * }\r\n * ```\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a popup.\r\n * const provider = new FacebookAuthProvider();\r\n * provider.addScope('user_birthday');\r\n * const result = await signInWithPopup(auth, provider);\r\n *\r\n * // The signed-in user info.\r\n * const user = result.user;\r\n * // This gives you a Facebook Access Token.\r\n * const credential = FacebookAuthProvider.credentialFromResult(result);\r\n * const token = credential.accessToken;\r\n * ```\r\n *\r\n * @public\r\n */\r\nclass FacebookAuthProvider extends BaseOAuthProvider {\r\n    constructor() {\r\n        super(\"facebook.com\" /* ProviderId.FACEBOOK */);\r\n    }\r\n    /**\r\n     * Creates a credential for Facebook.\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * // `event` from the Facebook auth.authResponseChange callback.\r\n     * const credential = FacebookAuthProvider.credential(event.authResponse.accessToken);\r\n     * const result = await signInWithCredential(credential);\r\n     * ```\r\n     *\r\n     * @param accessToken - Facebook access token.\r\n     */\r\n    static credential(accessToken) {\r\n        return OAuthCredential._fromParams({\r\n            providerId: FacebookAuthProvider.PROVIDER_ID,\r\n            signInMethod: FacebookAuthProvider.FACEBOOK_SIGN_IN_METHOD,\r\n            accessToken\r\n        });\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link UserCredential}.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromResult(userCredential) {\r\n        return FacebookAuthProvider.credentialFromTaggedObject(userCredential);\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link AuthError} which was\r\n     * thrown during a sign-in, link, or reauthenticate operation.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromError(error) {\r\n        return FacebookAuthProvider.credentialFromTaggedObject((error.customData || {}));\r\n    }\r\n    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {\r\n        if (!tokenResponse || !('oauthAccessToken' in tokenResponse)) {\r\n            return null;\r\n        }\r\n        if (!tokenResponse.oauthAccessToken) {\r\n            return null;\r\n        }\r\n        try {\r\n            return FacebookAuthProvider.credential(tokenResponse.oauthAccessToken);\r\n        }\r\n        catch (_a) {\r\n            return null;\r\n        }\r\n    }\r\n}\r\n/** Always set to {@link SignInMethod}.FACEBOOK. */\r\nFacebookAuthProvider.FACEBOOK_SIGN_IN_METHOD = \"facebook.com\" /* SignInMethod.FACEBOOK */;\r\n/** Always set to {@link ProviderId}.FACEBOOK. */\r\nFacebookAuthProvider.PROVIDER_ID = \"facebook.com\" /* ProviderId.FACEBOOK */;\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Provider for generating an an {@link OAuthCredential} for {@link ProviderId}.GOOGLE.\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a redirect.\r\n * const provider = new GoogleAuthProvider();\r\n * // Start a sign in process for an unauthenticated user.\r\n * provider.addScope('profile');\r\n * provider.addScope('email');\r\n * await signInWithRedirect(auth, provider);\r\n * // This will trigger a full page redirect away from your app\r\n *\r\n * // After returning from the redirect when your app initializes you can obtain the result\r\n * const result = await getRedirectResult(auth);\r\n * if (result) {\r\n *   // This is the signed-in user\r\n *   const user = result.user;\r\n *   // This gives you a Google Access Token.\r\n *   const credential = GoogleAuthProvider.credentialFromResult(result);\r\n *   const token = credential.accessToken;\r\n * }\r\n * ```\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a popup.\r\n * const provider = new GoogleAuthProvider();\r\n * provider.addScope('profile');\r\n * provider.addScope('email');\r\n * const result = await signInWithPopup(auth, provider);\r\n *\r\n * // The signed-in user info.\r\n * const user = result.user;\r\n * // This gives you a Google Access Token.\r\n * const credential = GoogleAuthProvider.credentialFromResult(result);\r\n * const token = credential.accessToken;\r\n * ```\r\n *\r\n * @public\r\n */\r\nclass GoogleAuthProvider extends BaseOAuthProvider {\r\n    constructor() {\r\n        super(\"google.com\" /* ProviderId.GOOGLE */);\r\n        this.addScope('profile');\r\n    }\r\n    /**\r\n     * Creates a credential for Google. At least one of ID token and access token is required.\r\n     *\r\n     * @example\r\n     * ```javascript\r\n     * // \\`googleUser\\` from the onsuccess Google Sign In callback.\r\n     * const credential = GoogleAuthProvider.credential(googleUser.getAuthResponse().id_token);\r\n     * const result = await signInWithCredential(credential);\r\n     * ```\r\n     *\r\n     * @param idToken - Google ID token.\r\n     * @param accessToken - Google access token.\r\n     */\r\n    static credential(idToken, accessToken) {\r\n        return OAuthCredential._fromParams({\r\n            providerId: GoogleAuthProvider.PROVIDER_ID,\r\n            signInMethod: GoogleAuthProvider.GOOGLE_SIGN_IN_METHOD,\r\n            idToken,\r\n            accessToken\r\n        });\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link UserCredential}.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromResult(userCredential) {\r\n        return GoogleAuthProvider.credentialFromTaggedObject(userCredential);\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link AuthError} which was\r\n     * thrown during a sign-in, link, or reauthenticate operation.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromError(error) {\r\n        return GoogleAuthProvider.credentialFromTaggedObject((error.customData || {}));\r\n    }\r\n    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {\r\n        if (!tokenResponse) {\r\n            return null;\r\n        }\r\n        const { oauthIdToken, oauthAccessToken } = tokenResponse;\r\n        if (!oauthIdToken && !oauthAccessToken) {\r\n            // This could be an oauth 1 credential or a phone credential\r\n            return null;\r\n        }\r\n        try {\r\n            return GoogleAuthProvider.credential(oauthIdToken, oauthAccessToken);\r\n        }\r\n        catch (_a) {\r\n            return null;\r\n        }\r\n    }\r\n}\r\n/** Always set to {@link SignInMethod}.GOOGLE. */\r\nGoogleAuthProvider.GOOGLE_SIGN_IN_METHOD = \"google.com\" /* SignInMethod.GOOGLE */;\r\n/** Always set to {@link ProviderId}.GOOGLE. */\r\nGoogleAuthProvider.PROVIDER_ID = \"google.com\" /* ProviderId.GOOGLE */;\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Provider for generating an {@link OAuthCredential} for {@link ProviderId}.GITHUB.\r\n *\r\n * @remarks\r\n * GitHub requires an OAuth 2.0 redirect, so you can either handle the redirect directly, or use\r\n * the {@link signInWithPopup} handler:\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a redirect.\r\n * const provider = new GithubAuthProvider();\r\n * // Start a sign in process for an unauthenticated user.\r\n * provider.addScope('repo');\r\n * await signInWithRedirect(auth, provider);\r\n * // This will trigger a full page redirect away from your app\r\n *\r\n * // After returning from the redirect when your app initializes you can obtain the result\r\n * const result = await getRedirectResult(auth);\r\n * if (result) {\r\n *   // This is the signed-in user\r\n *   const user = result.user;\r\n *   // This gives you a Github Access Token.\r\n *   const credential = GithubAuthProvider.credentialFromResult(result);\r\n *   const token = credential.accessToken;\r\n * }\r\n * ```\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a popup.\r\n * const provider = new GithubAuthProvider();\r\n * provider.addScope('repo');\r\n * const result = await signInWithPopup(auth, provider);\r\n *\r\n * // The signed-in user info.\r\n * const user = result.user;\r\n * // This gives you a Github Access Token.\r\n * const credential = GithubAuthProvider.credentialFromResult(result);\r\n * const token = credential.accessToken;\r\n * ```\r\n * @public\r\n */\r\nclass GithubAuthProvider extends BaseOAuthProvider {\r\n    constructor() {\r\n        super(\"github.com\" /* ProviderId.GITHUB */);\r\n    }\r\n    /**\r\n     * Creates a credential for Github.\r\n     *\r\n     * @param accessToken - Github access token.\r\n     */\r\n    static credential(accessToken) {\r\n        return OAuthCredential._fromParams({\r\n            providerId: GithubAuthProvider.PROVIDER_ID,\r\n            signInMethod: GithubAuthProvider.GITHUB_SIGN_IN_METHOD,\r\n            accessToken\r\n        });\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link UserCredential}.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromResult(userCredential) {\r\n        return GithubAuthProvider.credentialFromTaggedObject(userCredential);\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link AuthError} which was\r\n     * thrown during a sign-in, link, or reauthenticate operation.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromError(error) {\r\n        return GithubAuthProvider.credentialFromTaggedObject((error.customData || {}));\r\n    }\r\n    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {\r\n        if (!tokenResponse || !('oauthAccessToken' in tokenResponse)) {\r\n            return null;\r\n        }\r\n        if (!tokenResponse.oauthAccessToken) {\r\n            return null;\r\n        }\r\n        try {\r\n            return GithubAuthProvider.credential(tokenResponse.oauthAccessToken);\r\n        }\r\n        catch (_a) {\r\n            return null;\r\n        }\r\n    }\r\n}\r\n/** Always set to {@link SignInMethod}.GITHUB. */\r\nGithubAuthProvider.GITHUB_SIGN_IN_METHOD = \"github.com\" /* SignInMethod.GITHUB */;\r\n/** Always set to {@link ProviderId}.GITHUB. */\r\nGithubAuthProvider.PROVIDER_ID = \"github.com\" /* ProviderId.GITHUB */;\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst IDP_REQUEST_URI = 'http://localhost';\r\n/**\r\n * @public\r\n */\r\nclass SAMLAuthCredential extends AuthCredential {\r\n    /** @internal */\r\n    constructor(providerId, pendingToken) {\r\n        super(providerId, providerId);\r\n        this.pendingToken = pendingToken;\r\n    }\r\n    /** @internal */\r\n    _getIdTokenResponse(auth) {\r\n        const request = this.buildRequest();\r\n        return signInWithIdp(auth, request);\r\n    }\r\n    /** @internal */\r\n    _linkToIdToken(auth, idToken) {\r\n        const request = this.buildRequest();\r\n        request.idToken = idToken;\r\n        return signInWithIdp(auth, request);\r\n    }\r\n    /** @internal */\r\n    _getReauthenticationResolver(auth) {\r\n        const request = this.buildRequest();\r\n        request.autoCreate = false;\r\n        return signInWithIdp(auth, request);\r\n    }\r\n    /** {@inheritdoc AuthCredential.toJSON}  */\r\n    toJSON() {\r\n        return {\r\n            signInMethod: this.signInMethod,\r\n            providerId: this.providerId,\r\n            pendingToken: this.pendingToken\r\n        };\r\n    }\r\n    /**\r\n     * Static method to deserialize a JSON representation of an object into an\r\n     * {@link  AuthCredential}.\r\n     *\r\n     * @param json - Input can be either Object or the stringified representation of the object.\r\n     * When string is provided, JSON.parse would be called first.\r\n     *\r\n     * @returns If the JSON input does not represent an {@link  AuthCredential}, null is returned.\r\n     */\r\n    static fromJSON(json) {\r\n        const obj = typeof json === 'string' ? JSON.parse(json) : json;\r\n        const { providerId, signInMethod, pendingToken } = obj;\r\n        if (!providerId ||\r\n            !signInMethod ||\r\n            !pendingToken ||\r\n            providerId !== signInMethod) {\r\n            return null;\r\n        }\r\n        return new SAMLAuthCredential(providerId, pendingToken);\r\n    }\r\n    /**\r\n     * Helper static method to avoid exposing the constructor to end users.\r\n     *\r\n     * @internal\r\n     */\r\n    static _create(providerId, pendingToken) {\r\n        return new SAMLAuthCredential(providerId, pendingToken);\r\n    }\r\n    buildRequest() {\r\n        return {\r\n            requestUri: IDP_REQUEST_URI,\r\n            returnSecureToken: true,\r\n            pendingToken: this.pendingToken\r\n        };\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst SAML_PROVIDER_PREFIX = 'saml.';\r\n/**\r\n * An {@link AuthProvider} for SAML.\r\n *\r\n * @public\r\n */\r\nclass SAMLAuthProvider extends FederatedAuthProvider {\r\n    /**\r\n     * Constructor. The providerId must start with \"saml.\"\r\n     * @param providerId - SAML provider ID.\r\n     */\r\n    constructor(providerId) {\r\n        _assert(providerId.startsWith(SAML_PROVIDER_PREFIX), \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        super(providerId);\r\n    }\r\n    /**\r\n     * Generates an {@link AuthCredential} from a {@link UserCredential} after a\r\n     * successful SAML flow completes.\r\n     *\r\n     * @remarks\r\n     *\r\n     * For example, to get an {@link AuthCredential}, you could write the\r\n     * following code:\r\n     *\r\n     * ```js\r\n     * const userCredential = await signInWithPopup(auth, samlProvider);\r\n     * const credential = SAMLAuthProvider.credentialFromResult(userCredential);\r\n     * ```\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromResult(userCredential) {\r\n        return SAMLAuthProvider.samlCredentialFromTaggedObject(userCredential);\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link AuthError} which was\r\n     * thrown during a sign-in, link, or reauthenticate operation.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromError(error) {\r\n        return SAMLAuthProvider.samlCredentialFromTaggedObject((error.customData || {}));\r\n    }\r\n    /**\r\n     * Creates an {@link AuthCredential} from a JSON string or a plain object.\r\n     * @param json - A plain object or a JSON string\r\n     */\r\n    static credentialFromJSON(json) {\r\n        const credential = SAMLAuthCredential.fromJSON(json);\r\n        _assert(credential, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        return credential;\r\n    }\r\n    static samlCredentialFromTaggedObject({ _tokenResponse: tokenResponse }) {\r\n        if (!tokenResponse) {\r\n            return null;\r\n        }\r\n        const { pendingToken, providerId } = tokenResponse;\r\n        if (!pendingToken || !providerId) {\r\n            return null;\r\n        }\r\n        try {\r\n            return SAMLAuthCredential._create(providerId, pendingToken);\r\n        }\r\n        catch (e) {\r\n            return null;\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Provider for generating an {@link OAuthCredential} for {@link ProviderId}.TWITTER.\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a redirect.\r\n * const provider = new TwitterAuthProvider();\r\n * // Start a sign in process for an unauthenticated user.\r\n * await signInWithRedirect(auth, provider);\r\n * // This will trigger a full page redirect away from your app\r\n *\r\n * // After returning from the redirect when your app initializes you can obtain the result\r\n * const result = await getRedirectResult(auth);\r\n * if (result) {\r\n *   // This is the signed-in user\r\n *   const user = result.user;\r\n *   // This gives you a Twitter Access Token and Secret.\r\n *   const credential = TwitterAuthProvider.credentialFromResult(result);\r\n *   const token = credential.accessToken;\r\n *   const secret = credential.secret;\r\n * }\r\n * ```\r\n *\r\n * @example\r\n * ```javascript\r\n * // Sign in using a popup.\r\n * const provider = new TwitterAuthProvider();\r\n * const result = await signInWithPopup(auth, provider);\r\n *\r\n * // The signed-in user info.\r\n * const user = result.user;\r\n * // This gives you a Twitter Access Token and Secret.\r\n * const credential = TwitterAuthProvider.credentialFromResult(result);\r\n * const token = credential.accessToken;\r\n * const secret = credential.secret;\r\n * ```\r\n *\r\n * @public\r\n */\r\nclass TwitterAuthProvider extends BaseOAuthProvider {\r\n    constructor() {\r\n        super(\"twitter.com\" /* ProviderId.TWITTER */);\r\n    }\r\n    /**\r\n     * Creates a credential for Twitter.\r\n     *\r\n     * @param token - Twitter access token.\r\n     * @param secret - Twitter secret.\r\n     */\r\n    static credential(token, secret) {\r\n        return OAuthCredential._fromParams({\r\n            providerId: TwitterAuthProvider.PROVIDER_ID,\r\n            signInMethod: TwitterAuthProvider.TWITTER_SIGN_IN_METHOD,\r\n            oauthToken: token,\r\n            oauthTokenSecret: secret\r\n        });\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link UserCredential}.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromResult(userCredential) {\r\n        return TwitterAuthProvider.credentialFromTaggedObject(userCredential);\r\n    }\r\n    /**\r\n     * Used to extract the underlying {@link OAuthCredential} from a {@link AuthError} which was\r\n     * thrown during a sign-in, link, or reauthenticate operation.\r\n     *\r\n     * @param userCredential - The user credential.\r\n     */\r\n    static credentialFromError(error) {\r\n        return TwitterAuthProvider.credentialFromTaggedObject((error.customData || {}));\r\n    }\r\n    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {\r\n        if (!tokenResponse) {\r\n            return null;\r\n        }\r\n        const { oauthAccessToken, oauthTokenSecret } = tokenResponse;\r\n        if (!oauthAccessToken || !oauthTokenSecret) {\r\n            return null;\r\n        }\r\n        try {\r\n            return TwitterAuthProvider.credential(oauthAccessToken, oauthTokenSecret);\r\n        }\r\n        catch (_a) {\r\n            return null;\r\n        }\r\n    }\r\n}\r\n/** Always set to {@link SignInMethod}.TWITTER. */\r\nTwitterAuthProvider.TWITTER_SIGN_IN_METHOD = \"twitter.com\" /* SignInMethod.TWITTER */;\r\n/** Always set to {@link ProviderId}.TWITTER. */\r\nTwitterAuthProvider.PROVIDER_ID = \"twitter.com\" /* ProviderId.TWITTER */;\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function signUp(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signUp\" /* Endpoint.SIGN_UP */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass UserCredentialImpl {\r\n    constructor(params) {\r\n        this.user = params.user;\r\n        this.providerId = params.providerId;\r\n        this._tokenResponse = params._tokenResponse;\r\n        this.operationType = params.operationType;\r\n    }\r\n    static async _fromIdTokenResponse(auth, operationType, idTokenResponse, isAnonymous = false) {\r\n        const user = await UserImpl._fromIdTokenResponse(auth, idTokenResponse, isAnonymous);\r\n        const providerId = providerIdForResponse(idTokenResponse);\r\n        const userCred = new UserCredentialImpl({\r\n            user,\r\n            providerId,\r\n            _tokenResponse: idTokenResponse,\r\n            operationType\r\n        });\r\n        return userCred;\r\n    }\r\n    static async _forOperation(user, operationType, response) {\r\n        await user._updateTokensIfNecessary(response, /* reload */ true);\r\n        const providerId = providerIdForResponse(response);\r\n        return new UserCredentialImpl({\r\n            user,\r\n            providerId,\r\n            _tokenResponse: response,\r\n            operationType\r\n        });\r\n    }\r\n}\r\nfunction providerIdForResponse(response) {\r\n    if (response.providerId) {\r\n        return response.providerId;\r\n    }\r\n    if ('phoneNumber' in response) {\r\n        return \"phone\" /* ProviderId.PHONE */;\r\n    }\r\n    return null;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Asynchronously signs in as an anonymous user.\r\n *\r\n * @remarks\r\n * If there is already an anonymous user signed in, that user will be returned; otherwise, a\r\n * new anonymous user identity will be created and returned.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n *\r\n * @public\r\n */\r\nasync function signInAnonymously(auth) {\r\n    var _a;\r\n    const authInternal = _castAuth(auth);\r\n    await authInternal._initializationPromise;\r\n    if ((_a = authInternal.currentUser) === null || _a === void 0 ? void 0 : _a.isAnonymous) {\r\n        // If an anonymous user is already signed in, no need to sign them in again.\r\n        return new UserCredentialImpl({\r\n            user: authInternal.currentUser,\r\n            providerId: null,\r\n            operationType: \"signIn\" /* OperationType.SIGN_IN */\r\n        });\r\n    }\r\n    const response = await signUp(authInternal, {\r\n        returnSecureToken: true\r\n    });\r\n    const userCredential = await UserCredentialImpl._fromIdTokenResponse(authInternal, \"signIn\" /* OperationType.SIGN_IN */, response, true);\r\n    await authInternal._updateCurrentUser(userCredential.user);\r\n    return userCredential;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass MultiFactorError extends _firebase_util__WEBPACK_IMPORTED_MODULE_0__.FirebaseError {\r\n    constructor(auth, error, operationType, user) {\r\n        var _a;\r\n        super(error.code, error.message);\r\n        this.operationType = operationType;\r\n        this.user = user;\r\n        // https://github.com/Microsoft/TypeScript-wiki/blob/master/Breaking-Changes.md#extending-built-ins-like-error-array-and-map-may-no-longer-work\r\n        Object.setPrototypeOf(this, MultiFactorError.prototype);\r\n        this.customData = {\r\n            appName: auth.name,\r\n            tenantId: (_a = auth.tenantId) !== null && _a !== void 0 ? _a : undefined,\r\n            _serverResponse: error.customData._serverResponse,\r\n            operationType\r\n        };\r\n    }\r\n    static _fromErrorAndOperation(auth, error, operationType, user) {\r\n        return new MultiFactorError(auth, error, operationType, user);\r\n    }\r\n}\r\nfunction _processCredentialSavingMfaContextIfNecessary(auth, operationType, credential, user) {\r\n    const idTokenProvider = operationType === \"reauthenticate\" /* OperationType.REAUTHENTICATE */\r\n        ? credential._getReauthenticationResolver(auth)\r\n        : credential._getIdTokenResponse(auth);\r\n    return idTokenProvider.catch(error => {\r\n        if (error.code === `auth/${\"multi-factor-auth-required\" /* AuthErrorCode.MFA_REQUIRED */}`) {\r\n            throw MultiFactorError._fromErrorAndOperation(auth, error, operationType, user);\r\n        }\r\n        throw error;\r\n    });\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Takes a set of UserInfo provider data and converts it to a set of names\r\n */\r\nfunction providerDataAsNames(providerData) {\r\n    return new Set(providerData\r\n        .map(({ providerId }) => providerId)\r\n        .filter(pid => !!pid));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Unlinks a provider from a user account.\r\n *\r\n * @param user - The user.\r\n * @param providerId - The provider to unlink.\r\n *\r\n * @public\r\n */\r\nasync function unlink(user, providerId) {\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    await _assertLinkedStatus(true, userInternal, providerId);\r\n    const { providerUserInfo } = await deleteLinkedAccounts(userInternal.auth, {\r\n        idToken: await userInternal.getIdToken(),\r\n        deleteProvider: [providerId]\r\n    });\r\n    const providersLeft = providerDataAsNames(providerUserInfo || []);\r\n    userInternal.providerData = userInternal.providerData.filter(pd => providersLeft.has(pd.providerId));\r\n    if (!providersLeft.has(\"phone\" /* ProviderId.PHONE */)) {\r\n        userInternal.phoneNumber = null;\r\n    }\r\n    await userInternal.auth._persistUserIfCurrent(userInternal);\r\n    return userInternal;\r\n}\r\nasync function _link(user, credential, bypassAuthState = false) {\r\n    const response = await _logoutIfInvalidated(user, credential._linkToIdToken(user.auth, await user.getIdToken()), bypassAuthState);\r\n    return UserCredentialImpl._forOperation(user, \"link\" /* OperationType.LINK */, response);\r\n}\r\nasync function _assertLinkedStatus(expected, user, provider) {\r\n    await _reloadWithoutSaving(user);\r\n    const providerIds = providerDataAsNames(user.providerData);\r\n    const code = expected === false\r\n        ? \"provider-already-linked\" /* AuthErrorCode.PROVIDER_ALREADY_LINKED */\r\n        : \"no-such-provider\" /* AuthErrorCode.NO_SUCH_PROVIDER */;\r\n    _assert(providerIds.has(provider) === expected, user.auth, code);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function _reauthenticate(user, credential, bypassAuthState = false) {\r\n    const { auth } = user;\r\n    const operationType = \"reauthenticate\" /* OperationType.REAUTHENTICATE */;\r\n    try {\r\n        const response = await _logoutIfInvalidated(user, _processCredentialSavingMfaContextIfNecessary(auth, operationType, credential, user), bypassAuthState);\r\n        _assert(response.idToken, auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        const parsed = _parseToken(response.idToken);\r\n        _assert(parsed, auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        const { sub: localId } = parsed;\r\n        _assert(user.uid === localId, auth, \"user-mismatch\" /* AuthErrorCode.USER_MISMATCH */);\r\n        return UserCredentialImpl._forOperation(user, operationType, response);\r\n    }\r\n    catch (e) {\r\n        // Convert user deleted error into user mismatch\r\n        if ((e === null || e === void 0 ? void 0 : e.code) === `auth/${\"user-not-found\" /* AuthErrorCode.USER_DELETED */}`) {\r\n            _fail(auth, \"user-mismatch\" /* AuthErrorCode.USER_MISMATCH */);\r\n        }\r\n        throw e;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function _signInWithCredential(auth, credential, bypassAuthState = false) {\r\n    const operationType = \"signIn\" /* OperationType.SIGN_IN */;\r\n    const response = await _processCredentialSavingMfaContextIfNecessary(auth, operationType, credential);\r\n    const userCredential = await UserCredentialImpl._fromIdTokenResponse(auth, operationType, response);\r\n    if (!bypassAuthState) {\r\n        await auth._updateCurrentUser(userCredential.user);\r\n    }\r\n    return userCredential;\r\n}\r\n/**\r\n * Asynchronously signs in with the given credentials.\r\n *\r\n * @remarks\r\n * An {@link AuthProvider} can be used to generate the credential.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param credential - The auth credential.\r\n *\r\n * @public\r\n */\r\nasync function signInWithCredential(auth, credential) {\r\n    return _signInWithCredential(_castAuth(auth), credential);\r\n}\r\n/**\r\n * Links the user account with the given credentials.\r\n *\r\n * @remarks\r\n * An {@link AuthProvider} can be used to generate the credential.\r\n *\r\n * @param user - The user.\r\n * @param credential - The auth credential.\r\n *\r\n * @public\r\n */\r\nasync function linkWithCredential(user, credential) {\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    await _assertLinkedStatus(false, userInternal, credential.providerId);\r\n    return _link(userInternal, credential);\r\n}\r\n/**\r\n * Re-authenticates a user using a fresh credential.\r\n *\r\n * @remarks\r\n * Use before operations such as {@link updatePassword} that require tokens from recent sign-in\r\n * attempts. This method can be used to recover from a `CREDENTIAL_TOO_OLD_LOGIN_AGAIN` error\r\n * or a `TOKEN_EXPIRED` error.\r\n *\r\n * @param user - The user.\r\n * @param credential - The auth credential.\r\n *\r\n * @public\r\n */\r\nasync function reauthenticateWithCredential(user, credential) {\r\n    return _reauthenticate((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user), credential);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function signInWithCustomToken$1(auth, request) {\r\n    return _performSignInRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:signInWithCustomToken\" /* Endpoint.SIGN_IN_WITH_CUSTOM_TOKEN */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Asynchronously signs in using a custom token.\r\n *\r\n * @remarks\r\n * Custom tokens are used to integrate Firebase Auth with existing auth systems, and must\r\n * be generated by an auth backend using the\r\n * {@link https://firebase.google.com/docs/reference/admin/node/admin.auth.Auth#createcustomtoken | createCustomToken}\r\n * method in the {@link https://firebase.google.com/docs/auth/admin | Admin SDK} .\r\n *\r\n * Fails with an error if the token is invalid, expired, or not accepted by the Firebase Auth service.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param customToken - The custom token to sign in with.\r\n *\r\n * @public\r\n */\r\nasync function signInWithCustomToken(auth, customToken) {\r\n    const authInternal = _castAuth(auth);\r\n    const response = await signInWithCustomToken$1(authInternal, {\r\n        token: customToken,\r\n        returnSecureToken: true\r\n    });\r\n    const cred = await UserCredentialImpl._fromIdTokenResponse(authInternal, \"signIn\" /* OperationType.SIGN_IN */, response);\r\n    await authInternal._updateCurrentUser(cred.user);\r\n    return cred;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass MultiFactorInfoImpl {\r\n    constructor(factorId, response) {\r\n        this.factorId = factorId;\r\n        this.uid = response.mfaEnrollmentId;\r\n        this.enrollmentTime = new Date(response.enrolledAt).toUTCString();\r\n        this.displayName = response.displayName;\r\n    }\r\n    static _fromServerResponse(auth, enrollment) {\r\n        if ('phoneInfo' in enrollment) {\r\n            return PhoneMultiFactorInfoImpl._fromServerResponse(auth, enrollment);\r\n        }\r\n        else if ('totpInfo' in enrollment) {\r\n            return TotpMultiFactorInfoImpl._fromServerResponse(auth, enrollment);\r\n        }\r\n        return _fail(auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    }\r\n}\r\nclass PhoneMultiFactorInfoImpl extends MultiFactorInfoImpl {\r\n    constructor(response) {\r\n        super(\"phone\" /* FactorId.PHONE */, response);\r\n        this.phoneNumber = response.phoneInfo;\r\n    }\r\n    static _fromServerResponse(_auth, enrollment) {\r\n        return new PhoneMultiFactorInfoImpl(enrollment);\r\n    }\r\n}\r\nclass TotpMultiFactorInfoImpl extends MultiFactorInfoImpl {\r\n    constructor(response) {\r\n        super(\"totp\" /* FactorId.TOTP */, response);\r\n    }\r\n    static _fromServerResponse(_auth, enrollment) {\r\n        return new TotpMultiFactorInfoImpl(enrollment);\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction _setActionCodeSettingsOnRequest(auth, request, actionCodeSettings) {\r\n    var _a;\r\n    _assert(((_a = actionCodeSettings.url) === null || _a === void 0 ? void 0 : _a.length) > 0, auth, \"invalid-continue-uri\" /* AuthErrorCode.INVALID_CONTINUE_URI */);\r\n    _assert(typeof actionCodeSettings.dynamicLinkDomain === 'undefined' ||\r\n        actionCodeSettings.dynamicLinkDomain.length > 0, auth, \"invalid-dynamic-link-domain\" /* AuthErrorCode.INVALID_DYNAMIC_LINK_DOMAIN */);\r\n    request.continueUrl = actionCodeSettings.url;\r\n    request.dynamicLinkDomain = actionCodeSettings.dynamicLinkDomain;\r\n    request.canHandleCodeInApp = actionCodeSettings.handleCodeInApp;\r\n    if (actionCodeSettings.iOS) {\r\n        _assert(actionCodeSettings.iOS.bundleId.length > 0, auth, \"missing-ios-bundle-id\" /* AuthErrorCode.MISSING_IOS_BUNDLE_ID */);\r\n        request.iOSBundleId = actionCodeSettings.iOS.bundleId;\r\n    }\r\n    if (actionCodeSettings.android) {\r\n        _assert(actionCodeSettings.android.packageName.length > 0, auth, \"missing-android-pkg-name\" /* AuthErrorCode.MISSING_ANDROID_PACKAGE_NAME */);\r\n        request.androidInstallApp = actionCodeSettings.android.installApp;\r\n        request.androidMinimumVersionCode =\r\n            actionCodeSettings.android.minimumVersion;\r\n        request.androidPackageName = actionCodeSettings.android.packageName;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Updates the password policy cached in the {@link Auth} instance if a policy is already\r\n * cached for the project or tenant.\r\n *\r\n * @remarks\r\n * We only fetch the password policy if the password did not meet policy requirements and\r\n * there is an existing policy cached. A developer must call validatePassword at least\r\n * once for the cache to be automatically updated.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n *\r\n * @private\r\n */\r\nasync function recachePasswordPolicy(auth) {\r\n    const authInternal = _castAuth(auth);\r\n    if (authInternal._getPasswordPolicyInternal()) {\r\n        await authInternal._updatePasswordPolicy();\r\n    }\r\n}\r\n/**\r\n * Sends a password reset email to the given email address. This method does not throw an error when\r\n * there's no user account with the given email address and\r\n * [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled.\r\n *\r\n * @remarks\r\n * To complete the password reset, call {@link confirmPasswordReset} with the code supplied in\r\n * the email sent to the user, along with the new password specified by the user.\r\n *\r\n * @example\r\n * ```javascript\r\n * const actionCodeSettings = {\r\n *   url: 'https://www.example.com/?email=user@example.com',\r\n *   iOS: {\r\n *      bundleId: 'com.example.ios'\r\n *   },\r\n *   android: {\r\n *     packageName: 'com.example.android',\r\n *     installApp: true,\r\n *     minimumVersion: '12'\r\n *   },\r\n *   handleCodeInApp: true\r\n * };\r\n * await sendPasswordResetEmail(auth, 'user@example.com', actionCodeSettings);\r\n * // Obtain code from user.\r\n * await confirmPasswordReset('user@example.com', code);\r\n * ```\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param email - The user's email address.\r\n * @param actionCodeSettings - The {@link ActionCodeSettings}.\r\n *\r\n * @public\r\n */\r\nasync function sendPasswordResetEmail(auth, email, actionCodeSettings) {\r\n    const authInternal = _castAuth(auth);\r\n    const request = {\r\n        requestType: \"PASSWORD_RESET\" /* ActionCodeOperation.PASSWORD_RESET */,\r\n        email,\r\n        clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */\r\n    };\r\n    if (actionCodeSettings) {\r\n        _setActionCodeSettingsOnRequest(authInternal, request, actionCodeSettings);\r\n    }\r\n    await handleRecaptchaFlow(authInternal, request, \"getOobCode\" /* RecaptchaActionName.GET_OOB_CODE */, sendPasswordResetEmail$1);\r\n}\r\n/**\r\n * Completes the password reset process, given a confirmation code and new password.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param oobCode - A confirmation code sent to the user.\r\n * @param newPassword - The new password.\r\n *\r\n * @public\r\n */\r\nasync function confirmPasswordReset(auth, oobCode, newPassword) {\r\n    await resetPassword((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth), {\r\n        oobCode,\r\n        newPassword\r\n    })\r\n        .catch(async (error) => {\r\n        if (error.code ===\r\n            `auth/${\"password-does-not-meet-requirements\" /* AuthErrorCode.PASSWORD_DOES_NOT_MEET_REQUIREMENTS */}`) {\r\n            void recachePasswordPolicy(auth);\r\n        }\r\n        throw error;\r\n    });\r\n    // Do not return the email.\r\n}\r\n/**\r\n * Applies a verification code sent to the user by email or other out-of-band mechanism.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param oobCode - A verification code sent to the user.\r\n *\r\n * @public\r\n */\r\nasync function applyActionCode(auth, oobCode) {\r\n    await applyActionCode$1((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth), { oobCode });\r\n}\r\n/**\r\n * Checks a verification code sent to the user by email or other out-of-band mechanism.\r\n *\r\n * @returns metadata about the code.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param oobCode - A verification code sent to the user.\r\n *\r\n * @public\r\n */\r\nasync function checkActionCode(auth, oobCode) {\r\n    const authModular = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth);\r\n    const response = await resetPassword(authModular, { oobCode });\r\n    // Email could be empty only if the request type is EMAIL_SIGNIN or\r\n    // VERIFY_AND_CHANGE_EMAIL.\r\n    // New email should not be empty if the request type is\r\n    // VERIFY_AND_CHANGE_EMAIL.\r\n    // Multi-factor info could not be empty if the request type is\r\n    // REVERT_SECOND_FACTOR_ADDITION.\r\n    const operation = response.requestType;\r\n    _assert(operation, authModular, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    switch (operation) {\r\n        case \"EMAIL_SIGNIN\" /* ActionCodeOperation.EMAIL_SIGNIN */:\r\n            break;\r\n        case \"VERIFY_AND_CHANGE_EMAIL\" /* ActionCodeOperation.VERIFY_AND_CHANGE_EMAIL */:\r\n            _assert(response.newEmail, authModular, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n            break;\r\n        case \"REVERT_SECOND_FACTOR_ADDITION\" /* ActionCodeOperation.REVERT_SECOND_FACTOR_ADDITION */:\r\n            _assert(response.mfaInfo, authModular, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        // fall through\r\n        default:\r\n            _assert(response.email, authModular, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n    }\r\n    // The multi-factor info for revert second factor addition\r\n    let multiFactorInfo = null;\r\n    if (response.mfaInfo) {\r\n        multiFactorInfo = MultiFactorInfoImpl._fromServerResponse(_castAuth(authModular), response.mfaInfo);\r\n    }\r\n    return {\r\n        data: {\r\n            email: (response.requestType === \"VERIFY_AND_CHANGE_EMAIL\" /* ActionCodeOperation.VERIFY_AND_CHANGE_EMAIL */\r\n                ? response.newEmail\r\n                : response.email) || null,\r\n            previousEmail: (response.requestType === \"VERIFY_AND_CHANGE_EMAIL\" /* ActionCodeOperation.VERIFY_AND_CHANGE_EMAIL */\r\n                ? response.email\r\n                : response.newEmail) || null,\r\n            multiFactorInfo\r\n        },\r\n        operation\r\n    };\r\n}\r\n/**\r\n * Checks a password reset code sent to the user by email or other out-of-band mechanism.\r\n *\r\n * @returns the user's email address if valid.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param code - A verification code sent to the user.\r\n *\r\n * @public\r\n */\r\nasync function verifyPasswordResetCode(auth, code) {\r\n    const { data } = await checkActionCode((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth), code);\r\n    // Email should always be present since a code was sent to it\r\n    return data.email;\r\n}\r\n/**\r\n * Creates a new user account associated with the specified email address and password.\r\n *\r\n * @remarks\r\n * On successful creation of the user account, this user will also be signed in to your application.\r\n *\r\n * User account creation can fail if the account already exists or the password is invalid.\r\n *\r\n * Note: The email address acts as a unique identifier for the user and enables an email-based\r\n * password reset. This function will create a new user account and set the initial user password.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param email - The user's email address.\r\n * @param password - The user's chosen password.\r\n *\r\n * @public\r\n */\r\nasync function createUserWithEmailAndPassword(auth, email, password) {\r\n    const authInternal = _castAuth(auth);\r\n    const request = {\r\n        returnSecureToken: true,\r\n        email,\r\n        password,\r\n        clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */\r\n    };\r\n    const signUpResponse = handleRecaptchaFlow(authInternal, request, \"signUpPassword\" /* RecaptchaActionName.SIGN_UP_PASSWORD */, signUp);\r\n    const response = await signUpResponse.catch(error => {\r\n        if (error.code === `auth/${\"password-does-not-meet-requirements\" /* AuthErrorCode.PASSWORD_DOES_NOT_MEET_REQUIREMENTS */}`) {\r\n            void recachePasswordPolicy(auth);\r\n        }\r\n        throw error;\r\n    });\r\n    const userCredential = await UserCredentialImpl._fromIdTokenResponse(authInternal, \"signIn\" /* OperationType.SIGN_IN */, response);\r\n    await authInternal._updateCurrentUser(userCredential.user);\r\n    return userCredential;\r\n}\r\n/**\r\n * Asynchronously signs in using an email and password.\r\n *\r\n * @remarks\r\n * Fails with an error if the email address and password do not match.\r\n * When [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled,\r\n * this method fails with \"auth/invalid-credential\" in case of an invalid email/password.\r\n *\r\n * Note: The user's password is NOT the password used to access the user's email account. The\r\n * email address serves as a unique identifier for the user, and the password is used to access\r\n * the user's account in your Firebase project. See also: {@link createUserWithEmailAndPassword}.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param email - The users email address.\r\n * @param password - The users password.\r\n *\r\n * @public\r\n */\r\nfunction signInWithEmailAndPassword(auth, email, password) {\r\n    return signInWithCredential((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth), EmailAuthProvider.credential(email, password)).catch(async (error) => {\r\n        if (error.code === `auth/${\"password-does-not-meet-requirements\" /* AuthErrorCode.PASSWORD_DOES_NOT_MEET_REQUIREMENTS */}`) {\r\n            void recachePasswordPolicy(auth);\r\n        }\r\n        throw error;\r\n    });\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Sends a sign-in email link to the user with the specified email.\r\n *\r\n * @remarks\r\n * The sign-in operation has to always be completed in the app unlike other out of band email\r\n * actions (password reset and email verifications). This is because, at the end of the flow,\r\n * the user is expected to be signed in and their Auth state persisted within the app.\r\n *\r\n * To complete sign in with the email link, call {@link signInWithEmailLink} with the email\r\n * address and the email link supplied in the email sent to the user.\r\n *\r\n * @example\r\n * ```javascript\r\n * const actionCodeSettings = {\r\n *   url: 'https://www.example.com/?email=user@example.com',\r\n *   iOS: {\r\n *      bundleId: 'com.example.ios'\r\n *   },\r\n *   android: {\r\n *     packageName: 'com.example.android',\r\n *     installApp: true,\r\n *     minimumVersion: '12'\r\n *   },\r\n *   handleCodeInApp: true\r\n * };\r\n * await sendSignInLinkToEmail(auth, 'user@example.com', actionCodeSettings);\r\n * // Obtain emailLink from the user.\r\n * if(isSignInWithEmailLink(auth, emailLink)) {\r\n *   await signInWithEmailLink(auth, 'user@example.com', emailLink);\r\n * }\r\n * ```\r\n *\r\n * @param authInternal - The {@link Auth} instance.\r\n * @param email - The user's email address.\r\n * @param actionCodeSettings - The {@link ActionCodeSettings}.\r\n *\r\n * @public\r\n */\r\nasync function sendSignInLinkToEmail(auth, email, actionCodeSettings) {\r\n    const authInternal = _castAuth(auth);\r\n    const request = {\r\n        requestType: \"EMAIL_SIGNIN\" /* ActionCodeOperation.EMAIL_SIGNIN */,\r\n        email,\r\n        clientType: \"CLIENT_TYPE_WEB\" /* RecaptchaClientType.WEB */\r\n    };\r\n    function setActionCodeSettings(request, actionCodeSettings) {\r\n        _assert(actionCodeSettings.handleCodeInApp, authInternal, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        if (actionCodeSettings) {\r\n            _setActionCodeSettingsOnRequest(authInternal, request, actionCodeSettings);\r\n        }\r\n    }\r\n    setActionCodeSettings(request, actionCodeSettings);\r\n    await handleRecaptchaFlow(authInternal, request, \"getOobCode\" /* RecaptchaActionName.GET_OOB_CODE */, sendSignInLinkToEmail$1);\r\n}\r\n/**\r\n * Checks if an incoming link is a sign-in with email link suitable for {@link signInWithEmailLink}.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param emailLink - The link sent to the user's email address.\r\n *\r\n * @public\r\n */\r\nfunction isSignInWithEmailLink(auth, emailLink) {\r\n    const actionCodeUrl = ActionCodeURL.parseLink(emailLink);\r\n    return (actionCodeUrl === null || actionCodeUrl === void 0 ? void 0 : actionCodeUrl.operation) === \"EMAIL_SIGNIN\" /* ActionCodeOperation.EMAIL_SIGNIN */;\r\n}\r\n/**\r\n * Asynchronously signs in using an email and sign-in email link.\r\n *\r\n * @remarks\r\n * If no link is passed, the link is inferred from the current URL.\r\n *\r\n * Fails with an error if the email address is invalid or OTP in email link expires.\r\n *\r\n * Note: Confirm the link is a sign-in email link before calling this method firebase.auth.Auth.isSignInWithEmailLink.\r\n *\r\n * @example\r\n * ```javascript\r\n * const actionCodeSettings = {\r\n *   url: 'https://www.example.com/?email=user@example.com',\r\n *   iOS: {\r\n *      bundleId: 'com.example.ios'\r\n *   },\r\n *   android: {\r\n *     packageName: 'com.example.android',\r\n *     installApp: true,\r\n *     minimumVersion: '12'\r\n *   },\r\n *   handleCodeInApp: true\r\n * };\r\n * await sendSignInLinkToEmail(auth, 'user@example.com', actionCodeSettings);\r\n * // Obtain emailLink from the user.\r\n * if(isSignInWithEmailLink(auth, emailLink)) {\r\n *   await signInWithEmailLink(auth, 'user@example.com', emailLink);\r\n * }\r\n * ```\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param email - The user's email address.\r\n * @param emailLink - The link sent to the user's email address.\r\n *\r\n * @public\r\n */\r\nasync function signInWithEmailLink(auth, email, emailLink) {\r\n    const authModular = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth);\r\n    const credential = EmailAuthProvider.credentialWithLink(email, emailLink || _getCurrentUrl());\r\n    // Check if the tenant ID in the email link matches the tenant ID on Auth\r\n    // instance.\r\n    _assert(credential._tenantId === (authModular.tenantId || null), authModular, \"tenant-id-mismatch\" /* AuthErrorCode.TENANT_ID_MISMATCH */);\r\n    return signInWithCredential(authModular, credential);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function createAuthUri(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:createAuthUri\" /* Endpoint.CREATE_AUTH_URI */, _addTidIfNecessary(auth, request));\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Gets the list of possible sign in methods for the given email address. This method returns an\r\n * empty list when [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled, irrespective of the number of\r\n * authentication methods available for the given email.\r\n *\r\n * @remarks\r\n * This is useful to differentiate methods of sign-in for the same provider, eg.\r\n * {@link EmailAuthProvider} which has 2 methods of sign-in,\r\n * {@link SignInMethod}.EMAIL_PASSWORD and\r\n * {@link SignInMethod}.EMAIL_LINK.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param email - The user's email address.\r\n *\r\n * Deprecated. Migrating off of this method is recommended as a security best-practice.\r\n * Learn more in the Identity Platform documentation for [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection).\r\n * @public\r\n */\r\nasync function fetchSignInMethodsForEmail(auth, email) {\r\n    // createAuthUri returns an error if continue URI is not http or https.\r\n    // For environments like Cordova, Chrome extensions, native frameworks, file\r\n    // systems, etc, use http://localhost as continue URL.\r\n    const continueUri = _isHttpOrHttps() ? _getCurrentUrl() : 'http://localhost';\r\n    const request = {\r\n        identifier: email,\r\n        continueUri\r\n    };\r\n    const { signinMethods } = await createAuthUri((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth), request);\r\n    return signinMethods || [];\r\n}\r\n/**\r\n * Sends a verification email to a user.\r\n *\r\n * @remarks\r\n * The verification process is completed by calling {@link applyActionCode}.\r\n *\r\n * @example\r\n * ```javascript\r\n * const actionCodeSettings = {\r\n *   url: 'https://www.example.com/?email=user@example.com',\r\n *   iOS: {\r\n *      bundleId: 'com.example.ios'\r\n *   },\r\n *   android: {\r\n *     packageName: 'com.example.android',\r\n *     installApp: true,\r\n *     minimumVersion: '12'\r\n *   },\r\n *   handleCodeInApp: true\r\n * };\r\n * await sendEmailVerification(user, actionCodeSettings);\r\n * // Obtain code from the user.\r\n * await applyActionCode(auth, code);\r\n * ```\r\n *\r\n * @param user - The user.\r\n * @param actionCodeSettings - The {@link ActionCodeSettings}.\r\n *\r\n * @public\r\n */\r\nasync function sendEmailVerification(user, actionCodeSettings) {\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    const idToken = await user.getIdToken();\r\n    const request = {\r\n        requestType: \"VERIFY_EMAIL\" /* ActionCodeOperation.VERIFY_EMAIL */,\r\n        idToken\r\n    };\r\n    if (actionCodeSettings) {\r\n        _setActionCodeSettingsOnRequest(userInternal.auth, request, actionCodeSettings);\r\n    }\r\n    const { email } = await sendEmailVerification$1(userInternal.auth, request);\r\n    if (email !== user.email) {\r\n        await user.reload();\r\n    }\r\n}\r\n/**\r\n * Sends a verification email to a new email address.\r\n *\r\n * @remarks\r\n * The user's email will be updated to the new one after being verified.\r\n *\r\n * If you have a custom email action handler, you can complete the verification process by calling\r\n * {@link applyActionCode}.\r\n *\r\n * @example\r\n * ```javascript\r\n * const actionCodeSettings = {\r\n *   url: 'https://www.example.com/?email=user@example.com',\r\n *   iOS: {\r\n *      bundleId: 'com.example.ios'\r\n *   },\r\n *   android: {\r\n *     packageName: 'com.example.android',\r\n *     installApp: true,\r\n *     minimumVersion: '12'\r\n *   },\r\n *   handleCodeInApp: true\r\n * };\r\n * await verifyBeforeUpdateEmail(user, 'newemail@example.com', actionCodeSettings);\r\n * // Obtain code from the user.\r\n * await applyActionCode(auth, code);\r\n * ```\r\n *\r\n * @param user - The user.\r\n * @param newEmail - The new email address to be verified before update.\r\n * @param actionCodeSettings - The {@link ActionCodeSettings}.\r\n *\r\n * @public\r\n */\r\nasync function verifyBeforeUpdateEmail(user, newEmail, actionCodeSettings) {\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    const idToken = await user.getIdToken();\r\n    const request = {\r\n        requestType: \"VERIFY_AND_CHANGE_EMAIL\" /* ActionCodeOperation.VERIFY_AND_CHANGE_EMAIL */,\r\n        idToken,\r\n        newEmail\r\n    };\r\n    if (actionCodeSettings) {\r\n        _setActionCodeSettingsOnRequest(userInternal.auth, request, actionCodeSettings);\r\n    }\r\n    const { email } = await verifyAndChangeEmail(userInternal.auth, request);\r\n    if (email !== user.email) {\r\n        // If the local copy of the email on user is outdated, reload the\r\n        // user.\r\n        await user.reload();\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nasync function updateProfile$1(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v1/accounts:update\" /* Endpoint.SET_ACCOUNT_INFO */, request);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Updates a user's profile data.\r\n *\r\n * @param user - The user.\r\n * @param profile - The profile's `displayName` and `photoURL` to update.\r\n *\r\n * @public\r\n */\r\nasync function updateProfile(user, { displayName, photoURL: photoUrl }) {\r\n    if (displayName === undefined && photoUrl === undefined) {\r\n        return;\r\n    }\r\n    const userInternal = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    const idToken = await userInternal.getIdToken();\r\n    const profileRequest = {\r\n        idToken,\r\n        displayName,\r\n        photoUrl,\r\n        returnSecureToken: true\r\n    };\r\n    const response = await _logoutIfInvalidated(userInternal, updateProfile$1(userInternal.auth, profileRequest));\r\n    userInternal.displayName = response.displayName || null;\r\n    userInternal.photoURL = response.photoUrl || null;\r\n    // Update the password provider as well\r\n    const passwordProvider = userInternal.providerData.find(({ providerId }) => providerId === \"password\" /* ProviderId.PASSWORD */);\r\n    if (passwordProvider) {\r\n        passwordProvider.displayName = userInternal.displayName;\r\n        passwordProvider.photoURL = userInternal.photoURL;\r\n    }\r\n    await userInternal._updateTokensIfNecessary(response);\r\n}\r\n/**\r\n * Updates the user's email address.\r\n *\r\n * @remarks\r\n * An email will be sent to the original email address (if it was set) that allows to revoke the\r\n * email address change, in order to protect them from account hijacking.\r\n *\r\n * Important: this is a security sensitive operation that requires the user to have recently signed\r\n * in. If this requirement isn't met, ask the user to authenticate again and then call\r\n * {@link reauthenticateWithCredential}.\r\n *\r\n * @param user - The user.\r\n * @param newEmail - The new email address.\r\n *\r\n * Throws \"auth/operation-not-allowed\" error when [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled.\r\n * Deprecated - Use {@link verifyBeforeUpdateEmail} instead.\r\n *\r\n * @public\r\n */\r\nfunction updateEmail(user, newEmail) {\r\n    return updateEmailOrPassword((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user), newEmail, null);\r\n}\r\n/**\r\n * Updates the user's password.\r\n *\r\n * @remarks\r\n * Important: this is a security sensitive operation that requires the user to have recently signed\r\n * in. If this requirement isn't met, ask the user to authenticate again and then call\r\n * {@link reauthenticateWithCredential}.\r\n *\r\n * @param user - The user.\r\n * @param newPassword - The new password.\r\n *\r\n * @public\r\n */\r\nfunction updatePassword(user, newPassword) {\r\n    return updateEmailOrPassword((0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user), null, newPassword);\r\n}\r\nasync function updateEmailOrPassword(user, email, password) {\r\n    const { auth } = user;\r\n    const idToken = await user.getIdToken();\r\n    const request = {\r\n        idToken,\r\n        returnSecureToken: true\r\n    };\r\n    if (email) {\r\n        request.email = email;\r\n    }\r\n    if (password) {\r\n        request.password = password;\r\n    }\r\n    const response = await _logoutIfInvalidated(user, updateEmailPassword(auth, request));\r\n    await user._updateTokensIfNecessary(response, /* reload */ true);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Parse the `AdditionalUserInfo` from the ID token response.\r\n *\r\n */\r\nfunction _fromIdTokenResponse(idTokenResponse) {\r\n    var _a, _b;\r\n    if (!idTokenResponse) {\r\n        return null;\r\n    }\r\n    const { providerId } = idTokenResponse;\r\n    const profile = idTokenResponse.rawUserInfo\r\n        ? JSON.parse(idTokenResponse.rawUserInfo)\r\n        : {};\r\n    const isNewUser = idTokenResponse.isNewUser ||\r\n        idTokenResponse.kind === \"identitytoolkit#SignupNewUserResponse\" /* IdTokenResponseKind.SignupNewUser */;\r\n    if (!providerId && (idTokenResponse === null || idTokenResponse === void 0 ? void 0 : idTokenResponse.idToken)) {\r\n        const signInProvider = (_b = (_a = _parseToken(idTokenResponse.idToken)) === null || _a === void 0 ? void 0 : _a.firebase) === null || _b === void 0 ? void 0 : _b['sign_in_provider'];\r\n        if (signInProvider) {\r\n            const filteredProviderId = signInProvider !== \"anonymous\" /* ProviderId.ANONYMOUS */ &&\r\n                signInProvider !== \"custom\" /* ProviderId.CUSTOM */\r\n                ? signInProvider\r\n                : null;\r\n            // Uses generic class in accordance with the legacy SDK.\r\n            return new GenericAdditionalUserInfo(isNewUser, filteredProviderId);\r\n        }\r\n    }\r\n    if (!providerId) {\r\n        return null;\r\n    }\r\n    switch (providerId) {\r\n        case \"facebook.com\" /* ProviderId.FACEBOOK */:\r\n            return new FacebookAdditionalUserInfo(isNewUser, profile);\r\n        case \"github.com\" /* ProviderId.GITHUB */:\r\n            return new GithubAdditionalUserInfo(isNewUser, profile);\r\n        case \"google.com\" /* ProviderId.GOOGLE */:\r\n            return new GoogleAdditionalUserInfo(isNewUser, profile);\r\n        case \"twitter.com\" /* ProviderId.TWITTER */:\r\n            return new TwitterAdditionalUserInfo(isNewUser, profile, idTokenResponse.screenName || null);\r\n        case \"custom\" /* ProviderId.CUSTOM */:\r\n        case \"anonymous\" /* ProviderId.ANONYMOUS */:\r\n            return new GenericAdditionalUserInfo(isNewUser, null);\r\n        default:\r\n            return new GenericAdditionalUserInfo(isNewUser, providerId, profile);\r\n    }\r\n}\r\nclass GenericAdditionalUserInfo {\r\n    constructor(isNewUser, providerId, profile = {}) {\r\n        this.isNewUser = isNewUser;\r\n        this.providerId = providerId;\r\n        this.profile = profile;\r\n    }\r\n}\r\nclass FederatedAdditionalUserInfoWithUsername extends GenericAdditionalUserInfo {\r\n    constructor(isNewUser, providerId, profile, username) {\r\n        super(isNewUser, providerId, profile);\r\n        this.username = username;\r\n    }\r\n}\r\nclass FacebookAdditionalUserInfo extends GenericAdditionalUserInfo {\r\n    constructor(isNewUser, profile) {\r\n        super(isNewUser, \"facebook.com\" /* ProviderId.FACEBOOK */, profile);\r\n    }\r\n}\r\nclass GithubAdditionalUserInfo extends FederatedAdditionalUserInfoWithUsername {\r\n    constructor(isNewUser, profile) {\r\n        super(isNewUser, \"github.com\" /* ProviderId.GITHUB */, profile, typeof (profile === null || profile === void 0 ? void 0 : profile.login) === 'string' ? profile === null || profile === void 0 ? void 0 : profile.login : null);\r\n    }\r\n}\r\nclass GoogleAdditionalUserInfo extends GenericAdditionalUserInfo {\r\n    constructor(isNewUser, profile) {\r\n        super(isNewUser, \"google.com\" /* ProviderId.GOOGLE */, profile);\r\n    }\r\n}\r\nclass TwitterAdditionalUserInfo extends FederatedAdditionalUserInfoWithUsername {\r\n    constructor(isNewUser, profile, screenName) {\r\n        super(isNewUser, \"twitter.com\" /* ProviderId.TWITTER */, profile, screenName);\r\n    }\r\n}\r\n/**\r\n * Extracts provider specific {@link AdditionalUserInfo} for the given credential.\r\n *\r\n * @param userCredential - The user credential.\r\n *\r\n * @public\r\n */\r\nfunction getAdditionalUserInfo(userCredential) {\r\n    const { user, _tokenResponse } = userCredential;\r\n    if (user.isAnonymous && !_tokenResponse) {\r\n        // Handle the special case where signInAnonymously() gets called twice.\r\n        // No network call is made so there's nothing to actually fill this in\r\n        return {\r\n            providerId: null,\r\n            isNewUser: false,\r\n            profile: null\r\n        };\r\n    }\r\n    return _fromIdTokenResponse(_tokenResponse);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n// Non-optional auth methods.\r\n/**\r\n * Changes the type of persistence on the {@link Auth} instance for the currently saved\r\n * `Auth` session and applies this type of persistence for future sign-in requests, including\r\n * sign-in with redirect requests.\r\n *\r\n * @remarks\r\n * This makes it easy for a user signing in to specify whether their session should be\r\n * remembered or not. It also makes it easier to never persist the `Auth` state for applications\r\n * that are shared by other users or have sensitive data.\r\n *\r\n * This method does not work in a Node.js environment.\r\n *\r\n * @example\r\n * ```javascript\r\n * setPersistence(auth, browserSessionPersistence);\r\n * ```\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param persistence - The {@link Persistence} to use.\r\n * @returns A `Promise` that resolves once the persistence change has completed\r\n *\r\n * @public\r\n */\r\nfunction setPersistence(auth, persistence) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).setPersistence(persistence);\r\n}\r\n/**\r\n * Loads the reCAPTCHA configuration into the `Auth` instance.\r\n *\r\n * @remarks\r\n * This will load the reCAPTCHA config, which indicates whether the reCAPTCHA\r\n * verification flow should be triggered for each auth provider, into the\r\n * current Auth session.\r\n *\r\n * If initializeRecaptchaConfig() is not invoked, the auth flow will always start\r\n * without reCAPTCHA verification. If the provider is configured to require reCAPTCHA\r\n * verification, the SDK will transparently load the reCAPTCHA config and restart the\r\n * auth flows.\r\n *\r\n * Thus, by calling this optional method, you will reduce the latency of future auth flows.\r\n * Loading the reCAPTCHA config early will also enhance the signal collected by reCAPTCHA.\r\n *\r\n * This method does not work in a Node.js environment.\r\n *\r\n * @example\r\n * ```javascript\r\n * initializeRecaptchaConfig(auth);\r\n * ```\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n *\r\n * @public\r\n */\r\nfunction initializeRecaptchaConfig(auth) {\r\n    return _initializeRecaptchaConfig(auth);\r\n}\r\n/**\r\n * Validates the password against the password policy configured for the project or tenant.\r\n *\r\n * @remarks\r\n * If no tenant ID is set on the `Auth` instance, then this method will use the password\r\n * policy configured for the project. Otherwise, this method will use the policy configured\r\n * for the tenant. If a password policy has not been configured, then the default policy\r\n * configured for all projects will be used.\r\n *\r\n * If an auth flow fails because a submitted password does not meet the password policy\r\n * requirements and this method has previously been called, then this method will use the\r\n * most recent policy available when called again.\r\n *\r\n * @example\r\n * ```javascript\r\n * validatePassword(auth, 'some-password');\r\n * ```\r\n *\r\n * @param auth The {@link Auth} instance.\r\n * @param password The password to validate.\r\n *\r\n * @public\r\n */\r\nasync function validatePassword(auth, password) {\r\n    const authInternal = _castAuth(auth);\r\n    return authInternal.validatePassword(password);\r\n}\r\n/**\r\n * Adds an observer for changes to the signed-in user's ID token.\r\n *\r\n * @remarks\r\n * This includes sign-in, sign-out, and token refresh events.\r\n * This will not be triggered automatically upon ID token expiration. Use {@link User.getIdToken} to refresh the ID token.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param nextOrObserver - callback triggered on change.\r\n * @param error - Deprecated. This callback is never triggered. Errors\r\n * on signing in/out can be caught in promises returned from\r\n * sign-in/sign-out functions.\r\n * @param completed - Deprecated. This callback is never triggered.\r\n *\r\n * @public\r\n */\r\nfunction onIdTokenChanged(auth, nextOrObserver, error, completed) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).onIdTokenChanged(nextOrObserver, error, completed);\r\n}\r\n/**\r\n * Adds a blocking callback that runs before an auth state change\r\n * sets a new user.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param callback - callback triggered before new user value is set.\r\n *   If this throws, it blocks the user from being set.\r\n * @param onAbort - callback triggered if a later `beforeAuthStateChanged()`\r\n *   callback throws, allowing you to undo any side effects.\r\n */\r\nfunction beforeAuthStateChanged(auth, callback, onAbort) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).beforeAuthStateChanged(callback, onAbort);\r\n}\r\n/**\r\n * Adds an observer for changes to the user's sign-in state.\r\n *\r\n * @remarks\r\n * To keep the old behavior, see {@link onIdTokenChanged}.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param nextOrObserver - callback triggered on change.\r\n * @param error - Deprecated. This callback is never triggered. Errors\r\n * on signing in/out can be caught in promises returned from\r\n * sign-in/sign-out functions.\r\n * @param completed - Deprecated. This callback is never triggered.\r\n *\r\n * @public\r\n */\r\nfunction onAuthStateChanged(auth, nextOrObserver, error, completed) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).onAuthStateChanged(nextOrObserver, error, completed);\r\n}\r\n/**\r\n * Sets the current language to the default device/browser preference.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n *\r\n * @public\r\n */\r\nfunction useDeviceLanguage(auth) {\r\n    (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).useDeviceLanguage();\r\n}\r\n/**\r\n * Asynchronously sets the provided user as {@link Auth.currentUser} on the\r\n * {@link Auth} instance.\r\n *\r\n * @remarks\r\n * A new instance copy of the user provided will be made and set as currentUser.\r\n *\r\n * This will trigger {@link onAuthStateChanged} and {@link onIdTokenChanged} listeners\r\n * like other sign in methods.\r\n *\r\n * The operation fails with an error if the user to be updated belongs to a different Firebase\r\n * project.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param user - The new {@link User}.\r\n *\r\n * @public\r\n */\r\nfunction updateCurrentUser(auth, user) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).updateCurrentUser(user);\r\n}\r\n/**\r\n * Signs out the current user.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n *\r\n * @public\r\n */\r\nfunction signOut(auth) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth).signOut();\r\n}\r\n/**\r\n * Revokes the given access token. Currently only supports Apple OAuth access tokens.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param token - The Apple OAuth access token.\r\n *\r\n * @public\r\n */\r\nfunction revokeAccessToken(auth, token) {\r\n    const authInternal = _castAuth(auth);\r\n    return authInternal.revokeAccessToken(token);\r\n}\r\n/**\r\n * Deletes and signs out the user.\r\n *\r\n * @remarks\r\n * Important: this is a security-sensitive operation that requires the user to have recently\r\n * signed in. If this requirement isn't met, ask the user to authenticate again and then call\r\n * {@link reauthenticateWithCredential}.\r\n *\r\n * @param user - The user.\r\n *\r\n * @public\r\n */\r\nasync function deleteUser(user) {\r\n    return (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user).delete();\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass MultiFactorSessionImpl {\r\n    constructor(type, credential, user) {\r\n        this.type = type;\r\n        this.credential = credential;\r\n        this.user = user;\r\n    }\r\n    static _fromIdtoken(idToken, user) {\r\n        return new MultiFactorSessionImpl(\"enroll\" /* MultiFactorSessionType.ENROLL */, idToken, user);\r\n    }\r\n    static _fromMfaPendingCredential(mfaPendingCredential) {\r\n        return new MultiFactorSessionImpl(\"signin\" /* MultiFactorSessionType.SIGN_IN */, mfaPendingCredential);\r\n    }\r\n    toJSON() {\r\n        const key = this.type === \"enroll\" /* MultiFactorSessionType.ENROLL */\r\n            ? 'idToken'\r\n            : 'pendingCredential';\r\n        return {\r\n            multiFactorSession: {\r\n                [key]: this.credential\r\n            }\r\n        };\r\n    }\r\n    static fromJSON(obj) {\r\n        var _a, _b;\r\n        if (obj === null || obj === void 0 ? void 0 : obj.multiFactorSession) {\r\n            if ((_a = obj.multiFactorSession) === null || _a === void 0 ? void 0 : _a.pendingCredential) {\r\n                return MultiFactorSessionImpl._fromMfaPendingCredential(obj.multiFactorSession.pendingCredential);\r\n            }\r\n            else if ((_b = obj.multiFactorSession) === null || _b === void 0 ? void 0 : _b.idToken) {\r\n                return MultiFactorSessionImpl._fromIdtoken(obj.multiFactorSession.idToken);\r\n            }\r\n        }\r\n        return null;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass MultiFactorResolverImpl {\r\n    constructor(session, hints, signInResolver) {\r\n        this.session = session;\r\n        this.hints = hints;\r\n        this.signInResolver = signInResolver;\r\n    }\r\n    /** @internal */\r\n    static _fromError(authExtern, error) {\r\n        const auth = _castAuth(authExtern);\r\n        const serverResponse = error.customData._serverResponse;\r\n        const hints = (serverResponse.mfaInfo || []).map(enrollment => MultiFactorInfoImpl._fromServerResponse(auth, enrollment));\r\n        _assert(serverResponse.mfaPendingCredential, auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        const session = MultiFactorSessionImpl._fromMfaPendingCredential(serverResponse.mfaPendingCredential);\r\n        return new MultiFactorResolverImpl(session, hints, async (assertion) => {\r\n            const mfaResponse = await assertion._process(auth, session);\r\n            // Clear out the unneeded fields from the old login response\r\n            delete serverResponse.mfaInfo;\r\n            delete serverResponse.mfaPendingCredential;\r\n            // Use in the new token & refresh token in the old response\r\n            const idTokenResponse = Object.assign(Object.assign({}, serverResponse), { idToken: mfaResponse.idToken, refreshToken: mfaResponse.refreshToken });\r\n            // TODO: we should collapse this switch statement into UserCredentialImpl._forOperation and have it support the SIGN_IN case\r\n            switch (error.operationType) {\r\n                case \"signIn\" /* OperationType.SIGN_IN */:\r\n                    const userCredential = await UserCredentialImpl._fromIdTokenResponse(auth, error.operationType, idTokenResponse);\r\n                    await auth._updateCurrentUser(userCredential.user);\r\n                    return userCredential;\r\n                case \"reauthenticate\" /* OperationType.REAUTHENTICATE */:\r\n                    _assert(error.user, auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n                    return UserCredentialImpl._forOperation(error.user, error.operationType, idTokenResponse);\r\n                default:\r\n                    _fail(auth, \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n            }\r\n        });\r\n    }\r\n    async resolveSignIn(assertionExtern) {\r\n        const assertion = assertionExtern;\r\n        return this.signInResolver(assertion);\r\n    }\r\n}\r\n/**\r\n * Provides a {@link MultiFactorResolver} suitable for completion of a\r\n * multi-factor flow.\r\n *\r\n * @param auth - The {@link Auth} instance.\r\n * @param error - The {@link MultiFactorError} raised during a sign-in, or\r\n * reauthentication operation.\r\n *\r\n * @public\r\n */\r\nfunction getMultiFactorResolver(auth, error) {\r\n    var _a;\r\n    const authModular = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(auth);\r\n    const errorInternal = error;\r\n    _assert(error.customData.operationType, authModular, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n    _assert((_a = errorInternal.customData._serverResponse) === null || _a === void 0 ? void 0 : _a.mfaPendingCredential, authModular, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n    return MultiFactorResolverImpl._fromError(authModular, errorInternal);\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction startEnrollTotpMfa(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v2/accounts/mfaEnrollment:start\" /* Endpoint.START_MFA_ENROLLMENT */, _addTidIfNecessary(auth, request));\r\n}\r\nfunction finalizeEnrollTotpMfa(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v2/accounts/mfaEnrollment:finalize\" /* Endpoint.FINALIZE_MFA_ENROLLMENT */, _addTidIfNecessary(auth, request));\r\n}\r\nfunction withdrawMfa(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v2/accounts/mfaEnrollment:withdraw\" /* Endpoint.WITHDRAW_MFA */, _addTidIfNecessary(auth, request));\r\n}\n\nclass MultiFactorUserImpl {\r\n    constructor(user) {\r\n        this.user = user;\r\n        this.enrolledFactors = [];\r\n        user._onReload(userInfo => {\r\n            if (userInfo.mfaInfo) {\r\n                this.enrolledFactors = userInfo.mfaInfo.map(enrollment => MultiFactorInfoImpl._fromServerResponse(user.auth, enrollment));\r\n            }\r\n        });\r\n    }\r\n    static _fromUser(user) {\r\n        return new MultiFactorUserImpl(user);\r\n    }\r\n    async getSession() {\r\n        return MultiFactorSessionImpl._fromIdtoken(await this.user.getIdToken(), this.user);\r\n    }\r\n    async enroll(assertionExtern, displayName) {\r\n        const assertion = assertionExtern;\r\n        const session = (await this.getSession());\r\n        const finalizeMfaResponse = await _logoutIfInvalidated(this.user, assertion._process(this.user.auth, session, displayName));\r\n        // New tokens will be issued after enrollment of the new second factors.\r\n        // They need to be updated on the user.\r\n        await this.user._updateTokensIfNecessary(finalizeMfaResponse);\r\n        // The user needs to be reloaded to get the new multi-factor information\r\n        // from server. USER_RELOADED event will be triggered and `enrolledFactors`\r\n        // will be updated.\r\n        return this.user.reload();\r\n    }\r\n    async unenroll(infoOrUid) {\r\n        const mfaEnrollmentId = typeof infoOrUid === 'string' ? infoOrUid : infoOrUid.uid;\r\n        const idToken = await this.user.getIdToken();\r\n        try {\r\n            const idTokenResponse = await _logoutIfInvalidated(this.user, withdrawMfa(this.user.auth, {\r\n                idToken,\r\n                mfaEnrollmentId\r\n            }));\r\n            // Remove the second factor from the user's list.\r\n            this.enrolledFactors = this.enrolledFactors.filter(({ uid }) => uid !== mfaEnrollmentId);\r\n            // Depending on whether the backend decided to revoke the user's session,\r\n            // the tokenResponse may be empty. If the tokens were not updated (and they\r\n            // are now invalid), reloading the user will discover this and invalidate\r\n            // the user's state accordingly.\r\n            await this.user._updateTokensIfNecessary(idTokenResponse);\r\n            await this.user.reload();\r\n        }\r\n        catch (e) {\r\n            throw e;\r\n        }\r\n    }\r\n}\r\nconst multiFactorUserCache = new WeakMap();\r\n/**\r\n * The {@link MultiFactorUser} corresponding to the user.\r\n *\r\n * @remarks\r\n * This is used to access all multi-factor properties and operations related to the user.\r\n *\r\n * @param user - The user.\r\n *\r\n * @public\r\n */\r\nfunction multiFactor(user) {\r\n    const userModular = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getModularInstance)(user);\r\n    if (!multiFactorUserCache.has(userModular)) {\r\n        multiFactorUserCache.set(userModular, MultiFactorUserImpl._fromUser(userModular));\r\n    }\r\n    return multiFactorUserCache.get(userModular);\r\n}\n\nvar name = \"@firebase/auth\";\nvar version = \"1.5.1\";\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nclass AuthInterop {\r\n    constructor(auth) {\r\n        this.auth = auth;\r\n        this.internalListeners = new Map();\r\n    }\r\n    getUid() {\r\n        var _a;\r\n        this.assertAuthConfigured();\r\n        return ((_a = this.auth.currentUser) === null || _a === void 0 ? void 0 : _a.uid) || null;\r\n    }\r\n    async getToken(forceRefresh) {\r\n        this.assertAuthConfigured();\r\n        await this.auth._initializationPromise;\r\n        if (!this.auth.currentUser) {\r\n            return null;\r\n        }\r\n        const accessToken = await this.auth.currentUser.getIdToken(forceRefresh);\r\n        return { accessToken };\r\n    }\r\n    addAuthTokenListener(listener) {\r\n        this.assertAuthConfigured();\r\n        if (this.internalListeners.has(listener)) {\r\n            return;\r\n        }\r\n        const unsubscribe = this.auth.onIdTokenChanged(user => {\r\n            listener((user === null || user === void 0 ? void 0 : user.stsTokenManager.accessToken) || null);\r\n        });\r\n        this.internalListeners.set(listener, unsubscribe);\r\n        this.updateProactiveRefresh();\r\n    }\r\n    removeAuthTokenListener(listener) {\r\n        this.assertAuthConfigured();\r\n        const unsubscribe = this.internalListeners.get(listener);\r\n        if (!unsubscribe) {\r\n            return;\r\n        }\r\n        this.internalListeners.delete(listener);\r\n        unsubscribe();\r\n        this.updateProactiveRefresh();\r\n    }\r\n    assertAuthConfigured() {\r\n        _assert(this.auth._initializationPromise, \"dependent-sdk-initialized-before-auth\" /* AuthErrorCode.DEPENDENT_SDK_INIT_BEFORE_AUTH */);\r\n    }\r\n    updateProactiveRefresh() {\r\n        if (this.internalListeners.size > 0) {\r\n            this.auth._startProactiveRefresh();\r\n        }\r\n        else {\r\n            this.auth._stopProactiveRefresh();\r\n        }\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction getVersionForPlatform(clientPlatform) {\r\n    switch (clientPlatform) {\r\n        case \"Node\" /* ClientPlatform.NODE */:\r\n            return 'node';\r\n        case \"ReactNative\" /* ClientPlatform.REACT_NATIVE */:\r\n            return 'rn';\r\n        case \"Worker\" /* ClientPlatform.WORKER */:\r\n            return 'webworker';\r\n        case \"Cordova\" /* ClientPlatform.CORDOVA */:\r\n            return 'cordova';\r\n        default:\r\n            return undefined;\r\n    }\r\n}\r\n/** @internal */\r\nfunction registerAuth(clientPlatform) {\r\n    (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__._registerComponent)(new _firebase_component__WEBPACK_IMPORTED_MODULE_2__.Component(\"auth\" /* _ComponentName.AUTH */, (container, { options: deps }) => {\r\n        const app = container.getProvider('app').getImmediate();\r\n        const heartbeatServiceProvider = container.getProvider('heartbeat');\r\n        const appCheckServiceProvider = container.getProvider('app-check-internal');\r\n        const { apiKey, authDomain } = app.options;\r\n        _assert(apiKey && !apiKey.includes(':'), \"invalid-api-key\" /* AuthErrorCode.INVALID_API_KEY */, { appName: app.name });\r\n        const config = {\r\n            apiKey,\r\n            authDomain,\r\n            clientPlatform,\r\n            apiHost: \"identitytoolkit.googleapis.com\" /* DefaultConfig.API_HOST */,\r\n            tokenApiHost: \"securetoken.googleapis.com\" /* DefaultConfig.TOKEN_API_HOST */,\r\n            apiScheme: \"https\" /* DefaultConfig.API_SCHEME */,\r\n            sdkClientVersion: _getClientVersion(clientPlatform)\r\n        };\r\n        const authInstance = new AuthImpl(app, heartbeatServiceProvider, appCheckServiceProvider, config);\r\n        _initializeAuthInstance(authInstance, deps);\r\n        return authInstance;\r\n    }, \"PUBLIC\" /* ComponentType.PUBLIC */)\r\n        /**\r\n         * Auth can only be initialized by explicitly calling getAuth() or initializeAuth()\r\n         * For why we do this, See go/firebase-next-auth-init\r\n         */\r\n        .setInstantiationMode(\"EXPLICIT\" /* InstantiationMode.EXPLICIT */)\r\n        /**\r\n         * Because all firebase products that depend on auth depend on auth-internal directly,\r\n         * we need to initialize auth-internal after auth is initialized to make it available to other firebase products.\r\n         */\r\n        .setInstanceCreatedCallback((container, _instanceIdentifier, _instance) => {\r\n        const authInternalProvider = container.getProvider(\"auth-internal\" /* _ComponentName.AUTH_INTERNAL */);\r\n        authInternalProvider.initialize();\r\n    }));\r\n    (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__._registerComponent)(new _firebase_component__WEBPACK_IMPORTED_MODULE_2__.Component(\"auth-internal\" /* _ComponentName.AUTH_INTERNAL */, container => {\r\n        const auth = _castAuth(container.getProvider(\"auth\" /* _ComponentName.AUTH */).getImmediate());\r\n        return (auth => new AuthInterop(auth))(auth);\r\n    }, \"PRIVATE\" /* ComponentType.PRIVATE */).setInstantiationMode(\"EXPLICIT\" /* InstantiationMode.EXPLICIT */));\r\n    (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__.registerVersion)(name, version, getVersionForPlatform(clientPlatform));\r\n    // BUILD_TARGET will be replaced by values like esm5, esm2017, cjs5, etc during the compilation\r\n    (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__.registerVersion)(name, version, 'esm2017');\r\n}\n\n/**\r\n * @license\r\n * Copyright 2021 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n// Initialize the fetch polyfill, the types are slightly off so just cast and hope for the best\r\nFetchProvider.initialize(undici__WEBPACK_IMPORTED_MODULE_3__.fetch, undici__WEBPACK_IMPORTED_MODULE_3__.Headers, undici__WEBPACK_IMPORTED_MODULE_3__.Response);\r\n// First, we set up the various platform-specific features for Node (register\r\n// the version and declare the Node getAuth function)\r\nfunction getAuth(app = (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__.getApp)()) {\r\n    const provider = (0,_firebase_app__WEBPACK_IMPORTED_MODULE_1__._getProvider)(app, 'auth');\r\n    if (provider.isInitialized()) {\r\n        return provider.getImmediate();\r\n    }\r\n    const auth = initializeAuth(app);\r\n    const authEmulatorHost = (0,_firebase_util__WEBPACK_IMPORTED_MODULE_0__.getDefaultEmulatorHost)('auth');\r\n    if (authEmulatorHost) {\r\n        connectAuthEmulator(auth, `http://${authEmulatorHost}`);\r\n    }\r\n    return auth;\r\n}\r\nregisterAuth(\"Node\" /* ClientPlatform.NODE */);\r\n// The rest of this file contains no-ops and errors for browser-specific\r\n// methods. We keep the browser and Node entry points the same, but features\r\n// that only work in browsers are set to either do nothing (setPersistence) or\r\n// to reject with an auth/operation-not-supported-in-this-environment error.\r\n// The below exports are pulled into the main entry point by a rollup alias\r\n// plugin (overwriting the default browser imports).\r\n/** auth/operation-not-supported-in-this-environment */\r\nconst NOT_AVAILABLE_ERROR = _createError(\"operation-not-supported-in-this-environment\" /* AuthErrorCode.OPERATION_NOT_SUPPORTED */);\r\n/** Reject with auth/operation-not-supported-in-this-environment */\r\nasync function fail() {\r\n    throw NOT_AVAILABLE_ERROR;\r\n}\r\n/**\r\n * A class which will throw with\r\n * auth/operation-not-supported-in-this-environment if instantiated\r\n */\r\nclass FailClass {\r\n    constructor() {\r\n        throw NOT_AVAILABLE_ERROR;\r\n    }\r\n}\r\nconst browserLocalPersistence = inMemoryPersistence;\r\nconst browserSessionPersistence = inMemoryPersistence;\r\nconst indexedDBLocalPersistence = inMemoryPersistence;\r\nconst browserPopupRedirectResolver = NOT_AVAILABLE_ERROR;\r\nconst PhoneAuthProvider = FailClass;\r\nconst signInWithPhoneNumber = fail;\r\nconst linkWithPhoneNumber = fail;\r\nconst reauthenticateWithPhoneNumber = fail;\r\nconst updatePhoneNumber = fail;\r\nconst signInWithPopup = fail;\r\nconst linkWithPopup = fail;\r\nconst reauthenticateWithPopup = fail;\r\nconst signInWithRedirect = fail;\r\nconst linkWithRedirect = fail;\r\nconst reauthenticateWithRedirect = fail;\r\nconst getRedirectResult = fail;\r\nconst RecaptchaVerifier = FailClass;\r\nclass PhoneMultiFactorGenerator {\r\n    static assertion() {\r\n        throw NOT_AVAILABLE_ERROR;\r\n    }\r\n}\r\n// Set persistence should no-op instead of fail. Changing the prototype will\r\n// make sure both setPersistence(auth, persistence) and\r\n// auth.setPersistence(persistence) are covered.\r\nAuthImpl.prototype.setPersistence = async () => { };\n\n/**\r\n * @license\r\n * Copyright 2020 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nfunction finalizeSignInTotpMfa(auth, request) {\r\n    return _performApiRequest(auth, \"POST\" /* HttpMethod.POST */, \"/v2/accounts/mfaSignIn:finalize\" /* Endpoint.FINALIZE_MFA_SIGN_IN */, _addTidIfNecessary(auth, request));\r\n}\n\nclass MultiFactorAssertionImpl {\r\n    constructor(factorId) {\r\n        this.factorId = factorId;\r\n    }\r\n    _process(auth, session, displayName) {\r\n        switch (session.type) {\r\n            case \"enroll\" /* MultiFactorSessionType.ENROLL */:\r\n                return this._finalizeEnroll(auth, session.credential, displayName);\r\n            case \"signin\" /* MultiFactorSessionType.SIGN_IN */:\r\n                return this._finalizeSignIn(auth, session.credential);\r\n            default:\r\n                return debugFail('unexpected MultiFactorSessionType');\r\n        }\r\n    }\r\n}\n\n/**\r\n * Provider for generating a {@link TotpMultiFactorAssertion}.\r\n *\r\n * @public\r\n */\r\nclass TotpMultiFactorGenerator {\r\n    /**\r\n     * Provides a {@link TotpMultiFactorAssertion} to confirm ownership of\r\n     * the TOTP (time-based one-time password) second factor.\r\n     * This assertion is used to complete enrollment in TOTP second factor.\r\n     *\r\n     * @param secret A {@link TotpSecret} containing the shared secret key and other TOTP parameters.\r\n     * @param oneTimePassword One-time password from TOTP App.\r\n     * @returns A {@link TotpMultiFactorAssertion} which can be used with\r\n     * {@link MultiFactorUser.enroll}.\r\n     */\r\n    static assertionForEnrollment(secret, oneTimePassword) {\r\n        return TotpMultiFactorAssertionImpl._fromSecret(secret, oneTimePassword);\r\n    }\r\n    /**\r\n     * Provides a {@link TotpMultiFactorAssertion} to confirm ownership of the TOTP second factor.\r\n     * This assertion is used to complete signIn with TOTP as the second factor.\r\n     *\r\n     * @param enrollmentId identifies the enrolled TOTP second factor.\r\n     * @param oneTimePassword One-time password from TOTP App.\r\n     * @returns A {@link TotpMultiFactorAssertion} which can be used with\r\n     * {@link MultiFactorResolver.resolveSignIn}.\r\n     */\r\n    static assertionForSignIn(enrollmentId, oneTimePassword) {\r\n        return TotpMultiFactorAssertionImpl._fromEnrollmentId(enrollmentId, oneTimePassword);\r\n    }\r\n    /**\r\n     * Returns a promise to {@link TotpSecret} which contains the TOTP shared secret key and other parameters.\r\n     * Creates a TOTP secret as part of enrolling a TOTP second factor.\r\n     * Used for generating a QR code URL or inputting into a TOTP app.\r\n     * This method uses the auth instance corresponding to the user in the multiFactorSession.\r\n     *\r\n     * @param session The {@link MultiFactorSession} that the user is part of.\r\n     * @returns A promise to {@link TotpSecret}.\r\n     */\r\n    static async generateSecret(session) {\r\n        var _a;\r\n        const mfaSession = session;\r\n        _assert(typeof ((_a = mfaSession.user) === null || _a === void 0 ? void 0 : _a.auth) !== 'undefined', \"internal-error\" /* AuthErrorCode.INTERNAL_ERROR */);\r\n        const response = await startEnrollTotpMfa(mfaSession.user.auth, {\r\n            idToken: mfaSession.credential,\r\n            totpEnrollmentInfo: {}\r\n        });\r\n        return TotpSecret._fromStartTotpMfaEnrollmentResponse(response, mfaSession.user.auth);\r\n    }\r\n}\r\n/**\r\n * The identifier of the TOTP second factor: `totp`.\r\n */\r\nTotpMultiFactorGenerator.FACTOR_ID = \"totp\" /* FactorId.TOTP */;\r\nclass TotpMultiFactorAssertionImpl extends MultiFactorAssertionImpl {\r\n    constructor(otp, enrollmentId, secret) {\r\n        super(\"totp\" /* FactorId.TOTP */);\r\n        this.otp = otp;\r\n        this.enrollmentId = enrollmentId;\r\n        this.secret = secret;\r\n    }\r\n    /** @internal */\r\n    static _fromSecret(secret, otp) {\r\n        return new TotpMultiFactorAssertionImpl(otp, undefined, secret);\r\n    }\r\n    /** @internal */\r\n    static _fromEnrollmentId(enrollmentId, otp) {\r\n        return new TotpMultiFactorAssertionImpl(otp, enrollmentId);\r\n    }\r\n    /** @internal */\r\n    async _finalizeEnroll(auth, idToken, displayName) {\r\n        _assert(typeof this.secret !== 'undefined', auth, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        return finalizeEnrollTotpMfa(auth, {\r\n            idToken,\r\n            displayName,\r\n            totpVerificationInfo: this.secret._makeTotpVerificationInfo(this.otp)\r\n        });\r\n    }\r\n    /** @internal */\r\n    async _finalizeSignIn(auth, mfaPendingCredential) {\r\n        _assert(this.enrollmentId !== undefined && this.otp !== undefined, auth, \"argument-error\" /* AuthErrorCode.ARGUMENT_ERROR */);\r\n        const totpVerificationInfo = { verificationCode: this.otp };\r\n        return finalizeSignInTotpMfa(auth, {\r\n            mfaPendingCredential,\r\n            mfaEnrollmentId: this.enrollmentId,\r\n            totpVerificationInfo\r\n        });\r\n    }\r\n}\r\n/**\r\n * Provider for generating a {@link TotpMultiFactorAssertion}.\r\n *\r\n * Stores the shared secret key and other parameters to generate time-based OTPs.\r\n * Implements methods to retrieve the shared secret key and generate a QR code URL.\r\n * @public\r\n */\r\nclass TotpSecret {\r\n    // The public members are declared outside the constructor so the docs can be generated.\r\n    constructor(secretKey, hashingAlgorithm, codeLength, codeIntervalSeconds, enrollmentCompletionDeadline, sessionInfo, auth) {\r\n        this.sessionInfo = sessionInfo;\r\n        this.auth = auth;\r\n        this.secretKey = secretKey;\r\n        this.hashingAlgorithm = hashingAlgorithm;\r\n        this.codeLength = codeLength;\r\n        this.codeIntervalSeconds = codeIntervalSeconds;\r\n        this.enrollmentCompletionDeadline = enrollmentCompletionDeadline;\r\n    }\r\n    /** @internal */\r\n    static _fromStartTotpMfaEnrollmentResponse(response, auth) {\r\n        return new TotpSecret(response.totpSessionInfo.sharedSecretKey, response.totpSessionInfo.hashingAlgorithm, response.totpSessionInfo.verificationCodeLength, response.totpSessionInfo.periodSec, new Date(response.totpSessionInfo.finalizeEnrollmentTime).toUTCString(), response.totpSessionInfo.sessionInfo, auth);\r\n    }\r\n    /** @internal */\r\n    _makeTotpVerificationInfo(otp) {\r\n        return { sessionInfo: this.sessionInfo, verificationCode: otp };\r\n    }\r\n    /**\r\n     * Returns a QR code URL as described in\r\n     * https://github.com/google/google-authenticator/wiki/Key-Uri-Format\r\n     * This can be displayed to the user as a QR code to be scanned into a TOTP app like Google Authenticator.\r\n     * If the optional parameters are unspecified, an accountName of <userEmail> and issuer of <firebaseAppName> are used.\r\n     *\r\n     * @param accountName the name of the account/app along with a user identifier.\r\n     * @param issuer issuer of the TOTP (likely the app name).\r\n     * @returns A QR code URL string.\r\n     */\r\n    generateQrCodeUrl(accountName, issuer) {\r\n        var _a;\r\n        let useDefaults = false;\r\n        if (_isEmptyString(accountName) || _isEmptyString(issuer)) {\r\n            useDefaults = true;\r\n        }\r\n        if (useDefaults) {\r\n            if (_isEmptyString(accountName)) {\r\n                accountName = ((_a = this.auth.currentUser) === null || _a === void 0 ? void 0 : _a.email) || 'unknownuser';\r\n            }\r\n            if (_isEmptyString(issuer)) {\r\n                issuer = this.auth.name;\r\n            }\r\n        }\r\n        return `otpauth://totp/${issuer}:${accountName}?secret=${this.secretKey}&issuer=${issuer}&algorithm=${this.hashingAlgorithm}&digits=${this.codeLength}`;\r\n    }\r\n}\r\n/** @internal */\r\nfunction _isEmptyString(input) {\r\n    return typeof input === 'undefined' || (input === null || input === void 0 ? void 0 : input.length) === 0;\r\n}\n\n\n//# sourceMappingURL=totp-4c2d4e67.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@firebase/auth/dist/node-esm/totp-4c2d4e67.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/@firebase/component/dist/esm/index.esm2017.js":
/*!********************************************************************!*\
  !*** ./node_modules/@firebase/component/dist/esm/index.esm2017.js ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Component: () => (/* binding */ Component),\n/* harmony export */   ComponentContainer: () => (/* binding */ ComponentContainer),\n/* harmony export */   Provider: () => (/* binding */ Provider)\n/* harmony export */ });\n/* harmony import */ var _firebase_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @firebase/util */ \"(ssr)/./node_modules/@firebase/util/dist/node-esm/index.node.esm.js\");\n\n\n/**\r\n * Component for service name T, e.g. `auth`, `auth-internal`\r\n */\r\nclass Component {\r\n    /**\r\n     *\r\n     * @param name The public service name, e.g. app, auth, firestore, database\r\n     * @param instanceFactory Service factory responsible for creating the public interface\r\n     * @param type whether the service provided by the component is public or private\r\n     */\r\n    constructor(name, instanceFactory, type) {\r\n        this.name = name;\r\n        this.instanceFactory = instanceFactory;\r\n        this.type = type;\r\n        this.multipleInstances = false;\r\n        /**\r\n         * Properties to be added to the service namespace\r\n         */\r\n        this.serviceProps = {};\r\n        this.instantiationMode = \"LAZY\" /* InstantiationMode.LAZY */;\r\n        this.onInstanceCreated = null;\r\n    }\r\n    setInstantiationMode(mode) {\r\n        this.instantiationMode = mode;\r\n        return this;\r\n    }\r\n    setMultipleInstances(multipleInstances) {\r\n        this.multipleInstances = multipleInstances;\r\n        return this;\r\n    }\r\n    setServiceProps(props) {\r\n        this.serviceProps = props;\r\n        return this;\r\n    }\r\n    setInstanceCreatedCallback(callback) {\r\n        this.onInstanceCreated = callback;\r\n        return this;\r\n    }\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\nconst DEFAULT_ENTRY_NAME = '[DEFAULT]';\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * Provider for instance for service name T, e.g. 'auth', 'auth-internal'\r\n * NameServiceMapping[T] is an alias for the type of the instance\r\n */\r\nclass Provider {\r\n    constructor(name, container) {\r\n        this.name = name;\r\n        this.container = container;\r\n        this.component = null;\r\n        this.instances = new Map();\r\n        this.instancesDeferred = new Map();\r\n        this.instancesOptions = new Map();\r\n        this.onInitCallbacks = new Map();\r\n    }\r\n    /**\r\n     * @param identifier A provider can provide mulitple instances of a service\r\n     * if this.component.multipleInstances is true.\r\n     */\r\n    get(identifier) {\r\n        // if multipleInstances is not supported, use the default name\r\n        const normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);\r\n        if (!this.instancesDeferred.has(normalizedIdentifier)) {\r\n            const deferred = new _firebase_util__WEBPACK_IMPORTED_MODULE_0__.Deferred();\r\n            this.instancesDeferred.set(normalizedIdentifier, deferred);\r\n            if (this.isInitialized(normalizedIdentifier) ||\r\n                this.shouldAutoInitialize()) {\r\n                // initialize the service if it can be auto-initialized\r\n                try {\r\n                    const instance = this.getOrInitializeService({\r\n                        instanceIdentifier: normalizedIdentifier\r\n                    });\r\n                    if (instance) {\r\n                        deferred.resolve(instance);\r\n                    }\r\n                }\r\n                catch (e) {\r\n                    // when the instance factory throws an exception during get(), it should not cause\r\n                    // a fatal error. We just return the unresolved promise in this case.\r\n                }\r\n            }\r\n        }\r\n        return this.instancesDeferred.get(normalizedIdentifier).promise;\r\n    }\r\n    getImmediate(options) {\r\n        var _a;\r\n        // if multipleInstances is not supported, use the default name\r\n        const normalizedIdentifier = this.normalizeInstanceIdentifier(options === null || options === void 0 ? void 0 : options.identifier);\r\n        const optional = (_a = options === null || options === void 0 ? void 0 : options.optional) !== null && _a !== void 0 ? _a : false;\r\n        if (this.isInitialized(normalizedIdentifier) ||\r\n            this.shouldAutoInitialize()) {\r\n            try {\r\n                return this.getOrInitializeService({\r\n                    instanceIdentifier: normalizedIdentifier\r\n                });\r\n            }\r\n            catch (e) {\r\n                if (optional) {\r\n                    return null;\r\n                }\r\n                else {\r\n                    throw e;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            // In case a component is not initialized and should/can not be auto-initialized at the moment, return null if the optional flag is set, or throw\r\n            if (optional) {\r\n                return null;\r\n            }\r\n            else {\r\n                throw Error(`Service ${this.name} is not available`);\r\n            }\r\n        }\r\n    }\r\n    getComponent() {\r\n        return this.component;\r\n    }\r\n    setComponent(component) {\r\n        if (component.name !== this.name) {\r\n            throw Error(`Mismatching Component ${component.name} for Provider ${this.name}.`);\r\n        }\r\n        if (this.component) {\r\n            throw Error(`Component for ${this.name} has already been provided`);\r\n        }\r\n        this.component = component;\r\n        // return early without attempting to initialize the component if the component requires explicit initialization (calling `Provider.initialize()`)\r\n        if (!this.shouldAutoInitialize()) {\r\n            return;\r\n        }\r\n        // if the service is eager, initialize the default instance\r\n        if (isComponentEager(component)) {\r\n            try {\r\n                this.getOrInitializeService({ instanceIdentifier: DEFAULT_ENTRY_NAME });\r\n            }\r\n            catch (e) {\r\n                // when the instance factory for an eager Component throws an exception during the eager\r\n                // initialization, it should not cause a fatal error.\r\n                // TODO: Investigate if we need to make it configurable, because some component may want to cause\r\n                // a fatal error in this case?\r\n            }\r\n        }\r\n        // Create service instances for the pending promises and resolve them\r\n        // NOTE: if this.multipleInstances is false, only the default instance will be created\r\n        // and all promises with resolve with it regardless of the identifier.\r\n        for (const [instanceIdentifier, instanceDeferred] of this.instancesDeferred.entries()) {\r\n            const normalizedIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);\r\n            try {\r\n                // `getOrInitializeService()` should always return a valid instance since a component is guaranteed. use ! to make typescript happy.\r\n                const instance = this.getOrInitializeService({\r\n                    instanceIdentifier: normalizedIdentifier\r\n                });\r\n                instanceDeferred.resolve(instance);\r\n            }\r\n            catch (e) {\r\n                // when the instance factory throws an exception, it should not cause\r\n                // a fatal error. We just leave the promise unresolved.\r\n            }\r\n        }\r\n    }\r\n    clearInstance(identifier = DEFAULT_ENTRY_NAME) {\r\n        this.instancesDeferred.delete(identifier);\r\n        this.instancesOptions.delete(identifier);\r\n        this.instances.delete(identifier);\r\n    }\r\n    // app.delete() will call this method on every provider to delete the services\r\n    // TODO: should we mark the provider as deleted?\r\n    async delete() {\r\n        const services = Array.from(this.instances.values());\r\n        await Promise.all([\r\n            ...services\r\n                .filter(service => 'INTERNAL' in service) // legacy services\r\n                // eslint-disable-next-line @typescript-eslint/no-explicit-any\r\n                .map(service => service.INTERNAL.delete()),\r\n            ...services\r\n                .filter(service => '_delete' in service) // modularized services\r\n                // eslint-disable-next-line @typescript-eslint/no-explicit-any\r\n                .map(service => service._delete())\r\n        ]);\r\n    }\r\n    isComponentSet() {\r\n        return this.component != null;\r\n    }\r\n    isInitialized(identifier = DEFAULT_ENTRY_NAME) {\r\n        return this.instances.has(identifier);\r\n    }\r\n    getOptions(identifier = DEFAULT_ENTRY_NAME) {\r\n        return this.instancesOptions.get(identifier) || {};\r\n    }\r\n    initialize(opts = {}) {\r\n        const { options = {} } = opts;\r\n        const normalizedIdentifier = this.normalizeInstanceIdentifier(opts.instanceIdentifier);\r\n        if (this.isInitialized(normalizedIdentifier)) {\r\n            throw Error(`${this.name}(${normalizedIdentifier}) has already been initialized`);\r\n        }\r\n        if (!this.isComponentSet()) {\r\n            throw Error(`Component ${this.name} has not been registered yet`);\r\n        }\r\n        const instance = this.getOrInitializeService({\r\n            instanceIdentifier: normalizedIdentifier,\r\n            options\r\n        });\r\n        // resolve any pending promise waiting for the service instance\r\n        for (const [instanceIdentifier, instanceDeferred] of this.instancesDeferred.entries()) {\r\n            const normalizedDeferredIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);\r\n            if (normalizedIdentifier === normalizedDeferredIdentifier) {\r\n                instanceDeferred.resolve(instance);\r\n            }\r\n        }\r\n        return instance;\r\n    }\r\n    /**\r\n     *\r\n     * @param callback - a function that will be invoked  after the provider has been initialized by calling provider.initialize().\r\n     * The function is invoked SYNCHRONOUSLY, so it should not execute any longrunning tasks in order to not block the program.\r\n     *\r\n     * @param identifier An optional instance identifier\r\n     * @returns a function to unregister the callback\r\n     */\r\n    onInit(callback, identifier) {\r\n        var _a;\r\n        const normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);\r\n        const existingCallbacks = (_a = this.onInitCallbacks.get(normalizedIdentifier)) !== null && _a !== void 0 ? _a : new Set();\r\n        existingCallbacks.add(callback);\r\n        this.onInitCallbacks.set(normalizedIdentifier, existingCallbacks);\r\n        const existingInstance = this.instances.get(normalizedIdentifier);\r\n        if (existingInstance) {\r\n            callback(existingInstance, normalizedIdentifier);\r\n        }\r\n        return () => {\r\n            existingCallbacks.delete(callback);\r\n        };\r\n    }\r\n    /**\r\n     * Invoke onInit callbacks synchronously\r\n     * @param instance the service instance`\r\n     */\r\n    invokeOnInitCallbacks(instance, identifier) {\r\n        const callbacks = this.onInitCallbacks.get(identifier);\r\n        if (!callbacks) {\r\n            return;\r\n        }\r\n        for (const callback of callbacks) {\r\n            try {\r\n                callback(instance, identifier);\r\n            }\r\n            catch (_a) {\r\n                // ignore errors in the onInit callback\r\n            }\r\n        }\r\n    }\r\n    getOrInitializeService({ instanceIdentifier, options = {} }) {\r\n        let instance = this.instances.get(instanceIdentifier);\r\n        if (!instance && this.component) {\r\n            instance = this.component.instanceFactory(this.container, {\r\n                instanceIdentifier: normalizeIdentifierForFactory(instanceIdentifier),\r\n                options\r\n            });\r\n            this.instances.set(instanceIdentifier, instance);\r\n            this.instancesOptions.set(instanceIdentifier, options);\r\n            /**\r\n             * Invoke onInit listeners.\r\n             * Note this.component.onInstanceCreated is different, which is used by the component creator,\r\n             * while onInit listeners are registered by consumers of the provider.\r\n             */\r\n            this.invokeOnInitCallbacks(instance, instanceIdentifier);\r\n            /**\r\n             * Order is important\r\n             * onInstanceCreated() should be called after this.instances.set(instanceIdentifier, instance); which\r\n             * makes `isInitialized()` return true.\r\n             */\r\n            if (this.component.onInstanceCreated) {\r\n                try {\r\n                    this.component.onInstanceCreated(this.container, instanceIdentifier, instance);\r\n                }\r\n                catch (_a) {\r\n                    // ignore errors in the onInstanceCreatedCallback\r\n                }\r\n            }\r\n        }\r\n        return instance || null;\r\n    }\r\n    normalizeInstanceIdentifier(identifier = DEFAULT_ENTRY_NAME) {\r\n        if (this.component) {\r\n            return this.component.multipleInstances ? identifier : DEFAULT_ENTRY_NAME;\r\n        }\r\n        else {\r\n            return identifier; // assume multiple instances are supported before the component is provided.\r\n        }\r\n    }\r\n    shouldAutoInitialize() {\r\n        return (!!this.component &&\r\n            this.component.instantiationMode !== \"EXPLICIT\" /* InstantiationMode.EXPLICIT */);\r\n    }\r\n}\r\n// undefined should be passed to the service factory for the default instance\r\nfunction normalizeIdentifierForFactory(identifier) {\r\n    return identifier === DEFAULT_ENTRY_NAME ? undefined : identifier;\r\n}\r\nfunction isComponentEager(component) {\r\n    return component.instantiationMode === \"EAGER\" /* InstantiationMode.EAGER */;\r\n}\n\n/**\r\n * @license\r\n * Copyright 2019 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * ComponentContainer that provides Providers for service name T, e.g. `auth`, `auth-internal`\r\n */\r\nclass ComponentContainer {\r\n    constructor(name) {\r\n        this.name = name;\r\n        this.providers = new Map();\r\n    }\r\n    /**\r\n     *\r\n     * @param component Component being added\r\n     * @param overwrite When a component with the same name has already been registered,\r\n     * if overwrite is true: overwrite the existing component with the new component and create a new\r\n     * provider with the new component. It can be useful in tests where you want to use different mocks\r\n     * for different tests.\r\n     * if overwrite is false: throw an exception\r\n     */\r\n    addComponent(component) {\r\n        const provider = this.getProvider(component.name);\r\n        if (provider.isComponentSet()) {\r\n            throw new Error(`Component ${component.name} has already been registered with ${this.name}`);\r\n        }\r\n        provider.setComponent(component);\r\n    }\r\n    addOrOverwriteComponent(component) {\r\n        const provider = this.getProvider(component.name);\r\n        if (provider.isComponentSet()) {\r\n            // delete the existing provider from the container, so we can register the new component\r\n            this.providers.delete(component.name);\r\n        }\r\n        this.addComponent(component);\r\n    }\r\n    /**\r\n     * getProvider provides a type safe interface where it can only be called with a field name\r\n     * present in NameServiceMapping interface.\r\n     *\r\n     * Firebase SDKs providing services should extend NameServiceMapping interface to register\r\n     * themselves.\r\n     */\r\n    getProvider(name) {\r\n        if (this.providers.has(name)) {\r\n            return this.providers.get(name);\r\n        }\r\n        // create a Provider for a service that hasn't registered with Firebase\r\n        const provider = new Provider(name, this);\r\n        this.providers.set(name, provider);\r\n        return provider;\r\n    }\r\n    getProviders() {\r\n        return Array.from(this.providers.values());\r\n    }\r\n}\n\n\n//# sourceMappingURL=index.esm2017.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@firebase/component/dist/esm/index.esm2017.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/@firebase/logger/dist/esm/index.esm2017.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@firebase/logger/dist/esm/index.esm2017.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LogLevel: () => (/* binding */ LogLevel),\n/* harmony export */   Logger: () => (/* binding */ Logger),\n/* harmony export */   setLogLevel: () => (/* binding */ setLogLevel),\n/* harmony export */   setUserLogHandler: () => (/* binding */ setUserLogHandler)\n/* harmony export */ });\n/**\r\n * @license\r\n * Copyright 2017 Google LLC\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n *   http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n */\r\n/**\r\n * A container for all of the Logger instances\r\n */\r\nconst instances = [];\r\n/**\r\n * The JS SDK supports 5 log levels and also allows a user the ability to\r\n * silence the logs altogether.\r\n *\r\n * The order is a follows:\r\n * DEBUG < VERBOSE < INFO < WARN < ERROR\r\n *\r\n * All of the log types above the current log level will be captured (i.e. if\r\n * you set the log level to `INFO`, errors will still be logged, but `DEBUG` and\r\n * `VERBOSE` logs will not)\r\n */\r\nvar LogLevel;\r\n(function (LogLevel) {\r\n    LogLevel[LogLevel[\"DEBUG\"] = 0] = \"DEBUG\";\r\n    LogLevel[LogLevel[\"VERBOSE\"] = 1] = \"VERBOSE\";\r\n    LogLevel[LogLevel[\"INFO\"] = 2] = \"INFO\";\r\n    LogLevel[LogLevel[\"WARN\"] = 3] = \"WARN\";\r\n    LogLevel[LogLevel[\"ERROR\"] = 4] = \"ERROR\";\r\n    LogLevel[LogLevel[\"SILENT\"] = 5] = \"SILENT\";\r\n})(LogLevel || (LogLevel = {}));\r\nconst levelStringToEnum = {\r\n    'debug': LogLevel.DEBUG,\r\n    'verbose': LogLevel.VERBOSE,\r\n    'info': LogLevel.INFO,\r\n    'warn': LogLevel.WARN,\r\n    'error': LogLevel.ERROR,\r\n    'silent': LogLevel.SILENT\r\n};\r\n/**\r\n * The default log level\r\n */\r\nconst defaultLogLevel = LogLevel.INFO;\r\n/**\r\n * By default, `console.debug` is not displayed in the developer console (in\r\n * chrome). To avoid forcing users to have to opt-in to these logs twice\r\n * (i.e. once for firebase, and once in the console), we are sending `DEBUG`\r\n * logs to the `console.log` function.\r\n */\r\nconst ConsoleMethod = {\r\n    [LogLevel.DEBUG]: 'log',\r\n    [LogLevel.VERBOSE]: 'log',\r\n    [LogLevel.INFO]: 'info',\r\n    [LogLevel.WARN]: 'warn',\r\n    [LogLevel.ERROR]: 'error'\r\n};\r\n/**\r\n * The default log handler will forward DEBUG, VERBOSE, INFO, WARN, and ERROR\r\n * messages on to their corresponding console counterparts (if the log method\r\n * is supported by the current log level)\r\n */\r\nconst defaultLogHandler = (instance, logType, ...args) => {\r\n    if (logType < instance.logLevel) {\r\n        return;\r\n    }\r\n    const now = new Date().toISOString();\r\n    const method = ConsoleMethod[logType];\r\n    if (method) {\r\n        console[method](`[${now}]  ${instance.name}:`, ...args);\r\n    }\r\n    else {\r\n        throw new Error(`Attempted to log a message with an invalid logType (value: ${logType})`);\r\n    }\r\n};\r\nclass Logger {\r\n    /**\r\n     * Gives you an instance of a Logger to capture messages according to\r\n     * Firebase's logging scheme.\r\n     *\r\n     * @param name The name that the logs will be associated with\r\n     */\r\n    constructor(name) {\r\n        this.name = name;\r\n        /**\r\n         * The log level of the given Logger instance.\r\n         */\r\n        this._logLevel = defaultLogLevel;\r\n        /**\r\n         * The main (internal) log handler for the Logger instance.\r\n         * Can be set to a new function in internal package code but not by user.\r\n         */\r\n        this._logHandler = defaultLogHandler;\r\n        /**\r\n         * The optional, additional, user-defined log handler for the Logger instance.\r\n         */\r\n        this._userLogHandler = null;\r\n        /**\r\n         * Capture the current instance for later use\r\n         */\r\n        instances.push(this);\r\n    }\r\n    get logLevel() {\r\n        return this._logLevel;\r\n    }\r\n    set logLevel(val) {\r\n        if (!(val in LogLevel)) {\r\n            throw new TypeError(`Invalid value \"${val}\" assigned to \\`logLevel\\``);\r\n        }\r\n        this._logLevel = val;\r\n    }\r\n    // Workaround for setter/getter having to be the same type.\r\n    setLogLevel(val) {\r\n        this._logLevel = typeof val === 'string' ? levelStringToEnum[val] : val;\r\n    }\r\n    get logHandler() {\r\n        return this._logHandler;\r\n    }\r\n    set logHandler(val) {\r\n        if (typeof val !== 'function') {\r\n            throw new TypeError('Value assigned to `logHandler` must be a function');\r\n        }\r\n        this._logHandler = val;\r\n    }\r\n    get userLogHandler() {\r\n        return this._userLogHandler;\r\n    }\r\n    set userLogHandler(val) {\r\n        this._userLogHandler = val;\r\n    }\r\n    /**\r\n     * The functions below are all based on the `console` interface\r\n     */\r\n    debug(...args) {\r\n        this._userLogHandler && this._userLogHandler(this, LogLevel.DEBUG, ...args);\r\n        this._logHandler(this, LogLevel.DEBUG, ...args);\r\n    }\r\n    log(...args) {\r\n        this._userLogHandler &&\r\n            this._userLogHandler(this, LogLevel.VERBOSE, ...args);\r\n        this._logHandler(this, LogLevel.VERBOSE, ...args);\r\n    }\r\n    info(...args) {\r\n        this._userLogHandler && this._userLogHandler(this, LogLevel.INFO, ...args);\r\n        this._logHandler(this, LogLevel.INFO, ...args);\r\n    }\r\n    warn(...args) {\r\n        this._userLogHandler && this._userLogHandler(this, LogLevel.WARN, ...args);\r\n        this._logHandler(this, LogLevel.WARN, ...args);\r\n    }\r\n    error(...args) {\r\n        this._userLogHandler && this._userLogHandler(this, LogLevel.ERROR, ...args);\r\n        this._logHandler(this, LogLevel.ERROR, ...args);\r\n    }\r\n}\r\nfunction setLogLevel(level) {\r\n    instances.forEach(inst => {\r\n        inst.setLogLevel(level);\r\n    });\r\n}\r\nfunction setUserLogHandler(logCallback, options) {\r\n    for (const instance of instances) {\r\n        let customLogLevel = null;\r\n        if (options && options.level) {\r\n            customLogLevel = levelStringToEnum[options.level];\r\n        }\r\n        if (logCallback === null) {\r\n            instance.userLogHandler = null;\r\n        }\r\n        else {\r\n            instance.userLogHandler = (instance, level, ...args) => {\r\n                const message = args\r\n                    .map(arg => {\r\n                    if (arg == null) {\r\n                        return null;\r\n                    }\r\n                    else if (typeof arg === 'string') {\r\n                        return arg;\r\n                    }\r\n                    else if (typeof arg === 'number' || typeof arg === 'boolean') {\r\n                        return arg.toString();\r\n                    }\r\n                    else if (arg instanceof Error) {\r\n                        return arg.message;\r\n                    }\r\n                    else {\r\n                        try {\r\n                            return JSON.stringify(arg);\r\n                        }\r\n                        catch (ignored) {\r\n                            return null;\r\n                        }\r\n                    }\r\n                })\r\n                    .filter(arg => arg)\r\n                    .join(' ');\r\n                if (level >= (customLogLevel !== null && customLogLevel !== void 0 ? customLogLevel : instance.logLevel)) {\r\n                    logCallback({\r\n                        level: LogLevel[level].toLowerCase(),\r\n                        message,\r\n                        args,\r\n                        type: instance.name\r\n                    });\r\n                }\r\n            };\r\n        }\r\n    }\r\n}\n\n\n//# sourceMappingURL=index.esm2017.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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