"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/lru-cache";
exports.ids = ["vendor-chunks/lru-cache"];
exports.modules = {

/***/ "(action-browser)/./node_modules/lru-cache/dist/cjs/index-cjs.js":
/*!******************************************************!*\
  !*** ./node_modules/lru-cache/dist/cjs/index-cjs.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\nvar __importDefault = (void 0) && (void 0).__importDefault || function(mod) {\n    return mod && mod.__esModule ? mod : {\n        \"default\": mod\n    };\n};\nconst index_js_1 = __importDefault(__webpack_require__(/*! ./index.js */ \"(action-browser)/./node_modules/lru-cache/dist/cjs/index.js\"));\nmodule.exports = Object.assign(index_js_1.default, {\n    default: index_js_1.default,\n    LRUCache: index_js_1.default\n}); //# sourceMappingURL=index-cjs.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFjdGlvbi1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9scnUtY2FjaGUvZGlzdC9janMvaW5kZXgtY2pzLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2IsSUFBSUEsa0JBQWtCLENBQUMsTUFBRyxLQUFLLE9BQUcsRUFBRUEsZUFBZSxJQUFLLFNBQVVDLEdBQUc7SUFDakUsT0FBTyxPQUFRQSxJQUFJQyxVQUFVLEdBQUlELE1BQU07UUFBRSxXQUFXQTtJQUFJO0FBQzVEO0FBQ0EsTUFBTUUsYUFBYUgsZ0JBQWdCSSxtQkFBT0EsQ0FBQywrRUFBWTtBQUN2REMsT0FBT0MsT0FBTyxHQUFHQyxPQUFPQyxNQUFNLENBQUNMLFdBQVdNLE9BQU8sRUFBRTtJQUFFQSxTQUFTTixXQUFXTSxPQUFPO0lBQUVDLFVBQVVQLFdBQVdNLE9BQU87QUFBQyxJQUMvRyxxQ0FBcUMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9teS1kcml2ZS8uL25vZGVfbW9kdWxlcy9scnUtY2FjaGUvZGlzdC9janMvaW5kZXgtY2pzLmpzP2Q5ZjQiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgX19pbXBvcnREZWZhdWx0ID0gKHRoaXMgJiYgdGhpcy5fX2ltcG9ydERlZmF1bHQpIHx8IGZ1bmN0aW9uIChtb2QpIHtcbiAgICByZXR1cm4gKG1vZCAmJiBtb2QuX19lc01vZHVsZSkgPyBtb2QgOiB7IFwiZGVmYXVsdFwiOiBtb2QgfTtcbn07XG5jb25zdCBpbmRleF9qc18xID0gX19pbXBvcnREZWZhdWx0KHJlcXVpcmUoXCIuL2luZGV4LmpzXCIpKTtcbm1vZHVsZS5leHBvcnRzID0gT2JqZWN0LmFzc2lnbihpbmRleF9qc18xLmRlZmF1bHQsIHsgZGVmYXVsdDogaW5kZXhfanNfMS5kZWZhdWx0LCBMUlVDYWNoZTogaW5kZXhfanNfMS5kZWZhdWx0IH0pO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9aW5kZXgtY2pzLmpzLm1hcCJdLCJuYW1lcyI6WyJfX2ltcG9ydERlZmF1bHQiLCJtb2QiLCJfX2VzTW9kdWxlIiwiaW5kZXhfanNfMSIsInJlcXVpcmUiLCJtb2R1bGUiLCJleHBvcnRzIiwiT2JqZWN0IiwiYXNzaWduIiwiZGVmYXVsdCIsIkxSVUNhY2hlIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/lru-cache/dist/cjs/index-cjs.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/lru-cache/dist/cjs/index.js":
/*!**************************************************!*\
  !*** ./node_modules/lru-cache/dist/cjs/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports) => {

eval("\n/**\n * @module LRUCache\n */ Object.defineProperty(exports, \"__esModule\", ({\n    value: true\n}));\nexports.LRUCache = void 0;\nconst perf = typeof performance === \"object\" && performance && typeof performance.now === \"function\" ? performance : Date;\nconst warned = new Set();\nconst emitWarning = (msg, type, code, fn)=>{\n    typeof process === \"object\" && process && typeof process.emitWarning === \"function\" ? process.emitWarning(msg, type, code, fn) : console.error(`[${code}] ${type}: ${msg}`);\n};\nconst shouldWarn = (code)=>!warned.has(code);\nconst TYPE = Symbol(\"type\");\nconst isPosInt = (n)=>n && n === Math.floor(n) && n > 0 && isFinite(n);\n/* c8 ignore start */ // This is a little bit ridiculous, tbh.\n// The maximum array length is 2^32-1 or thereabouts on most JS impls.\n// And well before that point, you're caching the entire world, I mean,\n// that's ~32GB of just integers for the next/prev links, plus whatever\n// else to hold that many keys and values.  Just filling the memory with\n// zeroes at init time is brutal when you get that big.\n// But why not be complete?\n// Maybe in the future, these limits will have expanded.\nconst getUintArray = (max)=>!isPosInt(max) ? null : max <= Math.pow(2, 8) ? Uint8Array : max <= Math.pow(2, 16) ? Uint16Array : max <= Math.pow(2, 32) ? Uint32Array : max <= Number.MAX_SAFE_INTEGER ? ZeroArray : null;\n/* c8 ignore stop */ class ZeroArray extends Array {\n    constructor(size){\n        super(size);\n        this.fill(0);\n    }\n}\nclass Stack {\n    // private constructor\n    static #constructing = false;\n    static create(max) {\n        const HeapCls = getUintArray(max);\n        if (!HeapCls) return [];\n        Stack.#constructing = true;\n        const s = new Stack(max, HeapCls);\n        Stack.#constructing = false;\n        return s;\n    }\n    constructor(max, HeapCls){\n        /* c8 ignore start */ if (!Stack.#constructing) {\n            throw new TypeError(\"instantiate Stack using Stack.create(n)\");\n        }\n        /* c8 ignore stop */ this.heap = new HeapCls(max);\n        this.length = 0;\n    }\n    push(n) {\n        this.heap[this.length++] = n;\n    }\n    pop() {\n        return this.heap[--this.length];\n    }\n}\n/**\n * Default export, the thing you're using this module to get.\n *\n * All properties from the options object (with the exception of\n * {@link OptionsBase.max} and {@link OptionsBase.maxSize}) are added as\n * normal public members. (`max` and `maxBase` are read-only getters.)\n * Changing any of these will alter the defaults for subsequent method calls,\n * but is otherwise safe.\n */ class LRUCache {\n    // properties coming in from the options of these, only max and maxSize\n    // really *need* to be protected. The rest can be modified, as they just\n    // set defaults for various methods.\n    #max;\n    #maxSize;\n    #dispose;\n    #disposeAfter;\n    #fetchMethod;\n    // computed properties\n    #size;\n    #calculatedSize;\n    #keyMap;\n    #keyList;\n    #valList;\n    #next;\n    #prev;\n    #head;\n    #tail;\n    #free;\n    #disposed;\n    #sizes;\n    #starts;\n    #ttls;\n    #hasDispose;\n    #hasFetchMethod;\n    #hasDisposeAfter;\n    /**\n     * Do not call this method unless you need to inspect the\n     * inner workings of the cache.  If anything returned by this\n     * object is modified in any way, strange breakage may occur.\n     *\n     * These fields are private for a reason!\n     *\n     * @internal\n     */ static unsafeExposeInternals(c) {\n        return {\n            // properties\n            starts: c.#starts,\n            ttls: c.#ttls,\n            sizes: c.#sizes,\n            keyMap: c.#keyMap,\n            keyList: c.#keyList,\n            valList: c.#valList,\n            next: c.#next,\n            prev: c.#prev,\n            get head () {\n                return c.#head;\n            },\n            get tail () {\n                return c.#tail;\n            },\n            free: c.#free,\n            // methods\n            isBackgroundFetch: (p)=>c.#isBackgroundFetch(p),\n            backgroundFetch: (k, index, options, context)=>c.#backgroundFetch(k, index, options, context),\n            moveToTail: (index)=>c.#moveToTail(index),\n            indexes: (options)=>c.#indexes(options),\n            rindexes: (options)=>c.#rindexes(options),\n            isStale: (index)=>c.#isStale(index)\n        };\n    }\n    // Protected read-only members\n    /**\n     * {@link LRUCache.OptionsBase.max} (read-only)\n     */ get max() {\n        return this.#max;\n    }\n    /**\n     * {@link LRUCache.OptionsBase.maxSize} (read-only)\n     */ get maxSize() {\n        return this.#maxSize;\n    }\n    /**\n     * The total computed size of items in the cache (read-only)\n     */ get calculatedSize() {\n        return this.#calculatedSize;\n    }\n    /**\n     * The number of items stored in the cache (read-only)\n     */ get size() {\n        return this.#size;\n    }\n    /**\n     * {@link LRUCache.OptionsBase.fetchMethod} (read-only)\n     */ get fetchMethod() {\n        return this.#fetchMethod;\n    }\n    /**\n     * {@link LRUCache.OptionsBase.dispose} (read-only)\n     */ get dispose() {\n        return this.#dispose;\n    }\n    /**\n     * {@link LRUCache.OptionsBase.disposeAfter} (read-only)\n     */ get disposeAfter() {\n        return this.#disposeAfter;\n    }\n    constructor(options){\n        // conditionally set private methods related to TTL\n        this.#updateItemAge = ()=>{};\n        this.#statusTTL = ()=>{};\n        this.#setItemTTL = ()=>{};\n        /* c8 ignore stop */ this.#isStale = ()=>false;\n        this.#removeItemSize = (_i)=>{};\n        this.#addItemSize = (_i, _s, _st)=>{};\n        this.#requireSize = (_k, _v, size, sizeCalculation)=>{\n            if (size || sizeCalculation) {\n                throw new TypeError(\"cannot set size without setting maxSize or maxEntrySize on cache\");\n            }\n            return 0;\n        };\n        const { max = 0, ttl, ttlResolution = 1, ttlAutopurge, updateAgeOnGet, updateAgeOnHas, allowStale, dispose, disposeAfter, noDisposeOnSet, noUpdateTTL, maxSize = 0, maxEntrySize = 0, sizeCalculation, fetchMethod, noDeleteOnFetchRejection, noDeleteOnStaleGet, allowStaleOnFetchRejection, allowStaleOnFetchAbort, ignoreFetchAbort } = options;\n        if (max !== 0 && !isPosInt(max)) {\n            throw new TypeError(\"max option must be a nonnegative integer\");\n        }\n        const UintArray = max ? getUintArray(max) : Array;\n        if (!UintArray) {\n            throw new Error(\"invalid max value: \" + max);\n        }\n        this.#max = max;\n        this.#maxSize = maxSize;\n        this.maxEntrySize = maxEntrySize || this.#maxSize;\n        this.sizeCalculation = sizeCalculation;\n        if (this.sizeCalculation) {\n            if (!this.#maxSize && !this.maxEntrySize) {\n                throw new TypeError(\"cannot set sizeCalculation without setting maxSize or maxEntrySize\");\n            }\n            if (typeof this.sizeCalculation !== \"function\") {\n                throw new TypeError(\"sizeCalculation set to non-function\");\n            }\n        }\n        if (fetchMethod !== undefined && typeof fetchMethod !== \"function\") {\n            throw new TypeError(\"fetchMethod must be a function if specified\");\n        }\n        this.#fetchMethod = fetchMethod;\n        this.#hasFetchMethod = !!fetchMethod;\n        this.#keyMap = new Map();\n        this.#keyList = new Array(max).fill(undefined);\n        this.#valList = new Array(max).fill(undefined);\n        this.#next = new UintArray(max);\n        this.#prev = new UintArray(max);\n        this.#head = 0;\n        this.#tail = 0;\n        this.#free = Stack.create(max);\n        this.#size = 0;\n        this.#calculatedSize = 0;\n        if (typeof dispose === \"function\") {\n            this.#dispose = dispose;\n        }\n        if (typeof disposeAfter === \"function\") {\n            this.#disposeAfter = disposeAfter;\n            this.#disposed = [];\n        } else {\n            this.#disposeAfter = undefined;\n            this.#disposed = undefined;\n        }\n        this.#hasDispose = !!this.#dispose;\n        this.#hasDisposeAfter = !!this.#disposeAfter;\n        this.noDisposeOnSet = !!noDisposeOnSet;\n        this.noUpdateTTL = !!noUpdateTTL;\n        this.noDeleteOnFetchRejection = !!noDeleteOnFetchRejection;\n        this.allowStaleOnFetchRejection = !!allowStaleOnFetchRejection;\n        this.allowStaleOnFetchAbort = !!allowStaleOnFetchAbort;\n        this.ignoreFetchAbort = !!ignoreFetchAbort;\n        // NB: maxEntrySize is set to maxSize if it's set\n        if (this.maxEntrySize !== 0) {\n            if (this.#maxSize !== 0) {\n                if (!isPosInt(this.#maxSize)) {\n                    throw new TypeError(\"maxSize must be a positive integer if specified\");\n                }\n            }\n            if (!isPosInt(this.maxEntrySize)) {\n                throw new TypeError(\"maxEntrySize must be a positive integer if specified\");\n            }\n            this.#initializeSizeTracking();\n        }\n        this.allowStale = !!allowStale;\n        this.noDeleteOnStaleGet = !!noDeleteOnStaleGet;\n        this.updateAgeOnGet = !!updateAgeOnGet;\n        this.updateAgeOnHas = !!updateAgeOnHas;\n        this.ttlResolution = isPosInt(ttlResolution) || ttlResolution === 0 ? ttlResolution : 1;\n        this.ttlAutopurge = !!ttlAutopurge;\n        this.ttl = ttl || 0;\n        if (this.ttl) {\n            if (!isPosInt(this.ttl)) {\n                throw new TypeError(\"ttl must be a positive integer if specified\");\n            }\n            this.#initializeTTLTracking();\n        }\n        // do not allow completely unbounded caches\n        if (this.#max === 0 && this.ttl === 0 && this.#maxSize === 0) {\n            throw new TypeError(\"At least one of max, maxSize, or ttl is required\");\n        }\n        if (!this.ttlAutopurge && !this.#max && !this.#maxSize) {\n            const code = \"LRU_CACHE_UNBOUNDED\";\n            if (shouldWarn(code)) {\n                warned.add(code);\n                const msg = \"TTL caching without ttlAutopurge, max, or maxSize can \" + \"result in unbounded memory consumption.\";\n                emitWarning(msg, \"UnboundedCacheWarning\", code, LRUCache);\n            }\n        }\n    }\n    /**\n     * Return the remaining TTL time for a given entry key\n     */ getRemainingTTL(key) {\n        return this.#keyMap.has(key) ? Infinity : 0;\n    }\n    #initializeTTLTracking() {\n        const ttls = new ZeroArray(this.#max);\n        const starts = new ZeroArray(this.#max);\n        this.#ttls = ttls;\n        this.#starts = starts;\n        this.#setItemTTL = (index, ttl, start = perf.now())=>{\n            starts[index] = ttl !== 0 ? start : 0;\n            ttls[index] = ttl;\n            if (ttl !== 0 && this.ttlAutopurge) {\n                const t = setTimeout(()=>{\n                    if (this.#isStale(index)) {\n                        this.delete(this.#keyList[index]);\n                    }\n                }, ttl + 1);\n                // unref() not supported on all platforms\n                /* c8 ignore start */ if (t.unref) {\n                    t.unref();\n                }\n            /* c8 ignore stop */ }\n        };\n        this.#updateItemAge = (index)=>{\n            starts[index] = ttls[index] !== 0 ? perf.now() : 0;\n        };\n        this.#statusTTL = (status, index)=>{\n            if (ttls[index]) {\n                const ttl = ttls[index];\n                const start = starts[index];\n                status.ttl = ttl;\n                status.start = start;\n                status.now = cachedNow || getNow();\n                status.remainingTTL = status.now + ttl - start;\n            }\n        };\n        // debounce calls to perf.now() to 1s so we're not hitting\n        // that costly call repeatedly.\n        let cachedNow = 0;\n        const getNow = ()=>{\n            const n = perf.now();\n            if (this.ttlResolution > 0) {\n                cachedNow = n;\n                const t = setTimeout(()=>cachedNow = 0, this.ttlResolution);\n                // not available on all platforms\n                /* c8 ignore start */ if (t.unref) {\n                    t.unref();\n                }\n            /* c8 ignore stop */ }\n            return n;\n        };\n        this.getRemainingTTL = (key)=>{\n            const index = this.#keyMap.get(key);\n            if (index === undefined) {\n                return 0;\n            }\n            return ttls[index] === 0 || starts[index] === 0 ? Infinity : starts[index] + ttls[index] - (cachedNow || getNow());\n        };\n        this.#isStale = (index)=>{\n            return ttls[index] !== 0 && starts[index] !== 0 && (cachedNow || getNow()) - starts[index] > ttls[index];\n        };\n    }\n    #updateItemAge;\n    #statusTTL;\n    #setItemTTL;\n    #isStale;\n    #initializeSizeTracking() {\n        const sizes = new ZeroArray(this.#max);\n        this.#calculatedSize = 0;\n        this.#sizes = sizes;\n        this.#removeItemSize = (index)=>{\n            this.#calculatedSize -= sizes[index];\n            sizes[index] = 0;\n        };\n        this.#requireSize = (k, v, size, sizeCalculation)=>{\n            // provisionally accept background fetches.\n            // actual value size will be checked when they return.\n            if (this.#isBackgroundFetch(v)) {\n                return 0;\n            }\n            if (!isPosInt(size)) {\n                if (sizeCalculation) {\n                    if (typeof sizeCalculation !== \"function\") {\n                        throw new TypeError(\"sizeCalculation must be a function\");\n                    }\n                    size = sizeCalculation(v, k);\n                    if (!isPosInt(size)) {\n                        throw new TypeError(\"sizeCalculation return invalid (expect positive integer)\");\n                    }\n                } else {\n                    throw new TypeError(\"invalid size value (must be positive integer). \" + \"When maxSize or maxEntrySize is used, sizeCalculation \" + \"or size must be set.\");\n                }\n            }\n            return size;\n        };\n        this.#addItemSize = (index, size, status)=>{\n            sizes[index] = size;\n            if (this.#maxSize) {\n                const maxSize = this.#maxSize - sizes[index];\n                while(this.#calculatedSize > maxSize){\n                    this.#evict(true);\n                }\n            }\n            this.#calculatedSize += sizes[index];\n            if (status) {\n                status.entrySize = size;\n                status.totalCalculatedSize = this.#calculatedSize;\n            }\n        };\n    }\n    #removeItemSize;\n    #addItemSize;\n    #requireSize;\n    *#indexes({ allowStale = this.allowStale } = {}) {\n        if (this.#size) {\n            for(let i = this.#tail; true;){\n                if (!this.#isValidIndex(i)) {\n                    break;\n                }\n                if (allowStale || !this.#isStale(i)) {\n                    yield i;\n                }\n                if (i === this.#head) {\n                    break;\n                } else {\n                    i = this.#prev[i];\n                }\n            }\n        }\n    }\n    *#rindexes({ allowStale = this.allowStale } = {}) {\n        if (this.#size) {\n            for(let i = this.#head; true;){\n                if (!this.#isValidIndex(i)) {\n                    break;\n                }\n                if (allowStale || !this.#isStale(i)) {\n                    yield i;\n                }\n                if (i === this.#tail) {\n                    break;\n                } else {\n                    i = this.#next[i];\n                }\n            }\n        }\n    }\n    #isValidIndex(index) {\n        return index !== undefined && this.#keyMap.get(this.#keyList[index]) === index;\n    }\n    /**\n     * Return a generator yielding `[key, value]` pairs,\n     * in order from most recently used to least recently used.\n     */ *entries() {\n        for (const i of this.#indexes()){\n            if (this.#valList[i] !== undefined && this.#keyList[i] !== undefined && !this.#isBackgroundFetch(this.#valList[i])) {\n                yield [\n                    this.#keyList[i],\n                    this.#valList[i]\n                ];\n            }\n        }\n    }\n    /**\n     * Inverse order version of {@link LRUCache.entries}\n     *\n     * Return a generator yielding `[key, value]` pairs,\n     * in order from least recently used to most recently used.\n     */ *rentries() {\n        for (const i of this.#rindexes()){\n            if (this.#valList[i] !== undefined && this.#keyList[i] !== undefined && !this.#isBackgroundFetch(this.#valList[i])) {\n                yield [\n                    this.#keyList[i],\n                    this.#valList[i]\n                ];\n            }\n        }\n    }\n    /**\n     * Return a generator yielding the keys in the cache,\n     * in order from most recently used to least recently used.\n     */ *keys() {\n        for (const i of this.#indexes()){\n            const k = this.#keyList[i];\n            if (k !== undefined && !this.#isBackgroundFetch(this.#valList[i])) {\n                yield k;\n            }\n        }\n    }\n    /**\n     * Inverse order version of {@link LRUCache.keys}\n     *\n     * Return a generator yielding the keys in the cache,\n     * in order from least recently used to most recently used.\n     */ *rkeys() {\n        for (const i of this.#rindexes()){\n            const k = this.#keyList[i];\n            if (k !== undefined && !this.#isBackgroundFetch(this.#valList[i])) {\n                yield k;\n            }\n        }\n    }\n    /**\n     * Return a generator yielding the values in the cache,\n     * in order from most recently used to least recently used.\n     */ *values() {\n        for (const i of this.#indexes()){\n            const v = this.#valList[i];\n            if (v !== undefined && !this.#isBackgroundFetch(this.#valList[i])) {\n                yield this.#valList[i];\n            }\n        }\n    }\n    /**\n     * Inverse order version of {@link LRUCache.values}\n     *\n     * Return a generator yielding the values in the cache,\n     * in order from least recently used to most recently used.\n     */ *rvalues() {\n        for (const i of this.#rindexes()){\n            const v = this.#valList[i];\n            if (v !== undefined && !this.#isBackgroundFetch(this.#valList[i])) {\n                yield this.#valList[i];\n            }\n        }\n    }\n    /**\n     * Iterating over the cache itself yields the same results as\n     * {@link LRUCache.entries}\n     */ [Symbol.iterator]() {\n        return this.entries();\n    }\n    /**\n     * Find a value for which the supplied fn method returns a truthy value,\n     * similar to Array.find().  fn is called as fn(value, key, cache).\n     */ find(fn, getOptions = {}) {\n        for (const i of this.#indexes()){\n            const v = this.#valList[i];\n            const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;\n            if (value === undefined) continue;\n            if (fn(value, this.#keyList[i], this)) {\n                return this.get(this.#keyList[i], getOptions);\n            }\n        }\n    }\n    /**\n     * Call the supplied function on each item in the cache, in order from\n     * most recently used to least recently used.  fn is called as\n     * fn(value, key, cache).  Does not update age or recenty of use.\n     * Does not iterate over stale values.\n     */ forEach(fn, thisp = this) {\n        for (const i of this.#indexes()){\n            const v = this.#valList[i];\n            const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;\n            if (value === undefined) continue;\n            fn.call(thisp, value, this.#keyList[i], this);\n        }\n    }\n    /**\n     * The same as {@link LRUCache.forEach} but items are iterated over in\n     * reverse order.  (ie, less recently used items are iterated over first.)\n     */ rforEach(fn, thisp = this) {\n        for (const i of this.#rindexes()){\n            const v = this.#valList[i];\n            const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;\n            if (value === undefined) continue;\n            fn.call(thisp, value, this.#keyList[i], this);\n        }\n    }\n    /**\n     * Delete any stale entries. Returns true if anything was removed,\n     * false otherwise.\n     */ purgeStale() {\n        let deleted = false;\n        for (const i of this.#rindexes({\n            allowStale: true\n        })){\n            if (this.#isStale(i)) {\n                this.delete(this.#keyList[i]);\n                deleted = true;\n            }\n        }\n        return deleted;\n    }\n    /**\n     * Return an array of [key, {@link LRUCache.Entry}] tuples which can be\n     * passed to cache.load()\n     */ dump() {\n        const arr = [];\n        for (const i of this.#indexes({\n            allowStale: true\n        })){\n            const key = this.#keyList[i];\n            const v = this.#valList[i];\n            const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;\n            if (value === undefined || key === undefined) continue;\n            const entry = {\n                value\n            };\n            if (this.#ttls && this.#starts) {\n                entry.ttl = this.#ttls[i];\n                // always dump the start relative to a portable timestamp\n                // it's ok for this to be a bit slow, it's a rare operation.\n                const age = perf.now() - this.#starts[i];\n                entry.start = Math.floor(Date.now() - age);\n            }\n            if (this.#sizes) {\n                entry.size = this.#sizes[i];\n            }\n            arr.unshift([\n                key,\n                entry\n            ]);\n        }\n        return arr;\n    }\n    /**\n     * Reset the cache and load in the items in entries in the order listed.\n     * Note that the shape of the resulting cache may be different if the\n     * same options are not used in both caches.\n     */ load(arr) {\n        this.clear();\n        for (const [key, entry] of arr){\n            if (entry.start) {\n                // entry.start is a portable timestamp, but we may be using\n                // node's performance.now(), so calculate the offset, so that\n                // we get the intended remaining TTL, no matter how long it's\n                // been on ice.\n                //\n                // it's ok for this to be a bit slow, it's a rare operation.\n                const age = Date.now() - entry.start;\n                entry.start = perf.now() - age;\n            }\n            this.set(key, entry.value, entry);\n        }\n    }\n    /**\n     * Add a value to the cache.\n     */ set(k, v, setOptions = {}) {\n        const { ttl = this.ttl, start, noDisposeOnSet = this.noDisposeOnSet, sizeCalculation = this.sizeCalculation, status } = setOptions;\n        let { noUpdateTTL = this.noUpdateTTL } = setOptions;\n        const size = this.#requireSize(k, v, setOptions.size || 0, sizeCalculation);\n        // if the item doesn't fit, don't do anything\n        // NB: maxEntrySize set to maxSize by default\n        if (this.maxEntrySize && size > this.maxEntrySize) {\n            if (status) {\n                status.set = \"miss\";\n                status.maxEntrySizeExceeded = true;\n            }\n            // have to delete, in case something is there already.\n            this.delete(k);\n            return this;\n        }\n        let index = this.#size === 0 ? undefined : this.#keyMap.get(k);\n        if (index === undefined) {\n            // addition\n            index = this.#size === 0 ? this.#tail : this.#free.length !== 0 ? this.#free.pop() : this.#size === this.#max ? this.#evict(false) : this.#size;\n            this.#keyList[index] = k;\n            this.#valList[index] = v;\n            this.#keyMap.set(k, index);\n            this.#next[this.#tail] = index;\n            this.#prev[index] = this.#tail;\n            this.#tail = index;\n            this.#size++;\n            this.#addItemSize(index, size, status);\n            if (status) status.set = \"add\";\n            noUpdateTTL = false;\n        } else {\n            // update\n            this.#moveToTail(index);\n            const oldVal = this.#valList[index];\n            if (v !== oldVal) {\n                if (this.#hasFetchMethod && this.#isBackgroundFetch(oldVal)) {\n                    oldVal.__abortController.abort(new Error(\"replaced\"));\n                } else if (!noDisposeOnSet) {\n                    if (this.#hasDispose) {\n                        this.#dispose?.(oldVal, k, \"set\");\n                    }\n                    if (this.#hasDisposeAfter) {\n                        this.#disposed?.push([\n                            oldVal,\n                            k,\n                            \"set\"\n                        ]);\n                    }\n                }\n                this.#removeItemSize(index);\n                this.#addItemSize(index, size, status);\n                this.#valList[index] = v;\n                if (status) {\n                    status.set = \"replace\";\n                    const oldValue = oldVal && this.#isBackgroundFetch(oldVal) ? oldVal.__staleWhileFetching : oldVal;\n                    if (oldValue !== undefined) status.oldValue = oldValue;\n                }\n            } else if (status) {\n                status.set = \"update\";\n            }\n        }\n        if (ttl !== 0 && !this.#ttls) {\n            this.#initializeTTLTracking();\n        }\n        if (this.#ttls) {\n            if (!noUpdateTTL) {\n                this.#setItemTTL(index, ttl, start);\n            }\n            if (status) this.#statusTTL(status, index);\n        }\n        if (!noDisposeOnSet && this.#hasDisposeAfter && this.#disposed) {\n            const dt = this.#disposed;\n            let task;\n            while(task = dt?.shift()){\n                this.#disposeAfter?.(...task);\n            }\n        }\n        return this;\n    }\n    /**\n     * Evict the least recently used item, returning its value or\n     * `undefined` if cache is empty.\n     */ pop() {\n        try {\n            while(this.#size){\n                const val = this.#valList[this.#head];\n                this.#evict(true);\n                if (this.#isBackgroundFetch(val)) {\n                    if (val.__staleWhileFetching) {\n                        return val.__staleWhileFetching;\n                    }\n                } else if (val !== undefined) {\n                    return val;\n                }\n            }\n        } finally{\n            if (this.#hasDisposeAfter && this.#disposed) {\n                const dt = this.#disposed;\n                let task;\n                while(task = dt?.shift()){\n                    this.#disposeAfter?.(...task);\n                }\n            }\n        }\n    }\n    #evict(free) {\n        const head = this.#head;\n        const k = this.#keyList[head];\n        const v = this.#valList[head];\n        if (this.#hasFetchMethod && this.#isBackgroundFetch(v)) {\n            v.__abortController.abort(new Error(\"evicted\"));\n        } else if (this.#hasDispose || this.#hasDisposeAfter) {\n            if (this.#hasDispose) {\n                this.#dispose?.(v, k, \"evict\");\n            }\n            if (this.#hasDisposeAfter) {\n                this.#disposed?.push([\n                    v,\n                    k,\n                    \"evict\"\n                ]);\n            }\n        }\n        this.#removeItemSize(head);\n        // if we aren't about to use the index, then null these out\n        if (free) {\n            this.#keyList[head] = undefined;\n            this.#valList[head] = undefined;\n            this.#free.push(head);\n        }\n        if (this.#size === 1) {\n            this.#head = this.#tail = 0;\n            this.#free.length = 0;\n        } else {\n            this.#head = this.#next[head];\n        }\n        this.#keyMap.delete(k);\n        this.#size--;\n        return head;\n    }\n    /**\n     * Check if a key is in the cache, without updating the recency of use.\n     * Will return false if the item is stale, even though it is technically\n     * in the cache.\n     *\n     * Will not update item age unless\n     * {@link LRUCache.OptionsBase.updateAgeOnHas} is set.\n     */ has(k, hasOptions = {}) {\n        const { updateAgeOnHas = this.updateAgeOnHas, status } = hasOptions;\n        const index = this.#keyMap.get(k);\n        if (index !== undefined) {\n            const v = this.#valList[index];\n            if (this.#isBackgroundFetch(v) && v.__staleWhileFetching === undefined) {\n                return false;\n            }\n            if (!this.#isStale(index)) {\n                if (updateAgeOnHas) {\n                    this.#updateItemAge(index);\n                }\n                if (status) {\n                    status.has = \"hit\";\n                    this.#statusTTL(status, index);\n                }\n                return true;\n            } else if (status) {\n                status.has = \"stale\";\n                this.#statusTTL(status, index);\n            }\n        } else if (status) {\n            status.has = \"miss\";\n        }\n        return false;\n    }\n    /**\n     * Like {@link LRUCache#get} but doesn't update recency or delete stale\n     * items.\n     *\n     * Returns `undefined` if the item is stale, unless\n     * {@link LRUCache.OptionsBase.allowStale} is set.\n     */ peek(k, peekOptions = {}) {\n        const { allowStale = this.allowStale } = peekOptions;\n        const index = this.#keyMap.get(k);\n        if (index !== undefined && (allowStale || !this.#isStale(index))) {\n            const v = this.#valList[index];\n            // either stale and allowed, or forcing a refresh of non-stale value\n            return this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;\n        }\n    }\n    #backgroundFetch(k, index, options, context) {\n        const v = index === undefined ? undefined : this.#valList[index];\n        if (this.#isBackgroundFetch(v)) {\n            return v;\n        }\n        const ac = new AbortController();\n        const { signal } = options;\n        // when/if our AC signals, then stop listening to theirs.\n        signal?.addEventListener(\"abort\", ()=>ac.abort(signal.reason), {\n            signal: ac.signal\n        });\n        const fetchOpts = {\n            signal: ac.signal,\n            options,\n            context\n        };\n        const cb = (v, updateCache = false)=>{\n            const { aborted } = ac.signal;\n            const ignoreAbort = options.ignoreFetchAbort && v !== undefined;\n            if (options.status) {\n                if (aborted && !updateCache) {\n                    options.status.fetchAborted = true;\n                    options.status.fetchError = ac.signal.reason;\n                    if (ignoreAbort) options.status.fetchAbortIgnored = true;\n                } else {\n                    options.status.fetchResolved = true;\n                }\n            }\n            if (aborted && !ignoreAbort && !updateCache) {\n                return fetchFail(ac.signal.reason);\n            }\n            // either we didn't abort, and are still here, or we did, and ignored\n            const bf = p;\n            if (this.#valList[index] === p) {\n                if (v === undefined) {\n                    if (bf.__staleWhileFetching) {\n                        this.#valList[index] = bf.__staleWhileFetching;\n                    } else {\n                        this.delete(k);\n                    }\n                } else {\n                    if (options.status) options.status.fetchUpdated = true;\n                    this.set(k, v, fetchOpts.options);\n                }\n            }\n            return v;\n        };\n        const eb = (er)=>{\n            if (options.status) {\n                options.status.fetchRejected = true;\n                options.status.fetchError = er;\n            }\n            return fetchFail(er);\n        };\n        const fetchFail = (er)=>{\n            const { aborted } = ac.signal;\n            const allowStaleAborted = aborted && options.allowStaleOnFetchAbort;\n            const allowStale = allowStaleAborted || options.allowStaleOnFetchRejection;\n            const noDelete = allowStale || options.noDeleteOnFetchRejection;\n            const bf = p;\n            if (this.#valList[index] === p) {\n                // if we allow stale on fetch rejections, then we need to ensure that\n                // the stale value is not removed from the cache when the fetch fails.\n                const del = !noDelete || bf.__staleWhileFetching === undefined;\n                if (del) {\n                    this.delete(k);\n                } else if (!allowStaleAborted) {\n                    // still replace the *promise* with the stale value,\n                    // since we are done with the promise at this point.\n                    // leave it untouched if we're still waiting for an\n                    // aborted background fetch that hasn't yet returned.\n                    this.#valList[index] = bf.__staleWhileFetching;\n                }\n            }\n            if (allowStale) {\n                if (options.status && bf.__staleWhileFetching !== undefined) {\n                    options.status.returnedStale = true;\n                }\n                return bf.__staleWhileFetching;\n            } else if (bf.__returned === bf) {\n                throw er;\n            }\n        };\n        const pcall = (res, rej)=>{\n            const fmp = this.#fetchMethod?.(k, v, fetchOpts);\n            if (fmp && fmp instanceof Promise) {\n                fmp.then((v)=>res(v), rej);\n            }\n            // ignored, we go until we finish, regardless.\n            // defer check until we are actually aborting,\n            // so fetchMethod can override.\n            ac.signal.addEventListener(\"abort\", ()=>{\n                if (!options.ignoreFetchAbort || options.allowStaleOnFetchAbort) {\n                    res();\n                    // when it eventually resolves, update the cache.\n                    if (options.allowStaleOnFetchAbort) {\n                        res = (v)=>cb(v, true);\n                    }\n                }\n            });\n        };\n        if (options.status) options.status.fetchDispatched = true;\n        const p = new Promise(pcall).then(cb, eb);\n        const bf = Object.assign(p, {\n            __abortController: ac,\n            __staleWhileFetching: v,\n            __returned: undefined\n        });\n        if (index === undefined) {\n            // internal, don't expose status.\n            this.set(k, bf, {\n                ...fetchOpts.options,\n                status: undefined\n            });\n            index = this.#keyMap.get(k);\n        } else {\n            this.#valList[index] = bf;\n        }\n        return bf;\n    }\n    #isBackgroundFetch(p) {\n        if (!this.#hasFetchMethod) return false;\n        const b = p;\n        return !!b && b instanceof Promise && b.hasOwnProperty(\"__staleWhileFetching\") && b.__abortController instanceof AbortController;\n    }\n    async fetch(k, fetchOptions = {}) {\n        const { // get options\n        allowStale = this.allowStale, updateAgeOnGet = this.updateAgeOnGet, noDeleteOnStaleGet = this.noDeleteOnStaleGet, // set options\n        ttl = this.ttl, noDisposeOnSet = this.noDisposeOnSet, size = 0, sizeCalculation = this.sizeCalculation, noUpdateTTL = this.noUpdateTTL, // fetch exclusive options\n        noDeleteOnFetchRejection = this.noDeleteOnFetchRejection, allowStaleOnFetchRejection = this.allowStaleOnFetchRejection, ignoreFetchAbort = this.ignoreFetchAbort, allowStaleOnFetchAbort = this.allowStaleOnFetchAbort, context, forceRefresh = false, status, signal } = fetchOptions;\n        if (!this.#hasFetchMethod) {\n            if (status) status.fetch = \"get\";\n            return this.get(k, {\n                allowStale,\n                updateAgeOnGet,\n                noDeleteOnStaleGet,\n                status\n            });\n        }\n        const options = {\n            allowStale,\n            updateAgeOnGet,\n            noDeleteOnStaleGet,\n            ttl,\n            noDisposeOnSet,\n            size,\n            sizeCalculation,\n            noUpdateTTL,\n            noDeleteOnFetchRejection,\n            allowStaleOnFetchRejection,\n            allowStaleOnFetchAbort,\n            ignoreFetchAbort,\n            status,\n            signal\n        };\n        let index = this.#keyMap.get(k);\n        if (index === undefined) {\n            if (status) status.fetch = \"miss\";\n            const p = this.#backgroundFetch(k, index, options, context);\n            return p.__returned = p;\n        } else {\n            // in cache, maybe already fetching\n            const v = this.#valList[index];\n            if (this.#isBackgroundFetch(v)) {\n                const stale = allowStale && v.__staleWhileFetching !== undefined;\n                if (status) {\n                    status.fetch = \"inflight\";\n                    if (stale) status.returnedStale = true;\n                }\n                return stale ? v.__staleWhileFetching : v.__returned = v;\n            }\n            // if we force a refresh, that means do NOT serve the cached value,\n            // unless we are already in the process of refreshing the cache.\n            const isStale = this.#isStale(index);\n            if (!forceRefresh && !isStale) {\n                if (status) status.fetch = \"hit\";\n                this.#moveToTail(index);\n                if (updateAgeOnGet) {\n                    this.#updateItemAge(index);\n                }\n                if (status) this.#statusTTL(status, index);\n                return v;\n            }\n            // ok, it is stale or a forced refresh, and not already fetching.\n            // refresh the cache.\n            const p = this.#backgroundFetch(k, index, options, context);\n            const hasStale = p.__staleWhileFetching !== undefined;\n            const staleVal = hasStale && allowStale;\n            if (status) {\n                status.fetch = isStale ? \"stale\" : \"refresh\";\n                if (staleVal && isStale) status.returnedStale = true;\n            }\n            return staleVal ? p.__staleWhileFetching : p.__returned = p;\n        }\n    }\n    /**\n     * Return a value from the cache. Will update the recency of the cache\n     * entry found.\n     *\n     * If the key is not found, get() will return `undefined`.\n     */ get(k, getOptions = {}) {\n        const { allowStale = this.allowStale, updateAgeOnGet = this.updateAgeOnGet, noDeleteOnStaleGet = this.noDeleteOnStaleGet, status } = getOptions;\n        const index = this.#keyMap.get(k);\n        if (index !== undefined) {\n            const value = this.#valList[index];\n            const fetching = this.#isBackgroundFetch(value);\n            if (status) this.#statusTTL(status, index);\n            if (this.#isStale(index)) {\n                if (status) status.get = \"stale\";\n                // delete only if not an in-flight background fetch\n                if (!fetching) {\n                    if (!noDeleteOnStaleGet) {\n                        this.delete(k);\n                    }\n                    if (status && allowStale) status.returnedStale = true;\n                    return allowStale ? value : undefined;\n                } else {\n                    if (status && allowStale && value.__staleWhileFetching !== undefined) {\n                        status.returnedStale = true;\n                    }\n                    return allowStale ? value.__staleWhileFetching : undefined;\n                }\n            } else {\n                if (status) status.get = \"hit\";\n                // if we're currently fetching it, we don't actually have it yet\n                // it's not stale, which means this isn't a staleWhileRefetching.\n                // If it's not stale, and fetching, AND has a __staleWhileFetching\n                // value, then that means the user fetched with {forceRefresh:true},\n                // so it's safe to return that value.\n                if (fetching) {\n                    return value.__staleWhileFetching;\n                }\n                this.#moveToTail(index);\n                if (updateAgeOnGet) {\n                    this.#updateItemAge(index);\n                }\n                return value;\n            }\n        } else if (status) {\n            status.get = \"miss\";\n        }\n    }\n    #connect(p, n) {\n        this.#prev[n] = p;\n        this.#next[p] = n;\n    }\n    #moveToTail(index) {\n        // if tail already, nothing to do\n        // if head, move head to next[index]\n        // else\n        //   move next[prev[index]] to next[index] (head has no prev)\n        //   move prev[next[index]] to prev[index]\n        // prev[index] = tail\n        // next[tail] = index\n        // tail = index\n        if (index !== this.#tail) {\n            if (index === this.#head) {\n                this.#head = this.#next[index];\n            } else {\n                this.#connect(this.#prev[index], this.#next[index]);\n            }\n            this.#connect(this.#tail, index);\n            this.#tail = index;\n        }\n    }\n    /**\n     * Deletes a key out of the cache.\n     * Returns true if the key was deleted, false otherwise.\n     */ delete(k) {\n        let deleted = false;\n        if (this.#size !== 0) {\n            const index = this.#keyMap.get(k);\n            if (index !== undefined) {\n                deleted = true;\n                if (this.#size === 1) {\n                    this.clear();\n                } else {\n                    this.#removeItemSize(index);\n                    const v = this.#valList[index];\n                    if (this.#isBackgroundFetch(v)) {\n                        v.__abortController.abort(new Error(\"deleted\"));\n                    } else if (this.#hasDispose || this.#hasDisposeAfter) {\n                        if (this.#hasDispose) {\n                            this.#dispose?.(v, k, \"delete\");\n                        }\n                        if (this.#hasDisposeAfter) {\n                            this.#disposed?.push([\n                                v,\n                                k,\n                                \"delete\"\n                            ]);\n                        }\n                    }\n                    this.#keyMap.delete(k);\n                    this.#keyList[index] = undefined;\n                    this.#valList[index] = undefined;\n                    if (index === this.#tail) {\n                        this.#tail = this.#prev[index];\n                    } else if (index === this.#head) {\n                        this.#head = this.#next[index];\n                    } else {\n                        this.#next[this.#prev[index]] = this.#next[index];\n                        this.#prev[this.#next[index]] = this.#prev[index];\n                    }\n                    this.#size--;\n                    this.#free.push(index);\n                }\n            }\n        }\n        if (this.#hasDisposeAfter && this.#disposed?.length) {\n            const dt = this.#disposed;\n            let task;\n            while(task = dt?.shift()){\n                this.#disposeAfter?.(...task);\n            }\n        }\n        return deleted;\n    }\n    /**\n     * Clear the cache entirely, throwing away all values.\n     */ clear() {\n        for (const index of this.#rindexes({\n            allowStale: true\n        })){\n            const v = this.#valList[index];\n            if (this.#isBackgroundFetch(v)) {\n                v.__abortController.abort(new Error(\"deleted\"));\n            } else {\n                const k = this.#keyList[index];\n                if (this.#hasDispose) {\n                    this.#dispose?.(v, k, \"delete\");\n                }\n                if (this.#hasDisposeAfter) {\n                    this.#disposed?.push([\n                        v,\n                        k,\n                        \"delete\"\n                    ]);\n                }\n            }\n        }\n        this.#keyMap.clear();\n        this.#valList.fill(undefined);\n        this.#keyList.fill(undefined);\n        if (this.#ttls && this.#starts) {\n            this.#ttls.fill(0);\n            this.#starts.fill(0);\n        }\n        if (this.#sizes) {\n            this.#sizes.fill(0);\n        }\n        this.#head = 0;\n        this.#tail = 0;\n        this.#free.length = 0;\n        this.#calculatedSize = 0;\n        this.#size = 0;\n        if (this.#hasDisposeAfter && this.#disposed) {\n            const dt = this.#disposed;\n            let task;\n            while(task = dt?.shift()){\n                this.#disposeAfter?.(...task);\n            }\n        }\n    }\n}\nexports.LRUCache = LRUCache;\nexports[\"default\"] = LRUCache; //# sourceMappingURL=index.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/lru-cache/dist/cjs/index.js\n");

/***/ })

};
;