"use client"
import React from 'react';
import './addFolder.css'
import Modal from 'react-modal';

const customStyles = {
    content: {
        border: '0',
        borderRadius: '4px',
        bottom: 'auto',
        minHeight: '15rem',
        maxHeight: '15em',
        left: '50%',
        padding: '2rem',
        position: 'fixed',
        right: 'auto',
        top: '50%',
        transform: 'translate(-50%,-50%)',
        minWidth: '20rem',
        width: window.innerWidth < 800
            ? '60%'
            : '60%',
        maxWidth: '30rem',
        borderRadius: '20px'
    },
    overlay: {
        position: 'fixed',
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        backgroundColor: 'rgba(0, 0, 0, 0.5)'
    }
};
export default function Addfolder(prop) {
    const [folderName,
        setFolderName] = React.useState('');

    const handleFolderNameChange = (e) => {
        setFolderName(e.target.value);
    };

    return (
        <Modal
            ariaHideApp={false}
            isOpen={prop.open}
            style={customStyles}
            contentLabel="Example Modal">
            <div className='modal-body '>

                <span className="material-icons closeModal" onClick={e => prop.close(false)}>
                    cancel
                </span>
                <div>New Folder</div>
                {/* <span className="material-icons folder">
                    folder
                </span> */}

                <div className='form-group mt-5'>
                    <input
                        className="form-control"
                        value={folderName}
                        onChange={handleFolderNameChange}
                        type='text'
                        placeholder="Folder Name"/>
                </div>
                <div className='grid grid-cols-2 mt-10'>
                    <div>
                        <button className="font-extrabold  text-red-600" type='reset'>Cancel
                        </button>
                    </div>
                    <div>
                        <button className="font-extrabold text-blue-600" type='button' onClick={e=>
                            {
                                prop.folder(folderName.replace(/ /g,'%20'))
                               setFolderName('')
                            }}>Create
                        </button>
                    </div>
                </div>

            </div>

        </Modal>
    )
}
