"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/iconv-lite";
exports.ids = ["vendor-chunks/iconv-lite"];
exports.modules = {

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/dbcs-codec.js":
/*!*********************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/dbcs-codec.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// Multibyte codec. In this scheme, a character is represented by 1 or more bytes.\n// Our codec supports UTF-16 surrogates, extensions for GB18030 and unicode sequences.\n// To save memory and loading time, we read table files only when requested.\nexports._dbcs = DBCSCodec;\nvar UNASSIGNED = -1, GB18030_CODE = -2, SEQ_START = -10, NODE_START = -1000, UNASSIGNED_NODE = new Array(0x100), DEF_CHAR = -1;\nfor(var i = 0; i < 0x100; i++)UNASSIGNED_NODE[i] = UNASSIGNED;\n// Class DBCSCodec reads and initializes mapping tables.\nfunction DBCSCodec(codecOptions, iconv) {\n    this.encodingName = codecOptions.encodingName;\n    if (!codecOptions) throw new Error(\"DBCS codec is called without the data.\");\n    if (!codecOptions.table) throw new Error(\"Encoding '\" + this.encodingName + \"' has no data.\");\n    // Load tables.\n    var mappingTable = codecOptions.table();\n    // Decode tables: MBCS -> Unicode.\n    // decodeTables is a trie, encoded as an array of arrays of integers. Internal arrays are trie nodes and all have len = 256.\n    // Trie root is decodeTables[0].\n    // Values: >=  0 -> unicode character code. can be > 0xFFFF\n    //         == UNASSIGNED -> unknown/unassigned sequence.\n    //         == GB18030_CODE -> this is the end of a GB18030 4-byte sequence.\n    //         <= NODE_START -> index of the next node in our trie to process next byte.\n    //         <= SEQ_START  -> index of the start of a character code sequence, in decodeTableSeq.\n    this.decodeTables = [];\n    this.decodeTables[0] = UNASSIGNED_NODE.slice(0); // Create root node.\n    // Sometimes a MBCS char corresponds to a sequence of unicode chars. We store them as arrays of integers here. \n    this.decodeTableSeq = [];\n    // Actual mapping tables consist of chunks. Use them to fill up decode tables.\n    for(var i = 0; i < mappingTable.length; i++)this._addDecodeChunk(mappingTable[i]);\n    // Load & create GB18030 tables when needed.\n    if (typeof codecOptions.gb18030 === \"function\") {\n        this.gb18030 = codecOptions.gb18030(); // Load GB18030 ranges.\n        // Add GB18030 common decode nodes.\n        var commonThirdByteNodeIdx = this.decodeTables.length;\n        this.decodeTables.push(UNASSIGNED_NODE.slice(0));\n        var commonFourthByteNodeIdx = this.decodeTables.length;\n        this.decodeTables.push(UNASSIGNED_NODE.slice(0));\n        // Fill out the tree\n        var firstByteNode = this.decodeTables[0];\n        for(var i = 0x81; i <= 0xFE; i++){\n            var secondByteNode = this.decodeTables[NODE_START - firstByteNode[i]];\n            for(var j = 0x30; j <= 0x39; j++){\n                if (secondByteNode[j] === UNASSIGNED) {\n                    secondByteNode[j] = NODE_START - commonThirdByteNodeIdx;\n                } else if (secondByteNode[j] > NODE_START) {\n                    throw new Error(\"gb18030 decode tables conflict at byte 2\");\n                }\n                var thirdByteNode = this.decodeTables[NODE_START - secondByteNode[j]];\n                for(var k = 0x81; k <= 0xFE; k++){\n                    if (thirdByteNode[k] === UNASSIGNED) {\n                        thirdByteNode[k] = NODE_START - commonFourthByteNodeIdx;\n                    } else if (thirdByteNode[k] === NODE_START - commonFourthByteNodeIdx) {\n                        continue;\n                    } else if (thirdByteNode[k] > NODE_START) {\n                        throw new Error(\"gb18030 decode tables conflict at byte 3\");\n                    }\n                    var fourthByteNode = this.decodeTables[NODE_START - thirdByteNode[k]];\n                    for(var l = 0x30; l <= 0x39; l++){\n                        if (fourthByteNode[l] === UNASSIGNED) fourthByteNode[l] = GB18030_CODE;\n                    }\n                }\n            }\n        }\n    }\n    this.defaultCharUnicode = iconv.defaultCharUnicode;\n    // Encode tables: Unicode -> DBCS.\n    // `encodeTable` is array mapping from unicode char to encoded char. All its values are integers for performance.\n    // Because it can be sparse, it is represented as array of buckets by 256 chars each. Bucket can be null.\n    // Values: >=  0 -> it is a normal char. Write the value (if <=256 then 1 byte, if <=65536 then 2 bytes, etc.).\n    //         == UNASSIGNED -> no conversion found. Output a default char.\n    //         <= SEQ_START  -> it's an index in encodeTableSeq, see below. The character starts a sequence.\n    this.encodeTable = [];\n    // `encodeTableSeq` is used when a sequence of unicode characters is encoded as a single code. We use a tree of\n    // objects where keys correspond to characters in sequence and leafs are the encoded dbcs values. A special DEF_CHAR key\n    // means end of sequence (needed when one sequence is a strict subsequence of another).\n    // Objects are kept separately from encodeTable to increase performance.\n    this.encodeTableSeq = [];\n    // Some chars can be decoded, but need not be encoded.\n    var skipEncodeChars = {};\n    if (codecOptions.encodeSkipVals) for(var i = 0; i < codecOptions.encodeSkipVals.length; i++){\n        var val = codecOptions.encodeSkipVals[i];\n        if (typeof val === \"number\") skipEncodeChars[val] = true;\n        else for(var j = val.from; j <= val.to; j++)skipEncodeChars[j] = true;\n    }\n    // Use decode trie to recursively fill out encode tables.\n    this._fillEncodeTable(0, 0, skipEncodeChars);\n    // Add more encoding pairs when needed.\n    if (codecOptions.encodeAdd) {\n        for(var uChar in codecOptions.encodeAdd)if (Object.prototype.hasOwnProperty.call(codecOptions.encodeAdd, uChar)) this._setEncodeChar(uChar.charCodeAt(0), codecOptions.encodeAdd[uChar]);\n    }\n    this.defCharSB = this.encodeTable[0][iconv.defaultCharSingleByte.charCodeAt(0)];\n    if (this.defCharSB === UNASSIGNED) this.defCharSB = this.encodeTable[0][\"?\"];\n    if (this.defCharSB === UNASSIGNED) this.defCharSB = \"?\".charCodeAt(0);\n}\nDBCSCodec.prototype.encoder = DBCSEncoder;\nDBCSCodec.prototype.decoder = DBCSDecoder;\n// Decoder helpers\nDBCSCodec.prototype._getDecodeTrieNode = function(addr) {\n    var bytes = [];\n    for(; addr > 0; addr >>>= 8)bytes.push(addr & 0xFF);\n    if (bytes.length == 0) bytes.push(0);\n    var node = this.decodeTables[0];\n    for(var i = bytes.length - 1; i > 0; i--){\n        var val = node[bytes[i]];\n        if (val == UNASSIGNED) {\n            node[bytes[i]] = NODE_START - this.decodeTables.length;\n            this.decodeTables.push(node = UNASSIGNED_NODE.slice(0));\n        } else if (val <= NODE_START) {\n            node = this.decodeTables[NODE_START - val];\n        } else throw new Error(\"Overwrite byte in \" + this.encodingName + \", addr: \" + addr.toString(16));\n    }\n    return node;\n};\nDBCSCodec.prototype._addDecodeChunk = function(chunk) {\n    // First element of chunk is the hex mbcs code where we start.\n    var curAddr = parseInt(chunk[0], 16);\n    // Choose the decoding node where we'll write our chars.\n    var writeTable = this._getDecodeTrieNode(curAddr);\n    curAddr = curAddr & 0xFF;\n    // Write all other elements of the chunk to the table.\n    for(var k = 1; k < chunk.length; k++){\n        var part = chunk[k];\n        if (typeof part === \"string\") {\n            for(var l = 0; l < part.length;){\n                var code = part.charCodeAt(l++);\n                if (0xD800 <= code && code < 0xDC00) {\n                    var codeTrail = part.charCodeAt(l++);\n                    if (0xDC00 <= codeTrail && codeTrail < 0xE000) writeTable[curAddr++] = 0x10000 + (code - 0xD800) * 0x400 + (codeTrail - 0xDC00);\n                    else throw new Error(\"Incorrect surrogate pair in \" + this.encodingName + \" at chunk \" + chunk[0]);\n                } else if (0x0FF0 < code && code <= 0x0FFF) {\n                    var len = 0xFFF - code + 2;\n                    var seq = [];\n                    for(var m = 0; m < len; m++)seq.push(part.charCodeAt(l++)); // Simple variation: don't support surrogates or subsequences in seq.\n                    writeTable[curAddr++] = SEQ_START - this.decodeTableSeq.length;\n                    this.decodeTableSeq.push(seq);\n                } else writeTable[curAddr++] = code; // Basic char\n            }\n        } else if (typeof part === \"number\") {\n            var charCode = writeTable[curAddr - 1] + 1;\n            for(var l = 0; l < part; l++)writeTable[curAddr++] = charCode++;\n        } else throw new Error(\"Incorrect type '\" + typeof part + \"' given in \" + this.encodingName + \" at chunk \" + chunk[0]);\n    }\n    if (curAddr > 0xFF) throw new Error(\"Incorrect chunk in \" + this.encodingName + \" at addr \" + chunk[0] + \": too long\" + curAddr);\n};\n// Encoder helpers\nDBCSCodec.prototype._getEncodeBucket = function(uCode) {\n    var high = uCode >> 8; // This could be > 0xFF because of astral characters.\n    if (this.encodeTable[high] === undefined) this.encodeTable[high] = UNASSIGNED_NODE.slice(0); // Create bucket on demand.\n    return this.encodeTable[high];\n};\nDBCSCodec.prototype._setEncodeChar = function(uCode, dbcsCode) {\n    var bucket = this._getEncodeBucket(uCode);\n    var low = uCode & 0xFF;\n    if (bucket[low] <= SEQ_START) this.encodeTableSeq[SEQ_START - bucket[low]][DEF_CHAR] = dbcsCode; // There's already a sequence, set a single-char subsequence of it.\n    else if (bucket[low] == UNASSIGNED) bucket[low] = dbcsCode;\n};\nDBCSCodec.prototype._setEncodeSequence = function(seq, dbcsCode) {\n    // Get the root of character tree according to first character of the sequence.\n    var uCode = seq[0];\n    var bucket = this._getEncodeBucket(uCode);\n    var low = uCode & 0xFF;\n    var node;\n    if (bucket[low] <= SEQ_START) {\n        // There's already a sequence with  - use it.\n        node = this.encodeTableSeq[SEQ_START - bucket[low]];\n    } else {\n        // There was no sequence object - allocate a new one.\n        node = {};\n        if (bucket[low] !== UNASSIGNED) node[DEF_CHAR] = bucket[low]; // If a char was set before - make it a single-char subsequence.\n        bucket[low] = SEQ_START - this.encodeTableSeq.length;\n        this.encodeTableSeq.push(node);\n    }\n    // Traverse the character tree, allocating new nodes as needed.\n    for(var j = 1; j < seq.length - 1; j++){\n        var oldVal = node[uCode];\n        if (typeof oldVal === \"object\") node = oldVal;\n        else {\n            node = node[uCode] = {};\n            if (oldVal !== undefined) node[DEF_CHAR] = oldVal;\n        }\n    }\n    // Set the leaf to given dbcsCode.\n    uCode = seq[seq.length - 1];\n    node[uCode] = dbcsCode;\n};\nDBCSCodec.prototype._fillEncodeTable = function(nodeIdx, prefix, skipEncodeChars) {\n    var node = this.decodeTables[nodeIdx];\n    var hasValues = false;\n    var subNodeEmpty = {};\n    for(var i = 0; i < 0x100; i++){\n        var uCode = node[i];\n        var mbCode = prefix + i;\n        if (skipEncodeChars[mbCode]) continue;\n        if (uCode >= 0) {\n            this._setEncodeChar(uCode, mbCode);\n            hasValues = true;\n        } else if (uCode <= NODE_START) {\n            var subNodeIdx = NODE_START - uCode;\n            if (!subNodeEmpty[subNodeIdx]) {\n                var newPrefix = mbCode << 8 >>> 0; // NOTE: '>>> 0' keeps 32-bit num positive.\n                if (this._fillEncodeTable(subNodeIdx, newPrefix, skipEncodeChars)) hasValues = true;\n                else subNodeEmpty[subNodeIdx] = true;\n            }\n        } else if (uCode <= SEQ_START) {\n            this._setEncodeSequence(this.decodeTableSeq[SEQ_START - uCode], mbCode);\n            hasValues = true;\n        }\n    }\n    return hasValues;\n};\n// == Encoder ==================================================================\nfunction DBCSEncoder(options, codec) {\n    // Encoder state\n    this.leadSurrogate = -1;\n    this.seqObj = undefined;\n    // Static data\n    this.encodeTable = codec.encodeTable;\n    this.encodeTableSeq = codec.encodeTableSeq;\n    this.defaultCharSingleByte = codec.defCharSB;\n    this.gb18030 = codec.gb18030;\n}\nDBCSEncoder.prototype.write = function(str) {\n    var newBuf = Buffer.alloc(str.length * (this.gb18030 ? 4 : 3)), leadSurrogate = this.leadSurrogate, seqObj = this.seqObj, nextChar = -1, i = 0, j = 0;\n    while(true){\n        // 0. Get next character.\n        if (nextChar === -1) {\n            if (i == str.length) break;\n            var uCode = str.charCodeAt(i++);\n        } else {\n            var uCode = nextChar;\n            nextChar = -1;\n        }\n        // 1. Handle surrogates.\n        if (0xD800 <= uCode && uCode < 0xE000) {\n            if (uCode < 0xDC00) {\n                if (leadSurrogate === -1) {\n                    leadSurrogate = uCode;\n                    continue;\n                } else {\n                    leadSurrogate = uCode;\n                    // Double lead surrogate found.\n                    uCode = UNASSIGNED;\n                }\n            } else {\n                if (leadSurrogate !== -1) {\n                    uCode = 0x10000 + (leadSurrogate - 0xD800) * 0x400 + (uCode - 0xDC00);\n                    leadSurrogate = -1;\n                } else {\n                    // Incomplete surrogate pair - only trail surrogate found.\n                    uCode = UNASSIGNED;\n                }\n            }\n        } else if (leadSurrogate !== -1) {\n            // Incomplete surrogate pair - only lead surrogate found.\n            nextChar = uCode;\n            uCode = UNASSIGNED; // Write an error, then current char.\n            leadSurrogate = -1;\n        }\n        // 2. Convert uCode character.\n        var dbcsCode = UNASSIGNED;\n        if (seqObj !== undefined && uCode != UNASSIGNED) {\n            var resCode = seqObj[uCode];\n            if (typeof resCode === \"object\") {\n                seqObj = resCode;\n                continue;\n            } else if (typeof resCode == \"number\") {\n                dbcsCode = resCode;\n            } else if (resCode == undefined) {\n                // Try default character for this sequence\n                resCode = seqObj[DEF_CHAR];\n                if (resCode !== undefined) {\n                    dbcsCode = resCode; // Found. Write it.\n                    nextChar = uCode; // Current character will be written too in the next iteration.\n                } else {\n                // TODO: What if we have no default? (resCode == undefined)\n                // Then, we should write first char of the sequence as-is and try the rest recursively.\n                // Didn't do it for now because no encoding has this situation yet.\n                // Currently, just skip the sequence and write current char.\n                }\n            }\n            seqObj = undefined;\n        } else if (uCode >= 0) {\n            var subtable = this.encodeTable[uCode >> 8];\n            if (subtable !== undefined) dbcsCode = subtable[uCode & 0xFF];\n            if (dbcsCode <= SEQ_START) {\n                seqObj = this.encodeTableSeq[SEQ_START - dbcsCode];\n                continue;\n            }\n            if (dbcsCode == UNASSIGNED && this.gb18030) {\n                // Use GB18030 algorithm to find character(s) to write.\n                var idx = findIdx(this.gb18030.uChars, uCode);\n                if (idx != -1) {\n                    var dbcsCode = this.gb18030.gbChars[idx] + (uCode - this.gb18030.uChars[idx]);\n                    newBuf[j++] = 0x81 + Math.floor(dbcsCode / 12600);\n                    dbcsCode = dbcsCode % 12600;\n                    newBuf[j++] = 0x30 + Math.floor(dbcsCode / 1260);\n                    dbcsCode = dbcsCode % 1260;\n                    newBuf[j++] = 0x81 + Math.floor(dbcsCode / 10);\n                    dbcsCode = dbcsCode % 10;\n                    newBuf[j++] = 0x30 + dbcsCode;\n                    continue;\n                }\n            }\n        }\n        // 3. Write dbcsCode character.\n        if (dbcsCode === UNASSIGNED) dbcsCode = this.defaultCharSingleByte;\n        if (dbcsCode < 0x100) {\n            newBuf[j++] = dbcsCode;\n        } else if (dbcsCode < 0x10000) {\n            newBuf[j++] = dbcsCode >> 8; // high byte\n            newBuf[j++] = dbcsCode & 0xFF; // low byte\n        } else if (dbcsCode < 0x1000000) {\n            newBuf[j++] = dbcsCode >> 16;\n            newBuf[j++] = dbcsCode >> 8 & 0xFF;\n            newBuf[j++] = dbcsCode & 0xFF;\n        } else {\n            newBuf[j++] = dbcsCode >>> 24;\n            newBuf[j++] = dbcsCode >>> 16 & 0xFF;\n            newBuf[j++] = dbcsCode >>> 8 & 0xFF;\n            newBuf[j++] = dbcsCode & 0xFF;\n        }\n    }\n    this.seqObj = seqObj;\n    this.leadSurrogate = leadSurrogate;\n    return newBuf.slice(0, j);\n};\nDBCSEncoder.prototype.end = function() {\n    if (this.leadSurrogate === -1 && this.seqObj === undefined) return; // All clean. Most often case.\n    var newBuf = Buffer.alloc(10), j = 0;\n    if (this.seqObj) {\n        var dbcsCode = this.seqObj[DEF_CHAR];\n        if (dbcsCode !== undefined) {\n            if (dbcsCode < 0x100) {\n                newBuf[j++] = dbcsCode;\n            } else {\n                newBuf[j++] = dbcsCode >> 8; // high byte\n                newBuf[j++] = dbcsCode & 0xFF; // low byte\n            }\n        } else {\n        // See todo above.\n        }\n        this.seqObj = undefined;\n    }\n    if (this.leadSurrogate !== -1) {\n        // Incomplete surrogate pair - only lead surrogate found.\n        newBuf[j++] = this.defaultCharSingleByte;\n        this.leadSurrogate = -1;\n    }\n    return newBuf.slice(0, j);\n};\n// Export for testing\nDBCSEncoder.prototype.findIdx = findIdx;\n// == Decoder ==================================================================\nfunction DBCSDecoder(options, codec) {\n    // Decoder state\n    this.nodeIdx = 0;\n    this.prevBytes = [];\n    // Static data\n    this.decodeTables = codec.decodeTables;\n    this.decodeTableSeq = codec.decodeTableSeq;\n    this.defaultCharUnicode = codec.defaultCharUnicode;\n    this.gb18030 = codec.gb18030;\n}\nDBCSDecoder.prototype.write = function(buf) {\n    var newBuf = Buffer.alloc(buf.length * 2), nodeIdx = this.nodeIdx, prevBytes = this.prevBytes, prevOffset = this.prevBytes.length, seqStart = -this.prevBytes.length, uCode;\n    for(var i = 0, j = 0; i < buf.length; i++){\n        var curByte = i >= 0 ? buf[i] : prevBytes[i + prevOffset];\n        // Lookup in current trie node.\n        var uCode = this.decodeTables[nodeIdx][curByte];\n        if (uCode >= 0) {\n        // Normal character, just use it.\n        } else if (uCode === UNASSIGNED) {\n            // TODO: Callback with seq.\n            uCode = this.defaultCharUnicode.charCodeAt(0);\n            i = seqStart; // Skip one byte ('i' will be incremented by the for loop) and try to parse again.\n        } else if (uCode === GB18030_CODE) {\n            if (i >= 3) {\n                var ptr = (buf[i - 3] - 0x81) * 12600 + (buf[i - 2] - 0x30) * 1260 + (buf[i - 1] - 0x81) * 10 + (curByte - 0x30);\n            } else {\n                var ptr = (prevBytes[i - 3 + prevOffset] - 0x81) * 12600 + ((i - 2 >= 0 ? buf[i - 2] : prevBytes[i - 2 + prevOffset]) - 0x30) * 1260 + ((i - 1 >= 0 ? buf[i - 1] : prevBytes[i - 1 + prevOffset]) - 0x81) * 10 + (curByte - 0x30);\n            }\n            var idx = findIdx(this.gb18030.gbChars, ptr);\n            uCode = this.gb18030.uChars[idx] + ptr - this.gb18030.gbChars[idx];\n        } else if (uCode <= NODE_START) {\n            nodeIdx = NODE_START - uCode;\n            continue;\n        } else if (uCode <= SEQ_START) {\n            var seq = this.decodeTableSeq[SEQ_START - uCode];\n            for(var k = 0; k < seq.length - 1; k++){\n                uCode = seq[k];\n                newBuf[j++] = uCode & 0xFF;\n                newBuf[j++] = uCode >> 8;\n            }\n            uCode = seq[seq.length - 1];\n        } else throw new Error(\"iconv-lite internal error: invalid decoding table value \" + uCode + \" at \" + nodeIdx + \"/\" + curByte);\n        // Write the character to buffer, handling higher planes using surrogate pair.\n        if (uCode >= 0x10000) {\n            uCode -= 0x10000;\n            var uCodeLead = 0xD800 | uCode >> 10;\n            newBuf[j++] = uCodeLead & 0xFF;\n            newBuf[j++] = uCodeLead >> 8;\n            uCode = 0xDC00 | uCode & 0x3FF;\n        }\n        newBuf[j++] = uCode & 0xFF;\n        newBuf[j++] = uCode >> 8;\n        // Reset trie node.\n        nodeIdx = 0;\n        seqStart = i + 1;\n    }\n    this.nodeIdx = nodeIdx;\n    this.prevBytes = seqStart >= 0 ? Array.prototype.slice.call(buf, seqStart) : prevBytes.slice(seqStart + prevOffset).concat(Array.prototype.slice.call(buf));\n    return newBuf.slice(0, j).toString(\"ucs2\");\n};\nDBCSDecoder.prototype.end = function() {\n    var ret = \"\";\n    // Try to parse all remaining chars.\n    while(this.prevBytes.length > 0){\n        // Skip 1 character in the buffer.\n        ret += this.defaultCharUnicode;\n        var bytesArr = this.prevBytes.slice(1);\n        // Parse remaining as usual.\n        this.prevBytes = [];\n        this.nodeIdx = 0;\n        if (bytesArr.length > 0) ret += this.write(bytesArr);\n    }\n    this.prevBytes = [];\n    this.nodeIdx = 0;\n    return ret;\n};\n// Binary search for GB18030. Returns largest i such that table[i] <= val.\nfunction findIdx(table, val) {\n    if (table[0] > val) return -1;\n    var l = 0, r = table.length;\n    while(l < r - 1){\n        var mid = l + (r - l + 1 >> 1);\n        if (table[mid] <= val) l = mid;\n        else r = mid;\n    }\n    return l;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/dbcs-codec.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/dbcs-data.js":
/*!********************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/dbcs-data.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n// Description of supported double byte encodings and aliases.\n// Tables are not require()-d until they are needed to speed up library load.\n// require()-s are direct to support Browserify.\nmodule.exports = {\n    // == Japanese/ShiftJIS ====================================================\n    // All japanese encodings are based on JIS X set of standards:\n    // JIS X 0201 - Single-byte encoding of ASCII + ¥ + Kana chars at 0xA1-0xDF.\n    // JIS X 0208 - Main set of 6879 characters, placed in 94x94 plane, to be encoded by 2 bytes. \n    //              Has several variations in 1978, 1983, 1990 and 1997.\n    // JIS X 0212 - Supplementary plane of 6067 chars in 94x94 plane. 1990. Effectively dead.\n    // JIS X 0213 - Extension and modern replacement of 0208 and 0212. Total chars: 11233.\n    //              2 planes, first is superset of 0208, second - revised 0212.\n    //              Introduced in 2000, revised 2004. Some characters are in Unicode Plane 2 (0x2xxxx)\n    // Byte encodings are:\n    //  * Shift_JIS: Compatible with 0201, uses not defined chars in top half as lead bytes for double-byte\n    //               encoding of 0208. Lead byte ranges: 0x81-0x9F, 0xE0-0xEF; Trail byte ranges: 0x40-0x7E, 0x80-0x9E, 0x9F-0xFC.\n    //               Windows CP932 is a superset of Shift_JIS. Some companies added more chars, notably KDDI.\n    //  * EUC-JP:    Up to 3 bytes per character. Used mostly on *nixes.\n    //               0x00-0x7F       - lower part of 0201\n    //               0x8E, 0xA1-0xDF - upper part of 0201\n    //               (0xA1-0xFE)x2   - 0208 plane (94x94).\n    //               0x8F, (0xA1-0xFE)x2 - 0212 plane (94x94).\n    //  * JIS X 208: 7-bit, direct encoding of 0208. Byte ranges: 0x21-0x7E (94 values). Uncommon.\n    //               Used as-is in ISO2022 family.\n    //  * ISO2022-JP: Stateful encoding, with escape sequences to switch between ASCII, \n    //                0201-1976 Roman, 0208-1978, 0208-1983.\n    //  * ISO2022-JP-1: Adds esc seq for 0212-1990.\n    //  * ISO2022-JP-2: Adds esc seq for GB2313-1980, KSX1001-1992, ISO8859-1, ISO8859-7.\n    //  * ISO2022-JP-3: Adds esc seq for 0201-1976 Kana set, 0213-2000 Planes 1, 2.\n    //  * ISO2022-JP-2004: Adds 0213-2004 Plane 1.\n    //\n    // After JIS X 0213 appeared, Shift_JIS-2004, EUC-JISX0213 and ISO2022-JP-2004 followed, with just changing the planes.\n    //\n    // Overall, it seems that it's a mess :( http://www8.plala.or.jp/tkubota1/unicode-symbols-map2.html\n    \"shiftjis\": {\n        type: \"_dbcs\",\n        table: function() {\n            return __webpack_require__(/*! ./tables/shiftjis.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/shiftjis.json\");\n        },\n        encodeAdd: {\n            \"\\xa5\": 0x5C,\n            \"‾\": 0x7E\n        },\n        encodeSkipVals: [\n            {\n                from: 0xED40,\n                to: 0xF940\n            }\n        ]\n    },\n    \"csshiftjis\": \"shiftjis\",\n    \"mskanji\": \"shiftjis\",\n    \"sjis\": \"shiftjis\",\n    \"windows31j\": \"shiftjis\",\n    \"ms31j\": \"shiftjis\",\n    \"xsjis\": \"shiftjis\",\n    \"windows932\": \"shiftjis\",\n    \"ms932\": \"shiftjis\",\n    \"932\": \"shiftjis\",\n    \"cp932\": \"shiftjis\",\n    \"eucjp\": {\n        type: \"_dbcs\",\n        table: function() {\n            return __webpack_require__(/*! ./tables/eucjp.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/eucjp.json\");\n        },\n        encodeAdd: {\n            \"\\xa5\": 0x5C,\n            \"‾\": 0x7E\n        }\n    },\n    // TODO: KDDI extension to Shift_JIS\n    // TODO: IBM CCSID 942 = CP932, but F0-F9 custom chars and other char changes.\n    // TODO: IBM CCSID 943 = Shift_JIS = CP932 with original Shift_JIS lower 128 chars.\n    // == Chinese/GBK ==========================================================\n    // http://en.wikipedia.org/wiki/GBK\n    // We mostly implement W3C recommendation: https://www.w3.org/TR/encoding/#gbk-encoder\n    // Oldest GB2312 (1981, ~7600 chars) is a subset of CP936\n    \"gb2312\": \"cp936\",\n    \"gb231280\": \"cp936\",\n    \"gb23121980\": \"cp936\",\n    \"csgb2312\": \"cp936\",\n    \"csiso58gb231280\": \"cp936\",\n    \"euccn\": \"cp936\",\n    // Microsoft's CP936 is a subset and approximation of GBK.\n    \"windows936\": \"cp936\",\n    \"ms936\": \"cp936\",\n    \"936\": \"cp936\",\n    \"cp936\": {\n        type: \"_dbcs\",\n        table: function() {\n            return __webpack_require__(/*! ./tables/cp936.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/cp936.json\");\n        }\n    },\n    // GBK (~22000 chars) is an extension of CP936 that added user-mapped chars and some other.\n    \"gbk\": {\n        type: \"_dbcs\",\n        table: function() {\n            return (__webpack_require__(/*! ./tables/cp936.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/cp936.json\").concat)(__webpack_require__(/*! ./tables/gbk-added.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/gbk-added.json\"));\n        }\n    },\n    \"xgbk\": \"gbk\",\n    \"isoir58\": \"gbk\",\n    // GB18030 is an algorithmic extension of GBK.\n    // Main source: https://www.w3.org/TR/encoding/#gbk-encoder\n    // http://icu-project.org/docs/papers/gb18030.html\n    // http://source.icu-project.org/repos/icu/data/trunk/charset/data/xml/gb-18030-2000.xml\n    // http://www.khngai.com/chinese/charmap/tblgbk.php?page=0\n    \"gb18030\": {\n        type: \"_dbcs\",\n        table: function() {\n            return (__webpack_require__(/*! ./tables/cp936.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/cp936.json\").concat)(__webpack_require__(/*! ./tables/gbk-added.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/gbk-added.json\"));\n        },\n        gb18030: function() {\n            return __webpack_require__(/*! ./tables/gb18030-ranges.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/gb18030-ranges.json\");\n        },\n        encodeSkipVals: [\n            0x80\n        ],\n        encodeAdd: {\n            \"€\": 0xA2E3\n        }\n    },\n    \"chinese\": \"gb18030\",\n    // == Korean ===============================================================\n    // EUC-KR, KS_C_5601 and KS X 1001 are exactly the same.\n    \"windows949\": \"cp949\",\n    \"ms949\": \"cp949\",\n    \"949\": \"cp949\",\n    \"cp949\": {\n        type: \"_dbcs\",\n        table: function() {\n            return __webpack_require__(/*! ./tables/cp949.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/cp949.json\");\n        }\n    },\n    \"cseuckr\": \"cp949\",\n    \"csksc56011987\": \"cp949\",\n    \"euckr\": \"cp949\",\n    \"isoir149\": \"cp949\",\n    \"korean\": \"cp949\",\n    \"ksc56011987\": \"cp949\",\n    \"ksc56011989\": \"cp949\",\n    \"ksc5601\": \"cp949\",\n    // == Big5/Taiwan/Hong Kong ================================================\n    // There are lots of tables for Big5 and cp950. Please see the following links for history:\n    // http://moztw.org/docs/big5/  http://www.haible.de/bruno/charsets/conversion-tables/Big5.html\n    // Variations, in roughly number of defined chars:\n    //  * Windows CP 950: Microsoft variant of Big5. Canonical: http://www.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP950.TXT\n    //  * Windows CP 951: Microsoft variant of Big5-HKSCS-2001. Seems to be never public. http://me.abelcheung.org/articles/research/what-is-cp951/\n    //  * Big5-2003 (Taiwan standard) almost superset of cp950.\n    //  * Unicode-at-on (UAO) / Mozilla 1.8. Falling out of use on the Web. Not supported by other browsers.\n    //  * Big5-HKSCS (-2001, -2004, -2008). Hong Kong standard. \n    //    many unicode code points moved from PUA to Supplementary plane (U+2XXXX) over the years.\n    //    Plus, it has 4 combining sequences.\n    //    Seems that Mozilla refused to support it for 10 yrs. https://bugzilla.mozilla.org/show_bug.cgi?id=162431 https://bugzilla.mozilla.org/show_bug.cgi?id=310299\n    //    because big5-hkscs is the only encoding to include astral characters in non-algorithmic way.\n    //    Implementations are not consistent within browsers; sometimes labeled as just big5.\n    //    MS Internet Explorer switches from big5 to big5-hkscs when a patch applied.\n    //    Great discussion & recap of what's going on https://bugzilla.mozilla.org/show_bug.cgi?id=912470#c31\n    //    In the encoder, it might make sense to support encoding old PUA mappings to Big5 bytes seq-s.\n    //    Official spec: http://www.ogcio.gov.hk/en/business/tech_promotion/ccli/terms/doc/2003cmp_2008.txt\n    //                   http://www.ogcio.gov.hk/tc/business/tech_promotion/ccli/terms/doc/hkscs-2008-big5-iso.txt\n    // \n    // Current understanding of how to deal with Big5(-HKSCS) is in the Encoding Standard, http://encoding.spec.whatwg.org/#big5-encoder\n    // Unicode mapping (http://www.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT) is said to be wrong.\n    \"windows950\": \"cp950\",\n    \"ms950\": \"cp950\",\n    \"950\": \"cp950\",\n    \"cp950\": {\n        type: \"_dbcs\",\n        table: function() {\n            return __webpack_require__(/*! ./tables/cp950.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/cp950.json\");\n        }\n    },\n    // Big5 has many variations and is an extension of cp950. We use Encoding Standard's as a consensus.\n    \"big5\": \"big5hkscs\",\n    \"big5hkscs\": {\n        type: \"_dbcs\",\n        table: function() {\n            return (__webpack_require__(/*! ./tables/cp950.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/cp950.json\").concat)(__webpack_require__(/*! ./tables/big5-added.json */ \"(action-browser)/./node_modules/iconv-lite/encodings/tables/big5-added.json\"));\n        },\n        encodeSkipVals: [\n            // Although Encoding Standard says we should avoid encoding to HKSCS area (See Step 1 of\n            // https://encoding.spec.whatwg.org/#index-big5-pointer), we still do it to increase compatibility with ICU.\n            // But if a single unicode point can be encoded both as HKSCS and regular Big5, we prefer the latter.\n            0x8e69,\n            0x8e6f,\n            0x8e7e,\n            0x8eab,\n            0x8eb4,\n            0x8ecd,\n            0x8ed0,\n            0x8f57,\n            0x8f69,\n            0x8f6e,\n            0x8fcb,\n            0x8ffe,\n            0x906d,\n            0x907a,\n            0x90c4,\n            0x90dc,\n            0x90f1,\n            0x91bf,\n            0x92af,\n            0x92b0,\n            0x92b1,\n            0x92b2,\n            0x92d1,\n            0x9447,\n            0x94ca,\n            0x95d9,\n            0x96fc,\n            0x9975,\n            0x9b76,\n            0x9b78,\n            0x9b7b,\n            0x9bc6,\n            0x9bde,\n            0x9bec,\n            0x9bf6,\n            0x9c42,\n            0x9c53,\n            0x9c62,\n            0x9c68,\n            0x9c6b,\n            0x9c77,\n            0x9cbc,\n            0x9cbd,\n            0x9cd0,\n            0x9d57,\n            0x9d5a,\n            0x9dc4,\n            0x9def,\n            0x9dfb,\n            0x9ea9,\n            0x9eef,\n            0x9efd,\n            0x9f60,\n            0x9fcb,\n            0xa077,\n            0xa0dc,\n            0xa0df,\n            0x8fcc,\n            0x92c8,\n            0x9644,\n            0x96ed,\n            // Step 2 of https://encoding.spec.whatwg.org/#index-big5-pointer: Use last pointer for U+2550, U+255E, U+2561, U+256A, U+5341, or U+5345\n            0xa2a4,\n            0xa2a5,\n            0xa2a7,\n            0xa2a6,\n            0xa2cc,\n            0xa2ce\n        ]\n    },\n    \"cnbig5\": \"big5hkscs\",\n    \"csbig5\": \"big5hkscs\",\n    \"xxbig5\": \"big5hkscs\"\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFjdGlvbi1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9pY29udi1saXRlL2VuY29kaW5ncy9kYmNzLWRhdGEuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFFYiw4REFBOEQ7QUFDOUQsNkVBQTZFO0FBQzdFLGdEQUFnRDtBQUVoREEsT0FBT0MsT0FBTyxHQUFHO0lBRWIsNEVBQTRFO0lBQzVFLDhEQUE4RDtJQUM5RCw0RUFBNEU7SUFDNUUsOEZBQThGO0lBQzlGLG9FQUFvRTtJQUNwRSx5RkFBeUY7SUFDekYsc0ZBQXNGO0lBQ3RGLDJFQUEyRTtJQUMzRSxrR0FBa0c7SUFFbEcsc0JBQXNCO0lBQ3RCLHVHQUF1RztJQUN2Ryw4SEFBOEg7SUFDOUgseUdBQXlHO0lBQ3pHLG9FQUFvRTtJQUNwRSxxREFBcUQ7SUFDckQscURBQXFEO0lBQ3JELHNEQUFzRDtJQUN0RCwwREFBMEQ7SUFDMUQsOEZBQThGO0lBQzlGLDhDQUE4QztJQUM5QyxvRkFBb0Y7SUFDcEYsd0RBQXdEO0lBQ3hELCtDQUErQztJQUMvQyxxRkFBcUY7SUFDckYsK0VBQStFO0lBQy9FLDhDQUE4QztJQUM5QyxFQUFFO0lBQ0YsdUhBQXVIO0lBQ3ZILEVBQUU7SUFDRixtR0FBbUc7SUFFbkcsWUFBWTtRQUNSQyxNQUFNO1FBQ05DLE9BQU87WUFBYSxPQUFPQyxtQkFBT0EsQ0FBQztRQUEwQjtRQUM3REMsV0FBVztZQUFDLFFBQVU7WUFBTSxLQUFVO1FBQUk7UUFDMUNDLGdCQUFnQjtZQUFDO2dCQUFDQyxNQUFNO2dCQUFRQyxJQUFJO1lBQU07U0FBRTtJQUNoRDtJQUNBLGNBQWM7SUFDZCxXQUFXO0lBQ1gsUUFBUTtJQUNSLGNBQWM7SUFDZCxTQUFTO0lBQ1QsU0FBUztJQUNULGNBQWM7SUFDZCxTQUFTO0lBQ1QsT0FBTztJQUNQLFNBQVM7SUFFVCxTQUFTO1FBQ0xOLE1BQU07UUFDTkMsT0FBTztZQUFhLE9BQU9DLG1CQUFPQSxDQUFDO1FBQXVCO1FBQzFEQyxXQUFXO1lBQUMsUUFBVTtZQUFNLEtBQVU7UUFBSTtJQUM5QztJQUVBLG9DQUFvQztJQUNwQyw4RUFBOEU7SUFDOUUsbUZBQW1GO0lBR25GLDRFQUE0RTtJQUM1RSxtQ0FBbUM7SUFDbkMsc0ZBQXNGO0lBRXRGLHlEQUF5RDtJQUN6RCxVQUFVO0lBQ1YsWUFBWTtJQUNaLGNBQWM7SUFDZCxZQUFZO0lBQ1osbUJBQW1CO0lBQ25CLFNBQVM7SUFFVCwwREFBMEQ7SUFDMUQsY0FBYztJQUNkLFNBQVM7SUFDVCxPQUFPO0lBQ1AsU0FBUztRQUNMSCxNQUFNO1FBQ05DLE9BQU87WUFBYSxPQUFPQyxtQkFBT0EsQ0FBQztRQUF1QjtJQUM5RDtJQUVBLDJGQUEyRjtJQUMzRixPQUFPO1FBQ0hGLE1BQU07UUFDTkMsT0FBTztZQUFhLE9BQU9DLGlJQUFxQyxDQUFDQSxtQkFBT0EsQ0FBQztRQUE0QjtJQUN6RztJQUNBLFFBQVE7SUFDUixXQUFXO0lBRVgsOENBQThDO0lBQzlDLDJEQUEyRDtJQUMzRCxrREFBa0Q7SUFDbEQsd0ZBQXdGO0lBQ3hGLDBEQUEwRDtJQUMxRCxXQUFXO1FBQ1BGLE1BQU07UUFDTkMsT0FBTztZQUFhLE9BQU9DLGlJQUFxQyxDQUFDQSxtQkFBT0EsQ0FBQztRQUE0QjtRQUNyR00sU0FBUztZQUFhLE9BQU9OLG1CQUFPQSxDQUFDO1FBQWdDO1FBQ3JFRSxnQkFBZ0I7WUFBQztTQUFLO1FBQ3RCRCxXQUFXO1lBQUMsS0FBSztRQUFNO0lBQzNCO0lBRUEsV0FBVztJQUdYLDRFQUE0RTtJQUM1RSx3REFBd0Q7SUFDeEQsY0FBYztJQUNkLFNBQVM7SUFDVCxPQUFPO0lBQ1AsU0FBUztRQUNMSCxNQUFNO1FBQ05DLE9BQU87WUFBYSxPQUFPQyxtQkFBT0EsQ0FBQztRQUF1QjtJQUM5RDtJQUVBLFdBQVc7SUFDWCxpQkFBaUI7SUFDakIsU0FBUztJQUNULFlBQVk7SUFDWixVQUFVO0lBQ1YsZUFBZTtJQUNmLGVBQWU7SUFDZixXQUFXO0lBR1gsNEVBQTRFO0lBQzVFLDJGQUEyRjtJQUMzRiwrRkFBK0Y7SUFDL0Ysa0RBQWtEO0lBQ2xELG1JQUFtSTtJQUNuSSwrSUFBK0k7SUFDL0ksMkRBQTJEO0lBQzNELHdHQUF3RztJQUN4Ryw0REFBNEQ7SUFDNUQsOEZBQThGO0lBQzlGLHlDQUF5QztJQUN6QyxrS0FBa0s7SUFDbEssa0dBQWtHO0lBQ2xHLHlGQUF5RjtJQUN6RixpRkFBaUY7SUFDakYseUdBQXlHO0lBQ3pHLG1HQUFtRztJQUNuRyx1R0FBdUc7SUFDdkcsOEdBQThHO0lBQzlHLEdBQUc7SUFDSCxvSUFBb0k7SUFDcEksaUhBQWlIO0lBRWpILGNBQWM7SUFDZCxTQUFTO0lBQ1QsT0FBTztJQUNQLFNBQVM7UUFDTEYsTUFBTTtRQUNOQyxPQUFPO1lBQWEsT0FBT0MsbUJBQU9BLENBQUM7UUFBdUI7SUFDOUQ7SUFFQSxvR0FBb0c7SUFDcEcsUUFBUTtJQUNSLGFBQWE7UUFDVEYsTUFBTTtRQUNOQyxPQUFPO1lBQWEsT0FBT0MsaUlBQXFDLENBQUNBLG1CQUFPQSxDQUFDO1FBQTZCO1FBQ3RHRSxnQkFBZ0I7WUFDWix3RkFBd0Y7WUFDeEYsNEdBQTRHO1lBQzVHLHFHQUFxRztZQUNyRztZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFDeEY7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFDaEc7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFDaEc7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFDaEc7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFFeEUseUlBQXlJO1lBQ3pJO1lBQVE7WUFBUTtZQUFRO1lBQVE7WUFBUTtTQUMzQztJQUNMO0lBRUEsVUFBVTtJQUNWLFVBQVU7SUFDVixVQUFVO0FBQ2QiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9teS1kcml2ZS8uL25vZGVfbW9kdWxlcy9pY29udi1saXRlL2VuY29kaW5ncy9kYmNzLWRhdGEuanM/MGFmNyJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcblxuLy8gRGVzY3JpcHRpb24gb2Ygc3VwcG9ydGVkIGRvdWJsZSBieXRlIGVuY29kaW5ncyBhbmQgYWxpYXNlcy5cbi8vIFRhYmxlcyBhcmUgbm90IHJlcXVpcmUoKS1kIHVudGlsIHRoZXkgYXJlIG5lZWRlZCB0byBzcGVlZCB1cCBsaWJyYXJ5IGxvYWQuXG4vLyByZXF1aXJlKCktcyBhcmUgZGlyZWN0IHRvIHN1cHBvcnQgQnJvd3NlcmlmeS5cblxubW9kdWxlLmV4cG9ydHMgPSB7XG4gICAgXG4gICAgLy8gPT0gSmFwYW5lc2UvU2hpZnRKSVMgPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuICAgIC8vIEFsbCBqYXBhbmVzZSBlbmNvZGluZ3MgYXJlIGJhc2VkIG9uIEpJUyBYIHNldCBvZiBzdGFuZGFyZHM6XG4gICAgLy8gSklTIFggMDIwMSAtIFNpbmdsZS1ieXRlIGVuY29kaW5nIG9mIEFTQ0lJICsgwqUgKyBLYW5hIGNoYXJzIGF0IDB4QTEtMHhERi5cbiAgICAvLyBKSVMgWCAwMjA4IC0gTWFpbiBzZXQgb2YgNjg3OSBjaGFyYWN0ZXJzLCBwbGFjZWQgaW4gOTR4OTQgcGxhbmUsIHRvIGJlIGVuY29kZWQgYnkgMiBieXRlcy4gXG4gICAgLy8gICAgICAgICAgICAgIEhhcyBzZXZlcmFsIHZhcmlhdGlvbnMgaW4gMTk3OCwgMTk4MywgMTk5MCBhbmQgMTk5Ny5cbiAgICAvLyBKSVMgWCAwMjEyIC0gU3VwcGxlbWVudGFyeSBwbGFuZSBvZiA2MDY3IGNoYXJzIGluIDk0eDk0IHBsYW5lLiAxOTkwLiBFZmZlY3RpdmVseSBkZWFkLlxuICAgIC8vIEpJUyBYIDAyMTMgLSBFeHRlbnNpb24gYW5kIG1vZGVybiByZXBsYWNlbWVudCBvZiAwMjA4IGFuZCAwMjEyLiBUb3RhbCBjaGFyczogMTEyMzMuXG4gICAgLy8gICAgICAgICAgICAgIDIgcGxhbmVzLCBmaXJzdCBpcyBzdXBlcnNldCBvZiAwMjA4LCBzZWNvbmQgLSByZXZpc2VkIDAyMTIuXG4gICAgLy8gICAgICAgICAgICAgIEludHJvZHVjZWQgaW4gMjAwMCwgcmV2aXNlZCAyMDA0LiBTb21lIGNoYXJhY3RlcnMgYXJlIGluIFVuaWNvZGUgUGxhbmUgMiAoMHgyeHh4eClcblxuICAgIC8vIEJ5dGUgZW5jb2RpbmdzIGFyZTpcbiAgICAvLyAgKiBTaGlmdF9KSVM6IENvbXBhdGlibGUgd2l0aCAwMjAxLCB1c2VzIG5vdCBkZWZpbmVkIGNoYXJzIGluIHRvcCBoYWxmIGFzIGxlYWQgYnl0ZXMgZm9yIGRvdWJsZS1ieXRlXG4gICAgLy8gICAgICAgICAgICAgICBlbmNvZGluZyBvZiAwMjA4LiBMZWFkIGJ5dGUgcmFuZ2VzOiAweDgxLTB4OUYsIDB4RTAtMHhFRjsgVHJhaWwgYnl0ZSByYW5nZXM6IDB4NDAtMHg3RSwgMHg4MC0weDlFLCAweDlGLTB4RkMuXG4gICAgLy8gICAgICAgICAgICAgICBXaW5kb3dzIENQOTMyIGlzIGEgc3VwZXJzZXQgb2YgU2hpZnRfSklTLiBTb21lIGNvbXBhbmllcyBhZGRlZCBtb3JlIGNoYXJzLCBub3RhYmx5IEtEREkuXG4gICAgLy8gICogRVVDLUpQOiAgICBVcCB0byAzIGJ5dGVzIHBlciBjaGFyYWN0ZXIuIFVzZWQgbW9zdGx5IG9uICpuaXhlcy5cbiAgICAvLyAgICAgICAgICAgICAgIDB4MDAtMHg3RiAgICAgICAtIGxvd2VyIHBhcnQgb2YgMDIwMVxuICAgIC8vICAgICAgICAgICAgICAgMHg4RSwgMHhBMS0weERGIC0gdXBwZXIgcGFydCBvZiAwMjAxXG4gICAgLy8gICAgICAgICAgICAgICAoMHhBMS0weEZFKXgyICAgLSAwMjA4IHBsYW5lICg5NHg5NCkuXG4gICAgLy8gICAgICAgICAgICAgICAweDhGLCAoMHhBMS0weEZFKXgyIC0gMDIxMiBwbGFuZSAoOTR4OTQpLlxuICAgIC8vICAqIEpJUyBYIDIwODogNy1iaXQsIGRpcmVjdCBlbmNvZGluZyBvZiAwMjA4LiBCeXRlIHJhbmdlczogMHgyMS0weDdFICg5NCB2YWx1ZXMpLiBVbmNvbW1vbi5cbiAgICAvLyAgICAgICAgICAgICAgIFVzZWQgYXMtaXMgaW4gSVNPMjAyMiBmYW1pbHkuXG4gICAgLy8gICogSVNPMjAyMi1KUDogU3RhdGVmdWwgZW5jb2RpbmcsIHdpdGggZXNjYXBlIHNlcXVlbmNlcyB0byBzd2l0Y2ggYmV0d2VlbiBBU0NJSSwgXG4gICAgLy8gICAgICAgICAgICAgICAgMDIwMS0xOTc2IFJvbWFuLCAwMjA4LTE5NzgsIDAyMDgtMTk4My5cbiAgICAvLyAgKiBJU08yMDIyLUpQLTE6IEFkZHMgZXNjIHNlcSBmb3IgMDIxMi0xOTkwLlxuICAgIC8vICAqIElTTzIwMjItSlAtMjogQWRkcyBlc2Mgc2VxIGZvciBHQjIzMTMtMTk4MCwgS1NYMTAwMS0xOTkyLCBJU084ODU5LTEsIElTTzg4NTktNy5cbiAgICAvLyAgKiBJU08yMDIyLUpQLTM6IEFkZHMgZXNjIHNlcSBmb3IgMDIwMS0xOTc2IEthbmEgc2V0LCAwMjEzLTIwMDAgUGxhbmVzIDEsIDIuXG4gICAgLy8gICogSVNPMjAyMi1KUC0yMDA0OiBBZGRzIDAyMTMtMjAwNCBQbGFuZSAxLlxuICAgIC8vXG4gICAgLy8gQWZ0ZXIgSklTIFggMDIxMyBhcHBlYXJlZCwgU2hpZnRfSklTLTIwMDQsIEVVQy1KSVNYMDIxMyBhbmQgSVNPMjAyMi1KUC0yMDA0IGZvbGxvd2VkLCB3aXRoIGp1c3QgY2hhbmdpbmcgdGhlIHBsYW5lcy5cbiAgICAvL1xuICAgIC8vIE92ZXJhbGwsIGl0IHNlZW1zIHRoYXQgaXQncyBhIG1lc3MgOiggaHR0cDovL3d3dzgucGxhbGEub3IuanAvdGt1Ym90YTEvdW5pY29kZS1zeW1ib2xzLW1hcDIuaHRtbFxuXG4gICAgJ3NoaWZ0amlzJzoge1xuICAgICAgICB0eXBlOiAnX2RiY3MnLFxuICAgICAgICB0YWJsZTogZnVuY3Rpb24oKSB7IHJldHVybiByZXF1aXJlKCcuL3RhYmxlcy9zaGlmdGppcy5qc29uJykgfSxcbiAgICAgICAgZW5jb2RlQWRkOiB7J1xcdTAwYTUnOiAweDVDLCAnXFx1MjAzRSc6IDB4N0V9LFxuICAgICAgICBlbmNvZGVTa2lwVmFsczogW3tmcm9tOiAweEVENDAsIHRvOiAweEY5NDB9XSxcbiAgICB9LFxuICAgICdjc3NoaWZ0amlzJzogJ3NoaWZ0amlzJyxcbiAgICAnbXNrYW5qaSc6ICdzaGlmdGppcycsXG4gICAgJ3NqaXMnOiAnc2hpZnRqaXMnLFxuICAgICd3aW5kb3dzMzFqJzogJ3NoaWZ0amlzJyxcbiAgICAnbXMzMWonOiAnc2hpZnRqaXMnLFxuICAgICd4c2ppcyc6ICdzaGlmdGppcycsXG4gICAgJ3dpbmRvd3M5MzInOiAnc2hpZnRqaXMnLFxuICAgICdtczkzMic6ICdzaGlmdGppcycsXG4gICAgJzkzMic6ICdzaGlmdGppcycsXG4gICAgJ2NwOTMyJzogJ3NoaWZ0amlzJyxcblxuICAgICdldWNqcCc6IHtcbiAgICAgICAgdHlwZTogJ19kYmNzJyxcbiAgICAgICAgdGFibGU6IGZ1bmN0aW9uKCkgeyByZXR1cm4gcmVxdWlyZSgnLi90YWJsZXMvZXVjanAuanNvbicpIH0sXG4gICAgICAgIGVuY29kZUFkZDogeydcXHUwMGE1JzogMHg1QywgJ1xcdTIwM0UnOiAweDdFfSxcbiAgICB9LFxuXG4gICAgLy8gVE9ETzogS0RESSBleHRlbnNpb24gdG8gU2hpZnRfSklTXG4gICAgLy8gVE9ETzogSUJNIENDU0lEIDk0MiA9IENQOTMyLCBidXQgRjAtRjkgY3VzdG9tIGNoYXJzIGFuZCBvdGhlciBjaGFyIGNoYW5nZXMuXG4gICAgLy8gVE9ETzogSUJNIENDU0lEIDk0MyA9IFNoaWZ0X0pJUyA9IENQOTMyIHdpdGggb3JpZ2luYWwgU2hpZnRfSklTIGxvd2VyIDEyOCBjaGFycy5cblxuXG4gICAgLy8gPT0gQ2hpbmVzZS9HQksgPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuICAgIC8vIGh0dHA6Ly9lbi53aWtpcGVkaWEub3JnL3dpa2kvR0JLXG4gICAgLy8gV2UgbW9zdGx5IGltcGxlbWVudCBXM0MgcmVjb21tZW5kYXRpb246IGh0dHBzOi8vd3d3LnczLm9yZy9UUi9lbmNvZGluZy8jZ2JrLWVuY29kZXJcblxuICAgIC8vIE9sZGVzdCBHQjIzMTIgKDE5ODEsIH43NjAwIGNoYXJzKSBpcyBhIHN1YnNldCBvZiBDUDkzNlxuICAgICdnYjIzMTInOiAnY3A5MzYnLFxuICAgICdnYjIzMTI4MCc6ICdjcDkzNicsXG4gICAgJ2diMjMxMjE5ODAnOiAnY3A5MzYnLFxuICAgICdjc2diMjMxMic6ICdjcDkzNicsXG4gICAgJ2NzaXNvNThnYjIzMTI4MCc6ICdjcDkzNicsXG4gICAgJ2V1Y2NuJzogJ2NwOTM2JyxcblxuICAgIC8vIE1pY3Jvc29mdCdzIENQOTM2IGlzIGEgc3Vic2V0IGFuZCBhcHByb3hpbWF0aW9uIG9mIEdCSy5cbiAgICAnd2luZG93czkzNic6ICdjcDkzNicsXG4gICAgJ21zOTM2JzogJ2NwOTM2JyxcbiAgICAnOTM2JzogJ2NwOTM2JyxcbiAgICAnY3A5MzYnOiB7XG4gICAgICAgIHR5cGU6ICdfZGJjcycsXG4gICAgICAgIHRhYmxlOiBmdW5jdGlvbigpIHsgcmV0dXJuIHJlcXVpcmUoJy4vdGFibGVzL2NwOTM2Lmpzb24nKSB9LFxuICAgIH0sXG5cbiAgICAvLyBHQksgKH4yMjAwMCBjaGFycykgaXMgYW4gZXh0ZW5zaW9uIG9mIENQOTM2IHRoYXQgYWRkZWQgdXNlci1tYXBwZWQgY2hhcnMgYW5kIHNvbWUgb3RoZXIuXG4gICAgJ2diayc6IHtcbiAgICAgICAgdHlwZTogJ19kYmNzJyxcbiAgICAgICAgdGFibGU6IGZ1bmN0aW9uKCkgeyByZXR1cm4gcmVxdWlyZSgnLi90YWJsZXMvY3A5MzYuanNvbicpLmNvbmNhdChyZXF1aXJlKCcuL3RhYmxlcy9nYmstYWRkZWQuanNvbicpKSB9LFxuICAgIH0sXG4gICAgJ3hnYmsnOiAnZ2JrJyxcbiAgICAnaXNvaXI1OCc6ICdnYmsnLFxuXG4gICAgLy8gR0IxODAzMCBpcyBhbiBhbGdvcml0aG1pYyBleHRlbnNpb24gb2YgR0JLLlxuICAgIC8vIE1haW4gc291cmNlOiBodHRwczovL3d3dy53My5vcmcvVFIvZW5jb2RpbmcvI2diay1lbmNvZGVyXG4gICAgLy8gaHR0cDovL2ljdS1wcm9qZWN0Lm9yZy9kb2NzL3BhcGVycy9nYjE4MDMwLmh0bWxcbiAgICAvLyBodHRwOi8vc291cmNlLmljdS1wcm9qZWN0Lm9yZy9yZXBvcy9pY3UvZGF0YS90cnVuay9jaGFyc2V0L2RhdGEveG1sL2diLTE4MDMwLTIwMDAueG1sXG4gICAgLy8gaHR0cDovL3d3dy5raG5nYWkuY29tL2NoaW5lc2UvY2hhcm1hcC90YmxnYmsucGhwP3BhZ2U9MFxuICAgICdnYjE4MDMwJzoge1xuICAgICAgICB0eXBlOiAnX2RiY3MnLFxuICAgICAgICB0YWJsZTogZnVuY3Rpb24oKSB7IHJldHVybiByZXF1aXJlKCcuL3RhYmxlcy9jcDkzNi5qc29uJykuY29uY2F0KHJlcXVpcmUoJy4vdGFibGVzL2diay1hZGRlZC5qc29uJykpIH0sXG4gICAgICAgIGdiMTgwMzA6IGZ1bmN0aW9uKCkgeyByZXR1cm4gcmVxdWlyZSgnLi90YWJsZXMvZ2IxODAzMC1yYW5nZXMuanNvbicpIH0sXG4gICAgICAgIGVuY29kZVNraXBWYWxzOiBbMHg4MF0sXG4gICAgICAgIGVuY29kZUFkZDogeyfigqwnOiAweEEyRTN9LFxuICAgIH0sXG5cbiAgICAnY2hpbmVzZSc6ICdnYjE4MDMwJyxcblxuXG4gICAgLy8gPT0gS29yZWFuID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuICAgIC8vIEVVQy1LUiwgS1NfQ181NjAxIGFuZCBLUyBYIDEwMDEgYXJlIGV4YWN0bHkgdGhlIHNhbWUuXG4gICAgJ3dpbmRvd3M5NDknOiAnY3A5NDknLFxuICAgICdtczk0OSc6ICdjcDk0OScsXG4gICAgJzk0OSc6ICdjcDk0OScsXG4gICAgJ2NwOTQ5Jzoge1xuICAgICAgICB0eXBlOiAnX2RiY3MnLFxuICAgICAgICB0YWJsZTogZnVuY3Rpb24oKSB7IHJldHVybiByZXF1aXJlKCcuL3RhYmxlcy9jcDk0OS5qc29uJykgfSxcbiAgICB9LFxuXG4gICAgJ2NzZXVja3InOiAnY3A5NDknLFxuICAgICdjc2tzYzU2MDExOTg3JzogJ2NwOTQ5JyxcbiAgICAnZXVja3InOiAnY3A5NDknLFxuICAgICdpc29pcjE0OSc6ICdjcDk0OScsXG4gICAgJ2tvcmVhbic6ICdjcDk0OScsXG4gICAgJ2tzYzU2MDExOTg3JzogJ2NwOTQ5JyxcbiAgICAna3NjNTYwMTE5ODknOiAnY3A5NDknLFxuICAgICdrc2M1NjAxJzogJ2NwOTQ5JyxcblxuXG4gICAgLy8gPT0gQmlnNS9UYWl3YW4vSG9uZyBLb25nID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuICAgIC8vIFRoZXJlIGFyZSBsb3RzIG9mIHRhYmxlcyBmb3IgQmlnNSBhbmQgY3A5NTAuIFBsZWFzZSBzZWUgdGhlIGZvbGxvd2luZyBsaW5rcyBmb3IgaGlzdG9yeTpcbiAgICAvLyBodHRwOi8vbW96dHcub3JnL2RvY3MvYmlnNS8gIGh0dHA6Ly93d3cuaGFpYmxlLmRlL2JydW5vL2NoYXJzZXRzL2NvbnZlcnNpb24tdGFibGVzL0JpZzUuaHRtbFxuICAgIC8vIFZhcmlhdGlvbnMsIGluIHJvdWdobHkgbnVtYmVyIG9mIGRlZmluZWQgY2hhcnM6XG4gICAgLy8gICogV2luZG93cyBDUCA5NTA6IE1pY3Jvc29mdCB2YXJpYW50IG9mIEJpZzUuIENhbm9uaWNhbDogaHR0cDovL3d3dy51bmljb2RlLm9yZy9QdWJsaWMvTUFQUElOR1MvVkVORE9SUy9NSUNTRlQvV0lORE9XUy9DUDk1MC5UWFRcbiAgICAvLyAgKiBXaW5kb3dzIENQIDk1MTogTWljcm9zb2Z0IHZhcmlhbnQgb2YgQmlnNS1IS1NDUy0yMDAxLiBTZWVtcyB0byBiZSBuZXZlciBwdWJsaWMuIGh0dHA6Ly9tZS5hYmVsY2hldW5nLm9yZy9hcnRpY2xlcy9yZXNlYXJjaC93aGF0LWlzLWNwOTUxL1xuICAgIC8vICAqIEJpZzUtMjAwMyAoVGFpd2FuIHN0YW5kYXJkKSBhbG1vc3Qgc3VwZXJzZXQgb2YgY3A5NTAuXG4gICAgLy8gICogVW5pY29kZS1hdC1vbiAoVUFPKSAvIE1vemlsbGEgMS44LiBGYWxsaW5nIG91dCBvZiB1c2Ugb24gdGhlIFdlYi4gTm90IHN1cHBvcnRlZCBieSBvdGhlciBicm93c2Vycy5cbiAgICAvLyAgKiBCaWc1LUhLU0NTICgtMjAwMSwgLTIwMDQsIC0yMDA4KS4gSG9uZyBLb25nIHN0YW5kYXJkLiBcbiAgICAvLyAgICBtYW55IHVuaWNvZGUgY29kZSBwb2ludHMgbW92ZWQgZnJvbSBQVUEgdG8gU3VwcGxlbWVudGFyeSBwbGFuZSAoVSsyWFhYWCkgb3ZlciB0aGUgeWVhcnMuXG4gICAgLy8gICAgUGx1cywgaXQgaGFzIDQgY29tYmluaW5nIHNlcXVlbmNlcy5cbiAgICAvLyAgICBTZWVtcyB0aGF0IE1vemlsbGEgcmVmdXNlZCB0byBzdXBwb3J0IGl0IGZvciAxMCB5cnMuIGh0dHBzOi8vYnVnemlsbGEubW96aWxsYS5vcmcvc2hvd19idWcuY2dpP2lkPTE2MjQzMSBodHRwczovL2J1Z3ppbGxhLm1vemlsbGEub3JnL3Nob3dfYnVnLmNnaT9pZD0zMTAyOTlcbiAgICAvLyAgICBiZWNhdXNlIGJpZzUtaGtzY3MgaXMgdGhlIG9ubHkgZW5jb2RpbmcgdG8gaW5jbHVkZSBhc3RyYWwgY2hhcmFjdGVycyBpbiBub24tYWxnb3JpdGhtaWMgd2F5LlxuICAgIC8vICAgIEltcGxlbWVudGF0aW9ucyBhcmUgbm90IGNvbnNpc3RlbnQgd2l0aGluIGJyb3dzZXJzOyBzb21ldGltZXMgbGFiZWxlZCBhcyBqdXN0IGJpZzUuXG4gICAgLy8gICAgTVMgSW50ZXJuZXQgRXhwbG9yZXIgc3dpdGNoZXMgZnJvbSBiaWc1IHRvIGJpZzUtaGtzY3Mgd2hlbiBhIHBhdGNoIGFwcGxpZWQuXG4gICAgLy8gICAgR3JlYXQgZGlzY3Vzc2lvbiAmIHJlY2FwIG9mIHdoYXQncyBnb2luZyBvbiBodHRwczovL2J1Z3ppbGxhLm1vemlsbGEub3JnL3Nob3dfYnVnLmNnaT9pZD05MTI0NzAjYzMxXG4gICAgLy8gICAgSW4gdGhlIGVuY29kZXIsIGl0IG1pZ2h0IG1ha2Ugc2Vuc2UgdG8gc3VwcG9ydCBlbmNvZGluZyBvbGQgUFVBIG1hcHBpbmdzIHRvIEJpZzUgYnl0ZXMgc2VxLXMuXG4gICAgLy8gICAgT2ZmaWNpYWwgc3BlYzogaHR0cDovL3d3dy5vZ2Npby5nb3YuaGsvZW4vYnVzaW5lc3MvdGVjaF9wcm9tb3Rpb24vY2NsaS90ZXJtcy9kb2MvMjAwM2NtcF8yMDA4LnR4dFxuICAgIC8vICAgICAgICAgICAgICAgICAgIGh0dHA6Ly93d3cub2djaW8uZ292LmhrL3RjL2J1c2luZXNzL3RlY2hfcHJvbW90aW9uL2NjbGkvdGVybXMvZG9jL2hrc2NzLTIwMDgtYmlnNS1pc28udHh0XG4gICAgLy8gXG4gICAgLy8gQ3VycmVudCB1bmRlcnN0YW5kaW5nIG9mIGhvdyB0byBkZWFsIHdpdGggQmlnNSgtSEtTQ1MpIGlzIGluIHRoZSBFbmNvZGluZyBTdGFuZGFyZCwgaHR0cDovL2VuY29kaW5nLnNwZWMud2hhdHdnLm9yZy8jYmlnNS1lbmNvZGVyXG4gICAgLy8gVW5pY29kZSBtYXBwaW5nIChodHRwOi8vd3d3LnVuaWNvZGUub3JnL1B1YmxpYy9NQVBQSU5HUy9PQlNPTEVURS9FQVNUQVNJQS9PVEhFUi9CSUc1LlRYVCkgaXMgc2FpZCB0byBiZSB3cm9uZy5cblxuICAgICd3aW5kb3dzOTUwJzogJ2NwOTUwJyxcbiAgICAnbXM5NTAnOiAnY3A5NTAnLFxuICAgICc5NTAnOiAnY3A5NTAnLFxuICAgICdjcDk1MCc6IHtcbiAgICAgICAgdHlwZTogJ19kYmNzJyxcbiAgICAgICAgdGFibGU6IGZ1bmN0aW9uKCkgeyByZXR1cm4gcmVxdWlyZSgnLi90YWJsZXMvY3A5NTAuanNvbicpIH0sXG4gICAgfSxcblxuICAgIC8vIEJpZzUgaGFzIG1hbnkgdmFyaWF0aW9ucyBhbmQgaXMgYW4gZXh0ZW5zaW9uIG9mIGNwOTUwLiBXZSB1c2UgRW5jb2RpbmcgU3RhbmRhcmQncyBhcyBhIGNvbnNlbnN1cy5cbiAgICAnYmlnNSc6ICdiaWc1aGtzY3MnLFxuICAgICdiaWc1aGtzY3MnOiB7XG4gICAgICAgIHR5cGU6ICdfZGJjcycsXG4gICAgICAgIHRhYmxlOiBmdW5jdGlvbigpIHsgcmV0dXJuIHJlcXVpcmUoJy4vdGFibGVzL2NwOTUwLmpzb24nKS5jb25jYXQocmVxdWlyZSgnLi90YWJsZXMvYmlnNS1hZGRlZC5qc29uJykpIH0sXG4gICAgICAgIGVuY29kZVNraXBWYWxzOiBbXG4gICAgICAgICAgICAvLyBBbHRob3VnaCBFbmNvZGluZyBTdGFuZGFyZCBzYXlzIHdlIHNob3VsZCBhdm9pZCBlbmNvZGluZyB0byBIS1NDUyBhcmVhIChTZWUgU3RlcCAxIG9mXG4gICAgICAgICAgICAvLyBodHRwczovL2VuY29kaW5nLnNwZWMud2hhdHdnLm9yZy8jaW5kZXgtYmlnNS1wb2ludGVyKSwgd2Ugc3RpbGwgZG8gaXQgdG8gaW5jcmVhc2UgY29tcGF0aWJpbGl0eSB3aXRoIElDVS5cbiAgICAgICAgICAgIC8vIEJ1dCBpZiBhIHNpbmdsZSB1bmljb2RlIHBvaW50IGNhbiBiZSBlbmNvZGVkIGJvdGggYXMgSEtTQ1MgYW5kIHJlZ3VsYXIgQmlnNSwgd2UgcHJlZmVyIHRoZSBsYXR0ZXIuXG4gICAgICAgICAgICAweDhlNjksIDB4OGU2ZiwgMHg4ZTdlLCAweDhlYWIsIDB4OGViNCwgMHg4ZWNkLCAweDhlZDAsIDB4OGY1NywgMHg4ZjY5LCAweDhmNmUsIDB4OGZjYiwgMHg4ZmZlLFxuICAgICAgICAgICAgMHg5MDZkLCAweDkwN2EsIDB4OTBjNCwgMHg5MGRjLCAweDkwZjEsIDB4OTFiZiwgMHg5MmFmLCAweDkyYjAsIDB4OTJiMSwgMHg5MmIyLCAweDkyZDEsIDB4OTQ0NywgMHg5NGNhLFxuICAgICAgICAgICAgMHg5NWQ5LCAweDk2ZmMsIDB4OTk3NSwgMHg5Yjc2LCAweDliNzgsIDB4OWI3YiwgMHg5YmM2LCAweDliZGUsIDB4OWJlYywgMHg5YmY2LCAweDljNDIsIDB4OWM1MywgMHg5YzYyLFxuICAgICAgICAgICAgMHg5YzY4LCAweDljNmIsIDB4OWM3NywgMHg5Y2JjLCAweDljYmQsIDB4OWNkMCwgMHg5ZDU3LCAweDlkNWEsIDB4OWRjNCwgMHg5ZGVmLCAweDlkZmIsIDB4OWVhOSwgMHg5ZWVmLFxuICAgICAgICAgICAgMHg5ZWZkLCAweDlmNjAsIDB4OWZjYiwgMHhhMDc3LCAweGEwZGMsIDB4YTBkZiwgMHg4ZmNjLCAweDkyYzgsIDB4OTY0NCwgMHg5NmVkLFxuXG4gICAgICAgICAgICAvLyBTdGVwIDIgb2YgaHR0cHM6Ly9lbmNvZGluZy5zcGVjLndoYXR3Zy5vcmcvI2luZGV4LWJpZzUtcG9pbnRlcjogVXNlIGxhc3QgcG9pbnRlciBmb3IgVSsyNTUwLCBVKzI1NUUsIFUrMjU2MSwgVSsyNTZBLCBVKzUzNDEsIG9yIFUrNTM0NVxuICAgICAgICAgICAgMHhhMmE0LCAweGEyYTUsIDB4YTJhNywgMHhhMmE2LCAweGEyY2MsIDB4YTJjZSxcbiAgICAgICAgXSxcbiAgICB9LFxuXG4gICAgJ2NuYmlnNSc6ICdiaWc1aGtzY3MnLFxuICAgICdjc2JpZzUnOiAnYmlnNWhrc2NzJyxcbiAgICAneHhiaWc1JzogJ2JpZzVoa3NjcycsXG59O1xuIl0sIm5hbWVzIjpbIm1vZHVsZSIsImV4cG9ydHMiLCJ0eXBlIiwidGFibGUiLCJyZXF1aXJlIiwiZW5jb2RlQWRkIiwiZW5jb2RlU2tpcFZhbHMiLCJmcm9tIiwidG8iLCJjb25jYXQiLCJnYjE4MDMwIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/dbcs-data.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/index.js":
/*!****************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\n// Update this array if you add/rename/remove files in this directory.\n// We support Browserify by skipping automatic module discovery and requiring modules directly.\nvar modules = [\n    __webpack_require__(/*! ./internal */ \"(action-browser)/./node_modules/iconv-lite/encodings/internal.js\"),\n    __webpack_require__(/*! ./utf32 */ \"(action-browser)/./node_modules/iconv-lite/encodings/utf32.js\"),\n    __webpack_require__(/*! ./utf16 */ \"(action-browser)/./node_modules/iconv-lite/encodings/utf16.js\"),\n    __webpack_require__(/*! ./utf7 */ \"(action-browser)/./node_modules/iconv-lite/encodings/utf7.js\"),\n    __webpack_require__(/*! ./sbcs-codec */ \"(action-browser)/./node_modules/iconv-lite/encodings/sbcs-codec.js\"),\n    __webpack_require__(/*! ./sbcs-data */ \"(action-browser)/./node_modules/iconv-lite/encodings/sbcs-data.js\"),\n    __webpack_require__(/*! ./sbcs-data-generated */ \"(action-browser)/./node_modules/iconv-lite/encodings/sbcs-data-generated.js\"),\n    __webpack_require__(/*! ./dbcs-codec */ \"(action-browser)/./node_modules/iconv-lite/encodings/dbcs-codec.js\"),\n    __webpack_require__(/*! ./dbcs-data */ \"(action-browser)/./node_modules/iconv-lite/encodings/dbcs-data.js\")\n];\n// Put all encoding/alias/codec definitions to single object and export it.\nfor(var i = 0; i < modules.length; i++){\n    var module = modules[i];\n    for(var enc in module)if (Object.prototype.hasOwnProperty.call(module, enc)) exports[enc] = module[enc];\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/index.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/internal.js":
/*!*******************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/internal.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// Export Node.js internal encodings.\nmodule.exports = {\n    // Encodings\n    utf8: {\n        type: \"_internal\",\n        bomAware: true\n    },\n    cesu8: {\n        type: \"_internal\",\n        bomAware: true\n    },\n    unicode11utf8: \"utf8\",\n    ucs2: {\n        type: \"_internal\",\n        bomAware: true\n    },\n    utf16le: \"ucs2\",\n    binary: {\n        type: \"_internal\"\n    },\n    base64: {\n        type: \"_internal\"\n    },\n    hex: {\n        type: \"_internal\"\n    },\n    // Codec.\n    _internal: InternalCodec\n};\n//------------------------------------------------------------------------------\nfunction InternalCodec(codecOptions, iconv) {\n    this.enc = codecOptions.encodingName;\n    this.bomAware = codecOptions.bomAware;\n    if (this.enc === \"base64\") this.encoder = InternalEncoderBase64;\n    else if (this.enc === \"cesu8\") {\n        this.enc = \"utf8\"; // Use utf8 for decoding.\n        this.encoder = InternalEncoderCesu8;\n        // Add decoder for versions of Node not supporting CESU-8\n        if (Buffer.from(\"eda0bdedb2a9\", \"hex\").toString() !== \"\\uD83D\\uDCA9\") {\n            this.decoder = InternalDecoderCesu8;\n            this.defaultCharUnicode = iconv.defaultCharUnicode;\n        }\n    }\n}\nInternalCodec.prototype.encoder = InternalEncoder;\nInternalCodec.prototype.decoder = InternalDecoder;\n//------------------------------------------------------------------------------\n// We use node.js internal decoder. Its signature is the same as ours.\nvar StringDecoder = (__webpack_require__(/*! string_decoder */ \"string_decoder\").StringDecoder);\nif (!StringDecoder.prototype.end) StringDecoder.prototype.end = function() {};\nfunction InternalDecoder(options, codec) {\n    this.decoder = new StringDecoder(codec.enc);\n}\nInternalDecoder.prototype.write = function(buf) {\n    if (!Buffer.isBuffer(buf)) {\n        buf = Buffer.from(buf);\n    }\n    return this.decoder.write(buf);\n};\nInternalDecoder.prototype.end = function() {\n    return this.decoder.end();\n};\n//------------------------------------------------------------------------------\n// Encoder is mostly trivial\nfunction InternalEncoder(options, codec) {\n    this.enc = codec.enc;\n}\nInternalEncoder.prototype.write = function(str) {\n    return Buffer.from(str, this.enc);\n};\nInternalEncoder.prototype.end = function() {};\n//------------------------------------------------------------------------------\n// Except base64 encoder, which must keep its state.\nfunction InternalEncoderBase64(options, codec) {\n    this.prevStr = \"\";\n}\nInternalEncoderBase64.prototype.write = function(str) {\n    str = this.prevStr + str;\n    var completeQuads = str.length - str.length % 4;\n    this.prevStr = str.slice(completeQuads);\n    str = str.slice(0, completeQuads);\n    return Buffer.from(str, \"base64\");\n};\nInternalEncoderBase64.prototype.end = function() {\n    return Buffer.from(this.prevStr, \"base64\");\n};\n//------------------------------------------------------------------------------\n// CESU-8 encoder is also special.\nfunction InternalEncoderCesu8(options, codec) {}\nInternalEncoderCesu8.prototype.write = function(str) {\n    var buf = Buffer.alloc(str.length * 3), bufIdx = 0;\n    for(var i = 0; i < str.length; i++){\n        var charCode = str.charCodeAt(i);\n        // Naive implementation, but it works because CESU-8 is especially easy\n        // to convert from UTF-16 (which all JS strings are encoded in).\n        if (charCode < 0x80) buf[bufIdx++] = charCode;\n        else if (charCode < 0x800) {\n            buf[bufIdx++] = 0xC0 + (charCode >>> 6);\n            buf[bufIdx++] = 0x80 + (charCode & 0x3f);\n        } else {\n            buf[bufIdx++] = 0xE0 + (charCode >>> 12);\n            buf[bufIdx++] = 0x80 + (charCode >>> 6 & 0x3f);\n            buf[bufIdx++] = 0x80 + (charCode & 0x3f);\n        }\n    }\n    return buf.slice(0, bufIdx);\n};\nInternalEncoderCesu8.prototype.end = function() {};\n//------------------------------------------------------------------------------\n// CESU-8 decoder is not implemented in Node v4.0+\nfunction InternalDecoderCesu8(options, codec) {\n    this.acc = 0;\n    this.contBytes = 0;\n    this.accBytes = 0;\n    this.defaultCharUnicode = codec.defaultCharUnicode;\n}\nInternalDecoderCesu8.prototype.write = function(buf) {\n    var acc = this.acc, contBytes = this.contBytes, accBytes = this.accBytes, res = \"\";\n    for(var i = 0; i < buf.length; i++){\n        var curByte = buf[i];\n        if ((curByte & 0xC0) !== 0x80) {\n            if (contBytes > 0) {\n                res += this.defaultCharUnicode;\n                contBytes = 0;\n            }\n            if (curByte < 0x80) {\n                res += String.fromCharCode(curByte);\n            } else if (curByte < 0xE0) {\n                acc = curByte & 0x1F;\n                contBytes = 1;\n                accBytes = 1;\n            } else if (curByte < 0xF0) {\n                acc = curByte & 0x0F;\n                contBytes = 2;\n                accBytes = 1;\n            } else {\n                res += this.defaultCharUnicode;\n            }\n        } else {\n            if (contBytes > 0) {\n                acc = acc << 6 | curByte & 0x3f;\n                contBytes--;\n                accBytes++;\n                if (contBytes === 0) {\n                    // Check for overlong encoding, but support Modified UTF-8 (encoding NULL as C0 80)\n                    if (accBytes === 2 && acc < 0x80 && acc > 0) res += this.defaultCharUnicode;\n                    else if (accBytes === 3 && acc < 0x800) res += this.defaultCharUnicode;\n                    else // Actually add character.\n                    res += String.fromCharCode(acc);\n                }\n            } else {\n                res += this.defaultCharUnicode;\n            }\n        }\n    }\n    this.acc = acc;\n    this.contBytes = contBytes;\n    this.accBytes = accBytes;\n    return res;\n};\nInternalDecoderCesu8.prototype.end = function() {\n    var res = 0;\n    if (this.contBytes > 0) res += this.defaultCharUnicode;\n    return res;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFjdGlvbi1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9pY29udi1saXRlL2VuY29kaW5ncy9pbnRlcm5hbC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLElBQUlBLFNBQVNDLHlHQUE4QjtBQUUzQyxxQ0FBcUM7QUFFckNDLE9BQU9DLE9BQU8sR0FBRztJQUNiLFlBQVk7SUFDWkMsTUFBUTtRQUFFQyxNQUFNO1FBQWFDLFVBQVU7SUFBSTtJQUMzQ0MsT0FBUTtRQUFFRixNQUFNO1FBQWFDLFVBQVU7SUFBSTtJQUMzQ0UsZUFBZTtJQUVmQyxNQUFRO1FBQUVKLE1BQU07UUFBYUMsVUFBVTtJQUFJO0lBQzNDSSxTQUFTO0lBRVRDLFFBQVE7UUFBRU4sTUFBTTtJQUFZO0lBQzVCTyxRQUFRO1FBQUVQLE1BQU07SUFBWTtJQUM1QlEsS0FBUTtRQUFFUixNQUFNO0lBQVk7SUFFNUIsU0FBUztJQUNUUyxXQUFXQztBQUNmO0FBRUEsZ0ZBQWdGO0FBRWhGLFNBQVNBLGNBQWNDLFlBQVksRUFBRUMsS0FBSztJQUN0QyxJQUFJLENBQUNDLEdBQUcsR0FBR0YsYUFBYUcsWUFBWTtJQUNwQyxJQUFJLENBQUNiLFFBQVEsR0FBR1UsYUFBYVYsUUFBUTtJQUVyQyxJQUFJLElBQUksQ0FBQ1ksR0FBRyxLQUFLLFVBQ2IsSUFBSSxDQUFDRSxPQUFPLEdBQUdDO1NBQ2QsSUFBSSxJQUFJLENBQUNILEdBQUcsS0FBSyxTQUFTO1FBQzNCLElBQUksQ0FBQ0EsR0FBRyxHQUFHLFFBQVEseUJBQXlCO1FBQzVDLElBQUksQ0FBQ0UsT0FBTyxHQUFHRTtRQUVmLHlEQUF5RDtRQUN6RCxJQUFJdEIsT0FBT3VCLElBQUksQ0FBQyxnQkFBZ0IsT0FBT0MsUUFBUSxPQUFPLGdCQUFNO1lBQ3hELElBQUksQ0FBQ0MsT0FBTyxHQUFHQztZQUNmLElBQUksQ0FBQ0Msa0JBQWtCLEdBQUdWLE1BQU1VLGtCQUFrQjtRQUN0RDtJQUNKO0FBQ0o7QUFFQVosY0FBY2EsU0FBUyxDQUFDUixPQUFPLEdBQUdTO0FBQ2xDZCxjQUFjYSxTQUFTLENBQUNILE9BQU8sR0FBR0s7QUFFbEMsZ0ZBQWdGO0FBRWhGLHNFQUFzRTtBQUN0RSxJQUFJQyxnQkFBZ0I5QiwyRUFBdUM7QUFFM0QsSUFBSSxDQUFDOEIsY0FBY0gsU0FBUyxDQUFDSSxHQUFHLEVBQzVCRCxjQUFjSCxTQUFTLENBQUNJLEdBQUcsR0FBRyxZQUFZO0FBRzlDLFNBQVNGLGdCQUFnQkcsT0FBTyxFQUFFQyxLQUFLO0lBQ25DLElBQUksQ0FBQ1QsT0FBTyxHQUFHLElBQUlNLGNBQWNHLE1BQU1oQixHQUFHO0FBQzlDO0FBRUFZLGdCQUFnQkYsU0FBUyxDQUFDTyxLQUFLLEdBQUcsU0FBU0MsR0FBRztJQUMxQyxJQUFJLENBQUNwQyxPQUFPcUMsUUFBUSxDQUFDRCxNQUFNO1FBQ3ZCQSxNQUFNcEMsT0FBT3VCLElBQUksQ0FBQ2E7SUFDdEI7SUFFQSxPQUFPLElBQUksQ0FBQ1gsT0FBTyxDQUFDVSxLQUFLLENBQUNDO0FBQzlCO0FBRUFOLGdCQUFnQkYsU0FBUyxDQUFDSSxHQUFHLEdBQUc7SUFDNUIsT0FBTyxJQUFJLENBQUNQLE9BQU8sQ0FBQ08sR0FBRztBQUMzQjtBQUdBLGdGQUFnRjtBQUNoRiw0QkFBNEI7QUFFNUIsU0FBU0gsZ0JBQWdCSSxPQUFPLEVBQUVDLEtBQUs7SUFDbkMsSUFBSSxDQUFDaEIsR0FBRyxHQUFHZ0IsTUFBTWhCLEdBQUc7QUFDeEI7QUFFQVcsZ0JBQWdCRCxTQUFTLENBQUNPLEtBQUssR0FBRyxTQUFTRyxHQUFHO0lBQzFDLE9BQU90QyxPQUFPdUIsSUFBSSxDQUFDZSxLQUFLLElBQUksQ0FBQ3BCLEdBQUc7QUFDcEM7QUFFQVcsZ0JBQWdCRCxTQUFTLENBQUNJLEdBQUcsR0FBRyxZQUNoQztBQUdBLGdGQUFnRjtBQUNoRixvREFBb0Q7QUFFcEQsU0FBU1gsc0JBQXNCWSxPQUFPLEVBQUVDLEtBQUs7SUFDekMsSUFBSSxDQUFDSyxPQUFPLEdBQUc7QUFDbkI7QUFFQWxCLHNCQUFzQk8sU0FBUyxDQUFDTyxLQUFLLEdBQUcsU0FBU0csR0FBRztJQUNoREEsTUFBTSxJQUFJLENBQUNDLE9BQU8sR0FBR0Q7SUFDckIsSUFBSUUsZ0JBQWdCRixJQUFJRyxNQUFNLEdBQUlILElBQUlHLE1BQU0sR0FBRztJQUMvQyxJQUFJLENBQUNGLE9BQU8sR0FBR0QsSUFBSUksS0FBSyxDQUFDRjtJQUN6QkYsTUFBTUEsSUFBSUksS0FBSyxDQUFDLEdBQUdGO0lBRW5CLE9BQU94QyxPQUFPdUIsSUFBSSxDQUFDZSxLQUFLO0FBQzVCO0FBRUFqQixzQkFBc0JPLFNBQVMsQ0FBQ0ksR0FBRyxHQUFHO0lBQ2xDLE9BQU9oQyxPQUFPdUIsSUFBSSxDQUFDLElBQUksQ0FBQ2dCLE9BQU8sRUFBRTtBQUNyQztBQUdBLGdGQUFnRjtBQUNoRixrQ0FBa0M7QUFFbEMsU0FBU2pCLHFCQUFxQlcsT0FBTyxFQUFFQyxLQUFLLEdBQzVDO0FBRUFaLHFCQUFxQk0sU0FBUyxDQUFDTyxLQUFLLEdBQUcsU0FBU0csR0FBRztJQUMvQyxJQUFJRixNQUFNcEMsT0FBTzJDLEtBQUssQ0FBQ0wsSUFBSUcsTUFBTSxHQUFHLElBQUlHLFNBQVM7SUFDakQsSUFBSyxJQUFJQyxJQUFJLEdBQUdBLElBQUlQLElBQUlHLE1BQU0sRUFBRUksSUFBSztRQUNqQyxJQUFJQyxXQUFXUixJQUFJUyxVQUFVLENBQUNGO1FBQzlCLHVFQUF1RTtRQUN2RSxnRUFBZ0U7UUFDaEUsSUFBSUMsV0FBVyxNQUNYVixHQUFHLENBQUNRLFNBQVMsR0FBR0U7YUFDZixJQUFJQSxXQUFXLE9BQU87WUFDdkJWLEdBQUcsQ0FBQ1EsU0FBUyxHQUFHLE9BQVFFLENBQUFBLGFBQWE7WUFDckNWLEdBQUcsQ0FBQ1EsU0FBUyxHQUFHLE9BQVFFLENBQUFBLFdBQVcsSUFBRztRQUMxQyxPQUNLO1lBQ0RWLEdBQUcsQ0FBQ1EsU0FBUyxHQUFHLE9BQVFFLENBQUFBLGFBQWEsRUFBQztZQUN0Q1YsR0FBRyxDQUFDUSxTQUFTLEdBQUcsT0FBUSxjQUFjLElBQUssSUFBRztZQUM5Q1IsR0FBRyxDQUFDUSxTQUFTLEdBQUcsT0FBUUUsQ0FBQUEsV0FBVyxJQUFHO1FBQzFDO0lBQ0o7SUFDQSxPQUFPVixJQUFJTSxLQUFLLENBQUMsR0FBR0U7QUFDeEI7QUFFQXRCLHFCQUFxQk0sU0FBUyxDQUFDSSxHQUFHLEdBQUcsWUFDckM7QUFFQSxnRkFBZ0Y7QUFDaEYsa0RBQWtEO0FBRWxELFNBQVNOLHFCQUFxQk8sT0FBTyxFQUFFQyxLQUFLO0lBQ3hDLElBQUksQ0FBQ2MsR0FBRyxHQUFHO0lBQ1gsSUFBSSxDQUFDQyxTQUFTLEdBQUc7SUFDakIsSUFBSSxDQUFDQyxRQUFRLEdBQUc7SUFDaEIsSUFBSSxDQUFDdkIsa0JBQWtCLEdBQUdPLE1BQU1QLGtCQUFrQjtBQUN0RDtBQUVBRCxxQkFBcUJFLFNBQVMsQ0FBQ08sS0FBSyxHQUFHLFNBQVNDLEdBQUc7SUFDL0MsSUFBSVksTUFBTSxJQUFJLENBQUNBLEdBQUcsRUFBRUMsWUFBWSxJQUFJLENBQUNBLFNBQVMsRUFBRUMsV0FBVyxJQUFJLENBQUNBLFFBQVEsRUFDcEVDLE1BQU07SUFDVixJQUFLLElBQUlOLElBQUksR0FBR0EsSUFBSVQsSUFBSUssTUFBTSxFQUFFSSxJQUFLO1FBQ2pDLElBQUlPLFVBQVVoQixHQUFHLENBQUNTLEVBQUU7UUFDcEIsSUFBSSxDQUFDTyxVQUFVLElBQUcsTUFBTyxNQUFNO1lBQzNCLElBQUlILFlBQVksR0FBRztnQkFDZkUsT0FBTyxJQUFJLENBQUN4QixrQkFBa0I7Z0JBQzlCc0IsWUFBWTtZQUNoQjtZQUVBLElBQUlHLFVBQVUsTUFBTTtnQkFDaEJELE9BQU9FLE9BQU9DLFlBQVksQ0FBQ0Y7WUFDL0IsT0FBTyxJQUFJQSxVQUFVLE1BQU07Z0JBQ3ZCSixNQUFNSSxVQUFVO2dCQUNoQkgsWUFBWTtnQkFBR0MsV0FBVztZQUM5QixPQUFPLElBQUlFLFVBQVUsTUFBTTtnQkFDdkJKLE1BQU1JLFVBQVU7Z0JBQ2hCSCxZQUFZO2dCQUFHQyxXQUFXO1lBQzlCLE9BQU87Z0JBQ0hDLE9BQU8sSUFBSSxDQUFDeEIsa0JBQWtCO1lBQ2xDO1FBQ0osT0FBTztZQUNILElBQUlzQixZQUFZLEdBQUc7Z0JBQ2ZELE1BQU0sT0FBUSxJQUFNSSxVQUFVO2dCQUM5Qkg7Z0JBQWFDO2dCQUNiLElBQUlELGNBQWMsR0FBRztvQkFDakIsbUZBQW1GO29CQUNuRixJQUFJQyxhQUFhLEtBQUtGLE1BQU0sUUFBUUEsTUFBTSxHQUN0Q0csT0FBTyxJQUFJLENBQUN4QixrQkFBa0I7eUJBQzdCLElBQUl1QixhQUFhLEtBQUtGLE1BQU0sT0FDN0JHLE9BQU8sSUFBSSxDQUFDeEIsa0JBQWtCO3lCQUU5QiwwQkFBMEI7b0JBQzFCd0IsT0FBT0UsT0FBT0MsWUFBWSxDQUFDTjtnQkFDbkM7WUFDSixPQUFPO2dCQUNIRyxPQUFPLElBQUksQ0FBQ3hCLGtCQUFrQjtZQUNsQztRQUNKO0lBQ0o7SUFDQSxJQUFJLENBQUNxQixHQUFHLEdBQUdBO0lBQUssSUFBSSxDQUFDQyxTQUFTLEdBQUdBO0lBQVcsSUFBSSxDQUFDQyxRQUFRLEdBQUdBO0lBQzVELE9BQU9DO0FBQ1g7QUFFQXpCLHFCQUFxQkUsU0FBUyxDQUFDSSxHQUFHLEdBQUc7SUFDakMsSUFBSW1CLE1BQU07SUFDVixJQUFJLElBQUksQ0FBQ0YsU0FBUyxHQUFHLEdBQ2pCRSxPQUFPLElBQUksQ0FBQ3hCLGtCQUFrQjtJQUNsQyxPQUFPd0I7QUFDWCIsInNvdXJjZXMiOlsid2VicGFjazovL215LWRyaXZlLy4vbm9kZV9tb2R1bGVzL2ljb252LWxpdGUvZW5jb2RpbmdzL2ludGVybmFsLmpzPzllOTEiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgQnVmZmVyID0gcmVxdWlyZShcInNhZmVyLWJ1ZmZlclwiKS5CdWZmZXI7XG5cbi8vIEV4cG9ydCBOb2RlLmpzIGludGVybmFsIGVuY29kaW5ncy5cblxubW9kdWxlLmV4cG9ydHMgPSB7XG4gICAgLy8gRW5jb2RpbmdzXG4gICAgdXRmODogICB7IHR5cGU6IFwiX2ludGVybmFsXCIsIGJvbUF3YXJlOiB0cnVlfSxcbiAgICBjZXN1ODogIHsgdHlwZTogXCJfaW50ZXJuYWxcIiwgYm9tQXdhcmU6IHRydWV9LFxuICAgIHVuaWNvZGUxMXV0Zjg6IFwidXRmOFwiLFxuXG4gICAgdWNzMjogICB7IHR5cGU6IFwiX2ludGVybmFsXCIsIGJvbUF3YXJlOiB0cnVlfSxcbiAgICB1dGYxNmxlOiBcInVjczJcIixcblxuICAgIGJpbmFyeTogeyB0eXBlOiBcIl9pbnRlcm5hbFwiIH0sXG4gICAgYmFzZTY0OiB7IHR5cGU6IFwiX2ludGVybmFsXCIgfSxcbiAgICBoZXg6ICAgIHsgdHlwZTogXCJfaW50ZXJuYWxcIiB9LFxuXG4gICAgLy8gQ29kZWMuXG4gICAgX2ludGVybmFsOiBJbnRlcm5hbENvZGVjLFxufTtcblxuLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cblxuZnVuY3Rpb24gSW50ZXJuYWxDb2RlYyhjb2RlY09wdGlvbnMsIGljb252KSB7XG4gICAgdGhpcy5lbmMgPSBjb2RlY09wdGlvbnMuZW5jb2RpbmdOYW1lO1xuICAgIHRoaXMuYm9tQXdhcmUgPSBjb2RlY09wdGlvbnMuYm9tQXdhcmU7XG5cbiAgICBpZiAodGhpcy5lbmMgPT09IFwiYmFzZTY0XCIpXG4gICAgICAgIHRoaXMuZW5jb2RlciA9IEludGVybmFsRW5jb2RlckJhc2U2NDtcbiAgICBlbHNlIGlmICh0aGlzLmVuYyA9PT0gXCJjZXN1OFwiKSB7XG4gICAgICAgIHRoaXMuZW5jID0gXCJ1dGY4XCI7IC8vIFVzZSB1dGY4IGZvciBkZWNvZGluZy5cbiAgICAgICAgdGhpcy5lbmNvZGVyID0gSW50ZXJuYWxFbmNvZGVyQ2VzdTg7XG5cbiAgICAgICAgLy8gQWRkIGRlY29kZXIgZm9yIHZlcnNpb25zIG9mIE5vZGUgbm90IHN1cHBvcnRpbmcgQ0VTVS04XG4gICAgICAgIGlmIChCdWZmZXIuZnJvbSgnZWRhMGJkZWRiMmE5JywgJ2hleCcpLnRvU3RyaW5nKCkgIT09ICfwn5KpJykge1xuICAgICAgICAgICAgdGhpcy5kZWNvZGVyID0gSW50ZXJuYWxEZWNvZGVyQ2VzdTg7XG4gICAgICAgICAgICB0aGlzLmRlZmF1bHRDaGFyVW5pY29kZSA9IGljb252LmRlZmF1bHRDaGFyVW5pY29kZTtcbiAgICAgICAgfVxuICAgIH1cbn1cblxuSW50ZXJuYWxDb2RlYy5wcm90b3R5cGUuZW5jb2RlciA9IEludGVybmFsRW5jb2RlcjtcbkludGVybmFsQ29kZWMucHJvdG90eXBlLmRlY29kZXIgPSBJbnRlcm5hbERlY29kZXI7XG5cbi8vLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG5cbi8vIFdlIHVzZSBub2RlLmpzIGludGVybmFsIGRlY29kZXIuIEl0cyBzaWduYXR1cmUgaXMgdGhlIHNhbWUgYXMgb3Vycy5cbnZhciBTdHJpbmdEZWNvZGVyID0gcmVxdWlyZSgnc3RyaW5nX2RlY29kZXInKS5TdHJpbmdEZWNvZGVyO1xuXG5pZiAoIVN0cmluZ0RlY29kZXIucHJvdG90eXBlLmVuZCkgLy8gTm9kZSB2MC44IGRvZXNuJ3QgaGF2ZSB0aGlzIG1ldGhvZC5cbiAgICBTdHJpbmdEZWNvZGVyLnByb3RvdHlwZS5lbmQgPSBmdW5jdGlvbigpIHt9O1xuXG5cbmZ1bmN0aW9uIEludGVybmFsRGVjb2RlcihvcHRpb25zLCBjb2RlYykge1xuICAgIHRoaXMuZGVjb2RlciA9IG5ldyBTdHJpbmdEZWNvZGVyKGNvZGVjLmVuYyk7XG59XG5cbkludGVybmFsRGVjb2Rlci5wcm90b3R5cGUud3JpdGUgPSBmdW5jdGlvbihidWYpIHtcbiAgICBpZiAoIUJ1ZmZlci5pc0J1ZmZlcihidWYpKSB7XG4gICAgICAgIGJ1ZiA9IEJ1ZmZlci5mcm9tKGJ1Zik7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuZGVjb2Rlci53cml0ZShidWYpO1xufVxuXG5JbnRlcm5hbERlY29kZXIucHJvdG90eXBlLmVuZCA9IGZ1bmN0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmRlY29kZXIuZW5kKCk7XG59XG5cblxuLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbi8vIEVuY29kZXIgaXMgbW9zdGx5IHRyaXZpYWxcblxuZnVuY3Rpb24gSW50ZXJuYWxFbmNvZGVyKG9wdGlvbnMsIGNvZGVjKSB7XG4gICAgdGhpcy5lbmMgPSBjb2RlYy5lbmM7XG59XG5cbkludGVybmFsRW5jb2Rlci5wcm90b3R5cGUud3JpdGUgPSBmdW5jdGlvbihzdHIpIHtcbiAgICByZXR1cm4gQnVmZmVyLmZyb20oc3RyLCB0aGlzLmVuYyk7XG59XG5cbkludGVybmFsRW5jb2Rlci5wcm90b3R5cGUuZW5kID0gZnVuY3Rpb24oKSB7XG59XG5cblxuLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbi8vIEV4Y2VwdCBiYXNlNjQgZW5jb2Rlciwgd2hpY2ggbXVzdCBrZWVwIGl0cyBzdGF0ZS5cblxuZnVuY3Rpb24gSW50ZXJuYWxFbmNvZGVyQmFzZTY0KG9wdGlvbnMsIGNvZGVjKSB7XG4gICAgdGhpcy5wcmV2U3RyID0gJyc7XG59XG5cbkludGVybmFsRW5jb2RlckJhc2U2NC5wcm90b3R5cGUud3JpdGUgPSBmdW5jdGlvbihzdHIpIHtcbiAgICBzdHIgPSB0aGlzLnByZXZTdHIgKyBzdHI7XG4gICAgdmFyIGNvbXBsZXRlUXVhZHMgPSBzdHIubGVuZ3RoIC0gKHN0ci5sZW5ndGggJSA0KTtcbiAgICB0aGlzLnByZXZTdHIgPSBzdHIuc2xpY2UoY29tcGxldGVRdWFkcyk7XG4gICAgc3RyID0gc3RyLnNsaWNlKDAsIGNvbXBsZXRlUXVhZHMpO1xuXG4gICAgcmV0dXJuIEJ1ZmZlci5mcm9tKHN0ciwgXCJiYXNlNjRcIik7XG59XG5cbkludGVybmFsRW5jb2RlckJhc2U2NC5wcm90b3R5cGUuZW5kID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIEJ1ZmZlci5mcm9tKHRoaXMucHJldlN0ciwgXCJiYXNlNjRcIik7XG59XG5cblxuLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbi8vIENFU1UtOCBlbmNvZGVyIGlzIGFsc28gc3BlY2lhbC5cblxuZnVuY3Rpb24gSW50ZXJuYWxFbmNvZGVyQ2VzdTgob3B0aW9ucywgY29kZWMpIHtcbn1cblxuSW50ZXJuYWxFbmNvZGVyQ2VzdTgucHJvdG90eXBlLndyaXRlID0gZnVuY3Rpb24oc3RyKSB7XG4gICAgdmFyIGJ1ZiA9IEJ1ZmZlci5hbGxvYyhzdHIubGVuZ3RoICogMyksIGJ1ZklkeCA9IDA7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBzdHIubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgdmFyIGNoYXJDb2RlID0gc3RyLmNoYXJDb2RlQXQoaSk7XG4gICAgICAgIC8vIE5haXZlIGltcGxlbWVudGF0aW9uLCBidXQgaXQgd29ya3MgYmVjYXVzZSBDRVNVLTggaXMgZXNwZWNpYWxseSBlYXN5XG4gICAgICAgIC8vIHRvIGNvbnZlcnQgZnJvbSBVVEYtMTYgKHdoaWNoIGFsbCBKUyBzdHJpbmdzIGFyZSBlbmNvZGVkIGluKS5cbiAgICAgICAgaWYgKGNoYXJDb2RlIDwgMHg4MClcbiAgICAgICAgICAgIGJ1ZltidWZJZHgrK10gPSBjaGFyQ29kZTtcbiAgICAgICAgZWxzZSBpZiAoY2hhckNvZGUgPCAweDgwMCkge1xuICAgICAgICAgICAgYnVmW2J1ZklkeCsrXSA9IDB4QzAgKyAoY2hhckNvZGUgPj4+IDYpO1xuICAgICAgICAgICAgYnVmW2J1ZklkeCsrXSA9IDB4ODAgKyAoY2hhckNvZGUgJiAweDNmKTtcbiAgICAgICAgfVxuICAgICAgICBlbHNlIHsgLy8gY2hhckNvZGUgd2lsbCBhbHdheXMgYmUgPCAweDEwMDAwIGluIGphdmFzY3JpcHQuXG4gICAgICAgICAgICBidWZbYnVmSWR4KytdID0gMHhFMCArIChjaGFyQ29kZSA+Pj4gMTIpO1xuICAgICAgICAgICAgYnVmW2J1ZklkeCsrXSA9IDB4ODAgKyAoKGNoYXJDb2RlID4+PiA2KSAmIDB4M2YpO1xuICAgICAgICAgICAgYnVmW2J1ZklkeCsrXSA9IDB4ODAgKyAoY2hhckNvZGUgJiAweDNmKTtcbiAgICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gYnVmLnNsaWNlKDAsIGJ1ZklkeCk7XG59XG5cbkludGVybmFsRW5jb2RlckNlc3U4LnByb3RvdHlwZS5lbmQgPSBmdW5jdGlvbigpIHtcbn1cblxuLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbi8vIENFU1UtOCBkZWNvZGVyIGlzIG5vdCBpbXBsZW1lbnRlZCBpbiBOb2RlIHY0LjArXG5cbmZ1bmN0aW9uIEludGVybmFsRGVjb2RlckNlc3U4KG9wdGlvbnMsIGNvZGVjKSB7XG4gICAgdGhpcy5hY2MgPSAwO1xuICAgIHRoaXMuY29udEJ5dGVzID0gMDtcbiAgICB0aGlzLmFjY0J5dGVzID0gMDtcbiAgICB0aGlzLmRlZmF1bHRDaGFyVW5pY29kZSA9IGNvZGVjLmRlZmF1bHRDaGFyVW5pY29kZTtcbn1cblxuSW50ZXJuYWxEZWNvZGVyQ2VzdTgucHJvdG90eXBlLndyaXRlID0gZnVuY3Rpb24oYnVmKSB7XG4gICAgdmFyIGFjYyA9IHRoaXMuYWNjLCBjb250Qnl0ZXMgPSB0aGlzLmNvbnRCeXRlcywgYWNjQnl0ZXMgPSB0aGlzLmFjY0J5dGVzLCBcbiAgICAgICAgcmVzID0gJyc7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBidWYubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgdmFyIGN1ckJ5dGUgPSBidWZbaV07XG4gICAgICAgIGlmICgoY3VyQnl0ZSAmIDB4QzApICE9PSAweDgwKSB7IC8vIExlYWRpbmcgYnl0ZVxuICAgICAgICAgICAgaWYgKGNvbnRCeXRlcyA+IDApIHsgLy8gUHJldmlvdXMgY29kZSBpcyBpbnZhbGlkXG4gICAgICAgICAgICAgICAgcmVzICs9IHRoaXMuZGVmYXVsdENoYXJVbmljb2RlO1xuICAgICAgICAgICAgICAgIGNvbnRCeXRlcyA9IDA7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChjdXJCeXRlIDwgMHg4MCkgeyAvLyBTaW5nbGUtYnl0ZSBjb2RlXG4gICAgICAgICAgICAgICAgcmVzICs9IFN0cmluZy5mcm9tQ2hhckNvZGUoY3VyQnl0ZSk7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKGN1ckJ5dGUgPCAweEUwKSB7IC8vIFR3by1ieXRlIGNvZGVcbiAgICAgICAgICAgICAgICBhY2MgPSBjdXJCeXRlICYgMHgxRjtcbiAgICAgICAgICAgICAgICBjb250Qnl0ZXMgPSAxOyBhY2NCeXRlcyA9IDE7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKGN1ckJ5dGUgPCAweEYwKSB7IC8vIFRocmVlLWJ5dGUgY29kZVxuICAgICAgICAgICAgICAgIGFjYyA9IGN1ckJ5dGUgJiAweDBGO1xuICAgICAgICAgICAgICAgIGNvbnRCeXRlcyA9IDI7IGFjY0J5dGVzID0gMTtcbiAgICAgICAgICAgIH0gZWxzZSB7IC8vIEZvdXIgb3IgbW9yZSBhcmUgbm90IHN1cHBvcnRlZCBmb3IgQ0VTVS04LlxuICAgICAgICAgICAgICAgIHJlcyArPSB0aGlzLmRlZmF1bHRDaGFyVW5pY29kZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHsgLy8gQ29udGludWF0aW9uIGJ5dGVcbiAgICAgICAgICAgIGlmIChjb250Qnl0ZXMgPiAwKSB7IC8vIFdlJ3JlIHdhaXRpbmcgZm9yIGl0LlxuICAgICAgICAgICAgICAgIGFjYyA9IChhY2MgPDwgNikgfCAoY3VyQnl0ZSAmIDB4M2YpO1xuICAgICAgICAgICAgICAgIGNvbnRCeXRlcy0tOyBhY2NCeXRlcysrO1xuICAgICAgICAgICAgICAgIGlmIChjb250Qnl0ZXMgPT09IDApIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gQ2hlY2sgZm9yIG92ZXJsb25nIGVuY29kaW5nLCBidXQgc3VwcG9ydCBNb2RpZmllZCBVVEYtOCAoZW5jb2RpbmcgTlVMTCBhcyBDMCA4MClcbiAgICAgICAgICAgICAgICAgICAgaWYgKGFjY0J5dGVzID09PSAyICYmIGFjYyA8IDB4ODAgJiYgYWNjID4gMClcbiAgICAgICAgICAgICAgICAgICAgICAgIHJlcyArPSB0aGlzLmRlZmF1bHRDaGFyVW5pY29kZTtcbiAgICAgICAgICAgICAgICAgICAgZWxzZSBpZiAoYWNjQnl0ZXMgPT09IDMgJiYgYWNjIDwgMHg4MDApXG4gICAgICAgICAgICAgICAgICAgICAgICByZXMgKz0gdGhpcy5kZWZhdWx0Q2hhclVuaWNvZGU7XG4gICAgICAgICAgICAgICAgICAgIGVsc2VcbiAgICAgICAgICAgICAgICAgICAgICAgIC8vIEFjdHVhbGx5IGFkZCBjaGFyYWN0ZXIuXG4gICAgICAgICAgICAgICAgICAgICAgICByZXMgKz0gU3RyaW5nLmZyb21DaGFyQ29kZShhY2MpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSB7IC8vIFVuZXhwZWN0ZWQgY29udGludWF0aW9uIGJ5dGVcbiAgICAgICAgICAgICAgICByZXMgKz0gdGhpcy5kZWZhdWx0Q2hhclVuaWNvZGU7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG4gICAgdGhpcy5hY2MgPSBhY2M7IHRoaXMuY29udEJ5dGVzID0gY29udEJ5dGVzOyB0aGlzLmFjY0J5dGVzID0gYWNjQnl0ZXM7XG4gICAgcmV0dXJuIHJlcztcbn1cblxuSW50ZXJuYWxEZWNvZGVyQ2VzdTgucHJvdG90eXBlLmVuZCA9IGZ1bmN0aW9uKCkge1xuICAgIHZhciByZXMgPSAwO1xuICAgIGlmICh0aGlzLmNvbnRCeXRlcyA+IDApXG4gICAgICAgIHJlcyArPSB0aGlzLmRlZmF1bHRDaGFyVW5pY29kZTtcbiAgICByZXR1cm4gcmVzO1xufVxuIl0sIm5hbWVzIjpbIkJ1ZmZlciIsInJlcXVpcmUiLCJtb2R1bGUiLCJleHBvcnRzIiwidXRmOCIsInR5cGUiLCJib21Bd2FyZSIsImNlc3U4IiwidW5pY29kZTExdXRmOCIsInVjczIiLCJ1dGYxNmxlIiwiYmluYXJ5IiwiYmFzZTY0IiwiaGV4IiwiX2ludGVybmFsIiwiSW50ZXJuYWxDb2RlYyIsImNvZGVjT3B0aW9ucyIsImljb252IiwiZW5jIiwiZW5jb2RpbmdOYW1lIiwiZW5jb2RlciIsIkludGVybmFsRW5jb2RlckJhc2U2NCIsIkludGVybmFsRW5jb2RlckNlc3U4IiwiZnJvbSIsInRvU3RyaW5nIiwiZGVjb2RlciIsIkludGVybmFsRGVjb2RlckNlc3U4IiwiZGVmYXVsdENoYXJVbmljb2RlIiwicHJvdG90eXBlIiwiSW50ZXJuYWxFbmNvZGVyIiwiSW50ZXJuYWxEZWNvZGVyIiwiU3RyaW5nRGVjb2RlciIsImVuZCIsIm9wdGlvbnMiLCJjb2RlYyIsIndyaXRlIiwiYnVmIiwiaXNCdWZmZXIiLCJzdHIiLCJwcmV2U3RyIiwiY29tcGxldGVRdWFkcyIsImxlbmd0aCIsInNsaWNlIiwiYWxsb2MiLCJidWZJZHgiLCJpIiwiY2hhckNvZGUiLCJjaGFyQ29kZUF0IiwiYWNjIiwiY29udEJ5dGVzIiwiYWNjQnl0ZXMiLCJyZXMiLCJjdXJCeXRlIiwiU3RyaW5nIiwiZnJvbUNoYXJDb2RlIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/internal.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/sbcs-codec.js":
/*!*********************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/sbcs-codec.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// Single-byte codec. Needs a 'chars' string parameter that contains 256 or 128 chars that\n// correspond to encoded bytes (if 128 - then lower half is ASCII). \nexports._sbcs = SBCSCodec;\nfunction SBCSCodec(codecOptions, iconv) {\n    if (!codecOptions) throw new Error(\"SBCS codec is called without the data.\");\n    // Prepare char buffer for decoding.\n    if (!codecOptions.chars || codecOptions.chars.length !== 128 && codecOptions.chars.length !== 256) throw new Error(\"Encoding '\" + codecOptions.type + \"' has incorrect 'chars' (must be of len 128 or 256)\");\n    if (codecOptions.chars.length === 128) {\n        var asciiString = \"\";\n        for(var i = 0; i < 128; i++)asciiString += String.fromCharCode(i);\n        codecOptions.chars = asciiString + codecOptions.chars;\n    }\n    this.decodeBuf = Buffer.from(codecOptions.chars, \"ucs2\");\n    // Encoding buffer.\n    var encodeBuf = Buffer.alloc(65536, iconv.defaultCharSingleByte.charCodeAt(0));\n    for(var i = 0; i < codecOptions.chars.length; i++)encodeBuf[codecOptions.chars.charCodeAt(i)] = i;\n    this.encodeBuf = encodeBuf;\n}\nSBCSCodec.prototype.encoder = SBCSEncoder;\nSBCSCodec.prototype.decoder = SBCSDecoder;\nfunction SBCSEncoder(options, codec) {\n    this.encodeBuf = codec.encodeBuf;\n}\nSBCSEncoder.prototype.write = function(str) {\n    var buf = Buffer.alloc(str.length);\n    for(var i = 0; i < str.length; i++)buf[i] = this.encodeBuf[str.charCodeAt(i)];\n    return buf;\n};\nSBCSEncoder.prototype.end = function() {};\nfunction SBCSDecoder(options, codec) {\n    this.decodeBuf = codec.decodeBuf;\n}\nSBCSDecoder.prototype.write = function(buf) {\n    // Strings are immutable in JS -> we use ucs2 buffer to speed up computations.\n    var decodeBuf = this.decodeBuf;\n    var newBuf = Buffer.alloc(buf.length * 2);\n    var idx1 = 0, idx2 = 0;\n    for(var i = 0; i < buf.length; i++){\n        idx1 = buf[i] * 2;\n        idx2 = i * 2;\n        newBuf[idx2] = decodeBuf[idx1];\n        newBuf[idx2 + 1] = decodeBuf[idx1 + 1];\n    }\n    return newBuf.toString(\"ucs2\");\n};\nSBCSDecoder.prototype.end = function() {};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/sbcs-codec.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/sbcs-data-generated.js":
/*!******************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/sbcs-data-generated.js ***!
  \******************************************************************/
/***/ ((module) => {

eval("\n// Generated data for sbcs codec. Don't edit manually. Regenerate using generation/gen-sbcs.js script.\nmodule.exports = {\n    \"437\": \"cp437\",\n    \"737\": \"cp737\",\n    \"775\": \"cp775\",\n    \"850\": \"cp850\",\n    \"852\": \"cp852\",\n    \"855\": \"cp855\",\n    \"856\": \"cp856\",\n    \"857\": \"cp857\",\n    \"858\": \"cp858\",\n    \"860\": \"cp860\",\n    \"861\": \"cp861\",\n    \"862\": \"cp862\",\n    \"863\": \"cp863\",\n    \"864\": \"cp864\",\n    \"865\": \"cp865\",\n    \"866\": \"cp866\",\n    \"869\": \"cp869\",\n    \"874\": \"windows874\",\n    \"922\": \"cp922\",\n    \"1046\": \"cp1046\",\n    \"1124\": \"cp1124\",\n    \"1125\": \"cp1125\",\n    \"1129\": \"cp1129\",\n    \"1133\": \"cp1133\",\n    \"1161\": \"cp1161\",\n    \"1162\": \"cp1162\",\n    \"1163\": \"cp1163\",\n    \"1250\": \"windows1250\",\n    \"1251\": \"windows1251\",\n    \"1252\": \"windows1252\",\n    \"1253\": \"windows1253\",\n    \"1254\": \"windows1254\",\n    \"1255\": \"windows1255\",\n    \"1256\": \"windows1256\",\n    \"1257\": \"windows1257\",\n    \"1258\": \"windows1258\",\n    \"28591\": \"iso88591\",\n    \"28592\": \"iso88592\",\n    \"28593\": \"iso88593\",\n    \"28594\": \"iso88594\",\n    \"28595\": \"iso88595\",\n    \"28596\": \"iso88596\",\n    \"28597\": \"iso88597\",\n    \"28598\": \"iso88598\",\n    \"28599\": \"iso88599\",\n    \"28600\": \"iso885910\",\n    \"28601\": \"iso885911\",\n    \"28603\": \"iso885913\",\n    \"28604\": \"iso885914\",\n    \"28605\": \"iso885915\",\n    \"28606\": \"iso885916\",\n    \"windows874\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€����…�����������‘’“”•–—��������\\xa0กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����\"\n    },\n    \"win874\": \"windows874\",\n    \"cp874\": \"windows874\",\n    \"windows1250\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚�„…†‡�‰Š‹ŚŤŽŹ�‘’“”•–—�™š›śťžź\\xa0ˇ˘Ł\\xa4Ą\\xa6\\xa7\\xa8\\xa9Ş\\xab\\xac\\xad\\xaeŻ\\xb0\\xb1˛ł\\xb4\\xb5\\xb6\\xb7\\xb8ąş\\xbbĽ˝ľżŔ\\xc1\\xc2Ă\\xc4ĹĆ\\xc7Č\\xc9Ę\\xcbĚ\\xcd\\xceĎĐŃŇ\\xd3\\xd4Ő\\xd6\\xd7ŘŮ\\xdaŰ\\xdc\\xddŢ\\xdfŕ\\xe1\\xe2ă\\xe4ĺć\\xe7č\\xe9ę\\xebě\\xed\\xeeďđńň\\xf3\\xf4ő\\xf6\\xf7řů\\xfaű\\xfc\\xfdţ˙\"\n    },\n    \"win1250\": \"windows1250\",\n    \"cp1250\": \"windows1250\",\n    \"windows1251\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"ЂЃ‚ѓ„…†‡€‰Љ‹ЊЌЋЏђ‘’“”•–—�™љ›њќћџ\\xa0ЎўЈ\\xa4Ґ\\xa6\\xa7Ё\\xa9Є\\xab\\xac\\xad\\xaeЇ\\xb0\\xb1Ііґ\\xb5\\xb6\\xb7ё№є\\xbbјЅѕїАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя\"\n    },\n    \"win1251\": \"windows1251\",\n    \"cp1251\": \"windows1251\",\n    \"windows1252\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚ƒ„…†‡ˆ‰Š‹Œ�Ž��‘’“”•–—˜™š›œ�žŸ\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcf\\xd0\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdc\\xdd\\xde\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xef\\xf0\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfc\\xfd\\xfe\\xff\"\n    },\n    \"win1252\": \"windows1252\",\n    \"cp1252\": \"windows1252\",\n    \"windows1253\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚ƒ„…†‡�‰�‹�����‘’“”•–—�™�›����\\xa0΅Ά\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9�\\xab\\xac\\xad\\xae―\\xb0\\xb1\\xb2\\xb3΄\\xb5\\xb6\\xb7ΈΉΊ\\xbbΌ\\xbdΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�\"\n    },\n    \"win1253\": \"windows1253\",\n    \"cp1253\": \"windows1253\",\n    \"windows1254\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚ƒ„…†‡ˆ‰Š‹Œ����‘’“”•–—˜™š›œ��Ÿ\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcfĞ\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdcİŞ\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xefğ\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfcış\\xff\"\n    },\n    \"win1254\": \"windows1254\",\n    \"cp1254\": \"windows1254\",\n    \"windows1255\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚ƒ„…†‡ˆ‰�‹�����‘’“”•–—˜™�›����\\xa0\\xa1\\xa2\\xa3₪\\xa5\\xa6\\xa7\\xa8\\xa9\\xd7\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xf7\\xbb\\xbc\\xbd\\xbe\\xbfְֱֲֳִֵֶַָֹֺֻּֽ־ֿ׀ׁׂ׃װױײ׳״�������אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�\"\n    },\n    \"win1255\": \"windows1255\",\n    \"cp1255\": \"windows1255\",\n    \"windows1256\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€پ‚ƒ„…†‡ˆ‰ٹ‹Œچژڈگ‘’“”•–—ک™ڑ›œ‌‍ں\\xa0،\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9ھ\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9؛\\xbb\\xbc\\xbd\\xbe؟ہءآأؤإئابةتثجحخدذرزسشصض\\xd7طظعغـفقك\\xe0ل\\xe2منهو\\xe7\\xe8\\xe9\\xea\\xebىي\\xee\\xefًٌٍَ\\xf4ُِ\\xf7ّ\\xf9ْ\\xfb\\xfc‎‏ے\"\n    },\n    \"win1256\": \"windows1256\",\n    \"cp1256\": \"windows1256\",\n    \"windows1257\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚�„…†‡�‰�‹�\\xa8ˇ\\xb8�‘’“”•–—�™�›�\\xaf˛�\\xa0�\\xa2\\xa3\\xa4�\\xa6\\xa7\\xd8\\xa9Ŗ\\xab\\xac\\xad\\xae\\xc6\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xf8\\xb9ŗ\\xbb\\xbc\\xbd\\xbe\\xe6ĄĮĀĆ\\xc4\\xc5ĘĒČ\\xc9ŹĖĢĶĪĻŠŃŅ\\xd3Ō\\xd5\\xd6\\xd7ŲŁŚŪ\\xdcŻŽ\\xdfąįāć\\xe4\\xe5ęēč\\xe9źėģķīļšńņ\\xf3ō\\xf5\\xf6\\xf7ųłśū\\xfcżž˙\"\n    },\n    \"win1257\": \"windows1257\",\n    \"cp1257\": \"windows1257\",\n    \"windows1258\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€�‚ƒ„…†‡ˆ‰�‹Œ����‘’“”•–—˜™�›œ��Ÿ\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2Ă\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb̀\\xcd\\xce\\xcfĐ\\xd1̉\\xd3\\xd4Ơ\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdcỮ\\xdf\\xe0\\xe1\\xe2ă\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb́\\xed\\xee\\xefđ\\xf1̣\\xf3\\xf4ơ\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfcư₫\\xff\"\n    },\n    \"win1258\": \"windows1258\",\n    \"cp1258\": \"windows1258\",\n    \"iso88591\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcf\\xd0\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdc\\xdd\\xde\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xef\\xf0\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfc\\xfd\\xfe\\xff\"\n    },\n    \"cp28591\": \"iso88591\",\n    \"iso88592\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0Ą˘Ł\\xa4ĽŚ\\xa7\\xa8ŠŞŤŹ\\xadŽŻ\\xb0ą˛ł\\xb4ľśˇ\\xb8šşťź˝žżŔ\\xc1\\xc2Ă\\xc4ĹĆ\\xc7Č\\xc9Ę\\xcbĚ\\xcd\\xceĎĐŃŇ\\xd3\\xd4Ő\\xd6\\xd7ŘŮ\\xdaŰ\\xdc\\xddŢ\\xdfŕ\\xe1\\xe2ă\\xe4ĺć\\xe7č\\xe9ę\\xebě\\xed\\xeeďđńň\\xf3\\xf4ő\\xf6\\xf7řů\\xfaű\\xfc\\xfdţ˙\"\n    },\n    \"cp28592\": \"iso88592\",\n    \"iso88593\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0Ħ˘\\xa3\\xa4�Ĥ\\xa7\\xa8İŞĞĴ\\xad�Ż\\xb0ħ\\xb2\\xb3\\xb4\\xb5ĥ\\xb7\\xb8ışğĵ\\xbd�ż\\xc0\\xc1\\xc2�\\xc4ĊĈ\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcf�\\xd1\\xd2\\xd3\\xd4Ġ\\xd6\\xd7Ĝ\\xd9\\xda\\xdb\\xdcŬŜ\\xdf\\xe0\\xe1\\xe2�\\xe4ċĉ\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xef�\\xf1\\xf2\\xf3\\xf4ġ\\xf6\\xf7ĝ\\xf9\\xfa\\xfb\\xfcŭŝ˙\"\n    },\n    \"cp28593\": \"iso88593\",\n    \"iso88594\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0ĄĸŖ\\xa4ĨĻ\\xa7\\xa8ŠĒĢŦ\\xadŽ\\xaf\\xb0ą˛ŗ\\xb4ĩļˇ\\xb8šēģŧŊžŋĀ\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6ĮČ\\xc9Ę\\xcbĖ\\xcd\\xceĪĐŅŌĶ\\xd4\\xd5\\xd6\\xd7\\xd8Ų\\xda\\xdb\\xdcŨŪ\\xdfā\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6įč\\xe9ę\\xebė\\xed\\xeeīđņōķ\\xf4\\xf5\\xf6\\xf7\\xf8ų\\xfa\\xfb\\xfcũū˙\"\n    },\n    \"cp28594\": \"iso88594\",\n    \"iso88595\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0ЁЂЃЄЅІЇЈЉЊЋЌ\\xadЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя№ёђѓєѕіїјљњћќ\\xa7ўџ\"\n    },\n    \"cp28595\": \"iso88595\",\n    \"iso88596\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0���\\xa4�������،\\xad�������������؛���؟�ءآأؤإئابةتثجحخدذرزسشصضطظعغ�����ـفقكلمنهوىيًٌٍَُِّْ�������������\"\n    },\n    \"cp28596\": \"iso88596\",\n    \"iso88597\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0‘’\\xa3€₯\\xa6\\xa7\\xa8\\xa9ͺ\\xab\\xac\\xad�―\\xb0\\xb1\\xb2\\xb3΄΅Ά\\xb7ΈΉΊ\\xbbΌ\\xbdΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�\"\n    },\n    \"cp28597\": \"iso88597\",\n    \"iso88598\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0�\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xd7\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xf7\\xbb\\xbc\\xbd\\xbe��������������������������������‗אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�\"\n    },\n    \"cp28598\": \"iso88598\",\n    \"iso88599\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcfĞ\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdcİŞ\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xefğ\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfcış\\xff\"\n    },\n    \"cp28599\": \"iso88599\",\n    \"iso885910\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0ĄĒĢĪĨĶ\\xa7ĻĐŠŦŽ\\xadŪŊ\\xb0ąēģīĩķ\\xb7ļđšŧž―ūŋĀ\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6ĮČ\\xc9Ę\\xcbĖ\\xcd\\xce\\xcf\\xd0ŅŌ\\xd3\\xd4\\xd5\\xd6Ũ\\xd8Ų\\xda\\xdb\\xdc\\xdd\\xde\\xdfā\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6įč\\xe9ę\\xebė\\xed\\xee\\xef\\xf0ņō\\xf3\\xf4\\xf5\\xf6ũ\\xf8ų\\xfa\\xfb\\xfc\\xfd\\xfeĸ\"\n    },\n    \"cp28600\": \"iso885910\",\n    \"iso885911\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����\"\n    },\n    \"cp28601\": \"iso885911\",\n    \"iso885913\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0”\\xa2\\xa3\\xa4„\\xa6\\xa7\\xd8\\xa9Ŗ\\xab\\xac\\xad\\xae\\xc6\\xb0\\xb1\\xb2\\xb3“\\xb5\\xb6\\xb7\\xf8\\xb9ŗ\\xbb\\xbc\\xbd\\xbe\\xe6ĄĮĀĆ\\xc4\\xc5ĘĒČ\\xc9ŹĖĢĶĪĻŠŃŅ\\xd3Ō\\xd5\\xd6\\xd7ŲŁŚŪ\\xdcŻŽ\\xdfąįāć\\xe4\\xe5ęēč\\xe9źėģķīļšńņ\\xf3ō\\xf5\\xf6\\xf7ųłśū\\xfcżž’\"\n    },\n    \"cp28603\": \"iso885913\",\n    \"iso885914\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0Ḃḃ\\xa3ĊċḊ\\xa7Ẁ\\xa9ẂḋỲ\\xad\\xaeŸḞḟĠġṀṁ\\xb6ṖẁṗẃṠỳẄẅṡ\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcfŴ\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6Ṫ\\xd8\\xd9\\xda\\xdb\\xdc\\xddŶ\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xefŵ\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6ṫ\\xf8\\xf9\\xfa\\xfb\\xfc\\xfdŷ\\xff\"\n    },\n    \"cp28604\": \"iso885914\",\n    \"iso885915\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xa1\\xa2\\xa3€\\xa5Š\\xa7š\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3Ž\\xb5\\xb6\\xb7ž\\xb9\\xba\\xbbŒœŸ\\xbf\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcf\\xd0\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdc\\xdd\\xde\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xef\\xf0\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfc\\xfd\\xfe\\xff\"\n    },\n    \"cp28605\": \"iso885915\",\n    \"iso885916\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0ĄąŁ€„Š\\xa7š\\xa9Ș\\xabŹ\\xadźŻ\\xb0\\xb1ČłŽ”\\xb6\\xb7žčș\\xbbŒœŸż\\xc0\\xc1\\xc2Ă\\xc4Ć\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcfĐŃ\\xd2\\xd3\\xd4Ő\\xd6ŚŰ\\xd9\\xda\\xdb\\xdcĘȚ\\xdf\\xe0\\xe1\\xe2ă\\xe4ć\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xefđń\\xf2\\xf3\\xf4ő\\xf6śű\\xf9\\xfa\\xfb\\xfcęț\\xff\"\n    },\n    \"cp28606\": \"iso885916\",\n    \"cp437\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4\\xe0\\xe5\\xe7\\xea\\xeb\\xe8\\xef\\xee\\xec\\xc4\\xc5\\xc9\\xe6\\xc6\\xf4\\xf6\\xf2\\xfb\\xf9\\xff\\xd6\\xdc\\xa2\\xa3\\xa5₧ƒ\\xe1\\xed\\xf3\\xfa\\xf1\\xd1\\xaa\\xba\\xbf⌐\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm437\": \"cp437\",\n    \"csibm437\": \"cp437\",\n    \"cp737\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρσςτυφχψ░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀ωάέήϊίόύϋώΆΈΉΊΌΎΏ\\xb1≥≤ΪΫ\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm737\": \"cp737\",\n    \"csibm737\": \"cp737\",\n    \"cp775\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"Ć\\xfc\\xe9ā\\xe4ģ\\xe5ćłēŖŗīŹ\\xc4\\xc5\\xc9\\xe6\\xc6ō\\xf6Ģ\\xa2Śś\\xd6\\xdc\\xf8\\xa3\\xd8\\xd7\\xa4ĀĪ\\xf3Żżź”\\xa6\\xa9\\xae\\xac\\xbd\\xbcŁ\\xab\\xbb░▒▓│┤ĄČĘĖ╣║╗╝ĮŠ┐└┴┬├─┼ŲŪ╚╔╩╦╠═╬Žąčęėįšųūž┘┌█▄▌▐▀\\xd3\\xdfŌŃ\\xf5\\xd5\\xb5ńĶķĻļņĒŅ’\\xad\\xb1“\\xbe\\xb6\\xa7\\xf7„\\xb0∙\\xb7\\xb9\\xb3\\xb2■\\xa0\"\n    },\n    \"ibm775\": \"cp775\",\n    \"csibm775\": \"cp775\",\n    \"cp850\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4\\xe0\\xe5\\xe7\\xea\\xeb\\xe8\\xef\\xee\\xec\\xc4\\xc5\\xc9\\xe6\\xc6\\xf4\\xf6\\xf2\\xfb\\xf9\\xff\\xd6\\xdc\\xf8\\xa3\\xd8\\xd7ƒ\\xe1\\xed\\xf3\\xfa\\xf1\\xd1\\xaa\\xba\\xbf\\xae\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤\\xc1\\xc2\\xc0\\xa9╣║╗╝\\xa2\\xa5┐└┴┬├─┼\\xe3\\xc3╚╔╩╦╠═╬\\xa4\\xf0\\xd0\\xca\\xcb\\xc8ı\\xcd\\xce\\xcf┘┌█▄\\xa6\\xcc▀\\xd3\\xdf\\xd4\\xd2\\xf5\\xd5\\xb5\\xfe\\xde\\xda\\xdb\\xd9\\xfd\\xdd\\xaf\\xb4\\xad\\xb1‗\\xbe\\xb6\\xa7\\xf7\\xb8\\xb0\\xa8\\xb7\\xb9\\xb3\\xb2■\\xa0\"\n    },\n    \"ibm850\": \"cp850\",\n    \"csibm850\": \"cp850\",\n    \"cp852\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4ůć\\xe7ł\\xebŐő\\xeeŹ\\xc4Ć\\xc9Ĺĺ\\xf4\\xf6ĽľŚś\\xd6\\xdcŤťŁ\\xd7č\\xe1\\xed\\xf3\\xfaĄąŽžĘę\\xacźČş\\xab\\xbb░▒▓│┤\\xc1\\xc2ĚŞ╣║╗╝Żż┐└┴┬├─┼Ăă╚╔╩╦╠═╬\\xa4đĐĎ\\xcbďŇ\\xcd\\xceě┘┌█▄ŢŮ▀\\xd3\\xdf\\xd4ŃńňŠšŔ\\xdaŕŰ\\xfd\\xddţ\\xb4\\xad˝˛ˇ˘\\xa7\\xf7\\xb8\\xb0\\xa8˙űŘř■\\xa0\"\n    },\n    \"ibm852\": \"cp852\",\n    \"csibm852\": \"cp852\",\n    \"cp855\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"ђЂѓЃёЁєЄѕЅіІїЇјЈљЉњЊћЋќЌўЎџЏюЮъЪаАбБцЦдДеЕфФгГ\\xab\\xbb░▒▓│┤хХиИ╣║╗╝йЙ┐└┴┬├─┼кК╚╔╩╦╠═╬\\xa4лЛмМнНоОп┘┌█▄Пя▀ЯрРсСтТуУжЖвВьЬ№\\xadыЫзЗшШэЭщЩчЧ\\xa7■\\xa0\"\n    },\n    \"ibm855\": \"cp855\",\n    \"csibm855\": \"cp855\",\n    \"cp856\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"אבגדהוזחטיךכלםמןנסעףפץצקרשת�\\xa3�\\xd7����������\\xae\\xac\\xbd\\xbc�\\xab\\xbb░▒▓│┤���\\xa9╣║╗╝\\xa2\\xa5┐└┴┬├─┼��╚╔╩╦╠═╬\\xa4���������┘┌█▄\\xa6�▀������\\xb5�������\\xaf\\xb4\\xad\\xb1‗\\xbe\\xb6\\xa7\\xf7\\xb8\\xb0\\xa8\\xb7\\xb9\\xb3\\xb2■\\xa0\"\n    },\n    \"ibm856\": \"cp856\",\n    \"csibm856\": \"cp856\",\n    \"cp857\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4\\xe0\\xe5\\xe7\\xea\\xeb\\xe8\\xef\\xeeı\\xc4\\xc5\\xc9\\xe6\\xc6\\xf4\\xf6\\xf2\\xfb\\xf9İ\\xd6\\xdc\\xf8\\xa3\\xd8Şş\\xe1\\xed\\xf3\\xfa\\xf1\\xd1Ğğ\\xbf\\xae\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤\\xc1\\xc2\\xc0\\xa9╣║╗╝\\xa2\\xa5┐└┴┬├─┼\\xe3\\xc3╚╔╩╦╠═╬\\xa4\\xba\\xaa\\xca\\xcb\\xc8�\\xcd\\xce\\xcf┘┌█▄\\xa6\\xcc▀\\xd3\\xdf\\xd4\\xd2\\xf5\\xd5\\xb5�\\xd7\\xda\\xdb\\xd9\\xec\\xff\\xaf\\xb4\\xad\\xb1�\\xbe\\xb6\\xa7\\xf7\\xb8\\xb0\\xa8\\xb7\\xb9\\xb3\\xb2■\\xa0\"\n    },\n    \"ibm857\": \"cp857\",\n    \"csibm857\": \"cp857\",\n    \"cp858\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4\\xe0\\xe5\\xe7\\xea\\xeb\\xe8\\xef\\xee\\xec\\xc4\\xc5\\xc9\\xe6\\xc6\\xf4\\xf6\\xf2\\xfb\\xf9\\xff\\xd6\\xdc\\xf8\\xa3\\xd8\\xd7ƒ\\xe1\\xed\\xf3\\xfa\\xf1\\xd1\\xaa\\xba\\xbf\\xae\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤\\xc1\\xc2\\xc0\\xa9╣║╗╝\\xa2\\xa5┐└┴┬├─┼\\xe3\\xc3╚╔╩╦╠═╬\\xa4\\xf0\\xd0\\xca\\xcb\\xc8€\\xcd\\xce\\xcf┘┌█▄\\xa6\\xcc▀\\xd3\\xdf\\xd4\\xd2\\xf5\\xd5\\xb5\\xfe\\xde\\xda\\xdb\\xd9\\xfd\\xdd\\xaf\\xb4\\xad\\xb1‗\\xbe\\xb6\\xa7\\xf7\\xb8\\xb0\\xa8\\xb7\\xb9\\xb3\\xb2■\\xa0\"\n    },\n    \"ibm858\": \"cp858\",\n    \"csibm858\": \"cp858\",\n    \"cp860\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe3\\xe0\\xc1\\xe7\\xea\\xca\\xe8\\xcd\\xd4\\xec\\xc3\\xc2\\xc9\\xc0\\xc8\\xf4\\xf5\\xf2\\xda\\xf9\\xcc\\xd5\\xdc\\xa2\\xa3\\xd9₧\\xd3\\xe1\\xed\\xf3\\xfa\\xf1\\xd1\\xaa\\xba\\xbf\\xd2\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm860\": \"cp860\",\n    \"csibm860\": \"cp860\",\n    \"cp861\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4\\xe0\\xe5\\xe7\\xea\\xeb\\xe8\\xd0\\xf0\\xde\\xc4\\xc5\\xc9\\xe6\\xc6\\xf4\\xf6\\xfe\\xfb\\xdd\\xfd\\xd6\\xdc\\xf8\\xa3\\xd8₧ƒ\\xe1\\xed\\xf3\\xfa\\xc1\\xcd\\xd3\\xda\\xbf⌐\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm861\": \"cp861\",\n    \"csibm861\": \"cp861\",\n    \"cp862\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"אבגדהוזחטיךכלםמןנסעףפץצקרשת\\xa2\\xa3\\xa5₧ƒ\\xe1\\xed\\xf3\\xfa\\xf1\\xd1\\xaa\\xba\\xbf⌐\\xac\\xbd\\xbc\\xa1\\xab\\xbb░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm862\": \"cp862\",\n    \"csibm862\": \"cp862\",\n    \"cp863\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xc2\\xe0\\xb6\\xe7\\xea\\xeb\\xe8\\xef\\xee‗\\xc0\\xa7\\xc9\\xc8\\xca\\xf4\\xcb\\xcf\\xfb\\xf9\\xa4\\xd4\\xdc\\xa2\\xa3\\xd9\\xdbƒ\\xa6\\xb4\\xf3\\xfa\\xa8\\xb8\\xb3\\xaf\\xce⌐\\xac\\xbd\\xbc\\xbe\\xab\\xbb░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm863\": \"cp863\",\n    \"csibm863\": \"cp863\",\n    \"cp864\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x00\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\b\t\\n\\v\\f\\r\\x0e\\x0f\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1a\\x1b\\x1c\\x1d\\x1e\\x1f !\\\"#$٪&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\\x7f\\xb0\\xb7∙√▒─│┼┤┬├┴┐┌└┘β∞φ\\xb1\\xbd\\xbc≈\\xab\\xbbﻷﻸ��ﻻﻼ�\\xa0\\xadﺂ\\xa3\\xa4ﺄ��ﺎﺏﺕﺙ،ﺝﺡﺥ٠١٢٣٤٥٦٧٨٩ﻑ؛ﺱﺵﺹ؟\\xa2ﺀﺁﺃﺅﻊﺋﺍﺑﺓﺗﺛﺟﺣﺧﺩﺫﺭﺯﺳﺷﺻﺿﻁﻅﻋﻏ\\xa6\\xac\\xf7\\xd7ﻉـﻓﻗﻛﻟﻣﻧﻫﻭﻯﻳﺽﻌﻎﻍﻡﹽّﻥﻩﻬﻰﻲﻐﻕﻵﻶﻝﻙﻱ■�\"\n    },\n    \"ibm864\": \"cp864\",\n    \"csibm864\": \"cp864\",\n    \"cp865\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc7\\xfc\\xe9\\xe2\\xe4\\xe0\\xe5\\xe7\\xea\\xeb\\xe8\\xef\\xee\\xec\\xc4\\xc5\\xc9\\xe6\\xc6\\xf4\\xf6\\xf2\\xfb\\xf9\\xff\\xd6\\xdc\\xf8\\xa3\\xd8₧ƒ\\xe1\\xed\\xf3\\xfa\\xf1\\xd1\\xaa\\xba\\xbf⌐\\xac\\xbd\\xbc\\xa1\\xab\\xa4░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"ibm865\": \"cp865\",\n    \"csibm865\": \"cp865\",\n    \"cp866\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёЄєЇїЎў\\xb0∙\\xb7√№\\xa4■\\xa0\"\n    },\n    \"ibm866\": \"cp866\",\n    \"csibm866\": \"cp866\",\n    \"cp869\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"������Ά�\\xb7\\xac\\xa6‘’Έ―ΉΊΪΌ��ΎΫ\\xa9Ώ\\xb2\\xb3ά\\xa3έήίϊΐόύΑΒΓΔΕΖΗ\\xbdΘΙ\\xab\\xbb░▒▓│┤ΚΛΜΝ╣║╗╝ΞΟ┐└┴┬├─┼ΠΡ╚╔╩╦╠═╬ΣΤΥΦΧΨΩαβγ┘┌█▄δε▀ζηθικλμνξοπρσςτ΄\\xad\\xb1υφχ\\xa7ψ΅\\xb0\\xa8ωϋΰώ■\\xa0\"\n    },\n    \"ibm869\": \"cp869\",\n    \"csibm869\": \"cp869\",\n    \"cp922\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae‾\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2\\xc3\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb\\xcc\\xcd\\xce\\xcfŠ\\xd1\\xd2\\xd3\\xd4\\xd5\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdc\\xddŽ\\xdf\\xe0\\xe1\\xe2\\xe3\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xefš\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfc\\xfdž\\xff\"\n    },\n    \"ibm922\": \"cp922\",\n    \"csibm922\": \"cp922\",\n    \"cp1046\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"ﺈ\\xd7\\xf7ﹱ\\x88■│─┐┌└┘ﹹﹻﹽﹿﹷﺊﻰﻳﻲﻎﻏﻐﻶﻸﻺﻼ\\xa0\\xa4ﺋﺑﺗﺛﺟﺣ،\\xadﺧﺳ٠١٢٣٤٥٦٧٨٩ﺷ؛ﺻﺿﻊ؟ﻋءآأؤإئابةتثجحخدذرزسشصضطﻇعغﻌﺂﺄﺎﻓـفقكلمنهوىيًٌٍَُِّْﻗﻛﻟﻵﻷﻹﻻﻣﻧﻬﻩ�\"\n    },\n    \"ibm1046\": \"cp1046\",\n    \"csibm1046\": \"cp1046\",\n    \"cp1124\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0ЁЂҐЄЅІЇЈЉЊЋЌ\\xadЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя№ёђґєѕіїјљњћќ\\xa7ўџ\"\n    },\n    \"ibm1124\": \"cp1124\",\n    \"csibm1124\": \"cp1124\",\n    \"cp1125\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёҐґЄєІіЇї\\xb7√№\\xa4■\\xa0\"\n    },\n    \"ibm1125\": \"cp1125\",\n    \"csibm1125\": \"cp1125\",\n    \"cp1129\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7œ\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3Ÿ\\xb5\\xb6\\xb7Œ\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2Ă\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb̀\\xcd\\xce\\xcfĐ\\xd1̉\\xd3\\xd4Ơ\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdcỮ\\xdf\\xe0\\xe1\\xe2ă\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb́\\xed\\xee\\xefđ\\xf1̣\\xf3\\xf4ơ\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfcư₫\\xff\"\n    },\n    \"ibm1129\": \"cp1129\",\n    \"csibm1129\": \"cp1129\",\n    \"cp1133\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0ກຂຄງຈສຊຍດຕຖທນບປຜຝພຟມຢຣລວຫອຮ���ຯະາຳິີຶືຸູຼັົຽ���ເແໂໃໄ່້໊໋໌ໍໆ�ໜໝ₭����������������໐໑໒໓໔໕໖໗໘໙��\\xa2\\xac\\xa6�\"\n    },\n    \"ibm1133\": \"cp1133\",\n    \"csibm1133\": \"cp1133\",\n    \"cp1161\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"��������������������������������่กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู้๊๋€฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛\\xa2\\xac\\xa6\\xa0\"\n    },\n    \"ibm1161\": \"cp1161\",\n    \"csibm1161\": \"cp1161\",\n    \"cp1162\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"€\\x81\\x82\\x83\\x84…\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90‘’“”•–—\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����\"\n    },\n    \"ibm1162\": \"cp1162\",\n    \"csibm1162\": \"cp1162\",\n    \"cp1163\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xa1\\xa2\\xa3€\\xa5\\xa6\\xa7œ\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3Ÿ\\xb5\\xb6\\xb7Œ\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbf\\xc0\\xc1\\xc2Ă\\xc4\\xc5\\xc6\\xc7\\xc8\\xc9\\xca\\xcb̀\\xcd\\xce\\xcfĐ\\xd1̉\\xd3\\xd4Ơ\\xd6\\xd7\\xd8\\xd9\\xda\\xdb\\xdcỮ\\xdf\\xe0\\xe1\\xe2ă\\xe4\\xe5\\xe6\\xe7\\xe8\\xe9\\xea\\xeb́\\xed\\xee\\xefđ\\xf1̣\\xf3\\xf4ơ\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfcư₫\\xff\"\n    },\n    \"ibm1163\": \"cp1163\",\n    \"csibm1163\": \"cp1163\",\n    \"maccroatian\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xc5\\xc7\\xc9\\xd1\\xd6\\xdc\\xe1\\xe0\\xe2\\xe4\\xe3\\xe5\\xe7\\xe9\\xe8\\xea\\xeb\\xed\\xec\\xee\\xef\\xf1\\xf3\\xf2\\xf4\\xf6\\xf5\\xfa\\xf9\\xfb\\xfc†\\xb0\\xa2\\xa3\\xa7•\\xb6\\xdf\\xaeŠ™\\xb4\\xa8≠Ž\\xd8∞\\xb1≤≥∆\\xb5∂∑∏š∫\\xaa\\xbaΩž\\xf8\\xbf\\xa1\\xac√ƒ≈Ć\\xabČ…\\xa0\\xc0\\xc3\\xd5ŒœĐ—“”‘’\\xf7◊�\\xa9⁄\\xa4‹›\\xc6\\xbb–\\xb7‚„‰\\xc2ć\\xc1č\\xc8\\xcd\\xce\\xcf\\xcc\\xd3\\xd4đ\\xd2\\xda\\xdb\\xd9ıˆ˜\\xafπ\\xcb˚\\xb8\\xca\\xe6ˇ\"\n    },\n    \"maccyrillic\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†\\xb0\\xa2\\xa3\\xa7•\\xb6І\\xae\\xa9™Ђђ≠Ѓѓ∞\\xb1≤≥і\\xb5∂ЈЄєЇїЉљЊњјЅ\\xac√ƒ≈∆\\xab\\xbb…\\xa0ЋћЌќѕ–—“”‘’\\xf7„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю\\xa4\"\n    },\n    \"macgreek\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xb9\\xb2\\xc9\\xb3\\xd6\\xdc΅\\xe0\\xe2\\xe4΄\\xa8\\xe7\\xe9\\xe8\\xea\\xeb\\xa3™\\xee\\xef•\\xbd‰\\xf4\\xf6\\xa6\\xad\\xf9\\xfb\\xfc†ΓΔΘΛΞΠ\\xdf\\xae\\xa9ΣΪ\\xa7≠\\xb0·Α\\xb1≤≥\\xa5ΒΕΖΗΙΚΜΦΫΨΩάΝ\\xacΟΡ≈Τ\\xab\\xbb…\\xa0ΥΧΆΈœ–―“”‘’\\xf7ΉΊΌΎέήίόΏύαβψδεφγηιξκλμνοπώρστθωςχυζϊϋΐΰ�\"\n    },\n    \"maciceland\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xc5\\xc7\\xc9\\xd1\\xd6\\xdc\\xe1\\xe0\\xe2\\xe4\\xe3\\xe5\\xe7\\xe9\\xe8\\xea\\xeb\\xed\\xec\\xee\\xef\\xf1\\xf3\\xf2\\xf4\\xf6\\xf5\\xfa\\xf9\\xfb\\xfc\\xdd\\xb0\\xa2\\xa3\\xa7•\\xb6\\xdf\\xae\\xa9™\\xb4\\xa8≠\\xc6\\xd8∞\\xb1≤≥\\xa5\\xb5∂∑∏π∫\\xaa\\xbaΩ\\xe6\\xf8\\xbf\\xa1\\xac√ƒ≈∆\\xab\\xbb…\\xa0\\xc0\\xc3\\xd5Œœ–—“”‘’\\xf7◊\\xffŸ⁄\\xa4\\xd0\\xf0\\xde\\xfe\\xfd\\xb7‚„‰\\xc2\\xca\\xc1\\xcb\\xc8\\xcd\\xce\\xcf\\xcc\\xd3\\xd4�\\xd2\\xda\\xdb\\xd9ıˆ˜\\xaf˘˙˚\\xb8˝˛ˇ\"\n    },\n    \"macroman\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xc5\\xc7\\xc9\\xd1\\xd6\\xdc\\xe1\\xe0\\xe2\\xe4\\xe3\\xe5\\xe7\\xe9\\xe8\\xea\\xeb\\xed\\xec\\xee\\xef\\xf1\\xf3\\xf2\\xf4\\xf6\\xf5\\xfa\\xf9\\xfb\\xfc†\\xb0\\xa2\\xa3\\xa7•\\xb6\\xdf\\xae\\xa9™\\xb4\\xa8≠\\xc6\\xd8∞\\xb1≤≥\\xa5\\xb5∂∑∏π∫\\xaa\\xbaΩ\\xe6\\xf8\\xbf\\xa1\\xac√ƒ≈∆\\xab\\xbb…\\xa0\\xc0\\xc3\\xd5Œœ–—“”‘’\\xf7◊\\xffŸ⁄\\xa4‹›ﬁﬂ‡\\xb7‚„‰\\xc2\\xca\\xc1\\xcb\\xc8\\xcd\\xce\\xcf\\xcc\\xd3\\xd4�\\xd2\\xda\\xdb\\xd9ıˆ˜\\xaf˘˙˚\\xb8˝˛ˇ\"\n    },\n    \"macromania\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xc5\\xc7\\xc9\\xd1\\xd6\\xdc\\xe1\\xe0\\xe2\\xe4\\xe3\\xe5\\xe7\\xe9\\xe8\\xea\\xeb\\xed\\xec\\xee\\xef\\xf1\\xf3\\xf2\\xf4\\xf6\\xf5\\xfa\\xf9\\xfb\\xfc†\\xb0\\xa2\\xa3\\xa7•\\xb6\\xdf\\xae\\xa9™\\xb4\\xa8≠ĂŞ∞\\xb1≤≥\\xa5\\xb5∂∑∏π∫\\xaa\\xbaΩăş\\xbf\\xa1\\xac√ƒ≈∆\\xab\\xbb…\\xa0\\xc0\\xc3\\xd5Œœ–—“”‘’\\xf7◊\\xffŸ⁄\\xa4‹›Ţţ‡\\xb7‚„‰\\xc2\\xca\\xc1\\xcb\\xc8\\xcd\\xce\\xcf\\xcc\\xd3\\xd4�\\xd2\\xda\\xdb\\xd9ıˆ˜\\xaf˘˙˚\\xb8˝˛ˇ\"\n    },\n    \"macthai\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xab\\xbb…“”�•‘’�\\xa0กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู\\uFEFF​–—฿เแโใไๅๆ็่้๊๋์ํ™๏๐๑๒๓๔๕๖๗๘๙\\xae\\xa9����\"\n    },\n    \"macturkish\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xc5\\xc7\\xc9\\xd1\\xd6\\xdc\\xe1\\xe0\\xe2\\xe4\\xe3\\xe5\\xe7\\xe9\\xe8\\xea\\xeb\\xed\\xec\\xee\\xef\\xf1\\xf3\\xf2\\xf4\\xf6\\xf5\\xfa\\xf9\\xfb\\xfc†\\xb0\\xa2\\xa3\\xa7•\\xb6\\xdf\\xae\\xa9™\\xb4\\xa8≠\\xc6\\xd8∞\\xb1≤≥\\xa5\\xb5∂∑∏π∫\\xaa\\xbaΩ\\xe6\\xf8\\xbf\\xa1\\xac√ƒ≈∆\\xab\\xbb…\\xa0\\xc0\\xc3\\xd5Œœ–—“”‘’\\xf7◊\\xffŸĞğİıŞş‡\\xb7‚„‰\\xc2\\xca\\xc1\\xcb\\xc8\\xcd\\xce\\xcf\\xcc\\xd3\\xd4�\\xd2\\xda\\xdb\\xd9�ˆ˜\\xaf˘˙˚\\xb8˝˛ˇ\"\n    },\n    \"macukraine\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†\\xb0Ґ\\xa3\\xa7•\\xb6І\\xae\\xa9™Ђђ≠Ѓѓ∞\\xb1≤≥і\\xb5ґЈЄєЇїЉљЊњјЅ\\xac√ƒ≈∆\\xab\\xbb…\\xa0ЋћЌќѕ–—“”‘’\\xf7„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю\\xa4\"\n    },\n    \"koi8r\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥\\xa0⌡\\xb0\\xb2\\xb7\\xf7═║╒ё╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡Ё╢╣╤╥╦╧╨╩╪╫╬\\xa9юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ\"\n    },\n    \"koi8u\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥\\xa0⌡\\xb0\\xb2\\xb7\\xf7═║╒ёє╔ії╗╘╙╚╛ґ╝╞╟╠╡ЁЄ╣ІЇ╦╧╨╩╪Ґ╬\\xa9юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ\"\n    },\n    \"koi8ru\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥\\xa0⌡\\xb0\\xb2\\xb7\\xf7═║╒ёє╔ії╗╘╙╚╛ґў╞╟╠╡ЁЄ╣ІЇ╦╧╨╩╪ҐЎ\\xa9юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ\"\n    },\n    \"koi8t\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"қғ‚Ғ„…†‡�‰ҳ‹ҲҷҶ�Қ‘’“”•–—�™�›�����ӯӮё\\xa4ӣ\\xa6\\xa7���\\xab\\xac\\xad\\xae�\\xb0\\xb1\\xb2Ё�Ӣ\\xb6\\xb7�№�\\xbb���\\xa9юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ\"\n    },\n    \"armscii8\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0�և։)(\\xbb\\xab—.՝,-֊…՜՛՞ԱաԲբԳգԴդԵեԶզԷէԸըԹթԺժԻիԼլԽխԾծԿկՀհՁձՂղՃճՄմՅյՆնՇշՈոՉչՊպՋջՌռՍսՎվՏտՐրՑցՒւՓփՔքՕօՖֆ՚�\"\n    },\n    \"rk1048\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"ЂЃ‚ѓ„…†‡€‰Љ‹ЊҚҺЏђ‘’“”•–—�™љ›њқһџ\\xa0ҰұӘ\\xa4Ө\\xa6\\xa7Ё\\xa9Ғ\\xab\\xac\\xad\\xaeҮ\\xb0\\xb1Ііө\\xb5\\xb6\\xb7ё№ғ\\xbbәҢңүАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя\"\n    },\n    \"tcvn\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x00\\xdaỤ\\x03ỪỬỮ\\x07\\b\t\\n\\v\\f\\r\\x0e\\x0f\\x10ỨỰỲỶỸ\\xddỴ\\x18\\x19\\x1a\\x1b\\x1c\\x1d\\x1e\\x1f !\\\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\\x7f\\xc0Ả\\xc3\\xc1ẠẶẬ\\xc8ẺẼ\\xc9ẸỆ\\xccỈĨ\\xcdỊ\\xd2Ỏ\\xd5\\xd3ỌỘỜỞỠỚỢ\\xd9ỦŨ\\xa0Ă\\xc2\\xca\\xd4ƠƯĐă\\xe2\\xea\\xf4ơưđẶ̀̀̉̃́\\xe0ả\\xe3\\xe1ạẲằẳẵắẴẮẦẨẪẤỀặầẩẫấậ\\xe8Ểẻẽ\\xe9ẹềểễếệ\\xecỉỄẾỒĩ\\xedị\\xf2Ổỏ\\xf5\\xf3ọồổỗốộờởỡớợ\\xf9Ỗủũ\\xfaụừửữứựỳỷỹ\\xfdỵỐ\"\n    },\n    \"georgianacademy\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81‚ƒ„…†‡ˆ‰Š‹Œ\\x8d\\x8e\\x8f\\x90‘’“”•–—˜™š›œ\\x9d\\x9eŸ\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbfაბგდევზთიკლმნოპჟრსტუფქღყშჩცძწჭხჯჰჱჲჳჴჵჶ\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xef\\xf0\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfc\\xfd\\xfe\\xff\"\n    },\n    \"georgianps\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81‚ƒ„…†‡ˆ‰Š‹Œ\\x8d\\x8e\\x8f\\x90‘’“”•–—˜™š›œ\\x9d\\x9eŸ\\xa0\\xa1\\xa2\\xa3\\xa4\\xa5\\xa6\\xa7\\xa8\\xa9\\xaa\\xab\\xac\\xad\\xae\\xaf\\xb0\\xb1\\xb2\\xb3\\xb4\\xb5\\xb6\\xb7\\xb8\\xb9\\xba\\xbb\\xbc\\xbd\\xbe\\xbfაბგდევზჱთიკლმნჲოპჟრსტჳუფქღყშჩცძწჭხჴჯჰჵ\\xe6\\xe7\\xe8\\xe9\\xea\\xeb\\xec\\xed\\xee\\xef\\xf0\\xf1\\xf2\\xf3\\xf4\\xf5\\xf6\\xf7\\xf8\\xf9\\xfa\\xfb\\xfc\\xfd\\xfe\\xff\"\n    },\n    \"pt154\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"ҖҒӮғ„…ҶҮҲүҠӢҢҚҺҸҗ‘’“”•–—ҳҷҡӣңқһҹ\\xa0ЎўЈӨҘҰ\\xa7Ё\\xa9Ә\\xab\\xacӯ\\xaeҜ\\xb0ұІіҙө\\xb6\\xb7ё№ә\\xbbјҪҫҝАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя\"\n    },\n    \"viscii\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x00\\x01Ẳ\\x03\\x04ẴẪ\\x07\\b\t\\n\\v\\f\\r\\x0e\\x0f\\x10\\x11\\x12\\x13Ỷ\\x15\\x16\\x17\\x18Ỹ\\x1a\\x1b\\x1c\\x1dỴ\\x1f !\\\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\\x7fẠẮẰẶẤẦẨẬẼẸẾỀỂỄỆỐỒỔỖỘỢỚỜỞỊỎỌỈỦŨỤỲ\\xd5ắằặấầẩậẽẹếềểễệốồổỗỠƠộờởịỰỨỪỬơớƯ\\xc0\\xc1\\xc2\\xc3ẢĂẳẵ\\xc8\\xc9\\xcaẺ\\xcc\\xcdĨỳĐứ\\xd2\\xd3\\xd4ạỷừử\\xd9\\xdaỹỵ\\xddỡư\\xe0\\xe1\\xe2\\xe3ảăữẫ\\xe8\\xe9\\xeaẻ\\xec\\xedĩỉđự\\xf2\\xf3\\xf4\\xf5ỏọụ\\xf9\\xfaũủ\\xfdợỮ\"\n    },\n    \"iso646cn\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x00\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\b\t\\n\\v\\f\\r\\x0e\\x0f\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1a\\x1b\\x1c\\x1d\\x1e\\x1f !\\\"#\\xa5%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`abcdefghijklmnopqrstuvwxyz{|}‾\\x7f��������������������������������������������������������������������������������������������������������������������������������\"\n    },\n    \"iso646jp\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x00\\x01\\x02\\x03\\x04\\x05\\x06\\x07\\b\t\\n\\v\\f\\r\\x0e\\x0f\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1a\\x1b\\x1c\\x1d\\x1e\\x1f !\\\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\xa5]^_`abcdefghijklmnopqrstuvwxyz{|}‾\\x7f��������������������������������������������������������������������������������������������������������������������������������\"\n    },\n    \"hproman8\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8a\\x8b\\x8c\\x8d\\x8e\\x8f\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9a\\x9b\\x9c\\x9d\\x9e\\x9f\\xa0\\xc0\\xc2\\xc8\\xca\\xcb\\xce\\xcf\\xb4ˋˆ\\xa8˜\\xd9\\xdb₤\\xaf\\xdd\\xfd\\xb0\\xc7\\xe7\\xd1\\xf1\\xa1\\xbf\\xa4\\xa3\\xa5\\xa7ƒ\\xa2\\xe2\\xea\\xf4\\xfb\\xe1\\xe9\\xf3\\xfa\\xe0\\xe8\\xf2\\xf9\\xe4\\xeb\\xf6\\xfc\\xc5\\xee\\xd8\\xc6\\xe5\\xed\\xf8\\xe6\\xc4\\xec\\xd6\\xdc\\xc9\\xef\\xdf\\xd4\\xc1\\xc3\\xe3\\xd0\\xf0\\xcd\\xcc\\xd3\\xd2\\xd5\\xf5Šš\\xdaŸ\\xff\\xde\\xfe\\xb7\\xb5\\xb6\\xbe—\\xbc\\xbd\\xaa\\xba\\xab■\\xbb\\xb1�\"\n    },\n    \"macintosh\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4\\xc5\\xc7\\xc9\\xd1\\xd6\\xdc\\xe1\\xe0\\xe2\\xe4\\xe3\\xe5\\xe7\\xe9\\xe8\\xea\\xeb\\xed\\xec\\xee\\xef\\xf1\\xf3\\xf2\\xf4\\xf6\\xf5\\xfa\\xf9\\xfb\\xfc†\\xb0\\xa2\\xa3\\xa7•\\xb6\\xdf\\xae\\xa9™\\xb4\\xa8≠\\xc6\\xd8∞\\xb1≤≥\\xa5\\xb5∂∑∏π∫\\xaa\\xbaΩ\\xe6\\xf8\\xbf\\xa1\\xac√ƒ≈∆\\xab\\xbb…\\xa0\\xc0\\xc3\\xd5Œœ–—“”‘’\\xf7◊\\xffŸ⁄\\xa4‹›ﬁﬂ‡\\xb7‚„‰\\xc2\\xca\\xc1\\xcb\\xc8\\xcd\\xce\\xcf\\xcc\\xd3\\xd4�\\xd2\\xda\\xdb\\xd9ıˆ˜\\xaf˘˙˚\\xb8˝˛ˇ\"\n    },\n    \"ascii\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"��������������������������������������������������������������������������������������������������������������������������������\"\n    },\n    \"tis620\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"���������������������������������กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����\"\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/sbcs-data-generated.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/sbcs-data.js":
/*!********************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/sbcs-data.js ***!
  \********************************************************/
/***/ ((module) => {

eval("\n// Manually added data to be used by sbcs codec in addition to generated one.\nmodule.exports = {\n    // Not supported by iconv, not sure why.\n    \"10029\": \"maccenteuro\",\n    \"maccenteuro\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\xc4Āā\\xc9Ą\\xd6\\xdc\\xe1ąČ\\xe4čĆć\\xe9ŹźĎ\\xedďĒēĖ\\xf3ė\\xf4\\xf6\\xf5\\xfaĚě\\xfc†\\xb0Ę\\xa3\\xa7•\\xb6\\xdf\\xae\\xa9™ę\\xa8≠ģĮįĪ≤≥īĶ∂∑łĻļĽľĹĺŅņŃ\\xac√ńŇ∆\\xab\\xbb…\\xa0ňŐ\\xd5őŌ–—“”‘’\\xf7◊ōŔŕŘ‹›řŖŗŠ‚„šŚś\\xc1Ťť\\xcdŽžŪ\\xd3\\xd4ūŮ\\xdaůŰűŲų\\xdd\\xfdķŻŁżĢˇ\"\n    },\n    \"808\": \"cp808\",\n    \"ibm808\": \"cp808\",\n    \"cp808\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёЄєЇїЎў\\xb0∙\\xb7√№€■\\xa0\"\n    },\n    \"mik\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя└┴┬├─┼╣║╚╔╩╦╠═╬┐░▒▓│┤№\\xa7╗╝┘┌█▄▌▐▀α\\xdfΓπΣσ\\xb5τΦΘΩδ∞φε∩≡\\xb1≥≤⌠⌡\\xf7≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    \"cp720\": {\n        \"type\": \"_sbcs\",\n        \"chars\": \"\\x80\\x81\\xe9\\xe2\\x84\\xe0\\x86\\xe7\\xea\\xeb\\xe8\\xef\\xee\\x8d\\x8e\\x8f\\x90ّْ\\xf4\\xa4ـ\\xfb\\xf9ءآأؤ\\xa3إئابةتثجحخدذرزسشص\\xab\\xbb░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀ضطظعغف\\xb5قكلمنهوىي≡ًٌٍَُِ≈\\xb0∙\\xb7√ⁿ\\xb2■\\xa0\"\n    },\n    // Aliases of generated encodings.\n    \"ascii8bit\": \"ascii\",\n    \"usascii\": \"ascii\",\n    \"ansix34\": \"ascii\",\n    \"ansix341968\": \"ascii\",\n    \"ansix341986\": \"ascii\",\n    \"csascii\": \"ascii\",\n    \"cp367\": \"ascii\",\n    \"ibm367\": \"ascii\",\n    \"isoir6\": \"ascii\",\n    \"iso646us\": \"ascii\",\n    \"iso646irv\": \"ascii\",\n    \"us\": \"ascii\",\n    \"latin1\": \"iso88591\",\n    \"latin2\": \"iso88592\",\n    \"latin3\": \"iso88593\",\n    \"latin4\": \"iso88594\",\n    \"latin5\": \"iso88599\",\n    \"latin6\": \"iso885910\",\n    \"latin7\": \"iso885913\",\n    \"latin8\": \"iso885914\",\n    \"latin9\": \"iso885915\",\n    \"latin10\": \"iso885916\",\n    \"csisolatin1\": \"iso88591\",\n    \"csisolatin2\": \"iso88592\",\n    \"csisolatin3\": \"iso88593\",\n    \"csisolatin4\": \"iso88594\",\n    \"csisolatincyrillic\": \"iso88595\",\n    \"csisolatinarabic\": \"iso88596\",\n    \"csisolatingreek\": \"iso88597\",\n    \"csisolatinhebrew\": \"iso88598\",\n    \"csisolatin5\": \"iso88599\",\n    \"csisolatin6\": \"iso885910\",\n    \"l1\": \"iso88591\",\n    \"l2\": \"iso88592\",\n    \"l3\": \"iso88593\",\n    \"l4\": \"iso88594\",\n    \"l5\": \"iso88599\",\n    \"l6\": \"iso885910\",\n    \"l7\": \"iso885913\",\n    \"l8\": \"iso885914\",\n    \"l9\": \"iso885915\",\n    \"l10\": \"iso885916\",\n    \"isoir14\": \"iso646jp\",\n    \"isoir57\": \"iso646cn\",\n    \"isoir100\": \"iso88591\",\n    \"isoir101\": \"iso88592\",\n    \"isoir109\": \"iso88593\",\n    \"isoir110\": \"iso88594\",\n    \"isoir144\": \"iso88595\",\n    \"isoir127\": \"iso88596\",\n    \"isoir126\": \"iso88597\",\n    \"isoir138\": \"iso88598\",\n    \"isoir148\": \"iso88599\",\n    \"isoir157\": \"iso885910\",\n    \"isoir166\": \"tis620\",\n    \"isoir179\": \"iso885913\",\n    \"isoir199\": \"iso885914\",\n    \"isoir203\": \"iso885915\",\n    \"isoir226\": \"iso885916\",\n    \"cp819\": \"iso88591\",\n    \"ibm819\": \"iso88591\",\n    \"cyrillic\": \"iso88595\",\n    \"arabic\": \"iso88596\",\n    \"arabic8\": \"iso88596\",\n    \"ecma114\": \"iso88596\",\n    \"asmo708\": \"iso88596\",\n    \"greek\": \"iso88597\",\n    \"greek8\": \"iso88597\",\n    \"ecma118\": \"iso88597\",\n    \"elot928\": \"iso88597\",\n    \"hebrew\": \"iso88598\",\n    \"hebrew8\": \"iso88598\",\n    \"turkish\": \"iso88599\",\n    \"turkish8\": \"iso88599\",\n    \"thai\": \"iso885911\",\n    \"thai8\": \"iso885911\",\n    \"celtic\": \"iso885914\",\n    \"celtic8\": \"iso885914\",\n    \"isoceltic\": \"iso885914\",\n    \"tis6200\": \"tis620\",\n    \"tis62025291\": \"tis620\",\n    \"tis62025330\": \"tis620\",\n    \"10000\": \"macroman\",\n    \"10006\": \"macgreek\",\n    \"10007\": \"maccyrillic\",\n    \"10079\": \"maciceland\",\n    \"10081\": \"macturkish\",\n    \"cspc8codepage437\": \"cp437\",\n    \"cspc775baltic\": \"cp775\",\n    \"cspc850multilingual\": \"cp850\",\n    \"cspcp852\": \"cp852\",\n    \"cspc862latinhebrew\": \"cp862\",\n    \"cpgr\": \"cp869\",\n    \"msee\": \"cp1250\",\n    \"mscyrl\": \"cp1251\",\n    \"msansi\": \"cp1252\",\n    \"msgreek\": \"cp1253\",\n    \"msturk\": \"cp1254\",\n    \"mshebr\": \"cp1255\",\n    \"msarab\": \"cp1256\",\n    \"winbaltrim\": \"cp1257\",\n    \"cp20866\": \"koi8r\",\n    \"20866\": \"koi8r\",\n    \"ibm878\": \"koi8r\",\n    \"cskoi8r\": \"koi8r\",\n    \"cp21866\": \"koi8u\",\n    \"21866\": \"koi8u\",\n    \"ibm1168\": \"koi8u\",\n    \"strk10482002\": \"rk1048\",\n    \"tcvn5712\": \"tcvn\",\n    \"tcvn57121\": \"tcvn\",\n    \"gb198880\": \"iso646cn\",\n    \"cn\": \"iso646cn\",\n    \"csiso14jisc6220ro\": \"iso646jp\",\n    \"jisc62201969ro\": \"iso646jp\",\n    \"jp\": \"iso646jp\",\n    \"cshproman8\": \"hproman8\",\n    \"r8\": \"hproman8\",\n    \"roman8\": \"hproman8\",\n    \"xroman8\": \"hproman8\",\n    \"ibm1051\": \"hproman8\",\n    \"mac\": \"macintosh\",\n    \"csmacintosh\": \"macintosh\"\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/sbcs-data.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/utf16.js":
/*!****************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/utf16.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// Note: UTF16-LE (or UCS2) codec is Node.js native. See encodings/internal.js\n// == UTF16-BE codec. ==========================================================\nexports.utf16be = Utf16BECodec;\nfunction Utf16BECodec() {}\nUtf16BECodec.prototype.encoder = Utf16BEEncoder;\nUtf16BECodec.prototype.decoder = Utf16BEDecoder;\nUtf16BECodec.prototype.bomAware = true;\n// -- Encoding\nfunction Utf16BEEncoder() {}\nUtf16BEEncoder.prototype.write = function(str) {\n    var buf = Buffer.from(str, \"ucs2\");\n    for(var i = 0; i < buf.length; i += 2){\n        var tmp = buf[i];\n        buf[i] = buf[i + 1];\n        buf[i + 1] = tmp;\n    }\n    return buf;\n};\nUtf16BEEncoder.prototype.end = function() {};\n// -- Decoding\nfunction Utf16BEDecoder() {\n    this.overflowByte = -1;\n}\nUtf16BEDecoder.prototype.write = function(buf) {\n    if (buf.length == 0) return \"\";\n    var buf2 = Buffer.alloc(buf.length + 1), i = 0, j = 0;\n    if (this.overflowByte !== -1) {\n        buf2[0] = buf[0];\n        buf2[1] = this.overflowByte;\n        i = 1;\n        j = 2;\n    }\n    for(; i < buf.length - 1; i += 2, j += 2){\n        buf2[j] = buf[i + 1];\n        buf2[j + 1] = buf[i];\n    }\n    this.overflowByte = i == buf.length - 1 ? buf[buf.length - 1] : -1;\n    return buf2.slice(0, j).toString(\"ucs2\");\n};\nUtf16BEDecoder.prototype.end = function() {\n    this.overflowByte = -1;\n};\n// == UTF-16 codec =============================================================\n// Decoder chooses automatically from UTF-16LE and UTF-16BE using BOM and space-based heuristic.\n// Defaults to UTF-16LE, as it's prevalent and default in Node.\n// http://en.wikipedia.org/wiki/UTF-16 and http://encoding.spec.whatwg.org/#utf-16le\n// Decoder default can be changed: iconv.decode(buf, 'utf16', {defaultEncoding: 'utf-16be'});\n// Encoder uses UTF-16LE and prepends BOM (which can be overridden with addBOM: false).\nexports.utf16 = Utf16Codec;\nfunction Utf16Codec(codecOptions, iconv) {\n    this.iconv = iconv;\n}\nUtf16Codec.prototype.encoder = Utf16Encoder;\nUtf16Codec.prototype.decoder = Utf16Decoder;\n// -- Encoding (pass-through)\nfunction Utf16Encoder(options, codec) {\n    options = options || {};\n    if (options.addBOM === undefined) options.addBOM = true;\n    this.encoder = codec.iconv.getEncoder(\"utf-16le\", options);\n}\nUtf16Encoder.prototype.write = function(str) {\n    return this.encoder.write(str);\n};\nUtf16Encoder.prototype.end = function() {\n    return this.encoder.end();\n};\n// -- Decoding\nfunction Utf16Decoder(options, codec) {\n    this.decoder = null;\n    this.initialBufs = [];\n    this.initialBufsLen = 0;\n    this.options = options || {};\n    this.iconv = codec.iconv;\n}\nUtf16Decoder.prototype.write = function(buf) {\n    if (!this.decoder) {\n        // Codec is not chosen yet. Accumulate initial bytes.\n        this.initialBufs.push(buf);\n        this.initialBufsLen += buf.length;\n        if (this.initialBufsLen < 16) return \"\";\n        // We have enough bytes -> detect endianness.\n        var encoding = detectEncoding(this.initialBufs, this.options.defaultEncoding);\n        this.decoder = this.iconv.getDecoder(encoding, this.options);\n        var resStr = \"\";\n        for(var i = 0; i < this.initialBufs.length; i++)resStr += this.decoder.write(this.initialBufs[i]);\n        this.initialBufs.length = this.initialBufsLen = 0;\n        return resStr;\n    }\n    return this.decoder.write(buf);\n};\nUtf16Decoder.prototype.end = function() {\n    if (!this.decoder) {\n        var encoding = detectEncoding(this.initialBufs, this.options.defaultEncoding);\n        this.decoder = this.iconv.getDecoder(encoding, this.options);\n        var resStr = \"\";\n        for(var i = 0; i < this.initialBufs.length; i++)resStr += this.decoder.write(this.initialBufs[i]);\n        var trail = this.decoder.end();\n        if (trail) resStr += trail;\n        this.initialBufs.length = this.initialBufsLen = 0;\n        return resStr;\n    }\n    return this.decoder.end();\n};\nfunction detectEncoding(bufs, defaultEncoding) {\n    var b = [];\n    var charsProcessed = 0;\n    var asciiCharsLE = 0, asciiCharsBE = 0; // Number of ASCII chars when decoded as LE or BE.\n    outer_loop: for(var i = 0; i < bufs.length; i++){\n        var buf = bufs[i];\n        for(var j = 0; j < buf.length; j++){\n            b.push(buf[j]);\n            if (b.length === 2) {\n                if (charsProcessed === 0) {\n                    // Check BOM first.\n                    if (b[0] === 0xFF && b[1] === 0xFE) return \"utf-16le\";\n                    if (b[0] === 0xFE && b[1] === 0xFF) return \"utf-16be\";\n                }\n                if (b[0] === 0 && b[1] !== 0) asciiCharsBE++;\n                if (b[0] !== 0 && b[1] === 0) asciiCharsLE++;\n                b.length = 0;\n                charsProcessed++;\n                if (charsProcessed >= 100) {\n                    break outer_loop;\n                }\n            }\n        }\n    }\n    // Make decisions.\n    // Most of the time, the content has ASCII chars (U+00**), but the opposite (U+**00) is uncommon.\n    // So, we count ASCII as if it was LE or BE, and decide from that.\n    if (asciiCharsBE > asciiCharsLE) return \"utf-16be\";\n    if (asciiCharsBE < asciiCharsLE) return \"utf-16le\";\n    // Couldn't decide (likely all zeros or not enough data).\n    return defaultEncoding || \"utf-16le\";\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKGFjdGlvbi1icm93c2VyKS8uL25vZGVfbW9kdWxlcy9pY29udi1saXRlL2VuY29kaW5ncy91dGYxNi5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLElBQUlBLFNBQVNDLHlHQUE4QjtBQUUzQyw4RUFBOEU7QUFFOUUsZ0ZBQWdGO0FBRWhGQyxlQUFlLEdBQUdFO0FBQ2xCLFNBQVNBLGdCQUNUO0FBRUFBLGFBQWFDLFNBQVMsQ0FBQ0MsT0FBTyxHQUFHQztBQUNqQ0gsYUFBYUMsU0FBUyxDQUFDRyxPQUFPLEdBQUdDO0FBQ2pDTCxhQUFhQyxTQUFTLENBQUNLLFFBQVEsR0FBRztBQUdsQyxjQUFjO0FBRWQsU0FBU0gsa0JBQ1Q7QUFFQUEsZUFBZUYsU0FBUyxDQUFDTSxLQUFLLEdBQUcsU0FBU0MsR0FBRztJQUN6QyxJQUFJQyxNQUFNYixPQUFPYyxJQUFJLENBQUNGLEtBQUs7SUFDM0IsSUFBSyxJQUFJRyxJQUFJLEdBQUdBLElBQUlGLElBQUlHLE1BQU0sRUFBRUQsS0FBSyxFQUFHO1FBQ3BDLElBQUlFLE1BQU1KLEdBQUcsQ0FBQ0UsRUFBRTtRQUFFRixHQUFHLENBQUNFLEVBQUUsR0FBR0YsR0FBRyxDQUFDRSxJQUFFLEVBQUU7UUFBRUYsR0FBRyxDQUFDRSxJQUFFLEVBQUUsR0FBR0U7SUFDcEQ7SUFDQSxPQUFPSjtBQUNYO0FBRUFOLGVBQWVGLFNBQVMsQ0FBQ2EsR0FBRyxHQUFHLFlBQy9CO0FBR0EsY0FBYztBQUVkLFNBQVNUO0lBQ0wsSUFBSSxDQUFDVSxZQUFZLEdBQUcsQ0FBQztBQUN6QjtBQUVBVixlQUFlSixTQUFTLENBQUNNLEtBQUssR0FBRyxTQUFTRSxHQUFHO0lBQ3pDLElBQUlBLElBQUlHLE1BQU0sSUFBSSxHQUNkLE9BQU87SUFFWCxJQUFJSSxPQUFPcEIsT0FBT3FCLEtBQUssQ0FBQ1IsSUFBSUcsTUFBTSxHQUFHLElBQ2pDRCxJQUFJLEdBQUdPLElBQUk7SUFFZixJQUFJLElBQUksQ0FBQ0gsWUFBWSxLQUFLLENBQUMsR0FBRztRQUMxQkMsSUFBSSxDQUFDLEVBQUUsR0FBR1AsR0FBRyxDQUFDLEVBQUU7UUFDaEJPLElBQUksQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDRCxZQUFZO1FBQzNCSixJQUFJO1FBQUdPLElBQUk7SUFDZjtJQUVBLE1BQU9QLElBQUlGLElBQUlHLE1BQU0sR0FBQyxHQUFHRCxLQUFLLEdBQUdPLEtBQUksRUFBRztRQUNwQ0YsSUFBSSxDQUFDRSxFQUFFLEdBQUdULEdBQUcsQ0FBQ0UsSUFBRSxFQUFFO1FBQ2xCSyxJQUFJLENBQUNFLElBQUUsRUFBRSxHQUFHVCxHQUFHLENBQUNFLEVBQUU7SUFDdEI7SUFFQSxJQUFJLENBQUNJLFlBQVksR0FBRyxLQUFNTixJQUFJRyxNQUFNLEdBQUMsSUFBS0gsR0FBRyxDQUFDQSxJQUFJRyxNQUFNLEdBQUMsRUFBRSxHQUFHLENBQUM7SUFFL0QsT0FBT0ksS0FBS0csS0FBSyxDQUFDLEdBQUdELEdBQUdFLFFBQVEsQ0FBQztBQUNyQztBQUVBZixlQUFlSixTQUFTLENBQUNhLEdBQUcsR0FBRztJQUMzQixJQUFJLENBQUNDLFlBQVksR0FBRyxDQUFDO0FBQ3pCO0FBR0EsZ0ZBQWdGO0FBQ2hGLGdHQUFnRztBQUNoRywrREFBK0Q7QUFDL0Qsb0ZBQW9GO0FBQ3BGLDZGQUE2RjtBQUU3Rix1RkFBdUY7QUFFdkZqQixhQUFhLEdBQUd3QjtBQUNoQixTQUFTQSxXQUFXQyxZQUFZLEVBQUVDLEtBQUs7SUFDbkMsSUFBSSxDQUFDQSxLQUFLLEdBQUdBO0FBQ2pCO0FBRUFGLFdBQVdyQixTQUFTLENBQUNDLE9BQU8sR0FBR3VCO0FBQy9CSCxXQUFXckIsU0FBUyxDQUFDRyxPQUFPLEdBQUdzQjtBQUcvQiw2QkFBNkI7QUFFN0IsU0FBU0QsYUFBYUUsT0FBTyxFQUFFQyxLQUFLO0lBQ2hDRCxVQUFVQSxXQUFXLENBQUM7SUFDdEIsSUFBSUEsUUFBUUUsTUFBTSxLQUFLQyxXQUNuQkgsUUFBUUUsTUFBTSxHQUFHO0lBQ3JCLElBQUksQ0FBQzNCLE9BQU8sR0FBRzBCLE1BQU1KLEtBQUssQ0FBQ08sVUFBVSxDQUFDLFlBQVlKO0FBQ3REO0FBRUFGLGFBQWF4QixTQUFTLENBQUNNLEtBQUssR0FBRyxTQUFTQyxHQUFHO0lBQ3ZDLE9BQU8sSUFBSSxDQUFDTixPQUFPLENBQUNLLEtBQUssQ0FBQ0M7QUFDOUI7QUFFQWlCLGFBQWF4QixTQUFTLENBQUNhLEdBQUcsR0FBRztJQUN6QixPQUFPLElBQUksQ0FBQ1osT0FBTyxDQUFDWSxHQUFHO0FBQzNCO0FBR0EsY0FBYztBQUVkLFNBQVNZLGFBQWFDLE9BQU8sRUFBRUMsS0FBSztJQUNoQyxJQUFJLENBQUN4QixPQUFPLEdBQUc7SUFDZixJQUFJLENBQUM0QixXQUFXLEdBQUcsRUFBRTtJQUNyQixJQUFJLENBQUNDLGNBQWMsR0FBRztJQUV0QixJQUFJLENBQUNOLE9BQU8sR0FBR0EsV0FBVyxDQUFDO0lBQzNCLElBQUksQ0FBQ0gsS0FBSyxHQUFHSSxNQUFNSixLQUFLO0FBQzVCO0FBRUFFLGFBQWF6QixTQUFTLENBQUNNLEtBQUssR0FBRyxTQUFTRSxHQUFHO0lBQ3ZDLElBQUksQ0FBQyxJQUFJLENBQUNMLE9BQU8sRUFBRTtRQUNmLHFEQUFxRDtRQUNyRCxJQUFJLENBQUM0QixXQUFXLENBQUNFLElBQUksQ0FBQ3pCO1FBQ3RCLElBQUksQ0FBQ3dCLGNBQWMsSUFBSXhCLElBQUlHLE1BQU07UUFFakMsSUFBSSxJQUFJLENBQUNxQixjQUFjLEdBQUcsSUFDdEIsT0FBTztRQUVYLDZDQUE2QztRQUM3QyxJQUFJRSxXQUFXQyxlQUFlLElBQUksQ0FBQ0osV0FBVyxFQUFFLElBQUksQ0FBQ0wsT0FBTyxDQUFDVSxlQUFlO1FBQzVFLElBQUksQ0FBQ2pDLE9BQU8sR0FBRyxJQUFJLENBQUNvQixLQUFLLENBQUNjLFVBQVUsQ0FBQ0gsVUFBVSxJQUFJLENBQUNSLE9BQU87UUFFM0QsSUFBSVksU0FBUztRQUNiLElBQUssSUFBSTVCLElBQUksR0FBR0EsSUFBSSxJQUFJLENBQUNxQixXQUFXLENBQUNwQixNQUFNLEVBQUVELElBQ3pDNEIsVUFBVSxJQUFJLENBQUNuQyxPQUFPLENBQUNHLEtBQUssQ0FBQyxJQUFJLENBQUN5QixXQUFXLENBQUNyQixFQUFFO1FBRXBELElBQUksQ0FBQ3FCLFdBQVcsQ0FBQ3BCLE1BQU0sR0FBRyxJQUFJLENBQUNxQixjQUFjLEdBQUc7UUFDaEQsT0FBT007SUFDWDtJQUVBLE9BQU8sSUFBSSxDQUFDbkMsT0FBTyxDQUFDRyxLQUFLLENBQUNFO0FBQzlCO0FBRUFpQixhQUFhekIsU0FBUyxDQUFDYSxHQUFHLEdBQUc7SUFDekIsSUFBSSxDQUFDLElBQUksQ0FBQ1YsT0FBTyxFQUFFO1FBQ2YsSUFBSStCLFdBQVdDLGVBQWUsSUFBSSxDQUFDSixXQUFXLEVBQUUsSUFBSSxDQUFDTCxPQUFPLENBQUNVLGVBQWU7UUFDNUUsSUFBSSxDQUFDakMsT0FBTyxHQUFHLElBQUksQ0FBQ29CLEtBQUssQ0FBQ2MsVUFBVSxDQUFDSCxVQUFVLElBQUksQ0FBQ1IsT0FBTztRQUUzRCxJQUFJWSxTQUFTO1FBQ2IsSUFBSyxJQUFJNUIsSUFBSSxHQUFHQSxJQUFJLElBQUksQ0FBQ3FCLFdBQVcsQ0FBQ3BCLE1BQU0sRUFBRUQsSUFDekM0QixVQUFVLElBQUksQ0FBQ25DLE9BQU8sQ0FBQ0csS0FBSyxDQUFDLElBQUksQ0FBQ3lCLFdBQVcsQ0FBQ3JCLEVBQUU7UUFFcEQsSUFBSTZCLFFBQVEsSUFBSSxDQUFDcEMsT0FBTyxDQUFDVSxHQUFHO1FBQzVCLElBQUkwQixPQUNBRCxVQUFVQztRQUVkLElBQUksQ0FBQ1IsV0FBVyxDQUFDcEIsTUFBTSxHQUFHLElBQUksQ0FBQ3FCLGNBQWMsR0FBRztRQUNoRCxPQUFPTTtJQUNYO0lBQ0EsT0FBTyxJQUFJLENBQUNuQyxPQUFPLENBQUNVLEdBQUc7QUFDM0I7QUFFQSxTQUFTc0IsZUFBZUssSUFBSSxFQUFFSixlQUFlO0lBQ3pDLElBQUlLLElBQUksRUFBRTtJQUNWLElBQUlDLGlCQUFpQjtJQUNyQixJQUFJQyxlQUFlLEdBQUdDLGVBQWUsR0FBRyxrREFBa0Q7SUFFMUZDLFlBQ0EsSUFBSyxJQUFJbkMsSUFBSSxHQUFHQSxJQUFJOEIsS0FBSzdCLE1BQU0sRUFBRUQsSUFBSztRQUNsQyxJQUFJRixNQUFNZ0MsSUFBSSxDQUFDOUIsRUFBRTtRQUNqQixJQUFLLElBQUlPLElBQUksR0FBR0EsSUFBSVQsSUFBSUcsTUFBTSxFQUFFTSxJQUFLO1lBQ2pDd0IsRUFBRVIsSUFBSSxDQUFDekIsR0FBRyxDQUFDUyxFQUFFO1lBQ2IsSUFBSXdCLEVBQUU5QixNQUFNLEtBQUssR0FBRztnQkFDaEIsSUFBSStCLG1CQUFtQixHQUFHO29CQUN0QixtQkFBbUI7b0JBQ25CLElBQUlELENBQUMsQ0FBQyxFQUFFLEtBQUssUUFBUUEsQ0FBQyxDQUFDLEVBQUUsS0FBSyxNQUFNLE9BQU87b0JBQzNDLElBQUlBLENBQUMsQ0FBQyxFQUFFLEtBQUssUUFBUUEsQ0FBQyxDQUFDLEVBQUUsS0FBSyxNQUFNLE9BQU87Z0JBQy9DO2dCQUVBLElBQUlBLENBQUMsQ0FBQyxFQUFFLEtBQUssS0FBS0EsQ0FBQyxDQUFDLEVBQUUsS0FBSyxHQUFHRztnQkFDOUIsSUFBSUgsQ0FBQyxDQUFDLEVBQUUsS0FBSyxLQUFLQSxDQUFDLENBQUMsRUFBRSxLQUFLLEdBQUdFO2dCQUU5QkYsRUFBRTlCLE1BQU0sR0FBRztnQkFDWCtCO2dCQUVBLElBQUlBLGtCQUFrQixLQUFLO29CQUN2QixNQUFNRztnQkFDVjtZQUNKO1FBQ0o7SUFDSjtJQUVBLGtCQUFrQjtJQUNsQixpR0FBaUc7SUFDakcsa0VBQWtFO0lBQ2xFLElBQUlELGVBQWVELGNBQWMsT0FBTztJQUN4QyxJQUFJQyxlQUFlRCxjQUFjLE9BQU87SUFFeEMseURBQXlEO0lBQ3pELE9BQU9QLG1CQUFtQjtBQUM5QiIsInNvdXJjZXMiOlsid2VicGFjazovL215LWRyaXZlLy4vbm9kZV9tb2R1bGVzL2ljb252LWxpdGUvZW5jb2RpbmdzL3V0ZjE2LmpzP2E2YmEiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG52YXIgQnVmZmVyID0gcmVxdWlyZShcInNhZmVyLWJ1ZmZlclwiKS5CdWZmZXI7XG5cbi8vIE5vdGU6IFVURjE2LUxFIChvciBVQ1MyKSBjb2RlYyBpcyBOb2RlLmpzIG5hdGl2ZS4gU2VlIGVuY29kaW5ncy9pbnRlcm5hbC5qc1xuXG4vLyA9PSBVVEYxNi1CRSBjb2RlYy4gPT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuXG5leHBvcnRzLnV0ZjE2YmUgPSBVdGYxNkJFQ29kZWM7XG5mdW5jdGlvbiBVdGYxNkJFQ29kZWMoKSB7XG59XG5cblV0ZjE2QkVDb2RlYy5wcm90b3R5cGUuZW5jb2RlciA9IFV0ZjE2QkVFbmNvZGVyO1xuVXRmMTZCRUNvZGVjLnByb3RvdHlwZS5kZWNvZGVyID0gVXRmMTZCRURlY29kZXI7XG5VdGYxNkJFQ29kZWMucHJvdG90eXBlLmJvbUF3YXJlID0gdHJ1ZTtcblxuXG4vLyAtLSBFbmNvZGluZ1xuXG5mdW5jdGlvbiBVdGYxNkJFRW5jb2RlcigpIHtcbn1cblxuVXRmMTZCRUVuY29kZXIucHJvdG90eXBlLndyaXRlID0gZnVuY3Rpb24oc3RyKSB7XG4gICAgdmFyIGJ1ZiA9IEJ1ZmZlci5mcm9tKHN0ciwgJ3VjczInKTtcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IGJ1Zi5sZW5ndGg7IGkgKz0gMikge1xuICAgICAgICB2YXIgdG1wID0gYnVmW2ldOyBidWZbaV0gPSBidWZbaSsxXTsgYnVmW2krMV0gPSB0bXA7XG4gICAgfVxuICAgIHJldHVybiBidWY7XG59XG5cblV0ZjE2QkVFbmNvZGVyLnByb3RvdHlwZS5lbmQgPSBmdW5jdGlvbigpIHtcbn1cblxuXG4vLyAtLSBEZWNvZGluZ1xuXG5mdW5jdGlvbiBVdGYxNkJFRGVjb2RlcigpIHtcbiAgICB0aGlzLm92ZXJmbG93Qnl0ZSA9IC0xO1xufVxuXG5VdGYxNkJFRGVjb2Rlci5wcm90b3R5cGUud3JpdGUgPSBmdW5jdGlvbihidWYpIHtcbiAgICBpZiAoYnVmLmxlbmd0aCA9PSAwKVxuICAgICAgICByZXR1cm4gJyc7XG5cbiAgICB2YXIgYnVmMiA9IEJ1ZmZlci5hbGxvYyhidWYubGVuZ3RoICsgMSksXG4gICAgICAgIGkgPSAwLCBqID0gMDtcblxuICAgIGlmICh0aGlzLm92ZXJmbG93Qnl0ZSAhPT0gLTEpIHtcbiAgICAgICAgYnVmMlswXSA9IGJ1ZlswXTtcbiAgICAgICAgYnVmMlsxXSA9IHRoaXMub3ZlcmZsb3dCeXRlO1xuICAgICAgICBpID0gMTsgaiA9IDI7XG4gICAgfVxuXG4gICAgZm9yICg7IGkgPCBidWYubGVuZ3RoLTE7IGkgKz0gMiwgais9IDIpIHtcbiAgICAgICAgYnVmMltqXSA9IGJ1ZltpKzFdO1xuICAgICAgICBidWYyW2orMV0gPSBidWZbaV07XG4gICAgfVxuXG4gICAgdGhpcy5vdmVyZmxvd0J5dGUgPSAoaSA9PSBidWYubGVuZ3RoLTEpID8gYnVmW2J1Zi5sZW5ndGgtMV0gOiAtMTtcblxuICAgIHJldHVybiBidWYyLnNsaWNlKDAsIGopLnRvU3RyaW5nKCd1Y3MyJyk7XG59XG5cblV0ZjE2QkVEZWNvZGVyLnByb3RvdHlwZS5lbmQgPSBmdW5jdGlvbigpIHtcbiAgICB0aGlzLm92ZXJmbG93Qnl0ZSA9IC0xO1xufVxuXG5cbi8vID09IFVURi0xNiBjb2RlYyA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09XG4vLyBEZWNvZGVyIGNob29zZXMgYXV0b21hdGljYWxseSBmcm9tIFVURi0xNkxFIGFuZCBVVEYtMTZCRSB1c2luZyBCT00gYW5kIHNwYWNlLWJhc2VkIGhldXJpc3RpYy5cbi8vIERlZmF1bHRzIHRvIFVURi0xNkxFLCBhcyBpdCdzIHByZXZhbGVudCBhbmQgZGVmYXVsdCBpbiBOb2RlLlxuLy8gaHR0cDovL2VuLndpa2lwZWRpYS5vcmcvd2lraS9VVEYtMTYgYW5kIGh0dHA6Ly9lbmNvZGluZy5zcGVjLndoYXR3Zy5vcmcvI3V0Zi0xNmxlXG4vLyBEZWNvZGVyIGRlZmF1bHQgY2FuIGJlIGNoYW5nZWQ6IGljb252LmRlY29kZShidWYsICd1dGYxNicsIHtkZWZhdWx0RW5jb2Rpbmc6ICd1dGYtMTZiZSd9KTtcblxuLy8gRW5jb2RlciB1c2VzIFVURi0xNkxFIGFuZCBwcmVwZW5kcyBCT00gKHdoaWNoIGNhbiBiZSBvdmVycmlkZGVuIHdpdGggYWRkQk9NOiBmYWxzZSkuXG5cbmV4cG9ydHMudXRmMTYgPSBVdGYxNkNvZGVjO1xuZnVuY3Rpb24gVXRmMTZDb2RlYyhjb2RlY09wdGlvbnMsIGljb252KSB7XG4gICAgdGhpcy5pY29udiA9IGljb252O1xufVxuXG5VdGYxNkNvZGVjLnByb3RvdHlwZS5lbmNvZGVyID0gVXRmMTZFbmNvZGVyO1xuVXRmMTZDb2RlYy5wcm90b3R5cGUuZGVjb2RlciA9IFV0ZjE2RGVjb2RlcjtcblxuXG4vLyAtLSBFbmNvZGluZyAocGFzcy10aHJvdWdoKVxuXG5mdW5jdGlvbiBVdGYxNkVuY29kZXIob3B0aW9ucywgY29kZWMpIHtcbiAgICBvcHRpb25zID0gb3B0aW9ucyB8fCB7fTtcbiAgICBpZiAob3B0aW9ucy5hZGRCT00gPT09IHVuZGVmaW5lZClcbiAgICAgICAgb3B0aW9ucy5hZGRCT00gPSB0cnVlO1xuICAgIHRoaXMuZW5jb2RlciA9IGNvZGVjLmljb252LmdldEVuY29kZXIoJ3V0Zi0xNmxlJywgb3B0aW9ucyk7XG59XG5cblV0ZjE2RW5jb2Rlci5wcm90b3R5cGUud3JpdGUgPSBmdW5jdGlvbihzdHIpIHtcbiAgICByZXR1cm4gdGhpcy5lbmNvZGVyLndyaXRlKHN0cik7XG59XG5cblV0ZjE2RW5jb2Rlci5wcm90b3R5cGUuZW5kID0gZnVuY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZW5jb2Rlci5lbmQoKTtcbn1cblxuXG4vLyAtLSBEZWNvZGluZ1xuXG5mdW5jdGlvbiBVdGYxNkRlY29kZXIob3B0aW9ucywgY29kZWMpIHtcbiAgICB0aGlzLmRlY29kZXIgPSBudWxsO1xuICAgIHRoaXMuaW5pdGlhbEJ1ZnMgPSBbXTtcbiAgICB0aGlzLmluaXRpYWxCdWZzTGVuID0gMDtcblxuICAgIHRoaXMub3B0aW9ucyA9IG9wdGlvbnMgfHwge307XG4gICAgdGhpcy5pY29udiA9IGNvZGVjLmljb252O1xufVxuXG5VdGYxNkRlY29kZXIucHJvdG90eXBlLndyaXRlID0gZnVuY3Rpb24oYnVmKSB7XG4gICAgaWYgKCF0aGlzLmRlY29kZXIpIHtcbiAgICAgICAgLy8gQ29kZWMgaXMgbm90IGNob3NlbiB5ZXQuIEFjY3VtdWxhdGUgaW5pdGlhbCBieXRlcy5cbiAgICAgICAgdGhpcy5pbml0aWFsQnVmcy5wdXNoKGJ1Zik7XG4gICAgICAgIHRoaXMuaW5pdGlhbEJ1ZnNMZW4gKz0gYnVmLmxlbmd0aDtcbiAgICAgICAgXG4gICAgICAgIGlmICh0aGlzLmluaXRpYWxCdWZzTGVuIDwgMTYpIC8vIFdlIG5lZWQgbW9yZSBieXRlcyB0byB1c2Ugc3BhY2UgaGV1cmlzdGljIChzZWUgYmVsb3cpXG4gICAgICAgICAgICByZXR1cm4gJyc7XG5cbiAgICAgICAgLy8gV2UgaGF2ZSBlbm91Z2ggYnl0ZXMgLT4gZGV0ZWN0IGVuZGlhbm5lc3MuXG4gICAgICAgIHZhciBlbmNvZGluZyA9IGRldGVjdEVuY29kaW5nKHRoaXMuaW5pdGlhbEJ1ZnMsIHRoaXMub3B0aW9ucy5kZWZhdWx0RW5jb2RpbmcpO1xuICAgICAgICB0aGlzLmRlY29kZXIgPSB0aGlzLmljb252LmdldERlY29kZXIoZW5jb2RpbmcsIHRoaXMub3B0aW9ucyk7XG5cbiAgICAgICAgdmFyIHJlc1N0ciA9ICcnO1xuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHRoaXMuaW5pdGlhbEJ1ZnMubGVuZ3RoOyBpKyspXG4gICAgICAgICAgICByZXNTdHIgKz0gdGhpcy5kZWNvZGVyLndyaXRlKHRoaXMuaW5pdGlhbEJ1ZnNbaV0pO1xuXG4gICAgICAgIHRoaXMuaW5pdGlhbEJ1ZnMubGVuZ3RoID0gdGhpcy5pbml0aWFsQnVmc0xlbiA9IDA7XG4gICAgICAgIHJldHVybiByZXNTdHI7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuZGVjb2Rlci53cml0ZShidWYpO1xufVxuXG5VdGYxNkRlY29kZXIucHJvdG90eXBlLmVuZCA9IGZ1bmN0aW9uKCkge1xuICAgIGlmICghdGhpcy5kZWNvZGVyKSB7XG4gICAgICAgIHZhciBlbmNvZGluZyA9IGRldGVjdEVuY29kaW5nKHRoaXMuaW5pdGlhbEJ1ZnMsIHRoaXMub3B0aW9ucy5kZWZhdWx0RW5jb2RpbmcpO1xuICAgICAgICB0aGlzLmRlY29kZXIgPSB0aGlzLmljb252LmdldERlY29kZXIoZW5jb2RpbmcsIHRoaXMub3B0aW9ucyk7XG5cbiAgICAgICAgdmFyIHJlc1N0ciA9ICcnO1xuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHRoaXMuaW5pdGlhbEJ1ZnMubGVuZ3RoOyBpKyspXG4gICAgICAgICAgICByZXNTdHIgKz0gdGhpcy5kZWNvZGVyLndyaXRlKHRoaXMuaW5pdGlhbEJ1ZnNbaV0pO1xuXG4gICAgICAgIHZhciB0cmFpbCA9IHRoaXMuZGVjb2Rlci5lbmQoKTtcbiAgICAgICAgaWYgKHRyYWlsKVxuICAgICAgICAgICAgcmVzU3RyICs9IHRyYWlsO1xuXG4gICAgICAgIHRoaXMuaW5pdGlhbEJ1ZnMubGVuZ3RoID0gdGhpcy5pbml0aWFsQnVmc0xlbiA9IDA7XG4gICAgICAgIHJldHVybiByZXNTdHI7XG4gICAgfVxuICAgIHJldHVybiB0aGlzLmRlY29kZXIuZW5kKCk7XG59XG5cbmZ1bmN0aW9uIGRldGVjdEVuY29kaW5nKGJ1ZnMsIGRlZmF1bHRFbmNvZGluZykge1xuICAgIHZhciBiID0gW107XG4gICAgdmFyIGNoYXJzUHJvY2Vzc2VkID0gMDtcbiAgICB2YXIgYXNjaWlDaGFyc0xFID0gMCwgYXNjaWlDaGFyc0JFID0gMDsgLy8gTnVtYmVyIG9mIEFTQ0lJIGNoYXJzIHdoZW4gZGVjb2RlZCBhcyBMRSBvciBCRS5cblxuICAgIG91dGVyX2xvb3A6XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBidWZzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgIHZhciBidWYgPSBidWZzW2ldO1xuICAgICAgICBmb3IgKHZhciBqID0gMDsgaiA8IGJ1Zi5sZW5ndGg7IGorKykge1xuICAgICAgICAgICAgYi5wdXNoKGJ1ZltqXSk7XG4gICAgICAgICAgICBpZiAoYi5sZW5ndGggPT09IDIpIHtcbiAgICAgICAgICAgICAgICBpZiAoY2hhcnNQcm9jZXNzZWQgPT09IDApIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gQ2hlY2sgQk9NIGZpcnN0LlxuICAgICAgICAgICAgICAgICAgICBpZiAoYlswXSA9PT0gMHhGRiAmJiBiWzFdID09PSAweEZFKSByZXR1cm4gJ3V0Zi0xNmxlJztcbiAgICAgICAgICAgICAgICAgICAgaWYgKGJbMF0gPT09IDB4RkUgJiYgYlsxXSA9PT0gMHhGRikgcmV0dXJuICd1dGYtMTZiZSc7XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgaWYgKGJbMF0gPT09IDAgJiYgYlsxXSAhPT0gMCkgYXNjaWlDaGFyc0JFKys7XG4gICAgICAgICAgICAgICAgaWYgKGJbMF0gIT09IDAgJiYgYlsxXSA9PT0gMCkgYXNjaWlDaGFyc0xFKys7XG5cbiAgICAgICAgICAgICAgICBiLmxlbmd0aCA9IDA7XG4gICAgICAgICAgICAgICAgY2hhcnNQcm9jZXNzZWQrKztcblxuICAgICAgICAgICAgICAgIGlmIChjaGFyc1Byb2Nlc3NlZCA+PSAxMDApIHtcbiAgICAgICAgICAgICAgICAgICAgYnJlYWsgb3V0ZXJfbG9vcDtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvLyBNYWtlIGRlY2lzaW9ucy5cbiAgICAvLyBNb3N0IG9mIHRoZSB0aW1lLCB0aGUgY29udGVudCBoYXMgQVNDSUkgY2hhcnMgKFUrMDAqKiksIGJ1dCB0aGUgb3Bwb3NpdGUgKFUrKiowMCkgaXMgdW5jb21tb24uXG4gICAgLy8gU28sIHdlIGNvdW50IEFTQ0lJIGFzIGlmIGl0IHdhcyBMRSBvciBCRSwgYW5kIGRlY2lkZSBmcm9tIHRoYXQuXG4gICAgaWYgKGFzY2lpQ2hhcnNCRSA+IGFzY2lpQ2hhcnNMRSkgcmV0dXJuICd1dGYtMTZiZSc7XG4gICAgaWYgKGFzY2lpQ2hhcnNCRSA8IGFzY2lpQ2hhcnNMRSkgcmV0dXJuICd1dGYtMTZsZSc7XG5cbiAgICAvLyBDb3VsZG4ndCBkZWNpZGUgKGxpa2VseSBhbGwgemVyb3Mgb3Igbm90IGVub3VnaCBkYXRhKS5cbiAgICByZXR1cm4gZGVmYXVsdEVuY29kaW5nIHx8ICd1dGYtMTZsZSc7XG59XG5cblxuIl0sIm5hbWVzIjpbIkJ1ZmZlciIsInJlcXVpcmUiLCJleHBvcnRzIiwidXRmMTZiZSIsIlV0ZjE2QkVDb2RlYyIsInByb3RvdHlwZSIsImVuY29kZXIiLCJVdGYxNkJFRW5jb2RlciIsImRlY29kZXIiLCJVdGYxNkJFRGVjb2RlciIsImJvbUF3YXJlIiwid3JpdGUiLCJzdHIiLCJidWYiLCJmcm9tIiwiaSIsImxlbmd0aCIsInRtcCIsImVuZCIsIm92ZXJmbG93Qnl0ZSIsImJ1ZjIiLCJhbGxvYyIsImoiLCJzbGljZSIsInRvU3RyaW5nIiwidXRmMTYiLCJVdGYxNkNvZGVjIiwiY29kZWNPcHRpb25zIiwiaWNvbnYiLCJVdGYxNkVuY29kZXIiLCJVdGYxNkRlY29kZXIiLCJvcHRpb25zIiwiY29kZWMiLCJhZGRCT00iLCJ1bmRlZmluZWQiLCJnZXRFbmNvZGVyIiwiaW5pdGlhbEJ1ZnMiLCJpbml0aWFsQnVmc0xlbiIsInB1c2giLCJlbmNvZGluZyIsImRldGVjdEVuY29kaW5nIiwiZGVmYXVsdEVuY29kaW5nIiwiZ2V0RGVjb2RlciIsInJlc1N0ciIsInRyYWlsIiwiYnVmcyIsImIiLCJjaGFyc1Byb2Nlc3NlZCIsImFzY2lpQ2hhcnNMRSIsImFzY2lpQ2hhcnNCRSIsIm91dGVyX2xvb3AiXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/utf16.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/utf32.js":
/*!****************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/utf32.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// == UTF32-LE/BE codec. ==========================================================\nexports._utf32 = Utf32Codec;\nfunction Utf32Codec(codecOptions, iconv) {\n    this.iconv = iconv;\n    this.bomAware = true;\n    this.isLE = codecOptions.isLE;\n}\nexports.utf32le = {\n    type: \"_utf32\",\n    isLE: true\n};\nexports.utf32be = {\n    type: \"_utf32\",\n    isLE: false\n};\n// Aliases\nexports.ucs4le = \"utf32le\";\nexports.ucs4be = \"utf32be\";\nUtf32Codec.prototype.encoder = Utf32Encoder;\nUtf32Codec.prototype.decoder = Utf32Decoder;\n// -- Encoding\nfunction Utf32Encoder(options, codec) {\n    this.isLE = codec.isLE;\n    this.highSurrogate = 0;\n}\nUtf32Encoder.prototype.write = function(str) {\n    var src = Buffer.from(str, \"ucs2\");\n    var dst = Buffer.alloc(src.length * 2);\n    var write32 = this.isLE ? dst.writeUInt32LE : dst.writeUInt32BE;\n    var offset = 0;\n    for(var i = 0; i < src.length; i += 2){\n        var code = src.readUInt16LE(i);\n        var isHighSurrogate = 0xD800 <= code && code < 0xDC00;\n        var isLowSurrogate = 0xDC00 <= code && code < 0xE000;\n        if (this.highSurrogate) {\n            if (isHighSurrogate || !isLowSurrogate) {\n                // There shouldn't be two high surrogates in a row, nor a high surrogate which isn't followed by a low\n                // surrogate. If this happens, keep the pending high surrogate as a stand-alone semi-invalid character\n                // (technically wrong, but expected by some applications, like Windows file names).\n                write32.call(dst, this.highSurrogate, offset);\n                offset += 4;\n            } else {\n                // Create 32-bit value from high and low surrogates;\n                var codepoint = (this.highSurrogate - 0xD800 << 10 | code - 0xDC00) + 0x10000;\n                write32.call(dst, codepoint, offset);\n                offset += 4;\n                this.highSurrogate = 0;\n                continue;\n            }\n        }\n        if (isHighSurrogate) this.highSurrogate = code;\n        else {\n            // Even if the current character is a low surrogate, with no previous high surrogate, we'll\n            // encode it as a semi-invalid stand-alone character for the same reasons expressed above for\n            // unpaired high surrogates.\n            write32.call(dst, code, offset);\n            offset += 4;\n            this.highSurrogate = 0;\n        }\n    }\n    if (offset < dst.length) dst = dst.slice(0, offset);\n    return dst;\n};\nUtf32Encoder.prototype.end = function() {\n    // Treat any leftover high surrogate as a semi-valid independent character.\n    if (!this.highSurrogate) return;\n    var buf = Buffer.alloc(4);\n    if (this.isLE) buf.writeUInt32LE(this.highSurrogate, 0);\n    else buf.writeUInt32BE(this.highSurrogate, 0);\n    this.highSurrogate = 0;\n    return buf;\n};\n// -- Decoding\nfunction Utf32Decoder(options, codec) {\n    this.isLE = codec.isLE;\n    this.badChar = codec.iconv.defaultCharUnicode.charCodeAt(0);\n    this.overflow = [];\n}\nUtf32Decoder.prototype.write = function(src) {\n    if (src.length === 0) return \"\";\n    var i = 0;\n    var codepoint = 0;\n    var dst = Buffer.alloc(src.length + 4);\n    var offset = 0;\n    var isLE = this.isLE;\n    var overflow = this.overflow;\n    var badChar = this.badChar;\n    if (overflow.length > 0) {\n        for(; i < src.length && overflow.length < 4; i++)overflow.push(src[i]);\n        if (overflow.length === 4) {\n            // NOTE: codepoint is a signed int32 and can be negative.\n            // NOTE: We copied this block from below to help V8 optimize it (it works with array, not buffer).\n            if (isLE) {\n                codepoint = overflow[i] | overflow[i + 1] << 8 | overflow[i + 2] << 16 | overflow[i + 3] << 24;\n            } else {\n                codepoint = overflow[i + 3] | overflow[i + 2] << 8 | overflow[i + 1] << 16 | overflow[i] << 24;\n            }\n            overflow.length = 0;\n            offset = _writeCodepoint(dst, offset, codepoint, badChar);\n        }\n    }\n    // Main loop. Should be as optimized as possible.\n    for(; i < src.length - 3; i += 4){\n        // NOTE: codepoint is a signed int32 and can be negative.\n        if (isLE) {\n            codepoint = src[i] | src[i + 1] << 8 | src[i + 2] << 16 | src[i + 3] << 24;\n        } else {\n            codepoint = src[i + 3] | src[i + 2] << 8 | src[i + 1] << 16 | src[i] << 24;\n        }\n        offset = _writeCodepoint(dst, offset, codepoint, badChar);\n    }\n    // Keep overflowing bytes.\n    for(; i < src.length; i++){\n        overflow.push(src[i]);\n    }\n    return dst.slice(0, offset).toString(\"ucs2\");\n};\nfunction _writeCodepoint(dst, offset, codepoint, badChar) {\n    // NOTE: codepoint is signed int32 and can be negative. We keep it that way to help V8 with optimizations.\n    if (codepoint < 0 || codepoint > 0x10FFFF) {\n        // Not a valid Unicode codepoint\n        codepoint = badChar;\n    }\n    // Ephemeral Planes: Write high surrogate.\n    if (codepoint >= 0x10000) {\n        codepoint -= 0x10000;\n        var high = 0xD800 | codepoint >> 10;\n        dst[offset++] = high & 0xff;\n        dst[offset++] = high >> 8;\n        // Low surrogate is written below.\n        var codepoint = 0xDC00 | codepoint & 0x3FF;\n    }\n    // Write BMP char or low surrogate.\n    dst[offset++] = codepoint & 0xff;\n    dst[offset++] = codepoint >> 8;\n    return offset;\n}\n;\nUtf32Decoder.prototype.end = function() {\n    this.overflow.length = 0;\n};\n// == UTF-32 Auto codec =============================================================\n// Decoder chooses automatically from UTF-32LE and UTF-32BE using BOM and space-based heuristic.\n// Defaults to UTF-32LE. http://en.wikipedia.org/wiki/UTF-32\n// Encoder/decoder default can be changed: iconv.decode(buf, 'utf32', {defaultEncoding: 'utf-32be'});\n// Encoder prepends BOM (which can be overridden with (addBOM: false}).\nexports.utf32 = Utf32AutoCodec;\nexports.ucs4 = \"utf32\";\nfunction Utf32AutoCodec(options, iconv) {\n    this.iconv = iconv;\n}\nUtf32AutoCodec.prototype.encoder = Utf32AutoEncoder;\nUtf32AutoCodec.prototype.decoder = Utf32AutoDecoder;\n// -- Encoding\nfunction Utf32AutoEncoder(options, codec) {\n    options = options || {};\n    if (options.addBOM === undefined) options.addBOM = true;\n    this.encoder = codec.iconv.getEncoder(options.defaultEncoding || \"utf-32le\", options);\n}\nUtf32AutoEncoder.prototype.write = function(str) {\n    return this.encoder.write(str);\n};\nUtf32AutoEncoder.prototype.end = function() {\n    return this.encoder.end();\n};\n// -- Decoding\nfunction Utf32AutoDecoder(options, codec) {\n    this.decoder = null;\n    this.initialBufs = [];\n    this.initialBufsLen = 0;\n    this.options = options || {};\n    this.iconv = codec.iconv;\n}\nUtf32AutoDecoder.prototype.write = function(buf) {\n    if (!this.decoder) {\n        // Codec is not chosen yet. Accumulate initial bytes.\n        this.initialBufs.push(buf);\n        this.initialBufsLen += buf.length;\n        if (this.initialBufsLen < 32) return \"\";\n        // We have enough bytes -> detect endianness.\n        var encoding = detectEncoding(this.initialBufs, this.options.defaultEncoding);\n        this.decoder = this.iconv.getDecoder(encoding, this.options);\n        var resStr = \"\";\n        for(var i = 0; i < this.initialBufs.length; i++)resStr += this.decoder.write(this.initialBufs[i]);\n        this.initialBufs.length = this.initialBufsLen = 0;\n        return resStr;\n    }\n    return this.decoder.write(buf);\n};\nUtf32AutoDecoder.prototype.end = function() {\n    if (!this.decoder) {\n        var encoding = detectEncoding(this.initialBufs, this.options.defaultEncoding);\n        this.decoder = this.iconv.getDecoder(encoding, this.options);\n        var resStr = \"\";\n        for(var i = 0; i < this.initialBufs.length; i++)resStr += this.decoder.write(this.initialBufs[i]);\n        var trail = this.decoder.end();\n        if (trail) resStr += trail;\n        this.initialBufs.length = this.initialBufsLen = 0;\n        return resStr;\n    }\n    return this.decoder.end();\n};\nfunction detectEncoding(bufs, defaultEncoding) {\n    var b = [];\n    var charsProcessed = 0;\n    var invalidLE = 0, invalidBE = 0; // Number of invalid chars when decoded as LE or BE.\n    var bmpCharsLE = 0, bmpCharsBE = 0; // Number of BMP chars when decoded as LE or BE.\n    outer_loop: for(var i = 0; i < bufs.length; i++){\n        var buf = bufs[i];\n        for(var j = 0; j < buf.length; j++){\n            b.push(buf[j]);\n            if (b.length === 4) {\n                if (charsProcessed === 0) {\n                    // Check BOM first.\n                    if (b[0] === 0xFF && b[1] === 0xFE && b[2] === 0 && b[3] === 0) {\n                        return \"utf-32le\";\n                    }\n                    if (b[0] === 0 && b[1] === 0 && b[2] === 0xFE && b[3] === 0xFF) {\n                        return \"utf-32be\";\n                    }\n                }\n                if (b[0] !== 0 || b[1] > 0x10) invalidBE++;\n                if (b[3] !== 0 || b[2] > 0x10) invalidLE++;\n                if (b[0] === 0 && b[1] === 0 && (b[2] !== 0 || b[3] !== 0)) bmpCharsBE++;\n                if ((b[0] !== 0 || b[1] !== 0) && b[2] === 0 && b[3] === 0) bmpCharsLE++;\n                b.length = 0;\n                charsProcessed++;\n                if (charsProcessed >= 100) {\n                    break outer_loop;\n                }\n            }\n        }\n    }\n    // Make decisions.\n    if (bmpCharsBE - invalidBE > bmpCharsLE - invalidLE) return \"utf-32be\";\n    if (bmpCharsBE - invalidBE < bmpCharsLE - invalidLE) return \"utf-32le\";\n    // Couldn't decide (likely all zeros or not enough data).\n    return defaultEncoding || \"utf-32le\";\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/utf32.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/utf7.js":
/*!***************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/utf7.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// UTF-7 codec, according to https://tools.ietf.org/html/rfc2152\n// See also below a UTF-7-IMAP codec, according to http://tools.ietf.org/html/rfc3501#section-5.1.3\nexports.utf7 = Utf7Codec;\nexports.unicode11utf7 = \"utf7\"; // Alias UNICODE-1-1-UTF-7\nfunction Utf7Codec(codecOptions, iconv) {\n    this.iconv = iconv;\n}\n;\nUtf7Codec.prototype.encoder = Utf7Encoder;\nUtf7Codec.prototype.decoder = Utf7Decoder;\nUtf7Codec.prototype.bomAware = true;\n// -- Encoding\nvar nonDirectChars = /[^A-Za-z0-9'\\(\\),-\\.\\/:\\? \\n\\r\\t]+/g;\nfunction Utf7Encoder(options, codec) {\n    this.iconv = codec.iconv;\n}\nUtf7Encoder.prototype.write = function(str) {\n    // Naive implementation.\n    // Non-direct chars are encoded as \"+<base64>-\"; single \"+\" char is encoded as \"+-\".\n    return Buffer.from(str.replace(nonDirectChars, (function(chunk) {\n        return \"+\" + (chunk === \"+\" ? \"\" : this.iconv.encode(chunk, \"utf16-be\").toString(\"base64\").replace(/=+$/, \"\")) + \"-\";\n    }).bind(this)));\n};\nUtf7Encoder.prototype.end = function() {};\n// -- Decoding\nfunction Utf7Decoder(options, codec) {\n    this.iconv = codec.iconv;\n    this.inBase64 = false;\n    this.base64Accum = \"\";\n}\nvar base64Regex = /[A-Za-z0-9\\/+]/;\nvar base64Chars = [];\nfor(var i = 0; i < 256; i++)base64Chars[i] = base64Regex.test(String.fromCharCode(i));\nvar plusChar = \"+\".charCodeAt(0), minusChar = \"-\".charCodeAt(0), andChar = \"&\".charCodeAt(0);\nUtf7Decoder.prototype.write = function(buf) {\n    var res = \"\", lastI = 0, inBase64 = this.inBase64, base64Accum = this.base64Accum;\n    // The decoder is more involved as we must handle chunks in stream.\n    for(var i = 0; i < buf.length; i++){\n        if (!inBase64) {\n            // Write direct chars until '+'\n            if (buf[i] == plusChar) {\n                res += this.iconv.decode(buf.slice(lastI, i), \"ascii\"); // Write direct chars.\n                lastI = i + 1;\n                inBase64 = true;\n            }\n        } else {\n            if (!base64Chars[buf[i]]) {\n                if (i == lastI && buf[i] == minusChar) {\n                    res += \"+\";\n                } else {\n                    var b64str = base64Accum + this.iconv.decode(buf.slice(lastI, i), \"ascii\");\n                    res += this.iconv.decode(Buffer.from(b64str, \"base64\"), \"utf16-be\");\n                }\n                if (buf[i] != minusChar) i--;\n                lastI = i + 1;\n                inBase64 = false;\n                base64Accum = \"\";\n            }\n        }\n    }\n    if (!inBase64) {\n        res += this.iconv.decode(buf.slice(lastI), \"ascii\"); // Write direct chars.\n    } else {\n        var b64str = base64Accum + this.iconv.decode(buf.slice(lastI), \"ascii\");\n        var canBeDecoded = b64str.length - b64str.length % 8; // Minimal chunk: 2 quads -> 2x3 bytes -> 3 chars.\n        base64Accum = b64str.slice(canBeDecoded); // The rest will be decoded in future.\n        b64str = b64str.slice(0, canBeDecoded);\n        res += this.iconv.decode(Buffer.from(b64str, \"base64\"), \"utf16-be\");\n    }\n    this.inBase64 = inBase64;\n    this.base64Accum = base64Accum;\n    return res;\n};\nUtf7Decoder.prototype.end = function() {\n    var res = \"\";\n    if (this.inBase64 && this.base64Accum.length > 0) res = this.iconv.decode(Buffer.from(this.base64Accum, \"base64\"), \"utf16-be\");\n    this.inBase64 = false;\n    this.base64Accum = \"\";\n    return res;\n};\n// UTF-7-IMAP codec.\n// RFC3501 Sec. 5.1.3 Modified UTF-7 (http://tools.ietf.org/html/rfc3501#section-5.1.3)\n// Differences:\n//  * Base64 part is started by \"&\" instead of \"+\"\n//  * Direct characters are 0x20-0x7E, except \"&\" (0x26)\n//  * In Base64, \",\" is used instead of \"/\"\n//  * Base64 must not be used to represent direct characters.\n//  * No implicit shift back from Base64 (should always end with '-')\n//  * String must end in non-shifted position.\n//  * \"-&\" while in base64 is not allowed.\nexports.utf7imap = Utf7IMAPCodec;\nfunction Utf7IMAPCodec(codecOptions, iconv) {\n    this.iconv = iconv;\n}\n;\nUtf7IMAPCodec.prototype.encoder = Utf7IMAPEncoder;\nUtf7IMAPCodec.prototype.decoder = Utf7IMAPDecoder;\nUtf7IMAPCodec.prototype.bomAware = true;\n// -- Encoding\nfunction Utf7IMAPEncoder(options, codec) {\n    this.iconv = codec.iconv;\n    this.inBase64 = false;\n    this.base64Accum = Buffer.alloc(6);\n    this.base64AccumIdx = 0;\n}\nUtf7IMAPEncoder.prototype.write = function(str) {\n    var inBase64 = this.inBase64, base64Accum = this.base64Accum, base64AccumIdx = this.base64AccumIdx, buf = Buffer.alloc(str.length * 5 + 10), bufIdx = 0;\n    for(var i = 0; i < str.length; i++){\n        var uChar = str.charCodeAt(i);\n        if (0x20 <= uChar && uChar <= 0x7E) {\n            if (inBase64) {\n                if (base64AccumIdx > 0) {\n                    bufIdx += buf.write(base64Accum.slice(0, base64AccumIdx).toString(\"base64\").replace(/\\//g, \",\").replace(/=+$/, \"\"), bufIdx);\n                    base64AccumIdx = 0;\n                }\n                buf[bufIdx++] = minusChar; // Write '-', then go to direct mode.\n                inBase64 = false;\n            }\n            if (!inBase64) {\n                buf[bufIdx++] = uChar; // Write direct character\n                if (uChar === andChar) buf[bufIdx++] = minusChar;\n            }\n        } else {\n            if (!inBase64) {\n                buf[bufIdx++] = andChar; // Write '&', then go to base64 mode.\n                inBase64 = true;\n            }\n            if (inBase64) {\n                base64Accum[base64AccumIdx++] = uChar >> 8;\n                base64Accum[base64AccumIdx++] = uChar & 0xFF;\n                if (base64AccumIdx == base64Accum.length) {\n                    bufIdx += buf.write(base64Accum.toString(\"base64\").replace(/\\//g, \",\"), bufIdx);\n                    base64AccumIdx = 0;\n                }\n            }\n        }\n    }\n    this.inBase64 = inBase64;\n    this.base64AccumIdx = base64AccumIdx;\n    return buf.slice(0, bufIdx);\n};\nUtf7IMAPEncoder.prototype.end = function() {\n    var buf = Buffer.alloc(10), bufIdx = 0;\n    if (this.inBase64) {\n        if (this.base64AccumIdx > 0) {\n            bufIdx += buf.write(this.base64Accum.slice(0, this.base64AccumIdx).toString(\"base64\").replace(/\\//g, \",\").replace(/=+$/, \"\"), bufIdx);\n            this.base64AccumIdx = 0;\n        }\n        buf[bufIdx++] = minusChar; // Write '-', then go to direct mode.\n        this.inBase64 = false;\n    }\n    return buf.slice(0, bufIdx);\n};\n// -- Decoding\nfunction Utf7IMAPDecoder(options, codec) {\n    this.iconv = codec.iconv;\n    this.inBase64 = false;\n    this.base64Accum = \"\";\n}\nvar base64IMAPChars = base64Chars.slice();\nbase64IMAPChars[\",\".charCodeAt(0)] = true;\nUtf7IMAPDecoder.prototype.write = function(buf) {\n    var res = \"\", lastI = 0, inBase64 = this.inBase64, base64Accum = this.base64Accum;\n    // The decoder is more involved as we must handle chunks in stream.\n    // It is forgiving, closer to standard UTF-7 (for example, '-' is optional at the end).\n    for(var i = 0; i < buf.length; i++){\n        if (!inBase64) {\n            // Write direct chars until '&'\n            if (buf[i] == andChar) {\n                res += this.iconv.decode(buf.slice(lastI, i), \"ascii\"); // Write direct chars.\n                lastI = i + 1;\n                inBase64 = true;\n            }\n        } else {\n            if (!base64IMAPChars[buf[i]]) {\n                if (i == lastI && buf[i] == minusChar) {\n                    res += \"&\";\n                } else {\n                    var b64str = base64Accum + this.iconv.decode(buf.slice(lastI, i), \"ascii\").replace(/,/g, \"/\");\n                    res += this.iconv.decode(Buffer.from(b64str, \"base64\"), \"utf16-be\");\n                }\n                if (buf[i] != minusChar) i--;\n                lastI = i + 1;\n                inBase64 = false;\n                base64Accum = \"\";\n            }\n        }\n    }\n    if (!inBase64) {\n        res += this.iconv.decode(buf.slice(lastI), \"ascii\"); // Write direct chars.\n    } else {\n        var b64str = base64Accum + this.iconv.decode(buf.slice(lastI), \"ascii\").replace(/,/g, \"/\");\n        var canBeDecoded = b64str.length - b64str.length % 8; // Minimal chunk: 2 quads -> 2x3 bytes -> 3 chars.\n        base64Accum = b64str.slice(canBeDecoded); // The rest will be decoded in future.\n        b64str = b64str.slice(0, canBeDecoded);\n        res += this.iconv.decode(Buffer.from(b64str, \"base64\"), \"utf16-be\");\n    }\n    this.inBase64 = inBase64;\n    this.base64Accum = base64Accum;\n    return res;\n};\nUtf7IMAPDecoder.prototype.end = function() {\n    var res = \"\";\n    if (this.inBase64 && this.base64Accum.length > 0) res = this.iconv.decode(Buffer.from(this.base64Accum, \"base64\"), \"utf16-be\");\n    this.inBase64 = false;\n    this.base64Accum = \"\";\n    return res;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/encodings/utf7.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/lib/bom-handling.js":
/*!*****************************************************!*\
  !*** ./node_modules/iconv-lite/lib/bom-handling.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports) => {

eval("\nvar BOMChar = \"\\uFEFF\";\nexports.PrependBOM = PrependBOMWrapper;\nfunction PrependBOMWrapper(encoder, options) {\n    this.encoder = encoder;\n    this.addBOM = true;\n}\nPrependBOMWrapper.prototype.write = function(str) {\n    if (this.addBOM) {\n        str = BOMChar + str;\n        this.addBOM = false;\n    }\n    return this.encoder.write(str);\n};\nPrependBOMWrapper.prototype.end = function() {\n    return this.encoder.end();\n};\n//------------------------------------------------------------------------------\nexports.StripBOM = StripBOMWrapper;\nfunction StripBOMWrapper(decoder, options) {\n    this.decoder = decoder;\n    this.pass = false;\n    this.options = options || {};\n}\nStripBOMWrapper.prototype.write = function(buf) {\n    var res = this.decoder.write(buf);\n    if (this.pass || !res) return res;\n    if (res[0] === BOMChar) {\n        res = res.slice(1);\n        if (typeof this.options.stripBOM === \"function\") this.options.stripBOM();\n    }\n    this.pass = true;\n    return res;\n};\nStripBOMWrapper.prototype.end = function() {\n    return this.decoder.end();\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/lib/bom-handling.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/lib/index.js":
/*!**********************************************!*\
  !*** ./node_modules/iconv-lite/lib/index.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\nvar bomHandling = __webpack_require__(/*! ./bom-handling */ \"(action-browser)/./node_modules/iconv-lite/lib/bom-handling.js\"), iconv = module.exports;\n// All codecs and aliases are kept here, keyed by encoding name/alias.\n// They are lazy loaded in `iconv.getCodec` from `encodings/index.js`.\niconv.encodings = null;\n// Characters emitted in case of error.\niconv.defaultCharUnicode = \"�\";\niconv.defaultCharSingleByte = \"?\";\n// Public API.\niconv.encode = function encode(str, encoding, options) {\n    str = \"\" + (str || \"\"); // Ensure string.\n    var encoder = iconv.getEncoder(encoding, options);\n    var res = encoder.write(str);\n    var trail = encoder.end();\n    return trail && trail.length > 0 ? Buffer.concat([\n        res,\n        trail\n    ]) : res;\n};\niconv.decode = function decode(buf, encoding, options) {\n    if (typeof buf === \"string\") {\n        if (!iconv.skipDecodeWarning) {\n            console.error(\"Iconv-lite warning: decode()-ing strings is deprecated. Refer to https://github.com/ashtuchkin/iconv-lite/wiki/Use-Buffers-when-decoding\");\n            iconv.skipDecodeWarning = true;\n        }\n        buf = Buffer.from(\"\" + (buf || \"\"), \"binary\"); // Ensure buffer.\n    }\n    var decoder = iconv.getDecoder(encoding, options);\n    var res = decoder.write(buf);\n    var trail = decoder.end();\n    return trail ? res + trail : res;\n};\niconv.encodingExists = function encodingExists(enc) {\n    try {\n        iconv.getCodec(enc);\n        return true;\n    } catch (e) {\n        return false;\n    }\n};\n// Legacy aliases to convert functions\niconv.toEncoding = iconv.encode;\niconv.fromEncoding = iconv.decode;\n// Search for a codec in iconv.encodings. Cache codec data in iconv._codecDataCache.\niconv._codecDataCache = {};\niconv.getCodec = function getCodec(encoding) {\n    if (!iconv.encodings) iconv.encodings = __webpack_require__(/*! ../encodings */ \"(action-browser)/./node_modules/iconv-lite/encodings/index.js\"); // Lazy load all encoding definitions.\n    // Canonicalize encoding name: strip all non-alphanumeric chars and appended year.\n    var enc = iconv._canonicalizeEncoding(encoding);\n    // Traverse iconv.encodings to find actual codec.\n    var codecOptions = {};\n    while(true){\n        var codec = iconv._codecDataCache[enc];\n        if (codec) return codec;\n        var codecDef = iconv.encodings[enc];\n        switch(typeof codecDef){\n            case \"string\":\n                enc = codecDef;\n                break;\n            case \"object\":\n                for(var key in codecDef)codecOptions[key] = codecDef[key];\n                if (!codecOptions.encodingName) codecOptions.encodingName = enc;\n                enc = codecDef.type;\n                break;\n            case \"function\":\n                if (!codecOptions.encodingName) codecOptions.encodingName = enc;\n                // The codec function must load all tables and return object with .encoder and .decoder methods.\n                // It'll be called only once (for each different options object).\n                codec = new codecDef(codecOptions, iconv);\n                iconv._codecDataCache[codecOptions.encodingName] = codec; // Save it to be reused later.\n                return codec;\n            default:\n                throw new Error(\"Encoding not recognized: '\" + encoding + \"' (searched as: '\" + enc + \"')\");\n        }\n    }\n};\niconv._canonicalizeEncoding = function(encoding) {\n    // Canonicalize encoding name: strip all non-alphanumeric chars and appended year.\n    return (\"\" + encoding).toLowerCase().replace(/:\\d{4}$|[^0-9a-z]/g, \"\");\n};\niconv.getEncoder = function getEncoder(encoding, options) {\n    var codec = iconv.getCodec(encoding), encoder = new codec.encoder(options, codec);\n    if (codec.bomAware && options && options.addBOM) encoder = new bomHandling.PrependBOM(encoder, options);\n    return encoder;\n};\niconv.getDecoder = function getDecoder(encoding, options) {\n    var codec = iconv.getCodec(encoding), decoder = new codec.decoder(options, codec);\n    if (codec.bomAware && !(options && options.stripBOM === false)) decoder = new bomHandling.StripBOM(decoder, options);\n    return decoder;\n};\n// Streaming API\n// NOTE: Streaming API naturally depends on 'stream' module from Node.js. Unfortunately in browser environments this module can add\n// up to 100Kb to the output bundle. To avoid unnecessary code bloat, we don't enable Streaming API in browser by default.\n// If you would like to enable it explicitly, please add the following code to your app:\n// > iconv.enableStreamingAPI(require('stream'));\niconv.enableStreamingAPI = function enableStreamingAPI(stream_module) {\n    if (iconv.supportsStreams) return;\n    // Dependency-inject stream module to create IconvLite stream classes.\n    var streams = __webpack_require__(/*! ./streams */ \"(action-browser)/./node_modules/iconv-lite/lib/streams.js\")(stream_module);\n    // Not public API yet, but expose the stream classes.\n    iconv.IconvLiteEncoderStream = streams.IconvLiteEncoderStream;\n    iconv.IconvLiteDecoderStream = streams.IconvLiteDecoderStream;\n    // Streaming API.\n    iconv.encodeStream = function encodeStream(encoding, options) {\n        return new iconv.IconvLiteEncoderStream(iconv.getEncoder(encoding, options), options);\n    };\n    iconv.decodeStream = function decodeStream(encoding, options) {\n        return new iconv.IconvLiteDecoderStream(iconv.getDecoder(encoding, options), options);\n    };\n    iconv.supportsStreams = true;\n};\n// Enable Streaming API automatically if 'stream' module is available and non-empty (the majority of environments).\nvar stream_module;\ntry {\n    stream_module = __webpack_require__(/*! stream */ \"stream\");\n} catch (e) {}\nif (stream_module && stream_module.Transform) {\n    iconv.enableStreamingAPI(stream_module);\n} else {\n    // In rare cases where 'stream' module is not available by default, throw a helpful exception.\n    iconv.encodeStream = iconv.decodeStream = function() {\n        throw new Error(\"iconv-lite Streaming API is not enabled. Use iconv.enableStreamingAPI(require('stream')); to enable it.\");\n    };\n}\nif (false) {}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/lib/index.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/lib/streams.js":
/*!************************************************!*\
  !*** ./node_modules/iconv-lite/lib/streams.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\nvar Buffer = (__webpack_require__(/*! safer-buffer */ \"(action-browser)/./node_modules/safer-buffer/safer.js\").Buffer);\n// NOTE: Due to 'stream' module being pretty large (~100Kb, significant in browser environments), \n// we opt to dependency-inject it instead of creating a hard dependency.\nmodule.exports = function(stream_module) {\n    var Transform = stream_module.Transform;\n    // == Encoder stream =======================================================\n    function IconvLiteEncoderStream(conv, options) {\n        this.conv = conv;\n        options = options || {};\n        options.decodeStrings = false; // We accept only strings, so we don't need to decode them.\n        Transform.call(this, options);\n    }\n    IconvLiteEncoderStream.prototype = Object.create(Transform.prototype, {\n        constructor: {\n            value: IconvLiteEncoderStream\n        }\n    });\n    IconvLiteEncoderStream.prototype._transform = function(chunk, encoding, done) {\n        if (typeof chunk != \"string\") return done(new Error(\"Iconv encoding stream needs strings as its input.\"));\n        try {\n            var res = this.conv.write(chunk);\n            if (res && res.length) this.push(res);\n            done();\n        } catch (e) {\n            done(e);\n        }\n    };\n    IconvLiteEncoderStream.prototype._flush = function(done) {\n        try {\n            var res = this.conv.end();\n            if (res && res.length) this.push(res);\n            done();\n        } catch (e) {\n            done(e);\n        }\n    };\n    IconvLiteEncoderStream.prototype.collect = function(cb) {\n        var chunks = [];\n        this.on(\"error\", cb);\n        this.on(\"data\", function(chunk) {\n            chunks.push(chunk);\n        });\n        this.on(\"end\", function() {\n            cb(null, Buffer.concat(chunks));\n        });\n        return this;\n    };\n    // == Decoder stream =======================================================\n    function IconvLiteDecoderStream(conv, options) {\n        this.conv = conv;\n        options = options || {};\n        options.encoding = this.encoding = \"utf8\"; // We output strings.\n        Transform.call(this, options);\n    }\n    IconvLiteDecoderStream.prototype = Object.create(Transform.prototype, {\n        constructor: {\n            value: IconvLiteDecoderStream\n        }\n    });\n    IconvLiteDecoderStream.prototype._transform = function(chunk, encoding, done) {\n        if (!Buffer.isBuffer(chunk) && !(chunk instanceof Uint8Array)) return done(new Error(\"Iconv decoding stream needs buffers as its input.\"));\n        try {\n            var res = this.conv.write(chunk);\n            if (res && res.length) this.push(res, this.encoding);\n            done();\n        } catch (e) {\n            done(e);\n        }\n    };\n    IconvLiteDecoderStream.prototype._flush = function(done) {\n        try {\n            var res = this.conv.end();\n            if (res && res.length) this.push(res, this.encoding);\n            done();\n        } catch (e) {\n            done(e);\n        }\n    };\n    IconvLiteDecoderStream.prototype.collect = function(cb) {\n        var res = \"\";\n        this.on(\"error\", cb);\n        this.on(\"data\", function(chunk) {\n            res += chunk;\n        });\n        this.on(\"end\", function() {\n            cb(null, res);\n        });\n        return this;\n    };\n    return {\n        IconvLiteEncoderStream: IconvLiteEncoderStream,\n        IconvLiteDecoderStream: IconvLiteDecoderStream\n    };\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(action-browser)/./node_modules/iconv-lite/lib/streams.js\n");

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/big5-added.json":
/*!******************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/big5-added.json ***!
  \******************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["8740","䏰䰲䘃䖦䕸𧉧䵷䖳𧲱䳢𧳅㮕䜶䝄䱇䱀𤊿𣘗𧍒𦺋𧃒䱗𪍑䝏䗚䲅𧱬䴇䪤䚡𦬣爥𥩔𡩣𣸆𣽡晍囻"],["8767","綕夝𨮹㷴霴𧯯寛𡵞媤㘥𩺰嫑宷峼杮薓𩥅瑡璝㡵𡵓𣚞𦀡㻬"],["87a1","𥣞㫵竼龗𤅡𨤍𣇪𠪊𣉞䌊蒄龖鐯䤰蘓墖靊鈘秐稲晠権袝瑌篅枂稬剏遆㓦珄𥶹瓆鿇垳䤯呌䄱𣚎堘穲𧭥讏䚮𦺈䆁𥶙箮𢒼鿈𢓁𢓉𢓌鿉蔄𣖻䂴鿊䓡𪷿拁灮鿋"],["8840","㇀",4,"𠄌㇅𠃑𠃍㇆㇇𠃋𡿨㇈𠃊㇉㇊㇋㇌𠄎㇍㇎ĀÁǍÀĒÉĚÈŌÓǑÒ࿿Ê̄Ế࿿Ê̌ỀÊāáǎàɑēéěèīíǐìōóǒòūúǔùǖǘǚ"],["88a1","ǜü࿿ê̄ế࿿ê̌ềêɡ⏚⏛"],["8940","𪎩𡅅"],["8943","攊"],["8946","丽滝鵎釟"],["894c","𧜵撑会伨侨兖兴农凤务动医华发变团声处备夲头学实実岚庆总斉柾栄桥济炼电纤纬纺织经统缆缷艺苏药视设询车轧轮"],["89a1","琑糼緍楆竉刧"],["89ab","醌碸酞肼"],["89b0","贋胶𠧧"],["89b5","肟黇䳍鷉鸌䰾𩷶𧀎鸊𪄳㗁"],["89c1","溚舾甙"],["89c5","䤑马骏龙禇𨑬𡷊𠗐𢫦两亁亀亇亿仫伷㑌侽㹈倃傈㑽㒓㒥円夅凛凼刅争剹劐匧㗇厩㕑厰㕓参吣㕭㕲㚁咓咣咴咹哐哯唘唣唨㖘唿㖥㖿嗗㗅"],["8a40","𧶄唥"],["8a43","𠱂𠴕𥄫喐𢳆㧬𠍁蹆𤶸𩓥䁓𨂾睺𢰸㨴䟕𨅝𦧲𤷪擝𠵼𠾴𠳕𡃴撍蹾𠺖𠰋𠽤𢲩𨉖𤓓"],["8a64","𠵆𩩍𨃩䟴𤺧𢳂骲㩧𩗴㿭㔆𥋇𩟔𧣈𢵄鵮頕"],["8a76","䏙𦂥撴哣𢵌𢯊𡁷㧻𡁯"],["8aa1","𦛚𦜖𧦠擪𥁒𠱃蹨𢆡𨭌𠜱"],["8aac","䠋𠆩㿺塳𢶍"],["8ab2","𤗈𠓼𦂗𠽌𠶖啹䂻䎺"],["8abb","䪴𢩦𡂝膪飵𠶜捹㧾𢝵跀嚡摼㹃"],["8ac9","𪘁𠸉𢫏𢳉"],["8ace","𡃈𣧂㦒㨆𨊛㕸𥹉𢃇噒𠼱𢲲𩜠㒼氽𤸻"],["8adf","𧕴𢺋𢈈𪙛𨳍𠹺𠰴𦠜羓𡃏𢠃𢤹㗻𥇣𠺌𠾍𠺪㾓𠼰𠵇𡅏𠹌"],["8af6","𠺫𠮩𠵈𡃀𡄽㿹𢚖搲𠾭"],["8b40","𣏴𧘹𢯎𠵾𠵿𢱑𢱕㨘𠺘𡃇𠼮𪘲𦭐𨳒𨶙𨳊閪哌苄喹"],["8b55","𩻃鰦骶𧝞𢷮煀腭胬尜𦕲脴㞗卟𨂽醶𠻺𠸏𠹷𠻻㗝𤷫㘉𠳖嚯𢞵𡃉𠸐𠹸𡁸𡅈𨈇𡑕𠹹𤹐𢶤婔𡀝𡀞𡃵𡃶垜𠸑"],["8ba1","𧚔𨋍𠾵𠹻𥅾㜃𠾶𡆀𥋘𪊽𤧚𡠺𤅷𨉼墙剨㘚𥜽箲孨䠀䬬鼧䧧鰟鮍𥭴𣄽嗻㗲嚉丨夂𡯁屮靑𠂆乛亻㔾尣彑忄㣺扌攵歺氵氺灬爫丬犭𤣩罒礻糹罓𦉪㓁"],["8bde","𦍋耂肀𦘒𦥑卝衤见𧢲讠贝钅镸长门𨸏韦页风飞饣𩠐鱼鸟黄歯龜丷𠂇阝户钢"],["8c40","倻淾𩱳龦㷉袏𤅎灷峵䬠𥇍㕙𥴰愢𨨲辧釶熑朙玺𣊁𪄇㲋𡦀䬐磤琂冮𨜏䀉橣𪊺䈣蘏𠩯稪𩥇𨫪靕灍匤𢁾鏴盙𨧣龧矝亣俰傼丯众龨吴綋墒壐𡶶庒庙忂𢜒斋"],["8ca1","𣏹椙橃𣱣泿"],["8ca7","爀𤔅玌㻛𤨓嬕璹讃𥲤𥚕窓篬糃繬苸薗龩袐龪躹龫迏蕟駠鈡龬𨶹𡐿䁱䊢娚"],["8cc9","顨杫䉶圽"],["8cce","藖𤥻芿𧄍䲁𦵴嵻𦬕𦾾龭龮宖龯曧繛湗秊㶈䓃𣉖𢞖䎚䔶"],["8ce6","峕𣬚諹屸㴒𣕑嵸龲煗䕘𤃬𡸣䱷㥸㑊𠆤𦱁諌侴𠈹妿腬顖𩣺弻"],["8d40","𠮟"],["8d42","𢇁𨥭䄂䚻𩁹㼇龳𪆵䃸㟖䛷𦱆䅼𨚲𧏿䕭㣔𥒚䕡䔛䶉䱻䵶䗪㿈𤬏㙡䓞䒽䇭崾嵈嵖㷼㠏嶤嶹㠠㠸幂庽弥徃㤈㤔㤿㥍惗愽峥㦉憷憹懏㦸戬抐拥挘㧸嚱"],["8da1","㨃揢揻搇摚㩋擀崕嘡龟㪗斆㪽旿晓㫲暒㬢朖㭂枤栀㭘桊梄㭲㭱㭻椉楃牜楤榟榅㮼槖㯝橥橴橱檂㯬檙㯲檫檵櫔櫶殁毁毪汵沪㳋洂洆洦涁㳯涤涱渕渘温溆𨧀溻滢滚齿滨滩漤漴㵆𣽁澁澾㵪㵵熷岙㶊瀬㶑灐灔灯灿炉𠌥䏁㗱𠻘"],["8e40","𣻗垾𦻓焾𥟠㙎榢𨯩孴穉𥣡𩓙穥穽𥦬窻窰竂竃燑𦒍䇊竚竝竪䇯咲𥰁笋筕笩𥌎𥳾箢筯莜𥮴𦱿篐萡箒箸𥴠㶭𥱥蒒篺簆簵𥳁籄粃𤢂粦晽𤕸糉糇糦籴糳糵糎"],["8ea1","繧䔝𦹄絝𦻖璍綉綫焵綳緒𤁗𦀩緤㴓緵𡟹緥𨍭縝𦄡𦅚繮纒䌫鑬縧罀罁罇礶𦋐駡羗𦍑羣𡙡𠁨䕜𣝦䔃𨌺翺𦒉者耈耝耨耯𪂇𦳃耻耼聡𢜔䦉𦘦𣷣𦛨朥肧𨩈脇脚墰𢛶汿𦒘𤾸擧𡒊舘𡡞橓𤩥𤪕䑺舩𠬍𦩒𣵾俹𡓽蓢荢𦬊𤦧𣔰𡝳𣷸芪椛芳䇛"],["8f40","蕋苐茚𠸖𡞴㛁𣅽𣕚艻苢茘𣺋𦶣𦬅𦮗𣗎㶿茝嗬莅䔋𦶥莬菁菓㑾𦻔橗蕚㒖𦹂𢻯葘𥯤葱㷓䓤檧葊𣲵祘蒨𦮖𦹷𦹃蓞萏莑䒠蒓蓤𥲑䉀𥳀䕃蔴嫲𦺙䔧蕳䔖枿蘖"],["8fa1","𨘥𨘻藁𧂈蘂𡖂𧃍䕫䕪蘨㙈𡢢号𧎚虾蝱𪃸蟮𢰧螱蟚蠏噡虬桖䘏衅衆𧗠𣶹𧗤衞袜䙛袴袵揁装睷𧜏覇覊覦覩覧覼𨨥觧𧤤𧪽誜瞓釾誐𧩙竩𧬺𣾏䜓𧬸煼謌謟𥐰𥕥謿譌譍誩𤩺讐讛誯𡛟䘕衏貛𧵔𧶏貫㜥𧵓賖𧶘𧶽贒贃𡤐賛灜贑𤳉㻐起"],["9040","趩𨀂𡀔𤦊㭼𨆼𧄌竧躭躶軃鋔輙輭𨍥𨐒辥錃𪊟𠩐辳䤪𨧞𨔽𣶻廸𣉢迹𪀔𨚼𨔁𢌥㦀𦻗逷𨔼𧪾遡𨕬𨘋邨𨜓郄𨛦邮都酧㫰醩釄粬𨤳𡺉鈎沟鉁鉢𥖹銹𨫆𣲛𨬌𥗛"],["90a1","𠴱錬鍫𨫡𨯫炏嫃𨫢𨫥䥥鉄𨯬𨰹𨯿鍳鑛躼閅閦鐦閠濶䊹𢙺𨛘𡉼𣸮䧟氜陻隖䅬隣𦻕懚隶磵𨫠隽双䦡𦲸𠉴𦐐𩂯𩃥𤫑𡤕𣌊霱虂霶䨏䔽䖅𤫩灵孁霛靜𩇕靗孊𩇫靟鐥僐𣂷𣂼鞉鞟鞱鞾韀韒韠𥑬韮琜𩐳響韵𩐝𧥺䫑頴頳顋顦㬎𧅵㵑𠘰𤅜"],["9140","𥜆飊颷飈飇䫿𦴧𡛓喰飡飦飬鍸餹𤨩䭲𩡗𩤅駵騌騻騐驘𥜥㛄𩂱𩯕髠髢𩬅髴䰎鬔鬭𨘀倴鬴𦦨㣃𣁽魐魀𩴾婅𡡣鮎𤉋鰂鯿鰌𩹨鷔𩾷𪆒𪆫𪃡𪄣𪇟鵾鶃𪄴鸎梈"],["91a1","鷄𢅛𪆓𪈠𡤻𪈳鴹𪂹𪊴麐麕麞麢䴴麪麯𤍤黁㭠㧥㴝伲㞾𨰫鼂鼈䮖鐤𦶢鼗鼖鼹嚟嚊齅馸𩂋韲葿齢齩竜龎爖䮾𤥵𤦻煷𤧸𤍈𤩑玞𨯚𡣺禟𨥾𨸶鍩鏳𨩄鋬鎁鏋𨥬𤒹爗㻫睲穃烐𤑳𤏸煾𡟯炣𡢾𣖙㻇𡢅𥐯𡟸㜢𡛻𡠹㛡𡝴𡣑𥽋㜣𡛀坛𤨥𡏾𡊨"],["9240","𡏆𡒶蔃𣚦蔃葕𤦔𧅥𣸱𥕜𣻻𧁒䓴𣛮𩦝𦼦柹㜳㰕㷧塬𡤢栐䁗𣜿𤃡𤂋𤄏𦰡哋嚞𦚱嚒𠿟𠮨𠸍鏆𨬓鎜仸儫㠙𤐶亼𠑥𠍿佋侊𥙑婨𠆫𠏋㦙𠌊𠐔㐵伩𠋀𨺳𠉵諚𠈌亘"],["92a1","働儍侢伃𤨎𣺊佂倮偬傁俌俥偘僼兙兛兝兞湶𣖕𣸹𣺿浲𡢄𣺉冨凃𠗠䓝𠒣𠒒𠒑赺𨪜𠜎剙劤𠡳勡鍮䙺熌𤎌𠰠𤦬𡃤槑𠸝瑹㻞璙琔瑖玘䮎𤪼𤂍叐㖄爏𤃉喴𠍅响𠯆圝鉝雴鍦埝垍坿㘾壋媙𨩆𡛺𡝯𡜐娬妸銏婾嫏娒𥥆𡧳𡡡𤊕㛵洅瑃娡𥺃"],["9340","媁𨯗𠐓鏠璌𡌃焅䥲鐈𨧻鎽㞠尞岞幞幈𡦖𡥼𣫮廍孏𡤃𡤄㜁𡢠㛝𡛾㛓脪𨩇𡶺𣑲𨦨弌弎𡤧𡞫婫𡜻孄蘔𧗽衠恾𢡠𢘫忛㺸𢖯𢖾𩂈𦽳懀𠀾𠁆𢘛憙憘恵𢲛𢴇𤛔𩅍"],["93a1","摱𤙥𢭪㨩𢬢𣑐𩣪𢹸挷𪑛撶挱揑𤧣𢵧护𢲡搻敫楲㯴𣂎𣊭𤦉𣊫唍𣋠𡣙𩐿曎𣊉𣆳㫠䆐𥖄𨬢𥖏𡛼𥕛𥐥磮𣄃𡠪𣈴㑤𣈏𣆂𤋉暎𦴤晫䮓昰𧡰𡷫晣𣋒𣋡昞𥡲㣑𣠺𣞼㮙𣞢𣏾瓐㮖枏𤘪梶栞㯄檾㡣𣟕𤒇樳橒櫉欅𡤒攑梘橌㯗橺歗𣿀𣲚鎠鋲𨯪𨫋"],["9440","銉𨀞𨧜鑧涥漋𤧬浧𣽿㶏渄𤀼娽渊塇洤硂焻𤌚𤉶烱牐犇犔𤞏𤜥兹𤪤𠗫瑺𣻸𣙟𤩊𤤗𥿡㼆㺱𤫟𨰣𣼵悧㻳瓌琼鎇琷䒟𦷪䕑疃㽣𤳙𤴆㽘畕癳𪗆㬙瑨𨫌𤦫𤦎㫻"],["94a1","㷍𤩎㻿𤧅𤣳釺圲鍂𨫣𡡤僟𥈡𥇧睸𣈲眎眏睻𤚗𣞁㩞𤣰琸璛㺿𤪺𤫇䃈𤪖𦆮錇𥖁砞碍碈磒珐祙𧝁𥛣䄎禛蒖禥樭𣻺稺秴䅮𡛦䄲鈵秱𠵌𤦌𠊙𣶺𡝮㖗啫㕰㚪𠇔𠰍竢婙𢛵𥪯𥪜娍𠉛磰娪𥯆竾䇹籝籭䈑𥮳𥺼𥺦糍𤧹𡞰粎籼粮檲緜縇緓罎𦉡"],["9540","𦅜𧭈綗𥺂䉪𦭵𠤖柖𠁎𣗏埄𦐒𦏸𤥢翝笧𠠬𥫩𥵃笌𥸎駦虅驣樜𣐿㧢𤧷𦖭騟𦖠蒀𧄧𦳑䓪脷䐂胆脉腂𦞴飃𦩂艢艥𦩑葓𦶧蘐𧈛媆䅿𡡀嬫𡢡嫤𡣘蚠蜨𣶏蠭𧐢娂"],["95a1","衮佅袇袿裦襥襍𥚃襔𧞅𧞄𨯵𨯙𨮜𨧹㺭蒣䛵䛏㟲訽訜𩑈彍鈫𤊄旔焩烄𡡅鵭貟賩𧷜妚矃姰䍮㛔踪躧𤰉輰轊䋴汘澻𢌡䢛潹溋𡟚鯩㚵𤤯邻邗啱䤆醻鐄𨩋䁢𨫼鐧𨰝𨰻蓥訫閙閧閗閖𨴴瑅㻂𤣿𤩂𤏪㻧𣈥随𨻧𨹦𨹥㻌𤧭𤩸𣿮琒瑫㻼靁𩂰"],["9640","桇䨝𩂓𥟟靝鍨𨦉𨰦𨬯𦎾銺嬑譩䤼珹𤈛鞛靱餸𠼦巁𨯅𤪲頟𩓚鋶𩗗釥䓀𨭐𤩧𨭤飜𨩅㼀鈪䤥萔餻饍𧬆㷽馛䭯馪驜𨭥𥣈檏騡嫾騯𩣱䮐𩥈馼䮽䮗鍽塲𡌂堢𤦸"],["96a1","𡓨硄𢜟𣶸棅㵽鑘㤧慐𢞁𢥫愇鱏鱓鱻鰵鰐魿鯏𩸭鮟𪇵𪃾鴡䲮𤄄鸘䲰鴌𪆴𪃭𪃳𩤯鶥蒽𦸒𦿟𦮂藼䔳𦶤𦺄𦷰萠藮𦸀𣟗𦁤秢𣖜𣙀䤭𤧞㵢鏛銾鍈𠊿碹鉷鑍俤㑀遤𥕝砽硔碶硋𡝗𣇉𤥁㚚佲濚濙瀞瀞吔𤆵垻壳垊鴖埗焴㒯𤆬燫𦱀𤾗嬨𡞵𨩉"],["9740","愌嫎娋䊼𤒈㜬䭻𨧼鎻鎸𡣖𠼝葲𦳀𡐓𤋺𢰦𤏁妔𣶷𦝁綨𦅛𦂤𤦹𤦋𨧺鋥珢㻩璴𨭣𡢟㻡𤪳櫘珳珻㻖𤨾𤪔𡟙𤩦𠎧𡐤𤧥瑈𤤖炥𤥶銄珦鍟𠓾錱𨫎𨨖鎆𨯧𥗕䤵𨪂煫"],["97a1","𤥃𠳿嚤𠘚𠯫𠲸唂秄𡟺緾𡛂𤩐𡡒䔮鐁㜊𨫀𤦭妰𡢿𡢃𧒄媡㛢𣵛㚰鉟婹𨪁𡡢鍴㳍𠪴䪖㦊僴㵩㵌𡎜煵䋻𨈘渏𩃤䓫浗𧹏灧沯㳖𣿭𣸭渂漌㵯𠏵畑㚼㓈䚀㻚䡱姄鉮䤾轁𨰜𦯀堒埈㛖𡑒烾𤍢𤩱𢿣𡊰𢎽梹楧𡎘𣓥𧯴𣛟𨪃𣟖𣏺𤲟樚𣚭𦲷萾䓟䓎"],["9840","𦴦𦵑𦲂𦿞漗𧄉茽𡜺菭𦲀𧁓𡟛妉媂𡞳婡婱𡤅𤇼㜭姯𡜼㛇熎鎐暚𤊥婮娫𤊓樫𣻹𧜶𤑛𤋊焝𤉙𨧡侰𦴨峂𤓎𧹍𤎽樌𤉖𡌄炦焳𤏩㶥泟勇𤩏繥姫崯㷳彜𤩝𡟟綤萦"],["98a1","咅𣫺𣌀𠈔坾𠣕𠘙㿥𡾞𪊶瀃𩅛嵰玏糓𨩙𩐠俈翧狍猐𧫴猸猹𥛶獁獈㺩𧬘遬燵𤣲珡臶㻊県㻑沢国琙琞琟㻢㻰㻴㻺瓓㼎㽓畂畭畲疍㽼痈痜㿀癍㿗癴㿜発𤽜熈嘣覀塩䀝睃䀹条䁅㗛瞘䁪䁯属瞾矋売砘点砜䂨砹硇硑硦葈𥔵礳栃礲䄃"],["9940","䄉禑禙辻稆込䅧窑䆲窼艹䇄竏竛䇏両筢筬筻簒簛䉠䉺类粜䊌粸䊔糭输烀𠳏総緔緐緽羮羴犟䎗耠耥笹耮耱联㷌垴炠肷胩䏭脌猪脎脒畠脔䐁㬹腖腙腚"],["99a1","䐓堺腼膄䐥膓䐭膥埯臁臤艔䒏芦艶苊苘苿䒰荗险榊萅烵葤惣蒈䔄蒾蓡蓸蔐蔸蕒䔻蕯蕰藠䕷虲蚒蚲蛯际螋䘆䘗袮裿褤襇覑𧥧訩訸誔誴豑賔賲贜䞘塟跃䟭仮踺嗘坔蹱嗵躰䠷軎転軤軭軲辷迁迊迌逳駄䢭飠鈓䤞鈨鉘鉫銱銮銿"],["9a40","鋣鋫鋳鋴鋽鍃鎄鎭䥅䥑麿鐗匁鐝鐭鐾䥪鑔鑹锭関䦧间阳䧥枠䨤靀䨵鞲韂噔䫤惨颹䬙飱塄餎餙冴餜餷饂饝饢䭰駅䮝騼鬏窃魩鮁鯝鯱鯴䱭鰠㝯𡯂鵉鰺"],["9aa1","黾噐鶓鶽鷀鷼银辶鹻麬麱麽黆铜黢黱黸竈齄𠂔𠊷𠎠椚铃妬𠓗塀铁㞹𠗕𠘕𠙶𡚺块煳𠫂𠫍𠮿呪吆𠯋咞𠯻𠰻𠱓𠱥𠱼惧𠲍噺𠲵𠳝𠳭𠵯𠶲𠷈楕鰯螥𠸄𠸎𠻗𠾐𠼭𠹳尠𠾼帋𡁜𡁏𡁶朞𡁻𡂈𡂖㙇𡂿𡃓𡄯𡄻卤蒭𡋣𡍵𡌶讁𡕷𡘙𡟃𡟇乸炻𡠭𡥪"],["9b40","𡨭𡩅𡰪𡱰𡲬𡻈拃𡻕𡼕熘桕𢁅槩㛈𢉼𢏗𢏺𢜪𢡱𢥏苽𢥧𢦓𢫕覥𢫨辠𢬎鞸𢬿顇骽𢱌"],["9b62","𢲈𢲷𥯨𢴈𢴒𢶷𢶕𢹂𢽴𢿌𣀳𣁦𣌟𣏞徱晈暿𧩹𣕧𣗳爁𤦺矗𣘚𣜖纇𠍆墵朎"],["9ba1","椘𣪧𧙗𥿢𣸑𣺹𧗾𢂚䣐䪸𤄙𨪚𤋮𤌍𤀻𤌴𤎖𤩅𠗊凒𠘑妟𡺨㮾𣳿𤐄𤓖垈𤙴㦛𤜯𨗨𩧉㝢𢇃譞𨭎駖𤠒𤣻𤨕爉𤫀𠱸奥𤺥𤾆𠝹軚𥀬劏圿煱𥊙𥐙𣽊𤪧喼𥑆𥑮𦭒釔㑳𥔿𧘲𥕞䜘𥕢𥕦𥟇𤤿𥡝偦㓻𣏌惞𥤃䝼𨥈𥪮𥮉𥰆𡶐垡煑澶𦄂𧰒遖𦆲𤾚譢𦐂𦑊"],["9c40","嵛𦯷輶𦒄𡤜諪𤧶𦒈𣿯𦔒䯀𦖿𦚵𢜛鑥𥟡憕娧晉侻嚹𤔡𦛼乪𤤴陖涏𦲽㘘襷𦞙𦡮𦐑𦡞營𦣇筂𩃀𠨑𦤦鄄𦤹穅鷰𦧺騦𦨭㙟𦑩𠀡禃𦨴𦭛崬𣔙菏𦮝䛐𦲤画补𦶮墶"],["9ca1","㜜𢖍𧁋𧇍㱔𧊀𧊅銁𢅺𧊋錰𧋦𤧐氹钟𧑐𠻸蠧裵𢤦𨑳𡞱溸𤨪𡠠㦤㚹尐秣䔿暶𩲭𩢤襃𧟌𧡘囖䃟𡘊㦡𣜯𨃨𡏅熭荦𧧝𩆨婧䲷𧂯𨦫𧧽𧨊𧬋𧵦𤅺筃祾𨀉澵𪋟樃𨌘厢𦸇鎿栶靝𨅯𨀣𦦵𡏭𣈯𨁈嶅𨰰𨂃圕頣𨥉嶫𤦈斾槕叒𤪥𣾁㰑朶𨂐𨃴𨄮𡾡𨅏"],["9d40","𨆉𨆯𨈚𨌆𨌯𨎊㗊𨑨𨚪䣺揦𨥖砈鉕𨦸䏲𨧧䏟𨧨𨭆𨯔姸𨰉輋𨿅𩃬筑𩄐𩄼㷷𩅞𤫊运犏嚋𩓧𩗩𩖰𩖸𩜲𩣑𩥉𩥪𩧃𩨨𩬎𩵚𩶛纟𩻸𩼣䲤镇𪊓熢𪋿䶑递𪗋䶜𠲜达嗁"],["9da1","辺𢒰边𤪓䔉繿潖檱仪㓤𨬬𧢝㜺躀𡟵𨀤𨭬𨮙𧨾𦚯㷫𧙕𣲷𥘵𥥖亚𥺁𦉘嚿𠹭踎孭𣺈𤲞揞拐𡟶𡡻攰嘭𥱊吚𥌑㷆𩶘䱽嘢嘞罉𥻘奵𣵀蝰东𠿪𠵉𣚺脗鵞贘瘻鱅癎瞹鍅吲腈苷嘥脲萘肽嗪祢噃吖𠺝㗎嘅嗱曱𨋢㘭甴嗰喺咗啲𠱁𠲖廐𥅈𠹶𢱢"],["9e40","𠺢麫絚嗞𡁵抝靭咔賍燶酶揼掹揾啩𢭃鱲𢺳冚㓟𠶧冧呍唞唓癦踭𦢊疱肶蠄螆裇膶萜𡃁䓬猄𤜆宐茋𦢓噻𢛴𧴯𤆣𧵳𦻐𧊶酰𡇙鈈𣳼𪚩𠺬𠻹牦𡲢䝎𤿂𧿹𠿫䃺"],["9ea1","鱝攟𢶠䣳𤟠𩵼𠿬𠸊恢𧖣𠿭"],["9ead","𦁈𡆇熣纎鵐业丄㕷嬍沲卧㚬㧜卽㚥𤘘墚𤭮舭呋垪𥪕𠥹"],["9ec5","㩒𢑥獴𩺬䴉鯭𣳾𩼰䱛𤾩𩖞𩿞葜𣶶𧊲𦞳𣜠挮紥𣻷𣸬㨪逈勌㹴㙺䗩𠒎癀嫰𠺶硺𧼮墧䂿噼鮋嵴癔𪐴麅䳡痹㟻愙𣃚𤏲"],["9ef5","噝𡊩垧𤥣𩸆刴𧂮㖭汊鵼"],["9f40","籖鬹埞𡝬屓擓𩓐𦌵𧅤蚭𠴨𦴢𤫢𠵱"],["9f4f","凾𡼏嶎霃𡷑麁遌笟鬂峑箣扨挵髿篏鬪籾鬮籂粆鰕篼鬉鼗鰛𤤾齚啳寃俽麘俲剠㸆勑坧偖妷帒韈鶫轜呩鞴饀鞺匬愰"],["9fa1","椬叚鰊鴂䰻陁榀傦畆𡝭駚剳"],["9fae","酙隁酜"],["9fb2","酑𨺗捿𦴣櫊嘑醎畺抅𠏼獏籰𥰡𣳽"],["9fc1","𤤙盖鮝个𠳔莾衂"],["9fc9","届槀僭坺刟巵从氱𠇲伹咜哚劚趂㗾弌㗳"],["9fdb","歒酼龥鮗頮颴骺麨麄煺笔"],["9fe7","毺蠘罸"],["9feb","嘠𪙊蹷齓"],["9ff0","跔蹏鸜踁抂𨍽踨蹵竓𤩷稾磘泪詧瘇"],["a040","𨩚鼦泎蟖痃𪊲硓咢贌狢獱謭猂瓱賫𤪻蘯徺袠䒷"],["a055","𡠻𦸅"],["a058","詾𢔛"],["a05b","惽癧髗鵄鍮鮏蟵"],["a063","蠏賷猬霡鮰㗖犲䰇籑饊𦅙慙䰄麖慽"],["a073","坟慯抦戹拎㩜懢厪𣏵捤栂㗒"],["a0a1","嵗𨯂迚𨸹"],["a0a6","僙𡵆礆匲阸𠼻䁥"],["a0ae","矾"],["a0b0","糂𥼚糚稭聦聣絍甅瓲覔舚朌聢𧒆聛瓰脃眤覉𦟌畓𦻑螩蟎臈螌詉貭譃眫瓸蓚㘵榲趦"],["a0d4","覩瑨涹蟁𤀑瓧㷛煶悤憜㳑煢恷"],["a0e2","罱𨬭牐惩䭾删㰘𣳇𥻗𧙖𥔱𡥄𡋾𩤃𦷜𧂭峁𦆭𨨏𣙷𠃮𦡆𤼎䕢嬟𦍌齐麦𦉫"],["a3c0","␀",31,"␡"],["c6a1","①",9,"⑴",9,"ⅰ",9,"丶丿亅亠冂冖冫勹匸卩厶夊宀巛⼳广廴彐彡攴无疒癶辵隶¨ˆヽヾゝゞ〃仝々〆〇ー［］✽ぁ",23],["c740","す",58,"ァアィイ"],["c7a1","ゥ",81,"А",5,"ЁЖ",4],["c840","Л",26,"ёж",25,"⇧↸↹㇏𠃌乚𠂊刂䒑"],["c8a1","龰冈龱𧘇"],["c8cd","￢￤＇＂㈱№℡゛゜⺀⺄⺆⺇⺈⺊⺌⺍⺕⺜⺝⺥⺧⺪⺬⺮⺶⺼⺾⻆⻊⻌⻍⻏⻖⻗⻞⻣"],["c8f5","ʃɐɛɔɵœøŋʊɪ"],["f9fe","￭"],["fa40","𠕇鋛𠗟𣿅蕌䊵珯况㙉𤥂𨧤鍄𡧛苮𣳈砼杄拟𤤳𨦪𠊠𦮳𡌅侫𢓭倈𦴩𧪄𣘀𤪱𢔓倩𠍾徤𠎀𠍇滛𠐟偽儁㑺儎顬㝃萖𤦤𠒇兠𣎴兪𠯿𢃼𠋥𢔰𠖎𣈳𡦃宂蝽𠖳𣲙冲冸"],["faa1","鴴凉减凑㳜凓𤪦决凢卂凭菍椾𣜭彻刋刦刼劵剗劔効勅簕蕂勠蘍𦬓包𨫞啉滙𣾀𠥔𣿬匳卄𠯢泋𡜦栛珕恊㺪㣌𡛨燝䒢卭却𨚫卾卿𡖖𡘓矦厓𨪛厠厫厮玧𥝲㽙玜叁叅汉义埾叙㪫𠮏叠𣿫𢶣叶𠱷吓灹唫晗浛呭𦭓𠵴啝咏咤䞦𡜍𠻝㶴𠵍"],["fb40","𨦼𢚘啇䳭启琗喆喩嘅𡣗𤀺䕒𤐵暳𡂴嘷曍𣊊暤暭噍噏磱囱鞇叾圀囯园𨭦㘣𡉏坆𤆥汮炋坂㚱𦱾埦𡐖堃𡑔𤍣堦𤯵塜墪㕡壠壜𡈼壻寿坃𪅐𤉸鏓㖡够梦㛃湙"],["fba1","𡘾娤啓𡚒蔅姉𠵎𦲁𦴪𡟜姙𡟻𡞲𦶦浱𡠨𡛕姹𦹅媫婣㛦𤦩婷㜈媖瑥嫓𦾡𢕔㶅𡤑㜲𡚸広勐孶斈孼𧨎䀄䡝𠈄寕慠𡨴𥧌𠖥寳宝䴐尅𡭄尓珎尔𡲥𦬨屉䣝岅峩峯嶋𡷹𡸷崐崘嵆𡺤岺巗苼㠭𤤁𢁉𢅳芇㠶㯂帮檊幵幺𤒼𠳓厦亷廐厨𡝱帉廴𨒂"],["fc40","廹廻㢠廼栾鐛弍𠇁弢㫞䢮𡌺强𦢈𢏐彘𢑱彣鞽𦹮彲鍀𨨶徧嶶㵟𥉐𡽪𧃸𢙨釖𠊞𨨩怱暅𡡷㥣㷇㘹垐𢞴祱㹀悞悤悳𤦂𤦏𧩓璤僡媠慤萤慂慈𦻒憁凴𠙖憇宪𣾷"],["fca1","𢡟懓𨮝𩥝懐㤲𢦀𢣁怣慜攞掋𠄘担𡝰拕𢸍捬𤧟㨗搸揸𡎎𡟼撐澊𢸶頔𤂌𥜝擡擥鑻㩦携㩗敍漖𤨨𤨣斅敭敟𣁾斵𤥀䬷旑䃘𡠩无旣忟𣐀昘𣇷𣇸晄𣆤𣆥晋𠹵晧𥇦晳晴𡸽𣈱𨗴𣇈𥌓矅𢣷馤朂𤎜𤨡㬫槺𣟂杞杧杢𤇍𩃭柗䓩栢湐鈼栁𣏦𦶠桝"],["fd40","𣑯槡樋𨫟楳棃𣗍椁椀㴲㨁𣘼㮀枬楡𨩊䋼椶榘㮡𠏉荣傐槹𣙙𢄪橅𣜃檝㯳枱櫈𩆜㰍欝𠤣惞欵歴𢟍溵𣫛𠎵𡥘㝀吡𣭚毡𣻼毜氷𢒋𤣱𦭑汚舦汹𣶼䓅𣶽𤆤𤤌𤤀"],["fda1","𣳉㛥㳫𠴲鮃𣇹𢒑羏样𦴥𦶡𦷫涖浜湼漄𤥿𤂅𦹲蔳𦽴凇沜渝萮𨬡港𣸯瑓𣾂秌湏媑𣁋濸㜍澝𣸰滺𡒗𤀽䕕鏰潄潜㵎潴𩅰㴻澟𤅄濓𤂑𤅕𤀹𣿰𣾴𤄿凟𤅖𤅗𤅀𦇝灋灾炧炁烌烕烖烟䄄㷨熴熖𤉷焫煅媈煊煮岜𤍥煏鍢𤋁焬𤑚𤨧𤨢熺𨯨炽爎"],["fe40","鑂爕夑鑃爤鍁𥘅爮牀𤥴梽牕牗㹕𣁄栍漽犂猪猫𤠣𨠫䣭𨠄猨献珏玪𠰺𦨮珉瑉𤇢𡛧𤨤昣㛅𤦷𤦍𤧻珷琕椃𤨦琹𠗃㻗瑜𢢭瑠𨺲瑇珤瑶莹瑬㜰瑴鏱樬璂䥓𤪌"],["fea1","𤅟𤩹𨮏孆𨰃𡢞瓈𡦈甎瓩甞𨻙𡩋寗𨺬鎅畍畊畧畮𤾂㼄𤴓疎瑝疞疴瘂瘬癑癏癯癶𦏵皐臯㟸𦤑𦤎皡皥皷盌𦾟葢𥂝𥅽𡸜眞眦着撯𥈠睘𣊬瞯𨥤𨥨𡛁矴砉𡍶𤨒棊碯磇磓隥礮𥗠磗礴碱𧘌辸袄𨬫𦂃𢘜禆褀椂禀𥡗禝𧬹礼禩渪𧄦㺨秆𩄍秔"]]');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/cp936.json":
/*!*************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/cp936.json ***!
  \*************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["0","\\u0000",127,"€"],["8140","丂丄丅丆丏丒丗丟丠両丣並丩丮丯丱丳丵丷丼乀乁乂乄乆乊乑乕乗乚乛乢乣乤乥乧乨乪",5,"乲乴",9,"乿",6,"亇亊"],["8180","亐亖亗亙亜亝亞亣亪亯亰亱亴亶亷亸亹亼亽亾仈仌仏仐仒仚仛仜仠仢仦仧仩仭仮仯仱仴仸仹仺仼仾伀伂",6,"伋伌伒",4,"伜伝伡伣伨伩伬伭伮伱伳伵伷伹伻伾",4,"佄佅佇",5,"佒佔佖佡佢佦佨佪佫佭佮佱佲併佷佸佹佺佽侀侁侂侅來侇侊侌侎侐侒侓侕侖侘侙侚侜侞侟価侢"],["8240","侤侫侭侰",4,"侶",8,"俀俁係俆俇俈俉俋俌俍俒",4,"俙俛俠俢俤俥俧俫俬俰俲俴俵俶俷俹俻俼俽俿",11],["8280","個倎倐們倓倕倖倗倛倝倞倠倢倣値倧倫倯",10,"倻倽倿偀偁偂偄偅偆偉偊偋偍偐",4,"偖偗偘偙偛偝",7,"偦",5,"偭",8,"偸偹偺偼偽傁傂傃傄傆傇傉傊傋傌傎",20,"傤傦傪傫傭",4,"傳",6,"傼"],["8340","傽",17,"僐",5,"僗僘僙僛",10,"僨僩僪僫僯僰僱僲僴僶",4,"僼",9,"儈"],["8380","儉儊儌",5,"儓",13,"儢",28,"兂兇兊兌兎兏児兒兓兗兘兙兛兝",4,"兣兤兦內兩兪兯兲兺兾兿冃冄円冇冊冋冎冏冐冑冓冔冘冚冝冞冟冡冣冦",4,"冭冮冴冸冹冺冾冿凁凂凃凅凈凊凍凎凐凒",5],["8440","凘凙凚凜凞凟凢凣凥",5,"凬凮凱凲凴凷凾刄刅刉刋刌刏刐刓刔刕刜刞刟刡刢刣別刦刧刪刬刯刱刲刴刵刼刾剄",5,"剋剎剏剒剓剕剗剘"],["8480","剙剚剛剝剟剠剢剣剤剦剨剫剬剭剮剰剱剳",9,"剾劀劃",4,"劉",6,"劑劒劔",6,"劜劤劥劦劧劮劯劰労",9,"勀勁勂勄勅勆勈勊勌勍勎勏勑勓勔動勗務",5,"勠勡勢勣勥",10,"勱",7,"勻勼勽匁匂匃匄匇匉匊匋匌匎"],["8540","匑匒匓匔匘匛匜匞匟匢匤匥匧匨匩匫匬匭匯",9,"匼匽區卂卄卆卋卌卍卐協単卙卛卝卥卨卪卬卭卲卶卹卻卼卽卾厀厁厃厇厈厊厎厏"],["8580","厐",4,"厖厗厙厛厜厞厠厡厤厧厪厫厬厭厯",6,"厷厸厹厺厼厽厾叀參",4,"収叏叐叒叓叕叚叜叝叞叡叢叧叴叺叾叿吀吂吅吇吋吔吘吙吚吜吢吤吥吪吰吳吶吷吺吽吿呁呂呄呅呇呉呌呍呎呏呑呚呝",4,"呣呥呧呩",7,"呴呹呺呾呿咁咃咅咇咈咉咊咍咑咓咗咘咜咞咟咠咡"],["8640","咢咥咮咰咲咵咶咷咹咺咼咾哃哅哊哋哖哘哛哠",4,"哫哬哯哰哱哴",5,"哻哾唀唂唃唄唅唈唊",4,"唒唓唕",5,"唜唝唞唟唡唥唦"],["8680","唨唩唫唭唲唴唵唶唸唹唺唻唽啀啂啅啇啈啋",4,"啑啒啓啔啗",4,"啝啞啟啠啢啣啨啩啫啯",5,"啹啺啽啿喅喆喌喍喎喐喒喓喕喖喗喚喛喞喠",6,"喨",8,"喲喴営喸喺喼喿",4,"嗆嗇嗈嗊嗋嗎嗏嗐嗕嗗",4,"嗞嗠嗢嗧嗩嗭嗮嗰嗱嗴嗶嗸",4,"嗿嘂嘃嘄嘅"],["8740","嘆嘇嘊嘋嘍嘐",7,"嘙嘚嘜嘝嘠嘡嘢嘥嘦嘨嘩嘪嘫嘮嘯嘰嘳嘵嘷嘸嘺嘼嘽嘾噀",11,"噏",4,"噕噖噚噛噝",4],["8780","噣噥噦噧噭噮噯噰噲噳噴噵噷噸噹噺噽",7,"嚇",6,"嚐嚑嚒嚔",14,"嚤",10,"嚰",6,"嚸嚹嚺嚻嚽",12,"囋",8,"囕囖囘囙囜団囥",5,"囬囮囯囲図囶囷囸囻囼圀圁圂圅圇國",6],["8840","園",9,"圝圞圠圡圢圤圥圦圧圫圱圲圴",4,"圼圽圿坁坃坄坅坆坈坉坋坒",4,"坘坙坢坣坥坧坬坮坰坱坲坴坵坸坹坺坽坾坿垀"],["8880","垁垇垈垉垊垍",4,"垔",6,"垜垝垞垟垥垨垪垬垯垰垱垳垵垶垷垹",8,"埄",6,"埌埍埐埑埓埖埗埛埜埞埡埢埣埥",7,"埮埰埱埲埳埵埶執埻埼埾埿堁堃堄堅堈堉堊堌堎堏堐堒堓堔堖堗堘堚堛堜堝堟堢堣堥",4,"堫",4,"報堲堳場堶",7],["8940","堾",5,"塅",6,"塎塏塐塒塓塕塖塗塙",4,"塟",5,"塦",4,"塭",16,"塿墂墄墆墇墈墊墋墌"],["8980","墍",4,"墔",4,"墛墜墝墠",7,"墪",17,"墽墾墿壀壂壃壄壆",10,"壒壓壔壖",13,"壥",5,"壭壯壱売壴壵壷壸壺",7,"夃夅夆夈",4,"夎夐夑夒夓夗夘夛夝夞夠夡夢夣夦夨夬夰夲夳夵夶夻"],["8a40","夽夾夿奀奃奅奆奊奌奍奐奒奓奙奛",4,"奡奣奤奦",12,"奵奷奺奻奼奾奿妀妅妉妋妌妎妏妐妑妔妕妘妚妛妜妝妟妠妡妢妦"],["8a80","妧妬妭妰妱妳",5,"妺妼妽妿",6,"姇姈姉姌姍姎姏姕姖姙姛姞",4,"姤姦姧姩姪姫姭",11,"姺姼姽姾娀娂娊娋娍娎娏娐娒娔娕娖娗娙娚娛娝娞娡娢娤娦娧娨娪",6,"娳娵娷",4,"娽娾娿婁",4,"婇婈婋",9,"婖婗婘婙婛",5],["8b40","婡婣婤婥婦婨婩婫",8,"婸婹婻婼婽婾媀",17,"媓",6,"媜",13,"媫媬"],["8b80","媭",4,"媴媶媷媹",4,"媿嫀嫃",5,"嫊嫋嫍",4,"嫓嫕嫗嫙嫚嫛嫝嫞嫟嫢嫤嫥嫧嫨嫪嫬",4,"嫲",22,"嬊",11,"嬘",25,"嬳嬵嬶嬸",7,"孁",6],["8c40","孈",7,"孒孖孞孠孡孧孨孫孭孮孯孲孴孶孷學孹孻孼孾孿宂宆宊宍宎宐宑宒宔宖実宧宨宩宬宭宮宯宱宲宷宺宻宼寀寁寃寈寉寊寋寍寎寏"],["8c80","寑寔",8,"寠寢寣實寧審",4,"寯寱",6,"寽対尀専尃尅將專尋尌對導尐尒尓尗尙尛尞尟尠尡尣尦尨尩尪尫尭尮尯尰尲尳尵尶尷屃屄屆屇屌屍屒屓屔屖屗屘屚屛屜屝屟屢層屧",6,"屰屲",6,"屻屼屽屾岀岃",4,"岉岊岋岎岏岒岓岕岝",4,"岤",4],["8d40","岪岮岯岰岲岴岶岹岺岻岼岾峀峂峃峅",5,"峌",5,"峓",5,"峚",6,"峢峣峧峩峫峬峮峯峱",9,"峼",4],["8d80","崁崄崅崈",5,"崏",4,"崕崗崘崙崚崜崝崟",4,"崥崨崪崫崬崯",4,"崵",7,"崿",7,"嵈嵉嵍",10,"嵙嵚嵜嵞",10,"嵪嵭嵮嵰嵱嵲嵳嵵",12,"嶃",21,"嶚嶛嶜嶞嶟嶠"],["8e40","嶡",21,"嶸",12,"巆",6,"巎",12,"巜巟巠巣巤巪巬巭"],["8e80","巰巵巶巸",4,"巿帀帄帇帉帊帋帍帎帒帓帗帞",7,"帨",4,"帯帰帲",4,"帹帺帾帿幀幁幃幆",5,"幍",6,"幖",4,"幜幝幟幠幣",14,"幵幷幹幾庁庂広庅庈庉庌庍庎庒庘庛庝庡庢庣庤庨",4,"庮",4,"庴庺庻庼庽庿",6],["8f40","廆廇廈廋",5,"廔廕廗廘廙廚廜",11,"廩廫",8,"廵廸廹廻廼廽弅弆弇弉弌弍弎弐弒弔弖弙弚弜弝弞弡弢弣弤"],["8f80","弨弫弬弮弰弲",6,"弻弽弾弿彁",14,"彑彔彙彚彛彜彞彟彠彣彥彧彨彫彮彯彲彴彵彶彸彺彽彾彿徃徆徍徎徏徑従徔徖徚徛徝從徟徠徢",5,"復徫徬徯",5,"徶徸徹徺徻徾",4,"忇忈忊忋忎忓忔忕忚忛応忞忟忢忣忥忦忨忩忬忯忰忲忳忴忶忷忹忺忼怇"],["9040","怈怉怋怌怐怑怓怗怘怚怞怟怢怣怤怬怭怮怰",4,"怶",4,"怽怾恀恄",6,"恌恎恏恑恓恔恖恗恘恛恜恞恟恠恡恥恦恮恱恲恴恵恷恾悀"],["9080","悁悂悅悆悇悈悊悋悎悏悐悑悓悕悗悘悙悜悞悡悢悤悥悧悩悪悮悰悳悵悶悷悹悺悽",7,"惇惈惉惌",4,"惒惓惔惖惗惙惛惞惡",4,"惪惱惲惵惷惸惻",4,"愂愃愄愅愇愊愋愌愐",4,"愖愗愘愙愛愜愝愞愡愢愥愨愩愪愬",18,"慀",6],["9140","慇慉態慍慏慐慒慓慔慖",6,"慞慟慠慡慣慤慥慦慩",6,"慱慲慳慴慶慸",18,"憌憍憏",4,"憕"],["9180","憖",6,"憞",8,"憪憫憭",9,"憸",5,"憿懀懁懃",4,"應懌",4,"懓懕",16,"懧",13,"懶",8,"戀",5,"戇戉戓戔戙戜戝戞戠戣戦戧戨戩戫戭戯戰戱戲戵戶戸",4,"扂扄扅扆扊"],["9240","扏扐払扖扗扙扚扜",6,"扤扥扨扱扲扴扵扷扸扺扻扽抁抂抃抅抆抇抈抋",5,"抔抙抜抝択抣抦抧抩抪抭抮抯抰抲抳抴抶抷抸抺抾拀拁"],["9280","拃拋拏拑拕拝拞拠拡拤拪拫拰拲拵拸拹拺拻挀挃挄挅挆挊挋挌挍挏挐挒挓挔挕挗挘挙挜挦挧挩挬挭挮挰挱挳",5,"挻挼挾挿捀捁捄捇捈捊捑捒捓捔捖",7,"捠捤捥捦捨捪捫捬捯捰捲捳捴捵捸捹捼捽捾捿掁掃掄掅掆掋掍掑掓掔掕掗掙",6,"採掤掦掫掯掱掲掵掶掹掻掽掿揀"],["9340","揁揂揃揅揇揈揊揋揌揑揓揔揕揗",6,"揟揢揤",4,"揫揬揮揯揰揱揳揵揷揹揺揻揼揾搃搄搆",4,"損搎搑搒搕",5,"搝搟搢搣搤"],["9380","搥搧搨搩搫搮",5,"搵",4,"搻搼搾摀摂摃摉摋",6,"摓摕摖摗摙",4,"摟",7,"摨摪摫摬摮",9,"摻",6,"撃撆撈",8,"撓撔撗撘撚撛撜撝撟",4,"撥撦撧撨撪撫撯撱撲撳撴撶撹撻撽撾撿擁擃擄擆",6,"擏擑擓擔擕擖擙據"],["9440","擛擜擝擟擠擡擣擥擧",24,"攁",7,"攊",7,"攓",4,"攙",8],["9480","攢攣攤攦",4,"攬攭攰攱攲攳攷攺攼攽敀",4,"敆敇敊敋敍敎敐敒敓敔敗敘敚敜敟敠敡敤敥敧敨敩敪敭敮敯敱敳敵敶數",14,"斈斉斊斍斎斏斒斔斕斖斘斚斝斞斠斢斣斦斨斪斬斮斱",7,"斺斻斾斿旀旂旇旈旉旊旍旐旑旓旔旕旘",7,"旡旣旤旪旫"],["9540","旲旳旴旵旸旹旻",4,"昁昄昅昇昈昉昋昍昐昑昒昖昗昘昚昛昜昞昡昢昣昤昦昩昪昫昬昮昰昲昳昷",4,"昽昿晀時晄",6,"晍晎晐晑晘"],["9580","晙晛晜晝晞晠晢晣晥晧晩",4,"晱晲晳晵晸晹晻晼晽晿暀暁暃暅暆暈暉暊暋暍暎暏暐暒暓暔暕暘",4,"暞",8,"暩",4,"暯",4,"暵暶暷暸暺暻暼暽暿",25,"曚曞",7,"曧曨曪",5,"曱曵曶書曺曻曽朁朂會"],["9640","朄朅朆朇朌朎朏朑朒朓朖朘朙朚朜朞朠",5,"朧朩朮朰朲朳朶朷朸朹朻朼朾朿杁杄杅杇杊杋杍杒杔杕杗",4,"杝杢杣杤杦杧杫杬杮東杴杶"],["9680","杸杹杺杻杽枀枂枃枅枆枈枊枌枍枎枏枑枒枓枔枖枙枛枟枠枡枤枦枩枬枮枱枲枴枹",7,"柂柅",9,"柕柖柗柛柟柡柣柤柦柧柨柪柫柭柮柲柵",7,"柾栁栂栃栄栆栍栐栒栔栕栘",4,"栞栟栠栢",6,"栫",6,"栴栵栶栺栻栿桇桋桍桏桒桖",5],["9740","桜桝桞桟桪桬",7,"桵桸",8,"梂梄梇",7,"梐梑梒梔梕梖梘",9,"梣梤梥梩梪梫梬梮梱梲梴梶梷梸"],["9780","梹",6,"棁棃",5,"棊棌棎棏棐棑棓棔棖棗棙棛",4,"棡棢棤",9,"棯棲棳棴棶棷棸棻棽棾棿椀椂椃椄椆",4,"椌椏椑椓",11,"椡椢椣椥",7,"椮椯椱椲椳椵椶椷椸椺椻椼椾楀楁楃",16,"楕楖楘楙楛楜楟"],["9840","楡楢楤楥楧楨楩楪楬業楯楰楲",4,"楺楻楽楾楿榁榃榅榊榋榌榎",5,"榖榗榙榚榝",9,"榩榪榬榮榯榰榲榳榵榶榸榹榺榼榽"],["9880","榾榿槀槂",7,"構槍槏槑槒槓槕",5,"槜槝槞槡",11,"槮槯槰槱槳",9,"槾樀",9,"樋",11,"標",5,"樠樢",5,"権樫樬樭樮樰樲樳樴樶",6,"樿",4,"橅橆橈",7,"橑",6,"橚"],["9940","橜",4,"橢橣橤橦",10,"橲",6,"橺橻橽橾橿檁檂檃檅",8,"檏檒",4,"檘",7,"檡",5],["9980","檧檨檪檭",114,"欥欦欨",6],["9a40","欯欰欱欳欴欵欶欸欻欼欽欿歀歁歂歄歅歈歊歋歍",11,"歚",7,"歨歩歫",13,"歺歽歾歿殀殅殈"],["9a80","殌殎殏殐殑殔殕殗殘殙殜",4,"殢",7,"殫",7,"殶殸",6,"毀毃毄毆",4,"毌毎毐毑毘毚毜",4,"毢",7,"毬毭毮毰毱毲毴毶毷毸毺毻毼毾",6,"氈",4,"氎氒気氜氝氞氠氣氥氫氬氭氱氳氶氷氹氺氻氼氾氿汃汄汅汈汋",4,"汑汒汓汖汘"],["9b40","汙汚汢汣汥汦汧汫",4,"汱汳汵汷汸決汻汼汿沀沄沇沊沋沍沎沑沒沕沖沗沘沚沜沝沞沠沢沨沬沯沰沴沵沶沷沺泀況泂泃泆泇泈泋泍泎泏泑泒泘"],["9b80","泙泚泜泝泟泤泦泧泩泬泭泲泴泹泿洀洂洃洅洆洈洉洊洍洏洐洑洓洔洕洖洘洜洝洟",5,"洦洨洩洬洭洯洰洴洶洷洸洺洿浀浂浄浉浌浐浕浖浗浘浛浝浟浡浢浤浥浧浨浫浬浭浰浱浲浳浵浶浹浺浻浽",4,"涃涄涆涇涊涋涍涏涐涒涖",4,"涜涢涥涬涭涰涱涳涴涶涷涹",5,"淁淂淃淈淉淊"],["9c40","淍淎淏淐淒淓淔淕淗淚淛淜淟淢淣淥淧淨淩淪淭淯淰淲淴淵淶淸淺淽",7,"渆渇済渉渋渏渒渓渕渘渙減渜渞渟渢渦渧渨渪測渮渰渱渳渵"],["9c80","渶渷渹渻",7,"湅",7,"湏湐湑湒湕湗湙湚湜湝湞湠",10,"湬湭湯",14,"満溁溂溄溇溈溊",4,"溑",6,"溙溚溛溝溞溠溡溣溤溦溨溩溫溬溭溮溰溳溵溸溹溼溾溿滀滃滄滅滆滈滉滊滌滍滎滐滒滖滘滙滛滜滝滣滧滪",5],["9d40","滰滱滲滳滵滶滷滸滺",7,"漃漄漅漇漈漊",4,"漐漑漒漖",9,"漡漢漣漥漦漧漨漬漮漰漲漴漵漷",6,"漿潀潁潂"],["9d80","潃潄潅潈潉潊潌潎",9,"潙潚潛潝潟潠潡潣潤潥潧",5,"潯潰潱潳潵潶潷潹潻潽",6,"澅澆澇澊澋澏",12,"澝澞澟澠澢",4,"澨",10,"澴澵澷澸澺",5,"濁濃",5,"濊",6,"濓",10,"濟濢濣濤濥"],["9e40","濦",7,"濰",32,"瀒",7,"瀜",6,"瀤",6],["9e80","瀫",9,"瀶瀷瀸瀺",17,"灍灎灐",13,"灟",11,"灮灱灲灳灴灷灹灺灻災炁炂炃炄炆炇炈炋炌炍炏炐炑炓炗炘炚炛炞",12,"炰炲炴炵炶為炾炿烄烅烆烇烉烋",12,"烚"],["9f40","烜烝烞烠烡烢烣烥烪烮烰",6,"烸烺烻烼烾",10,"焋",4,"焑焒焔焗焛",10,"焧",7,"焲焳焴"],["9f80","焵焷",13,"煆煇煈煉煋煍煏",12,"煝煟",4,"煥煩",4,"煯煰煱煴煵煶煷煹煻煼煾",5,"熅",4,"熋熌熍熎熐熑熒熓熕熖熗熚",4,"熡",6,"熩熪熫熭",5,"熴熶熷熸熺",8,"燄",9,"燏",4],["a040","燖",9,"燡燢燣燤燦燨",5,"燯",9,"燺",11,"爇",19],["a080","爛爜爞",9,"爩爫爭爮爯爲爳爴爺爼爾牀",6,"牉牊牋牎牏牐牑牓牔牕牗牘牚牜牞牠牣牤牥牨牪牫牬牭牰牱牳牴牶牷牸牻牼牽犂犃犅",4,"犌犎犐犑犓",11,"犠",11,"犮犱犲犳犵犺",6,"狅狆狇狉狊狋狌狏狑狓狔狕狖狘狚狛"],["a1a1","　、。·ˉˇ¨〃々—～‖…‘’“”〔〕〈",7,"〖〗【】±×÷∶∧∨∑∏∪∩∈∷√⊥∥∠⌒⊙∫∮≡≌≈∽∝≠≮≯≤≥∞∵∴♂♀°′″℃＄¤￠￡‰§№☆★○●◎◇◆□■△▲※→←↑↓〓"],["a2a1","ⅰ",9],["a2b1","⒈",19,"⑴",19,"①",9],["a2e5","㈠",9],["a2f1","Ⅰ",11],["a3a1","！＂＃￥％",88,"￣"],["a4a1","ぁ",82],["a5a1","ァ",85],["a6a1","Α",16,"Σ",6],["a6c1","α",16,"σ",6],["a6e0","︵︶︹︺︿﹀︽︾﹁﹂﹃﹄"],["a6ee","︻︼︷︸︱"],["a6f4","︳︴"],["a7a1","А",5,"ЁЖ",25],["a7d1","а",5,"ёж",25],["a840","ˊˋ˙–―‥‵℅℉↖↗↘↙∕∟∣≒≦≧⊿═",35,"▁",6],["a880","█",7,"▓▔▕▼▽◢◣◤◥☉⊕〒〝〞"],["a8a1","āáǎàēéěèīíǐìōóǒòūúǔùǖǘǚǜüêɑ"],["a8bd","ńň"],["a8c0","ɡ"],["a8c5","ㄅ",36],["a940","〡",8,"㊣㎎㎏㎜㎝㎞㎡㏄㏎㏑㏒㏕︰￢￤"],["a959","℡㈱"],["a95c","‐"],["a960","ー゛゜ヽヾ〆ゝゞ﹉",9,"﹔﹕﹖﹗﹙",8],["a980","﹢",4,"﹨﹩﹪﹫"],["a996","〇"],["a9a4","─",75],["aa40","狜狝狟狢",5,"狪狫狵狶狹狽狾狿猀猂猄",5,"猋猌猍猏猐猑猒猔猘猙猚猟猠猣猤猦猧猨猭猯猰猲猳猵猶猺猻猼猽獀",8],["aa80","獉獊獋獌獎獏獑獓獔獕獖獘",7,"獡",10,"獮獰獱"],["ab40","獲",11,"獿",4,"玅玆玈玊玌玍玏玐玒玓玔玕玗玘玙玚玜玝玞玠玡玣",5,"玪玬玭玱玴玵玶玸玹玼玽玾玿珁珃",4],["ab80","珋珌珎珒",6,"珚珛珜珝珟珡珢珣珤珦珨珪珫珬珮珯珰珱珳",4],["ac40","珸",10,"琄琇琈琋琌琍琎琑",8,"琜",5,"琣琤琧琩琫琭琯琱琲琷",4,"琽琾琿瑀瑂",11],["ac80","瑎",6,"瑖瑘瑝瑠",12,"瑮瑯瑱",4,"瑸瑹瑺"],["ad40","瑻瑼瑽瑿璂璄璅璆璈璉璊璌璍璏璑",10,"璝璟",7,"璪",15,"璻",12],["ad80","瓈",9,"瓓",8,"瓝瓟瓡瓥瓧",6,"瓰瓱瓲"],["ae40","瓳瓵瓸",6,"甀甁甂甃甅",7,"甎甐甒甔甕甖甗甛甝甞甠",4,"甦甧甪甮甴甶甹甼甽甿畁畂畃畄畆畇畉畊畍畐畑畒畓畕畖畗畘"],["ae80","畝",7,"畧畨畩畫",6,"畳畵當畷畺",4,"疀疁疂疄疅疇"],["af40","疈疉疊疌疍疎疐疓疕疘疛疜疞疢疦",4,"疭疶疷疺疻疿痀痁痆痋痌痎痏痐痑痓痗痙痚痜痝痟痠痡痥痩痬痭痮痯痲痳痵痶痷痸痺痻痽痾瘂瘄瘆瘇"],["af80","瘈瘉瘋瘍瘎瘏瘑瘒瘓瘔瘖瘚瘜瘝瘞瘡瘣瘧瘨瘬瘮瘯瘱瘲瘶瘷瘹瘺瘻瘽癁療癄"],["b040","癅",6,"癎",5,"癕癗",4,"癝癟癠癡癢癤",6,"癬癭癮癰",7,"癹発發癿皀皁皃皅皉皊皌皍皏皐皒皔皕皗皘皚皛"],["b080","皜",7,"皥",8,"皯皰皳皵",9,"盀盁盃啊阿埃挨哎唉哀皑癌蔼矮艾碍爱隘鞍氨安俺按暗岸胺案肮昂盎凹敖熬翱袄傲奥懊澳芭捌扒叭吧笆八疤巴拔跋靶把耙坝霸罢爸白柏百摆佰败拜稗斑班搬扳般颁板版扮拌伴瓣半办绊邦帮梆榜膀绑棒磅蚌镑傍谤苞胞包褒剥"],["b140","盄盇盉盋盌盓盕盙盚盜盝盞盠",4,"盦",7,"盰盳盵盶盷盺盻盽盿眀眂眃眅眆眊県眎",10,"眛眜眝眞眡眣眤眥眧眪眫"],["b180","眬眮眰",4,"眹眻眽眾眿睂睄睅睆睈",7,"睒",7,"睜薄雹保堡饱宝抱报暴豹鲍爆杯碑悲卑北辈背贝钡倍狈备惫焙被奔苯本笨崩绷甭泵蹦迸逼鼻比鄙笔彼碧蓖蔽毕毙毖币庇痹闭敝弊必辟壁臂避陛鞭边编贬扁便变卞辨辩辫遍标彪膘表鳖憋别瘪彬斌濒滨宾摈兵冰柄丙秉饼炳"],["b240","睝睞睟睠睤睧睩睪睭",11,"睺睻睼瞁瞂瞃瞆",5,"瞏瞐瞓",11,"瞡瞣瞤瞦瞨瞫瞭瞮瞯瞱瞲瞴瞶",4],["b280","瞼瞾矀",12,"矎",8,"矘矙矚矝",4,"矤病并玻菠播拨钵波博勃搏铂箔伯帛舶脖膊渤泊驳捕卜哺补埠不布步簿部怖擦猜裁材才财睬踩采彩菜蔡餐参蚕残惭惨灿苍舱仓沧藏操糙槽曹草厕策侧册测层蹭插叉茬茶查碴搽察岔差诧拆柴豺搀掺蝉馋谗缠铲产阐颤昌猖"],["b340","矦矨矪矯矰矱矲矴矵矷矹矺矻矼砃",5,"砊砋砎砏砐砓砕砙砛砞砠砡砢砤砨砪砫砮砯砱砲砳砵砶砽砿硁硂硃硄硆硈硉硊硋硍硏硑硓硔硘硙硚"],["b380","硛硜硞",11,"硯",7,"硸硹硺硻硽",6,"场尝常长偿肠厂敞畅唱倡超抄钞朝嘲潮巢吵炒车扯撤掣彻澈郴臣辰尘晨忱沉陈趁衬撑称城橙成呈乘程惩澄诚承逞骋秤吃痴持匙池迟弛驰耻齿侈尺赤翅斥炽充冲虫崇宠抽酬畴踌稠愁筹仇绸瞅丑臭初出橱厨躇锄雏滁除楚"],["b440","碄碅碆碈碊碋碏碐碒碔碕碖碙碝碞碠碢碤碦碨",7,"碵碶碷碸確碻碼碽碿磀磂磃磄磆磇磈磌磍磎磏磑磒磓磖磗磘磚",9],["b480","磤磥磦磧磩磪磫磭",4,"磳磵磶磸磹磻",5,"礂礃礄礆",6,"础储矗搐触处揣川穿椽传船喘串疮窗幢床闯创吹炊捶锤垂春椿醇唇淳纯蠢戳绰疵茨磁雌辞慈瓷词此刺赐次聪葱囱匆从丛凑粗醋簇促蹿篡窜摧崔催脆瘁粹淬翠村存寸磋撮搓措挫错搭达答瘩打大呆歹傣戴带殆代贷袋待逮"],["b540","礍",5,"礔",9,"礟",4,"礥",14,"礵",4,"礽礿祂祃祄祅祇祊",8,"祔祕祘祙祡祣"],["b580","祤祦祩祪祫祬祮祰",6,"祹祻",4,"禂禃禆禇禈禉禋禌禍禎禐禑禒怠耽担丹单郸掸胆旦氮但惮淡诞弹蛋当挡党荡档刀捣蹈倒岛祷导到稻悼道盗德得的蹬灯登等瞪凳邓堤低滴迪敌笛狄涤翟嫡抵底地蒂第帝弟递缔颠掂滇碘点典靛垫电佃甸店惦奠淀殿碉叼雕凋刁掉吊钓调跌爹碟蝶迭谍叠"],["b640","禓",6,"禛",11,"禨",10,"禴",4,"禼禿秂秄秅秇秈秊秌秎秏秐秓秔秖秗秙",5,"秠秡秢秥秨秪"],["b680","秬秮秱",6,"秹秺秼秾秿稁稄稅稇稈稉稊稌稏",4,"稕稖稘稙稛稜丁盯叮钉顶鼎锭定订丢东冬董懂动栋侗恫冻洞兜抖斗陡豆逗痘都督毒犊独读堵睹赌杜镀肚度渡妒端短锻段断缎堆兑队对墩吨蹲敦顿囤钝盾遁掇哆多夺垛躲朵跺舵剁惰堕蛾峨鹅俄额讹娥恶厄扼遏鄂饿恩而儿耳尔饵洱二"],["b740","稝稟稡稢稤",14,"稴稵稶稸稺稾穀",5,"穇",9,"穒",4,"穘",16],["b780","穩",6,"穱穲穳穵穻穼穽穾窂窅窇窉窊窋窌窎窏窐窓窔窙窚窛窞窡窢贰发罚筏伐乏阀法珐藩帆番翻樊矾钒繁凡烦反返范贩犯饭泛坊芳方肪房防妨仿访纺放菲非啡飞肥匪诽吠肺废沸费芬酚吩氛分纷坟焚汾粉奋份忿愤粪丰封枫蜂峰锋风疯烽逢冯缝讽奉凤佛否夫敷肤孵扶拂辐幅氟符伏俘服"],["b840","窣窤窧窩窪窫窮",4,"窴",10,"竀",10,"竌",9,"竗竘竚竛竜竝竡竢竤竧",5,"竮竰竱竲竳"],["b880","竴",4,"竻竼竾笀笁笂笅笇笉笌笍笎笐笒笓笖笗笘笚笜笝笟笡笢笣笧笩笭浮涪福袱弗甫抚辅俯釜斧脯腑府腐赴副覆赋复傅付阜父腹负富讣附妇缚咐噶嘎该改概钙盖溉干甘杆柑竿肝赶感秆敢赣冈刚钢缸肛纲岗港杠篙皋高膏羔糕搞镐稿告哥歌搁戈鸽胳疙割革葛格蛤阁隔铬个各给根跟耕更庚羹"],["b940","笯笰笲笴笵笶笷笹笻笽笿",5,"筆筈筊筍筎筓筕筗筙筜筞筟筡筣",10,"筯筰筳筴筶筸筺筼筽筿箁箂箃箄箆",6,"箎箏"],["b980","箑箒箓箖箘箙箚箛箞箟箠箣箤箥箮箯箰箲箳箵箶箷箹",7,"篂篃範埂耿梗工攻功恭龚供躬公宫弓巩汞拱贡共钩勾沟苟狗垢构购够辜菇咕箍估沽孤姑鼓古蛊骨谷股故顾固雇刮瓜剐寡挂褂乖拐怪棺关官冠观管馆罐惯灌贯光广逛瑰规圭硅归龟闺轨鬼诡癸桂柜跪贵刽辊滚棍锅郭国果裹过哈"],["ba40","篅篈築篊篋篍篎篏篐篒篔",4,"篛篜篞篟篠篢篣篤篧篨篩篫篬篭篯篰篲",4,"篸篹篺篻篽篿",7,"簈簉簊簍簎簐",5,"簗簘簙"],["ba80","簚",4,"簠",5,"簨簩簫",12,"簹",5,"籂骸孩海氦亥害骇酣憨邯韩含涵寒函喊罕翰撼捍旱憾悍焊汗汉夯杭航壕嚎豪毫郝好耗号浩呵喝荷菏核禾和何合盒貉阂河涸赫褐鹤贺嘿黑痕很狠恨哼亨横衡恒轰哄烘虹鸿洪宏弘红喉侯猴吼厚候后呼乎忽瑚壶葫胡蝴狐糊湖"],["bb40","籃",9,"籎",36,"籵",5,"籾",9],["bb80","粈粊",6,"粓粔粖粙粚粛粠粡粣粦粧粨粩粫粬粭粯粰粴",4,"粺粻弧虎唬护互沪户花哗华猾滑画划化话槐徊怀淮坏欢环桓还缓换患唤痪豢焕涣宦幻荒慌黄磺蝗簧皇凰惶煌晃幌恍谎灰挥辉徽恢蛔回毁悔慧卉惠晦贿秽会烩汇讳诲绘荤昏婚魂浑混豁活伙火获或惑霍货祸击圾基机畸稽积箕"],["bc40","粿糀糂糃糄糆糉糋糎",6,"糘糚糛糝糞糡",6,"糩",5,"糰",7,"糹糺糼",13,"紋",5],["bc80","紑",14,"紡紣紤紥紦紨紩紪紬紭紮細",6,"肌饥迹激讥鸡姬绩缉吉极棘辑籍集及急疾汲即嫉级挤几脊己蓟技冀季伎祭剂悸济寄寂计记既忌际妓继纪嘉枷夹佳家加荚颊贾甲钾假稼价架驾嫁歼监坚尖笺间煎兼肩艰奸缄茧检柬碱硷拣捡简俭剪减荐槛鉴践贱见键箭件"],["bd40","紷",54,"絯",7],["bd80","絸",32,"健舰剑饯渐溅涧建僵姜将浆江疆蒋桨奖讲匠酱降蕉椒礁焦胶交郊浇骄娇嚼搅铰矫侥脚狡角饺缴绞剿教酵轿较叫窖揭接皆秸街阶截劫节桔杰捷睫竭洁结解姐戒藉芥界借介疥诫届巾筋斤金今津襟紧锦仅谨进靳晋禁近烬浸"],["be40","継",12,"綧",6,"綯",42],["be80","線",32,"尽劲荆兢茎睛晶鲸京惊精粳经井警景颈静境敬镜径痉靖竟竞净炯窘揪究纠玖韭久灸九酒厩救旧臼舅咎就疚鞠拘狙疽居驹菊局咀矩举沮聚拒据巨具距踞锯俱句惧炬剧捐鹃娟倦眷卷绢撅攫抉掘倔爵觉决诀绝均菌钧军君峻"],["bf40","緻",62],["bf80","縺縼",4,"繂",4,"繈",21,"俊竣浚郡骏喀咖卡咯开揩楷凯慨刊堪勘坎砍看康慷糠扛抗亢炕考拷烤靠坷苛柯棵磕颗科壳咳可渴克刻客课肯啃垦恳坑吭空恐孔控抠口扣寇枯哭窟苦酷库裤夸垮挎跨胯块筷侩快宽款匡筐狂框矿眶旷况亏盔岿窥葵奎魁傀"],["c040","繞",35,"纃",23,"纜纝纞"],["c080","纮纴纻纼绖绤绬绹缊缐缞缷缹缻",6,"罃罆",9,"罒罓馈愧溃坤昆捆困括扩廓阔垃拉喇蜡腊辣啦莱来赖蓝婪栏拦篮阑兰澜谰揽览懒缆烂滥琅榔狼廊郎朗浪捞劳牢老佬姥酪烙涝勒乐雷镭蕾磊累儡垒擂肋类泪棱楞冷厘梨犁黎篱狸离漓理李里鲤礼莉荔吏栗丽厉励砾历利傈例俐"],["c140","罖罙罛罜罝罞罠罣",4,"罫罬罭罯罰罳罵罶罷罸罺罻罼罽罿羀羂",7,"羋羍羏",4,"羕",4,"羛羜羠羢羣羥羦羨",6,"羱"],["c180","羳",4,"羺羻羾翀翂翃翄翆翇翈翉翋翍翏",4,"翖翗翙",5,"翢翣痢立粒沥隶力璃哩俩联莲连镰廉怜涟帘敛脸链恋炼练粮凉梁粱良两辆量晾亮谅撩聊僚疗燎寥辽潦了撂镣廖料列裂烈劣猎琳林磷霖临邻鳞淋凛赁吝拎玲菱零龄铃伶羚凌灵陵岭领另令溜琉榴硫馏留刘瘤流柳六龙聋咙笼窿"],["c240","翤翧翨翪翫翬翭翯翲翴",6,"翽翾翿耂耇耈耉耊耎耏耑耓耚耛耝耞耟耡耣耤耫",5,"耲耴耹耺耼耾聀聁聄聅聇聈聉聎聏聐聑聓聕聖聗"],["c280","聙聛",13,"聫",5,"聲",11,"隆垄拢陇楼娄搂篓漏陋芦卢颅庐炉掳卤虏鲁麓碌露路赂鹿潞禄录陆戮驴吕铝侣旅履屡缕虑氯律率滤绿峦挛孪滦卵乱掠略抡轮伦仑沦纶论萝螺罗逻锣箩骡裸落洛骆络妈麻玛码蚂马骂嘛吗埋买麦卖迈脉瞒馒蛮满蔓曼慢漫"],["c340","聾肁肂肅肈肊肍",5,"肔肕肗肙肞肣肦肧肨肬肰肳肵肶肸肹肻胅胇",4,"胏",6,"胘胟胠胢胣胦胮胵胷胹胻胾胿脀脁脃脄脅脇脈脋"],["c380","脌脕脗脙脛脜脝脟",12,"脭脮脰脳脴脵脷脹",4,"脿谩芒茫盲氓忙莽猫茅锚毛矛铆卯茂冒帽貌贸么玫枚梅酶霉煤没眉媒镁每美昧寐妹媚门闷们萌蒙檬盟锰猛梦孟眯醚靡糜迷谜弥米秘觅泌蜜密幂棉眠绵冕免勉娩缅面苗描瞄藐秒渺庙妙蔑灭民抿皿敏悯闽明螟鸣铭名命谬摸"],["c440","腀",5,"腇腉腍腎腏腒腖腗腘腛",4,"腡腢腣腤腦腨腪腫腬腯腲腳腵腶腷腸膁膃",4,"膉膋膌膍膎膐膒",5,"膙膚膞",4,"膤膥"],["c480","膧膩膫",7,"膴",5,"膼膽膾膿臄臅臇臈臉臋臍",6,"摹蘑模膜磨摩魔抹末莫墨默沫漠寞陌谋牟某拇牡亩姆母墓暮幕募慕木目睦牧穆拿哪呐钠那娜纳氖乃奶耐奈南男难囊挠脑恼闹淖呢馁内嫩能妮霓倪泥尼拟你匿腻逆溺蔫拈年碾撵捻念娘酿鸟尿捏聂孽啮镊镍涅您柠狞凝宁"],["c540","臔",14,"臤臥臦臨臩臫臮",4,"臵",5,"臽臿舃與",4,"舎舏舑舓舕",5,"舝舠舤舥舦舧舩舮舲舺舼舽舿"],["c580","艀艁艂艃艅艆艈艊艌艍艎艐",7,"艙艛艜艝艞艠",7,"艩拧泞牛扭钮纽脓浓农弄奴努怒女暖虐疟挪懦糯诺哦欧鸥殴藕呕偶沤啪趴爬帕怕琶拍排牌徘湃派攀潘盘磐盼畔判叛乓庞旁耪胖抛咆刨炮袍跑泡呸胚培裴赔陪配佩沛喷盆砰抨烹澎彭蓬棚硼篷膨朋鹏捧碰坯砒霹批披劈琵毗"],["c640","艪艫艬艭艱艵艶艷艸艻艼芀芁芃芅芆芇芉芌芐芓芔芕芖芚芛芞芠芢芣芧芲芵芶芺芻芼芿苀苂苃苅苆苉苐苖苙苚苝苢苧苨苩苪苬苭苮苰苲苳苵苶苸"],["c680","苺苼",4,"茊茋茍茐茒茓茖茘茙茝",9,"茩茪茮茰茲茷茻茽啤脾疲皮匹痞僻屁譬篇偏片骗飘漂瓢票撇瞥拼频贫品聘乒坪苹萍平凭瓶评屏坡泼颇婆破魄迫粕剖扑铺仆莆葡菩蒲埔朴圃普浦谱曝瀑期欺栖戚妻七凄漆柒沏其棋奇歧畦崎脐齐旗祈祁骑起岂乞企启契砌器气迄弃汽泣讫掐"],["c740","茾茿荁荂荄荅荈荊",4,"荓荕",4,"荝荢荰",6,"荹荺荾",6,"莇莈莊莋莌莍莏莐莑莔莕莖莗莙莚莝莟莡",6,"莬莭莮"],["c780","莯莵莻莾莿菂菃菄菆菈菉菋菍菎菐菑菒菓菕菗菙菚菛菞菢菣菤菦菧菨菫菬菭恰洽牵扦钎铅千迁签仟谦乾黔钱钳前潜遣浅谴堑嵌欠歉枪呛腔羌墙蔷强抢橇锹敲悄桥瞧乔侨巧鞘撬翘峭俏窍切茄且怯窃钦侵亲秦琴勤芹擒禽寝沁青轻氢倾卿清擎晴氰情顷请庆琼穷秋丘邱球求囚酋泅趋区蛆曲躯屈驱渠"],["c840","菮華菳",4,"菺菻菼菾菿萀萂萅萇萈萉萊萐萒",5,"萙萚萛萞",5,"萩",7,"萲",5,"萹萺萻萾",7,"葇葈葉"],["c880","葊",6,"葒",4,"葘葝葞葟葠葢葤",4,"葪葮葯葰葲葴葷葹葻葼取娶龋趣去圈颧权醛泉全痊拳犬券劝缺炔瘸却鹊榷确雀裙群然燃冉染瓤壤攘嚷让饶扰绕惹热壬仁人忍韧任认刃妊纫扔仍日戎茸蓉荣融熔溶容绒冗揉柔肉茹蠕儒孺如辱乳汝入褥软阮蕊瑞锐闰润若弱撒洒萨腮鳃塞赛三叁"],["c940","葽",4,"蒃蒄蒅蒆蒊蒍蒏",7,"蒘蒚蒛蒝蒞蒟蒠蒢",12,"蒰蒱蒳蒵蒶蒷蒻蒼蒾蓀蓂蓃蓅蓆蓇蓈蓋蓌蓎蓏蓒蓔蓕蓗"],["c980","蓘",4,"蓞蓡蓢蓤蓧",4,"蓭蓮蓯蓱",10,"蓽蓾蔀蔁蔂伞散桑嗓丧搔骚扫嫂瑟色涩森僧莎砂杀刹沙纱傻啥煞筛晒珊苫杉山删煽衫闪陕擅赡膳善汕扇缮墒伤商赏晌上尚裳梢捎稍烧芍勺韶少哨邵绍奢赊蛇舌舍赦摄射慑涉社设砷申呻伸身深娠绅神沈审婶甚肾慎渗声生甥牲升绳"],["ca40","蔃",8,"蔍蔎蔏蔐蔒蔔蔕蔖蔘蔙蔛蔜蔝蔞蔠蔢",8,"蔭",9,"蔾",4,"蕄蕅蕆蕇蕋",10],["ca80","蕗蕘蕚蕛蕜蕝蕟",4,"蕥蕦蕧蕩",8,"蕳蕵蕶蕷蕸蕼蕽蕿薀薁省盛剩胜圣师失狮施湿诗尸虱十石拾时什食蚀实识史矢使屎驶始式示士世柿事拭誓逝势是嗜噬适仕侍释饰氏市恃室视试收手首守寿授售受瘦兽蔬枢梳殊抒输叔舒淑疏书赎孰熟薯暑曙署蜀黍鼠属术述树束戍竖墅庶数漱"],["cb40","薂薃薆薈",6,"薐",10,"薝",6,"薥薦薧薩薫薬薭薱",5,"薸薺",6,"藂",6,"藊",4,"藑藒"],["cb80","藔藖",5,"藝",6,"藥藦藧藨藪",14,"恕刷耍摔衰甩帅栓拴霜双爽谁水睡税吮瞬顺舜说硕朔烁斯撕嘶思私司丝死肆寺嗣四伺似饲巳松耸怂颂送宋讼诵搜艘擞嗽苏酥俗素速粟僳塑溯宿诉肃酸蒜算虽隋随绥髓碎岁穗遂隧祟孙损笋蓑梭唆缩琐索锁所塌他它她塔"],["cc40","藹藺藼藽藾蘀",4,"蘆",10,"蘒蘓蘔蘕蘗",15,"蘨蘪",13,"蘹蘺蘻蘽蘾蘿虀"],["cc80","虁",11,"虒虓處",4,"虛虜虝號虠虡虣",7,"獭挞蹋踏胎苔抬台泰酞太态汰坍摊贪瘫滩坛檀痰潭谭谈坦毯袒碳探叹炭汤塘搪堂棠膛唐糖倘躺淌趟烫掏涛滔绦萄桃逃淘陶讨套特藤腾疼誊梯剔踢锑提题蹄啼体替嚏惕涕剃屉天添填田甜恬舔腆挑条迢眺跳贴铁帖厅听烃"],["cd40","虭虯虰虲",6,"蚃",6,"蚎",4,"蚔蚖",5,"蚞",4,"蚥蚦蚫蚭蚮蚲蚳蚷蚸蚹蚻",4,"蛁蛂蛃蛅蛈蛌蛍蛒蛓蛕蛖蛗蛚蛜"],["cd80","蛝蛠蛡蛢蛣蛥蛦蛧蛨蛪蛫蛬蛯蛵蛶蛷蛺蛻蛼蛽蛿蜁蜄蜅蜆蜋蜌蜎蜏蜐蜑蜔蜖汀廷停亭庭挺艇通桐酮瞳同铜彤童桶捅筒统痛偷投头透凸秃突图徒途涂屠土吐兔湍团推颓腿蜕褪退吞屯臀拖托脱鸵陀驮驼椭妥拓唾挖哇蛙洼娃瓦袜歪外豌弯湾玩顽丸烷完碗挽晚皖惋宛婉万腕汪王亡枉网往旺望忘妄威"],["ce40","蜙蜛蜝蜟蜠蜤蜦蜧蜨蜪蜫蜬蜭蜯蜰蜲蜳蜵蜶蜸蜹蜺蜼蜽蝀",6,"蝊蝋蝍蝏蝐蝑蝒蝔蝕蝖蝘蝚",5,"蝡蝢蝦",7,"蝯蝱蝲蝳蝵"],["ce80","蝷蝸蝹蝺蝿螀螁螄螆螇螉螊螌螎",4,"螔螕螖螘",6,"螠",4,"巍微危韦违桅围唯惟为潍维苇萎委伟伪尾纬未蔚味畏胃喂魏位渭谓尉慰卫瘟温蚊文闻纹吻稳紊问嗡翁瓮挝蜗涡窝我斡卧握沃巫呜钨乌污诬屋无芜梧吾吴毋武五捂午舞伍侮坞戊雾晤物勿务悟误昔熙析西硒矽晰嘻吸锡牺"],["cf40","螥螦螧螩螪螮螰螱螲螴螶螷螸螹螻螼螾螿蟁",4,"蟇蟈蟉蟌",4,"蟔",6,"蟜蟝蟞蟟蟡蟢蟣蟤蟦蟧蟨蟩蟫蟬蟭蟯",9],["cf80","蟺蟻蟼蟽蟿蠀蠁蠂蠄",5,"蠋",7,"蠔蠗蠘蠙蠚蠜",4,"蠣稀息希悉膝夕惜熄烯溪汐犀檄袭席习媳喜铣洗系隙戏细瞎虾匣霞辖暇峡侠狭下厦夏吓掀锨先仙鲜纤咸贤衔舷闲涎弦嫌显险现献县腺馅羡宪陷限线相厢镶香箱襄湘乡翔祥详想响享项巷橡像向象萧硝霄削哮嚣销消宵淆晓"],["d040","蠤",13,"蠳",5,"蠺蠻蠽蠾蠿衁衂衃衆",5,"衎",5,"衕衖衘衚",6,"衦衧衪衭衯衱衳衴衵衶衸衹衺"],["d080","衻衼袀袃袆袇袉袊袌袎袏袐袑袓袔袕袗",4,"袝",4,"袣袥",5,"小孝校肖啸笑效楔些歇蝎鞋协挟携邪斜胁谐写械卸蟹懈泄泻谢屑薪芯锌欣辛新忻心信衅星腥猩惺兴刑型形邢行醒幸杏性姓兄凶胸匈汹雄熊休修羞朽嗅锈秀袖绣墟戌需虚嘘须徐许蓄酗叙旭序畜恤絮婿绪续轩喧宣悬旋玄"],["d140","袬袮袯袰袲",4,"袸袹袺袻袽袾袿裀裃裄裇裈裊裋裌裍裏裐裑裓裖裗裚",4,"裠裡裦裧裩",6,"裲裵裶裷裺裻製裿褀褁褃",5],["d180","褉褋",4,"褑褔",4,"褜",4,"褢褣褤褦褧褨褩褬褭褮褯褱褲褳褵褷选癣眩绚靴薛学穴雪血勋熏循旬询寻驯巡殉汛训讯逊迅压押鸦鸭呀丫芽牙蚜崖衙涯雅哑亚讶焉咽阉烟淹盐严研蜒岩延言颜阎炎沿奄掩眼衍演艳堰燕厌砚雁唁彦焰宴谚验殃央鸯秧杨扬佯疡羊洋阳氧仰痒养样漾邀腰妖瑶"],["d240","褸",8,"襂襃襅",24,"襠",5,"襧",19,"襼"],["d280","襽襾覀覂覄覅覇",26,"摇尧遥窑谣姚咬舀药要耀椰噎耶爷野冶也页掖业叶曳腋夜液一壹医揖铱依伊衣颐夷遗移仪胰疑沂宜姨彝椅蚁倚已乙矣以艺抑易邑屹亿役臆逸肄疫亦裔意毅忆义益溢诣议谊译异翼翌绎茵荫因殷音阴姻吟银淫寅饮尹引隐"],["d340","覢",30,"觃觍觓觔觕觗觘觙觛觝觟觠觡觢觤觧觨觩觪觬觭觮觰觱觲觴",6],["d380","觻",4,"訁",5,"計",21,"印英樱婴鹰应缨莹萤营荧蝇迎赢盈影颖硬映哟拥佣臃痈庸雍踊蛹咏泳涌永恿勇用幽优悠忧尤由邮铀犹油游酉有友右佑釉诱又幼迂淤于盂榆虞愚舆余俞逾鱼愉渝渔隅予娱雨与屿禹宇语羽玉域芋郁吁遇喻峪御愈欲狱育誉"],["d440","訞",31,"訿",8,"詉",21],["d480","詟",25,"詺",6,"浴寓裕预豫驭鸳渊冤元垣袁原援辕园员圆猿源缘远苑愿怨院曰约越跃钥岳粤月悦阅耘云郧匀陨允运蕴酝晕韵孕匝砸杂栽哉灾宰载再在咱攒暂赞赃脏葬遭糟凿藻枣早澡蚤躁噪造皂灶燥责择则泽贼怎增憎曾赠扎喳渣札轧"],["d540","誁",7,"誋",7,"誔",46],["d580","諃",32,"铡闸眨栅榨咋乍炸诈摘斋宅窄债寨瞻毡詹粘沾盏斩辗崭展蘸栈占战站湛绽樟章彰漳张掌涨杖丈帐账仗胀瘴障招昭找沼赵照罩兆肇召遮折哲蛰辙者锗蔗这浙珍斟真甄砧臻贞针侦枕疹诊震振镇阵蒸挣睁征狰争怔整拯正政"],["d640","諤",34,"謈",27],["d680","謤謥謧",30,"帧症郑证芝枝支吱蜘知肢脂汁之织职直植殖执值侄址指止趾只旨纸志挚掷至致置帜峙制智秩稚质炙痔滞治窒中盅忠钟衷终种肿重仲众舟周州洲诌粥轴肘帚咒皱宙昼骤珠株蛛朱猪诸诛逐竹烛煮拄瞩嘱主著柱助蛀贮铸筑"],["d740","譆",31,"譧",4,"譭",25],["d780","讇",24,"讬讱讻诇诐诪谉谞住注祝驻抓爪拽专砖转撰赚篆桩庄装妆撞壮状椎锥追赘坠缀谆准捉拙卓桌琢茁酌啄着灼浊兹咨资姿滋淄孜紫仔籽滓子自渍字鬃棕踪宗综总纵邹走奏揍租足卒族祖诅阻组钻纂嘴醉最罪尊遵昨左佐柞做作坐座"],["d840","谸",8,"豂豃豄豅豈豊豋豍",7,"豖豗豘豙豛",5,"豣",6,"豬",6,"豴豵豶豷豻",6,"貃貄貆貇"],["d880","貈貋貍",6,"貕貖貗貙",20,"亍丌兀丐廿卅丕亘丞鬲孬噩丨禺丿匕乇夭爻卮氐囟胤馗毓睾鼗丶亟鼐乜乩亓芈孛啬嘏仄厍厝厣厥厮靥赝匚叵匦匮匾赜卦卣刂刈刎刭刳刿剀剌剞剡剜蒯剽劂劁劐劓冂罔亻仃仉仂仨仡仫仞伛仳伢佤仵伥伧伉伫佞佧攸佚佝"],["d940","貮",62],["d980","賭",32,"佟佗伲伽佶佴侑侉侃侏佾佻侪佼侬侔俦俨俪俅俚俣俜俑俟俸倩偌俳倬倏倮倭俾倜倌倥倨偾偃偕偈偎偬偻傥傧傩傺僖儆僭僬僦僮儇儋仝氽佘佥俎龠汆籴兮巽黉馘冁夔勹匍訇匐凫夙兕亠兖亳衮袤亵脔裒禀嬴蠃羸冫冱冽冼"],["da40","贎",14,"贠赑赒赗赟赥赨赩赪赬赮赯赱赲赸",8,"趂趃趆趇趈趉趌",4,"趒趓趕",9,"趠趡"],["da80","趢趤",12,"趲趶趷趹趻趽跀跁跂跅跇跈跉跊跍跐跒跓跔凇冖冢冥讠讦讧讪讴讵讷诂诃诋诏诎诒诓诔诖诘诙诜诟诠诤诨诩诮诰诳诶诹诼诿谀谂谄谇谌谏谑谒谔谕谖谙谛谘谝谟谠谡谥谧谪谫谮谯谲谳谵谶卩卺阝阢阡阱阪阽阼陂陉陔陟陧陬陲陴隈隍隗隰邗邛邝邙邬邡邴邳邶邺"],["db40","跕跘跙跜跠跡跢跥跦跧跩跭跮跰跱跲跴跶跼跾",6,"踆踇踈踋踍踎踐踑踒踓踕",7,"踠踡踤",4,"踫踭踰踲踳踴踶踷踸踻踼踾"],["db80","踿蹃蹅蹆蹌",4,"蹓",5,"蹚",11,"蹧蹨蹪蹫蹮蹱邸邰郏郅邾郐郄郇郓郦郢郜郗郛郫郯郾鄄鄢鄞鄣鄱鄯鄹酃酆刍奂劢劬劭劾哿勐勖勰叟燮矍廴凵凼鬯厶弁畚巯坌垩垡塾墼壅壑圩圬圪圳圹圮圯坜圻坂坩垅坫垆坼坻坨坭坶坳垭垤垌垲埏垧垴垓垠埕埘埚埙埒垸埴埯埸埤埝"],["dc40","蹳蹵蹷",4,"蹽蹾躀躂躃躄躆躈",6,"躑躒躓躕",6,"躝躟",11,"躭躮躰躱躳",6,"躻",7],["dc80","軃",10,"軏",21,"堋堍埽埭堀堞堙塄堠塥塬墁墉墚墀馨鼙懿艹艽艿芏芊芨芄芎芑芗芙芫芸芾芰苈苊苣芘芷芮苋苌苁芩芴芡芪芟苄苎芤苡茉苷苤茏茇苜苴苒苘茌苻苓茑茚茆茔茕苠苕茜荑荛荜茈莒茼茴茱莛荞茯荏荇荃荟荀茗荠茭茺茳荦荥"],["dd40","軥",62],["dd80","輤",32,"荨茛荩荬荪荭荮莰荸莳莴莠莪莓莜莅荼莶莩荽莸荻莘莞莨莺莼菁萁菥菘堇萘萋菝菽菖萜萸萑萆菔菟萏萃菸菹菪菅菀萦菰菡葜葑葚葙葳蒇蒈葺蒉葸萼葆葩葶蒌蒎萱葭蓁蓍蓐蓦蒽蓓蓊蒿蒺蓠蒡蒹蒴蒗蓥蓣蔌甍蔸蓰蔹蔟蔺"],["de40","轅",32,"轪辀辌辒辝辠辡辢辤辥辦辧辪辬辭辮辯農辳辴辵辷辸辺辻込辿迀迃迆"],["de80","迉",4,"迏迒迖迗迚迠迡迣迧迬迯迱迲迴迵迶迺迻迼迾迿逇逈逌逎逓逕逘蕖蔻蓿蓼蕙蕈蕨蕤蕞蕺瞢蕃蕲蕻薤薨薇薏蕹薮薜薅薹薷薰藓藁藜藿蘧蘅蘩蘖蘼廾弈夼奁耷奕奚奘匏尢尥尬尴扌扪抟抻拊拚拗拮挢拶挹捋捃掭揶捱捺掎掴捭掬掊捩掮掼揲揸揠揿揄揞揎摒揆掾摅摁搋搛搠搌搦搡摞撄摭撖"],["df40","這逜連逤逥逧",5,"逰",4,"逷逹逺逽逿遀遃遅遆遈",4,"過達違遖遙遚遜",5,"遤遦遧適遪遫遬遯",4,"遶",6,"遾邁"],["df80","還邅邆邇邉邊邌",4,"邒邔邖邘邚邜邞邟邠邤邥邧邨邩邫邭邲邷邼邽邿郀摺撷撸撙撺擀擐擗擤擢攉攥攮弋忒甙弑卟叱叽叩叨叻吒吖吆呋呒呓呔呖呃吡呗呙吣吲咂咔呷呱呤咚咛咄呶呦咝哐咭哂咴哒咧咦哓哔呲咣哕咻咿哌哙哚哜咩咪咤哝哏哞唛哧唠哽唔哳唢唣唏唑唧唪啧喏喵啉啭啁啕唿啐唼"],["e040","郂郃郆郈郉郋郌郍郒郔郕郖郘郙郚郞郟郠郣郤郥郩郪郬郮郰郱郲郳郵郶郷郹郺郻郼郿鄀鄁鄃鄅",19,"鄚鄛鄜"],["e080","鄝鄟鄠鄡鄤",10,"鄰鄲",6,"鄺",8,"酄唷啖啵啶啷唳唰啜喋嗒喃喱喹喈喁喟啾嗖喑啻嗟喽喾喔喙嗪嗷嗉嘟嗑嗫嗬嗔嗦嗝嗄嗯嗥嗲嗳嗌嗍嗨嗵嗤辔嘞嘈嘌嘁嘤嘣嗾嘀嘧嘭噘嘹噗嘬噍噢噙噜噌噔嚆噤噱噫噻噼嚅嚓嚯囔囗囝囡囵囫囹囿圄圊圉圜帏帙帔帑帱帻帼"],["e140","酅酇酈酑酓酔酕酖酘酙酛酜酟酠酦酧酨酫酭酳酺酻酼醀",4,"醆醈醊醎醏醓",6,"醜",5,"醤",5,"醫醬醰醱醲醳醶醷醸醹醻"],["e180","醼",10,"釈釋釐釒",9,"針",8,"帷幄幔幛幞幡岌屺岍岐岖岈岘岙岑岚岜岵岢岽岬岫岱岣峁岷峄峒峤峋峥崂崃崧崦崮崤崞崆崛嵘崾崴崽嵬嵛嵯嵝嵫嵋嵊嵩嵴嶂嶙嶝豳嶷巅彳彷徂徇徉後徕徙徜徨徭徵徼衢彡犭犰犴犷犸狃狁狎狍狒狨狯狩狲狴狷猁狳猃狺"],["e240","釦",62],["e280","鈥",32,"狻猗猓猡猊猞猝猕猢猹猥猬猸猱獐獍獗獠獬獯獾舛夥飧夤夂饣饧",5,"饴饷饽馀馄馇馊馍馐馑馓馔馕庀庑庋庖庥庠庹庵庾庳赓廒廑廛廨廪膺忄忉忖忏怃忮怄忡忤忾怅怆忪忭忸怙怵怦怛怏怍怩怫怊怿怡恸恹恻恺恂"],["e340","鉆",45,"鉵",16],["e380","銆",7,"銏",24,"恪恽悖悚悭悝悃悒悌悛惬悻悱惝惘惆惚悴愠愦愕愣惴愀愎愫慊慵憬憔憧憷懔懵忝隳闩闫闱闳闵闶闼闾阃阄阆阈阊阋阌阍阏阒阕阖阗阙阚丬爿戕氵汔汜汊沣沅沐沔沌汨汩汴汶沆沩泐泔沭泷泸泱泗沲泠泖泺泫泮沱泓泯泾"],["e440","銨",5,"銯",24,"鋉",31],["e480","鋩",32,"洹洧洌浃浈洇洄洙洎洫浍洮洵洚浏浒浔洳涑浯涞涠浞涓涔浜浠浼浣渚淇淅淞渎涿淠渑淦淝淙渖涫渌涮渫湮湎湫溲湟溆湓湔渲渥湄滟溱溘滠漭滢溥溧溽溻溷滗溴滏溏滂溟潢潆潇漤漕滹漯漶潋潴漪漉漩澉澍澌潸潲潼潺濑"],["e540","錊",51,"錿",10],["e580","鍊",31,"鍫濉澧澹澶濂濡濮濞濠濯瀚瀣瀛瀹瀵灏灞宀宄宕宓宥宸甯骞搴寤寮褰寰蹇謇辶迓迕迥迮迤迩迦迳迨逅逄逋逦逑逍逖逡逵逶逭逯遄遑遒遐遨遘遢遛暹遴遽邂邈邃邋彐彗彖彘尻咫屐屙孱屣屦羼弪弩弭艴弼鬻屮妁妃妍妩妪妣"],["e640","鍬",34,"鎐",27],["e680","鎬",29,"鏋鏌鏍妗姊妫妞妤姒妲妯姗妾娅娆姝娈姣姘姹娌娉娲娴娑娣娓婀婧婊婕娼婢婵胬媪媛婷婺媾嫫媲嫒嫔媸嫠嫣嫱嫖嫦嫘嫜嬉嬗嬖嬲嬷孀尕尜孚孥孳孑孓孢驵驷驸驺驿驽骀骁骅骈骊骐骒骓骖骘骛骜骝骟骠骢骣骥骧纟纡纣纥纨纩"],["e740","鏎",7,"鏗",54],["e780","鐎",32,"纭纰纾绀绁绂绉绋绌绐绔绗绛绠绡绨绫绮绯绱绲缍绶绺绻绾缁缂缃缇缈缋缌缏缑缒缗缙缜缛缟缡",6,"缪缫缬缭缯",4,"缵幺畿巛甾邕玎玑玮玢玟珏珂珑玷玳珀珉珈珥珙顼琊珩珧珞玺珲琏琪瑛琦琥琨琰琮琬"],["e840","鐯",14,"鐿",43,"鑬鑭鑮鑯"],["e880","鑰",20,"钑钖钘铇铏铓铔铚铦铻锜锠琛琚瑁瑜瑗瑕瑙瑷瑭瑾璜璎璀璁璇璋璞璨璩璐璧瓒璺韪韫韬杌杓杞杈杩枥枇杪杳枘枧杵枨枞枭枋杷杼柰栉柘栊柩枰栌柙枵柚枳柝栀柃枸柢栎柁柽栲栳桠桡桎桢桄桤梃栝桕桦桁桧桀栾桊桉栩梵梏桴桷梓桫棂楮棼椟椠棹"],["e940","锧锳锽镃镈镋镕镚镠镮镴镵長",7,"門",42],["e980","閫",32,"椤棰椋椁楗棣椐楱椹楠楂楝榄楫榀榘楸椴槌榇榈槎榉楦楣楹榛榧榻榫榭槔榱槁槊槟榕槠榍槿樯槭樗樘橥槲橄樾檠橐橛樵檎橹樽樨橘橼檑檐檩檗檫猷獒殁殂殇殄殒殓殍殚殛殡殪轫轭轱轲轳轵轶轸轷轹轺轼轾辁辂辄辇辋"],["ea40","闌",27,"闬闿阇阓阘阛阞阠阣",6,"阫阬阭阯阰阷阸阹阺阾陁陃陊陎陏陑陒陓陖陗"],["ea80","陘陙陚陜陝陞陠陣陥陦陫陭",4,"陳陸",12,"隇隉隊辍辎辏辘辚軎戋戗戛戟戢戡戥戤戬臧瓯瓴瓿甏甑甓攴旮旯旰昊昙杲昃昕昀炅曷昝昴昱昶昵耆晟晔晁晏晖晡晗晷暄暌暧暝暾曛曜曦曩贲贳贶贻贽赀赅赆赈赉赇赍赕赙觇觊觋觌觎觏觐觑牮犟牝牦牯牾牿犄犋犍犏犒挈挲掰"],["eb40","隌階隑隒隓隕隖隚際隝",9,"隨",7,"隱隲隴隵隷隸隺隻隿雂雃雈雊雋雐雑雓雔雖",9,"雡",6,"雫"],["eb80","雬雭雮雰雱雲雴雵雸雺電雼雽雿霂霃霅霊霋霌霐霑霒霔霕霗",4,"霝霟霠搿擘耄毪毳毽毵毹氅氇氆氍氕氘氙氚氡氩氤氪氲攵敕敫牍牒牖爰虢刖肟肜肓肼朊肽肱肫肭肴肷胧胨胩胪胛胂胄胙胍胗朐胝胫胱胴胭脍脎胲胼朕脒豚脶脞脬脘脲腈腌腓腴腙腚腱腠腩腼腽腭腧塍媵膈膂膑滕膣膪臌朦臊膻"],["ec40","霡",8,"霫霬霮霯霱霳",4,"霺霻霼霽霿",18,"靔靕靗靘靚靜靝靟靣靤靦靧靨靪",7],["ec80","靲靵靷",4,"靽",7,"鞆",4,"鞌鞎鞏鞐鞓鞕鞖鞗鞙",4,"臁膦欤欷欹歃歆歙飑飒飓飕飙飚殳彀毂觳斐齑斓於旆旄旃旌旎旒旖炀炜炖炝炻烀炷炫炱烨烊焐焓焖焯焱煳煜煨煅煲煊煸煺熘熳熵熨熠燠燔燧燹爝爨灬焘煦熹戾戽扃扈扉礻祀祆祉祛祜祓祚祢祗祠祯祧祺禅禊禚禧禳忑忐"],["ed40","鞞鞟鞡鞢鞤",6,"鞬鞮鞰鞱鞳鞵",46],["ed80","韤韥韨韮",4,"韴韷",23,"怼恝恚恧恁恙恣悫愆愍慝憩憝懋懑戆肀聿沓泶淼矶矸砀砉砗砘砑斫砭砜砝砹砺砻砟砼砥砬砣砩硎硭硖硗砦硐硇硌硪碛碓碚碇碜碡碣碲碹碥磔磙磉磬磲礅磴礓礤礞礴龛黹黻黼盱眄眍盹眇眈眚眢眙眭眦眵眸睐睑睇睃睚睨"],["ee40","頏",62],["ee80","顎",32,"睢睥睿瞍睽瞀瞌瞑瞟瞠瞰瞵瞽町畀畎畋畈畛畲畹疃罘罡罟詈罨罴罱罹羁罾盍盥蠲钅钆钇钋钊钌钍钏钐钔钗钕钚钛钜钣钤钫钪钭钬钯钰钲钴钶",4,"钼钽钿铄铈",6,"铐铑铒铕铖铗铙铘铛铞铟铠铢铤铥铧铨铪"],["ef40","顯",5,"颋颎颒颕颙颣風",37,"飏飐飔飖飗飛飜飝飠",4],["ef80","飥飦飩",30,"铩铫铮铯铳铴铵铷铹铼铽铿锃锂锆锇锉锊锍锎锏锒",4,"锘锛锝锞锟锢锪锫锩锬锱锲锴锶锷锸锼锾锿镂锵镄镅镆镉镌镎镏镒镓镔镖镗镘镙镛镞镟镝镡镢镤",8,"镯镱镲镳锺矧矬雉秕秭秣秫稆嵇稃稂稞稔"],["f040","餈",4,"餎餏餑",28,"餯",26],["f080","饊",9,"饖",12,"饤饦饳饸饹饻饾馂馃馉稹稷穑黏馥穰皈皎皓皙皤瓞瓠甬鸠鸢鸨",4,"鸲鸱鸶鸸鸷鸹鸺鸾鹁鹂鹄鹆鹇鹈鹉鹋鹌鹎鹑鹕鹗鹚鹛鹜鹞鹣鹦",6,"鹱鹭鹳疒疔疖疠疝疬疣疳疴疸痄疱疰痃痂痖痍痣痨痦痤痫痧瘃痱痼痿瘐瘀瘅瘌瘗瘊瘥瘘瘕瘙"],["f140","馌馎馚",10,"馦馧馩",47],["f180","駙",32,"瘛瘼瘢瘠癀瘭瘰瘿瘵癃瘾瘳癍癞癔癜癖癫癯翊竦穸穹窀窆窈窕窦窠窬窨窭窳衤衩衲衽衿袂袢裆袷袼裉裢裎裣裥裱褚裼裨裾裰褡褙褓褛褊褴褫褶襁襦襻疋胥皲皴矜耒耔耖耜耠耢耥耦耧耩耨耱耋耵聃聆聍聒聩聱覃顸颀颃"],["f240","駺",62],["f280","騹",32,"颉颌颍颏颔颚颛颞颟颡颢颥颦虍虔虬虮虿虺虼虻蚨蚍蚋蚬蚝蚧蚣蚪蚓蚩蚶蛄蚵蛎蚰蚺蚱蚯蛉蛏蚴蛩蛱蛲蛭蛳蛐蜓蛞蛴蛟蛘蛑蜃蜇蛸蜈蜊蜍蜉蜣蜻蜞蜥蜮蜚蜾蝈蜴蜱蜩蜷蜿螂蜢蝽蝾蝻蝠蝰蝌蝮螋蝓蝣蝼蝤蝙蝥螓螯螨蟒"],["f340","驚",17,"驲骃骉骍骎骔骕骙骦骩",6,"骲骳骴骵骹骻骽骾骿髃髄髆",4,"髍髎髏髐髒體髕髖髗髙髚髛髜"],["f380","髝髞髠髢髣髤髥髧髨髩髪髬髮髰",8,"髺髼",6,"鬄鬅鬆蟆螈螅螭螗螃螫蟥螬螵螳蟋蟓螽蟑蟀蟊蟛蟪蟠蟮蠖蠓蟾蠊蠛蠡蠹蠼缶罂罄罅舐竺竽笈笃笄笕笊笫笏筇笸笪笙笮笱笠笥笤笳笾笞筘筚筅筵筌筝筠筮筻筢筲筱箐箦箧箸箬箝箨箅箪箜箢箫箴篑篁篌篝篚篥篦篪簌篾篼簏簖簋"],["f440","鬇鬉",5,"鬐鬑鬒鬔",10,"鬠鬡鬢鬤",10,"鬰鬱鬳",7,"鬽鬾鬿魀魆魊魋魌魎魐魒魓魕",5],["f480","魛",32,"簟簪簦簸籁籀臾舁舂舄臬衄舡舢舣舭舯舨舫舸舻舳舴舾艄艉艋艏艚艟艨衾袅袈裘裟襞羝羟羧羯羰羲籼敉粑粝粜粞粢粲粼粽糁糇糌糍糈糅糗糨艮暨羿翎翕翥翡翦翩翮翳糸絷綦綮繇纛麸麴赳趄趔趑趱赧赭豇豉酊酐酎酏酤"],["f540","魼",62],["f580","鮻",32,"酢酡酰酩酯酽酾酲酴酹醌醅醐醍醑醢醣醪醭醮醯醵醴醺豕鹾趸跫踅蹙蹩趵趿趼趺跄跖跗跚跞跎跏跛跆跬跷跸跣跹跻跤踉跽踔踝踟踬踮踣踯踺蹀踹踵踽踱蹉蹁蹂蹑蹒蹊蹰蹶蹼蹯蹴躅躏躔躐躜躞豸貂貊貅貘貔斛觖觞觚觜"],["f640","鯜",62],["f680","鰛",32,"觥觫觯訾謦靓雩雳雯霆霁霈霏霎霪霭霰霾龀龃龅",5,"龌黾鼋鼍隹隼隽雎雒瞿雠銎銮鋈錾鍪鏊鎏鐾鑫鱿鲂鲅鲆鲇鲈稣鲋鲎鲐鲑鲒鲔鲕鲚鲛鲞",5,"鲥",4,"鲫鲭鲮鲰",7,"鲺鲻鲼鲽鳄鳅鳆鳇鳊鳋"],["f740","鰼",62],["f780","鱻鱽鱾鲀鲃鲄鲉鲊鲌鲏鲓鲖鲗鲘鲙鲝鲪鲬鲯鲹鲾",4,"鳈鳉鳑鳒鳚鳛鳠鳡鳌",4,"鳓鳔鳕鳗鳘鳙鳜鳝鳟鳢靼鞅鞑鞒鞔鞯鞫鞣鞲鞴骱骰骷鹘骶骺骼髁髀髅髂髋髌髑魅魃魇魉魈魍魑飨餍餮饕饔髟髡髦髯髫髻髭髹鬈鬏鬓鬟鬣麽麾縻麂麇麈麋麒鏖麝麟黛黜黝黠黟黢黩黧黥黪黯鼢鼬鼯鼹鼷鼽鼾齄"],["f840","鳣",62],["f880","鴢",32],["f940","鵃",62],["f980","鶂",32],["fa40","鶣",62],["fa80","鷢",32],["fb40","鸃",27,"鸤鸧鸮鸰鸴鸻鸼鹀鹍鹐鹒鹓鹔鹖鹙鹝鹟鹠鹡鹢鹥鹮鹯鹲鹴",9,"麀"],["fb80","麁麃麄麅麆麉麊麌",5,"麔",8,"麞麠",5,"麧麨麩麪"],["fc40","麫",8,"麵麶麷麹麺麼麿",4,"黅黆黇黈黊黋黌黐黒黓黕黖黗黙黚點黡黣黤黦黨黫黬黭黮黰",8,"黺黽黿",6],["fc80","鼆",4,"鼌鼏鼑鼒鼔鼕鼖鼘鼚",5,"鼡鼣",8,"鼭鼮鼰鼱"],["fd40","鼲",4,"鼸鼺鼼鼿",4,"齅",10,"齒",38],["fd80","齹",5,"龁龂龍",11,"龜龝龞龡",4,"郎凉秊裏隣"],["fe40","兀嗀﨎﨏﨑﨓﨔礼﨟蘒﨡﨣﨤﨧﨨﨩"]]');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/cp949.json":
/*!*************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/cp949.json ***!
  \*************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["0","\\u0000",127],["8141","갂갃갅갆갋",4,"갘갞갟갡갢갣갥",6,"갮갲갳갴"],["8161","갵갶갷갺갻갽갾갿걁",9,"걌걎",5,"걕"],["8181","걖걗걙걚걛걝",18,"걲걳걵걶걹걻",4,"겂겇겈겍겎겏겑겒겓겕",6,"겞겢",5,"겫겭겮겱",6,"겺겾겿곀곂곃곅곆곇곉곊곋곍",7,"곖곘",7,"곢곣곥곦곩곫곭곮곲곴곷",4,"곾곿괁괂괃괅괇",4,"괎괐괒괓"],["8241","괔괕괖괗괙괚괛괝괞괟괡",7,"괪괫괮",5],["8261","괶괷괹괺괻괽",6,"굆굈굊",5,"굑굒굓굕굖굗"],["8281","굙",7,"굢굤",7,"굮굯굱굲굷굸굹굺굾궀궃",4,"궊궋궍궎궏궑",10,"궞",5,"궥",17,"궸",7,"귂귃귅귆귇귉",6,"귒귔",7,"귝귞귟귡귢귣귥",18],["8341","귺귻귽귾긂",5,"긊긌긎",5,"긕",7],["8361","긝",18,"긲긳긵긶긹긻긼"],["8381","긽긾긿깂깄깇깈깉깋깏깑깒깓깕깗",4,"깞깢깣깤깦깧깪깫깭깮깯깱",6,"깺깾",5,"꺆",5,"꺍",46,"꺿껁껂껃껅",6,"껎껒",5,"껚껛껝",8],["8441","껦껧껩껪껬껮",5,"껵껶껷껹껺껻껽",8],["8461","꼆꼉꼊꼋꼌꼎꼏꼑",18],["8481","꼤",7,"꼮꼯꼱꼳꼵",6,"꼾꽀꽄꽅꽆꽇꽊",5,"꽑",10,"꽞",5,"꽦",18,"꽺",5,"꾁꾂꾃꾅꾆꾇꾉",6,"꾒꾓꾔꾖",5,"꾝",26,"꾺꾻꾽꾾"],["8541","꾿꿁",5,"꿊꿌꿏",4,"꿕",6,"꿝",4],["8561","꿢",5,"꿪",5,"꿲꿳꿵꿶꿷꿹",6,"뀂뀃"],["8581","뀅",6,"뀍뀎뀏뀑뀒뀓뀕",6,"뀞",9,"뀩",26,"끆끇끉끋끍끏끐끑끒끖끘끚끛끜끞",29,"끾끿낁낂낃낅",6,"낎낐낒",5,"낛낝낞낣낤"],["8641","낥낦낧낪낰낲낶낷낹낺낻낽",6,"냆냊",5,"냒"],["8661","냓냕냖냗냙",6,"냡냢냣냤냦",10],["8681","냱",22,"넊넍넎넏넑넔넕넖넗넚넞",4,"넦넧넩넪넫넭",6,"넶넺",5,"녂녃녅녆녇녉",6,"녒녓녖녗녙녚녛녝녞녟녡",22,"녺녻녽녾녿놁놃",4,"놊놌놎놏놐놑놕놖놗놙놚놛놝"],["8741","놞",9,"놩",15],["8761","놹",18,"뇍뇎뇏뇑뇒뇓뇕"],["8781","뇖",5,"뇞뇠",7,"뇪뇫뇭뇮뇯뇱",7,"뇺뇼뇾",5,"눆눇눉눊눍",6,"눖눘눚",5,"눡",18,"눵",6,"눽",26,"뉙뉚뉛뉝뉞뉟뉡",6,"뉪",4],["8841","뉯",4,"뉶",5,"뉽",6,"늆늇늈늊",4],["8861","늏늒늓늕늖늗늛",4,"늢늤늧늨늩늫늭늮늯늱늲늳늵늶늷"],["8881","늸",15,"닊닋닍닎닏닑닓",4,"닚닜닞닟닠닡닣닧닩닪닰닱닲닶닼닽닾댂댃댅댆댇댉",6,"댒댖",5,"댝",54,"덗덙덚덝덠덡덢덣"],["8941","덦덨덪덬덭덯덲덳덵덶덷덹",6,"뎂뎆",5,"뎍"],["8961","뎎뎏뎑뎒뎓뎕",10,"뎢",5,"뎩뎪뎫뎭"],["8981","뎮",21,"돆돇돉돊돍돏돑돒돓돖돘돚돜돞돟돡돢돣돥돦돧돩",18,"돽",18,"됑",6,"됙됚됛됝됞됟됡",6,"됪됬",7,"됵",15],["8a41","둅",10,"둒둓둕둖둗둙",6,"둢둤둦"],["8a61","둧",4,"둭",18,"뒁뒂"],["8a81","뒃",4,"뒉",19,"뒞",5,"뒥뒦뒧뒩뒪뒫뒭",7,"뒶뒸뒺",5,"듁듂듃듅듆듇듉",6,"듑듒듓듔듖",5,"듞듟듡듢듥듧",4,"듮듰듲",5,"듹",26,"딖딗딙딚딝"],["8b41","딞",5,"딦딫",4,"딲딳딵딶딷딹",6,"땂땆"],["8b61","땇땈땉땊땎땏땑땒땓땕",6,"땞땢",8],["8b81","땫",52,"떢떣떥떦떧떩떬떭떮떯떲떶",4,"떾떿뗁뗂뗃뗅",6,"뗎뗒",5,"뗙",18,"뗭",18],["8c41","똀",15,"똒똓똕똖똗똙",4],["8c61","똞",6,"똦",5,"똭",6,"똵",5],["8c81","똻",12,"뙉",26,"뙥뙦뙧뙩",50,"뚞뚟뚡뚢뚣뚥",5,"뚭뚮뚯뚰뚲",16],["8d41","뛃",16,"뛕",8],["8d61","뛞",17,"뛱뛲뛳뛵뛶뛷뛹뛺"],["8d81","뛻",4,"뜂뜃뜄뜆",33,"뜪뜫뜭뜮뜱",6,"뜺뜼",7,"띅띆띇띉띊띋띍",6,"띖",9,"띡띢띣띥띦띧띩",6,"띲띴띶",5,"띾띿랁랂랃랅",6,"랎랓랔랕랚랛랝랞"],["8e41","랟랡",6,"랪랮",5,"랶랷랹",8],["8e61","럂",4,"럈럊",19],["8e81","럞",13,"럮럯럱럲럳럵",6,"럾렂",4,"렊렋렍렎렏렑",6,"렚렜렞",5,"렦렧렩렪렫렭",6,"렶렺",5,"롁롂롃롅",11,"롒롔",7,"롞롟롡롢롣롥",6,"롮롰롲",5,"롹롺롻롽",7],["8f41","뢅",7,"뢎",17],["8f61","뢠",7,"뢩",6,"뢱뢲뢳뢵뢶뢷뢹",4],["8f81","뢾뢿룂룄룆",5,"룍룎룏룑룒룓룕",7,"룞룠룢",5,"룪룫룭룮룯룱",6,"룺룼룾",5,"뤅",18,"뤙",6,"뤡",26,"뤾뤿륁륂륃륅",6,"륍륎륐륒",5],["9041","륚륛륝륞륟륡",6,"륪륬륮",5,"륶륷륹륺륻륽"],["9061","륾",5,"릆릈릋릌릏",15],["9081","릟",12,"릮릯릱릲릳릵",6,"릾맀맂",5,"맊맋맍맓",4,"맚맜맟맠맢맦맧맩맪맫맭",6,"맶맻",4,"먂",5,"먉",11,"먖",33,"먺먻먽먾먿멁멃멄멅멆"],["9141","멇멊멌멏멐멑멒멖멗멙멚멛멝",6,"멦멪",5],["9161","멲멳멵멶멷멹",9,"몆몈몉몊몋몍",5],["9181","몓",20,"몪몭몮몯몱몳",4,"몺몼몾",5,"뫅뫆뫇뫉",14,"뫚",33,"뫽뫾뫿묁묂묃묅",7,"묎묐묒",5,"묙묚묛묝묞묟묡",6],["9241","묨묪묬",7,"묷묹묺묿",4,"뭆뭈뭊뭋뭌뭎뭑뭒"],["9261","뭓뭕뭖뭗뭙",7,"뭢뭤",7,"뭭",4],["9281","뭲",21,"뮉뮊뮋뮍뮎뮏뮑",18,"뮥뮦뮧뮩뮪뮫뮭",6,"뮵뮶뮸",7,"믁믂믃믅믆믇믉",6,"믑믒믔",35,"믺믻믽믾밁"],["9341","밃",4,"밊밎밐밒밓밙밚밠밡밢밣밦밨밪밫밬밮밯밲밳밵"],["9361","밶밷밹",6,"뱂뱆뱇뱈뱊뱋뱎뱏뱑",8],["9381","뱚뱛뱜뱞",37,"벆벇벉벊벍벏",4,"벖벘벛",4,"벢벣벥벦벩",6,"벲벶",5,"벾벿볁볂볃볅",7,"볎볒볓볔볖볗볙볚볛볝",22,"볷볹볺볻볽"],["9441","볾",5,"봆봈봊",5,"봑봒봓봕",8],["9461","봞",5,"봥",6,"봭",12],["9481","봺",5,"뵁",6,"뵊뵋뵍뵎뵏뵑",6,"뵚",9,"뵥뵦뵧뵩",22,"붂붃붅붆붋",4,"붒붔붖붗붘붛붝",6,"붥",10,"붱",6,"붹",24],["9541","뷒뷓뷖뷗뷙뷚뷛뷝",11,"뷪",5,"뷱"],["9561","뷲뷳뷵뷶뷷뷹",6,"븁븂븄븆",5,"븎븏븑븒븓"],["9581","븕",6,"븞븠",35,"빆빇빉빊빋빍빏",4,"빖빘빜빝빞빟빢빣빥빦빧빩빫",4,"빲빶",4,"빾빿뺁뺂뺃뺅",6,"뺎뺒",5,"뺚",13,"뺩",14],["9641","뺸",23,"뻒뻓"],["9661","뻕뻖뻙",6,"뻡뻢뻦",5,"뻭",8],["9681","뻶",10,"뼂",5,"뼊",13,"뼚뼞",33,"뽂뽃뽅뽆뽇뽉",6,"뽒뽓뽔뽖",44],["9741","뾃",16,"뾕",8],["9761","뾞",17,"뾱",7],["9781","뾹",11,"뿆",5,"뿎뿏뿑뿒뿓뿕",6,"뿝뿞뿠뿢",89,"쀽쀾쀿"],["9841","쁀",16,"쁒",5,"쁙쁚쁛"],["9861","쁝쁞쁟쁡",6,"쁪",15],["9881","쁺",21,"삒삓삕삖삗삙",6,"삢삤삦",5,"삮삱삲삷",4,"삾샂샃샄샆샇샊샋샍샎샏샑",6,"샚샞",5,"샦샧샩샪샫샭",6,"샶샸샺",5,"섁섂섃섅섆섇섉",6,"섑섒섓섔섖",5,"섡섢섥섨섩섪섫섮"],["9941","섲섳섴섵섷섺섻섽섾섿셁",6,"셊셎",5,"셖셗"],["9961","셙셚셛셝",6,"셦셪",5,"셱셲셳셵셶셷셹셺셻"],["9981","셼",8,"솆",5,"솏솑솒솓솕솗",4,"솞솠솢솣솤솦솧솪솫솭솮솯솱",11,"솾",5,"쇅쇆쇇쇉쇊쇋쇍",6,"쇕쇖쇙",6,"쇡쇢쇣쇥쇦쇧쇩",6,"쇲쇴",7,"쇾쇿숁숂숃숅",6,"숎숐숒",5,"숚숛숝숞숡숢숣"],["9a41","숤숥숦숧숪숬숮숰숳숵",16],["9a61","쉆쉇쉉",6,"쉒쉓쉕쉖쉗쉙",6,"쉡쉢쉣쉤쉦"],["9a81","쉧",4,"쉮쉯쉱쉲쉳쉵",6,"쉾슀슂",5,"슊",5,"슑",6,"슙슚슜슞",5,"슦슧슩슪슫슮",5,"슶슸슺",33,"싞싟싡싢싥",5,"싮싰싲싳싴싵싷싺싽싾싿쌁",6,"쌊쌋쌎쌏"],["9b41","쌐쌑쌒쌖쌗쌙쌚쌛쌝",6,"쌦쌧쌪",8],["9b61","쌳",17,"썆",7],["9b81","썎",25,"썪썫썭썮썯썱썳",4,"썺썻썾",5,"쎅쎆쎇쎉쎊쎋쎍",50,"쏁",22,"쏚"],["9c41","쏛쏝쏞쏡쏣",4,"쏪쏫쏬쏮",5,"쏶쏷쏹",5],["9c61","쏿",8,"쐉",6,"쐑",9],["9c81","쐛",8,"쐥",6,"쐭쐮쐯쐱쐲쐳쐵",6,"쐾",9,"쑉",26,"쑦쑧쑩쑪쑫쑭",6,"쑶쑷쑸쑺",5,"쒁",18,"쒕",6,"쒝",12],["9d41","쒪",13,"쒹쒺쒻쒽",8],["9d61","쓆",25],["9d81","쓠",8,"쓪",5,"쓲쓳쓵쓶쓷쓹쓻쓼쓽쓾씂",9,"씍씎씏씑씒씓씕",6,"씝",10,"씪씫씭씮씯씱",6,"씺씼씾",5,"앆앇앋앏앐앑앒앖앚앛앜앟앢앣앥앦앧앩",6,"앲앶",5,"앾앿얁얂얃얅얆얈얉얊얋얎얐얒얓얔"],["9e41","얖얙얚얛얝얞얟얡",7,"얪",9,"얶"],["9e61","얷얺얿",4,"엋엍엏엒엓엕엖엗엙",6,"엢엤엦엧"],["9e81","엨엩엪엫엯엱엲엳엵엸엹엺엻옂옃옄옉옊옋옍옎옏옑",6,"옚옝",6,"옦옧옩옪옫옯옱옲옶옸옺옼옽옾옿왂왃왅왆왇왉",6,"왒왖",5,"왞왟왡",10,"왭왮왰왲",5,"왺왻왽왾왿욁",6,"욊욌욎",5,"욖욗욙욚욛욝",6,"욦"],["9f41","욨욪",5,"욲욳욵욶욷욻",4,"웂웄웆",5,"웎"],["9f61","웏웑웒웓웕",6,"웞웟웢",5,"웪웫웭웮웯웱웲"],["9f81","웳",4,"웺웻웼웾",5,"윆윇윉윊윋윍",6,"윖윘윚",5,"윢윣윥윦윧윩",6,"윲윴윶윸윹윺윻윾윿읁읂읃읅",4,"읋읎읐읙읚읛읝읞읟읡",6,"읩읪읬",7,"읶읷읹읺읻읿잀잁잂잆잋잌잍잏잒잓잕잙잛",4,"잢잧",4,"잮잯잱잲잳잵잶잷"],["a041","잸잹잺잻잾쟂",5,"쟊쟋쟍쟏쟑",6,"쟙쟚쟛쟜"],["a061","쟞",5,"쟥쟦쟧쟩쟪쟫쟭",13],["a081","쟻",4,"젂젃젅젆젇젉젋",4,"젒젔젗",4,"젞젟젡젢젣젥",6,"젮젰젲",5,"젹젺젻젽젾젿졁",6,"졊졋졎",5,"졕",26,"졲졳졵졶졷졹졻",4,"좂좄좈좉좊좎",5,"좕",7,"좞좠좢좣좤"],["a141","좥좦좧좩",18,"좾좿죀죁"],["a161","죂죃죅죆죇죉죊죋죍",6,"죖죘죚",5,"죢죣죥"],["a181","죦",14,"죶",5,"죾죿줁줂줃줇",4,"줎　、。·‥…¨〃­―∥＼∼‘’“”〔〕〈",9,"±×÷≠≤≥∞∴°′″℃Å￠￡￥♂♀∠⊥⌒∂∇≡≒§※☆★○●◎◇◆□■△▲▽▼→←↑↓↔〓≪≫√∽∝∵∫∬∈∋⊆⊇⊂⊃∪∩∧∨￢"],["a241","줐줒",5,"줙",18],["a261","줭",6,"줵",18],["a281","쥈",7,"쥒쥓쥕쥖쥗쥙",6,"쥢쥤",7,"쥭쥮쥯⇒⇔∀∃´～ˇ˘˝˚˙¸˛¡¿ː∮∑∏¤℉‰◁◀▷▶♤♠♡♥♧♣⊙◈▣◐◑▒▤▥▨▧▦▩♨☏☎☜☞¶†‡↕↗↙↖↘♭♩♪♬㉿㈜№㏇™㏂㏘℡€®"],["a341","쥱쥲쥳쥵",6,"쥽",10,"즊즋즍즎즏"],["a361","즑",6,"즚즜즞",16],["a381","즯",16,"짂짃짅짆짉짋",4,"짒짔짗짘짛！",58,"￦］",32,"￣"],["a441","짞짟짡짣짥짦짨짩짪짫짮짲",5,"짺짻짽짾짿쨁쨂쨃쨄"],["a461","쨅쨆쨇쨊쨎",5,"쨕쨖쨗쨙",12],["a481","쨦쨧쨨쨪",28,"ㄱ",93],["a541","쩇",4,"쩎쩏쩑쩒쩓쩕",6,"쩞쩢",5,"쩩쩪"],["a561","쩫",17,"쩾",5,"쪅쪆"],["a581","쪇",16,"쪙",14,"ⅰ",9],["a5b0","Ⅰ",9],["a5c1","Α",16,"Σ",6],["a5e1","α",16,"σ",6],["a641","쪨",19,"쪾쪿쫁쫂쫃쫅"],["a661","쫆",5,"쫎쫐쫒쫔쫕쫖쫗쫚",5,"쫡",6],["a681","쫨쫩쫪쫫쫭",6,"쫵",18,"쬉쬊─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂┒┑┚┙┖┕┎┍┞┟┡┢┦┧┩┪┭┮┱┲┵┶┹┺┽┾╀╁╃",7],["a741","쬋",4,"쬑쬒쬓쬕쬖쬗쬙",6,"쬢",7],["a761","쬪",22,"쭂쭃쭄"],["a781","쭅쭆쭇쭊쭋쭍쭎쭏쭑",6,"쭚쭛쭜쭞",5,"쭥",7,"㎕㎖㎗ℓ㎘㏄㎣㎤㎥㎦㎙",9,"㏊㎍㎎㎏㏏㎈㎉㏈㎧㎨㎰",9,"㎀",4,"㎺",5,"㎐",4,"Ω㏀㏁㎊㎋㎌㏖㏅㎭㎮㎯㏛㎩㎪㎫㎬㏝㏐㏓㏃㏉㏜㏆"],["a841","쭭",10,"쭺",14],["a861","쮉",18,"쮝",6],["a881","쮤",19,"쮹",11,"ÆÐªĦ"],["a8a6","Ĳ"],["a8a8","ĿŁØŒºÞŦŊ"],["a8b1","㉠",27,"ⓐ",25,"①",14,"½⅓⅔¼¾⅛⅜⅝⅞"],["a941","쯅",14,"쯕",10],["a961","쯠쯡쯢쯣쯥쯦쯨쯪",18],["a981","쯽",14,"찎찏찑찒찓찕",6,"찞찟찠찣찤æđðħıĳĸŀłøœßþŧŋŉ㈀",27,"⒜",25,"⑴",14,"¹²³⁴ⁿ₁₂₃₄"],["aa41","찥찦찪찫찭찯찱",6,"찺찿",4,"챆챇챉챊챋챍챎"],["aa61","챏",4,"챖챚",5,"챡챢챣챥챧챩",6,"챱챲"],["aa81","챳챴챶",29,"ぁ",82],["ab41","첔첕첖첗첚첛첝첞첟첡",6,"첪첮",5,"첶첷첹"],["ab61","첺첻첽",6,"쳆쳈쳊",5,"쳑쳒쳓쳕",5],["ab81","쳛",8,"쳥",6,"쳭쳮쳯쳱",12,"ァ",85],["ac41","쳾쳿촀촂",5,"촊촋촍촎촏촑",6,"촚촜촞촟촠"],["ac61","촡촢촣촥촦촧촩촪촫촭",11,"촺",4],["ac81","촿",28,"쵝쵞쵟А",5,"ЁЖ",25],["acd1","а",5,"ёж",25],["ad41","쵡쵢쵣쵥",6,"쵮쵰쵲",5,"쵹",7],["ad61","춁",6,"춉",10,"춖춗춙춚춛춝춞춟"],["ad81","춠춡춢춣춦춨춪",5,"춱",18,"췅"],["ae41","췆",5,"췍췎췏췑",16],["ae61","췢",5,"췩췪췫췭췮췯췱",6,"췺췼췾",4],["ae81","츃츅츆츇츉츊츋츍",6,"츕츖츗츘츚",5,"츢츣츥츦츧츩츪츫"],["af41","츬츭츮츯츲츴츶",19],["af61","칊",13,"칚칛칝칞칢",5,"칪칬"],["af81","칮",5,"칶칷칹칺칻칽",6,"캆캈캊",5,"캒캓캕캖캗캙"],["b041","캚",5,"캢캦",5,"캮",12],["b061","캻",5,"컂",19],["b081","컖",13,"컦컧컩컪컭",6,"컶컺",5,"가각간갇갈갉갊감",7,"같",4,"갠갤갬갭갯갰갱갸갹갼걀걋걍걔걘걜거걱건걷걸걺검겁것겄겅겆겉겊겋게겐겔겜겝겟겠겡겨격겪견겯결겸겹겻겼경곁계곈곌곕곗고곡곤곧골곪곬곯곰곱곳공곶과곽관괄괆"],["b141","켂켃켅켆켇켉",6,"켒켔켖",5,"켝켞켟켡켢켣"],["b161","켥",6,"켮켲",5,"켹",11],["b181","콅",14,"콖콗콙콚콛콝",6,"콦콨콪콫콬괌괍괏광괘괜괠괩괬괭괴괵괸괼굄굅굇굉교굔굘굡굣구국군굳굴굵굶굻굼굽굿궁궂궈궉권궐궜궝궤궷귀귁귄귈귐귑귓규균귤그극근귿글긁금급긋긍긔기긱긴긷길긺김깁깃깅깆깊까깍깎깐깔깖깜깝깟깠깡깥깨깩깬깰깸"],["b241","콭콮콯콲콳콵콶콷콹",6,"쾁쾂쾃쾄쾆",5,"쾍"],["b261","쾎",18,"쾢",5,"쾩"],["b281","쾪",5,"쾱",18,"쿅",6,"깹깻깼깽꺄꺅꺌꺼꺽꺾껀껄껌껍껏껐껑께껙껜껨껫껭껴껸껼꼇꼈꼍꼐꼬꼭꼰꼲꼴꼼꼽꼿꽁꽂꽃꽈꽉꽐꽜꽝꽤꽥꽹꾀꾄꾈꾐꾑꾕꾜꾸꾹꾼꿀꿇꿈꿉꿋꿍꿎꿔꿜꿨꿩꿰꿱꿴꿸뀀뀁뀄뀌뀐뀔뀜뀝뀨끄끅끈끊끌끎끓끔끕끗끙"],["b341","쿌",19,"쿢쿣쿥쿦쿧쿩"],["b361","쿪",5,"쿲쿴쿶",5,"쿽쿾쿿퀁퀂퀃퀅",5],["b381","퀋",5,"퀒",5,"퀙",19,"끝끼끽낀낄낌낍낏낑나낙낚난낟날낡낢남납낫",4,"낱낳내낵낸낼냄냅냇냈냉냐냑냔냘냠냥너넉넋넌널넒넓넘넙넛넜넝넣네넥넨넬넴넵넷넸넹녀녁년녈념녑녔녕녘녜녠노녹논놀놂놈놉놋농높놓놔놘놜놨뇌뇐뇔뇜뇝"],["b441","퀮",5,"퀶퀷퀹퀺퀻퀽",6,"큆큈큊",5],["b461","큑큒큓큕큖큗큙",6,"큡",10,"큮큯"],["b481","큱큲큳큵",6,"큾큿킀킂",18,"뇟뇨뇩뇬뇰뇹뇻뇽누눅눈눋눌눔눕눗눙눠눴눼뉘뉜뉠뉨뉩뉴뉵뉼늄늅늉느늑는늘늙늚늠늡늣능늦늪늬늰늴니닉닌닐닒님닙닛닝닢다닥닦단닫",4,"닳담답닷",4,"닿대댁댄댈댐댑댓댔댕댜더덕덖던덛덜덞덟덤덥"],["b541","킕",14,"킦킧킩킪킫킭",5],["b561","킳킶킸킺",5,"탂탃탅탆탇탊",5,"탒탖",4],["b581","탛탞탟탡탢탣탥",6,"탮탲",5,"탹",11,"덧덩덫덮데덱덴델뎀뎁뎃뎄뎅뎌뎐뎔뎠뎡뎨뎬도독돈돋돌돎돐돔돕돗동돛돝돠돤돨돼됐되된될됨됩됫됴두둑둔둘둠둡둣둥둬뒀뒈뒝뒤뒨뒬뒵뒷뒹듀듄듈듐듕드득든듣들듦듬듭듯등듸디딕딘딛딜딤딥딧딨딩딪따딱딴딸"],["b641","턅",7,"턎",17],["b661","턠",15,"턲턳턵턶턷턹턻턼턽턾"],["b681","턿텂텆",5,"텎텏텑텒텓텕",6,"텞텠텢",5,"텩텪텫텭땀땁땃땄땅땋때땍땐땔땜땝땟땠땡떠떡떤떨떪떫떰떱떳떴떵떻떼떽뗀뗄뗌뗍뗏뗐뗑뗘뗬또똑똔똘똥똬똴뙈뙤뙨뚜뚝뚠뚤뚫뚬뚱뛔뛰뛴뛸뜀뜁뜅뜨뜩뜬뜯뜰뜸뜹뜻띄띈띌띔띕띠띤띨띰띱띳띵라락란랄람랍랏랐랑랒랖랗"],["b741","텮",13,"텽",6,"톅톆톇톉톊"],["b761","톋",20,"톢톣톥톦톧"],["b781","톩",6,"톲톴톶톷톸톹톻톽톾톿퇁",14,"래랙랜랠램랩랫랬랭랴략랸럇량러럭런럴럼럽럿렀렁렇레렉렌렐렘렙렛렝려력련렬렴렵렷렸령례롄롑롓로록론롤롬롭롯롱롸롼뢍뢨뢰뢴뢸룀룁룃룅료룐룔룝룟룡루룩룬룰룸룹룻룽뤄뤘뤠뤼뤽륀륄륌륏륑류륙륜률륨륩"],["b841","퇐",7,"퇙",17],["b861","퇫",8,"퇵퇶퇷퇹",13],["b881","툈툊",5,"툑",24,"륫륭르륵른를름릅릇릉릊릍릎리릭린릴림립릿링마막만많",4,"맘맙맛망맞맡맣매맥맨맬맴맵맷맸맹맺먀먁먈먕머먹먼멀멂멈멉멋멍멎멓메멕멘멜멤멥멧멨멩며멱면멸몃몄명몇몌모목몫몬몰몲몸몹못몽뫄뫈뫘뫙뫼"],["b941","툪툫툮툯툱툲툳툵",6,"툾퉀퉂",5,"퉉퉊퉋퉌"],["b961","퉍",14,"퉝",6,"퉥퉦퉧퉨"],["b981","퉩",22,"튂튃튅튆튇튉튊튋튌묀묄묍묏묑묘묜묠묩묫무묵묶문묻물묽묾뭄뭅뭇뭉뭍뭏뭐뭔뭘뭡뭣뭬뮈뮌뮐뮤뮨뮬뮴뮷므믄믈믐믓미믹민믿밀밂밈밉밋밌밍및밑바",4,"받",4,"밤밥밧방밭배백밴밸뱀뱁뱃뱄뱅뱉뱌뱍뱐뱝버벅번벋벌벎범법벗"],["ba41","튍튎튏튒튓튔튖",5,"튝튞튟튡튢튣튥",6,"튭"],["ba61","튮튯튰튲",5,"튺튻튽튾틁틃",4,"틊틌",5],["ba81","틒틓틕틖틗틙틚틛틝",6,"틦",9,"틲틳틵틶틷틹틺벙벚베벡벤벧벨벰벱벳벴벵벼벽변별볍볏볐병볕볘볜보복볶본볼봄봅봇봉봐봔봤봬뵀뵈뵉뵌뵐뵘뵙뵤뵨부북분붇불붉붊붐붑붓붕붙붚붜붤붰붸뷔뷕뷘뷜뷩뷰뷴뷸븀븃븅브븍븐블븜븝븟비빅빈빌빎빔빕빗빙빚빛빠빡빤"],["bb41","틻",4,"팂팄팆",5,"팏팑팒팓팕팗",4,"팞팢팣"],["bb61","팤팦팧팪팫팭팮팯팱",6,"팺팾",5,"퍆퍇퍈퍉"],["bb81","퍊",31,"빨빪빰빱빳빴빵빻빼빽뺀뺄뺌뺍뺏뺐뺑뺘뺙뺨뻐뻑뻔뻗뻘뻠뻣뻤뻥뻬뼁뼈뼉뼘뼙뼛뼜뼝뽀뽁뽄뽈뽐뽑뽕뾔뾰뿅뿌뿍뿐뿔뿜뿟뿡쀼쁑쁘쁜쁠쁨쁩삐삑삔삘삠삡삣삥사삭삯산삳살삵삶삼삽삿샀상샅새색샌샐샘샙샛샜생샤"],["bc41","퍪",17,"퍾퍿펁펂펃펅펆펇"],["bc61","펈펉펊펋펎펒",5,"펚펛펝펞펟펡",6,"펪펬펮"],["bc81","펯",4,"펵펶펷펹펺펻펽",6,"폆폇폊",5,"폑",5,"샥샨샬샴샵샷샹섀섄섈섐섕서",4,"섣설섦섧섬섭섯섰성섶세섹센셀셈셉셋셌셍셔셕션셜셤셥셧셨셩셰셴셸솅소속솎손솔솖솜솝솟송솥솨솩솬솰솽쇄쇈쇌쇔쇗쇘쇠쇤쇨쇰쇱쇳쇼쇽숀숄숌숍숏숑수숙순숟술숨숩숫숭"],["bd41","폗폙",7,"폢폤",7,"폮폯폱폲폳폵폶폷"],["bd61","폸폹폺폻폾퐀퐂",5,"퐉",13],["bd81","퐗",5,"퐞",25,"숯숱숲숴쉈쉐쉑쉔쉘쉠쉥쉬쉭쉰쉴쉼쉽쉿슁슈슉슐슘슛슝스슥슨슬슭슴습슷승시식신싣실싫심십싯싱싶싸싹싻싼쌀쌈쌉쌌쌍쌓쌔쌕쌘쌜쌤쌥쌨쌩썅써썩썬썰썲썸썹썼썽쎄쎈쎌쏀쏘쏙쏜쏟쏠쏢쏨쏩쏭쏴쏵쏸쐈쐐쐤쐬쐰"],["be41","퐸",7,"푁푂푃푅",14],["be61","푔",7,"푝푞푟푡푢푣푥",7,"푮푰푱푲"],["be81","푳",4,"푺푻푽푾풁풃",4,"풊풌풎",5,"풕",8,"쐴쐼쐽쑈쑤쑥쑨쑬쑴쑵쑹쒀쒔쒜쒸쒼쓩쓰쓱쓴쓸쓺쓿씀씁씌씐씔씜씨씩씬씰씸씹씻씽아악안앉않알앍앎앓암압앗았앙앝앞애액앤앨앰앱앳앴앵야약얀얄얇얌얍얏양얕얗얘얜얠얩어억언얹얻얼얽얾엄",6,"엌엎"],["bf41","풞",10,"풪",14],["bf61","풹",18,"퓍퓎퓏퓑퓒퓓퓕"],["bf81","퓖",5,"퓝퓞퓠",7,"퓩퓪퓫퓭퓮퓯퓱",6,"퓹퓺퓼에엑엔엘엠엡엣엥여역엮연열엶엷염",5,"옅옆옇예옌옐옘옙옛옜오옥온올옭옮옰옳옴옵옷옹옻와왁완왈왐왑왓왔왕왜왝왠왬왯왱외왹왼욀욈욉욋욍요욕욘욜욤욥욧용우욱운울욹욺움웁웃웅워웍원월웜웝웠웡웨"],["c041","퓾",5,"픅픆픇픉픊픋픍",6,"픖픘",5],["c061","픞",25],["c081","픸픹픺픻픾픿핁핂핃핅",6,"핎핐핒",5,"핚핛핝핞핟핡핢핣웩웬웰웸웹웽위윅윈윌윔윕윗윙유육윤율윰윱윳융윷으윽은을읊음읍읏응",7,"읜읠읨읫이익인일읽읾잃임입잇있잉잊잎자작잔잖잗잘잚잠잡잣잤장잦재잭잰잴잼잽잿쟀쟁쟈쟉쟌쟎쟐쟘쟝쟤쟨쟬저적전절젊"],["c141","핤핦핧핪핬핮",5,"핶핷핹핺핻핽",6,"햆햊햋"],["c161","햌햍햎햏햑",19,"햦햧"],["c181","햨",31,"점접젓정젖제젝젠젤젬젭젯젱져젼졀졈졉졌졍졔조족존졸졺좀좁좃종좆좇좋좌좍좔좝좟좡좨좼좽죄죈죌죔죕죗죙죠죡죤죵주죽준줄줅줆줌줍줏중줘줬줴쥐쥑쥔쥘쥠쥡쥣쥬쥰쥴쥼즈즉즌즐즘즙즛증지직진짇질짊짐집짓"],["c241","헊헋헍헎헏헑헓",4,"헚헜헞",5,"헦헧헩헪헫헭헮"],["c261","헯",4,"헶헸헺",5,"혂혃혅혆혇혉",6,"혒"],["c281","혖",5,"혝혞혟혡혢혣혥",7,"혮",9,"혺혻징짖짙짚짜짝짠짢짤짧짬짭짯짰짱째짹짼쨀쨈쨉쨋쨌쨍쨔쨘쨩쩌쩍쩐쩔쩜쩝쩟쩠쩡쩨쩽쪄쪘쪼쪽쫀쫄쫌쫍쫏쫑쫓쫘쫙쫠쫬쫴쬈쬐쬔쬘쬠쬡쭁쭈쭉쭌쭐쭘쭙쭝쭤쭸쭹쮜쮸쯔쯤쯧쯩찌찍찐찔찜찝찡찢찧차착찬찮찰참찹찻"],["c341","혽혾혿홁홂홃홄홆홇홊홌홎홏홐홒홓홖홗홙홚홛홝",4],["c361","홢",4,"홨홪",5,"홲홳홵",11],["c381","횁횂횄횆",5,"횎횏횑횒횓횕",7,"횞횠횢",5,"횩횪찼창찾채책챈챌챔챕챗챘챙챠챤챦챨챰챵처척천철첨첩첫첬청체첵첸첼쳄쳅쳇쳉쳐쳔쳤쳬쳰촁초촉촌촐촘촙촛총촤촨촬촹최쵠쵤쵬쵭쵯쵱쵸춈추축춘출춤춥춧충춰췄췌췐취췬췰췸췹췻췽츄츈츌츔츙츠측츤츨츰츱츳층"],["c441","횫횭횮횯횱",7,"횺횼",7,"훆훇훉훊훋"],["c461","훍훎훏훐훒훓훕훖훘훚",5,"훡훢훣훥훦훧훩",4],["c481","훮훯훱훲훳훴훶",5,"훾훿휁휂휃휅",11,"휒휓휔치칙친칟칠칡침칩칫칭카칵칸칼캄캅캇캉캐캑캔캘캠캡캣캤캥캬캭컁커컥컨컫컬컴컵컷컸컹케켁켄켈켐켑켓켕켜켠켤켬켭켯켰켱켸코콕콘콜콤콥콧콩콰콱콴콸쾀쾅쾌쾡쾨쾰쿄쿠쿡쿤쿨쿰쿱쿳쿵쿼퀀퀄퀑퀘퀭퀴퀵퀸퀼"],["c541","휕휖휗휚휛휝휞휟휡",6,"휪휬휮",5,"휶휷휹"],["c561","휺휻휽",6,"흅흆흈흊",5,"흒흓흕흚",4],["c581","흟흢흤흦흧흨흪흫흭흮흯흱흲흳흵",6,"흾흿힀힂",5,"힊힋큄큅큇큉큐큔큘큠크큭큰클큼큽킁키킥킨킬킴킵킷킹타탁탄탈탉탐탑탓탔탕태택탠탤탬탭탯탰탱탸턍터턱턴털턺텀텁텃텄텅테텍텐텔템텝텟텡텨텬텼톄톈토톡톤톨톰톱톳통톺톼퇀퇘퇴퇸툇툉툐투툭툰툴툼툽툿퉁퉈퉜"],["c641","힍힎힏힑",6,"힚힜힞",5],["c6a1","퉤튀튁튄튈튐튑튕튜튠튤튬튱트특튼튿틀틂틈틉틋틔틘틜틤틥티틱틴틸팀팁팃팅파팍팎판팔팖팜팝팟팠팡팥패팩팬팰팸팹팻팼팽퍄퍅퍼퍽펀펄펌펍펏펐펑페펙펜펠펨펩펫펭펴편펼폄폅폈평폐폘폡폣포폭폰폴폼폽폿퐁"],["c7a1","퐈퐝푀푄표푠푤푭푯푸푹푼푿풀풂품풉풋풍풔풩퓌퓐퓔퓜퓟퓨퓬퓰퓸퓻퓽프픈플픔픕픗피픽핀필핌핍핏핑하학한할핥함합핫항해핵핸핼햄햅햇했행햐향허헉헌헐헒험헙헛헝헤헥헨헬헴헵헷헹혀혁현혈혐협혓혔형혜혠"],["c8a1","혤혭호혹혼홀홅홈홉홋홍홑화확환활홧황홰홱홴횃횅회획횐횔횝횟횡효횬횰횹횻후훅훈훌훑훔훗훙훠훤훨훰훵훼훽휀휄휑휘휙휜휠휨휩휫휭휴휵휸휼흄흇흉흐흑흔흖흗흘흙흠흡흣흥흩희흰흴흼흽힁히힉힌힐힘힙힛힝"],["caa1","伽佳假價加可呵哥嘉嫁家暇架枷柯歌珂痂稼苛茄街袈訶賈跏軻迦駕刻却各恪慤殼珏脚覺角閣侃刊墾奸姦干幹懇揀杆柬桿澗癎看磵稈竿簡肝艮艱諫間乫喝曷渴碣竭葛褐蝎鞨勘坎堪嵌感憾戡敢柑橄減甘疳監瞰紺邯鑑鑒龕"],["cba1","匣岬甲胛鉀閘剛堈姜岡崗康强彊慷江畺疆糠絳綱羌腔舡薑襁講鋼降鱇介价個凱塏愷愾慨改槪漑疥皆盖箇芥蓋豈鎧開喀客坑更粳羹醵倨去居巨拒据據擧渠炬祛距踞車遽鉅鋸乾件健巾建愆楗腱虔蹇鍵騫乞傑杰桀儉劍劒檢"],["cca1","瞼鈐黔劫怯迲偈憩揭擊格檄激膈覡隔堅牽犬甄絹繭肩見譴遣鵑抉決潔結缺訣兼慊箝謙鉗鎌京俓倞傾儆勁勍卿坰境庚徑慶憬擎敬景暻更梗涇炅烱璟璥瓊痙硬磬竟競絅經耕耿脛莖警輕逕鏡頃頸驚鯨係啓堺契季屆悸戒桂械"],["cda1","棨溪界癸磎稽系繫繼計誡谿階鷄古叩告呱固姑孤尻庫拷攷故敲暠枯槁沽痼皐睾稿羔考股膏苦苽菰藁蠱袴誥賈辜錮雇顧高鼓哭斛曲梏穀谷鵠困坤崑昆梱棍滾琨袞鯤汨滑骨供公共功孔工恐恭拱控攻珙空蚣貢鞏串寡戈果瓜"],["cea1","科菓誇課跨過鍋顆廓槨藿郭串冠官寬慣棺款灌琯瓘管罐菅觀貫關館刮恝括适侊光匡壙廣曠洸炚狂珖筐胱鑛卦掛罫乖傀塊壞怪愧拐槐魁宏紘肱轟交僑咬喬嬌嶠巧攪敎校橋狡皎矯絞翹膠蕎蛟較轎郊餃驕鮫丘久九仇俱具勾"],["cfa1","區口句咎嘔坵垢寇嶇廐懼拘救枸柩構歐毆毬求溝灸狗玖球瞿矩究絿耉臼舅舊苟衢謳購軀逑邱鉤銶駒驅鳩鷗龜國局菊鞠鞫麴君窘群裙軍郡堀屈掘窟宮弓穹窮芎躬倦券勸卷圈拳捲權淃眷厥獗蕨蹶闕机櫃潰詭軌饋句晷歸貴"],["d0a1","鬼龜叫圭奎揆槻珪硅窺竅糾葵規赳逵閨勻均畇筠菌鈞龜橘克剋劇戟棘極隙僅劤勤懃斤根槿瑾筋芹菫覲謹近饉契今妗擒昑檎琴禁禽芩衾衿襟金錦伋及急扱汲級給亘兢矜肯企伎其冀嗜器圻基埼夔奇妓寄岐崎己幾忌技旗旣"],["d1a1","朞期杞棋棄機欺氣汽沂淇玘琦琪璂璣畸畿碁磯祁祇祈祺箕紀綺羈耆耭肌記譏豈起錡錤飢饑騎騏驥麒緊佶吉拮桔金喫儺喇奈娜懦懶拏拿癩",5,"那樂",4,"諾酪駱亂卵暖欄煖爛蘭難鸞捏捺南嵐枏楠湳濫男藍襤拉"],["d2a1","納臘蠟衲囊娘廊",4,"乃來內奈柰耐冷女年撚秊念恬拈捻寧寗努勞奴弩怒擄櫓爐瑙盧",5,"駑魯",10,"濃籠聾膿農惱牢磊腦賂雷尿壘",7,"嫩訥杻紐勒",5,"能菱陵尼泥匿溺多茶"],["d3a1","丹亶但單團壇彖斷旦檀段湍短端簞緞蛋袒鄲鍛撻澾獺疸達啖坍憺擔曇淡湛潭澹痰聃膽蕁覃談譚錟沓畓答踏遝唐堂塘幢戇撞棠當糖螳黨代垈坮大對岱帶待戴擡玳臺袋貸隊黛宅德悳倒刀到圖堵塗導屠島嶋度徒悼挑掉搗桃"],["d4a1","棹櫂淘渡滔濤燾盜睹禱稻萄覩賭跳蹈逃途道都鍍陶韜毒瀆牘犢獨督禿篤纛讀墩惇敦旽暾沌焞燉豚頓乭突仝冬凍動同憧東桐棟洞潼疼瞳童胴董銅兜斗杜枓痘竇荳讀豆逗頭屯臀芚遁遯鈍得嶝橙燈登等藤謄鄧騰喇懶拏癩羅"],["d5a1","蘿螺裸邏樂洛烙珞絡落諾酪駱丹亂卵欄欒瀾爛蘭鸞剌辣嵐擥攬欖濫籃纜藍襤覽拉臘蠟廊朗浪狼琅瑯螂郞來崍徠萊冷掠略亮倆兩凉梁樑粮粱糧良諒輛量侶儷勵呂廬慮戾旅櫚濾礪藜蠣閭驢驪麗黎力曆歷瀝礫轢靂憐戀攣漣"],["d6a1","煉璉練聯蓮輦連鍊冽列劣洌烈裂廉斂殮濂簾獵令伶囹寧岺嶺怜玲笭羚翎聆逞鈴零靈領齡例澧禮醴隷勞怒撈擄櫓潞瀘爐盧老蘆虜路輅露魯鷺鹵碌祿綠菉錄鹿麓論壟弄朧瀧瓏籠聾儡瀨牢磊賂賚賴雷了僚寮廖料燎療瞭聊蓼"],["d7a1","遼鬧龍壘婁屢樓淚漏瘻累縷蔞褸鏤陋劉旒柳榴流溜瀏琉瑠留瘤硫謬類六戮陸侖倫崙淪綸輪律慄栗率隆勒肋凜凌楞稜綾菱陵俚利厘吏唎履悧李梨浬犁狸理璃異痢籬罹羸莉裏裡里釐離鯉吝潾燐璘藺躪隣鱗麟林淋琳臨霖砬"],["d8a1","立笠粒摩瑪痲碼磨馬魔麻寞幕漠膜莫邈万卍娩巒彎慢挽晩曼滿漫灣瞞萬蔓蠻輓饅鰻唜抹末沫茉襪靺亡妄忘忙望網罔芒茫莽輞邙埋妹媒寐昧枚梅每煤罵買賣邁魅脈貊陌驀麥孟氓猛盲盟萌冪覓免冕勉棉沔眄眠綿緬面麵滅"],["d9a1","蔑冥名命明暝椧溟皿瞑茗蓂螟酩銘鳴袂侮冒募姆帽慕摸摹暮某模母毛牟牡瑁眸矛耗芼茅謀謨貌木沐牧目睦穆鶩歿沒夢朦蒙卯墓妙廟描昴杳渺猫竗苗錨務巫憮懋戊拇撫无楙武毋無珷畝繆舞茂蕪誣貿霧鵡墨默們刎吻問文"],["daa1","汶紊紋聞蚊門雯勿沕物味媚尾嵋彌微未梶楣渼湄眉米美薇謎迷靡黴岷悶愍憫敏旻旼民泯玟珉緡閔密蜜謐剝博拍搏撲朴樸泊珀璞箔粕縛膊舶薄迫雹駁伴半反叛拌搬攀斑槃泮潘班畔瘢盤盼磐磻礬絆般蟠返頒飯勃拔撥渤潑"],["dba1","發跋醱鉢髮魃倣傍坊妨尨幇彷房放方旁昉枋榜滂磅紡肪膀舫芳蒡蚌訪謗邦防龐倍俳北培徘拜排杯湃焙盃背胚裴裵褙賠輩配陪伯佰帛柏栢白百魄幡樊煩燔番磻繁蕃藩飜伐筏罰閥凡帆梵氾汎泛犯範范法琺僻劈壁擘檗璧癖"],["dca1","碧蘗闢霹便卞弁變辨辯邊別瞥鱉鼈丙倂兵屛幷昞昺柄棅炳甁病秉竝輧餠騈保堡報寶普步洑湺潽珤甫菩補褓譜輔伏僕匐卜宓復服福腹茯蔔複覆輹輻馥鰒本乶俸奉封峯峰捧棒烽熢琫縫蓬蜂逢鋒鳳不付俯傅剖副否咐埠夫婦"],["dda1","孚孵富府復扶敷斧浮溥父符簿缶腐腑膚艀芙莩訃負賦賻赴趺部釜阜附駙鳧北分吩噴墳奔奮忿憤扮昐汾焚盆粉糞紛芬賁雰不佛弗彿拂崩朋棚硼繃鵬丕備匕匪卑妃婢庇悲憊扉批斐枇榧比毖毗毘沸泌琵痺砒碑秕秘粃緋翡肥"],["dea1","脾臂菲蜚裨誹譬費鄙非飛鼻嚬嬪彬斌檳殯浜濱瀕牝玭貧賓頻憑氷聘騁乍事些仕伺似使俟僿史司唆嗣四士奢娑寫寺射巳師徙思捨斜斯柶査梭死沙泗渣瀉獅砂社祀祠私篩紗絲肆舍莎蓑蛇裟詐詞謝賜赦辭邪飼駟麝削數朔索"],["dfa1","傘刪山散汕珊産疝算蒜酸霰乷撒殺煞薩三參杉森渗芟蔘衫揷澁鈒颯上傷像償商喪嘗孀尙峠常床庠廂想桑橡湘爽牀狀相祥箱翔裳觴詳象賞霜塞璽賽嗇塞穡索色牲生甥省笙墅壻嶼序庶徐恕抒捿敍暑曙書栖棲犀瑞筮絮緖署"],["e0a1","胥舒薯西誓逝鋤黍鼠夕奭席惜昔晳析汐淅潟石碩蓆釋錫仙僊先善嬋宣扇敾旋渲煽琁瑄璇璿癬禪線繕羨腺膳船蘚蟬詵跣選銑鐥饍鮮卨屑楔泄洩渫舌薛褻設說雪齧剡暹殲纖蟾贍閃陝攝涉燮葉城姓宬性惺成星晟猩珹盛省筬"],["e1a1","聖聲腥誠醒世勢歲洗稅笹細說貰召嘯塑宵小少巢所掃搔昭梳沼消溯瀟炤燒甦疏疎瘙笑篠簫素紹蔬蕭蘇訴逍遡邵銷韶騷俗屬束涑粟續謖贖速孫巽損蓀遜飡率宋悚松淞訟誦送頌刷殺灑碎鎖衰釗修受嗽囚垂壽嫂守岫峀帥愁"],["e2a1","戍手授搜收數樹殊水洙漱燧狩獸琇璲瘦睡秀穗竪粹綏綬繡羞脩茱蒐蓚藪袖誰讐輸遂邃酬銖銹隋隧隨雖需須首髓鬚叔塾夙孰宿淑潚熟琡璹肅菽巡徇循恂旬栒楯橓殉洵淳珣盾瞬筍純脣舜荀蓴蕣詢諄醇錞順馴戌術述鉥崇崧"],["e3a1","嵩瑟膝蝨濕拾習褶襲丞乘僧勝升承昇繩蠅陞侍匙嘶始媤尸屎屍市弑恃施是時枾柴猜矢示翅蒔蓍視試詩諡豕豺埴寔式息拭植殖湜熄篒蝕識軾食飾伸侁信呻娠宸愼新晨燼申神紳腎臣莘薪藎蜃訊身辛辰迅失室實悉審尋心沁"],["e4a1","沈深瀋甚芯諶什十拾雙氏亞俄兒啞娥峨我牙芽莪蛾衙訝阿雅餓鴉鵝堊岳嶽幄惡愕握樂渥鄂鍔顎鰐齷安岸按晏案眼雁鞍顔鮟斡謁軋閼唵岩巖庵暗癌菴闇壓押狎鴨仰央怏昻殃秧鴦厓哀埃崖愛曖涯碍艾隘靄厄扼掖液縊腋額"],["e5a1","櫻罌鶯鸚也倻冶夜惹揶椰爺耶若野弱掠略約若葯蒻藥躍亮佯兩凉壤孃恙揚攘敭暘梁楊樣洋瀁煬痒瘍禳穰糧羊良襄諒讓釀陽量養圄御於漁瘀禦語馭魚齬億憶抑檍臆偃堰彦焉言諺孼蘖俺儼嚴奄掩淹嶪業円予余勵呂女如廬"],["e6a1","旅歟汝濾璵礖礪與艅茹輿轝閭餘驪麗黎亦力域役易曆歷疫繹譯轢逆驛嚥堧姸娟宴年延憐戀捐挻撚椽沇沿涎涓淵演漣烟然煙煉燃燕璉硏硯秊筵緣練縯聯衍軟輦蓮連鉛鍊鳶列劣咽悅涅烈熱裂說閱厭廉念捻染殮炎焰琰艶苒"],["e7a1","簾閻髥鹽曄獵燁葉令囹塋寧嶺嶸影怜映暎楹榮永泳渶潁濚瀛瀯煐營獰玲瑛瑩瓔盈穎纓羚聆英詠迎鈴鍈零霙靈領乂倪例刈叡曳汭濊猊睿穢芮藝蘂禮裔詣譽豫醴銳隸霓預五伍俉傲午吾吳嗚塢墺奧娛寤悟惡懊敖旿晤梧汚澳"],["e8a1","烏熬獒筽蜈誤鰲鼇屋沃獄玉鈺溫瑥瘟穩縕蘊兀壅擁瓮甕癰翁邕雍饔渦瓦窩窪臥蛙蝸訛婉完宛梡椀浣玩琓琬碗緩翫脘腕莞豌阮頑曰往旺枉汪王倭娃歪矮外嵬巍猥畏了僚僥凹堯夭妖姚寥寮尿嶢拗搖撓擾料曜樂橈燎燿瑤療"],["e9a1","窈窯繇繞耀腰蓼蟯要謠遙遼邀饒慾欲浴縟褥辱俑傭冗勇埇墉容庸慂榕涌湧溶熔瑢用甬聳茸蓉踊鎔鏞龍于佑偶優又友右宇寓尤愚憂旴牛玗瑀盂祐禑禹紆羽芋藕虞迂遇郵釪隅雨雩勖彧旭昱栯煜稶郁頊云暈橒殞澐熉耘芸蕓"],["eaa1","運隕雲韻蔚鬱亐熊雄元原員圓園垣媛嫄寃怨愿援沅洹湲源爰猿瑗苑袁轅遠阮院願鴛月越鉞位偉僞危圍委威尉慰暐渭爲瑋緯胃萎葦蔿蝟衛褘謂違韋魏乳侑儒兪劉唯喩孺宥幼幽庾悠惟愈愉揄攸有杻柔柚柳楡楢油洧流游溜"],["eba1","濡猶猷琉瑜由留癒硫紐維臾萸裕誘諛諭踰蹂遊逾遺酉釉鍮類六堉戮毓肉育陸倫允奫尹崙淪潤玧胤贇輪鈗閏律慄栗率聿戎瀜絨融隆垠恩慇殷誾銀隱乙吟淫蔭陰音飮揖泣邑凝應膺鷹依倚儀宜意懿擬椅毅疑矣義艤薏蟻衣誼"],["eca1","議醫二以伊利吏夷姨履已弛彛怡易李梨泥爾珥理異痍痢移罹而耳肄苡荑裏裡貽貳邇里離飴餌匿溺瀷益翊翌翼謚人仁刃印吝咽因姻寅引忍湮燐璘絪茵藺蚓認隣靭靷鱗麟一佚佾壹日溢逸鎰馹任壬妊姙恁林淋稔臨荏賃入卄"],["eda1","立笠粒仍剩孕芿仔刺咨姉姿子字孜恣慈滋炙煮玆瓷疵磁紫者自茨蔗藉諮資雌作勺嚼斫昨灼炸爵綽芍酌雀鵲孱棧殘潺盞岑暫潛箴簪蠶雜丈仗匠場墻壯奬將帳庄張掌暲杖樟檣欌漿牆狀獐璋章粧腸臟臧莊葬蔣薔藏裝贓醬長"],["eea1","障再哉在宰才材栽梓渽滓災縡裁財載齋齎爭箏諍錚佇低儲咀姐底抵杵楮樗沮渚狙猪疽箸紵苧菹著藷詛貯躇這邸雎齟勣吊嫡寂摘敵滴狄炙的積笛籍績翟荻謫賊赤跡蹟迪迹適鏑佃佺傳全典前剪塡塼奠專展廛悛戰栓殿氈澱"],["efa1","煎琠田甸畑癲筌箋箭篆纏詮輾轉鈿銓錢鐫電顚顫餞切截折浙癤竊節絶占岾店漸点粘霑鮎點接摺蝶丁井亭停偵呈姃定幀庭廷征情挺政整旌晶晸柾楨檉正汀淀淨渟湞瀞炡玎珽町睛碇禎程穽精綎艇訂諪貞鄭酊釘鉦鋌錠霆靖"],["f0a1","靜頂鼎制劑啼堤帝弟悌提梯濟祭第臍薺製諸蹄醍除際霽題齊俎兆凋助嘲弔彫措操早晁曺曹朝條棗槽漕潮照燥爪璪眺祖祚租稠窕粗糟組繰肇藻蚤詔調趙躁造遭釣阻雕鳥族簇足鏃存尊卒拙猝倧宗從悰慫棕淙琮種終綜縱腫"],["f1a1","踪踵鍾鐘佐坐左座挫罪主住侏做姝胄呪周嗾奏宙州廚晝朱柱株注洲湊澍炷珠疇籌紂紬綢舟蛛註誅走躊輳週酎酒鑄駐竹粥俊儁准埈寯峻晙樽浚準濬焌畯竣蠢逡遵雋駿茁中仲衆重卽櫛楫汁葺增憎曾拯烝甑症繒蒸證贈之只"],["f2a1","咫地址志持指摯支旨智枝枳止池沚漬知砥祉祗紙肢脂至芝芷蜘誌識贄趾遲直稙稷織職唇嗔塵振搢晉晋桭榛殄津溱珍瑨璡畛疹盡眞瞋秦縉縝臻蔯袗診賑軫辰進鎭陣陳震侄叱姪嫉帙桎瓆疾秩窒膣蛭質跌迭斟朕什執潗緝輯"],["f3a1","鏶集徵懲澄且侘借叉嗟嵯差次此磋箚茶蹉車遮捉搾着窄錯鑿齪撰澯燦璨瓚竄簒纂粲纘讚贊鑽餐饌刹察擦札紮僭參塹慘慙懺斬站讒讖倉倡創唱娼廠彰愴敞昌昶暢槍滄漲猖瘡窓脹艙菖蒼債埰寀寨彩採砦綵菜蔡采釵冊柵策"],["f4a1","責凄妻悽處倜刺剔尺慽戚拓擲斥滌瘠脊蹠陟隻仟千喘天川擅泉淺玔穿舛薦賤踐遷釧闡阡韆凸哲喆徹撤澈綴輟轍鐵僉尖沾添甛瞻簽籤詹諂堞妾帖捷牒疊睫諜貼輒廳晴淸聽菁請靑鯖切剃替涕滯締諦逮遞體初剿哨憔抄招梢"],["f5a1","椒楚樵炒焦硝礁礎秒稍肖艸苕草蕉貂超酢醋醮促囑燭矗蜀觸寸忖村邨叢塚寵悤憁摠總聰蔥銃撮催崔最墜抽推椎楸樞湫皺秋芻萩諏趨追鄒酋醜錐錘鎚雛騶鰍丑畜祝竺筑築縮蓄蹙蹴軸逐春椿瑃出朮黜充忠沖蟲衝衷悴膵萃"],["f6a1","贅取吹嘴娶就炊翠聚脆臭趣醉驟鷲側仄厠惻測層侈値嗤峙幟恥梔治淄熾痔痴癡稚穉緇緻置致蚩輜雉馳齒則勅飭親七柒漆侵寢枕沈浸琛砧針鍼蟄秤稱快他咤唾墮妥惰打拖朶楕舵陀馱駝倬卓啄坼度托拓擢晫柝濁濯琢琸託"],["f7a1","鐸呑嘆坦彈憚歎灘炭綻誕奪脫探眈耽貪塔搭榻宕帑湯糖蕩兌台太怠態殆汰泰笞胎苔跆邰颱宅擇澤撑攄兎吐土討慟桶洞痛筒統通堆槌腿褪退頹偸套妬投透鬪慝特闖坡婆巴把播擺杷波派爬琶破罷芭跛頗判坂板版瓣販辦鈑"],["f8a1","阪八叭捌佩唄悖敗沛浿牌狽稗覇貝彭澎烹膨愎便偏扁片篇編翩遍鞭騙貶坪平枰萍評吠嬖幣廢弊斃肺蔽閉陛佈包匍匏咆哺圃布怖抛抱捕暴泡浦疱砲胞脯苞葡蒲袍褒逋鋪飽鮑幅暴曝瀑爆輻俵剽彪慓杓標漂瓢票表豹飇飄驃"],["f9a1","品稟楓諷豊風馮彼披疲皮被避陂匹弼必泌珌畢疋筆苾馝乏逼下何厦夏廈昰河瑕荷蝦賀遐霞鰕壑學虐謔鶴寒恨悍旱汗漢澣瀚罕翰閑閒限韓割轄函含咸啣喊檻涵緘艦銜陷鹹合哈盒蛤閤闔陜亢伉姮嫦巷恒抗杭桁沆港缸肛航"],["faa1","行降項亥偕咳垓奚孩害懈楷海瀣蟹解該諧邂駭骸劾核倖幸杏荇行享向嚮珦鄕響餉饗香噓墟虛許憲櫶獻軒歇險驗奕爀赫革俔峴弦懸晛泫炫玄玹現眩睍絃絢縣舷衒見賢鉉顯孑穴血頁嫌俠協夾峽挾浹狹脅脇莢鋏頰亨兄刑型"],["fba1","形泂滎瀅灐炯熒珩瑩荊螢衡逈邢鎣馨兮彗惠慧暳蕙蹊醯鞋乎互呼壕壺好岵弧戶扈昊晧毫浩淏湖滸澔濠濩灝狐琥瑚瓠皓祜糊縞胡芦葫蒿虎號蝴護豪鎬頀顥惑或酷婚昏混渾琿魂忽惚笏哄弘汞泓洪烘紅虹訌鴻化和嬅樺火畵"],["fca1","禍禾花華話譁貨靴廓擴攫確碻穫丸喚奐宦幻患換歡晥桓渙煥環紈還驩鰥活滑猾豁闊凰幌徨恍惶愰慌晃晄榥況湟滉潢煌璜皇篁簧荒蝗遑隍黃匯回廻徊恢悔懷晦會檜淮澮灰獪繪膾茴蛔誨賄劃獲宖橫鐄哮嚆孝效斅曉梟涍淆"],["fda1","爻肴酵驍侯候厚后吼喉嗅帿後朽煦珝逅勛勳塤壎焄熏燻薰訓暈薨喧暄煊萱卉喙毁彙徽揮暉煇諱輝麾休携烋畦虧恤譎鷸兇凶匈洶胸黑昕欣炘痕吃屹紇訖欠欽歆吸恰洽翕興僖凞喜噫囍姬嬉希憙憘戱晞曦熙熹熺犧禧稀羲詰"]]');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/cp950.json":
/*!*************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/cp950.json ***!
  \*************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["0","\\u0000",127],["a140","　，、。．‧；：？！︰…‥﹐﹑﹒·﹔﹕﹖﹗｜–︱—︳╴︴﹏（）︵︶｛｝︷︸〔〕︹︺【】︻︼《》︽︾〈〉︿﹀「」﹁﹂『』﹃﹄﹙﹚"],["a1a1","﹛﹜﹝﹞‘’“”〝〞‵′＃＆＊※§〃○●△▲◎☆★◇◆□■▽▼㊣℅¯￣＿ˍ﹉﹊﹍﹎﹋﹌﹟﹠﹡＋－×÷±√＜＞＝≦≧≠∞≒≡﹢",4,"～∩∪⊥∠∟⊿㏒㏑∫∮∵∴♀♂⊕⊙↑↓←→↖↗↙↘∥∣／"],["a240","＼∕﹨＄￥〒￠￡％＠℃℉﹩﹪﹫㏕㎜㎝㎞㏎㎡㎎㎏㏄°兙兛兞兝兡兣嗧瓩糎▁",7,"▏▎▍▌▋▊▉┼┴┬┤├▔─│▕┌┐└┘╭"],["a2a1","╮╰╯═╞╪╡◢◣◥◤╱╲╳０",9,"Ⅰ",9,"〡",8,"十卄卅Ａ",25,"ａ",21],["a340","ｗｘｙｚΑ",16,"Σ",6,"α",16,"σ",6,"ㄅ",10],["a3a1","ㄐ",25,"˙ˉˊˇˋ"],["a3e1","€"],["a440","一乙丁七乃九了二人儿入八几刀刁力匕十卜又三下丈上丫丸凡久么也乞于亡兀刃勺千叉口土士夕大女子孑孓寸小尢尸山川工己已巳巾干廾弋弓才"],["a4a1","丑丐不中丰丹之尹予云井互五亢仁什仃仆仇仍今介仄元允內六兮公冗凶分切刈勻勾勿化匹午升卅卞厄友及反壬天夫太夭孔少尤尺屯巴幻廿弔引心戈戶手扎支文斗斤方日曰月木欠止歹毋比毛氏水火爪父爻片牙牛犬王丙"],["a540","世丕且丘主乍乏乎以付仔仕他仗代令仙仞充兄冉冊冬凹出凸刊加功包匆北匝仟半卉卡占卯卮去可古右召叮叩叨叼司叵叫另只史叱台句叭叻四囚外"],["a5a1","央失奴奶孕它尼巨巧左市布平幼弁弘弗必戊打扔扒扑斥旦朮本未末札正母民氐永汁汀氾犯玄玉瓜瓦甘生用甩田由甲申疋白皮皿目矛矢石示禾穴立丞丟乒乓乩亙交亦亥仿伉伙伊伕伍伐休伏仲件任仰仳份企伋光兇兆先全"],["a640","共再冰列刑划刎刖劣匈匡匠印危吉吏同吊吐吁吋各向名合吃后吆吒因回囝圳地在圭圬圯圩夙多夷夸妄奸妃好她如妁字存宇守宅安寺尖屹州帆并年"],["a6a1","式弛忙忖戎戌戍成扣扛托收早旨旬旭曲曳有朽朴朱朵次此死氖汝汗汙江池汐汕污汛汍汎灰牟牝百竹米糸缶羊羽老考而耒耳聿肉肋肌臣自至臼舌舛舟艮色艾虫血行衣西阡串亨位住佇佗佞伴佛何估佐佑伽伺伸佃佔似但佣"],["a740","作你伯低伶余佝佈佚兌克免兵冶冷別判利刪刨劫助努劬匣即卵吝吭吞吾否呎吧呆呃吳呈呂君吩告吹吻吸吮吵吶吠吼呀吱含吟听囪困囤囫坊坑址坍"],["a7a1","均坎圾坐坏圻壯夾妝妒妨妞妣妙妖妍妤妓妊妥孝孜孚孛完宋宏尬局屁尿尾岐岑岔岌巫希序庇床廷弄弟彤形彷役忘忌志忍忱快忸忪戒我抄抗抖技扶抉扭把扼找批扳抒扯折扮投抓抑抆改攻攸旱更束李杏材村杜杖杞杉杆杠"],["a840","杓杗步每求汞沙沁沈沉沅沛汪決沐汰沌汨沖沒汽沃汲汾汴沆汶沍沔沘沂灶灼災灸牢牡牠狄狂玖甬甫男甸皂盯矣私秀禿究系罕肖肓肝肘肛肚育良芒"],["a8a1","芋芍見角言谷豆豕貝赤走足身車辛辰迂迆迅迄巡邑邢邪邦那酉釆里防阮阱阪阬並乖乳事些亞享京佯依侍佳使佬供例來侃佰併侈佩佻侖佾侏侑佺兔兒兕兩具其典冽函刻券刷刺到刮制剁劾劻卒協卓卑卦卷卸卹取叔受味呵"],["a940","咖呸咕咀呻呷咄咒咆呼咐呱呶和咚呢周咋命咎固垃坷坪坩坡坦坤坼夜奉奇奈奄奔妾妻委妹妮姑姆姐姍始姓姊妯妳姒姅孟孤季宗定官宜宙宛尚屈居"],["a9a1","屆岷岡岸岩岫岱岳帘帚帖帕帛帑幸庚店府底庖延弦弧弩往征彿彼忝忠忽念忿怏怔怯怵怖怪怕怡性怩怫怛或戕房戾所承拉拌拄抿拂抹拒招披拓拔拋拈抨抽押拐拙拇拍抵拚抱拘拖拗拆抬拎放斧於旺昔易昌昆昂明昀昏昕昊"],["aa40","昇服朋杭枋枕東果杳杷枇枝林杯杰板枉松析杵枚枓杼杪杲欣武歧歿氓氛泣注泳沱泌泥河沽沾沼波沫法泓沸泄油況沮泗泅泱沿治泡泛泊沬泯泜泖泠"],["aaa1","炕炎炒炊炙爬爭爸版牧物狀狎狙狗狐玩玨玟玫玥甽疝疙疚的盂盲直知矽社祀祁秉秈空穹竺糾罔羌羋者肺肥肢肱股肫肩肴肪肯臥臾舍芳芝芙芭芽芟芹花芬芥芯芸芣芰芾芷虎虱初表軋迎返近邵邸邱邶采金長門阜陀阿阻附"],["ab40","陂隹雨青非亟亭亮信侵侯便俠俑俏保促侶俘俟俊俗侮俐俄係俚俎俞侷兗冒冑冠剎剃削前剌剋則勇勉勃勁匍南卻厚叛咬哀咨哎哉咸咦咳哇哂咽咪品"],["aba1","哄哈咯咫咱咻咩咧咿囿垂型垠垣垢城垮垓奕契奏奎奐姜姘姿姣姨娃姥姪姚姦威姻孩宣宦室客宥封屎屏屍屋峙峒巷帝帥帟幽庠度建弈弭彥很待徊律徇後徉怒思怠急怎怨恍恰恨恢恆恃恬恫恪恤扁拜挖按拼拭持拮拽指拱拷"],["ac40","拯括拾拴挑挂政故斫施既春昭映昧是星昨昱昤曷柿染柱柔某柬架枯柵柩柯柄柑枴柚查枸柏柞柳枰柙柢柝柒歪殃殆段毒毗氟泉洋洲洪流津洌洱洞洗"],["aca1","活洽派洶洛泵洹洧洸洩洮洵洎洫炫為炳炬炯炭炸炮炤爰牲牯牴狩狠狡玷珊玻玲珍珀玳甚甭畏界畎畋疫疤疥疢疣癸皆皇皈盈盆盃盅省盹相眉看盾盼眇矜砂研砌砍祆祉祈祇禹禺科秒秋穿突竿竽籽紂紅紀紉紇約紆缸美羿耄"],["ad40","耐耍耑耶胖胥胚胃胄背胡胛胎胞胤胝致舢苧范茅苣苛苦茄若茂茉苒苗英茁苜苔苑苞苓苟苯茆虐虹虻虺衍衫要觔計訂訃貞負赴赳趴軍軌述迦迢迪迥"],["ada1","迭迫迤迨郊郎郁郃酋酊重閂限陋陌降面革韋韭音頁風飛食首香乘亳倌倍倣俯倦倥俸倩倖倆值借倚倒們俺倀倔倨俱倡個候倘俳修倭倪俾倫倉兼冤冥冢凍凌准凋剖剜剔剛剝匪卿原厝叟哨唐唁唷哼哥哲唆哺唔哩哭員唉哮哪"],["ae40","哦唧唇哽唏圃圄埂埔埋埃堉夏套奘奚娑娘娜娟娛娓姬娠娣娩娥娌娉孫屘宰害家宴宮宵容宸射屑展屐峭峽峻峪峨峰島崁峴差席師庫庭座弱徒徑徐恙"],["aea1","恣恥恐恕恭恩息悄悟悚悍悔悌悅悖扇拳挈拿捎挾振捕捂捆捏捉挺捐挽挪挫挨捍捌效敉料旁旅時晉晏晃晒晌晅晁書朔朕朗校核案框桓根桂桔栩梳栗桌桑栽柴桐桀格桃株桅栓栘桁殊殉殷氣氧氨氦氤泰浪涕消涇浦浸海浙涓"],["af40","浬涉浮浚浴浩涌涊浹涅浥涔烊烘烤烙烈烏爹特狼狹狽狸狷玆班琉珮珠珪珞畔畝畜畚留疾病症疲疳疽疼疹痂疸皋皰益盍盎眩真眠眨矩砰砧砸砝破砷"],["afa1","砥砭砠砟砲祕祐祠祟祖神祝祗祚秤秣秧租秦秩秘窄窈站笆笑粉紡紗紋紊素索純紐紕級紜納紙紛缺罟羔翅翁耆耘耕耙耗耽耿胱脂胰脅胭胴脆胸胳脈能脊胼胯臭臬舀舐航舫舨般芻茫荒荔荊茸荐草茵茴荏茲茹茶茗荀茱茨荃"],["b040","虔蚊蚪蚓蚤蚩蚌蚣蚜衰衷袁袂衽衹記訐討訌訕訊託訓訖訏訑豈豺豹財貢起躬軒軔軏辱送逆迷退迺迴逃追逅迸邕郡郝郢酒配酌釘針釗釜釙閃院陣陡"],["b0a1","陛陝除陘陞隻飢馬骨高鬥鬲鬼乾偺偽停假偃偌做偉健偶偎偕偵側偷偏倏偯偭兜冕凰剪副勒務勘動匐匏匙匿區匾參曼商啪啦啄啞啡啃啊唱啖問啕唯啤唸售啜唬啣唳啁啗圈國圉域堅堊堆埠埤基堂堵執培夠奢娶婁婉婦婪婀"],["b140","娼婢婚婆婊孰寇寅寄寂宿密尉專將屠屜屝崇崆崎崛崖崢崑崩崔崙崤崧崗巢常帶帳帷康庸庶庵庾張強彗彬彩彫得徙從徘御徠徜恿患悉悠您惋悴惦悽"],["b1a1","情悻悵惜悼惘惕惆惟悸惚惇戚戛扈掠控捲掖探接捷捧掘措捱掩掉掃掛捫推掄授掙採掬排掏掀捻捩捨捺敝敖救教敗啟敏敘敕敔斜斛斬族旋旌旎晝晚晤晨晦晞曹勗望梁梯梢梓梵桿桶梱梧梗械梃棄梭梆梅梔條梨梟梡梂欲殺"],["b240","毫毬氫涎涼淳淙液淡淌淤添淺清淇淋涯淑涮淞淹涸混淵淅淒渚涵淚淫淘淪深淮淨淆淄涪淬涿淦烹焉焊烽烯爽牽犁猜猛猖猓猙率琅琊球理現琍瓠瓶"],["b2a1","瓷甜產略畦畢異疏痔痕疵痊痍皎盔盒盛眷眾眼眶眸眺硫硃硎祥票祭移窒窕笠笨笛第符笙笞笮粒粗粕絆絃統紮紹紼絀細紳組累終紲紱缽羞羚翌翎習耜聊聆脯脖脣脫脩脰脤舂舵舷舶船莎莞莘荸莢莖莽莫莒莊莓莉莠荷荻荼"],["b340","莆莧處彪蛇蛀蚶蛄蚵蛆蛋蚱蚯蛉術袞袈被袒袖袍袋覓規訪訝訣訥許設訟訛訢豉豚販責貫貨貪貧赧赦趾趺軛軟這逍通逗連速逝逐逕逞造透逢逖逛途"],["b3a1","部郭都酗野釵釦釣釧釭釩閉陪陵陳陸陰陴陶陷陬雀雪雩章竟頂頃魚鳥鹵鹿麥麻傢傍傅備傑傀傖傘傚最凱割剴創剩勞勝勛博厥啻喀喧啼喊喝喘喂喜喪喔喇喋喃喳單喟唾喲喚喻喬喱啾喉喫喙圍堯堪場堤堰報堡堝堠壹壺奠"],["b440","婷媚婿媒媛媧孳孱寒富寓寐尊尋就嵌嵐崴嵇巽幅帽幀幃幾廊廁廂廄弼彭復循徨惑惡悲悶惠愜愣惺愕惰惻惴慨惱愎惶愉愀愒戟扉掣掌描揀揩揉揆揍"],["b4a1","插揣提握揖揭揮捶援揪換摒揚揹敞敦敢散斑斐斯普晰晴晶景暑智晾晷曾替期朝棺棕棠棘棗椅棟棵森棧棹棒棲棣棋棍植椒椎棉棚楮棻款欺欽殘殖殼毯氮氯氬港游湔渡渲湧湊渠渥渣減湛湘渤湖湮渭渦湯渴湍渺測湃渝渾滋"],["b540","溉渙湎湣湄湲湩湟焙焚焦焰無然煮焜牌犄犀猶猥猴猩琺琪琳琢琥琵琶琴琯琛琦琨甥甦畫番痢痛痣痙痘痞痠登發皖皓皴盜睏短硝硬硯稍稈程稅稀窘"],["b5a1","窗窖童竣等策筆筐筒答筍筋筏筑粟粥絞結絨絕紫絮絲絡給絢絰絳善翔翕耋聒肅腕腔腋腑腎脹腆脾腌腓腴舒舜菩萃菸萍菠菅萋菁華菱菴著萊菰萌菌菽菲菊萸萎萄菜萇菔菟虛蛟蛙蛭蛔蛛蛤蛐蛞街裁裂袱覃視註詠評詞証詁"],["b640","詔詛詐詆訴診訶詖象貂貯貼貳貽賁費賀貴買貶貿貸越超趁跎距跋跚跑跌跛跆軻軸軼辜逮逵週逸進逶鄂郵鄉郾酣酥量鈔鈕鈣鈉鈞鈍鈐鈇鈑閔閏開閑"],["b6a1","間閒閎隊階隋陽隅隆隍陲隄雁雅雄集雇雯雲韌項順須飧飪飯飩飲飭馮馭黃黍黑亂傭債傲傳僅傾催傷傻傯僇剿剷剽募勦勤勢勣匯嗟嗨嗓嗦嗎嗜嗇嗑嗣嗤嗯嗚嗡嗅嗆嗥嗉園圓塞塑塘塗塚塔填塌塭塊塢塒塋奧嫁嫉嫌媾媽媼"],["b740","媳嫂媲嵩嵯幌幹廉廈弒彙徬微愚意慈感想愛惹愁愈慎慌慄慍愾愴愧愍愆愷戡戢搓搾搞搪搭搽搬搏搜搔損搶搖搗搆敬斟新暗暉暇暈暖暄暘暍會榔業"],["b7a1","楚楷楠楔極椰概楊楨楫楞楓楹榆楝楣楛歇歲毀殿毓毽溢溯滓溶滂源溝滇滅溥溘溼溺溫滑準溜滄滔溪溧溴煎煙煩煤煉照煜煬煦煌煥煞煆煨煖爺牒猷獅猿猾瑯瑚瑕瑟瑞瑁琿瑙瑛瑜當畸瘀痰瘁痲痱痺痿痴痳盞盟睛睫睦睞督"],["b840","睹睪睬睜睥睨睢矮碎碰碗碘碌碉硼碑碓硿祺祿禁萬禽稜稚稠稔稟稞窟窠筷節筠筮筧粱粳粵經絹綑綁綏絛置罩罪署義羨群聖聘肆肄腱腰腸腥腮腳腫"],["b8a1","腹腺腦舅艇蒂葷落萱葵葦葫葉葬葛萼萵葡董葩葭葆虞虜號蛹蜓蜈蜇蜀蛾蛻蜂蜃蜆蜊衙裟裔裙補裘裝裡裊裕裒覜解詫該詳試詩詰誇詼詣誠話誅詭詢詮詬詹詻訾詨豢貊貉賊資賈賄貲賃賂賅跡跟跨路跳跺跪跤跦躲較載軾輊"],["b940","辟農運遊道遂達逼違遐遇遏過遍遑逾遁鄒鄗酬酪酩釉鈷鉗鈸鈽鉀鈾鉛鉋鉤鉑鈴鉉鉍鉅鈹鈿鉚閘隘隔隕雍雋雉雊雷電雹零靖靴靶預頑頓頊頒頌飼飴"],["b9a1","飽飾馳馱馴髡鳩麂鼎鼓鼠僧僮僥僖僭僚僕像僑僱僎僩兢凳劃劂匱厭嗾嘀嘛嘗嗽嘔嘆嘉嘍嘎嗷嘖嘟嘈嘐嗶團圖塵塾境墓墊塹墅塽壽夥夢夤奪奩嫡嫦嫩嫗嫖嫘嫣孵寞寧寡寥實寨寢寤察對屢嶄嶇幛幣幕幗幔廓廖弊彆彰徹慇"],["ba40","愿態慷慢慣慟慚慘慵截撇摘摔撤摸摟摺摑摧搴摭摻敲斡旗旖暢暨暝榜榨榕槁榮槓構榛榷榻榫榴槐槍榭槌榦槃榣歉歌氳漳演滾漓滴漩漾漠漬漏漂漢"],["baa1","滿滯漆漱漸漲漣漕漫漯澈漪滬漁滲滌滷熔熙煽熊熄熒爾犒犖獄獐瑤瑣瑪瑰瑭甄疑瘧瘍瘋瘉瘓盡監瞄睽睿睡磁碟碧碳碩碣禎福禍種稱窪窩竭端管箕箋筵算箝箔箏箸箇箄粹粽精綻綰綜綽綾綠緊綴網綱綺綢綿綵綸維緒緇綬"],["bb40","罰翠翡翟聞聚肇腐膀膏膈膊腿膂臧臺與舔舞艋蓉蒿蓆蓄蒙蒞蒲蒜蓋蒸蓀蓓蒐蒼蓑蓊蜿蜜蜻蜢蜥蜴蜘蝕蜷蜩裳褂裴裹裸製裨褚裯誦誌語誣認誡誓誤"],["bba1","說誥誨誘誑誚誧豪貍貌賓賑賒赫趙趕跼輔輒輕輓辣遠遘遜遣遙遞遢遝遛鄙鄘鄞酵酸酷酴鉸銀銅銘銖鉻銓銜銨鉼銑閡閨閩閣閥閤隙障際雌雒需靼鞅韶頗領颯颱餃餅餌餉駁骯骰髦魁魂鳴鳶鳳麼鼻齊億儀僻僵價儂儈儉儅凜"],["bc40","劇劈劉劍劊勰厲嘮嘻嘹嘲嘿嘴嘩噓噎噗噴嘶嘯嘰墀墟增墳墜墮墩墦奭嬉嫻嬋嫵嬌嬈寮寬審寫層履嶝嶔幢幟幡廢廚廟廝廣廠彈影德徵慶慧慮慝慕憂"],["bca1","慼慰慫慾憧憐憫憎憬憚憤憔憮戮摩摯摹撞撲撈撐撰撥撓撕撩撒撮播撫撚撬撙撢撳敵敷數暮暫暴暱樣樟槨樁樞標槽模樓樊槳樂樅槭樑歐歎殤毅毆漿潼澄潑潦潔澆潭潛潸潮澎潺潰潤澗潘滕潯潠潟熟熬熱熨牖犛獎獗瑩璋璃"],["bd40","瑾璀畿瘠瘩瘟瘤瘦瘡瘢皚皺盤瞎瞇瞌瞑瞋磋磅確磊碾磕碼磐稿稼穀稽稷稻窯窮箭箱範箴篆篇篁箠篌糊締練緯緻緘緬緝編緣線緞緩綞緙緲緹罵罷羯"],["bda1","翩耦膛膜膝膠膚膘蔗蔽蔚蓮蔬蔭蔓蔑蔣蔡蔔蓬蔥蓿蔆螂蝴蝶蝠蝦蝸蝨蝙蝗蝌蝓衛衝褐複褒褓褕褊誼諒談諄誕請諸課諉諂調誰論諍誶誹諛豌豎豬賠賞賦賤賬賭賢賣賜質賡赭趟趣踫踐踝踢踏踩踟踡踞躺輝輛輟輩輦輪輜輞"],["be40","輥適遮遨遭遷鄰鄭鄧鄱醇醉醋醃鋅銻銷鋪銬鋤鋁銳銼鋒鋇鋰銲閭閱霄霆震霉靠鞍鞋鞏頡頫頜颳養餓餒餘駝駐駟駛駑駕駒駙骷髮髯鬧魅魄魷魯鴆鴉"],["bea1","鴃麩麾黎墨齒儒儘儔儐儕冀冪凝劑劓勳噙噫噹噩噤噸噪器噥噱噯噬噢噶壁墾壇壅奮嬝嬴學寰導彊憲憑憩憊懍憶憾懊懈戰擅擁擋撻撼據擄擇擂操撿擒擔撾整曆曉暹曄曇暸樽樸樺橙橫橘樹橄橢橡橋橇樵機橈歙歷氅濂澱澡"],["bf40","濃澤濁澧澳激澹澶澦澠澴熾燉燐燒燈燕熹燎燙燜燃燄獨璜璣璘璟璞瓢甌甍瘴瘸瘺盧盥瞠瞞瞟瞥磨磚磬磧禦積穎穆穌穋窺篙簑築篤篛篡篩篦糕糖縊"],["bfa1","縑縈縛縣縞縝縉縐罹羲翰翱翮耨膳膩膨臻興艘艙蕊蕙蕈蕨蕩蕃蕉蕭蕪蕞螃螟螞螢融衡褪褲褥褫褡親覦諦諺諫諱謀諜諧諮諾謁謂諷諭諳諶諼豫豭貓賴蹄踱踴蹂踹踵輻輯輸輳辨辦遵遴選遲遼遺鄴醒錠錶鋸錳錯錢鋼錫錄錚"],["c040","錐錦錡錕錮錙閻隧隨險雕霎霑霖霍霓霏靛靜靦鞘頰頸頻頷頭頹頤餐館餞餛餡餚駭駢駱骸骼髻髭鬨鮑鴕鴣鴦鴨鴒鴛默黔龍龜優償儡儲勵嚎嚀嚐嚅嚇"],["c0a1","嚏壕壓壑壎嬰嬪嬤孺尷屨嶼嶺嶽嶸幫彌徽應懂懇懦懋戲戴擎擊擘擠擰擦擬擱擢擭斂斃曙曖檀檔檄檢檜櫛檣橾檗檐檠歜殮毚氈濘濱濟濠濛濤濫濯澀濬濡濩濕濮濰燧營燮燦燥燭燬燴燠爵牆獰獲璩環璦璨癆療癌盪瞳瞪瞰瞬"],["c140","瞧瞭矯磷磺磴磯礁禧禪穗窿簇簍篾篷簌篠糠糜糞糢糟糙糝縮績繆縷縲繃縫總縱繅繁縴縹繈縵縿縯罄翳翼聱聲聰聯聳臆臃膺臂臀膿膽臉膾臨舉艱薪"],["c1a1","薄蕾薜薑薔薯薛薇薨薊虧蟀蟑螳蟒蟆螫螻螺蟈蟋褻褶襄褸褽覬謎謗謙講謊謠謝謄謐豁谿豳賺賽購賸賻趨蹉蹋蹈蹊轄輾轂轅輿避遽還邁邂邀鄹醣醞醜鍍鎂錨鍵鍊鍥鍋錘鍾鍬鍛鍰鍚鍔闊闋闌闈闆隱隸雖霜霞鞠韓顆颶餵騁"],["c240","駿鮮鮫鮪鮭鴻鴿麋黏點黜黝黛鼾齋叢嚕嚮壙壘嬸彝懣戳擴擲擾攆擺擻擷斷曜朦檳檬櫃檻檸櫂檮檯歟歸殯瀉瀋濾瀆濺瀑瀏燻燼燾燸獷獵璧璿甕癖癘"],["c2a1","癒瞽瞿瞻瞼礎禮穡穢穠竄竅簫簧簪簞簣簡糧織繕繞繚繡繒繙罈翹翻職聶臍臏舊藏薩藍藐藉薰薺薹薦蟯蟬蟲蟠覆覲觴謨謹謬謫豐贅蹙蹣蹦蹤蹟蹕軀轉轍邇邃邈醫醬釐鎔鎊鎖鎢鎳鎮鎬鎰鎘鎚鎗闔闖闐闕離雜雙雛雞霤鞣鞦"],["c340","鞭韹額顏題顎顓颺餾餿餽餮馥騎髁鬃鬆魏魎魍鯊鯉鯽鯈鯀鵑鵝鵠黠鼕鼬儳嚥壞壟壢寵龐廬懲懷懶懵攀攏曠曝櫥櫝櫚櫓瀛瀟瀨瀚瀝瀕瀘爆爍牘犢獸"],["c3a1","獺璽瓊瓣疇疆癟癡矇礙禱穫穩簾簿簸簽簷籀繫繭繹繩繪羅繳羶羹羸臘藩藝藪藕藤藥藷蟻蠅蠍蟹蟾襠襟襖襞譁譜識證譚譎譏譆譙贈贊蹼蹲躇蹶蹬蹺蹴轔轎辭邊邋醱醮鏡鏑鏟鏃鏈鏜鏝鏖鏢鏍鏘鏤鏗鏨關隴難霪霧靡韜韻類"],["c440","願顛颼饅饉騖騙鬍鯨鯧鯖鯛鶉鵡鵲鵪鵬麒麗麓麴勸嚨嚷嚶嚴嚼壤孀孃孽寶巉懸懺攘攔攙曦朧櫬瀾瀰瀲爐獻瓏癢癥礦礪礬礫竇競籌籃籍糯糰辮繽繼"],["c4a1","纂罌耀臚艦藻藹蘑藺蘆蘋蘇蘊蠔蠕襤覺觸議譬警譯譟譫贏贍躉躁躅躂醴釋鐘鐃鏽闡霰飄饒饑馨騫騰騷騵鰓鰍鹹麵黨鼯齟齣齡儷儸囁囀囂夔屬巍懼懾攝攜斕曩櫻欄櫺殲灌爛犧瓖瓔癩矓籐纏續羼蘗蘭蘚蠣蠢蠡蠟襪襬覽譴"],["c540","護譽贓躊躍躋轟辯醺鐮鐳鐵鐺鐸鐲鐫闢霸霹露響顧顥饗驅驃驀騾髏魔魑鰭鰥鶯鶴鷂鶸麝黯鼙齜齦齧儼儻囈囊囉孿巔巒彎懿攤權歡灑灘玀瓤疊癮癬"],["c5a1","禳籠籟聾聽臟襲襯觼讀贖贗躑躓轡酈鑄鑑鑒霽霾韃韁顫饕驕驍髒鬚鱉鰱鰾鰻鷓鷗鼴齬齪龔囌巖戀攣攫攪曬欐瓚竊籤籣籥纓纖纔臢蘸蘿蠱變邐邏鑣鑠鑤靨顯饜驚驛驗髓體髑鱔鱗鱖鷥麟黴囑壩攬灞癱癲矗罐羈蠶蠹衢讓讒"],["c640","讖艷贛釀鑪靂靈靄韆顰驟鬢魘鱟鷹鷺鹼鹽鼇齷齲廳欖灣籬籮蠻觀躡釁鑲鑰顱饞髖鬣黌灤矚讚鑷韉驢驥纜讜躪釅鑽鑾鑼鱷鱸黷豔鑿鸚爨驪鬱鸛鸞籲"],["c940","乂乜凵匚厂万丌乇亍囗兀屮彳丏冇与丮亓仂仉仈冘勼卬厹圠夃夬尐巿旡殳毌气爿丱丼仨仜仩仡仝仚刌匜卌圢圣夗夯宁宄尒尻屴屳帄庀庂忉戉扐氕"],["c9a1","氶汃氿氻犮犰玊禸肊阞伎优伬仵伔仱伀价伈伝伂伅伢伓伄仴伒冱刓刉刐劦匢匟卍厊吇囡囟圮圪圴夼妀奼妅奻奾奷奿孖尕尥屼屺屻屾巟幵庄异弚彴忕忔忏扜扞扤扡扦扢扙扠扚扥旯旮朾朹朸朻机朿朼朳氘汆汒汜汏汊汔汋"],["ca40","汌灱牞犴犵玎甪癿穵网艸艼芀艽艿虍襾邙邗邘邛邔阢阤阠阣佖伻佢佉体佤伾佧佒佟佁佘伭伳伿佡冏冹刜刞刡劭劮匉卣卲厎厏吰吷吪呔呅吙吜吥吘"],["caa1","吽呏呁吨吤呇囮囧囥坁坅坌坉坋坒夆奀妦妘妠妗妎妢妐妏妧妡宎宒尨尪岍岏岈岋岉岒岊岆岓岕巠帊帎庋庉庌庈庍弅弝彸彶忒忑忐忭忨忮忳忡忤忣忺忯忷忻怀忴戺抃抌抎抏抔抇扱扻扺扰抁抈扷扽扲扴攷旰旴旳旲旵杅杇"],["cb40","杙杕杌杈杝杍杚杋毐氙氚汸汧汫沄沋沏汱汯汩沚汭沇沕沜汦汳汥汻沎灴灺牣犿犽狃狆狁犺狅玕玗玓玔玒町甹疔疕皁礽耴肕肙肐肒肜芐芏芅芎芑芓"],["cba1","芊芃芄豸迉辿邟邡邥邞邧邠阰阨阯阭丳侘佼侅佽侀侇佶佴侉侄佷佌侗佪侚佹侁佸侐侜侔侞侒侂侕佫佮冞冼冾刵刲刳剆刱劼匊匋匼厒厔咇呿咁咑咂咈呫呺呾呥呬呴呦咍呯呡呠咘呣呧呤囷囹坯坲坭坫坱坰坶垀坵坻坳坴坢"],["cc40","坨坽夌奅妵妺姏姎妲姌姁妶妼姃姖妱妽姀姈妴姇孢孥宓宕屄屇岮岤岠岵岯岨岬岟岣岭岢岪岧岝岥岶岰岦帗帔帙弨弢弣弤彔徂彾彽忞忥怭怦怙怲怋"],["cca1","怴怊怗怳怚怞怬怢怍怐怮怓怑怌怉怜戔戽抭抴拑抾抪抶拊抮抳抯抻抩抰抸攽斨斻昉旼昄昒昈旻昃昋昍昅旽昑昐曶朊枅杬枎枒杶杻枘枆构杴枍枌杺枟枑枙枃杽极杸杹枔欥殀歾毞氝沓泬泫泮泙沶泔沭泧沷泐泂沺泃泆泭泲"],["cd40","泒泝沴沊沝沀泞泀洰泍泇沰泹泏泩泑炔炘炅炓炆炄炑炖炂炚炃牪狖狋狘狉狜狒狔狚狌狑玤玡玭玦玢玠玬玝瓝瓨甿畀甾疌疘皯盳盱盰盵矸矼矹矻矺"],["cda1","矷祂礿秅穸穻竻籵糽耵肏肮肣肸肵肭舠芠苀芫芚芘芛芵芧芮芼芞芺芴芨芡芩苂芤苃芶芢虰虯虭虮豖迒迋迓迍迖迕迗邲邴邯邳邰阹阽阼阺陃俍俅俓侲俉俋俁俔俜俙侻侳俛俇俖侺俀侹俬剄剉勀勂匽卼厗厖厙厘咺咡咭咥哏"],["ce40","哃茍咷咮哖咶哅哆咠呰咼咢咾呲哞咰垵垞垟垤垌垗垝垛垔垘垏垙垥垚垕壴复奓姡姞姮娀姱姝姺姽姼姶姤姲姷姛姩姳姵姠姾姴姭宨屌峐峘峌峗峋峛"],["cea1","峞峚峉峇峊峖峓峔峏峈峆峎峟峸巹帡帢帣帠帤庰庤庢庛庣庥弇弮彖徆怷怹恔恲恞恅恓恇恉恛恌恀恂恟怤恄恘恦恮扂扃拏挍挋拵挎挃拫拹挏挌拸拶挀挓挔拺挕拻拰敁敃斪斿昶昡昲昵昜昦昢昳昫昺昝昴昹昮朏朐柁柲柈枺"],["cf40","柜枻柸柘柀枷柅柫柤柟枵柍枳柷柶柮柣柂枹柎柧柰枲柼柆柭柌枮柦柛柺柉柊柃柪柋欨殂殄殶毖毘毠氠氡洨洴洭洟洼洿洒洊泚洳洄洙洺洚洑洀洝浂"],["cfa1","洁洘洷洃洏浀洇洠洬洈洢洉洐炷炟炾炱炰炡炴炵炩牁牉牊牬牰牳牮狊狤狨狫狟狪狦狣玅珌珂珈珅玹玶玵玴珫玿珇玾珃珆玸珋瓬瓮甮畇畈疧疪癹盄眈眃眄眅眊盷盻盺矧矨砆砑砒砅砐砏砎砉砃砓祊祌祋祅祄秕种秏秖秎窀"],["d040","穾竑笀笁籺籸籹籿粀粁紃紈紁罘羑羍羾耇耎耏耔耷胘胇胠胑胈胂胐胅胣胙胜胊胕胉胏胗胦胍臿舡芔苙苾苹茇苨茀苕茺苫苖苴苬苡苲苵茌苻苶苰苪"],["d0a1","苤苠苺苳苭虷虴虼虳衁衎衧衪衩觓訄訇赲迣迡迮迠郱邽邿郕郅邾郇郋郈釔釓陔陏陑陓陊陎倞倅倇倓倢倰倛俵俴倳倷倬俶俷倗倜倠倧倵倯倱倎党冔冓凊凄凅凈凎剡剚剒剞剟剕剢勍匎厞唦哢唗唒哧哳哤唚哿唄唈哫唑唅哱"],["d140","唊哻哷哸哠唎唃唋圁圂埌堲埕埒垺埆垽垼垸垶垿埇埐垹埁夎奊娙娖娭娮娕娏娗娊娞娳孬宧宭宬尃屖屔峬峿峮峱峷崀峹帩帨庨庮庪庬弳弰彧恝恚恧"],["d1a1","恁悢悈悀悒悁悝悃悕悛悗悇悜悎戙扆拲挐捖挬捄捅挶捃揤挹捋捊挼挩捁挴捘捔捙挭捇挳捚捑挸捗捀捈敊敆旆旃旄旂晊晟晇晑朒朓栟栚桉栲栳栻桋桏栖栱栜栵栫栭栯桎桄栴栝栒栔栦栨栮桍栺栥栠欬欯欭欱欴歭肂殈毦毤"],["d240","毨毣毢毧氥浺浣浤浶洍浡涒浘浢浭浯涑涍淯浿涆浞浧浠涗浰浼浟涂涘洯浨涋浾涀涄洖涃浻浽浵涐烜烓烑烝烋缹烢烗烒烞烠烔烍烅烆烇烚烎烡牂牸"],["d2a1","牷牶猀狺狴狾狶狳狻猁珓珙珥珖玼珧珣珩珜珒珛珔珝珚珗珘珨瓞瓟瓴瓵甡畛畟疰痁疻痄痀疿疶疺皊盉眝眛眐眓眒眣眑眕眙眚眢眧砣砬砢砵砯砨砮砫砡砩砳砪砱祔祛祏祜祓祒祑秫秬秠秮秭秪秜秞秝窆窉窅窋窌窊窇竘笐"],["d340","笄笓笅笏笈笊笎笉笒粄粑粊粌粈粍粅紞紝紑紎紘紖紓紟紒紏紌罜罡罞罠罝罛羖羒翃翂翀耖耾耹胺胲胹胵脁胻脀舁舯舥茳茭荄茙荑茥荖茿荁茦茜茢"],["d3a1","荂荎茛茪茈茼荍茖茤茠茷茯茩荇荅荌荓茞茬荋茧荈虓虒蚢蚨蚖蚍蚑蚞蚇蚗蚆蚋蚚蚅蚥蚙蚡蚧蚕蚘蚎蚝蚐蚔衃衄衭衵衶衲袀衱衿衯袃衾衴衼訒豇豗豻貤貣赶赸趵趷趶軑軓迾迵适迿迻逄迼迶郖郠郙郚郣郟郥郘郛郗郜郤酐"],["d440","酎酏釕釢釚陜陟隼飣髟鬯乿偰偪偡偞偠偓偋偝偲偈偍偁偛偊偢倕偅偟偩偫偣偤偆偀偮偳偗偑凐剫剭剬剮勖勓匭厜啵啶唼啍啐唴唪啑啢唶唵唰啒啅"],["d4a1","唌唲啥啎唹啈唭唻啀啋圊圇埻堔埢埶埜埴堀埭埽堈埸堋埳埏堇埮埣埲埥埬埡堎埼堐埧堁堌埱埩埰堍堄奜婠婘婕婧婞娸娵婭婐婟婥婬婓婤婗婃婝婒婄婛婈媎娾婍娹婌婰婩婇婑婖婂婜孲孮寁寀屙崞崋崝崚崠崌崨崍崦崥崏"],["d540","崰崒崣崟崮帾帴庱庴庹庲庳弶弸徛徖徟悊悐悆悾悰悺惓惔惏惤惙惝惈悱惛悷惊悿惃惍惀挲捥掊掂捽掽掞掭掝掗掫掎捯掇掐据掯捵掜捭掮捼掤挻掟"],["d5a1","捸掅掁掑掍捰敓旍晥晡晛晙晜晢朘桹梇梐梜桭桮梮梫楖桯梣梬梩桵桴梲梏桷梒桼桫桲梪梀桱桾梛梖梋梠梉梤桸桻梑梌梊桽欶欳欷欸殑殏殍殎殌氪淀涫涴涳湴涬淩淢涷淶淔渀淈淠淟淖涾淥淜淝淛淴淊涽淭淰涺淕淂淏淉"],["d640","淐淲淓淽淗淍淣涻烺焍烷焗烴焌烰焄烳焐烼烿焆焓焀烸烶焋焂焎牾牻牼牿猝猗猇猑猘猊猈狿猏猞玈珶珸珵琄琁珽琇琀珺珼珿琌琋珴琈畤畣痎痒痏"],["d6a1","痋痌痑痐皏皉盓眹眯眭眱眲眴眳眽眥眻眵硈硒硉硍硊硌砦硅硐祤祧祩祪祣祫祡离秺秸秶秷窏窔窐笵筇笴笥笰笢笤笳笘笪笝笱笫笭笯笲笸笚笣粔粘粖粣紵紽紸紶紺絅紬紩絁絇紾紿絊紻紨罣羕羜羝羛翊翋翍翐翑翇翏翉耟"],["d740","耞耛聇聃聈脘脥脙脛脭脟脬脞脡脕脧脝脢舑舸舳舺舴舲艴莐莣莨莍荺荳莤荴莏莁莕莙荵莔莩荽莃莌莝莛莪莋荾莥莯莈莗莰荿莦莇莮荶莚虙虖蚿蚷"],["d7a1","蛂蛁蛅蚺蚰蛈蚹蚳蚸蛌蚴蚻蚼蛃蚽蚾衒袉袕袨袢袪袚袑袡袟袘袧袙袛袗袤袬袌袓袎覂觖觙觕訰訧訬訞谹谻豜豝豽貥赽赻赹趼跂趹趿跁軘軞軝軜軗軠軡逤逋逑逜逌逡郯郪郰郴郲郳郔郫郬郩酖酘酚酓酕釬釴釱釳釸釤釹釪"],["d840","釫釷釨釮镺閆閈陼陭陫陱陯隿靪頄飥馗傛傕傔傞傋傣傃傌傎傝偨傜傒傂傇兟凔匒匑厤厧喑喨喥喭啷噅喢喓喈喏喵喁喣喒喤啽喌喦啿喕喡喎圌堩堷"],["d8a1","堙堞堧堣堨埵塈堥堜堛堳堿堶堮堹堸堭堬堻奡媯媔媟婺媢媞婸媦婼媥媬媕媮娷媄媊媗媃媋媩婻婽媌媜媏媓媝寪寍寋寔寑寊寎尌尰崷嵃嵫嵁嵋崿崵嵑嵎嵕崳崺嵒崽崱嵙嵂崹嵉崸崼崲崶嵀嵅幄幁彘徦徥徫惉悹惌惢惎惄愔"],["d940","惲愊愖愅惵愓惸惼惾惁愃愘愝愐惿愄愋扊掔掱掰揎揥揨揯揃撝揳揊揠揶揕揲揵摡揟掾揝揜揄揘揓揂揇揌揋揈揰揗揙攲敧敪敤敜敨敥斌斝斞斮旐旒"],["d9a1","晼晬晻暀晱晹晪晲朁椌棓椄棜椪棬棪棱椏棖棷棫棤棶椓椐棳棡椇棌椈楰梴椑棯棆椔棸棐棽棼棨椋椊椗棎棈棝棞棦棴棑椆棔棩椕椥棇欹欻欿欼殔殗殙殕殽毰毲毳氰淼湆湇渟湉溈渼渽湅湢渫渿湁湝湳渜渳湋湀湑渻渃渮湞"],["da40","湨湜湡渱渨湠湱湫渹渢渰湓湥渧湸湤湷湕湹湒湦渵渶湚焠焞焯烻焮焱焣焥焢焲焟焨焺焛牋牚犈犉犆犅犋猒猋猰猢猱猳猧猲猭猦猣猵猌琮琬琰琫琖"],["daa1","琚琡琭琱琤琣琝琩琠琲瓻甯畯畬痧痚痡痦痝痟痤痗皕皒盚睆睇睄睍睅睊睎睋睌矞矬硠硤硥硜硭硱硪确硰硩硨硞硢祴祳祲祰稂稊稃稌稄窙竦竤筊笻筄筈筌筎筀筘筅粢粞粨粡絘絯絣絓絖絧絪絏絭絜絫絒絔絩絑絟絎缾缿罥"],["db40","罦羢羠羡翗聑聏聐胾胔腃腊腒腏腇脽腍脺臦臮臷臸臹舄舼舽舿艵茻菏菹萣菀菨萒菧菤菼菶萐菆菈菫菣莿萁菝菥菘菿菡菋菎菖菵菉萉萏菞萑萆菂菳"],["dba1","菕菺菇菑菪萓菃菬菮菄菻菗菢萛菛菾蛘蛢蛦蛓蛣蛚蛪蛝蛫蛜蛬蛩蛗蛨蛑衈衖衕袺裗袹袸裀袾袶袼袷袽袲褁裉覕覘覗觝觚觛詎詍訹詙詀詗詘詄詅詒詈詑詊詌詏豟貁貀貺貾貰貹貵趄趀趉跘跓跍跇跖跜跏跕跙跈跗跅軯軷軺"],["dc40","軹軦軮軥軵軧軨軶軫軱軬軴軩逭逴逯鄆鄬鄄郿郼鄈郹郻鄁鄀鄇鄅鄃酡酤酟酢酠鈁鈊鈥鈃鈚鈦鈏鈌鈀鈒釿釽鈆鈄鈧鈂鈜鈤鈙鈗鈅鈖镻閍閌閐隇陾隈"],["dca1","隉隃隀雂雈雃雱雰靬靰靮頇颩飫鳦黹亃亄亶傽傿僆傮僄僊傴僈僂傰僁傺傱僋僉傶傸凗剺剸剻剼嗃嗛嗌嗐嗋嗊嗝嗀嗔嗄嗩喿嗒喍嗏嗕嗢嗖嗈嗲嗍嗙嗂圔塓塨塤塏塍塉塯塕塎塝塙塥塛堽塣塱壼嫇嫄嫋媺媸媱媵媰媿嫈媻嫆"],["dd40","媷嫀嫊媴媶嫍媹媐寖寘寙尟尳嵱嵣嵊嵥嵲嵬嵞嵨嵧嵢巰幏幎幊幍幋廅廌廆廋廇彀徯徭惷慉慊愫慅愶愲愮慆愯慏愩慀戠酨戣戥戤揅揱揫搐搒搉搠搤"],["dda1","搳摃搟搕搘搹搷搢搣搌搦搰搨摁搵搯搊搚摀搥搧搋揧搛搮搡搎敯斒旓暆暌暕暐暋暊暙暔晸朠楦楟椸楎楢楱椿楅楪椹楂楗楙楺楈楉椵楬椳椽楥棰楸椴楩楀楯楄楶楘楁楴楌椻楋椷楜楏楑椲楒椯楻椼歆歅歃歂歈歁殛嗀毻毼"],["de40","毹毷毸溛滖滈溏滀溟溓溔溠溱溹滆滒溽滁溞滉溷溰滍溦滏溲溾滃滜滘溙溒溎溍溤溡溿溳滐滊溗溮溣煇煔煒煣煠煁煝煢煲煸煪煡煂煘煃煋煰煟煐煓"],["dea1","煄煍煚牏犍犌犑犐犎猼獂猻猺獀獊獉瑄瑊瑋瑒瑑瑗瑀瑏瑐瑎瑂瑆瑍瑔瓡瓿瓾瓽甝畹畷榃痯瘏瘃痷痾痼痹痸瘐痻痶痭痵痽皙皵盝睕睟睠睒睖睚睩睧睔睙睭矠碇碚碔碏碄碕碅碆碡碃硹碙碀碖硻祼禂祽祹稑稘稙稒稗稕稢稓"],["df40","稛稐窣窢窞竫筦筤筭筴筩筲筥筳筱筰筡筸筶筣粲粴粯綈綆綀綍絿綅絺綎絻綃絼綌綔綄絽綒罭罫罧罨罬羦羥羧翛翜耡腤腠腷腜腩腛腢腲朡腞腶腧腯"],["dfa1","腄腡舝艉艄艀艂艅蓱萿葖葶葹蒏蒍葥葑葀蒆葧萰葍葽葚葙葴葳葝蔇葞萷萺萴葺葃葸萲葅萩菙葋萯葂萭葟葰萹葎葌葒葯蓅蒎萻葇萶萳葨葾葄萫葠葔葮葐蜋蜄蛷蜌蛺蛖蛵蝍蛸蜎蜉蜁蛶蜍蜅裖裋裍裎裞裛裚裌裐覅覛觟觥觤"],["e040","觡觠觢觜触詶誆詿詡訿詷誂誄詵誃誁詴詺谼豋豊豥豤豦貆貄貅賌赨赩趑趌趎趏趍趓趔趐趒跰跠跬跱跮跐跩跣跢跧跲跫跴輆軿輁輀輅輇輈輂輋遒逿"],["e0a1","遄遉逽鄐鄍鄏鄑鄖鄔鄋鄎酮酯鉈鉒鈰鈺鉦鈳鉥鉞銃鈮鉊鉆鉭鉬鉏鉠鉧鉯鈶鉡鉰鈱鉔鉣鉐鉲鉎鉓鉌鉖鈲閟閜閞閛隒隓隑隗雎雺雽雸雵靳靷靸靲頏頍頎颬飶飹馯馲馰馵骭骫魛鳪鳭鳧麀黽僦僔僗僨僳僛僪僝僤僓僬僰僯僣僠"],["e140","凘劀劁勩勫匰厬嘧嘕嘌嘒嗼嘏嘜嘁嘓嘂嗺嘝嘄嗿嗹墉塼墐墘墆墁塿塴墋塺墇墑墎塶墂墈塻墔墏壾奫嫜嫮嫥嫕嫪嫚嫭嫫嫳嫢嫠嫛嫬嫞嫝嫙嫨嫟孷寠"],["e1a1","寣屣嶂嶀嵽嶆嵺嶁嵷嶊嶉嶈嵾嵼嶍嵹嵿幘幙幓廘廑廗廎廜廕廙廒廔彄彃彯徶愬愨慁慞慱慳慒慓慲慬憀慴慔慺慛慥愻慪慡慖戩戧戫搫摍摛摝摴摶摲摳摽摵摦撦摎撂摞摜摋摓摠摐摿搿摬摫摙摥摷敳斠暡暠暟朅朄朢榱榶槉"],["e240","榠槎榖榰榬榼榑榙榎榧榍榩榾榯榿槄榽榤槔榹槊榚槏榳榓榪榡榞槙榗榐槂榵榥槆歊歍歋殞殟殠毃毄毾滎滵滱漃漥滸漷滻漮漉潎漙漚漧漘漻漒滭漊"],["e2a1","漶潳滹滮漭潀漰漼漵滫漇漎潃漅滽滶漹漜滼漺漟漍漞漈漡熇熐熉熀熅熂熏煻熆熁熗牄牓犗犕犓獃獍獑獌瑢瑳瑱瑵瑲瑧瑮甀甂甃畽疐瘖瘈瘌瘕瘑瘊瘔皸瞁睼瞅瞂睮瞀睯睾瞃碲碪碴碭碨硾碫碞碥碠碬碢碤禘禊禋禖禕禔禓"],["e340","禗禈禒禐稫穊稰稯稨稦窨窫窬竮箈箜箊箑箐箖箍箌箛箎箅箘劄箙箤箂粻粿粼粺綧綷緂綣綪緁緀緅綝緎緄緆緋緌綯綹綖綼綟綦綮綩綡緉罳翢翣翥翞"],["e3a1","耤聝聜膉膆膃膇膍膌膋舕蒗蒤蒡蒟蒺蓎蓂蒬蒮蒫蒹蒴蓁蓍蒪蒚蒱蓐蒝蒧蒻蒢蒔蓇蓌蒛蒩蒯蒨蓖蒘蒶蓏蒠蓗蓔蓒蓛蒰蒑虡蜳蜣蜨蝫蝀蜮蜞蜡蜙蜛蝃蜬蝁蜾蝆蜠蜲蜪蜭蜼蜒蜺蜱蜵蝂蜦蜧蜸蜤蜚蜰蜑裷裧裱裲裺裾裮裼裶裻"],["e440","裰裬裫覝覡覟覞觩觫觨誫誙誋誒誏誖谽豨豩賕賏賗趖踉踂跿踍跽踊踃踇踆踅跾踀踄輐輑輎輍鄣鄜鄠鄢鄟鄝鄚鄤鄡鄛酺酲酹酳銥銤鉶銛鉺銠銔銪銍"],["e4a1","銦銚銫鉹銗鉿銣鋮銎銂銕銢鉽銈銡銊銆銌銙銧鉾銇銩銝銋鈭隞隡雿靘靽靺靾鞃鞀鞂靻鞄鞁靿韎韍頖颭颮餂餀餇馝馜駃馹馻馺駂馽駇骱髣髧鬾鬿魠魡魟鳱鳲鳵麧僿儃儰僸儆儇僶僾儋儌僽儊劋劌勱勯噈噂噌嘵噁噊噉噆噘"],["e540","噚噀嘳嘽嘬嘾嘸嘪嘺圚墫墝墱墠墣墯墬墥墡壿嫿嫴嫽嫷嫶嬃嫸嬂嫹嬁嬇嬅嬏屧嶙嶗嶟嶒嶢嶓嶕嶠嶜嶡嶚嶞幩幝幠幜緳廛廞廡彉徲憋憃慹憱憰憢憉"],["e5a1","憛憓憯憭憟憒憪憡憍慦憳戭摮摰撖撠撅撗撜撏撋撊撌撣撟摨撱撘敶敺敹敻斲斳暵暰暩暲暷暪暯樀樆樗槥槸樕槱槤樠槿槬槢樛樝槾樧槲槮樔槷槧橀樈槦槻樍槼槫樉樄樘樥樏槶樦樇槴樖歑殥殣殢殦氁氀毿氂潁漦潾澇濆澒"],["e640","澍澉澌潢潏澅潚澖潶潬澂潕潲潒潐潗澔澓潝漀潡潫潽潧澐潓澋潩潿澕潣潷潪潻熲熯熛熰熠熚熩熵熝熥熞熤熡熪熜熧熳犘犚獘獒獞獟獠獝獛獡獚獙"],["e6a1","獢璇璉璊璆璁瑽璅璈瑼瑹甈甇畾瘥瘞瘙瘝瘜瘣瘚瘨瘛皜皝皞皛瞍瞏瞉瞈磍碻磏磌磑磎磔磈磃磄磉禚禡禠禜禢禛歶稹窲窴窳箷篋箾箬篎箯箹篊箵糅糈糌糋緷緛緪緧緗緡縃緺緦緶緱緰緮緟罶羬羰羭翭翫翪翬翦翨聤聧膣膟"],["e740","膞膕膢膙膗舖艏艓艒艐艎艑蔤蔻蔏蔀蔩蔎蔉蔍蔟蔊蔧蔜蓻蔫蓺蔈蔌蓴蔪蓲蔕蓷蓫蓳蓼蔒蓪蓩蔖蓾蔨蔝蔮蔂蓽蔞蓶蔱蔦蓧蓨蓰蓯蓹蔘蔠蔰蔋蔙蔯虢"],["e7a1","蝖蝣蝤蝷蟡蝳蝘蝔蝛蝒蝡蝚蝑蝞蝭蝪蝐蝎蝟蝝蝯蝬蝺蝮蝜蝥蝏蝻蝵蝢蝧蝩衚褅褌褔褋褗褘褙褆褖褑褎褉覢覤覣觭觰觬諏諆誸諓諑諔諕誻諗誾諀諅諘諃誺誽諙谾豍貏賥賟賙賨賚賝賧趠趜趡趛踠踣踥踤踮踕踛踖踑踙踦踧"],["e840","踔踒踘踓踜踗踚輬輤輘輚輠輣輖輗遳遰遯遧遫鄯鄫鄩鄪鄲鄦鄮醅醆醊醁醂醄醀鋐鋃鋄鋀鋙銶鋏鋱鋟鋘鋩鋗鋝鋌鋯鋂鋨鋊鋈鋎鋦鋍鋕鋉鋠鋞鋧鋑鋓"],["e8a1","銵鋡鋆銴镼閬閫閮閰隤隢雓霅霈霂靚鞊鞎鞈韐韏頞頝頦頩頨頠頛頧颲餈飺餑餔餖餗餕駜駍駏駓駔駎駉駖駘駋駗駌骳髬髫髳髲髱魆魃魧魴魱魦魶魵魰魨魤魬鳼鳺鳽鳿鳷鴇鴀鳹鳻鴈鴅鴄麃黓鼏鼐儜儓儗儚儑凞匴叡噰噠噮"],["e940","噳噦噣噭噲噞噷圜圛壈墽壉墿墺壂墼壆嬗嬙嬛嬡嬔嬓嬐嬖嬨嬚嬠嬞寯嶬嶱嶩嶧嶵嶰嶮嶪嶨嶲嶭嶯嶴幧幨幦幯廩廧廦廨廥彋徼憝憨憖懅憴懆懁懌憺"],["e9a1","憿憸憌擗擖擐擏擉撽撉擃擛擳擙攳敿敼斢曈暾曀曊曋曏暽暻暺曌朣樴橦橉橧樲橨樾橝橭橶橛橑樨橚樻樿橁橪橤橐橏橔橯橩橠樼橞橖橕橍橎橆歕歔歖殧殪殫毈毇氄氃氆澭濋澣濇澼濎濈潞濄澽澞濊澨瀄澥澮澺澬澪濏澿澸"],["ea40","澢濉澫濍澯澲澰燅燂熿熸燖燀燁燋燔燊燇燏熽燘熼燆燚燛犝犞獩獦獧獬獥獫獪瑿璚璠璔璒璕璡甋疀瘯瘭瘱瘽瘳瘼瘵瘲瘰皻盦瞚瞝瞡瞜瞛瞢瞣瞕瞙"],["eaa1","瞗磝磩磥磪磞磣磛磡磢磭磟磠禤穄穈穇窶窸窵窱窷篞篣篧篝篕篥篚篨篹篔篪篢篜篫篘篟糒糔糗糐糑縒縡縗縌縟縠縓縎縜縕縚縢縋縏縖縍縔縥縤罃罻罼罺羱翯耪耩聬膱膦膮膹膵膫膰膬膴膲膷膧臲艕艖艗蕖蕅蕫蕍蕓蕡蕘"],["eb40","蕀蕆蕤蕁蕢蕄蕑蕇蕣蔾蕛蕱蕎蕮蕵蕕蕧蕠薌蕦蕝蕔蕥蕬虣虥虤螛螏螗螓螒螈螁螖螘蝹螇螣螅螐螑螝螄螔螜螚螉褞褦褰褭褮褧褱褢褩褣褯褬褟觱諠"],["eba1","諢諲諴諵諝謔諤諟諰諈諞諡諨諿諯諻貑貒貐賵賮賱賰賳赬赮趥趧踳踾踸蹀蹅踶踼踽蹁踰踿躽輶輮輵輲輹輷輴遶遹遻邆郺鄳鄵鄶醓醐醑醍醏錧錞錈錟錆錏鍺錸錼錛錣錒錁鍆錭錎錍鋋錝鋺錥錓鋹鋷錴錂錤鋿錩錹錵錪錔錌"],["ec40","錋鋾錉錀鋻錖閼闍閾閹閺閶閿閵閽隩雔霋霒霐鞙鞗鞔韰韸頵頯頲餤餟餧餩馞駮駬駥駤駰駣駪駩駧骹骿骴骻髶髺髹髷鬳鮀鮅鮇魼魾魻鮂鮓鮒鮐魺鮕"],["eca1","魽鮈鴥鴗鴠鴞鴔鴩鴝鴘鴢鴐鴙鴟麈麆麇麮麭黕黖黺鼒鼽儦儥儢儤儠儩勴嚓嚌嚍嚆嚄嚃噾嚂噿嚁壖壔壏壒嬭嬥嬲嬣嬬嬧嬦嬯嬮孻寱寲嶷幬幪徾徻懃憵憼懧懠懥懤懨懞擯擩擣擫擤擨斁斀斶旚曒檍檖檁檥檉檟檛檡檞檇檓檎"],["ed40","檕檃檨檤檑橿檦檚檅檌檒歛殭氉濌澩濴濔濣濜濭濧濦濞濲濝濢濨燡燱燨燲燤燰燢獳獮獯璗璲璫璐璪璭璱璥璯甐甑甒甏疄癃癈癉癇皤盩瞵瞫瞲瞷瞶"],["eda1","瞴瞱瞨矰磳磽礂磻磼磲礅磹磾礄禫禨穜穛穖穘穔穚窾竀竁簅簏篲簀篿篻簎篴簋篳簂簉簃簁篸篽簆篰篱簐簊糨縭縼繂縳顈縸縪繉繀繇縩繌縰縻縶繄縺罅罿罾罽翴翲耬膻臄臌臊臅臇膼臩艛艚艜薃薀薏薧薕薠薋薣蕻薤薚薞"],["ee40","蕷蕼薉薡蕺蕸蕗薎薖薆薍薙薝薁薢薂薈薅蕹蕶薘薐薟虨螾螪螭蟅螰螬螹螵螼螮蟉蟃蟂蟌螷螯蟄蟊螴螶螿螸螽蟞螲褵褳褼褾襁襒褷襂覭覯覮觲觳謞"],["eea1","謘謖謑謅謋謢謏謒謕謇謍謈謆謜謓謚豏豰豲豱豯貕貔賹赯蹎蹍蹓蹐蹌蹇轃轀邅遾鄸醚醢醛醙醟醡醝醠鎡鎃鎯鍤鍖鍇鍼鍘鍜鍶鍉鍐鍑鍠鍭鎏鍌鍪鍹鍗鍕鍒鍏鍱鍷鍻鍡鍞鍣鍧鎀鍎鍙闇闀闉闃闅閷隮隰隬霠霟霘霝霙鞚鞡鞜"],["ef40","鞞鞝韕韔韱顁顄顊顉顅顃餥餫餬餪餳餲餯餭餱餰馘馣馡騂駺駴駷駹駸駶駻駽駾駼騃骾髾髽鬁髼魈鮚鮨鮞鮛鮦鮡鮥鮤鮆鮢鮠鮯鴳鵁鵧鴶鴮鴯鴱鴸鴰"],["efa1","鵅鵂鵃鴾鴷鵀鴽翵鴭麊麉麍麰黈黚黻黿鼤鼣鼢齔龠儱儭儮嚘嚜嚗嚚嚝嚙奰嬼屩屪巀幭幮懘懟懭懮懱懪懰懫懖懩擿攄擽擸攁攃擼斔旛曚曛曘櫅檹檽櫡櫆檺檶檷櫇檴檭歞毉氋瀇瀌瀍瀁瀅瀔瀎濿瀀濻瀦濼濷瀊爁燿燹爃燽獶"],["f040","璸瓀璵瓁璾璶璻瓂甔甓癜癤癙癐癓癗癚皦皽盬矂瞺磿礌礓礔礉礐礒礑禭禬穟簜簩簙簠簟簭簝簦簨簢簥簰繜繐繖繣繘繢繟繑繠繗繓羵羳翷翸聵臑臒"],["f0a1","臐艟艞薴藆藀藃藂薳薵薽藇藄薿藋藎藈藅薱薶藒蘤薸薷薾虩蟧蟦蟢蟛蟫蟪蟥蟟蟳蟤蟔蟜蟓蟭蟘蟣螤蟗蟙蠁蟴蟨蟝襓襋襏襌襆襐襑襉謪謧謣謳謰謵譇謯謼謾謱謥謷謦謶謮謤謻謽謺豂豵貙貘貗賾贄贂贀蹜蹢蹠蹗蹖蹞蹥蹧"],["f140","蹛蹚蹡蹝蹩蹔轆轇轈轋鄨鄺鄻鄾醨醥醧醯醪鎵鎌鎒鎷鎛鎝鎉鎧鎎鎪鎞鎦鎕鎈鎙鎟鎍鎱鎑鎲鎤鎨鎴鎣鎥闒闓闑隳雗雚巂雟雘雝霣霢霥鞬鞮鞨鞫鞤鞪"],["f1a1","鞢鞥韗韙韖韘韺顐顑顒颸饁餼餺騏騋騉騍騄騑騊騅騇騆髀髜鬈鬄鬅鬩鬵魊魌魋鯇鯆鯃鮿鯁鮵鮸鯓鮶鯄鮹鮽鵜鵓鵏鵊鵛鵋鵙鵖鵌鵗鵒鵔鵟鵘鵚麎麌黟鼁鼀鼖鼥鼫鼪鼩鼨齌齕儴儵劖勷厴嚫嚭嚦嚧嚪嚬壚壝壛夒嬽嬾嬿巃幰"],["f240","徿懻攇攐攍攉攌攎斄旞旝曞櫧櫠櫌櫑櫙櫋櫟櫜櫐櫫櫏櫍櫞歠殰氌瀙瀧瀠瀖瀫瀡瀢瀣瀩瀗瀤瀜瀪爌爊爇爂爅犥犦犤犣犡瓋瓅璷瓃甖癠矉矊矄矱礝礛"],["f2a1","礡礜礗礞禰穧穨簳簼簹簬簻糬糪繶繵繸繰繷繯繺繲繴繨罋罊羃羆羷翽翾聸臗臕艤艡艣藫藱藭藙藡藨藚藗藬藲藸藘藟藣藜藑藰藦藯藞藢蠀蟺蠃蟶蟷蠉蠌蠋蠆蟼蠈蟿蠊蠂襢襚襛襗襡襜襘襝襙覈覷覶觶譐譈譊譀譓譖譔譋譕"],["f340","譑譂譒譗豃豷豶貚贆贇贉趬趪趭趫蹭蹸蹳蹪蹯蹻軂轒轑轏轐轓辴酀鄿醰醭鏞鏇鏏鏂鏚鏐鏹鏬鏌鏙鎩鏦鏊鏔鏮鏣鏕鏄鏎鏀鏒鏧镽闚闛雡霩霫霬霨霦"],["f3a1","鞳鞷鞶韝韞韟顜顙顝顗颿颽颻颾饈饇饃馦馧騚騕騥騝騤騛騢騠騧騣騞騜騔髂鬋鬊鬎鬌鬷鯪鯫鯠鯞鯤鯦鯢鯰鯔鯗鯬鯜鯙鯥鯕鯡鯚鵷鶁鶊鶄鶈鵱鶀鵸鶆鶋鶌鵽鵫鵴鵵鵰鵩鶅鵳鵻鶂鵯鵹鵿鶇鵨麔麑黀黼鼭齀齁齍齖齗齘匷嚲"],["f440","嚵嚳壣孅巆巇廮廯忀忁懹攗攖攕攓旟曨曣曤櫳櫰櫪櫨櫹櫱櫮櫯瀼瀵瀯瀷瀴瀱灂瀸瀿瀺瀹灀瀻瀳灁爓爔犨獽獼璺皫皪皾盭矌矎矏矍矲礥礣礧礨礤礩"],["f4a1","禲穮穬穭竷籉籈籊籇籅糮繻繾纁纀羺翿聹臛臙舋艨艩蘢藿蘁藾蘛蘀藶蘄蘉蘅蘌藽蠙蠐蠑蠗蠓蠖襣襦覹觷譠譪譝譨譣譥譧譭趮躆躈躄轙轖轗轕轘轚邍酃酁醷醵醲醳鐋鐓鏻鐠鐏鐔鏾鐕鐐鐨鐙鐍鏵鐀鏷鐇鐎鐖鐒鏺鐉鏸鐊鏿"],["f540","鏼鐌鏶鐑鐆闞闠闟霮霯鞹鞻韽韾顠顢顣顟飁飂饐饎饙饌饋饓騲騴騱騬騪騶騩騮騸騭髇髊髆鬐鬒鬑鰋鰈鯷鰅鰒鯸鱀鰇鰎鰆鰗鰔鰉鶟鶙鶤鶝鶒鶘鶐鶛"],["f5a1","鶠鶔鶜鶪鶗鶡鶚鶢鶨鶞鶣鶿鶩鶖鶦鶧麙麛麚黥黤黧黦鼰鼮齛齠齞齝齙龑儺儹劘劗囃嚽嚾孈孇巋巏廱懽攛欂櫼欃櫸欀灃灄灊灈灉灅灆爝爚爙獾甗癪矐礭礱礯籔籓糲纊纇纈纋纆纍罍羻耰臝蘘蘪蘦蘟蘣蘜蘙蘧蘮蘡蘠蘩蘞蘥"],["f640","蠩蠝蠛蠠蠤蠜蠫衊襭襩襮襫觺譹譸譅譺譻贐贔趯躎躌轞轛轝酆酄酅醹鐿鐻鐶鐩鐽鐼鐰鐹鐪鐷鐬鑀鐱闥闤闣霵霺鞿韡顤飉飆飀饘饖騹騽驆驄驂驁騺"],["f6a1","騿髍鬕鬗鬘鬖鬺魒鰫鰝鰜鰬鰣鰨鰩鰤鰡鶷鶶鶼鷁鷇鷊鷏鶾鷅鷃鶻鶵鷎鶹鶺鶬鷈鶱鶭鷌鶳鷍鶲鹺麜黫黮黭鼛鼘鼚鼱齎齥齤龒亹囆囅囋奱孋孌巕巑廲攡攠攦攢欋欈欉氍灕灖灗灒爞爟犩獿瓘瓕瓙瓗癭皭礵禴穰穱籗籜籙籛籚"],["f740","糴糱纑罏羇臞艫蘴蘵蘳蘬蘲蘶蠬蠨蠦蠪蠥襱覿覾觻譾讄讂讆讅譿贕躕躔躚躒躐躖躗轠轢酇鑌鑐鑊鑋鑏鑇鑅鑈鑉鑆霿韣顪顩飋饔饛驎驓驔驌驏驈驊"],["f7a1","驉驒驐髐鬙鬫鬻魖魕鱆鱈鰿鱄鰹鰳鱁鰼鰷鰴鰲鰽鰶鷛鷒鷞鷚鷋鷐鷜鷑鷟鷩鷙鷘鷖鷵鷕鷝麶黰鼵鼳鼲齂齫龕龢儽劙壨壧奲孍巘蠯彏戁戃戄攩攥斖曫欑欒欏毊灛灚爢玂玁玃癰矔籧籦纕艬蘺虀蘹蘼蘱蘻蘾蠰蠲蠮蠳襶襴襳觾"],["f840","讌讎讋讈豅贙躘轤轣醼鑢鑕鑝鑗鑞韄韅頀驖驙鬞鬟鬠鱒鱘鱐鱊鱍鱋鱕鱙鱌鱎鷻鷷鷯鷣鷫鷸鷤鷶鷡鷮鷦鷲鷰鷢鷬鷴鷳鷨鷭黂黐黲黳鼆鼜鼸鼷鼶齃齏"],["f8a1","齱齰齮齯囓囍孎屭攭曭曮欓灟灡灝灠爣瓛瓥矕礸禷禶籪纗羉艭虃蠸蠷蠵衋讔讕躞躟躠躝醾醽釂鑫鑨鑩雥靆靃靇韇韥驞髕魙鱣鱧鱦鱢鱞鱠鸂鷾鸇鸃鸆鸅鸀鸁鸉鷿鷽鸄麠鼞齆齴齵齶囔攮斸欘欙欗欚灢爦犪矘矙礹籩籫糶纚"],["f940","纘纛纙臠臡虆虇虈襹襺襼襻觿讘讙躥躤躣鑮鑭鑯鑱鑳靉顲饟鱨鱮鱭鸋鸍鸐鸏鸒鸑麡黵鼉齇齸齻齺齹圞灦籯蠼趲躦釃鑴鑸鑶鑵驠鱴鱳鱱鱵鸔鸓黶鼊"],["f9a1","龤灨灥糷虪蠾蠽蠿讞貜躩軉靋顳顴飌饡馫驤驦驧鬤鸕鸗齈戇欞爧虌躨钂钀钁驩驨鬮鸙爩虋讟钃鱹麷癵驫鱺鸝灩灪麤齾齉龘碁銹裏墻恒粧嫺╔╦╗╠╬╣╚╩╝╒╤╕╞╪╡╘╧╛╓╥╖╟╫╢╙╨╜║═╭╮╰╯▓"]]');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/eucjp.json":
/*!*************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/eucjp.json ***!
  \*************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["0","\\u0000",127],["8ea1","｡",62],["a1a1","　、。，．・：；？！゛゜´｀¨＾￣＿ヽヾゝゞ〃仝々〆〇ー―‐／＼～∥｜…‥‘’“”（）〔〕［］｛｝〈",9,"＋－±×÷＝≠＜＞≦≧∞∴♂♀°′″℃￥＄￠￡％＃＆＊＠§☆★○●◎◇"],["a2a1","◆□■△▲▽▼※〒→←↑↓〓"],["a2ba","∈∋⊆⊇⊂⊃∪∩"],["a2ca","∧∨￢⇒⇔∀∃"],["a2dc","∠⊥⌒∂∇≡≒≪≫√∽∝∵∫∬"],["a2f2","Å‰♯♭♪†‡¶"],["a2fe","◯"],["a3b0","０",9],["a3c1","Ａ",25],["a3e1","ａ",25],["a4a1","ぁ",82],["a5a1","ァ",85],["a6a1","Α",16,"Σ",6],["a6c1","α",16,"σ",6],["a7a1","А",5,"ЁЖ",25],["a7d1","а",5,"ёж",25],["a8a1","─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂"],["ada1","①",19,"Ⅰ",9],["adc0","㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㎡"],["addf","㍻〝〟№㏍℡㊤",4,"㈱㈲㈹㍾㍽㍼≒≡∫∮∑√⊥∠∟⊿∵∩∪"],["b0a1","亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭"],["b1a1","院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応"],["b2a1","押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改"],["b3a1","魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱"],["b4a1","粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄"],["b5a1","機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京"],["b6a1","供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈"],["b7a1","掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲"],["b8a1","検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向"],["b9a1","后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込"],["baa1","此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷"],["bba1","察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時"],["bca1","次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周"],["bda1","宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償"],["bea1","勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾"],["bfa1","拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾"],["c0a1","澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線"],["c1a1","繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎"],["c2a1","臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只"],["c3a1","叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵"],["c4a1","帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓"],["c5a1","邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到"],["c6a1","董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入"],["c7a1","如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦"],["c8a1","函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美"],["c9a1","鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服"],["caa1","福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋"],["cba1","法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満"],["cca1","漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉愈油癒"],["cda1","諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃"],["cea1","痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯"],["cfa1","蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕"],["d0a1","弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲"],["d1a1","僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨"],["d2a1","辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨"],["d3a1","咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉"],["d4a1","圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩"],["d5a1","奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓"],["d6a1","屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏"],["d7a1","廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚"],["d8a1","悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛"],["d9a1","戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼"],["daa1","據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼"],["dba1","曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘椢椦棡椌棍"],["dca1","棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣"],["dda1","檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾"],["dea1","沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌"],["dfa1","漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼"],["e0a1","燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱"],["e1a1","瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰"],["e2a1","癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬"],["e3a1","磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐"],["e4a1","筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆"],["e5a1","紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺"],["e6a1","罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋"],["e7a1","隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙"],["e8a1","茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈"],["e9a1","蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙"],["eaa1","蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞"],["eba1","襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫"],["eca1","譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊"],["eda1","蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸"],["eea1","遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮"],["efa1","錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞"],["f0a1","陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰"],["f1a1","顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷"],["f2a1","髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈"],["f3a1","鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠"],["f4a1","堯槇遙瑤凜熙"],["f9a1","纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德"],["faa1","忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱"],["fba1","犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚"],["fca1","釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑"],["fcf1","ⅰ",9,"￢￤＇＂"],["8fa2af","˘ˇ¸˙˝¯˛˚～΄΅"],["8fa2c2","¡¦¿"],["8fa2eb","ºª©®™¤№"],["8fa6e1","ΆΈΉΊΪ"],["8fa6e7","Ό"],["8fa6e9","ΎΫ"],["8fa6ec","Ώ"],["8fa6f1","άέήίϊΐόςύϋΰώ"],["8fa7c2","Ђ",10,"ЎЏ"],["8fa7f2","ђ",10,"ўџ"],["8fa9a1","ÆĐ"],["8fa9a4","Ħ"],["8fa9a6","Ĳ"],["8fa9a8","ŁĿ"],["8fa9ab","ŊØŒ"],["8fa9af","ŦÞ"],["8fa9c1","æđðħıĳĸłŀŉŋøœßŧþ"],["8faaa1","ÁÀÄÂĂǍĀĄÅÃĆĈČÇĊĎÉÈËÊĚĖĒĘ"],["8faaba","ĜĞĢĠĤÍÌÏÎǏİĪĮĨĴĶĹĽĻŃŇŅÑÓÒÖÔǑŐŌÕŔŘŖŚŜŠŞŤŢÚÙÜÛŬǓŰŪŲŮŨǗǛǙǕŴÝŸŶŹŽŻ"],["8faba1","áàäâăǎāąåãćĉčçċďéèëêěėēęǵĝğ"],["8fabbd","ġĥíìïîǐ"],["8fabc5","īįĩĵķĺľļńňņñóòöôǒőōõŕřŗśŝšşťţúùüûŭǔűūųůũǘǜǚǖŵýÿŷźžż"],["8fb0a1","丂丄丅丌丒丟丣两丨丫丮丯丰丵乀乁乄乇乑乚乜乣乨乩乴乵乹乿亍亖亗亝亯亹仃仐仚仛仠仡仢仨仯仱仳仵份仾仿伀伂伃伈伋伌伒伕伖众伙伮伱你伳伵伷伹伻伾佀佂佈佉佋佌佒佔佖佘佟佣佪佬佮佱佷佸佹佺佽佾侁侂侄"],["8fb1a1","侅侉侊侌侎侐侒侓侔侗侙侚侞侟侲侷侹侻侼侽侾俀俁俅俆俈俉俋俌俍俏俒俜俠俢俰俲俼俽俿倀倁倄倇倊倌倎倐倓倗倘倛倜倝倞倢倧倮倰倲倳倵偀偁偂偅偆偊偌偎偑偒偓偗偙偟偠偢偣偦偧偪偭偰偱倻傁傃傄傆傊傎傏傐"],["8fb2a1","傒傓傔傖傛傜傞",4,"傪傯傰傹傺傽僀僃僄僇僌僎僐僓僔僘僜僝僟僢僤僦僨僩僯僱僶僺僾儃儆儇儈儋儌儍儎僲儐儗儙儛儜儝儞儣儧儨儬儭儯儱儳儴儵儸儹兂兊兏兓兕兗兘兟兤兦兾冃冄冋冎冘冝冡冣冭冸冺冼冾冿凂"],["8fb3a1","凈减凑凒凓凕凘凞凢凥凮凲凳凴凷刁刂刅划刓刕刖刘刢刨刱刲刵刼剅剉剕剗剘剚剜剟剠剡剦剮剷剸剹劀劂劅劊劌劓劕劖劗劘劚劜劤劥劦劧劯劰劶劷劸劺劻劽勀勄勆勈勌勏勑勔勖勛勜勡勥勨勩勪勬勰勱勴勶勷匀匃匊匋"],["8fb4a1","匌匑匓匘匛匜匞匟匥匧匨匩匫匬匭匰匲匵匼匽匾卂卌卋卙卛卡卣卥卬卭卲卹卾厃厇厈厎厓厔厙厝厡厤厪厫厯厲厴厵厷厸厺厽叀叅叏叒叓叕叚叝叞叠另叧叵吂吓吚吡吧吨吪启吱吴吵呃呄呇呍呏呞呢呤呦呧呩呫呭呮呴呿"],["8fb5a1","咁咃咅咈咉咍咑咕咖咜咟咡咦咧咩咪咭咮咱咷咹咺咻咿哆哊响哎哠哪哬哯哶哼哾哿唀唁唅唈唉唌唍唎唕唪唫唲唵唶唻唼唽啁啇啉啊啍啐啑啘啚啛啞啠啡啤啦啿喁喂喆喈喎喏喑喒喓喔喗喣喤喭喲喿嗁嗃嗆嗉嗋嗌嗎嗑嗒"],["8fb6a1","嗓嗗嗘嗛嗞嗢嗩嗶嗿嘅嘈嘊嘍",5,"嘙嘬嘰嘳嘵嘷嘹嘻嘼嘽嘿噀噁噃噄噆噉噋噍噏噔噞噠噡噢噣噦噩噭噯噱噲噵嚄嚅嚈嚋嚌嚕嚙嚚嚝嚞嚟嚦嚧嚨嚩嚫嚬嚭嚱嚳嚷嚾囅囉囊囋囏囐囌囍囙囜囝囟囡囤",4,"囱囫园"],["8fb7a1","囶囷圁圂圇圊圌圑圕圚圛圝圠圢圣圤圥圩圪圬圮圯圳圴圽圾圿坅坆坌坍坒坢坥坧坨坫坭",4,"坳坴坵坷坹坺坻坼坾垁垃垌垔垗垙垚垜垝垞垟垡垕垧垨垩垬垸垽埇埈埌埏埕埝埞埤埦埧埩埭埰埵埶埸埽埾埿堃堄堈堉埡"],["8fb8a1","堌堍堛堞堟堠堦堧堭堲堹堿塉塌塍塏塐塕塟塡塤塧塨塸塼塿墀墁墇墈墉墊墌墍墏墐墔墖墝墠墡墢墦墩墱墲壄墼壂壈壍壎壐壒壔壖壚壝壡壢壩壳夅夆夋夌夒夓夔虁夝夡夣夤夨夯夰夳夵夶夿奃奆奒奓奙奛奝奞奟奡奣奫奭"],["8fb9a1","奯奲奵奶她奻奼妋妌妎妒妕妗妟妤妧妭妮妯妰妳妷妺妼姁姃姄姈姊姍姒姝姞姟姣姤姧姮姯姱姲姴姷娀娄娌娍娎娒娓娞娣娤娧娨娪娭娰婄婅婇婈婌婐婕婞婣婥婧婭婷婺婻婾媋媐媓媖媙媜媞媟媠媢媧媬媱媲媳媵媸媺媻媿"],["8fbaa1","嫄嫆嫈嫏嫚嫜嫠嫥嫪嫮嫵嫶嫽嬀嬁嬈嬗嬴嬙嬛嬝嬡嬥嬭嬸孁孋孌孒孖孞孨孮孯孼孽孾孿宁宄宆宊宎宐宑宓宔宖宨宩宬宭宯宱宲宷宺宼寀寁寍寏寖",4,"寠寯寱寴寽尌尗尞尟尣尦尩尫尬尮尰尲尵尶屙屚屜屢屣屧屨屩"],["8fbba1","屭屰屴屵屺屻屼屽岇岈岊岏岒岝岟岠岢岣岦岪岲岴岵岺峉峋峒峝峗峮峱峲峴崁崆崍崒崫崣崤崦崧崱崴崹崽崿嵂嵃嵆嵈嵕嵑嵙嵊嵟嵠嵡嵢嵤嵪嵭嵰嵹嵺嵾嵿嶁嶃嶈嶊嶒嶓嶔嶕嶙嶛嶟嶠嶧嶫嶰嶴嶸嶹巃巇巋巐巎巘巙巠巤"],["8fbca1","巩巸巹帀帇帍帒帔帕帘帟帠帮帨帲帵帾幋幐幉幑幖幘幛幜幞幨幪",4,"幰庀庋庎庢庤庥庨庪庬庱庳庽庾庿廆廌廋廎廑廒廔廕廜廞廥廫异弆弇弈弎弙弜弝弡弢弣弤弨弫弬弮弰弴弶弻弽弿彀彄彅彇彍彐彔彘彛彠彣彤彧"],["8fbda1","彯彲彴彵彸彺彽彾徉徍徏徖徜徝徢徧徫徤徬徯徰徱徸忄忇忈忉忋忐",4,"忞忡忢忨忩忪忬忭忮忯忲忳忶忺忼怇怊怍怓怔怗怘怚怟怤怭怳怵恀恇恈恉恌恑恔恖恗恝恡恧恱恾恿悂悆悈悊悎悑悓悕悘悝悞悢悤悥您悰悱悷"],["8fbea1","悻悾惂惄惈惉惊惋惎惏惔惕惙惛惝惞惢惥惲惵惸惼惽愂愇愊愌愐",4,"愖愗愙愜愞愢愪愫愰愱愵愶愷愹慁慅慆慉慞慠慬慲慸慻慼慿憀憁憃憄憋憍憒憓憗憘憜憝憟憠憥憨憪憭憸憹憼懀懁懂懎懏懕懜懝懞懟懡懢懧懩懥"],["8fbfa1","懬懭懯戁戃戄戇戓戕戜戠戢戣戧戩戫戹戽扂扃扄扆扌扐扑扒扔扖扚扜扤扭扯扳扺扽抍抎抏抐抦抨抳抶抷抺抾抿拄拎拕拖拚拪拲拴拼拽挃挄挊挋挍挐挓挖挘挩挪挭挵挶挹挼捁捂捃捄捆捊捋捎捒捓捔捘捛捥捦捬捭捱捴捵"],["8fc0a1","捸捼捽捿掂掄掇掊掐掔掕掙掚掞掤掦掭掮掯掽揁揅揈揎揑揓揔揕揜揠揥揪揬揲揳揵揸揹搉搊搐搒搔搘搞搠搢搤搥搩搪搯搰搵搽搿摋摏摑摒摓摔摚摛摜摝摟摠摡摣摭摳摴摻摽撅撇撏撐撑撘撙撛撝撟撡撣撦撨撬撳撽撾撿"],["8fc1a1","擄擉擊擋擌擎擐擑擕擗擤擥擩擪擭擰擵擷擻擿攁攄攈攉攊攏攓攔攖攙攛攞攟攢攦攩攮攱攺攼攽敃敇敉敐敒敔敟敠敧敫敺敽斁斅斊斒斕斘斝斠斣斦斮斲斳斴斿旂旈旉旎旐旔旖旘旟旰旲旴旵旹旾旿昀昄昈昉昍昑昒昕昖昝"],["8fc2a1","昞昡昢昣昤昦昩昪昫昬昮昰昱昳昹昷晀晅晆晊晌晑晎晗晘晙晛晜晠晡曻晪晫晬晾晳晵晿晷晸晹晻暀晼暋暌暍暐暒暙暚暛暜暟暠暤暭暱暲暵暻暿曀曂曃曈曌曎曏曔曛曟曨曫曬曮曺朅朇朎朓朙朜朠朢朳朾杅杇杈杌杔杕杝"],["8fc3a1","杦杬杮杴杶杻极构枎枏枑枓枖枘枙枛枰枱枲枵枻枼枽柹柀柂柃柅柈柉柒柗柙柜柡柦柰柲柶柷桒栔栙栝栟栨栧栬栭栯栰栱栳栻栿桄桅桊桌桕桗桘桛桫桮",4,"桵桹桺桻桼梂梄梆梈梖梘梚梜梡梣梥梩梪梮梲梻棅棈棌棏"],["8fc4a1","棐棑棓棖棙棜棝棥棨棪棫棬棭棰棱棵棶棻棼棽椆椉椊椐椑椓椖椗椱椳椵椸椻楂楅楉楎楗楛楣楤楥楦楨楩楬楰楱楲楺楻楿榀榍榒榖榘榡榥榦榨榫榭榯榷榸榺榼槅槈槑槖槗槢槥槮槯槱槳槵槾樀樁樃樏樑樕樚樝樠樤樨樰樲"],["8fc5a1","樴樷樻樾樿橅橆橉橊橎橐橑橒橕橖橛橤橧橪橱橳橾檁檃檆檇檉檋檑檛檝檞檟檥檫檯檰檱檴檽檾檿櫆櫉櫈櫌櫐櫔櫕櫖櫜櫝櫤櫧櫬櫰櫱櫲櫼櫽欂欃欆欇欉欏欐欑欗欛欞欤欨欫欬欯欵欶欻欿歆歊歍歒歖歘歝歠歧歫歮歰歵歽"],["8fc6a1","歾殂殅殗殛殟殠殢殣殨殩殬殭殮殰殸殹殽殾毃毄毉毌毖毚毡毣毦毧毮毱毷毹毿氂氄氅氉氍氎氐氒氙氟氦氧氨氬氮氳氵氶氺氻氿汊汋汍汏汒汔汙汛汜汫汭汯汴汶汸汹汻沅沆沇沉沔沕沗沘沜沟沰沲沴泂泆泍泏泐泑泒泔泖"],["8fc7a1","泚泜泠泧泩泫泬泮泲泴洄洇洊洎洏洑洓洚洦洧洨汧洮洯洱洹洼洿浗浞浟浡浥浧浯浰浼涂涇涑涒涔涖涗涘涪涬涴涷涹涽涿淄淈淊淎淏淖淛淝淟淠淢淥淩淯淰淴淶淼渀渄渞渢渧渲渶渹渻渼湄湅湈湉湋湏湑湒湓湔湗湜湝湞"],["8fc8a1","湢湣湨湳湻湽溍溓溙溠溧溭溮溱溳溻溿滀滁滃滇滈滊滍滎滏滫滭滮滹滻滽漄漈漊漌漍漖漘漚漛漦漩漪漯漰漳漶漻漼漭潏潑潒潓潗潙潚潝潞潡潢潨潬潽潾澃澇澈澋澌澍澐澒澓澔澖澚澟澠澥澦澧澨澮澯澰澵澶澼濅濇濈濊"],["8fc9a1","濚濞濨濩濰濵濹濼濽瀀瀅瀆瀇瀍瀗瀠瀣瀯瀴瀷瀹瀼灃灄灈灉灊灋灔灕灝灞灎灤灥灬灮灵灶灾炁炅炆炔",4,"炛炤炫炰炱炴炷烊烑烓烔烕烖烘烜烤烺焃",4,"焋焌焏焞焠焫焭焯焰焱焸煁煅煆煇煊煋煐煒煗煚煜煞煠"],["8fcaa1","煨煹熀熅熇熌熒熚熛熠熢熯熰熲熳熺熿燀燁燄燋燌燓燖燙燚燜燸燾爀爇爈爉爓爗爚爝爟爤爫爯爴爸爹牁牂牃牅牎牏牐牓牕牖牚牜牞牠牣牨牫牮牯牱牷牸牻牼牿犄犉犍犎犓犛犨犭犮犱犴犾狁狇狉狌狕狖狘狟狥狳狴狺狻"],["8fcba1","狾猂猄猅猇猋猍猒猓猘猙猞猢猤猧猨猬猱猲猵猺猻猽獃獍獐獒獖獘獝獞獟獠獦獧獩獫獬獮獯獱獷獹獼玀玁玃玅玆玎玐玓玕玗玘玜玞玟玠玢玥玦玪玫玭玵玷玹玼玽玿珅珆珉珋珌珏珒珓珖珙珝珡珣珦珧珩珴珵珷珹珺珻珽"],["8fcca1","珿琀琁琄琇琊琑琚琛琤琦琨",9,"琹瑀瑃瑄瑆瑇瑋瑍瑑瑒瑗瑝瑢瑦瑧瑨瑫瑭瑮瑱瑲璀璁璅璆璇璉璏璐璑璒璘璙璚璜璟璠璡璣璦璨璩璪璫璮璯璱璲璵璹璻璿瓈瓉瓌瓐瓓瓘瓚瓛瓞瓟瓤瓨瓪瓫瓯瓴瓺瓻瓼瓿甆"],["8fcda1","甒甖甗甠甡甤甧甩甪甯甶甹甽甾甿畀畃畇畈畎畐畒畗畞畟畡畯畱畹",5,"疁疅疐疒疓疕疙疜疢疤疴疺疿痀痁痄痆痌痎痏痗痜痟痠痡痤痧痬痮痯痱痹瘀瘂瘃瘄瘇瘈瘊瘌瘏瘒瘓瘕瘖瘙瘛瘜瘝瘞瘣瘥瘦瘩瘭瘲瘳瘵瘸瘹"],["8fcea1","瘺瘼癊癀癁癃癄癅癉癋癕癙癟癤癥癭癮癯癱癴皁皅皌皍皕皛皜皝皟皠皢",6,"皪皭皽盁盅盉盋盌盎盔盙盠盦盨盬盰盱盶盹盼眀眆眊眎眒眔眕眗眙眚眜眢眨眭眮眯眴眵眶眹眽眾睂睅睆睊睍睎睏睒睖睗睜睞睟睠睢"],["8fcfa1","睤睧睪睬睰睲睳睴睺睽瞀瞄瞌瞍瞔瞕瞖瞚瞟瞢瞧瞪瞮瞯瞱瞵瞾矃矉矑矒矕矙矞矟矠矤矦矪矬矰矱矴矸矻砅砆砉砍砎砑砝砡砢砣砭砮砰砵砷硃硄硇硈硌硎硒硜硞硠硡硣硤硨硪确硺硾碊碏碔碘碡碝碞碟碤碨碬碭碰碱碲碳"],["8fd0a1","碻碽碿磇磈磉磌磎磒磓磕磖磤磛磟磠磡磦磪磲磳礀磶磷磺磻磿礆礌礐礚礜礞礟礠礥礧礩礭礱礴礵礻礽礿祄祅祆祊祋祏祑祔祘祛祜祧祩祫祲祹祻祼祾禋禌禑禓禔禕禖禘禛禜禡禨禩禫禯禱禴禸离秂秄秇秈秊秏秔秖秚秝秞"],["8fd1a1","秠秢秥秪秫秭秱秸秼稂稃稇稉稊稌稑稕稛稞稡稧稫稭稯稰稴稵稸稹稺穄穅穇穈穌穕穖穙穜穝穟穠穥穧穪穭穵穸穾窀窂窅窆窊窋窐窑窔窞窠窣窬窳窵窹窻窼竆竉竌竎竑竛竨竩竫竬竱竴竻竽竾笇笔笟笣笧笩笪笫笭笮笯笰"],["8fd2a1","笱笴笽笿筀筁筇筎筕筠筤筦筩筪筭筯筲筳筷箄箉箎箐箑箖箛箞箠箥箬箯箰箲箵箶箺箻箼箽篂篅篈篊篔篖篗篙篚篛篨篪篲篴篵篸篹篺篼篾簁簂簃簄簆簉簋簌簎簏簙簛簠簥簦簨簬簱簳簴簶簹簺籆籊籕籑籒籓籙",5],["8fd3a1","籡籣籧籩籭籮籰籲籹籼籽粆粇粏粔粞粠粦粰粶粷粺粻粼粿糄糇糈糉糍糏糓糔糕糗糙糚糝糦糩糫糵紃紇紈紉紏紑紒紓紖紝紞紣紦紪紭紱紼紽紾絀絁絇絈絍絑絓絗絙絚絜絝絥絧絪絰絸絺絻絿綁綂綃綅綆綈綋綌綍綑綖綗綝"],["8fd4a1","綞綦綧綪綳綶綷綹緂",4,"緌緍緎緗緙縀緢緥緦緪緫緭緱緵緶緹緺縈縐縑縕縗縜縝縠縧縨縬縭縯縳縶縿繄繅繇繎繐繒繘繟繡繢繥繫繮繯繳繸繾纁纆纇纊纍纑纕纘纚纝纞缼缻缽缾缿罃罄罇罏罒罓罛罜罝罡罣罤罥罦罭"],["8fd5a1","罱罽罾罿羀羋羍羏羐羑羖羗羜羡羢羦羪羭羴羼羿翀翃翈翎翏翛翟翣翥翨翬翮翯翲翺翽翾翿耇耈耊耍耎耏耑耓耔耖耝耞耟耠耤耦耬耮耰耴耵耷耹耺耼耾聀聄聠聤聦聭聱聵肁肈肎肜肞肦肧肫肸肹胈胍胏胒胔胕胗胘胠胭胮"],["8fd6a1","胰胲胳胶胹胺胾脃脋脖脗脘脜脞脠脤脧脬脰脵脺脼腅腇腊腌腒腗腠腡腧腨腩腭腯腷膁膐膄膅膆膋膎膖膘膛膞膢膮膲膴膻臋臃臅臊臎臏臕臗臛臝臞臡臤臫臬臰臱臲臵臶臸臹臽臿舀舃舏舓舔舙舚舝舡舢舨舲舴舺艃艄艅艆"],["8fd7a1","艋艎艏艑艖艜艠艣艧艭艴艻艽艿芀芁芃芄芇芉芊芎芑芔芖芘芚芛芠芡芣芤芧芨芩芪芮芰芲芴芷芺芼芾芿苆苐苕苚苠苢苤苨苪苭苯苶苷苽苾茀茁茇茈茊茋荔茛茝茞茟茡茢茬茭茮茰茳茷茺茼茽荂荃荄荇荍荎荑荕荖荗荰荸"],["8fd8a1","荽荿莀莂莄莆莍莒莔莕莘莙莛莜莝莦莧莩莬莾莿菀菇菉菏菐菑菔菝荓菨菪菶菸菹菼萁萆萊萏萑萕萙莭萯萹葅葇葈葊葍葏葑葒葖葘葙葚葜葠葤葥葧葪葰葳葴葶葸葼葽蒁蒅蒒蒓蒕蒞蒦蒨蒩蒪蒯蒱蒴蒺蒽蒾蓀蓂蓇蓈蓌蓏蓓"],["8fd9a1","蓜蓧蓪蓯蓰蓱蓲蓷蔲蓺蓻蓽蔂蔃蔇蔌蔎蔐蔜蔞蔢蔣蔤蔥蔧蔪蔫蔯蔳蔴蔶蔿蕆蕏",4,"蕖蕙蕜",6,"蕤蕫蕯蕹蕺蕻蕽蕿薁薅薆薉薋薌薏薓薘薝薟薠薢薥薧薴薶薷薸薼薽薾薿藂藇藊藋藎薭藘藚藟藠藦藨藭藳藶藼"],["8fdaa1","藿蘀蘄蘅蘍蘎蘐蘑蘒蘘蘙蘛蘞蘡蘧蘩蘶蘸蘺蘼蘽虀虂虆虒虓虖虗虘虙虝虠",4,"虩虬虯虵虶虷虺蚍蚑蚖蚘蚚蚜蚡蚦蚧蚨蚭蚱蚳蚴蚵蚷蚸蚹蚿蛀蛁蛃蛅蛑蛒蛕蛗蛚蛜蛠蛣蛥蛧蚈蛺蛼蛽蜄蜅蜇蜋蜎蜏蜐蜓蜔蜙蜞蜟蜡蜣"],["8fdba1","蜨蜮蜯蜱蜲蜹蜺蜼蜽蜾蝀蝃蝅蝍蝘蝝蝡蝤蝥蝯蝱蝲蝻螃",6,"螋螌螐螓螕螗螘螙螞螠螣螧螬螭螮螱螵螾螿蟁蟈蟉蟊蟎蟕蟖蟙蟚蟜蟟蟢蟣蟤蟪蟫蟭蟱蟳蟸蟺蟿蠁蠃蠆蠉蠊蠋蠐蠙蠒蠓蠔蠘蠚蠛蠜蠞蠟蠨蠭蠮蠰蠲蠵"],["8fdca1","蠺蠼衁衃衅衈衉衊衋衎衑衕衖衘衚衜衟衠衤衩衱衹衻袀袘袚袛袜袟袠袨袪袺袽袾裀裊",4,"裑裒裓裛裞裧裯裰裱裵裷褁褆褍褎褏褕褖褘褙褚褜褠褦褧褨褰褱褲褵褹褺褾襀襂襅襆襉襏襒襗襚襛襜襡襢襣襫襮襰襳襵襺"],["8fdda1","襻襼襽覉覍覐覔覕覛覜覟覠覥覰覴覵覶覷覼觔",4,"觥觩觫觭觱觳觶觹觽觿訄訅訇訏訑訒訔訕訞訠訢訤訦訫訬訯訵訷訽訾詀詃詅詇詉詍詎詓詖詗詘詜詝詡詥詧詵詶詷詹詺詻詾詿誀誃誆誋誏誐誒誖誗誙誟誧誩誮誯誳"],["8fdea1","誶誷誻誾諃諆諈諉諊諑諓諔諕諗諝諟諬諰諴諵諶諼諿謅謆謋謑謜謞謟謊謭謰謷謼譂",4,"譈譒譓譔譙譍譞譣譭譶譸譹譼譾讁讄讅讋讍讏讔讕讜讞讟谸谹谽谾豅豇豉豋豏豑豓豔豗豘豛豝豙豣豤豦豨豩豭豳豵豶豻豾貆"],["8fdfa1","貇貋貐貒貓貙貛貜貤貹貺賅賆賉賋賏賖賕賙賝賡賨賬賯賰賲賵賷賸賾賿贁贃贉贒贗贛赥赩赬赮赿趂趄趈趍趐趑趕趞趟趠趦趫趬趯趲趵趷趹趻跀跅跆跇跈跊跎跑跔跕跗跙跤跥跧跬跰趼跱跲跴跽踁踄踅踆踋踑踔踖踠踡踢"],["8fe0a1","踣踦踧踱踳踶踷踸踹踽蹀蹁蹋蹍蹎蹏蹔蹛蹜蹝蹞蹡蹢蹩蹬蹭蹯蹰蹱蹹蹺蹻躂躃躉躐躒躕躚躛躝躞躢躧躩躭躮躳躵躺躻軀軁軃軄軇軏軑軔軜軨軮軰軱軷軹軺軭輀輂輇輈輏輐輖輗輘輞輠輡輣輥輧輨輬輭輮輴輵輶輷輺轀轁"],["8fe1a1","轃轇轏轑",4,"轘轝轞轥辝辠辡辤辥辦辵辶辸达迀迁迆迊迋迍运迒迓迕迠迣迤迨迮迱迵迶迻迾适逄逈逌逘逛逨逩逯逪逬逭逳逴逷逿遃遄遌遛遝遢遦遧遬遰遴遹邅邈邋邌邎邐邕邗邘邙邛邠邡邢邥邰邲邳邴邶邽郌邾郃"],["8fe2a1","郄郅郇郈郕郗郘郙郜郝郟郥郒郶郫郯郰郴郾郿鄀鄄鄅鄆鄈鄍鄐鄔鄖鄗鄘鄚鄜鄞鄠鄥鄢鄣鄧鄩鄮鄯鄱鄴鄶鄷鄹鄺鄼鄽酃酇酈酏酓酗酙酚酛酡酤酧酭酴酹酺酻醁醃醅醆醊醎醑醓醔醕醘醞醡醦醨醬醭醮醰醱醲醳醶醻醼醽醿"],["8fe3a1","釂釃釅釓釔釗釙釚釞釤釥釩釪釬",5,"釷釹釻釽鈀鈁鈄鈅鈆鈇鈉鈊鈌鈐鈒鈓鈖鈘鈜鈝鈣鈤鈥鈦鈨鈮鈯鈰鈳鈵鈶鈸鈹鈺鈼鈾鉀鉂鉃鉆鉇鉊鉍鉎鉏鉑鉘鉙鉜鉝鉠鉡鉥鉧鉨鉩鉮鉯鉰鉵",4,"鉻鉼鉽鉿銈銉銊銍銎銒銗"],["8fe4a1","銙銟銠銤銥銧銨銫銯銲銶銸銺銻銼銽銿",4,"鋅鋆鋇鋈鋋鋌鋍鋎鋐鋓鋕鋗鋘鋙鋜鋝鋟鋠鋡鋣鋥鋧鋨鋬鋮鋰鋹鋻鋿錀錂錈錍錑錔錕錜錝錞錟錡錤錥錧錩錪錳錴錶錷鍇鍈鍉鍐鍑鍒鍕鍗鍘鍚鍞鍤鍥鍧鍩鍪鍭鍯鍰鍱鍳鍴鍶"],["8fe5a1","鍺鍽鍿鎀鎁鎂鎈鎊鎋鎍鎏鎒鎕鎘鎛鎞鎡鎣鎤鎦鎨鎫鎴鎵鎶鎺鎩鏁鏄鏅鏆鏇鏉",4,"鏓鏙鏜鏞鏟鏢鏦鏧鏹鏷鏸鏺鏻鏽鐁鐂鐄鐈鐉鐍鐎鐏鐕鐖鐗鐟鐮鐯鐱鐲鐳鐴鐻鐿鐽鑃鑅鑈鑊鑌鑕鑙鑜鑟鑡鑣鑨鑫鑭鑮鑯鑱鑲钄钃镸镹"],["8fe6a1","镾閄閈閌閍閎閝閞閟閡閦閩閫閬閴閶閺閽閿闆闈闉闋闐闑闒闓闙闚闝闞闟闠闤闦阝阞阢阤阥阦阬阱阳阷阸阹阺阼阽陁陒陔陖陗陘陡陮陴陻陼陾陿隁隂隃隄隉隑隖隚隝隟隤隥隦隩隮隯隳隺雊雒嶲雘雚雝雞雟雩雯雱雺霂"],["8fe7a1","霃霅霉霚霛霝霡霢霣霨霱霳靁靃靊靎靏靕靗靘靚靛靣靧靪靮靳靶靷靸靻靽靿鞀鞉鞕鞖鞗鞙鞚鞞鞟鞢鞬鞮鞱鞲鞵鞶鞸鞹鞺鞼鞾鞿韁韄韅韇韉韊韌韍韎韐韑韔韗韘韙韝韞韠韛韡韤韯韱韴韷韸韺頇頊頙頍頎頔頖頜頞頠頣頦"],["8fe8a1","頫頮頯頰頲頳頵頥頾顄顇顊顑顒顓顖顗顙顚顢顣顥顦顪顬颫颭颮颰颴颷颸颺颻颿飂飅飈飌飡飣飥飦飧飪飳飶餂餇餈餑餕餖餗餚餛餜餟餢餦餧餫餱",4,"餹餺餻餼饀饁饆饇饈饍饎饔饘饙饛饜饞饟饠馛馝馟馦馰馱馲馵"],["8fe9a1","馹馺馽馿駃駉駓駔駙駚駜駞駧駪駫駬駰駴駵駹駽駾騂騃騄騋騌騐騑騖騞騠騢騣騤騧騭騮騳騵騶騸驇驁驄驊驋驌驎驑驔驖驝骪骬骮骯骲骴骵骶骹骻骾骿髁髃髆髈髎髐髒髕髖髗髛髜髠髤髥髧髩髬髲髳髵髹髺髽髿",4],["8feaa1","鬄鬅鬈鬉鬋鬌鬍鬎鬐鬒鬖鬙鬛鬜鬠鬦鬫鬭鬳鬴鬵鬷鬹鬺鬽魈魋魌魕魖魗魛魞魡魣魥魦魨魪",4,"魳魵魷魸魹魿鮀鮄鮅鮆鮇鮉鮊鮋鮍鮏鮐鮔鮚鮝鮞鮦鮧鮩鮬鮰鮱鮲鮷鮸鮻鮼鮾鮿鯁鯇鯈鯎鯐鯗鯘鯝鯟鯥鯧鯪鯫鯯鯳鯷鯸"],["8feba1","鯹鯺鯽鯿鰀鰂鰋鰏鰑鰖鰘鰙鰚鰜鰞鰢鰣鰦",4,"鰱鰵鰶鰷鰽鱁鱃鱄鱅鱉鱊鱎鱏鱐鱓鱔鱖鱘鱛鱝鱞鱟鱣鱩鱪鱜鱫鱨鱮鱰鱲鱵鱷鱻鳦鳲鳷鳹鴋鴂鴑鴗鴘鴜鴝鴞鴯鴰鴲鴳鴴鴺鴼鵅鴽鵂鵃鵇鵊鵓鵔鵟鵣鵢鵥鵩鵪鵫鵰鵶鵷鵻"],["8feca1","鵼鵾鶃鶄鶆鶊鶍鶎鶒鶓鶕鶖鶗鶘鶡鶪鶬鶮鶱鶵鶹鶼鶿鷃鷇鷉鷊鷔鷕鷖鷗鷚鷞鷟鷠鷥鷧鷩鷫鷮鷰鷳鷴鷾鸊鸂鸇鸎鸐鸑鸒鸕鸖鸙鸜鸝鹺鹻鹼麀麂麃麄麅麇麎麏麖麘麛麞麤麨麬麮麯麰麳麴麵黆黈黋黕黟黤黧黬黭黮黰黱黲黵"],["8feda1","黸黿鼂鼃鼉鼏鼐鼑鼒鼔鼖鼗鼙鼚鼛鼟鼢鼦鼪鼫鼯鼱鼲鼴鼷鼹鼺鼼鼽鼿齁齃",4,"齓齕齖齗齘齚齝齞齨齩齭",4,"齳齵齺齽龏龐龑龒龔龖龗龞龡龢龣龥"]]');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/gb18030-ranges.json":
/*!**********************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/gb18030-ranges.json ***!
  \**********************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"uChars":[128,165,169,178,184,216,226,235,238,244,248,251,253,258,276,284,300,325,329,334,364,463,465,467,469,471,473,475,477,506,594,610,712,716,730,930,938,962,970,1026,1104,1106,8209,8215,8218,8222,8231,8241,8244,8246,8252,8365,8452,8454,8458,8471,8482,8556,8570,8596,8602,8713,8720,8722,8726,8731,8737,8740,8742,8748,8751,8760,8766,8777,8781,8787,8802,8808,8816,8854,8858,8870,8896,8979,9322,9372,9548,9588,9616,9622,9634,9652,9662,9672,9676,9680,9702,9735,9738,9793,9795,11906,11909,11913,11917,11928,11944,11947,11951,11956,11960,11964,11979,12284,12292,12312,12319,12330,12351,12436,12447,12535,12543,12586,12842,12850,12964,13200,13215,13218,13253,13263,13267,13270,13384,13428,13727,13839,13851,14617,14703,14801,14816,14964,15183,15471,15585,16471,16736,17208,17325,17330,17374,17623,17997,18018,18212,18218,18301,18318,18760,18811,18814,18820,18823,18844,18848,18872,19576,19620,19738,19887,40870,59244,59336,59367,59413,59417,59423,59431,59437,59443,59452,59460,59478,59493,63789,63866,63894,63976,63986,64016,64018,64021,64025,64034,64037,64042,65074,65093,65107,65112,65127,65132,65375,65510,65536],"gbChars":[0,36,38,45,50,81,89,95,96,100,103,104,105,109,126,133,148,172,175,179,208,306,307,308,309,310,311,312,313,341,428,443,544,545,558,741,742,749,750,805,819,820,7922,7924,7925,7927,7934,7943,7944,7945,7950,8062,8148,8149,8152,8164,8174,8236,8240,8262,8264,8374,8380,8381,8384,8388,8390,8392,8393,8394,8396,8401,8406,8416,8419,8424,8437,8439,8445,8482,8485,8496,8521,8603,8936,8946,9046,9050,9063,9066,9076,9092,9100,9108,9111,9113,9131,9162,9164,9218,9219,11329,11331,11334,11336,11346,11361,11363,11366,11370,11372,11375,11389,11682,11686,11687,11692,11694,11714,11716,11723,11725,11730,11736,11982,11989,12102,12336,12348,12350,12384,12393,12395,12397,12510,12553,12851,12962,12973,13738,13823,13919,13933,14080,14298,14585,14698,15583,15847,16318,16434,16438,16481,16729,17102,17122,17315,17320,17402,17418,17859,17909,17911,17915,17916,17936,17939,17961,18664,18703,18814,18962,19043,33469,33470,33471,33484,33485,33490,33497,33501,33505,33513,33520,33536,33550,37845,37921,37948,38029,38038,38064,38065,38066,38069,38075,38076,38078,39108,39109,39113,39114,39115,39116,39265,39394,189000]}');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/gbk-added.json":
/*!*****************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/gbk-added.json ***!
  \*****************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["a140","",62],["a180","",32],["a240","",62],["a280","",32],["a2ab","",5],["a2e3","€"],["a2ef",""],["a2fd",""],["a340","",62],["a380","",31,"　"],["a440","",62],["a480","",32],["a4f4","",10],["a540","",62],["a580","",32],["a5f7","",7],["a640","",62],["a680","",32],["a6b9","",7],["a6d9","",6],["a6ec",""],["a6f3",""],["a6f6","",8],["a740","",62],["a780","",32],["a7c2","",14],["a7f2","",12],["a896","",10],["a8bc","ḿ"],["a8bf","ǹ"],["a8c1",""],["a8ea","",20],["a958",""],["a95b",""],["a95d",""],["a989","〾⿰",11],["a997","",12],["a9f0","",14],["aaa1","",93],["aba1","",93],["aca1","",93],["ada1","",93],["aea1","",93],["afa1","",93],["d7fa","",4],["f8a1","",93],["f9a1","",93],["faa1","",93],["fba1","",93],["fca1","",93],["fda1","",93],["fe50","⺁⺄㑳㑇⺈⺋㖞㘚㘎⺌⺗㥮㤘㧏㧟㩳㧐㭎㱮㳠⺧⺪䁖䅟⺮䌷⺳⺶⺷䎱䎬⺻䏝䓖䙡䙌"],["fe80","䜣䜩䝼䞍⻊䥇䥺䥽䦂䦃䦅䦆䦟䦛䦷䦶䲣䲟䲠䲡䱷䲢䴓",6,"䶮",93],["8135f437",""]]');

/***/ }),

/***/ "(action-browser)/./node_modules/iconv-lite/encodings/tables/shiftjis.json":
/*!****************************************************************!*\
  !*** ./node_modules/iconv-lite/encodings/tables/shiftjis.json ***!
  \****************************************************************/
/***/ ((module) => {

module.exports = JSON.parse('[["0","\\u0000",128],["a1","｡",62],["8140","　、。，．・：；？！゛゜´｀¨＾￣＿ヽヾゝゞ〃仝々〆〇ー―‐／＼～∥｜…‥‘’“”（）〔〕［］｛｝〈",9,"＋－±×"],["8180","÷＝≠＜＞≦≧∞∴♂♀°′″℃￥＄￠￡％＃＆＊＠§☆★○●◎◇◆□■△▲▽▼※〒→←↑↓〓"],["81b8","∈∋⊆⊇⊂⊃∪∩"],["81c8","∧∨￢⇒⇔∀∃"],["81da","∠⊥⌒∂∇≡≒≪≫√∽∝∵∫∬"],["81f0","Å‰♯♭♪†‡¶"],["81fc","◯"],["824f","０",9],["8260","Ａ",25],["8281","ａ",25],["829f","ぁ",82],["8340","ァ",62],["8380","ム",22],["839f","Α",16,"Σ",6],["83bf","α",16,"σ",6],["8440","А",5,"ЁЖ",25],["8470","а",5,"ёж",7],["8480","о",17],["849f","─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂"],["8740","①",19,"Ⅰ",9],["875f","㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㎡"],["877e","㍻"],["8780","〝〟№㏍℡㊤",4,"㈱㈲㈹㍾㍽㍼≒≡∫∮∑√⊥∠∟⊿∵∩∪"],["889f","亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭"],["8940","院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円"],["8980","園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改"],["8a40","魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫"],["8a80","橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄"],["8b40","機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救"],["8b80","朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈"],["8c40","掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨"],["8c80","劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向"],["8d40","后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降"],["8d80","項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷"],["8e40","察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止"],["8e80","死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周"],["8f40","宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳"],["8f80","準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾"],["9040","拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨"],["9080","逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線"],["9140","繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻"],["9180","操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只"],["9240","叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄"],["9280","逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓"],["9340","邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬"],["9380","凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入"],["9440","如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅"],["9480","楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美"],["9540","鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷"],["9580","斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋"],["9640","法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆"],["9680","摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉愈油癒"],["9740","諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲"],["9780","沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯"],["9840","蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕"],["989f","弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲"],["9940","僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭"],["9980","凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨"],["9a40","咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸"],["9a80","噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩"],["9b40","奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀"],["9b80","它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏"],["9c40","廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠"],["9c80","怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛"],["9d40","戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫"],["9d80","捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼"],["9e40","曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎"],["9e80","梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘椢椦棡椌棍棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣"],["9f40","檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯"],["9f80","麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌"],["e040","漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝"],["e080","烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱"],["e140","瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿"],["e180","痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬"],["e240","磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰"],["e280","窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆"],["e340","紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷"],["e380","縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋"],["e440","隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤"],["e480","艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈"],["e540","蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬"],["e580","蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞"],["e640","襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧"],["e680","諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊"],["e740","蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜"],["e780","轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮"],["e840","錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙"],["e880","閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰"],["e940","顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃"],["e980","騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈"],["ea40","鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯"],["ea80","黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠堯槇遙瑤凜熙"],["ed40","纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏"],["ed80","塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱"],["ee40","犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙"],["ee80","蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑"],["eeef","ⅰ",9,"￢￤＇＂"],["f040","",62],["f080","",124],["f140","",62],["f180","",124],["f240","",62],["f280","",124],["f340","",62],["f380","",124],["f440","",62],["f480","",124],["f540","",62],["f580","",124],["f640","",62],["f680","",124],["f740","",62],["f780","",124],["f840","",62],["f880","",124],["f940",""],["fa40","ⅰ",9,"Ⅰ",9,"￢￤＇＂㈱№℡∵纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊"],["fa80","兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯"],["fb40","涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神"],["fb80","祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙"],["fc40","髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑"]]');

/***/ })

};
;