import {Inter} from 'next/font/google'
import './globals.css'
import {Toaster} from "react-hot-toast";
import Nav from './Navigtion/nav'
const inter = Inter({subsets: ['latin']})

export const metadata = {
    title: 'My-Drive',
    description: 'Generated by create next app'
}

export default function RootLayout({children}) {
    return (
        <html lang="en">
            <head>
                 <link rel="icon" href="/image/driveIcon.png" />
                <link
                    href="https://fonts.googleapis.com/icon?family=Material+Icons"
                    rel="stylesheet"></link>
                <link
                    rel="stylesheet"
                    href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
                    
            </head>
            <body className={inter.className}>
                <Nav/>
                <Toaster
                    toastOptions={{
                    className: '',
                    style: {
                        border: '1px solid #713200',
                        color: '#713200',
                        position: "top-right ",
                        fontSize:'15px',
                        fontWeight:'bolder'
                    }
                }}/> {children}
              
                </body>
        </html>
    )
}
